/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.provider.Telephony;
import android.service.carrier.CarrierIdentifier;
import android.telephony.PhoneStateListener;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.LocalLog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CarrierResolver
extends Handler {
    private static final String LOG_TAG = CarrierResolver.class.getSimpleName();
    private static final boolean DBG = true;
    private static final boolean VDBG = Rlog.isLoggable(LOG_TAG, 2);
    private static final int SIM_LOAD_EVENT = 1;
    private static final int ICC_CHANGED_EVENT = 2;
    private static final int PREFER_APN_UPDATE_EVENT = 3;
    private static final int CARRIER_ID_DB_UPDATE_EVENT = 4;
    private static final Uri CONTENT_URL_PREFER_APN = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "preferapn");
    private List<CarrierMatchingRule> mCarrierMatchingRulesOnMccMnc = new ArrayList<CarrierMatchingRule>();
    private int mCarrierId = -1;
    private int mSpecificCarrierId = -1;
    private int mMnoCarrierId = -1;
    private String mCarrierName;
    private String mSpecificCarrierName;
    private String mPreferApn;
    private String mTestOverrideApn;
    private String mTestOverrideCarrierPriviledgeRule;
    private String mSpn = "";
    private Context mContext;
    private Phone mPhone;
    private IccRecords mIccRecords;
    private final LocalLog mCarrierIdLocalLog = new LocalLog(20);
    private final TelephonyManager mTelephonyMgr;
    private final ContentObserver mContentObserver = new ContentObserver(this){

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (CONTENT_URL_PREFER_APN.equals(uri.getLastPathSegment())) {
                CarrierResolver.logd("onChange URI: " + uri);
                CarrierResolver.this.sendEmptyMessage(3);
            } else if (Telephony.CarrierId.All.CONTENT_URI.equals(uri)) {
                CarrierResolver.logd("onChange URI: " + uri);
                CarrierResolver.this.sendEmptyMessage(4);
            }
        }
    };
    private final PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        @Override
        public void onCallStateChanged(int state, String ignored) {
        }
    };

    public CarrierResolver(Phone phone) {
        CarrierResolver.logd("Creating CarrierResolver[" + phone.getPhoneId() + "]");
        this.mContext = phone.getContext();
        this.mPhone = phone;
        this.mTelephonyMgr = TelephonyManager.from(this.mContext);
        this.mContext.getContentResolver().registerContentObserver(CONTENT_URL_PREFER_APN, false, this.mContentObserver);
        this.mContext.getContentResolver().registerContentObserver(Telephony.CarrierId.All.CONTENT_URI, false, this.mContentObserver);
        UiccController.getInstance().registerForIccChanged(this, 2, null);
    }

    public void resolveSubscriptionCarrierId(String simState) {
        CarrierResolver.logd("[resolveSubscriptionCarrierId] simState: " + simState);
        switch (simState) {
            case "ABSENT": 
            case "CARD_IO_ERROR": {
                this.handleSimAbsent();
                break;
            }
            case "LOADED": {
                this.handleSimLoaded();
            }
        }
    }

    private void handleSimLoaded() {
        if (this.mIccRecords != null) {
            this.mSpn = this.mIccRecords.getServiceProviderName() == null ? "" : this.mIccRecords.getServiceProviderName();
        } else {
            CarrierResolver.loge("mIccRecords is null on SIM_LOAD_EVENT, could not get SPN");
        }
        this.mPreferApn = this.getPreferApn();
        this.loadCarrierMatchingRulesOnMccMnc();
    }

    private void handleSimAbsent() {
        this.mCarrierMatchingRulesOnMccMnc.clear();
        this.mSpn = null;
        this.mPreferApn = null;
        this.updateCarrierIdAndName(-1, null, -1, null, -1);
    }

    @Override
    public void handleMessage(Message msg) {
        CarrierResolver.logd("handleMessage: " + msg.what);
        switch (msg.what) {
            case 1: {
                this.handleSimLoaded();
                break;
            }
            case 4: {
                this.loadCarrierMatchingRulesOnMccMnc();
                break;
            }
            case 3: {
                String preferApn = this.getPreferApn();
                if (CarrierResolver.equals(this.mPreferApn, preferApn, true)) break;
                CarrierResolver.logd("[updatePreferApn] from:" + this.mPreferApn + " to:" + preferApn);
                this.mPreferApn = preferApn;
                this.matchSubscriptionCarrier();
                break;
            }
            case 2: {
                IccRecords newIccRecords = UiccController.getInstance().getIccRecords(this.mPhone.getPhoneId(), 1);
                if (this.mIccRecords == newIccRecords) break;
                if (this.mIccRecords != null) {
                    CarrierResolver.logd("Removing stale icc objects.");
                    this.mIccRecords.unregisterForRecordsOverride(this);
                    this.mIccRecords = null;
                }
                if (newIccRecords == null) break;
                CarrierResolver.logd("new Icc object");
                newIccRecords.registerForRecordsOverride(this, 1, null);
                this.mIccRecords = newIccRecords;
                break;
            }
            default: {
                CarrierResolver.loge("invalid msg: " + msg.what);
            }
        }
    }

    private void loadCarrierMatchingRulesOnMccMnc() {
        try {
            String mccmnc = this.mTelephonyMgr.getSimOperatorNumericForPhone(this.mPhone.getPhoneId());
            try (Cursor cursor = this.mContext.getContentResolver().query(Telephony.CarrierId.All.CONTENT_URI, null, "mccmnc=?", new String[]{mccmnc}, null);){
                if (cursor != null) {
                    if (VDBG) {
                        CarrierResolver.logd("[loadCarrierMatchingRules]- " + cursor.getCount() + " Records(s) in DB mccmnc: " + mccmnc);
                    }
                    this.mCarrierMatchingRulesOnMccMnc.clear();
                    while (cursor.moveToNext()) {
                        this.mCarrierMatchingRulesOnMccMnc.add(CarrierResolver.makeCarrierMatchingRule(cursor));
                    }
                    this.matchSubscriptionCarrier();
                }
            }
        }
        catch (Exception ex) {
            CarrierResolver.loge("[loadCarrierMatchingRules]- ex: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCarrierNameFromId(int cid) {
        try (Cursor cursor = this.mContext.getContentResolver().query(Telephony.CarrierId.All.CONTENT_URI, null, "carrier_id=?", new String[]{cid + ""}, null);){
            if (cursor == null) return null;
            if (VDBG) {
                CarrierResolver.logd("[getCarrierNameFromId]- " + cursor.getCount() + " Records(s) in DB cid: " + cid);
            }
            if (!cursor.moveToNext()) return null;
            String string2 = cursor.getString(cursor.getColumnIndex("carrier_name"));
            return string2;
        }
        catch (Exception ex) {
            CarrierResolver.loge("[getCarrierNameFromId]- ex: " + ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CarrierMatchingRule> getCarrierMatchingRulesFromMccMnc(Context context, String mccmnc) {
        ArrayList<CarrierMatchingRule> rules = new ArrayList<CarrierMatchingRule>();
        try (Cursor cursor = context.getContentResolver().query(Telephony.CarrierId.All.CONTENT_URI, null, "mccmnc=?", new String[]{mccmnc}, null);){
            if (cursor != null) {
                if (VDBG) {
                    CarrierResolver.logd("[loadCarrierMatchingRules]- " + cursor.getCount() + " Records(s) in DB mccmnc: " + mccmnc);
                }
                rules.clear();
                while (cursor.moveToNext()) {
                    rules.add(CarrierResolver.makeCarrierMatchingRule(cursor));
                }
            }
        }
        catch (Exception ex) {
            CarrierResolver.loge("[loadCarrierMatchingRules]- ex: " + ex);
        }
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPreferApn() {
        if (!TextUtils.isEmpty(this.mTestOverrideApn)) {
            CarrierResolver.logd("[getPreferApn]- " + this.mTestOverrideApn + " test override");
            return this.mTestOverrideApn;
        }
        try (Cursor cursor = this.mContext.getContentResolver().query(Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "preferapn/subId/" + this.mPhone.getSubId()), new String[]{"apn"}, null, null, null);){
            if (cursor != null) {
                if (VDBG) {
                    CarrierResolver.logd("[getPreferApn]- " + cursor.getCount() + " Records(s) in DB");
                }
                if (cursor.moveToNext()) {
                    String apn = cursor.getString(cursor.getColumnIndexOrThrow("apn"));
                    CarrierResolver.logd("[getPreferApn]- " + apn);
                    String string2 = apn;
                    return string2;
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPreferApnUserEdited(String preferApn) {
        try (Cursor cursor = this.mContext.getContentResolver().query(Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "preferapn/subId/" + this.mPhone.getSubId()), new String[]{"edited"}, "apn=?", new String[]{preferApn}, null);){
            if (cursor == null) return false;
            if (!cursor.moveToFirst()) return false;
            boolean bl = cursor.getInt(cursor.getColumnIndexOrThrow("edited")) == 1;
            return bl;
        }
        catch (Exception ex) {
            CarrierResolver.loge("[isPreferApnUserEdited]- exception: " + ex);
        }
        return false;
    }

    public void setTestOverrideApn(String apn) {
        CarrierResolver.logd("[setTestOverrideApn]: " + apn);
        this.mTestOverrideApn = apn;
    }

    public void setTestOverrideCarrierPriviledgeRule(String rule) {
        CarrierResolver.logd("[setTestOverrideCarrierPriviledgeRule]: " + rule);
        this.mTestOverrideCarrierPriviledgeRule = rule;
    }

    private void updateCarrierIdAndName(int cid, String name, int specificCarrierId, String specificCarrierName, int mnoCid) {
        ContentValues cv;
        Intent intent;
        boolean update = false;
        if (specificCarrierId != this.mSpecificCarrierId) {
            CarrierResolver.logd("[updateSpecificCarrierId] from:" + this.mSpecificCarrierId + " to:" + specificCarrierId);
            this.mSpecificCarrierId = specificCarrierId;
            update = true;
        }
        if (specificCarrierName != this.mSpecificCarrierName) {
            CarrierResolver.logd("[updateSpecificCarrierName] from:" + this.mSpecificCarrierName + " to:" + specificCarrierName);
            this.mSpecificCarrierName = specificCarrierName;
            update = true;
        }
        if (update) {
            this.mCarrierIdLocalLog.log("[updateSpecificCarrierIdAndName] cid:" + this.mSpecificCarrierId + " name:" + this.mSpecificCarrierName);
            intent = new Intent("android.telephony.action.SUBSCRIPTION_SPECIFIC_CARRIER_IDENTITY_CHANGED");
            intent.putExtra("android.telephony.extra.SPECIFIC_CARRIER_ID", this.mSpecificCarrierId);
            intent.putExtra("android.telephony.extra.SPECIFIC_CARRIER_NAME", this.mSpecificCarrierName);
            intent.putExtra("android.telephony.extra.SUBSCRIPTION_ID", this.mPhone.getSubId());
            this.mContext.sendBroadcast(intent);
            cv = new ContentValues();
            cv.put("specific_carrier_id", this.mSpecificCarrierId);
            cv.put("specific_carrier_id_name", this.mSpecificCarrierName);
            this.mContext.getContentResolver().update(Telephony.CarrierId.getSpecificCarrierIdUriForSubscriptionId(this.mPhone.getSubId()), cv, null, null);
        }
        update = false;
        if (!CarrierResolver.equals(name, this.mCarrierName, true)) {
            CarrierResolver.logd("[updateCarrierName] from:" + this.mCarrierName + " to:" + name);
            this.mCarrierName = name;
            update = true;
        }
        if (cid != this.mCarrierId) {
            CarrierResolver.logd("[updateCarrierId] from:" + this.mCarrierId + " to:" + cid);
            this.mCarrierId = cid;
            update = true;
        }
        if (mnoCid != this.mMnoCarrierId) {
            CarrierResolver.logd("[updateMnoCarrierId] from:" + this.mMnoCarrierId + " to:" + mnoCid);
            this.mMnoCarrierId = mnoCid;
            update = true;
        }
        if (update) {
            this.mCarrierIdLocalLog.log("[updateCarrierIdAndName] cid:" + this.mCarrierId + " name:" + this.mCarrierName + " mnoCid:" + this.mMnoCarrierId);
            intent = new Intent("android.telephony.action.SUBSCRIPTION_CARRIER_IDENTITY_CHANGED");
            intent.putExtra("android.telephony.extra.CARRIER_ID", this.mCarrierId);
            intent.putExtra("android.telephony.extra.CARRIER_NAME", this.mCarrierName);
            intent.putExtra("android.telephony.extra.SUBSCRIPTION_ID", this.mPhone.getSubId());
            this.mContext.sendBroadcast(intent);
            cv = new ContentValues();
            cv.put("carrier_id", this.mCarrierId);
            cv.put("carrier_name", this.mCarrierName);
            this.mContext.getContentResolver().update(Telephony.CarrierId.getUriForSubscriptionId(this.mPhone.getSubId()), cv, null, null);
        }
        if (SubscriptionManager.isValidSubscriptionId(this.mPhone.getSubId())) {
            SubscriptionController.getInstance().setCarrierId(this.mCarrierId, this.mPhone.getSubId());
        }
    }

    private static CarrierMatchingRule makeCarrierMatchingRule(Cursor cursor) {
        String certs = cursor.getString(cursor.getColumnIndexOrThrow("privilege_access_rule"));
        return new CarrierMatchingRule(cursor.getString(cursor.getColumnIndexOrThrow("mccmnc")), cursor.getString(cursor.getColumnIndexOrThrow("imsi_prefix_xpattern")), cursor.getString(cursor.getColumnIndexOrThrow("iccid_prefix")), cursor.getString(cursor.getColumnIndexOrThrow("gid1")), cursor.getString(cursor.getColumnIndexOrThrow("gid2")), cursor.getString(cursor.getColumnIndexOrThrow("plmn")), cursor.getString(cursor.getColumnIndexOrThrow("spn")), cursor.getString(cursor.getColumnIndexOrThrow("apn")), TextUtils.isEmpty(certs) ? null : new ArrayList<String>(Arrays.asList(certs)), cursor.getInt(cursor.getColumnIndexOrThrow("carrier_id")), cursor.getString(cursor.getColumnIndexOrThrow("carrier_name")), cursor.getInt(cursor.getColumnIndexOrThrow("parent_carrier_id")));
    }

    private CarrierMatchingRule getSubscriptionMatchingRule() {
        String mccmnc = this.mTelephonyMgr.getSimOperatorNumericForPhone(this.mPhone.getPhoneId());
        String iccid = this.mPhone.getIccSerialNumber();
        String gid1 = this.mPhone.getGroupIdLevel1();
        String gid2 = this.mPhone.getGroupIdLevel2();
        String imsi = this.mPhone.getSubscriberId();
        String plmn = this.mPhone.getPlmn();
        String spn = this.mSpn;
        String apn = this.mPreferApn;
        List<String> accessRules = !TextUtils.isEmpty(this.mTestOverrideCarrierPriviledgeRule) ? new ArrayList<String>(Arrays.asList(this.mTestOverrideCarrierPriviledgeRule)) : this.mTelephonyMgr.createForSubscriptionId(this.mPhone.getSubId()).getCertsFromCarrierPrivilegeAccessRules();
        if (VDBG) {
            CarrierResolver.logd("[matchSubscriptionCarrier] mnnmnc:" + mccmnc + " gid1: " + gid1 + " gid2: " + gid2 + " imsi: " + Rlog.pii(LOG_TAG, (Object)imsi) + " iccid: " + Rlog.pii(LOG_TAG, (Object)iccid) + " plmn: " + plmn + " spn: " + spn + " apn: " + apn + " accessRules: " + (accessRules != null ? accessRules : null));
        }
        return new CarrierMatchingRule(mccmnc, imsi, iccid, gid1, gid2, plmn, spn, apn, accessRules, -1, null, -1);
    }

    private void matchSubscriptionCarrier() {
        if (!SubscriptionManager.isValidSubscriptionId(this.mPhone.getSubId())) {
            CarrierResolver.logd("[matchSubscriptionCarrier]skip before sim records loaded");
            return;
        }
        int maxScore = -1;
        CarrierMatchingRule maxRule = null;
        CarrierMatchingRule maxRuleParent = null;
        CarrierMatchingRule mnoRule = null;
        CarrierMatchingRule subscriptionRule = this.getSubscriptionMatchingRule();
        for (CarrierMatchingRule rule : this.mCarrierMatchingRulesOnMccMnc) {
            rule.match(subscriptionRule);
            if (rule.mScore > maxScore) {
                maxScore = rule.mScore;
                maxRule = rule;
                maxRuleParent = rule;
            } else if (maxScore > -1 && rule.mScore == maxScore) {
                if (rule.mParentCid == maxRule.mCid) {
                    maxRule = rule;
                } else if (maxRule.mParentCid == rule.mCid) {
                    maxRuleParent = rule;
                }
            }
            if (rule.mScore != 256) continue;
            mnoRule = rule;
        }
        if (maxScore == -1) {
            CarrierResolver.logd("[matchSubscriptionCarrier - no match] cid: -1 name: " + null);
            this.updateCarrierIdAndName(-1, null, -1, null, -1);
        } else {
            if (maxRule == maxRuleParent && maxRule.mParentCid != -1) {
                maxRuleParent = new CarrierMatchingRule(maxRule);
                maxRuleParent.mCid = maxRuleParent.mParentCid;
                maxRuleParent.mName = this.getCarrierNameFromId(maxRuleParent.mCid);
            }
            CarrierResolver.logd("[matchSubscriptionCarrier] specific cid: " + maxRule.mCid + " specific name: " + maxRule.mName + " cid: " + maxRuleParent.mCid + " name: " + maxRuleParent.mName);
            this.updateCarrierIdAndName(maxRuleParent.mCid, maxRuleParent.mName, maxRule.mCid, maxRule.mName, mnoRule == null ? maxRule.mCid : mnoRule.mCid);
        }
        String unknownGid1ToLog = (maxScore & 0x20) == 0 && !TextUtils.isEmpty(subscriptionRule.gid1) ? subscriptionRule.gid1 : null;
        String unknownMccmncToLog = (maxScore == -1 || (maxScore & 0x20) == 0) && !TextUtils.isEmpty(subscriptionRule.mccMnc) ? subscriptionRule.mccMnc : null;
        String apn = subscriptionRule.apn != null && !this.isPreferApnUserEdited(subscriptionRule.apn) ? subscriptionRule.apn : null;
        String iccidPrefix = subscriptionRule.iccidPrefix != null && subscriptionRule.iccidPrefix.length() >= 7 ? subscriptionRule.iccidPrefix.substring(0, 7) : subscriptionRule.iccidPrefix;
        String imsiPrefix = subscriptionRule.imsiPrefixPattern != null && subscriptionRule.imsiPrefixPattern.length() >= 8 ? subscriptionRule.imsiPrefixPattern.substring(0, 8) : subscriptionRule.imsiPrefixPattern;
        CarrierMatchingRule simInfo = new CarrierMatchingRule(subscriptionRule.mccMnc, imsiPrefix, iccidPrefix, subscriptionRule.gid1, subscriptionRule.gid2, subscriptionRule.plmn, subscriptionRule.spn, apn, subscriptionRule.privilegeAccessRule, -1, null, -1);
        TelephonyMetrics.getInstance().writeCarrierIdMatchingEvent(this.mPhone.getPhoneId(), this.getCarrierListVersion(), this.mCarrierId, unknownMccmncToLog, unknownGid1ToLog, simInfo);
    }

    public int getCarrierListVersion() {
        Cursor cursor = this.mContext.getContentResolver().query(Uri.withAppendedPath(Telephony.CarrierId.All.CONTENT_URI, "get_version"), null, null, null);
        cursor.moveToFirst();
        return cursor.getInt(0);
    }

    public int getCarrierId() {
        return this.mCarrierId;
    }

    public int getSpecificCarrierId() {
        return this.mSpecificCarrierId;
    }

    public String getCarrierName() {
        return this.mCarrierName;
    }

    public String getSpecificCarrierName() {
        return this.mSpecificCarrierName;
    }

    public int getMnoCarrierId() {
        return this.mMnoCarrierId;
    }

    public static int getCarrierIdFromIdentifier(Context context, CarrierIdentifier carrierIdentifier) {
        String mccmnc = carrierIdentifier.getMcc() + carrierIdentifier.getMnc();
        String gid1 = carrierIdentifier.getGid1();
        String gid2 = carrierIdentifier.getGid2();
        String imsi = carrierIdentifier.getImsi();
        String spn = carrierIdentifier.getSpn();
        if (VDBG) {
            CarrierResolver.logd("[getCarrierIdFromIdentifier] mnnmnc:" + mccmnc + " gid1: " + gid1 + " gid2: " + gid2 + " imsi: " + Rlog.pii(LOG_TAG, (Object)imsi) + " spn: " + spn);
        }
        CarrierMatchingRule targetRule = new CarrierMatchingRule(mccmnc, imsi, null, gid1, gid2, null, spn, null, null, -1, null, -1);
        int carrierId = -1;
        int maxScore = -1;
        List<CarrierMatchingRule> rules = CarrierResolver.getCarrierMatchingRulesFromMccMnc(context, targetRule.mccMnc);
        for (CarrierMatchingRule rule : rules) {
            rule.match(targetRule);
            if (rule.mScore <= maxScore) continue;
            maxScore = rule.mScore;
            carrierId = rule.mCid;
        }
        return carrierId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> getCarrierIdsFromApnQuery(Context context, String mccmnc, String mvnoCase, String mvnoData) {
        String selection = "mccmnc=" + mccmnc;
        if ("spn".equals(mvnoCase) && mvnoData != null) {
            selection = selection + " AND spn='" + mvnoData + "'";
        } else if ("imsi".equals(mvnoCase) && mvnoData != null) {
            selection = selection + " AND imsi_prefix_xpattern='" + mvnoData + "'";
        } else if ("gid1".equals(mvnoCase) && mvnoData != null) {
            selection = selection + " AND gid1='" + mvnoData + "'";
        } else if ("gid2".equals(mvnoCase) && mvnoData != null) {
            selection = selection + " AND gid2='" + mvnoData + "'";
        } else {
            CarrierResolver.logd("mvno case empty or other invalid values");
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        try (Cursor cursor = context.getContentResolver().query(Telephony.CarrierId.All.CONTENT_URI, null, selection, null, null);){
            if (cursor != null) {
                if (VDBG) {
                    CarrierResolver.logd("[getCarrierIdsFromApnQuery]- " + cursor.getCount() + " Records(s) in DB");
                }
                while (cursor.moveToNext()) {
                    int cid = cursor.getInt(cursor.getColumnIndex("carrier_id"));
                    if (ids.contains(cid)) continue;
                    ids.add(cid);
                }
            }
        }
        catch (Exception ex) {
            CarrierResolver.loge("[getCarrierIdsFromApnQuery]- ex: " + ex);
        }
        CarrierResolver.logd(selection + " " + ids);
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getCarrierIdFromMccMnc(Context context, String mccmnc) {
        try (Cursor cursor = context.getContentResolver().query(Telephony.CarrierId.All.CONTENT_URI, null, "mccmnc=? AND gid1 is NULL AND gid2 is NULL AND imsi_prefix_xpattern is NULL AND spn is NULL AND iccid_prefix is NULL AND plmn is NULL AND privilege_access_rule is NULL AND apn is NULL", new String[]{mccmnc}, null);){
            if (cursor == null) return -1;
            if (VDBG) {
                CarrierResolver.logd("[getCarrierIdFromMccMnc]- " + cursor.getCount() + " Records(s) in DB mccmnc: " + mccmnc);
            }
            if (!cursor.moveToNext()) return -1;
            int n = cursor.getInt(cursor.getColumnIndex("carrier_id"));
            return n;
        }
        catch (Exception ex) {
            CarrierResolver.loge("[getCarrierIdFromMccMnc]- ex: " + ex);
        }
        return -1;
    }

    private static boolean equals(String a, String b, boolean ignoreCase) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return ignoreCase ? a.equalsIgnoreCase(b) : a.equals(b);
        }
        return false;
    }

    private static void logd(String str) {
        Rlog.d(LOG_TAG, str);
    }

    private static void loge(String str) {
        Rlog.e(LOG_TAG, str);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        ipw.println("mCarrierResolverLocalLogs:");
        ipw.increaseIndent();
        this.mCarrierIdLocalLog.dump(fd, pw, args);
        ipw.decreaseIndent();
        ipw.println("mCarrierId: " + this.mCarrierId);
        ipw.println("mSpecificCarrierId: " + this.mSpecificCarrierId);
        ipw.println("mMnoCarrierId: " + this.mMnoCarrierId);
        ipw.println("mCarrierName: " + this.mCarrierName);
        ipw.println("mSpecificCarrierName: " + this.mSpecificCarrierName);
        ipw.println("carrier_list_version: " + this.getCarrierListVersion());
        ipw.println("mCarrierMatchingRules on mccmnc: " + this.mTelephonyMgr.getSimOperatorNumericForPhone(this.mPhone.getPhoneId()));
        ipw.increaseIndent();
        for (CarrierMatchingRule rule : this.mCarrierMatchingRulesOnMccMnc) {
            ipw.println(rule.toString());
        }
        ipw.decreaseIndent();
        ipw.println("mSpn: " + this.mSpn);
        ipw.println("mPreferApn: " + this.mPreferApn);
        ipw.flush();
    }

    public static class CarrierMatchingRule {
        private static final int SCORE_MCCMNC = 256;
        private static final int SCORE_IMSI_PREFIX = 128;
        private static final int SCORE_ICCID_PREFIX = 64;
        private static final int SCORE_GID1 = 32;
        private static final int SCORE_GID2 = 16;
        private static final int SCORE_PLMN = 8;
        private static final int SCORE_PRIVILEGE_ACCESS_RULE = 4;
        private static final int SCORE_SPN = 2;
        private static final int SCORE_APN = 1;
        private static final int SCORE_INVALID = -1;
        public final String mccMnc;
        public final String imsiPrefixPattern;
        public final String iccidPrefix;
        public final String gid1;
        public final String gid2;
        public final String plmn;
        public final String spn;
        public final String apn;
        public final List<String> privilegeAccessRule;
        private String mName;
        private int mCid;
        private int mParentCid;
        private int mScore = 0;

        @VisibleForTesting
        public CarrierMatchingRule(String mccmnc, String imsiPrefixPattern, String iccidPrefix, String gid1, String gid2, String plmn, String spn, String apn, List<String> privilegeAccessRule, int cid, String name, int parentCid) {
            this.mccMnc = mccmnc;
            this.imsiPrefixPattern = imsiPrefixPattern;
            this.iccidPrefix = iccidPrefix;
            this.gid1 = gid1;
            this.gid2 = gid2;
            this.plmn = plmn;
            this.spn = spn;
            this.apn = apn;
            this.privilegeAccessRule = privilegeAccessRule;
            this.mCid = cid;
            this.mName = name;
            this.mParentCid = parentCid;
        }

        private CarrierMatchingRule(CarrierMatchingRule rule) {
            this.mccMnc = rule.mccMnc;
            this.imsiPrefixPattern = rule.imsiPrefixPattern;
            this.iccidPrefix = rule.iccidPrefix;
            this.gid1 = rule.gid1;
            this.gid2 = rule.gid2;
            this.plmn = rule.plmn;
            this.spn = rule.spn;
            this.apn = rule.apn;
            this.privilegeAccessRule = rule.privilegeAccessRule;
            this.mCid = rule.mCid;
            this.mName = rule.mName;
            this.mParentCid = rule.mParentCid;
        }

        public void match(CarrierMatchingRule subscriptionRule) {
            this.mScore = 0;
            if (this.mccMnc != null) {
                if (!CarrierResolver.equals(subscriptionRule.mccMnc, this.mccMnc, false)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 256;
            }
            if (this.imsiPrefixPattern != null) {
                if (!this.imsiPrefixMatch(subscriptionRule.imsiPrefixPattern, this.imsiPrefixPattern)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 128;
            }
            if (this.iccidPrefix != null) {
                if (!this.iccidPrefixMatch(subscriptionRule.iccidPrefix, this.iccidPrefix)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 64;
            }
            if (this.gid1 != null) {
                if (!this.gidMatch(subscriptionRule.gid1, this.gid1)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 32;
            }
            if (this.gid2 != null) {
                if (!this.gidMatch(subscriptionRule.gid2, this.gid2)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 16;
            }
            if (this.plmn != null) {
                if (!CarrierResolver.equals(subscriptionRule.plmn, this.plmn, true)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 8;
            }
            if (this.spn != null) {
                if (!CarrierResolver.equals(subscriptionRule.spn, this.spn, true)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 2;
            }
            if (this.privilegeAccessRule != null && !this.privilegeAccessRule.isEmpty()) {
                if (!this.carrierPrivilegeRulesMatch(subscriptionRule.privilegeAccessRule, this.privilegeAccessRule)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 4;
            }
            if (this.apn != null) {
                if (!CarrierResolver.equals(subscriptionRule.apn, this.apn, true)) {
                    this.mScore = -1;
                    return;
                }
                ++this.mScore;
            }
        }

        private boolean imsiPrefixMatch(String imsi, String prefixXPattern) {
            if (TextUtils.isEmpty(prefixXPattern)) {
                return true;
            }
            if (TextUtils.isEmpty(imsi)) {
                return false;
            }
            if (imsi.length() < prefixXPattern.length()) {
                return false;
            }
            for (int i = 0; i < prefixXPattern.length(); ++i) {
                if (prefixXPattern.charAt(i) == 'x' || prefixXPattern.charAt(i) == 'X' || prefixXPattern.charAt(i) == imsi.charAt(i)) continue;
                return false;
            }
            return true;
        }

        private boolean iccidPrefixMatch(String iccid, String prefix) {
            if (iccid == null || prefix == null) {
                return false;
            }
            return iccid.startsWith(prefix);
        }

        private boolean gidMatch(String gidFromSim, String gid) {
            return gidFromSim != null && gidFromSim.toLowerCase().startsWith(gid.toLowerCase());
        }

        private boolean carrierPrivilegeRulesMatch(List<String> certsFromSubscription, List<String> certs) {
            if (certsFromSubscription == null || certsFromSubscription.isEmpty()) {
                return false;
            }
            for (String cert : certs) {
                for (String certFromSubscription : certsFromSubscription) {
                    if (TextUtils.isEmpty(cert) || !cert.equalsIgnoreCase(certFromSubscription)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "[CarrierMatchingRule] - mccmnc: " + this.mccMnc + " gid1: " + this.gid1 + " gid2: " + this.gid2 + " plmn: " + this.plmn + " imsi_prefix: " + this.imsiPrefixPattern + " iccid_prefix" + this.iccidPrefix + " spn: " + this.spn + " privilege_access_rule: " + this.privilegeAccessRule + " apn: " + this.apn + " name: " + this.mName + " cid: " + this.mCid + " score: " + this.mScore;
        }
    }
}

