/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.ServiceStateTracker;
import java.util.HashMap;
import java.util.Map;

public class CarrierServiceStateTracker
extends Handler {
    private static final String LOG_TAG = "CSST";
    protected static final int CARRIER_EVENT_BASE = 100;
    protected static final int CARRIER_EVENT_VOICE_REGISTRATION = 101;
    protected static final int CARRIER_EVENT_VOICE_DEREGISTRATION = 102;
    protected static final int CARRIER_EVENT_DATA_REGISTRATION = 103;
    protected static final int CARRIER_EVENT_DATA_DEREGISTRATION = 104;
    protected static final int CARRIER_EVENT_IMS_CAPABILITIES_CHANGED = 105;
    private static final int UNINITIALIZED_DELAY_VALUE = -1;
    private Phone mPhone;
    private ServiceStateTracker mSST;
    private final Map<Integer, NotificationType> mNotificationTypeMap = new HashMap<Integer, NotificationType>();
    private int mPreviousSubId = -1;
    public static final int NOTIFICATION_PREF_NETWORK = 1000;
    public static final int NOTIFICATION_EMERGENCY_NETWORK = 1001;
    private ContentObserver mPrefNetworkModeObserver = new ContentObserver(this){

        @Override
        public void onChange(boolean selfChange) {
            CarrierServiceStateTracker.this.handlePrefNetworkModeChanged();
        }
    };
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            CarrierConfigManager carrierConfigManager = (CarrierConfigManager)context.getSystemService("carrier_config");
            PersistableBundle b = carrierConfigManager.getConfigForSubId(CarrierServiceStateTracker.this.mPhone.getSubId());
            for (Map.Entry entry : CarrierServiceStateTracker.this.mNotificationTypeMap.entrySet()) {
                NotificationType notificationType = (NotificationType)entry.getValue();
                notificationType.setDelay(b);
            }
            CarrierServiceStateTracker.this.handleConfigChanges();
        }
    };

    public CarrierServiceStateTracker(Phone phone, ServiceStateTracker sst) {
        this.mPhone = phone;
        this.mSST = sst;
        phone.getContext().registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"));
        SubscriptionManager.from(this.mPhone.getContext()).addOnSubscriptionsChangedListener(new SubscriptionManager.OnSubscriptionsChangedListener(this.getLooper()){

            @Override
            public void onSubscriptionsChanged() {
                int subId = CarrierServiceStateTracker.this.mPhone.getSubId();
                if (CarrierServiceStateTracker.this.mPreviousSubId != subId) {
                    CarrierServiceStateTracker.this.mPreviousSubId = subId;
                    CarrierServiceStateTracker.this.registerPrefNetworkModeObserver();
                }
            }
        });
        this.registerNotificationTypes();
        this.registerPrefNetworkModeObserver();
    }

    @VisibleForTesting
    public ContentObserver getContentObserver() {
        return this.mPrefNetworkModeObserver;
    }

    private void registerPrefNetworkModeObserver() {
        int subId = this.mPhone.getSubId();
        this.unregisterPrefNetworkModeObserver();
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            this.mPhone.getContext().getContentResolver().registerContentObserver(Settings.Global.getUriFor("preferred_network_mode" + subId), true, this.mPrefNetworkModeObserver);
        }
    }

    private void unregisterPrefNetworkModeObserver() {
        this.mPhone.getContext().getContentResolver().unregisterContentObserver(this.mPrefNetworkModeObserver);
    }

    @VisibleForTesting
    public Map<Integer, NotificationType> getNotificationTypeMap() {
        return this.mNotificationTypeMap;
    }

    private void registerNotificationTypes() {
        this.mNotificationTypeMap.put(1000, new PrefNetworkNotification(1000));
        this.mNotificationTypeMap.put(1001, new EmergencyNetworkNotification(1001));
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                this.handleConfigChanges();
                break;
            }
            case 105: {
                this.handleImsCapabilitiesChanged();
                break;
            }
            case 1000: 
            case 1001: {
                Rlog.d(LOG_TAG, "sending notification after delay: " + msg.what);
                NotificationType notificationType = this.mNotificationTypeMap.get(msg.what);
                if (notificationType == null) break;
                this.sendNotification(notificationType);
            }
        }
    }

    private boolean isPhoneStillRegistered() {
        if (this.mSST.mSS == null) {
            return true;
        }
        return this.mSST.mSS.getVoiceRegState() == 0 || this.mSST.mSS.getDataRegState() == 0;
    }

    private boolean isPhoneVoiceRegistered() {
        if (this.mSST.mSS == null) {
            return true;
        }
        return this.mSST.mSS.getVoiceRegState() == 0;
    }

    private boolean isPhoneRegisteredForWifiCalling() {
        Rlog.d(LOG_TAG, "isPhoneRegisteredForWifiCalling: " + this.mPhone.isWifiCallingEnabled());
        return this.mPhone.isWifiCallingEnabled();
    }

    @VisibleForTesting
    public boolean isRadioOffOrAirplaneMode() {
        Context context = this.mPhone.getContext();
        int airplaneMode = -1;
        try {
            airplaneMode = Settings.Global.getInt(context.getContentResolver(), "airplane_mode_on", 0);
        }
        catch (Exception e) {
            Rlog.e(LOG_TAG, "Unable to get AIRPLACE_MODE_ON.");
            return true;
        }
        return !this.mSST.isRadioOn() || airplaneMode != 0;
    }

    private boolean isGlobalMode() {
        Context context = this.mPhone.getContext();
        int preferredNetworkSetting = -1;
        try {
            preferredNetworkSetting = Settings.Global.getInt(context.getContentResolver(), "preferred_network_mode" + this.mPhone.getSubId(), Phone.PREFERRED_NT_MODE);
        }
        catch (Exception e) {
            Rlog.e(LOG_TAG, "Unable to get PREFERRED_NETWORK_MODE.");
            return true;
        }
        return preferredNetworkSetting == 10;
    }

    private void handleConfigChanges() {
        for (Map.Entry<Integer, NotificationType> entry : this.mNotificationTypeMap.entrySet()) {
            NotificationType notificationType = entry.getValue();
            this.evaluateSendingMessageOrCancelNotification(notificationType);
        }
    }

    private void handlePrefNetworkModeChanged() {
        NotificationType notificationType = this.mNotificationTypeMap.get(1000);
        if (notificationType != null) {
            this.evaluateSendingMessageOrCancelNotification(notificationType);
        }
    }

    private void handleImsCapabilitiesChanged() {
        NotificationType notificationType = this.mNotificationTypeMap.get(1001);
        if (notificationType != null) {
            this.evaluateSendingMessageOrCancelNotification(notificationType);
        }
    }

    private void evaluateSendingMessageOrCancelNotification(NotificationType notificationType) {
        if (this.evaluateSendingMessage(notificationType)) {
            Message notificationMsg = this.obtainMessage(notificationType.getTypeId(), null);
            Rlog.i(LOG_TAG, "starting timer for notifications." + notificationType.getTypeId());
            this.sendMessageDelayed(notificationMsg, this.getDelay(notificationType));
        } else {
            this.cancelNotification(notificationType.getTypeId());
            Rlog.i(LOG_TAG, "canceling notifications: " + notificationType.getTypeId());
        }
    }

    @VisibleForTesting
    public boolean evaluateSendingMessage(NotificationType notificationType) {
        return notificationType.sendMessage();
    }

    @VisibleForTesting
    public int getDelay(NotificationType notificationType) {
        return notificationType.getDelay();
    }

    @VisibleForTesting
    public Notification.Builder getNotificationBuilder(NotificationType notificationType) {
        return notificationType.getNotificationBuilder();
    }

    @VisibleForTesting
    public NotificationManager getNotificationManager(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }

    @VisibleForTesting
    public void sendNotification(NotificationType notificationType) {
        if (!this.evaluateSendingMessage(notificationType)) {
            return;
        }
        Context context = this.mPhone.getContext();
        Notification.Builder builder = this.getNotificationBuilder(notificationType);
        builder.setWhen(System.currentTimeMillis()).setAutoCancel(true).setSmallIcon(17301642).setColor(context.getResources().getColor(17170460));
        this.getNotificationManager(context).notify(notificationType.getTypeId(), builder.build());
    }

    public void cancelNotification(int notificationId) {
        Context context = this.mPhone.getContext();
        this.removeMessages(notificationId);
        this.getNotificationManager(context).cancel(notificationId);
    }

    public void dispose() {
        this.unregisterPrefNetworkModeObserver();
    }

    public class EmergencyNetworkNotification
    implements NotificationType {
        private final int mTypeId;
        private int mDelay = -1;

        EmergencyNetworkNotification(int typeId) {
            this.mTypeId = typeId;
        }

        @Override
        public void setDelay(PersistableBundle bundle) {
            if (bundle == null) {
                Rlog.e(CarrierServiceStateTracker.LOG_TAG, "bundle is null");
                return;
            }
            this.mDelay = bundle.getInt("emergency_notification_delay_int");
            Rlog.i(CarrierServiceStateTracker.LOG_TAG, "reading time to delay notification emergency: " + this.mDelay);
        }

        @Override
        public int getDelay() {
            return this.mDelay;
        }

        @Override
        public int getTypeId() {
            return this.mTypeId;
        }

        @Override
        public boolean sendMessage() {
            Rlog.i(CarrierServiceStateTracker.LOG_TAG, "EmergencyNetworkNotification: sendMessage() w/values: ," + CarrierServiceStateTracker.this.isPhoneVoiceRegistered() + "," + this.mDelay + "," + CarrierServiceStateTracker.this.isPhoneRegisteredForWifiCalling() + "," + CarrierServiceStateTracker.this.mSST.isRadioOn());
            return this.mDelay != -1 && !CarrierServiceStateTracker.this.isPhoneVoiceRegistered() && CarrierServiceStateTracker.this.isPhoneRegisteredForWifiCalling();
        }

        @Override
        public Notification.Builder getNotificationBuilder() {
            Context context = CarrierServiceStateTracker.this.mPhone.getContext();
            CharSequence title = context.getText(17039414);
            CharSequence details = context.getText(17039413);
            return new Notification.Builder(context).setContentTitle(title).setStyle(new Notification.BigTextStyle().bigText(details)).setContentText(details).setChannel("wfc");
        }
    }

    public class PrefNetworkNotification
    implements NotificationType {
        private final int mTypeId;
        private int mDelay = -1;

        PrefNetworkNotification(int typeId) {
            this.mTypeId = typeId;
        }

        @Override
        public void setDelay(PersistableBundle bundle) {
            if (bundle == null) {
                Rlog.e(CarrierServiceStateTracker.LOG_TAG, "bundle is null");
                return;
            }
            this.mDelay = bundle.getInt("network_notification_delay_int");
            Rlog.i(CarrierServiceStateTracker.LOG_TAG, "reading time to delay notification pref network: " + this.mDelay);
        }

        @Override
        public int getDelay() {
            return this.mDelay;
        }

        @Override
        public int getTypeId() {
            return this.mTypeId;
        }

        @Override
        public boolean sendMessage() {
            Rlog.i(CarrierServiceStateTracker.LOG_TAG, "PrefNetworkNotification: sendMessage() w/values: ," + CarrierServiceStateTracker.this.isPhoneStillRegistered() + "," + this.mDelay + "," + CarrierServiceStateTracker.this.isGlobalMode() + "," + CarrierServiceStateTracker.this.mSST.isRadioOn());
            return this.mDelay != -1 && !CarrierServiceStateTracker.this.isPhoneStillRegistered() && !CarrierServiceStateTracker.this.isGlobalMode() && !CarrierServiceStateTracker.this.isRadioOffOrAirplaneMode();
        }

        @Override
        public Notification.Builder getNotificationBuilder() {
            Context context = CarrierServiceStateTracker.this.mPhone.getContext();
            Intent notificationIntent = new Intent("android.settings.DATA_ROAMING_SETTINGS");
            notificationIntent.putExtra("expandable", true);
            PendingIntent settingsIntent = PendingIntent.getActivity(context, 0, notificationIntent, 0x40000000);
            CharSequence title = context.getText(17039417);
            CharSequence details = context.getText(17039416);
            return new Notification.Builder(context).setContentTitle(title).setStyle(new Notification.BigTextStyle().bigText(details)).setContentText(details).setChannel("alert").setContentIntent(settingsIntent);
        }
    }

    public static interface NotificationType {
        public boolean sendMessage();

        public int getDelay();

        public void setDelay(PersistableBundle var1);

        public int getTypeId();

        public Notification.Builder getNotificationBuilder();
    }
}

