/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Message;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.SmsCbMessage;
import android.telephony.SubscriptionManager;
import android.util.LocalLog;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.WakeLockStateMachine;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class CellBroadcastHandler
extends WakeLockStateMachine {
    private final LocalLog mLocalLog = new LocalLog(100);
    private static final String EXTRA_MESSAGE = "message";

    private CellBroadcastHandler(Context context, Phone phone) {
        this("CellBroadcastHandler", context, phone);
    }

    protected CellBroadcastHandler(String debugTag, Context context, Phone phone) {
        super(debugTag, context, phone);
    }

    public static CellBroadcastHandler makeCellBroadcastHandler(Context context, Phone phone) {
        CellBroadcastHandler handler = new CellBroadcastHandler(context, phone);
        handler.start();
        return handler;
    }

    @Override
    protected boolean handleSmsMessage(Message message) {
        if (message.obj instanceof SmsCbMessage) {
            this.handleBroadcastSms((SmsCbMessage)message.obj);
            return true;
        }
        this.loge("handleMessage got object of type: " + message.obj.getClass().getName());
        return false;
    }

    protected void handleBroadcastSms(SmsCbMessage message) {
        TelephonyMetrics metrics = TelephonyMetrics.getInstance();
        metrics.writeNewCBSms(this.mPhone.getPhoneId(), message.getMessageFormat(), message.getMessagePriority(), message.isCmasMessage(), message.isEtwsMessage(), message.getServiceCategory(), message.getSerialNumber(), System.currentTimeMillis());
        if (message.isEmergencyMessage()) {
            String additionalPackage;
            String msg = "Dispatching emergency SMS CB, SmsCbMessage is: " + message;
            this.log(msg);
            this.mLocalLog.log(msg);
            Intent intent = new Intent("android.provider.Telephony.SMS_EMERGENCY_CB_RECEIVED");
            intent.addFlags(0x10000000);
            String receiverPermission = "android.permission.RECEIVE_EMERGENCY_BROADCAST";
            int appOp = 17;
            intent.putExtra(EXTRA_MESSAGE, message);
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
            if (Build.IS_DEBUGGABLE && (additionalPackage = Settings.Secure.getString(this.mContext.getContentResolver(), "cmas_additional_broadcast_pkg")) != null) {
                Intent additionalIntent = new Intent(intent);
                additionalIntent.setPackage(additionalPackage);
                this.mContext.sendOrderedBroadcastAsUser(additionalIntent, UserHandle.ALL, receiverPermission, appOp, null, this.getHandler(), -1, null, null);
            }
            String[] pkgs = this.mContext.getResources().getStringArray(17236002);
            this.mReceiverCount.addAndGet(pkgs.length);
            for (String pkg : pkgs) {
                intent.setPackage(pkg);
                this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.ALL, receiverPermission, appOp, this.mReceiver, this.getHandler(), -1, null, null);
            }
        } else {
            String msg = "Dispatching SMS CB, SmsCbMessage is: " + message;
            this.log(msg);
            this.mLocalLog.log(msg);
            Intent intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
            intent.addFlags(0x1000000);
            String receiverPermission = "android.permission.RECEIVE_SMS";
            int appOp = 16;
            intent.putExtra(EXTRA_MESSAGE, message);
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
            this.mReceiverCount.incrementAndGet();
            this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.ALL, receiverPermission, appOp, this.mReceiver, this.getHandler(), -1, null, null);
        }
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("CellBroadcastHandler:");
        this.mLocalLog.dump(fd, pw, args);
        pw.flush();
    }
}

