/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.hardware.radio.V1_0.CellIdentity;
import android.hardware.radio.V1_0.CellIdentityCdma;
import android.hardware.radio.V1_0.CellIdentityLte;
import android.hardware.radio.V1_0.CellIdentityTdscdma;
import android.hardware.radio.V1_2.CellIdentityGsm;
import android.hardware.radio.V1_2.DataRegStateResult;
import android.hardware.radio.V1_2.VoiceRegStateResult;
import android.hardware.radio.V1_4.LteVopsInfo;
import android.hardware.radio.V1_4.NrIndicators;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.telephony.CellIdentityWcdma;
import android.telephony.LteVopsSupportInfo;
import android.telephony.NetworkRegistrationInfo;
import android.telephony.NetworkService;
import android.telephony.NetworkServiceCallback;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class CellularNetworkService
extends NetworkService {
    private static final boolean DBG = false;
    private static final String TAG = CellularNetworkService.class.getSimpleName();
    private static final int GET_CS_REGISTRATION_STATE_DONE = 1;
    private static final int GET_PS_REGISTRATION_STATE_DONE = 2;
    private static final int NETWORK_REGISTRATION_STATE_CHANGED = 3;

    @Override
    public NetworkService.NetworkServiceProvider onCreateNetworkServiceProvider(int slotIndex) {
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            this.loge("Tried to Cellular network service with invalid slotId " + slotIndex);
            return null;
        }
        return new CellularNetworkServiceProvider(slotIndex);
    }

    private void log(String s) {
        Rlog.d(TAG, s);
    }

    private void loge(String s) {
        Rlog.e(TAG, s);
    }

    private class CellularNetworkServiceProvider
    extends NetworkService.NetworkServiceProvider {
        private final ConcurrentHashMap<Message, NetworkServiceCallback> mCallbackMap;
        private final Looper mLooper;
        private final HandlerThread mHandlerThread;
        private final Handler mHandler;
        private final Phone mPhone;

        CellularNetworkServiceProvider(int slotId) {
            super(CellularNetworkService.this, slotId);
            this.mCallbackMap = new ConcurrentHashMap();
            this.mPhone = PhoneFactory.getPhone(this.getSlotIndex());
            this.mHandlerThread = new HandlerThread(CellularNetworkService.class.getSimpleName());
            this.mHandlerThread.start();
            this.mLooper = this.mHandlerThread.getLooper();
            this.mHandler = new Handler(this.mLooper){

                @Override
                public void handleMessage(Message message) {
                    NetworkServiceCallback callback = (NetworkServiceCallback)CellularNetworkServiceProvider.this.mCallbackMap.remove(message);
                    switch (message.what) {
                        case 1: 
                        case 2: {
                            if (callback == null) {
                                return;
                            }
                            AsyncResult ar = (AsyncResult)message.obj;
                            int domain = message.what == 1 ? 1 : 2;
                            NetworkRegistrationInfo netState = CellularNetworkServiceProvider.this.getRegistrationStateFromResult(ar.result, domain);
                            int resultCode = ar.exception != null || netState == null ? 5 : 0;
                            try {
                                callback.onRequestNetworkRegistrationInfoComplete(resultCode, netState);
                            }
                            catch (Exception e) {
                                CellularNetworkService.this.loge("Exception: " + e);
                            }
                            break;
                        }
                        case 3: {
                            CellularNetworkServiceProvider.this.notifyNetworkRegistrationInfoChanged();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
            };
            this.mPhone.mCi.registerForNetworkStateChanged(this.mHandler, 3, null);
        }

        private int getRegStateFromHalRegState(int halRegState) {
            switch (halRegState) {
                case 0: 
                case 10: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: 
                case 12: {
                    return 2;
                }
                case 3: 
                case 13: {
                    return 3;
                }
                case 4: 
                case 14: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
            }
            return 0;
        }

        private boolean isEmergencyOnly(int halRegState) {
            switch (halRegState) {
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    return true;
                }
            }
            return false;
        }

        private List<Integer> getAvailableServices(int regState, int domain, boolean emergencyOnly) {
            ArrayList<Integer> availableServices = new ArrayList<Integer>();
            if (emergencyOnly) {
                availableServices.add(5);
            } else if (regState == 5 || regState == 1) {
                if (domain == 2) {
                    availableServices.add(2);
                } else if (domain == 1) {
                    availableServices.add(1);
                    availableServices.add(3);
                    availableServices.add(4);
                }
            }
            return availableServices;
        }

        private NetworkRegistrationInfo getRegistrationStateFromResult(Object result, int domain) {
            if (result == null) {
                return null;
            }
            if (domain == 1) {
                return this.createRegistrationStateFromVoiceRegState(result);
            }
            if (domain == 2) {
                return this.createRegistrationStateFromDataRegState(result);
            }
            return null;
        }

        private NetworkRegistrationInfo createRegistrationStateFromVoiceRegState(Object result) {
            int transportType = 1;
            int domain = 1;
            if (result instanceof android.hardware.radio.V1_0.VoiceRegStateResult) {
                android.hardware.radio.V1_0.VoiceRegStateResult voiceRegState = (android.hardware.radio.V1_0.VoiceRegStateResult)result;
                int regState = this.getRegStateFromHalRegState(voiceRegState.regState);
                int networkType = ServiceState.rilRadioTechnologyToNetworkType(voiceRegState.rat);
                if (networkType == 19) {
                    networkType = 13;
                }
                int reasonForDenial = voiceRegState.reasonForDenial;
                boolean emergencyOnly = this.isEmergencyOnly(voiceRegState.regState);
                boolean cssSupported = voiceRegState.cssSupported;
                int roamingIndicator = voiceRegState.roamingIndicator;
                int systemIsInPrl = voiceRegState.systemIsInPrl;
                int defaultRoamingIndicator = voiceRegState.defaultRoamingIndicator;
                List<Integer> availableServices = this.getAvailableServices(regState, domain, emergencyOnly);
                android.telephony.CellIdentity cellIdentity = this.convertHalCellIdentityToCellIdentity(voiceRegState.cellIdentity);
                return new NetworkRegistrationInfo(domain, transportType, regState, networkType, reasonForDenial, emergencyOnly, availableServices, cellIdentity, cssSupported, roamingIndicator, systemIsInPrl, defaultRoamingIndicator);
            }
            if (result instanceof VoiceRegStateResult) {
                VoiceRegStateResult voiceRegState = (VoiceRegStateResult)result;
                int regState = this.getRegStateFromHalRegState(voiceRegState.regState);
                int networkType = ServiceState.rilRadioTechnologyToNetworkType(voiceRegState.rat);
                if (networkType == 19) {
                    networkType = 13;
                }
                int reasonForDenial = voiceRegState.reasonForDenial;
                boolean emergencyOnly = this.isEmergencyOnly(voiceRegState.regState);
                boolean cssSupported = voiceRegState.cssSupported;
                int roamingIndicator = voiceRegState.roamingIndicator;
                int systemIsInPrl = voiceRegState.systemIsInPrl;
                int defaultRoamingIndicator = voiceRegState.defaultRoamingIndicator;
                List<Integer> availableServices = this.getAvailableServices(regState, domain, emergencyOnly);
                android.telephony.CellIdentity cellIdentity = this.convertHalCellIdentityToCellIdentity(voiceRegState.cellIdentity);
                return new NetworkRegistrationInfo(domain, transportType, regState, networkType, reasonForDenial, emergencyOnly, availableServices, cellIdentity, cssSupported, roamingIndicator, systemIsInPrl, defaultRoamingIndicator);
            }
            return null;
        }

        private NetworkRegistrationInfo createRegistrationStateFromDataRegState(Object result) {
            android.telephony.CellIdentity cellIdentity;
            Object dataRegState;
            int domain = 2;
            int regState = 4;
            int transportType = 1;
            int networkType = 0;
            int reasonForDenial = 0;
            boolean isUsingCarrierAggregation = false;
            boolean emergencyOnly = false;
            int maxDataCalls = 0;
            boolean isEndcAvailable = false;
            boolean isNrAvailable = false;
            boolean isDcNrRestricted = false;
            LteVopsSupportInfo lteVopsSupportInfo = new LteVopsSupportInfo(1, 1);
            if (result instanceof android.hardware.radio.V1_0.DataRegStateResult) {
                dataRegState = (android.hardware.radio.V1_0.DataRegStateResult)result;
                regState = this.getRegStateFromHalRegState(((android.hardware.radio.V1_0.DataRegStateResult)dataRegState).regState);
                networkType = ServiceState.rilRadioTechnologyToNetworkType(((android.hardware.radio.V1_0.DataRegStateResult)dataRegState).rat);
                reasonForDenial = ((android.hardware.radio.V1_0.DataRegStateResult)dataRegState).reasonDataDenied;
                emergencyOnly = this.isEmergencyOnly(((android.hardware.radio.V1_0.DataRegStateResult)dataRegState).regState);
                maxDataCalls = ((android.hardware.radio.V1_0.DataRegStateResult)dataRegState).maxDataCalls;
                cellIdentity = this.convertHalCellIdentityToCellIdentity(((android.hardware.radio.V1_0.DataRegStateResult)dataRegState).cellIdentity);
            } else if (result instanceof DataRegStateResult) {
                dataRegState = (DataRegStateResult)result;
                regState = this.getRegStateFromHalRegState(((DataRegStateResult)dataRegState).regState);
                networkType = ServiceState.rilRadioTechnologyToNetworkType(((DataRegStateResult)dataRegState).rat);
                reasonForDenial = ((DataRegStateResult)dataRegState).reasonDataDenied;
                emergencyOnly = this.isEmergencyOnly(((DataRegStateResult)dataRegState).regState);
                maxDataCalls = ((DataRegStateResult)dataRegState).maxDataCalls;
                cellIdentity = this.convertHalCellIdentityToCellIdentity(((DataRegStateResult)dataRegState).cellIdentity);
            } else if (result instanceof android.hardware.radio.V1_4.DataRegStateResult) {
                dataRegState = (android.hardware.radio.V1_4.DataRegStateResult)result;
                regState = this.getRegStateFromHalRegState(((android.hardware.radio.V1_4.DataRegStateResult)dataRegState).base.regState);
                networkType = ServiceState.rilRadioTechnologyToNetworkType(((android.hardware.radio.V1_4.DataRegStateResult)dataRegState).base.rat);
                reasonForDenial = ((android.hardware.radio.V1_4.DataRegStateResult)dataRegState).base.reasonDataDenied;
                emergencyOnly = this.isEmergencyOnly(((android.hardware.radio.V1_4.DataRegStateResult)dataRegState).base.regState);
                maxDataCalls = ((android.hardware.radio.V1_4.DataRegStateResult)dataRegState).base.maxDataCalls;
                cellIdentity = this.convertHalCellIdentityToCellIdentity(((android.hardware.radio.V1_4.DataRegStateResult)dataRegState).base.cellIdentity);
                NrIndicators nrIndicators = ((android.hardware.radio.V1_4.DataRegStateResult)dataRegState).nrIndicators;
                if (((android.hardware.radio.V1_4.DataRegStateResult)dataRegState).vopsInfo.getDiscriminator() == 1 && ServiceState.rilRadioTechnologyToAccessNetworkType(((android.hardware.radio.V1_4.DataRegStateResult)dataRegState).base.rat) == 3) {
                    LteVopsInfo vopsSupport = ((android.hardware.radio.V1_4.DataRegStateResult)dataRegState).vopsInfo.lteVopsInfo();
                    lteVopsSupportInfo = this.convertHalLteVopsSupportInfo(vopsSupport.isVopsSupported, vopsSupport.isEmcBearerSupported);
                } else {
                    lteVopsSupportInfo = new LteVopsSupportInfo(1, 1);
                }
                isEndcAvailable = nrIndicators.isEndcAvailable;
                isNrAvailable = nrIndicators.isNrAvailable;
                isDcNrRestricted = nrIndicators.isDcNrRestricted;
            } else {
                CellularNetworkService.this.loge("Unknown type of DataRegStateResult " + result);
                return null;
            }
            List<Integer> availableServices = this.getAvailableServices(regState, domain, emergencyOnly);
            if (networkType == 19) {
                isUsingCarrierAggregation = true;
                networkType = 13;
            }
            return new NetworkRegistrationInfo(domain, transportType, regState, networkType, reasonForDenial, emergencyOnly, availableServices, cellIdentity, maxDataCalls, isDcNrRestricted, isNrAvailable, isEndcAvailable, lteVopsSupportInfo, isUsingCarrierAggregation);
        }

        private LteVopsSupportInfo convertHalLteVopsSupportInfo(boolean vopsSupport, boolean emcBearerSupport) {
            int vops = 3;
            int emergency = 3;
            if (vopsSupport) {
                vops = 2;
            }
            if (emcBearerSupport) {
                emergency = 2;
            }
            return new LteVopsSupportInfo(vops, emergency);
        }

        private android.telephony.CellIdentity convertHalCellIdentityToCellIdentity(CellIdentity cellIdentity) {
            if (cellIdentity == null) {
                return null;
            }
            android.telephony.CellIdentity result = null;
            switch (cellIdentity.cellInfoType) {
                case 1: {
                    if (cellIdentity.cellIdentityGsm.size() != 1) break;
                    android.hardware.radio.V1_0.CellIdentityGsm cellIdentityGsm = cellIdentity.cellIdentityGsm.get(0);
                    result = new android.telephony.CellIdentityGsm(cellIdentityGsm);
                    break;
                }
                case 4: {
                    if (cellIdentity.cellIdentityWcdma.size() != 1) break;
                    android.hardware.radio.V1_0.CellIdentityWcdma cellIdentityWcdma = cellIdentity.cellIdentityWcdma.get(0);
                    result = new CellIdentityWcdma(cellIdentityWcdma);
                    break;
                }
                case 5: {
                    if (cellIdentity.cellIdentityTdscdma.size() != 1) break;
                    CellIdentityTdscdma cellIdentityTdscdma = cellIdentity.cellIdentityTdscdma.get(0);
                    result = new android.telephony.CellIdentityTdscdma(cellIdentityTdscdma);
                    break;
                }
                case 3: {
                    if (cellIdentity.cellIdentityLte.size() != 1) break;
                    CellIdentityLte cellIdentityLte = cellIdentity.cellIdentityLte.get(0);
                    result = new android.telephony.CellIdentityLte(cellIdentityLte);
                    break;
                }
                case 2: {
                    if (cellIdentity.cellIdentityCdma.size() != 1) break;
                    CellIdentityCdma cellIdentityCdma = cellIdentity.cellIdentityCdma.get(0);
                    result = new android.telephony.CellIdentityCdma(cellIdentityCdma);
                    break;
                }
            }
            return result;
        }

        private android.telephony.CellIdentity convertHalCellIdentityToCellIdentity(android.hardware.radio.V1_2.CellIdentity cellIdentity) {
            if (cellIdentity == null) {
                return null;
            }
            android.telephony.CellIdentity result = null;
            switch (cellIdentity.cellInfoType) {
                case 1: {
                    if (cellIdentity.cellIdentityGsm.size() != 1) break;
                    CellIdentityGsm cellIdentityGsm = cellIdentity.cellIdentityGsm.get(0);
                    result = new android.telephony.CellIdentityGsm(cellIdentityGsm);
                    break;
                }
                case 4: {
                    if (cellIdentity.cellIdentityWcdma.size() != 1) break;
                    android.hardware.radio.V1_2.CellIdentityWcdma cellIdentityWcdma = cellIdentity.cellIdentityWcdma.get(0);
                    result = new CellIdentityWcdma(cellIdentityWcdma);
                    break;
                }
                case 5: {
                    if (cellIdentity.cellIdentityTdscdma.size() != 1) break;
                    android.hardware.radio.V1_2.CellIdentityTdscdma cellIdentityTdscdma = cellIdentity.cellIdentityTdscdma.get(0);
                    result = new android.telephony.CellIdentityTdscdma(cellIdentityTdscdma);
                    break;
                }
                case 3: {
                    if (cellIdentity.cellIdentityLte.size() != 1) break;
                    android.hardware.radio.V1_2.CellIdentityLte cellIdentityLte = cellIdentity.cellIdentityLte.get(0);
                    result = new android.telephony.CellIdentityLte(cellIdentityLte);
                    break;
                }
                case 2: {
                    if (cellIdentity.cellIdentityCdma.size() != 1) break;
                    android.hardware.radio.V1_2.CellIdentityCdma cellIdentityCdma = cellIdentity.cellIdentityCdma.get(0);
                    result = new android.telephony.CellIdentityCdma(cellIdentityCdma);
                    break;
                }
            }
            return result;
        }

        @Override
        public void requestNetworkRegistrationInfo(int domain, NetworkServiceCallback callback) {
            Message message = null;
            if (domain == 1) {
                message = Message.obtain(this.mHandler, 1);
                this.mCallbackMap.put(message, callback);
                this.mPhone.mCi.getVoiceRegistrationState(message);
            } else if (domain == 2) {
                message = Message.obtain(this.mHandler, 2);
                this.mCallbackMap.put(message, callback);
                this.mPhone.mCi.getDataRegistrationState(message);
            } else {
                CellularNetworkService.this.loge("requestNetworkRegistrationInfo invalid domain " + domain);
                callback.onRequestNetworkRegistrationInfoComplete(2, null);
            }
        }

        @Override
        public void close() {
            this.mCallbackMap.clear();
            this.mHandlerThread.quit();
            this.mPhone.mCi.unregisterForNetworkStateChanged(this.mHandler);
        }
    }
}

