/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Handler;
import android.telephony.SubscriptionManager;
import android.util.Log;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConfigurationManager;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.metrics.TelephonyMetrics;

public class CellularNetworkValidator {
    private static final String LOG_TAG = "NetworkValidator";
    private static final int STATE_IDLE = 0;
    private static final int STATE_VALIDATING = 1;
    private static final int STATE_VALIDATED = 2;
    private static CellularNetworkValidator sInstance;
    private int mState = 0;
    private int mSubId;
    private int mTimeoutInMs;
    private boolean mReleaseAfterValidation;
    private NetworkRequest mNetworkRequest;
    private ValidationCallback mValidationCallback;
    private Context mContext;
    private ConnectivityManager mConnectivityManager;
    private Handler mHandler = new Handler();
    private ConnectivityNetworkCallback mNetworkCallback;

    public static CellularNetworkValidator make(Context context) {
        if (sInstance != null) {
            CellularNetworkValidator.logd("createCellularNetworkValidator failed. Instance already exists.");
        } else {
            sInstance = new CellularNetworkValidator(context);
        }
        return sInstance;
    }

    public static CellularNetworkValidator getInstance() {
        return sInstance;
    }

    public boolean isValidationFeatureSupported() {
        return PhoneConfigurationManager.getInstance().getCurrentPhoneCapability().validationBeforeSwitchSupported;
    }

    private CellularNetworkValidator(Context context) {
        this.mContext = context;
        this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
    }

    public synchronized void validate(int subId, int timeoutInMs, boolean releaseAfterValidation, ValidationCallback callback) {
        if (subId == this.mSubId) {
            return;
        }
        Phone phone = PhoneFactory.getPhone(SubscriptionManager.getPhoneId(subId));
        if (phone == null) {
            CellularNetworkValidator.logd("Failed to start validation. Inactive subId " + subId);
            callback.onValidationResult(false, subId);
            return;
        }
        if (this.isValidating()) {
            this.stopValidation();
        }
        this.mState = 1;
        this.mSubId = subId;
        this.mTimeoutInMs = timeoutInMs;
        this.mValidationCallback = callback;
        this.mReleaseAfterValidation = releaseAfterValidation;
        this.mNetworkRequest = this.createNetworkRequest();
        CellularNetworkValidator.logd("Start validating subId " + this.mSubId + " mTimeoutInMs " + this.mTimeoutInMs + " mReleaseAfterValidation " + this.mReleaseAfterValidation);
        this.mNetworkCallback = new ConnectivityNetworkCallback(subId);
        this.mConnectivityManager.requestNetwork(this.mNetworkRequest, this.mNetworkCallback, this.mHandler, this.mTimeoutInMs);
    }

    public synchronized void stopValidation() {
        if (!this.isValidating()) {
            CellularNetworkValidator.logd("No need to stop validation.");
        } else {
            this.mConnectivityManager.unregisterNetworkCallback(this.mNetworkCallback);
            this.mState = 0;
        }
        this.mSubId = -1;
    }

    public synchronized int getSubIdInValidation() {
        return this.mSubId;
    }

    public synchronized boolean isValidating() {
        return this.mState != 0;
    }

    private NetworkRequest createNetworkRequest() {
        return new NetworkRequest.Builder().addCapability(12).addTransportType(0).setNetworkSpecifier(String.valueOf(this.mSubId)).build();
    }

    private synchronized void reportValidationResult(boolean passed, int subId) {
        if (this.mSubId != subId) {
            return;
        }
        if (this.mState == 1) {
            this.mValidationCallback.onValidationResult(passed, this.mSubId);
            if (!this.mReleaseAfterValidation && passed) {
                this.mState = 2;
            } else {
                this.mConnectivityManager.unregisterNetworkCallback(this.mNetworkCallback);
                this.mState = 0;
            }
            TelephonyMetrics.getInstance().writeNetworkValidate(passed ? 3 : 2);
        }
        this.mSubId = -1;
    }

    private static void logd(String log) {
        Log.d(LOG_TAG, log);
    }

    class ConnectivityNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private final int mSubId;

        ConnectivityNetworkCallback(int subId) {
            this.mSubId = subId;
        }

        @Override
        public void onAvailable(Network network) {
            CellularNetworkValidator.logd("network onAvailable " + network);
            if (this.mSubId == CellularNetworkValidator.this.mSubId) {
                TelephonyMetrics.getInstance().writeNetworkValidate(1);
            }
        }

        @Override
        public void onLosing(Network network, int maxMsToLive) {
            CellularNetworkValidator.logd("network onLosing " + network + " maxMsToLive " + maxMsToLive);
            CellularNetworkValidator.this.reportValidationResult(false, this.mSubId);
        }

        @Override
        public void onLost(Network network) {
            CellularNetworkValidator.logd("network onLost " + network);
            CellularNetworkValidator.this.reportValidationResult(false, this.mSubId);
        }

        @Override
        public void onUnavailable() {
            CellularNetworkValidator.logd("onUnavailable");
            CellularNetworkValidator.this.reportValidationResult(false, this.mSubId);
        }

        @Override
        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            if (networkCapabilities.hasCapability(16)) {
                CellularNetworkValidator.logd("onValidated");
                CellularNetworkValidator.this.reportValidationResult(true, this.mSubId);
            }
        }
    }

    public static interface ValidationCallback {
        public void onValidationResult(boolean var1, int var2);
    }
}

