/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.CallQuality;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.PhoneCapability;
import android.telephony.PhysicalChannelConfig;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.data.ApnSetting;
import android.telephony.ims.ImsReasonInfo;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstantConversions;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.PhoneNotifier;
import java.util.List;

public class DefaultPhoneNotifier
implements PhoneNotifier {
    private static final String LOG_TAG = "DefaultPhoneNotifier";
    private static final boolean DBG = false;
    @UnsupportedAppUsage
    protected ITelephonyRegistry mRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));

    @Override
    public void notifyPhoneState(Phone sender) {
        Call ringingCall = sender.getRingingCall();
        int subId = sender.getSubId();
        int phoneId = sender.getPhoneId();
        String incomingNumber = "";
        if (ringingCall != null && ringingCall.getEarliestConnection() != null) {
            incomingNumber = ringingCall.getEarliestConnection().getAddress();
        }
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyCallStateForPhoneId(phoneId, subId, PhoneConstantConversions.convertCallState(sender.getState()), incomingNumber);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyServiceState(Phone sender) {
        ServiceState ss = sender.getServiceState();
        int phoneId = sender.getPhoneId();
        int subId = sender.getSubId();
        Rlog.d(LOG_TAG, "nofityServiceState: mRegistry=" + this.mRegistry + " ss=" + ss + " sender=" + sender + " phondId=" + phoneId + " subId=" + subId);
        if (ss == null) {
            ss = new ServiceState();
            ss.setStateOutOfService();
        }
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyServiceStateForPhoneId(phoneId, subId, ss);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifySignalStrength(Phone sender) {
        int phoneId = sender.getPhoneId();
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifySignalStrengthForPhoneId(phoneId, subId, sender.getSignalStrength());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyMessageWaitingChanged(Phone sender) {
        int phoneId = sender.getPhoneId();
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyMessageWaitingChangedForPhoneId(phoneId, subId, sender.getMessageWaitingIndicator());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyCallForwardingChanged(Phone sender) {
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                Rlog.d(LOG_TAG, "notifyCallForwardingChanged: subId=" + subId + ", isCFActive=" + sender.getCallForwardingIndicator());
                this.mRegistry.notifyCallForwardingChangedForSubscriber(subId, sender.getCallForwardingIndicator());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyDataActivity(Phone sender) {
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyDataActivityForSubscriber(subId, DefaultPhoneNotifier.convertDataActivityState(sender.getDataActivityState()));
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyDataConnection(Phone sender, String apnType, PhoneConstants.DataState state) {
        this.doNotifyDataConnection(sender, apnType, state);
    }

    private void doNotifyDataConnection(Phone sender, String apnType, PhoneConstants.DataState state) {
        ServiceState ss;
        int subId = sender.getSubId();
        int phoneId = sender.getPhoneId();
        long dds = SubscriptionManager.getDefaultDataSubscriptionId();
        TelephonyManager telephony = TelephonyManager.getDefault();
        LinkProperties linkProperties = null;
        NetworkCapabilities networkCapabilities = null;
        boolean roaming = false;
        if (state == PhoneConstants.DataState.CONNECTED) {
            linkProperties = sender.getLinkProperties(apnType);
            networkCapabilities = sender.getNetworkCapabilities(apnType);
        }
        if ((ss = sender.getServiceState()) != null) {
            roaming = ss.getDataRoaming();
        }
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyDataConnectionForSubscriber(phoneId, subId, PhoneConstantConversions.convertDataState(state), sender.isDataAllowed(ApnSetting.getApnTypesBitmaskFromString(apnType)), sender.getActiveApnHost(apnType), apnType, linkProperties, networkCapabilities, telephony != null ? telephony.getDataNetworkType(subId) : 0, roaming);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyDataConnectionFailed(Phone sender, String apnType) {
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyDataConnectionFailedForSubscriber(sender.getPhoneId(), sender.getSubId(), apnType);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyCellLocation(Phone sender, CellLocation cl) {
        int subId = sender.getSubId();
        Bundle data = new Bundle();
        cl.fillInNotifierBundle(data);
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyCellLocationForSubscriber(subId, data);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyCellInfo(Phone sender, List<CellInfo> cellInfo) {
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyCellInfoForSubscriber(subId, cellInfo);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyPhysicalChannelConfiguration(Phone sender, List<PhysicalChannelConfig> configs) {
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyPhysicalChannelConfigurationForSubscriber(subId, configs);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyOtaspChanged(Phone sender, int otaspMode) {
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyOtaspChanged(subId, otaspMode);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyPreciseCallState(Phone sender) {
        Call ringingCall = sender.getRingingCall();
        Call foregroundCall = sender.getForegroundCall();
        Call backgroundCall = sender.getBackgroundCall();
        if (ringingCall != null && foregroundCall != null && backgroundCall != null) {
            try {
                this.mRegistry.notifyPreciseCallState(sender.getPhoneId(), sender.getSubId(), DefaultPhoneNotifier.convertPreciseCallState(ringingCall.getState()), DefaultPhoneNotifier.convertPreciseCallState(foregroundCall.getState()), DefaultPhoneNotifier.convertPreciseCallState(backgroundCall.getState()));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void notifyDisconnectCause(Phone sender, int cause, int preciseCause) {
        try {
            this.mRegistry.notifyDisconnectCause(sender.getPhoneId(), sender.getSubId(), cause, preciseCause);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyImsDisconnectCause(Phone sender, ImsReasonInfo imsReasonInfo) {
        try {
            this.mRegistry.notifyImsDisconnectCause(sender.getSubId(), imsReasonInfo);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyPreciseDataConnectionFailed(Phone sender, String apnType, String apn, int failCause) {
        try {
            this.mRegistry.notifyPreciseDataConnectionFailed(sender.getPhoneId(), sender.getSubId(), apnType, apn, failCause);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifySrvccStateChanged(Phone sender, int state) {
        try {
            this.mRegistry.notifySrvccStateChanged(sender.getSubId(), state);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyDataActivationStateChanged(Phone sender, int activationState) {
        try {
            this.mRegistry.notifySimActivationStateChangedForPhoneId(sender.getPhoneId(), sender.getSubId(), 1, activationState);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyVoiceActivationStateChanged(Phone sender, int activationState) {
        try {
            this.mRegistry.notifySimActivationStateChangedForPhoneId(sender.getPhoneId(), sender.getSubId(), 0, activationState);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyUserMobileDataStateChanged(Phone sender, boolean state) {
        try {
            this.mRegistry.notifyUserMobileDataStateChangedForPhoneId(sender.getPhoneId(), sender.getSubId(), state);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyOemHookRawEventForSubscriber(Phone sender, byte[] rawData) {
        try {
            this.mRegistry.notifyOemHookRawEventForSubscriber(sender.getPhoneId(), sender.getSubId(), rawData);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyPhoneCapabilityChanged(PhoneCapability capability) {
        try {
            this.mRegistry.notifyPhoneCapabilityChanged(capability);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyRadioPowerStateChanged(Phone sender, int state) {
        try {
            this.mRegistry.notifyRadioPowerStateChanged(sender.getPhoneId(), sender.getSubId(), state);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyEmergencyNumberList(Phone sender) {
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyEmergencyNumberList(sender.getPhoneId(), sender.getSubId());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyCallQualityChanged(Phone sender, CallQuality callQuality, int callNetworkType) {
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyCallQualityChanged(callQuality, sender.getPhoneId(), sender.getSubId(), callNetworkType);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static int convertDataActivityState(PhoneInternalInterface.DataActivityState state) {
        switch (state) {
            case DATAIN: {
                return 1;
            }
            case DATAOUT: {
                return 2;
            }
            case DATAINANDOUT: {
                return 3;
            }
            case DORMANT: {
                return 4;
            }
        }
        return 0;
    }

    public static int convertPreciseCallState(Call.State state) {
        switch (state) {
            case ACTIVE: {
                return 1;
            }
            case HOLDING: {
                return 2;
            }
            case DIALING: {
                return 3;
            }
            case ALERTING: {
                return 4;
            }
            case INCOMING: {
                return 5;
            }
            case WAITING: {
                return 6;
            }
            case DISCONNECTED: {
                return 7;
            }
            case DISCONNECTING: {
                return 8;
            }
        }
        return 0;
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, s);
    }
}

