/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.display.DisplayManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.BatteryManager;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.util.LocalLog;
import android.util.SparseIntArray;
import android.view.Display;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Phone;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class DeviceStateMonitor
extends Handler {
    protected static final boolean DBG = false;
    protected static final String TAG = DeviceStateMonitor.class.getSimpleName();
    static final int EVENT_RIL_CONNECTED = 0;
    static final int EVENT_UPDATE_MODE_CHANGED = 1;
    @VisibleForTesting
    static final int EVENT_SCREEN_STATE_CHANGED = 2;
    static final int EVENT_POWER_SAVE_MODE_CHANGED = 3;
    @VisibleForTesting
    static final int EVENT_CHARGING_STATE_CHANGED = 4;
    static final int EVENT_TETHERING_STATE_CHANGED = 5;
    static final int EVENT_RADIO_AVAILABLE = 6;
    @VisibleForTesting
    static final int EVENT_WIFI_CONNECTION_CHANGED = 7;
    private static final int HYSTERESIS_KBPS = 50;
    private static final int WIFI_UNAVAILABLE = 0;
    private static final int WIFI_AVAILABLE = 1;
    private final Phone mPhone;
    private final LocalLog mLocalLog = new LocalLog(100);
    private final NetworkRequest mWifiNetworkRequest = new NetworkRequest.Builder().addTransportType(1).addCapability(12).removeCapability(13).build();
    private final ConnectivityManager.NetworkCallback mNetworkCallback = new ConnectivityManager.NetworkCallback(){
        Set<Network> mWifiNetworks = new HashSet<Network>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAvailable(Network network) {
            Set<Network> set = this.mWifiNetworks;
            synchronized (set) {
                if (this.mWifiNetworks.size() == 0) {
                    DeviceStateMonitor.this.obtainMessage(7, 1, 0).sendToTarget();
                    DeviceStateMonitor.this.log("Wifi (default) connected", true);
                }
                this.mWifiNetworks.add(network);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLost(Network network) {
            Set<Network> set = this.mWifiNetworks;
            synchronized (set) {
                this.mWifiNetworks.remove(network);
                if (this.mWifiNetworks.size() == 0) {
                    DeviceStateMonitor.this.obtainMessage(7, 0, 0).sendToTarget();
                    DeviceStateMonitor.this.log("Wifi (default) disconnected", true);
                }
            }
        }
    };
    private boolean mIsTetheringOn;
    private boolean mIsScreenOn;
    private boolean mIsCharging;
    private boolean mIsPowerSaveOn;
    private boolean mIsLowDataExpected;
    private boolean mIsWifiConnected;
    @VisibleForTesting
    static final int CELL_INFO_INTERVAL_SHORT_MS = 2000;
    @VisibleForTesting
    static final int CELL_INFO_INTERVAL_LONG_MS = 10000;
    private int mCellInfoMinInterval = 2000;
    private SparseIntArray mUpdateModes = new SparseIntArray();
    private int mUnsolicitedResponseFilter = -1;
    private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        @Override
        public void onDisplayAdded(int displayId) {
        }

        @Override
        public void onDisplayRemoved(int displayId) {
        }

        @Override
        public void onDisplayChanged(int displayId) {
            boolean screenOn = DeviceStateMonitor.this.isScreenOn();
            Message msg = DeviceStateMonitor.this.obtainMessage(2);
            msg.arg1 = screenOn ? 1 : 0;
            DeviceStateMonitor.this.sendMessage(msg);
        }
    };
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Message msg;
            DeviceStateMonitor.this.log("received: " + intent, true);
            switch (intent.getAction()) {
                case "android.os.action.POWER_SAVE_MODE_CHANGED": {
                    msg = DeviceStateMonitor.this.obtainMessage(3);
                    msg.arg1 = DeviceStateMonitor.this.isPowerSaveModeOn() ? 1 : 0;
                    DeviceStateMonitor.this.log("Power Save mode " + (msg.arg1 == 1 ? "on" : "off"), true);
                    break;
                }
                case "android.os.action.CHARGING": {
                    msg = DeviceStateMonitor.this.obtainMessage(4);
                    msg.arg1 = 1;
                    break;
                }
                case "android.os.action.DISCHARGING": {
                    msg = DeviceStateMonitor.this.obtainMessage(4);
                    msg.arg1 = 0;
                    break;
                }
                case "android.net.conn.TETHER_STATE_CHANGED": {
                    ArrayList<String> activeTetherIfaces = intent.getStringArrayListExtra("tetherArray");
                    boolean isTetheringOn = activeTetherIfaces != null && activeTetherIfaces.size() > 0;
                    DeviceStateMonitor.this.log("Tethering " + (isTetheringOn ? "on" : "off"), true);
                    msg = DeviceStateMonitor.this.obtainMessage(5);
                    msg.arg1 = isTetheringOn ? 1 : 0;
                    break;
                }
                default: {
                    DeviceStateMonitor.this.log("Unexpected broadcast intent: " + intent, false);
                    return;
                }
            }
            DeviceStateMonitor.this.sendMessage(msg);
        }
    };
    private static final int[] LINK_CAPACITY_DOWNLINK_THRESHOLDS = new int[]{100, 500, 1000, 5000, 10000, 20000, 50000, 100000, 200000, 500000, 1000000};
    private static final int[] LINK_CAPACITY_UPLINK_THRESHOLDS = new int[]{100, 500, 1000, 5000, 10000, 20000, 50000, 100000, 200000};

    public DeviceStateMonitor(Phone phone) {
        this.mPhone = phone;
        DisplayManager dm = (DisplayManager)phone.getContext().getSystemService("display");
        dm.registerDisplayListener(this.mDisplayListener, null);
        this.mIsPowerSaveOn = this.isPowerSaveModeOn();
        this.mIsCharging = this.isDeviceCharging();
        this.mIsScreenOn = this.isScreenOn();
        this.mIsTetheringOn = false;
        this.mIsLowDataExpected = false;
        this.log("DeviceStateMonitor mIsPowerSaveOn=" + this.mIsPowerSaveOn + ",mIsScreenOn=" + this.mIsScreenOn + ",mIsCharging=" + this.mIsCharging, false);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.os.action.POWER_SAVE_MODE_CHANGED");
        filter.addAction("android.os.action.CHARGING");
        filter.addAction("android.os.action.DISCHARGING");
        filter.addAction("android.net.conn.TETHER_STATE_CHANGED");
        this.mPhone.getContext().registerReceiver(this.mBroadcastReceiver, filter, null, this.mPhone);
        this.mPhone.mCi.registerForRilConnected(this, 0, null);
        this.mPhone.mCi.registerForAvailable(this, 6, null);
        ConnectivityManager cm = (ConnectivityManager)phone.getContext().getSystemService("connectivity");
        cm.registerNetworkCallback(this.mWifiNetworkRequest, this.mNetworkCallback);
    }

    private boolean isLowDataExpected() {
        return !this.mIsCharging && !this.mIsTetheringOn && !this.mIsScreenOn;
    }

    @VisibleForTesting
    public int computeCellInfoMinInterval() {
        if (this.mIsScreenOn && !this.mIsWifiConnected) {
            return 2000;
        }
        if (this.mIsScreenOn && this.mIsCharging) {
            return 2000;
        }
        return 10000;
    }

    private boolean shouldTurnOffSignalStrength() {
        return !this.mIsCharging && !this.mIsScreenOn && this.mUpdateModes.get(1) != 2;
    }

    private boolean shouldTurnOffFullNetworkUpdate() {
        return !this.mIsCharging && !this.mIsScreenOn && !this.mIsTetheringOn && this.mUpdateModes.get(2) != 2;
    }

    private boolean shouldTurnOffDormancyUpdate() {
        return !this.mIsCharging && !this.mIsScreenOn && !this.mIsTetheringOn && this.mUpdateModes.get(4) != 2;
    }

    private boolean shouldTurnOffLinkCapacityEstimate() {
        return !this.mIsCharging && !this.mIsScreenOn && !this.mIsTetheringOn && this.mUpdateModes.get(8) != 2;
    }

    private boolean shouldTurnOffPhysicalChannelConfig() {
        return !this.mIsCharging && !this.mIsScreenOn && !this.mIsTetheringOn && this.mUpdateModes.get(16) != 2;
    }

    public void setIndicationUpdateMode(int filters, int mode) {
        this.sendMessage(this.obtainMessage(1, filters, mode));
    }

    private void onSetIndicationUpdateMode(int filters, int mode) {
        if ((filters & 1) != 0) {
            this.mUpdateModes.put(1, mode);
        }
        if ((filters & 2) != 0) {
            this.mUpdateModes.put(2, mode);
        }
        if ((filters & 4) != 0) {
            this.mUpdateModes.put(4, mode);
        }
        if ((filters & 8) != 0) {
            this.mUpdateModes.put(8, mode);
        }
        if ((filters & 0x10) != 0) {
            this.mUpdateModes.put(16, mode);
        }
    }

    @Override
    public void handleMessage(Message msg) {
        this.log("handleMessage msg=" + msg, false);
        switch (msg.what) {
            case 0: 
            case 6: {
                this.onReset();
                break;
            }
            case 1: {
                this.onSetIndicationUpdateMode(msg.arg1, msg.arg2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.onUpdateDeviceState(msg.what, msg.arg1 != 0);
                break;
            }
            case 7: {
                this.onUpdateDeviceState(msg.what, msg.arg1 != 0);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected message arrives. msg = " + msg.what);
            }
        }
    }

    private void onUpdateDeviceState(int eventType, boolean state) {
        switch (eventType) {
            case 2: {
                if (this.mIsScreenOn == state) {
                    return;
                }
                this.mIsScreenOn = state;
                break;
            }
            case 4: {
                if (this.mIsCharging == state) {
                    return;
                }
                this.mIsCharging = state;
                this.sendDeviceState(1, this.mIsCharging);
                break;
            }
            case 5: {
                if (this.mIsTetheringOn == state) {
                    return;
                }
                this.mIsTetheringOn = state;
                break;
            }
            case 3: {
                if (this.mIsPowerSaveOn == state) {
                    return;
                }
                this.mIsPowerSaveOn = state;
                this.sendDeviceState(0, this.mIsPowerSaveOn);
                break;
            }
            case 7: {
                if (this.mIsWifiConnected == state) {
                    return;
                }
                this.mIsWifiConnected = state;
                break;
            }
            default: {
                return;
            }
        }
        int newCellInfoMinInterval = this.computeCellInfoMinInterval();
        if (this.mCellInfoMinInterval != newCellInfoMinInterval) {
            this.mCellInfoMinInterval = newCellInfoMinInterval;
            this.setCellInfoMinInterval(this.mCellInfoMinInterval);
            this.log("CellInfo Min Interval Updated to " + newCellInfoMinInterval, true);
        }
        if (this.mIsLowDataExpected != this.isLowDataExpected()) {
            this.mIsLowDataExpected = !this.mIsLowDataExpected;
            this.sendDeviceState(2, this.mIsLowDataExpected);
        }
        int newFilter = 0;
        if (!this.shouldTurnOffSignalStrength()) {
            newFilter |= 1;
        }
        if (!this.shouldTurnOffFullNetworkUpdate()) {
            newFilter |= 2;
        }
        if (!this.shouldTurnOffDormancyUpdate()) {
            newFilter |= 4;
        }
        if (!this.shouldTurnOffLinkCapacityEstimate()) {
            newFilter |= 8;
        }
        if (!this.shouldTurnOffPhysicalChannelConfig()) {
            newFilter |= 0x10;
        }
        this.setUnsolResponseFilter(newFilter, false);
    }

    private void onReset() {
        this.log("onReset.", true);
        this.sendDeviceState(1, this.mIsCharging);
        this.sendDeviceState(2, this.mIsLowDataExpected);
        this.sendDeviceState(0, this.mIsPowerSaveOn);
        this.setUnsolResponseFilter(this.mUnsolicitedResponseFilter, true);
        this.setSignalStrengthReportingCriteria();
        this.setLinkCapacityReportingCriteria();
        this.setCellInfoMinInterval(this.mCellInfoMinInterval);
    }

    private String deviceTypeToString(int type) {
        switch (type) {
            case 1: {
                return "CHARGING_STATE";
            }
            case 2: {
                return "LOW_DATA_EXPECTED";
            }
            case 0: {
                return "POWER_SAVE_MODE";
            }
        }
        return "UNKNOWN";
    }

    private void sendDeviceState(int type, boolean state) {
        this.log("send type: " + this.deviceTypeToString(type) + ", state=" + state, true);
        this.mPhone.mCi.sendDeviceState(type, state, null);
    }

    private void setUnsolResponseFilter(int newFilter, boolean force) {
        if (force || newFilter != this.mUnsolicitedResponseFilter) {
            this.log("old filter: " + this.mUnsolicitedResponseFilter + ", new filter: " + newFilter, true);
            this.mPhone.mCi.setUnsolResponseFilter(newFilter, null);
            this.mUnsolicitedResponseFilter = newFilter;
        }
    }

    private void setSignalStrengthReportingCriteria() {
        this.mPhone.setSignalStrengthReportingCriteria(AccessNetworkThresholds.GERAN, 1);
        this.mPhone.setSignalStrengthReportingCriteria(AccessNetworkThresholds.UTRAN, 2);
        this.mPhone.setSignalStrengthReportingCriteria(AccessNetworkThresholds.EUTRAN, 3);
        this.mPhone.setSignalStrengthReportingCriteria(AccessNetworkThresholds.CDMA2000, 4);
    }

    private void setLinkCapacityReportingCriteria() {
        this.mPhone.setLinkCapacityReportingCriteria(LINK_CAPACITY_DOWNLINK_THRESHOLDS, LINK_CAPACITY_UPLINK_THRESHOLDS, 1);
        this.mPhone.setLinkCapacityReportingCriteria(LINK_CAPACITY_DOWNLINK_THRESHOLDS, LINK_CAPACITY_UPLINK_THRESHOLDS, 2);
        this.mPhone.setLinkCapacityReportingCriteria(LINK_CAPACITY_DOWNLINK_THRESHOLDS, LINK_CAPACITY_UPLINK_THRESHOLDS, 3);
        this.mPhone.setLinkCapacityReportingCriteria(LINK_CAPACITY_DOWNLINK_THRESHOLDS, LINK_CAPACITY_UPLINK_THRESHOLDS, 4);
    }

    private void setCellInfoMinInterval(int rate) {
        this.mPhone.setCellInfoMinInterval(rate);
    }

    private boolean isPowerSaveModeOn() {
        PowerManager pm = (PowerManager)this.mPhone.getContext().getSystemService("power");
        return pm.isPowerSaveMode();
    }

    private boolean isDeviceCharging() {
        BatteryManager bm = (BatteryManager)this.mPhone.getContext().getSystemService("batterymanager");
        return bm.isCharging();
    }

    private boolean isScreenOn() {
        DisplayManager dm = (DisplayManager)this.mPhone.getContext().getSystemService("display");
        Display[] displays = dm.getDisplays();
        if (displays != null) {
            for (Display display : displays) {
                if (display.getState() != 2) continue;
                this.log("Screen " + Display.typeToString(display.getType()) + " on", true);
                return true;
            }
            this.log("Screens all off", true);
            return false;
        }
        this.log("No displays found", true);
        return false;
    }

    private void log(String msg, boolean logIntoLocalLog) {
        if (logIntoLocalLog) {
            this.mLocalLog.log(msg);
        }
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        ipw.increaseIndent();
        ipw.println("mIsTetheringOn=" + this.mIsTetheringOn);
        ipw.println("mIsScreenOn=" + this.mIsScreenOn);
        ipw.println("mIsCharging=" + this.mIsCharging);
        ipw.println("mIsPowerSaveOn=" + this.mIsPowerSaveOn);
        ipw.println("mIsLowDataExpected=" + this.mIsLowDataExpected);
        ipw.println("mUnsolicitedResponseFilter=" + this.mUnsolicitedResponseFilter);
        ipw.println("mIsWifiConnected=" + this.mIsWifiConnected);
        ipw.println("Local logs:");
        ipw.increaseIndent();
        this.mLocalLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.decreaseIndent();
        ipw.flush();
    }

    private static final class AccessNetworkThresholds {
        public static final int[] GERAN = new int[]{-109, -103, -97, -89};
        public static final int[] UTRAN = new int[]{-114, -104, -94, -84};
        public static final int[] EUTRAN = new int[]{-128, -118, -108, -98};
        public static final int[] CDMA2000 = new int[]{-105, -90, -75, -65};

        private AccessNetworkThresholds() {
        }
    }
}

