/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Handler;
import android.os.Looper;
import com.android.internal.annotations.VisibleForTesting;

public class ExponentialBackoff {
    private int mRetryCounter = 0;
    private long mStartDelayMs;
    private long mMaximumDelayMs;
    private long mCurrentDelayMs;
    private int mMultiplier;
    private final Runnable mRunnable;
    private final Handler mHandler;
    private HandlerAdapter mHandlerAdapter = new HandlerAdapter(){

        @Override
        public boolean postDelayed(Runnable runnable, long delayMillis) {
            return ExponentialBackoff.this.mHandler.postDelayed(runnable, delayMillis);
        }

        @Override
        public void removeCallbacks(Runnable runnable) {
            ExponentialBackoff.this.mHandler.removeCallbacks(runnable);
        }
    };

    public ExponentialBackoff(long initialDelayMs, long maximumDelayMs, int multiplier, Looper looper, Runnable runnable) {
        this(initialDelayMs, maximumDelayMs, multiplier, new Handler(looper), runnable);
    }

    public ExponentialBackoff(long initialDelayMs, long maximumDelayMs, int multiplier, Handler handler, Runnable runnable) {
        this.mStartDelayMs = initialDelayMs;
        this.mMaximumDelayMs = maximumDelayMs;
        this.mMultiplier = multiplier;
        this.mHandler = handler;
        this.mRunnable = runnable;
    }

    public void start() {
        this.mRetryCounter = 0;
        this.mCurrentDelayMs = this.mStartDelayMs;
        this.mHandlerAdapter.removeCallbacks(this.mRunnable);
        this.mHandlerAdapter.postDelayed(this.mRunnable, this.mCurrentDelayMs);
    }

    public void stop() {
        this.mRetryCounter = 0;
        this.mHandlerAdapter.removeCallbacks(this.mRunnable);
    }

    public void notifyFailed() {
        ++this.mRetryCounter;
        long temp = Math.min(this.mMaximumDelayMs, (long)((double)this.mStartDelayMs * Math.pow(this.mMultiplier, this.mRetryCounter)));
        this.mCurrentDelayMs = (long)((1.0 + Math.random()) / 2.0 * (double)temp);
        this.mHandlerAdapter.removeCallbacks(this.mRunnable);
        this.mHandlerAdapter.postDelayed(this.mRunnable, this.mCurrentDelayMs);
    }

    public long getCurrentDelay() {
        return this.mCurrentDelayMs;
    }

    @VisibleForTesting
    public void setHandlerAdapter(HandlerAdapter a) {
        this.mHandlerAdapter = a;
    }

    public static interface HandlerAdapter {
        public boolean postDelayed(Runnable var1, long var2);

        public void removeCallbacks(Runnable var1);
    }
}

