/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.provider.Settings;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;

public class GlobalSettingsHelper {
    public static int getInt(Context context, String settingName, int subId, int defaultValue) {
        settingName = GlobalSettingsHelper.getSettingName(context, settingName, subId);
        return Settings.Global.getInt(context.getContentResolver(), settingName, defaultValue);
    }

    public static boolean getBoolean(Context context, String settingName, int subId, boolean defaultValue) {
        settingName = GlobalSettingsHelper.getSettingName(context, settingName, subId);
        return Settings.Global.getInt(context.getContentResolver(), settingName, defaultValue ? 1 : 0) == 1;
    }

    public static boolean getBoolean(Context context, String settingName, int subId) throws Settings.SettingNotFoundException {
        settingName = GlobalSettingsHelper.getSettingName(context, settingName, subId);
        return Settings.Global.getInt(context.getContentResolver(), settingName) == 1;
    }

    public static boolean setInt(Context context, String settingName, int subId, int value) {
        boolean needChange;
        settingName = GlobalSettingsHelper.getSettingName(context, settingName, subId);
        try {
            needChange = Settings.Global.getInt(context.getContentResolver(), settingName) != value;
        }
        catch (Settings.SettingNotFoundException exception) {
            needChange = true;
        }
        if (needChange) {
            Settings.Global.putInt(context.getContentResolver(), settingName, value);
        }
        return needChange;
    }

    public static boolean setBoolean(Context context, String settingName, int subId, boolean value) {
        return GlobalSettingsHelper.setInt(context, settingName, subId, value ? 1 : 0);
    }

    private static String getSettingName(Context context, String settingName, int subId) {
        if (TelephonyManager.from(context).getSimCount() > 1 && SubscriptionManager.isValidSubscriptionId(subId)) {
            return settingName + subId;
        }
        return settingName;
    }
}

