/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.GsmCdmaCallTracker;
import com.android.internal.telephony.GsmCdmaConnection;
import com.android.internal.telephony.Phone;
import java.util.List;

public class GsmCdmaCall
extends Call {
    GsmCdmaCallTracker mOwner;

    public GsmCdmaCall(GsmCdmaCallTracker owner) {
        this.mOwner = owner;
    }

    @Override
    public List<Connection> getConnections() {
        return this.mConnections;
    }

    @Override
    public Phone getPhone() {
        return this.mOwner.getPhone();
    }

    @Override
    public boolean isMultiparty() {
        return this.mConnections.size() > 1;
    }

    @Override
    public void hangup() throws CallStateException {
        this.mOwner.hangup(this);
    }

    public String toString() {
        return this.mState.toString();
    }

    public void attach(Connection conn, DriverCall dc) {
        this.mConnections.add(conn);
        this.mState = GsmCdmaCall.stateFromDCState(dc.state);
    }

    @UnsupportedAppUsage
    public void attachFake(Connection conn, Call.State state) {
        this.mConnections.add(conn);
        this.mState = state;
    }

    public boolean connectionDisconnected(GsmCdmaConnection conn) {
        if (this.mState != Call.State.DISCONNECTED) {
            boolean hasOnlyDisconnectedConnections = true;
            int s = this.mConnections.size();
            for (int i = 0; i < s; ++i) {
                if (((Connection)this.mConnections.get(i)).getState() == Call.State.DISCONNECTED) continue;
                hasOnlyDisconnectedConnections = false;
                break;
            }
            if (hasOnlyDisconnectedConnections) {
                this.mState = Call.State.DISCONNECTED;
                return true;
            }
        }
        return false;
    }

    public void detach(GsmCdmaConnection conn) {
        this.mConnections.remove(conn);
        if (this.mConnections.size() == 0) {
            this.mState = Call.State.IDLE;
        }
    }

    boolean update(GsmCdmaConnection conn, DriverCall dc) {
        boolean changed = false;
        Call.State newState = GsmCdmaCall.stateFromDCState(dc.state);
        if (newState != this.mState) {
            this.mState = newState;
            changed = true;
        }
        return changed;
    }

    boolean isFull() {
        return this.mConnections.size() == this.mOwner.getMaxConnectionsPerCall();
    }

    void onHangupLocal() {
        int s = this.mConnections.size();
        for (int i = 0; i < s; ++i) {
            GsmCdmaConnection cn = (GsmCdmaConnection)this.mConnections.get(i);
            cn.onHangupLocal();
        }
        this.mState = Call.State.DISCONNECTING;
    }
}

