/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import java.util.Objects;

public class HalVersion
implements Comparable<HalVersion> {
    public static final HalVersion UNKNOWN = new HalVersion(-1, -1);
    public final int major;
    public final int minor;

    public HalVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    @Override
    public int compareTo(HalVersion ver) {
        if (ver == null) {
            return 1;
        }
        if (this.major > ver.major) {
            return 1;
        }
        if (this.major < ver.major) {
            return -1;
        }
        if (this.minor > ver.minor) {
            return 1;
        }
        if (this.minor < ver.minor) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor);
    }

    public boolean equals(Object o) {
        return o instanceof HalVersion && (o == this || this.compareTo((HalVersion)o) == 0);
    }

    public boolean greater(HalVersion ver) {
        return this.compareTo(ver) > 0;
    }

    public boolean less(HalVersion ver) {
        return this.compareTo(ver) < 0;
    }

    public boolean greaterOrEqual(HalVersion ver) {
        return this.greater(ver) || this.equals(ver);
    }

    public boolean lessOrEqual(HalVersion ver) {
        return this.less(ver) || this.equals(ver);
    }

    public String toString() {
        return this.major + "." + this.minor;
    }
}

