/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.uicc.AdnRecord;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class IccPhoneBookInterfaceManager {
    static final String LOG_TAG = "IccPhoneBookIM";
    @UnsupportedAppUsage
    protected static final boolean DBG = true;
    @UnsupportedAppUsage
    protected Phone mPhone;
    @UnsupportedAppUsage
    protected AdnRecordCache mAdnCache;
    protected static final int EVENT_GET_SIZE_DONE = 1;
    protected static final int EVENT_LOAD_DONE = 2;
    protected static final int EVENT_UPDATE_DONE = 3;
    @UnsupportedAppUsage
    protected Handler mBaseHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            AsyncResult ar = (AsyncResult)msg.obj;
            Request request = (Request)ar.userObj;
            switch (msg.what) {
                case 1: {
                    int[] recordSize = null;
                    if (ar.exception == null) {
                        recordSize = (int[])ar.result;
                        IccPhoneBookInterfaceManager.this.logd("GET_RECORD_SIZE Size " + recordSize[0] + " total " + recordSize[1] + " #record " + recordSize[2]);
                    } else {
                        IccPhoneBookInterfaceManager.this.loge("EVENT_GET_SIZE_DONE: failed; ex=" + ar.exception);
                    }
                    this.notifyPending(request, recordSize);
                    break;
                }
                case 3: {
                    boolean success;
                    boolean bl = success = ar.exception == null;
                    if (!success) {
                        IccPhoneBookInterfaceManager.this.loge("EVENT_UPDATE_DONE - failed; ex=" + ar.exception);
                    }
                    this.notifyPending(request, success);
                    break;
                }
                case 2: {
                    List records = null;
                    if (ar.exception == null) {
                        records = (List)ar.result;
                    } else {
                        IccPhoneBookInterfaceManager.this.loge("EVENT_LOAD_DONE: Cannot load ADN records; ex=" + ar.exception);
                    }
                    this.notifyPending(request, records);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyPending(Request request, Object result) {
            if (request != null) {
                Request request2 = request;
                synchronized (request2) {
                    request.mResult = result;
                    request.mStatus.set(true);
                    request.notifyAll();
                }
            }
        }
    };

    public IccPhoneBookInterfaceManager(Phone phone) {
        this.mPhone = phone;
        IccRecords r = phone.getIccRecords();
        if (r != null) {
            this.mAdnCache = r.getAdnCache();
        }
    }

    public void dispose() {
    }

    public void updateIccRecords(IccRecords iccRecords) {
        this.mAdnCache = iccRecords != null ? iccRecords.getAdnCache() : null;
    }

    @UnsupportedAppUsage
    protected void logd(String msg) {
        Rlog.d(LOG_TAG, "[IccPbInterfaceManager] " + msg);
    }

    @UnsupportedAppUsage
    protected void loge(String msg) {
        Rlog.e(LOG_TAG, "[IccPbInterfaceManager] " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAdnRecordsInEfBySearch(int efid, String oldTag, String oldPhoneNumber, String newTag, String newPhoneNumber, String pin2) {
        Request updateRequest;
        if (this.mPhone.getContext().checkCallingOrSelfPermission("android.permission.WRITE_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.WRITE_CONTACTS permission");
        }
        this.logd("updateAdnRecordsInEfBySearch: efid=0x" + Integer.toHexString(efid).toUpperCase() + " (" + Rlog.pii(LOG_TAG, (Object)oldTag) + "," + Rlog.pii(LOG_TAG, (Object)oldPhoneNumber) + ")==> (" + Rlog.pii(LOG_TAG, (Object)newTag) + "," + Rlog.pii(LOG_TAG, (Object)newPhoneNumber) + ") pin2=" + Rlog.pii(LOG_TAG, (Object)pin2));
        efid = this.updateEfForIccType(efid);
        this.checkThread();
        Request request = updateRequest = new Request();
        synchronized (request) {
            Message response = this.mBaseHandler.obtainMessage(3, updateRequest);
            AdnRecord oldAdn = new AdnRecord(oldTag, oldPhoneNumber);
            AdnRecord newAdn = new AdnRecord(newTag, newPhoneNumber);
            if (this.mAdnCache != null) {
                this.mAdnCache.updateAdnBySearch(efid, oldAdn, newAdn, pin2, response);
                this.waitForResult(updateRequest);
            } else {
                this.loge("Failure while trying to update by search due to uninitialised adncache");
            }
        }
        return (Boolean)updateRequest.mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAdnRecordsInEfByIndex(int efid, String newTag, String newPhoneNumber, int index, String pin2) {
        Request updateRequest;
        if (this.mPhone.getContext().checkCallingOrSelfPermission("android.permission.WRITE_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.WRITE_CONTACTS permission");
        }
        this.logd("updateAdnRecordsInEfByIndex: efid=0x" + Integer.toHexString(efid).toUpperCase() + " Index=" + index + " ==> (" + Rlog.pii(LOG_TAG, (Object)newTag) + "," + Rlog.pii(LOG_TAG, (Object)newPhoneNumber) + ") pin2=" + Rlog.pii(LOG_TAG, (Object)pin2));
        this.checkThread();
        Request request = updateRequest = new Request();
        synchronized (request) {
            Message response = this.mBaseHandler.obtainMessage(3, updateRequest);
            AdnRecord newAdn = new AdnRecord(newTag, newPhoneNumber);
            if (this.mAdnCache != null) {
                this.mAdnCache.updateAdnByIndex(efid, newAdn, index, pin2, response);
                this.waitForResult(updateRequest);
            } else {
                this.loge("Failure while trying to update by index due to uninitialised adncache");
            }
        }
        return (Boolean)updateRequest.mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAdnRecordsSize(int efid) {
        Request getSizeRequest;
        this.logd("getAdnRecordsSize: efid=" + efid);
        this.checkThread();
        Request request = getSizeRequest = new Request();
        synchronized (request) {
            Message response = this.mBaseHandler.obtainMessage(1, getSizeRequest);
            IccFileHandler fh = this.mPhone.getIccFileHandler();
            if (fh != null) {
                fh.getEFLinearRecordSize(efid, response);
                this.waitForResult(getSizeRequest);
            }
        }
        return getSizeRequest.mResult == null ? new int[3] : (int[])getSizeRequest.mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AdnRecord> getAdnRecordsInEf(int efid) {
        Request loadRequest;
        if (this.mPhone.getContext().checkCallingOrSelfPermission("android.permission.READ_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.READ_CONTACTS permission");
        }
        efid = this.updateEfForIccType(efid);
        this.logd("getAdnRecordsInEF: efid=0x" + Integer.toHexString(efid).toUpperCase());
        this.checkThread();
        Request request = loadRequest = new Request();
        synchronized (request) {
            Message response = this.mBaseHandler.obtainMessage(2, loadRequest);
            if (this.mAdnCache != null) {
                this.mAdnCache.requestLoadAllAdnLike(efid, this.mAdnCache.extensionEfForEf(efid), response);
                this.waitForResult(loadRequest);
            } else {
                this.loge("Failure while trying to load from SIM due to uninitialised adncache");
            }
        }
        return (List)loadRequest.mResult;
    }

    @UnsupportedAppUsage
    protected void checkThread() {
        if (this.mBaseHandler.getLooper().equals(Looper.myLooper())) {
            this.loge("query() called on the main UI thread!");
            throw new IllegalStateException("You cannot call query on this provder from the main UI thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForResult(Request request) {
        Request request2 = request;
        synchronized (request2) {
            while (!request.mStatus.get()) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {
                    this.logd("interrupted while trying to update by search");
                }
            }
        }
    }

    @UnsupportedAppUsage
    private int updateEfForIccType(int efid) {
        if (efid == 28474 && this.mPhone.getCurrentUiccAppType() == IccCardApplicationStatus.AppType.APPTYPE_USIM) {
            return 20272;
        }
        return efid;
    }

    private static final class Request {
        AtomicBoolean mStatus = new AtomicBoolean(false);
        Object mResult = null;

        private Request() {
        }
    }
}

