/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.UserManager;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import android.util.LocalLog;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.IntRangeManager;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SmsDispatchersController;
import com.android.internal.telephony.SmsNumberUtils;
import com.android.internal.telephony.SmsPermissions;
import com.android.internal.telephony.SmsRawData;
import com.android.internal.telephony.cdma.CdmaSmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.util.HexDump;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IccSmsInterfaceManager {
    static final String LOG_TAG = "IccSmsInterfaceManager";
    static final boolean DBG = true;
    @UnsupportedAppUsage
    protected final Object mLock = new Object();
    @UnsupportedAppUsage
    protected boolean mSuccess;
    @UnsupportedAppUsage
    private List<SmsRawData> mSms;
    @UnsupportedAppUsage
    private CellBroadcastRangeManager mCellBroadcastRangeManager = new CellBroadcastRangeManager();
    private CdmaBroadcastRangeManager mCdmaBroadcastRangeManager = new CdmaBroadcastRangeManager();
    private static final int EVENT_LOAD_DONE = 1;
    private static final int EVENT_UPDATE_DONE = 2;
    protected static final int EVENT_SET_BROADCAST_ACTIVATION_DONE = 3;
    protected static final int EVENT_SET_BROADCAST_CONFIG_DONE = 4;
    private static final int SMS_CB_CODE_SCHEME_MIN = 0;
    private static final int SMS_CB_CODE_SCHEME_MAX = 255;
    public static final int SMS_MESSAGE_PRIORITY_NOT_SPECIFIED = -1;
    public static final int SMS_MESSAGE_PERIOD_NOT_SPECIFIED = -1;
    @UnsupportedAppUsage
    protected Phone mPhone;
    @UnsupportedAppUsage
    protected final Context mContext;
    @UnsupportedAppUsage
    protected final AppOpsManager mAppOps;
    @VisibleForTesting
    public SmsDispatchersController mDispatchersController;
    private SmsPermissions mSmsPermissions;
    private final LocalLog mCellBroadcastLocalLog = new LocalLog(100);
    @UnsupportedAppUsage
    protected Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = IccSmsInterfaceManager.this.mLock;
                    synchronized (object) {
                        IccSmsInterfaceManager.this.mSuccess = ar.exception == null;
                        IccSmsInterfaceManager.this.mLock.notifyAll();
                        break;
                    }
                }
                case 1: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = IccSmsInterfaceManager.this.mLock;
                    synchronized (object) {
                        if (ar.exception == null) {
                            IccSmsInterfaceManager.this.mSms = IccSmsInterfaceManager.this.buildValidRawData((ArrayList)ar.result);
                            IccSmsInterfaceManager.this.markMessagesAsRead((ArrayList)ar.result);
                        } else {
                            if (Rlog.isLoggable("SMS", 3)) {
                                IccSmsInterfaceManager.this.log("Cannot load Sms records");
                            }
                            IccSmsInterfaceManager.this.mSms = null;
                        }
                        IccSmsInterfaceManager.this.mLock.notifyAll();
                        break;
                    }
                }
                case 3: 
                case 4: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = IccSmsInterfaceManager.this.mLock;
                    synchronized (object) {
                        IccSmsInterfaceManager.this.mSuccess = ar.exception == null;
                        IccSmsInterfaceManager.this.mLock.notifyAll();
                        break;
                    }
                }
            }
        }
    };

    protected IccSmsInterfaceManager(Phone phone) {
        this(phone, phone.getContext(), (AppOpsManager)phone.getContext().getSystemService("appops"), (UserManager)phone.getContext().getSystemService("user"), new SmsDispatchersController(phone, phone.mSmsStorageMonitor, phone.mSmsUsageMonitor));
    }

    @VisibleForTesting
    public IccSmsInterfaceManager(Phone phone, Context context, AppOpsManager appOps, UserManager userManager, SmsDispatchersController dispatchersController) {
        this.mPhone = phone;
        this.mContext = context;
        this.mAppOps = appOps;
        this.mDispatchersController = dispatchersController;
        this.mSmsPermissions = new SmsPermissions(phone, context, appOps);
    }

    protected void markMessagesAsRead(ArrayList<byte[]> messages) {
        if (messages == null) {
            return;
        }
        IccFileHandler fh = this.mPhone.getIccFileHandler();
        if (fh == null) {
            if (Rlog.isLoggable("SMS", 3)) {
                this.log("markMessagesAsRead - aborting, no icc card present.");
            }
            return;
        }
        int count = messages.size();
        for (int i = 0; i < count; ++i) {
            byte[] ba = messages.get(i);
            if (ba[0] != 3) continue;
            int n = ba.length;
            byte[] nba = new byte[n - 1];
            System.arraycopy(ba, 1, nba, 0, n - 1);
            byte[] record = this.makeSmsRecordData(1, nba);
            fh.updateEFLinearFixed(28476, i + 1, record, null, null);
            if (!Rlog.isLoggable("SMS", 3)) continue;
            this.log("SMS " + (i + 1) + " marked as read");
        }
    }

    @UnsupportedAppUsage
    protected void enforceReceiveAndSend(String message) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.RECEIVE_SMS", message);
        this.mContext.enforceCallingOrSelfPermission("android.permission.SEND_SMS", message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public boolean updateMessageOnIccEf(String callingPackage, int index, int status, byte[] pdu) {
        this.log("updateMessageOnIccEf: index=" + index + " status=" + status + " ==> (" + Arrays.toString(pdu) + ")");
        this.enforceReceiveAndSend("Updating message on Icc");
        if (this.mAppOps.noteOp(22, Binder.getCallingUid(), callingPackage) != 0) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message response = this.mHandler.obtainMessage(2);
            if ((status & 1) == 0) {
                if (1 == this.mPhone.getPhoneType()) {
                    this.mPhone.mCi.deleteSmsOnSim(index, response);
                } else {
                    this.mPhone.mCi.deleteSmsOnRuim(index, response);
                }
            } else {
                IccFileHandler fh = this.mPhone.getIccFileHandler();
                if (fh == null) {
                    response.recycle();
                    return this.mSuccess;
                }
                byte[] record = this.makeSmsRecordData(status, pdu);
                fh.updateEFLinearFixed(28476, index, record, null, response);
            }
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to update by index");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public boolean copyMessageToIccEf(String callingPackage, int status, byte[] pdu, byte[] smsc) {
        this.log("copyMessageToIccEf: status=" + status + " ==> pdu=(" + Arrays.toString(pdu) + "), smsc=(" + Arrays.toString(smsc) + ")");
        this.enforceReceiveAndSend("Copying message to Icc");
        if (this.mAppOps.noteOp(22, Binder.getCallingUid(), callingPackage) != 0) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message response = this.mHandler.obtainMessage(2);
            if (1 == this.mPhone.getPhoneType()) {
                this.mPhone.mCi.writeSmsToSim(status, IccUtils.bytesToHexString(smsc), IccUtils.bytesToHexString(pdu), response);
            } else {
                this.mPhone.mCi.writeSmsToRuim(status, IccUtils.bytesToHexString(pdu), response);
            }
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to update by index");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public List<SmsRawData> getAllMessagesFromIccEf(String callingPackage) {
        this.log("getAllMessagesFromEF");
        this.mContext.enforceCallingOrSelfPermission("android.permission.RECEIVE_SMS", "Reading messages from Icc");
        if (this.mAppOps.noteOp(21, Binder.getCallingUid(), callingPackage) != 0) {
            return new ArrayList<SmsRawData>();
        }
        Object object = this.mLock;
        synchronized (object) {
            IccFileHandler fh = this.mPhone.getIccFileHandler();
            if (fh == null) {
                Rlog.e(LOG_TAG, "Cannot load Sms records. No icc card?");
                this.mSms = null;
                return this.mSms;
            }
            Message response = this.mHandler.obtainMessage(1);
            fh.loadEFLinearFixedAll(28476, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to load from the Icc");
            }
        }
        return this.mSms;
    }

    public void sendDataWithSelfPermissions(String callingPackage, String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean isForVvm) {
        if (!this.mSmsPermissions.checkCallingOrSelfCanSendSms(callingPackage, "Sending SMS message")) {
            this.returnUnspecifiedFailure(sentIntent);
            return;
        }
        this.sendDataInternal(callingPackage, destAddr, scAddr, destPort, data, sentIntent, deliveryIntent, isForVvm);
    }

    @UnsupportedAppUsage
    public void sendData(String callingPackage, String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (!this.mSmsPermissions.checkCallingCanSendSms(callingPackage, "Sending SMS message")) {
            this.returnUnspecifiedFailure(sentIntent);
            return;
        }
        this.sendDataInternal(callingPackage, destAddr, scAddr, destPort, data, sentIntent, deliveryIntent, false);
    }

    private void sendDataInternal(String callingPackage, String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean isForVvm) {
        if (Rlog.isLoggable("SMS", 2)) {
            this.log("sendData: destAddr=" + destAddr + " scAddr=" + scAddr + " destPort=" + destPort + " data='" + HexDump.toHexString(data) + "' sentIntent=" + sentIntent + " deliveryIntent=" + deliveryIntent + " isForVVM=" + isForVvm);
        }
        destAddr = this.filterDestAddress(destAddr);
        this.mDispatchersController.sendData(callingPackage, destAddr, scAddr, destPort, data, sentIntent, deliveryIntent, isForVvm);
    }

    public void sendText(String callingPackage, String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean persistMessageForNonDefaultSmsApp) {
        this.sendTextInternal(callingPackage, destAddr, scAddr, text, sentIntent, deliveryIntent, persistMessageForNonDefaultSmsApp, -1, false, -1, false);
    }

    public void sendTextWithSelfPermissions(String callingPackage, String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean persistMessage, boolean isForVvm) {
        if (!this.mSmsPermissions.checkCallingOrSelfCanSendSms(callingPackage, "Sending SMS message")) {
            this.returnUnspecifiedFailure(sentIntent);
            return;
        }
        this.sendTextInternal(callingPackage, destAddr, scAddr, text, sentIntent, deliveryIntent, persistMessage, -1, false, -1, isForVvm);
    }

    private void sendTextInternal(String callingPackage, String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean persistMessageForNonDefaultSmsApp, int priority, boolean expectMore, int validityPeriod, boolean isForVvm) {
        if (Rlog.isLoggable("SMS", 2)) {
            this.log("sendText: destAddr=" + destAddr + " scAddr=" + scAddr + " text='" + text + "' sentIntent=" + sentIntent + " deliveryIntent=" + deliveryIntent + " priority=" + priority + " expectMore=" + expectMore + " validityPeriod=" + validityPeriod + " isForVVM=" + isForVvm);
        }
        destAddr = this.filterDestAddress(destAddr);
        this.mDispatchersController.sendText(destAddr, scAddr, text, sentIntent, deliveryIntent, null, callingPackage, persistMessageForNonDefaultSmsApp, priority, expectMore, validityPeriod, isForVvm);
    }

    public void sendTextWithOptions(String callingPackage, String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean persistMessageForNonDefaultSmsApp, int priority, boolean expectMore, int validityPeriod) {
        if (!this.mSmsPermissions.checkCallingOrSelfCanSendSms(callingPackage, "Sending SMS message")) {
            this.returnUnspecifiedFailure(sentIntent);
            return;
        }
        this.sendTextInternal(callingPackage, destAddr, scAddr, text, sentIntent, deliveryIntent, persistMessageForNonDefaultSmsApp, priority, expectMore, validityPeriod, false);
    }

    @UnsupportedAppUsage
    public void injectSmsPdu(byte[] pdu, String format, PendingIntent receivedIntent) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            this.mSmsPermissions.enforceCallerIsImsAppOrCarrierApp("injectSmsPdu");
        }
        if (Rlog.isLoggable("SMS", 2)) {
            this.log("pdu: " + pdu + "\n format=" + format + "\n receivedIntent=" + receivedIntent);
        }
        this.mDispatchersController.injectSmsPdu(pdu, format, (int result) -> {
            if (receivedIntent != null) {
                try {
                    receivedIntent.send(result);
                }
                catch (PendingIntent.CanceledException e) {
                    Rlog.d(LOG_TAG, "receivedIntent cancelled.");
                }
            }
        });
    }

    public void sendMultipartText(String callingPackage, String destAddr, String scAddr, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents, boolean persistMessageForNonDefaultSmsApp) {
        this.sendMultipartTextWithOptions(callingPackage, destAddr, scAddr, parts, sentIntents, deliveryIntents, persistMessageForNonDefaultSmsApp, -1, false, -1);
    }

    public void sendMultipartTextWithOptions(String callingPackage, String destAddr, String scAddr, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents, boolean persistMessageForNonDefaultSmsApp, int priority, boolean expectMore, int validityPeriod) {
        int i;
        if (!this.mSmsPermissions.checkCallingCanSendText(persistMessageForNonDefaultSmsApp, callingPackage, "Sending SMS message")) {
            this.returnUnspecifiedFailure(sentIntents);
            return;
        }
        if (Rlog.isLoggable("SMS", 2)) {
            i = 0;
            for (String part : parts) {
                this.log("sendMultipartTextWithOptions: destAddr=" + destAddr + ", srAddr=" + scAddr + ", part[" + i++ + "]=" + part);
            }
        }
        destAddr = this.filterDestAddress(destAddr);
        if (parts.size() > 1 && parts.size() < 10 && !SmsMessage.hasEmsSupport()) {
            for (i = 0; i < parts.size(); ++i) {
                String singlePart = parts.get(i);
                singlePart = SmsMessage.shouldAppendPageNumberAsPrefix() ? String.valueOf(i + 1) + '/' + parts.size() + ' ' + singlePart : singlePart.concat(' ' + String.valueOf(i + 1) + '/' + parts.size());
                PendingIntent singleSentIntent = null;
                if (sentIntents != null && sentIntents.size() > i) {
                    singleSentIntent = sentIntents.get(i);
                }
                PendingIntent singleDeliveryIntent = null;
                if (deliveryIntents != null && deliveryIntents.size() > i) {
                    singleDeliveryIntent = deliveryIntents.get(i);
                }
                this.mDispatchersController.sendText(destAddr, scAddr, singlePart, singleSentIntent, singleDeliveryIntent, null, callingPackage, persistMessageForNonDefaultSmsApp, priority, expectMore, validityPeriod, false);
            }
            return;
        }
        this.mDispatchersController.sendMultipartText(destAddr, scAddr, (ArrayList)parts, (ArrayList)sentIntents, (ArrayList)deliveryIntents, null, callingPackage, persistMessageForNonDefaultSmsApp, priority, expectMore, validityPeriod);
    }

    @UnsupportedAppUsage
    public int getPremiumSmsPermission(String packageName) {
        return this.mDispatchersController.getPremiumSmsPermission(packageName);
    }

    @UnsupportedAppUsage
    public void setPremiumSmsPermission(String packageName, int permission2) {
        this.mDispatchersController.setPremiumSmsPermission(packageName, permission2);
    }

    protected ArrayList<SmsRawData> buildValidRawData(ArrayList<byte[]> messages) {
        int count = messages.size();
        ArrayList<SmsRawData> ret = new ArrayList<SmsRawData>(count);
        for (int i = 0; i < count; ++i) {
            byte[] ba = messages.get(i);
            if ((ba[0] & 1) == 0) {
                ret.add(null);
                continue;
            }
            ret.add(new SmsRawData(messages.get(i)));
        }
        return ret;
    }

    protected byte[] makeSmsRecordData(int status, byte[] pdu) {
        byte[] data = 1 == this.mPhone.getPhoneType() ? new byte[176] : new byte[255];
        data[0] = (byte)(status & 7);
        System.arraycopy(pdu, 0, data, 1, pdu.length);
        for (int j = pdu.length + 1; j < data.length; ++j) {
            data[j] = -1;
        }
        return data;
    }

    public boolean enableCellBroadcast(int messageIdentifier, int ranType) {
        return this.enableCellBroadcastRange(messageIdentifier, messageIdentifier, ranType);
    }

    public boolean disableCellBroadcast(int messageIdentifier, int ranType) {
        return this.disableCellBroadcastRange(messageIdentifier, messageIdentifier, ranType);
    }

    public boolean enableCellBroadcastRange(int startMessageId, int endMessageId, int ranType) {
        if (ranType == 0) {
            return this.enableGsmBroadcastRange(startMessageId, endMessageId);
        }
        if (ranType == 1) {
            return this.enableCdmaBroadcastRange(startMessageId, endMessageId);
        }
        throw new IllegalArgumentException("Not a supported RAN Type");
    }

    public boolean disableCellBroadcastRange(int startMessageId, int endMessageId, int ranType) {
        if (ranType == 0) {
            return this.disableGsmBroadcastRange(startMessageId, endMessageId);
        }
        if (ranType == 1) {
            return this.disableCdmaBroadcastRange(startMessageId, endMessageId);
        }
        throw new IllegalArgumentException("Not a supported RAN Type");
    }

    @UnsupportedAppUsage
    public synchronized boolean enableGsmBroadcastRange(int startMessageId, int endMessageId) {
        this.mContext.enforceCallingPermission("android.permission.RECEIVE_SMS", "Enabling cell broadcast SMS");
        String client = this.mContext.getPackageManager().getNameForUid(Binder.getCallingUid());
        if (!this.mCellBroadcastRangeManager.enableRange(startMessageId, endMessageId, client)) {
            String msg = "Failed to add GSM cell broadcast channels range " + startMessageId + " to " + endMessageId;
            this.log(msg);
            this.mCellBroadcastLocalLog.log(msg);
            return false;
        }
        String msg = "Added GSM cell broadcast channels range " + startMessageId + " to " + endMessageId;
        this.log(msg);
        this.mCellBroadcastLocalLog.log(msg);
        this.setCellBroadcastActivation(!this.mCellBroadcastRangeManager.isEmpty());
        return true;
    }

    @UnsupportedAppUsage
    public synchronized boolean disableGsmBroadcastRange(int startMessageId, int endMessageId) {
        this.mContext.enforceCallingPermission("android.permission.RECEIVE_SMS", "Disabling cell broadcast SMS");
        String client = this.mContext.getPackageManager().getNameForUid(Binder.getCallingUid());
        if (!this.mCellBroadcastRangeManager.disableRange(startMessageId, endMessageId, client)) {
            String msg = "Failed to remove GSM cell broadcast channels range " + startMessageId + " to " + endMessageId;
            this.log(msg);
            this.mCellBroadcastLocalLog.log(msg);
            return false;
        }
        String msg = "Removed GSM cell broadcast channels range " + startMessageId + " to " + endMessageId;
        this.log(msg);
        this.mCellBroadcastLocalLog.log(msg);
        this.setCellBroadcastActivation(!this.mCellBroadcastRangeManager.isEmpty());
        return true;
    }

    @UnsupportedAppUsage
    public synchronized boolean enableCdmaBroadcastRange(int startMessageId, int endMessageId) {
        this.mContext.enforceCallingPermission("android.permission.RECEIVE_SMS", "Enabling cdma broadcast SMS");
        String client = this.mContext.getPackageManager().getNameForUid(Binder.getCallingUid());
        if (!this.mCdmaBroadcastRangeManager.enableRange(startMessageId, endMessageId, client)) {
            String msg = "Failed to add cdma broadcast channels range " + startMessageId + " to " + endMessageId;
            this.log(msg);
            this.mCellBroadcastLocalLog.log(msg);
            return false;
        }
        String msg = "Added cdma broadcast channels range " + startMessageId + " to " + endMessageId;
        this.log(msg);
        this.mCellBroadcastLocalLog.log(msg);
        this.setCdmaBroadcastActivation(!this.mCdmaBroadcastRangeManager.isEmpty());
        return true;
    }

    @UnsupportedAppUsage
    public synchronized boolean disableCdmaBroadcastRange(int startMessageId, int endMessageId) {
        this.mContext.enforceCallingPermission("android.permission.RECEIVE_SMS", "Disabling cell broadcast SMS");
        String client = this.mContext.getPackageManager().getNameForUid(Binder.getCallingUid());
        if (!this.mCdmaBroadcastRangeManager.disableRange(startMessageId, endMessageId, client)) {
            String msg = "Failed to remove cdma broadcast channels range " + startMessageId + " to " + endMessageId;
            this.log(msg);
            this.mCellBroadcastLocalLog.log(msg);
            return false;
        }
        String msg = "Removed cdma broadcast channels range " + startMessageId + " to " + endMessageId;
        this.log(msg);
        this.mCellBroadcastLocalLog.log(msg);
        this.setCdmaBroadcastActivation(!this.mCdmaBroadcastRangeManager.isEmpty());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private boolean setCellBroadcastConfig(SmsBroadcastConfigInfo[] configs) {
        this.log("Calling setGsmBroadcastConfig with " + configs.length + " configurations");
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(4);
            this.mSuccess = false;
            this.mPhone.mCi.setGsmBroadcastConfig(configs, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to set cell broadcast config");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCellBroadcastActivation(boolean activate) {
        this.log("Calling setCellBroadcastActivation(" + activate + ')');
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(3);
            this.mSuccess = false;
            this.mPhone.mCi.setGsmBroadcastActivation(activate, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to set cell broadcast activation");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private boolean setCdmaBroadcastConfig(CdmaSmsBroadcastConfigInfo[] configs) {
        this.log("Calling setCdmaBroadcastConfig with " + configs.length + " configurations");
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(4);
            this.mSuccess = false;
            this.mPhone.mCi.setCdmaBroadcastConfig(configs, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to set cdma broadcast config");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCdmaBroadcastActivation(boolean activate) {
        this.log("Calling setCdmaBroadcastActivation(" + activate + ")");
        Object object = this.mLock;
        synchronized (object) {
            Message response = this.mHandler.obtainMessage(3);
            this.mSuccess = false;
            this.mPhone.mCi.setCdmaBroadcastActivation(activate, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.log("interrupted while trying to set cdma broadcast activation");
            }
        }
        return this.mSuccess;
    }

    @UnsupportedAppUsage
    protected void log(String msg) {
        Log.d(LOG_TAG, "[IccSmsInterfaceManager] " + msg);
    }

    @UnsupportedAppUsage
    public boolean isImsSmsSupported() {
        return this.mDispatchersController.isIms();
    }

    @UnsupportedAppUsage
    public String getImsSmsFormat() {
        return this.mDispatchersController.getImsSmsFormat();
    }

    @UnsupportedAppUsage
    public void sendStoredText(String callingPkg, Uri messageUri, String scAddress, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        ContentResolver resolver;
        if (!this.mSmsPermissions.checkCallingCanSendSms(callingPkg, "Sending SMS message")) {
            this.returnUnspecifiedFailure(sentIntent);
            return;
        }
        if (Rlog.isLoggable("SMS", 2)) {
            this.log("sendStoredText: scAddr=" + scAddress + " messageUri=" + messageUri + " sentIntent=" + sentIntent + " deliveryIntent=" + deliveryIntent);
        }
        if (!this.isFailedOrDraft(resolver = this.mContext.getContentResolver(), messageUri)) {
            Log.e(LOG_TAG, "[IccSmsInterfaceManager]sendStoredText: not FAILED or DRAFT message");
            this.returnUnspecifiedFailure(sentIntent);
            return;
        }
        String[] textAndAddress = this.loadTextAndAddress(resolver, messageUri);
        if (textAndAddress == null) {
            Log.e(LOG_TAG, "[IccSmsInterfaceManager]sendStoredText: can not load text");
            this.returnUnspecifiedFailure(sentIntent);
            return;
        }
        textAndAddress[1] = this.filterDestAddress(textAndAddress[1]);
        this.mDispatchersController.sendText(textAndAddress[1], scAddress, textAndAddress[0], sentIntent, deliveryIntent, messageUri, callingPkg, true, -1, false, -1, false);
    }

    @UnsupportedAppUsage
    public void sendStoredMultipartText(String callingPkg, Uri messageUri, String scAddress, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents) {
        if (!this.mSmsPermissions.checkCallingCanSendSms(callingPkg, "Sending SMS message")) {
            this.returnUnspecifiedFailure(sentIntents);
            return;
        }
        ContentResolver resolver = this.mContext.getContentResolver();
        if (!this.isFailedOrDraft(resolver, messageUri)) {
            Log.e(LOG_TAG, "[IccSmsInterfaceManager]sendStoredMultipartText: not FAILED or DRAFT message");
            this.returnUnspecifiedFailure(sentIntents);
            return;
        }
        String[] textAndAddress = this.loadTextAndAddress(resolver, messageUri);
        if (textAndAddress == null) {
            Log.e(LOG_TAG, "[IccSmsInterfaceManager]sendStoredMultipartText: can not load text");
            this.returnUnspecifiedFailure(sentIntents);
            return;
        }
        ArrayList<String> parts = SmsManager.getDefault().divideMessage(textAndAddress[0]);
        if (parts == null || parts.size() < 1) {
            Log.e(LOG_TAG, "[IccSmsInterfaceManager]sendStoredMultipartText: can not divide text");
            this.returnUnspecifiedFailure(sentIntents);
            return;
        }
        textAndAddress[1] = this.filterDestAddress(textAndAddress[1]);
        if (parts.size() > 1 && parts.size() < 10 && !SmsMessage.hasEmsSupport()) {
            for (int i = 0; i < parts.size(); ++i) {
                String singlePart = parts.get(i);
                singlePart = SmsMessage.shouldAppendPageNumberAsPrefix() ? String.valueOf(i + 1) + '/' + parts.size() + ' ' + singlePart : singlePart.concat(' ' + String.valueOf(i + 1) + '/' + parts.size());
                PendingIntent singleSentIntent = null;
                if (sentIntents != null && sentIntents.size() > i) {
                    singleSentIntent = sentIntents.get(i);
                }
                PendingIntent singleDeliveryIntent = null;
                if (deliveryIntents != null && deliveryIntents.size() > i) {
                    singleDeliveryIntent = deliveryIntents.get(i);
                }
                this.mDispatchersController.sendText(textAndAddress[1], scAddress, singlePart, singleSentIntent, singleDeliveryIntent, messageUri, callingPkg, true, -1, false, -1, false);
            }
            return;
        }
        this.mDispatchersController.sendMultipartText(textAndAddress[1], scAddress, parts, (ArrayList)sentIntents, (ArrayList)deliveryIntents, messageUri, callingPkg, true, -1, false, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFailedOrDraft(ContentResolver resolver, Uri messageUri) {
        long identity = Binder.clearCallingIdentity();
        Cursor cursor = null;
        try {
            cursor = resolver.query(messageUri, new String[]{"type"}, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                int type = cursor.getInt(0);
                boolean bl = type == 3 || type == 5;
                return bl;
            }
        }
        catch (SQLiteException e) {
            Log.e(LOG_TAG, "[IccSmsInterfaceManager]isFailedOrDraft: query message type failed", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            Binder.restoreCallingIdentity(identity);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] loadTextAndAddress(ContentResolver resolver, Uri messageUri) {
        long identity = Binder.clearCallingIdentity();
        Cursor cursor = null;
        try {
            cursor = resolver.query(messageUri, new String[]{"body", "address"}, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                String[] stringArray = new String[]{cursor.getString(0), cursor.getString(1)};
                return stringArray;
            }
        }
        catch (SQLiteException e) {
            Log.e(LOG_TAG, "[IccSmsInterfaceManager]loadText: query message text failed", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            Binder.restoreCallingIdentity(identity);
        }
        return null;
    }

    private void returnUnspecifiedFailure(PendingIntent pi) {
        if (pi != null) {
            try {
                pi.send(1);
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
        }
    }

    private void returnUnspecifiedFailure(List<PendingIntent> pis) {
        if (pis == null) {
            return;
        }
        for (PendingIntent pi : pis) {
            this.returnUnspecifiedFailure(pi);
        }
    }

    @UnsupportedAppUsage
    private String filterDestAddress(String destAddr) {
        String result = null;
        result = SmsNumberUtils.filterDestAddr(this.mPhone, destAddr);
        return result != null ? result : destAddr;
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("CellBroadcast log:");
        this.mCellBroadcastLocalLog.dump(fd, pw, args);
        pw.println("SMS dispatcher controller log:");
        this.mDispatchersController.dump(fd, pw, args);
        pw.flush();
    }

    class CdmaBroadcastRangeManager
    extends IntRangeManager {
        private ArrayList<CdmaSmsBroadcastConfigInfo> mConfigList = new ArrayList();

        CdmaBroadcastRangeManager() {
        }

        @Override
        protected void startUpdate() {
            this.mConfigList.clear();
        }

        @Override
        protected void addRange(int startId, int endId, boolean selected) {
            this.mConfigList.add(new CdmaSmsBroadcastConfigInfo(startId, endId, 1, selected));
        }

        @Override
        protected boolean finishUpdate() {
            if (this.mConfigList.isEmpty()) {
                return true;
            }
            CdmaSmsBroadcastConfigInfo[] configs = this.mConfigList.toArray(new CdmaSmsBroadcastConfigInfo[this.mConfigList.size()]);
            return IccSmsInterfaceManager.this.setCdmaBroadcastConfig(configs);
        }
    }

    class CellBroadcastRangeManager
    extends IntRangeManager {
        private ArrayList<SmsBroadcastConfigInfo> mConfigList = new ArrayList();

        CellBroadcastRangeManager() {
        }

        @Override
        protected void startUpdate() {
            this.mConfigList.clear();
        }

        @Override
        protected void addRange(int startId, int endId, boolean selected) {
            this.mConfigList.add(new SmsBroadcastConfigInfo(startId, endId, 0, 255, selected));
        }

        @Override
        protected boolean finishUpdate() {
            if (this.mConfigList.isEmpty()) {
                return true;
            }
            SmsBroadcastConfigInfo[] configs = this.mConfigList.toArray(new SmsBroadcastConfigInfo[this.mConfigList.size()]);
            return IccSmsInterfaceManager.this.setCellBroadcastConfig(configs);
        }
    }
}

