/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Binder;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.telephony.CarrierConfigManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.SmsMessage;
import android.telephony.ims.ImsMmTelManager;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.aidl.IImsSmsListener;
import android.telephony.ims.feature.MmTelFeature;
import android.util.Pair;
import com.android.ims.ImsException;
import com.android.ims.ImsManager;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsDispatchersController;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.util.SMSDispatcherUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ImsSmsDispatcher
extends SMSDispatcher {
    private static final String TAG = "ImsSmsDispacher";
    @VisibleForTesting
    public Map<Integer, SMSDispatcher.SmsTracker> mTrackers = new ConcurrentHashMap<Integer, SMSDispatcher.SmsTracker>();
    @VisibleForTesting
    public AtomicInteger mNextToken = new AtomicInteger();
    private final Object mLock = new Object();
    private volatile boolean mIsSmsCapable;
    private volatile boolean mIsImsServiceUp;
    private volatile boolean mIsRegistered;
    private final ImsManager.Connector mImsManagerConnector;
    private TelephonyMetrics mMetrics = TelephonyMetrics.getInstance();
    private ImsMmTelManager.RegistrationCallback mRegistrationCallback = new ImsMmTelManager.RegistrationCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRegistered(int imsRadioTech) {
            Rlog.d(ImsSmsDispatcher.TAG, "onImsConnected imsRadioTech=" + imsRadioTech);
            Object object = ImsSmsDispatcher.this.mLock;
            synchronized (object) {
                ImsSmsDispatcher.this.mIsRegistered = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRegistering(int imsRadioTech) {
            Rlog.d(ImsSmsDispatcher.TAG, "onImsProgressing imsRadioTech=" + imsRadioTech);
            Object object = ImsSmsDispatcher.this.mLock;
            synchronized (object) {
                ImsSmsDispatcher.this.mIsRegistered = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUnregistered(ImsReasonInfo info) {
            Rlog.d(ImsSmsDispatcher.TAG, "onImsDisconnected imsReasonInfo=" + info);
            Object object = ImsSmsDispatcher.this.mLock;
            synchronized (object) {
                ImsSmsDispatcher.this.mIsRegistered = false;
            }
        }
    };
    private ImsMmTelManager.CapabilityCallback mCapabilityCallback = new ImsMmTelManager.CapabilityCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCapabilitiesStatusChanged(MmTelFeature.MmTelCapabilities capabilities) {
            Object object = ImsSmsDispatcher.this.mLock;
            synchronized (object) {
                ImsSmsDispatcher.this.mIsSmsCapable = capabilities.isCapable(8);
            }
        }
    };
    private final IImsSmsListener mImsSmsListener = new IImsSmsListener.Stub(){

        @Override
        public void onSendSmsResult(int token, int messageRef, int status, int reason) throws RemoteException {
            Rlog.d(ImsSmsDispatcher.TAG, "onSendSmsResult token=" + token + " messageRef=" + messageRef + " status=" + status + " reason=" + reason);
            ImsSmsDispatcher.this.mMetrics.writeOnImsServiceSmsSolicitedResponse(ImsSmsDispatcher.this.mPhone.getPhoneId(), status, reason);
            SMSDispatcher.SmsTracker tracker = ImsSmsDispatcher.this.mTrackers.get(token);
            if (tracker == null) {
                throw new IllegalArgumentException("Invalid token.");
            }
            tracker.mMessageRef = messageRef;
            switch (status) {
                case 1: {
                    tracker.onSent(ImsSmsDispatcher.this.mContext);
                    ImsSmsDispatcher.this.mPhone.notifySmsSent(tracker.mDestAddress);
                    break;
                }
                case 2: {
                    tracker.onFailed(ImsSmsDispatcher.this.mContext, reason, 0);
                    ImsSmsDispatcher.this.mTrackers.remove(token);
                    break;
                }
                case 3: {
                    ++tracker.mRetryCount;
                    ImsSmsDispatcher.this.sendSms(tracker);
                    break;
                }
                case 4: {
                    ++tracker.mRetryCount;
                    ImsSmsDispatcher.this.fallbackToPstn(token, tracker);
                    break;
                }
            }
        }

        @Override
        public void onSmsStatusReportReceived(int token, int messageRef, String format, byte[] pdu) throws RemoteException {
            Rlog.d(ImsSmsDispatcher.TAG, "Status report received.");
            SMSDispatcher.SmsTracker tracker = ImsSmsDispatcher.this.mTrackers.get(token);
            if (tracker == null) {
                throw new RemoteException("Invalid token.");
            }
            Pair<Boolean, Boolean> result = ImsSmsDispatcher.this.mSmsDispatchersController.handleSmsStatusReport(tracker, format, pdu);
            Rlog.d(ImsSmsDispatcher.TAG, "Status report handle result, success: " + result.first + "complete: " + result.second);
            try {
                ImsSmsDispatcher.this.getImsManager().acknowledgeSmsReport(token, messageRef, (Boolean)result.first != false ? 1 : 2);
            }
            catch (ImsException e) {
                Rlog.e(ImsSmsDispatcher.TAG, "Failed to acknowledgeSmsReport(). Error: " + e.getMessage());
            }
            if (((Boolean)result.second).booleanValue()) {
                ImsSmsDispatcher.this.mTrackers.remove(token);
            }
        }

        @Override
        public void onSmsReceived(int token, String format, byte[] pdu) {
            Rlog.d(ImsSmsDispatcher.TAG, "SMS received.");
            SmsMessage message = SmsMessage.createFromPdu(pdu, format);
            ImsSmsDispatcher.this.mSmsDispatchersController.injectSmsPdu(message, format, result -> {
                int mappedResult;
                Rlog.d(ImsSmsDispatcher.TAG, "SMS handled result: " + result);
                switch (result) {
                    case 1: {
                        mappedResult = 1;
                        break;
                    }
                    case 3: {
                        mappedResult = 3;
                        break;
                    }
                    case 4: {
                        mappedResult = 4;
                        break;
                    }
                    default: {
                        mappedResult = 2;
                    }
                }
                try {
                    if (message != null && message.mWrappedSmsMessage != null) {
                        ImsSmsDispatcher.this.getImsManager().acknowledgeSms(token, message.mWrappedSmsMessage.mMessageRef, mappedResult);
                    } else {
                        Rlog.w(ImsSmsDispatcher.TAG, "SMS Received with a PDU that could not be parsed.");
                        ImsSmsDispatcher.this.getImsManager().acknowledgeSms(token, 0, mappedResult);
                    }
                }
                catch (ImsException e) {
                    Rlog.e(ImsSmsDispatcher.TAG, "Failed to acknowledgeSms(). Error: " + e.getMessage());
                }
            }, true);
        }
    };

    public ImsSmsDispatcher(Phone phone, SmsDispatchersController smsDispatchersController) {
        super(phone, smsDispatchersController);
        this.mImsManagerConnector = new ImsManager.Connector(this.mContext, this.mPhone.getPhoneId(), new ImsManager.Connector.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectionReady(ImsManager manager) throws ImsException {
                Rlog.d(ImsSmsDispatcher.TAG, "ImsManager: connection ready.");
                Object object = ImsSmsDispatcher.this.mLock;
                synchronized (object) {
                    ImsSmsDispatcher.this.setListeners();
                    ImsSmsDispatcher.this.mIsImsServiceUp = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectionUnavailable() {
                Rlog.d(ImsSmsDispatcher.TAG, "ImsManager: connection unavailable.");
                Object object = ImsSmsDispatcher.this.mLock;
                synchronized (object) {
                    ImsSmsDispatcher.this.mIsImsServiceUp = false;
                }
            }
        });
        this.mImsManagerConnector.connect();
    }

    private void setListeners() throws ImsException {
        this.getImsManager().addRegistrationCallback(this.mRegistrationCallback);
        this.getImsManager().addCapabilitiesCallback(this.mCapabilityCallback);
        this.getImsManager().setSmsListener(this.getSmsListener());
        this.getImsManager().onSmsReady();
    }

    private boolean isLteService() {
        return this.mPhone.getServiceState().getRilVoiceRadioTechnology() == 14 && this.mPhone.getServiceState().getState() == 0;
    }

    private boolean isLimitedLteService() {
        return this.mPhone.getServiceState().getRilVoiceRadioTechnology() == 14 && this.mPhone.getServiceState().isEmergencyOnly();
    }

    private boolean isEmergencySmsPossible() {
        return this.isLteService() || this.isLimitedLteService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmergencySmsSupport(String destAddr) {
        boolean eSmsCarrierSupport = false;
        if (!PhoneNumberUtils.isLocalEmergencyNumber(this.mContext, this.mPhone.getSubId(), destAddr)) {
            Rlog.e(TAG, "Emergency Sms is not supported for: " + Rlog.pii(TAG, (Object)destAddr));
            return false;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
            if (configManager == null) {
                Rlog.e(TAG, "configManager is null");
                boolean bl = false;
                return bl;
            }
            PersistableBundle b = configManager.getConfigForSubId(this.getSubId());
            if (b == null) {
                Rlog.e(TAG, "PersistableBundle is null");
                boolean bl = false;
                return bl;
            }
            eSmsCarrierSupport = b.getBoolean("support_emergency_sms_over_ims_bool");
            boolean lteOrLimitedLte = this.isEmergencySmsPossible();
            Rlog.i(TAG, "isEmergencySmsSupport emergencySmsCarrierSupport: " + eSmsCarrierSupport + " destAddr: " + Rlog.pii(TAG, (Object)destAddr) + " mIsImsServiceUp: " + this.mIsImsServiceUp + " lteOrLimitedLte: " + lteOrLimitedLte);
            boolean bl = eSmsCarrierSupport && this.mIsImsServiceUp && lteOrLimitedLte;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable() {
        Object object = this.mLock;
        synchronized (object) {
            Rlog.d(TAG, "isAvailable: up=" + this.mIsImsServiceUp + ", reg= " + this.mIsRegistered + ", cap= " + this.mIsSmsCapable);
            return this.mIsImsServiceUp && this.mIsRegistered && this.mIsSmsCapable;
        }
    }

    @Override
    protected String getFormat() {
        try {
            return this.getImsManager().getSmsFormat();
        }
        catch (ImsException e) {
            Rlog.e(TAG, "Failed to get sms format. Error: " + e.getMessage());
            return "unknown";
        }
    }

    @Override
    protected boolean shouldBlockSmsForEcbm() {
        return false;
    }

    @Override
    protected SmsMessageBase.SubmitPduBase getSubmitPdu(String scAddr, String destAddr, String message, boolean statusReportRequested, SmsHeader smsHeader, int priority, int validityPeriod) {
        return SMSDispatcherUtil.getSubmitPdu(this.isCdmaMo(), scAddr, destAddr, message, statusReportRequested, smsHeader, priority, validityPeriod);
    }

    @Override
    protected SmsMessageBase.SubmitPduBase getSubmitPdu(String scAddr, String destAddr, int destPort, byte[] message, boolean statusReportRequested) {
        return SMSDispatcherUtil.getSubmitPdu(this.isCdmaMo(), scAddr, destAddr, destPort, message, statusReportRequested);
    }

    @Override
    protected GsmAlphabet.TextEncodingDetails calculateLength(CharSequence messageBody, boolean use7bitOnly) {
        return SMSDispatcherUtil.calculateLength(this.isCdmaMo(), messageBody, use7bitOnly);
    }

    @Override
    public void sendSms(SMSDispatcher.SmsTracker tracker) {
        Rlog.d(TAG, "sendSms:  mRetryCount=" + tracker.mRetryCount + " mMessageRef=" + tracker.mMessageRef + " SS=" + this.mPhone.getServiceState().getState());
        tracker.mUsesImsServiceForIms = true;
        HashMap<String, Object> map = tracker.getData();
        byte[] pdu = (byte[])map.get("pdu");
        byte[] smsc = (byte[])map.get("smsc");
        boolean isRetry = tracker.mRetryCount > 0;
        String format = this.getFormat();
        if ("3gpp".equals(format) && tracker.mRetryCount > 0 && (1 & pdu[0]) == 1) {
            pdu[0] = (byte)(pdu[0] | 4);
            pdu[1] = (byte)tracker.mMessageRef;
        }
        int token = this.mNextToken.incrementAndGet();
        this.mTrackers.put(token, tracker);
        try {
            this.getImsManager().sendSms(token, tracker.mMessageRef, format, smsc != null ? new String(smsc) : null, isRetry, pdu);
            this.mMetrics.writeImsServiceSendSms(this.mPhone.getPhoneId(), format, 1);
        }
        catch (ImsException e) {
            Rlog.e(TAG, "sendSms failed. Falling back to PSTN. Error: " + e.getMessage());
            this.fallbackToPstn(token, tracker);
            this.mMetrics.writeImsServiceSendSms(this.mPhone.getPhoneId(), format, 4);
        }
    }

    private ImsManager getImsManager() {
        return ImsManager.getInstance(this.mContext, this.mPhone.getPhoneId());
    }

    @VisibleForTesting
    public void fallbackToPstn(int token, SMSDispatcher.SmsTracker tracker) {
        this.mSmsDispatchersController.sendRetrySms(tracker);
        this.mTrackers.remove(token);
    }

    @Override
    protected boolean isCdmaMo() {
        return this.mSmsDispatchersController.isCdmaFormat(this.getFormat());
    }

    @VisibleForTesting
    public IImsSmsListener getSmsListener() {
        return this.mImsSmsListener;
    }
}

