/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.app.ActivityManager;
import android.app.BroadcastOptions;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.content.pm.UserInfo;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.IDeviceIdleController;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.provider.Telephony;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.Pair;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.AppSmsManager;
import com.android.internal.telephony.BlockChecker;
import com.android.internal.telephony.CarrierServicesSmsFilter;
import com.android.internal.telephony.CellBroadcastHandler;
import com.android.internal.telephony.InboundSmsTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.SmsConstants;
import com.android.internal.telephony.SmsDispatchersController;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.VisualVoicemailSmsFilter;
import com.android.internal.telephony.WapPushOverSms;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.util.HexDump;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class InboundSmsHandler
extends StateMachine {
    protected static final boolean DBG = true;
    protected static final boolean VDBG = false;
    private static final String[] PDU_DELETED_FLAG_PROJECTION = new String[]{"pdu", "deleted"};
    private static final Map<Integer, Integer> PDU_DELETED_FLAG_PROJECTION_INDEX_MAPPING = new HashMap<Integer, Integer>(){
        {
            this.put(0, 0);
            this.put(10, 1);
        }
    };
    private static final String[] PDU_SEQUENCE_PORT_PROJECTION = new String[]{"pdu", "sequence", "destination_port", "display_originating_addr", "date"};
    private static final Map<Integer, Integer> PDU_SEQUENCE_PORT_PROJECTION_INDEX_MAPPING = new HashMap<Integer, Integer>(){
        {
            this.put(0, 0);
            this.put(1, 1);
            this.put(2, 2);
            this.put(9, 3);
            this.put(3, 4);
        }
    };
    public static final int PDU_COLUMN = 0;
    public static final int SEQUENCE_COLUMN = 1;
    public static final int DESTINATION_PORT_COLUMN = 2;
    public static final int DATE_COLUMN = 3;
    public static final int REFERENCE_NUMBER_COLUMN = 4;
    public static final int COUNT_COLUMN = 5;
    public static final int ADDRESS_COLUMN = 6;
    public static final int ID_COLUMN = 7;
    public static final int MESSAGE_BODY_COLUMN = 8;
    public static final int DISPLAY_ADDRESS_COLUMN = 9;
    public static final int DELETED_FLAG_COLUMN = 10;
    public static final String SELECT_BY_ID = "_id=?";
    public static final int EVENT_NEW_SMS = 1;
    public static final int EVENT_BROADCAST_SMS = 2;
    private static final int EVENT_BROADCAST_COMPLETE = 3;
    private static final int EVENT_RETURN_TO_IDLE = 4;
    private static final int EVENT_RELEASE_WAKELOCK = 5;
    public static final int EVENT_START_ACCEPTING_SMS = 6;
    public static final int EVENT_INJECT_SMS = 7;
    public static final int EVENT_UPDATE_TRACKER = 8;
    private static final int WAKELOCK_TIMEOUT = 3000;
    private static final String NOTIFICATION_TAG = "InboundSmsHandler";
    private static final int NOTIFICATION_ID_NEW_MESSAGE = 1;
    protected static final Uri sRawUri = Uri.withAppendedPath(Telephony.Sms.CONTENT_URI, "raw");
    protected static final Uri sRawUriPermanentDelete = Uri.withAppendedPath(Telephony.Sms.CONTENT_URI, "raw/permanentDelete");
    @UnsupportedAppUsage
    protected final Context mContext;
    @UnsupportedAppUsage
    private final ContentResolver mResolver;
    @UnsupportedAppUsage
    private final WapPushOverSms mWapPush;
    @UnsupportedAppUsage
    private final PowerManager.WakeLock mWakeLock;
    private final DefaultState mDefaultState = new DefaultState();
    private final StartupState mStartupState = new StartupState();
    @UnsupportedAppUsage
    private final IdleState mIdleState = new IdleState();
    @UnsupportedAppUsage
    private final DeliveringState mDeliveringState = new DeliveringState();
    @UnsupportedAppUsage
    private final WaitingState mWaitingState = new WaitingState();
    protected SmsStorageMonitor mStorageMonitor;
    private final boolean mSmsReceiveDisabled;
    @UnsupportedAppUsage
    protected Phone mPhone;
    @UnsupportedAppUsage
    protected CellBroadcastHandler mCellBroadcastHandler;
    @UnsupportedAppUsage
    private UserManager mUserManager;
    protected TelephonyMetrics mMetrics = TelephonyMetrics.getInstance();
    private LocalLog mLocalLog = new LocalLog(64);
    @UnsupportedAppUsage
    IDeviceIdleController mDeviceIdleController;
    private final int DELETE_PERMANENTLY = 1;
    private final int MARK_DELETED = 2;
    private static String ACTION_OPEN_SMS_APP = "com.android.internal.telephony.OPEN_DEFAULT_SMS_APP";
    private int mWakeLockTimeout;
    private boolean mLastSmsWasInjected = false;

    protected InboundSmsHandler(String name, Context context, SmsStorageMonitor storageMonitor, Phone phone, CellBroadcastHandler cellBroadcastHandler) {
        super(name);
        this.mContext = context;
        this.mStorageMonitor = storageMonitor;
        this.mPhone = phone;
        this.mCellBroadcastHandler = cellBroadcastHandler;
        this.mResolver = context.getContentResolver();
        this.mWapPush = new WapPushOverSms(context);
        boolean smsCapable = this.mContext.getResources().getBoolean(0x11100C1);
        this.mSmsReceiveDisabled = !TelephonyManager.from(this.mContext).getSmsReceiveCapableForPhone(this.mPhone.getPhoneId(), smsCapable);
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, name);
        this.mWakeLock.acquire();
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.mDeviceIdleController = TelephonyComponentFactory.getInstance().inject(IDeviceIdleController.class.getName()).getIDeviceIdleController();
        this.addState(this.mDefaultState);
        this.addState(this.mStartupState, this.mDefaultState);
        this.addState(this.mIdleState, this.mDefaultState);
        this.addState(this.mDeliveringState, this.mDefaultState);
        this.addState(this.mWaitingState, this.mDeliveringState);
        this.setInitialState(this.mStartupState);
        this.log("created InboundSmsHandler");
    }

    public void dispose() {
        this.quit();
    }

    @Override
    protected void onQuitting() {
        this.mWapPush.dispose();
        while (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
    }

    @UnsupportedAppUsage
    public Phone getPhone() {
        return this.mPhone;
    }

    @UnsupportedAppUsage
    private void handleNewSms(AsyncResult ar) {
        int result;
        if (ar.exception != null) {
            this.loge("Exception processing incoming SMS: " + ar.exception);
            return;
        }
        try {
            SmsMessage sms = (SmsMessage)ar.result;
            this.mLastSmsWasInjected = false;
            result = this.dispatchMessage(sms.mWrappedSmsMessage);
        }
        catch (RuntimeException ex) {
            this.loge("Exception dispatching message", ex);
            result = 2;
        }
        if (result != -1) {
            boolean handled = result == 1;
            this.notifyAndAcknowledgeLastIncomingSms(handled, result, null);
        }
    }

    @UnsupportedAppUsage
    private void handleInjectSms(AsyncResult ar) {
        int result;
        SmsDispatchersController.SmsInjectionCallback callback = null;
        try {
            callback = (SmsDispatchersController.SmsInjectionCallback)ar.userObj;
            SmsMessage sms = (SmsMessage)ar.result;
            if (sms == null) {
                result = 2;
            } else {
                this.mLastSmsWasInjected = true;
                result = this.dispatchMessage(sms.mWrappedSmsMessage);
            }
        }
        catch (RuntimeException ex) {
            this.loge("Exception dispatching message", ex);
            result = 2;
        }
        if (callback != null) {
            callback.onSmsInjectedResult(result);
        }
    }

    private int dispatchMessage(SmsMessageBase smsb) {
        if (smsb == null) {
            this.loge("dispatchSmsMessage: message is null");
            return 2;
        }
        if (this.mSmsReceiveDisabled) {
            this.log("Received short message on device which doesn't support receiving SMS. Ignored.");
            return 1;
        }
        boolean onlyCore = false;
        try {
            onlyCore = IPackageManager.Stub.asInterface(ServiceManager.getService("package")).isOnlyCoreApps();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (onlyCore) {
            this.log("Received a short message in encrypted state. Rejecting.");
            return 2;
        }
        int result = this.dispatchMessageRadioSpecific(smsb);
        if (result != 1) {
            this.mMetrics.writeIncomingSmsError(this.mPhone.getPhoneId(), this.mLastSmsWasInjected, result);
        }
        return result;
    }

    protected abstract int dispatchMessageRadioSpecific(SmsMessageBase var1);

    @UnsupportedAppUsage
    protected abstract void acknowledgeLastIncomingSms(boolean var1, int var2, Message var3);

    private void notifyAndAcknowledgeLastIncomingSms(boolean success, int result, Message response) {
        if (!success) {
            Intent intent = new Intent("android.provider.Telephony.SMS_REJECTED");
            intent.putExtra("result", result);
            intent.addFlags(0x1000000);
            this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_SMS");
        }
        this.acknowledgeLastIncomingSms(success, result, response);
    }

    protected abstract boolean is3gpp2();

    @UnsupportedAppUsage
    protected int dispatchNormalMessage(SmsMessageBase sms) {
        InboundSmsTracker tracker;
        SmsHeader smsHeader = sms.getUserDataHeader();
        if (smsHeader == null || smsHeader.concatRef == null) {
            int destPort = -1;
            if (smsHeader != null && smsHeader.portAddrs != null) {
                destPort = smsHeader.portAddrs.destPort;
                this.log("destination port: " + destPort);
            }
            tracker = TelephonyComponentFactory.getInstance().inject(InboundSmsTracker.class.getName()).makeInboundSmsTracker(sms.getPdu(), sms.getTimestampMillis(), destPort, this.is3gpp2(), false, sms.getOriginatingAddress(), sms.getDisplayOriginatingAddress(), sms.getMessageBody(), sms.getMessageClass() == SmsConstants.MessageClass.CLASS_0);
        } else {
            SmsHeader.ConcatRef concatRef = smsHeader.concatRef;
            SmsHeader.PortAddrs portAddrs = smsHeader.portAddrs;
            int destPort = portAddrs != null ? portAddrs.destPort : -1;
            tracker = TelephonyComponentFactory.getInstance().inject(InboundSmsTracker.class.getName()).makeInboundSmsTracker(sms.getPdu(), sms.getTimestampMillis(), destPort, this.is3gpp2(), sms.getOriginatingAddress(), sms.getDisplayOriginatingAddress(), concatRef.refNumber, concatRef.seqNumber, concatRef.msgCount, false, sms.getMessageBody(), sms.getMessageClass() == SmsConstants.MessageClass.CLASS_0);
        }
        return this.addTrackerToRawTableAndSendMessage(tracker, tracker.getDestPort() == -1);
    }

    protected int addTrackerToRawTableAndSendMessage(InboundSmsTracker tracker, boolean deDup) {
        switch (this.addTrackerToRawTable(tracker, deDup)) {
            case 1: {
                this.sendMessage(2, tracker);
                return 1;
            }
            case 5: {
                return 1;
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private boolean processMessagePart(InboundSmsTracker tracker) {
        List pduList;
        String format;
        long[] timestamps;
        byte[][] pdus;
        int messageCount = tracker.getMessageCount();
        int destPort = tracker.getDestPort();
        boolean block = false;
        String address = tracker.getAddress();
        if (messageCount <= 0) {
            this.loge("processMessagePart: returning false due to invalid message count " + messageCount);
            return false;
        }
        if (messageCount == 1) {
            pdus = new byte[][]{tracker.getPdu()};
            timestamps = new long[]{tracker.getTimestamp()};
            block = BlockChecker.isBlocked(this.mContext, tracker.getDisplayAddress(), null);
        } else {
            try (Cursor cursor = null;){
                String refNumber = Integer.toString(tracker.getReferenceNumber());
                String count = Integer.toString(tracker.getMessageCount());
                String[] whereArgs = new String[]{address, refNumber, count};
                cursor = this.mResolver.query(sRawUri, PDU_SEQUENCE_PORT_PROJECTION, tracker.getQueryForSegments(), whereArgs, null);
                int cursorCount = cursor.getCount();
                if (cursorCount < messageCount) {
                    boolean bl = false;
                    return bl;
                }
                pdus = new byte[messageCount][];
                timestamps = new long[messageCount];
                while (cursor.moveToNext()) {
                    int index = cursor.getInt(PDU_SEQUENCE_PORT_PROJECTION_INDEX_MAPPING.get(1)) - tracker.getIndexOffset();
                    if (index >= pdus.length || index < 0) {
                        this.loge(String.format("processMessagePart: invalid seqNumber = %d, messageCount = %d", index + tracker.getIndexOffset(), messageCount));
                        continue;
                    }
                    pdus[index] = HexDump.hexStringToByteArray(cursor.getString(PDU_SEQUENCE_PORT_PROJECTION_INDEX_MAPPING.get(0)));
                    if (index == 0 && !cursor.isNull(PDU_SEQUENCE_PORT_PROJECTION_INDEX_MAPPING.get(2))) {
                        int port = cursor.getInt(PDU_SEQUENCE_PORT_PROJECTION_INDEX_MAPPING.get(2));
                        if ((port = InboundSmsTracker.getRealDestPort(port)) != -1) {
                            destPort = port;
                        }
                    }
                    timestamps[index] = cursor.getLong(PDU_SEQUENCE_PORT_PROJECTION_INDEX_MAPPING.get(3));
                    if (block) continue;
                    block = BlockChecker.isBlocked(this.mContext, cursor.getString(PDU_SEQUENCE_PORT_PROJECTION_INDEX_MAPPING.get(9)), null);
                }
            }
        }
        String string2 = format = !tracker.is3gpp2() ? "3gpp" : "3gpp2";
        if (destPort != 2948) {
            this.mMetrics.writeIncomingSmsSession(this.mPhone.getPhoneId(), this.mLastSmsWasInjected, format, timestamps, block);
        }
        if ((pduList = Arrays.asList(pdus)).size() == 0 || pduList.contains(null)) {
            String errorMsg = "processMessagePart: returning false due to " + (pduList.size() == 0 ? "pduList.size() == 0" : "pduList.contains(null)");
            this.loge(errorMsg);
            this.mLocalLog.log(errorMsg);
            return false;
        }
        SmsBroadcastReceiver resultReceiver = new SmsBroadcastReceiver(tracker);
        if (!this.mUserManager.isUserUnlocked()) {
            return this.processMessagePartWithUserLocked(tracker, pdus, destPort, resultReceiver);
        }
        if (destPort == 2948) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            for (byte[] pdu : pdus) {
                if (!tracker.is3gpp2()) {
                    SmsMessage msg = SmsMessage.createFromPdu(pdu, "3gpp");
                    if (msg != null) {
                        pdu = msg.getUserData();
                    } else {
                        this.loge("processMessagePart: SmsMessage.createFromPdu returned null");
                        this.mMetrics.writeIncomingWapPush(this.mPhone.getPhoneId(), this.mLastSmsWasInjected, format, timestamps, false);
                        return false;
                    }
                }
                output.write(pdu, 0, pdu.length);
            }
            int result = this.mWapPush.dispatchWapPdu(output.toByteArray(), resultReceiver, this, address);
            this.log("dispatchWapPdu() returned " + result);
            if (result == -1 || result == 1) {
                this.mMetrics.writeIncomingWapPush(this.mPhone.getPhoneId(), this.mLastSmsWasInjected, format, timestamps, true);
            } else {
                this.mMetrics.writeIncomingWapPush(this.mPhone.getPhoneId(), this.mLastSmsWasInjected, format, timestamps, false);
            }
            if (result == -1) {
                return true;
            }
            this.deleteFromRawTable(tracker.getDeleteWhere(), tracker.getDeleteWhereArgs(), 2);
            return false;
        }
        if (block) {
            this.deleteFromRawTable(tracker.getDeleteWhere(), tracker.getDeleteWhereArgs(), 1);
            return false;
        }
        boolean filterInvoked = this.filterSms(pdus, destPort, tracker, resultReceiver, true);
        if (!filterInvoked) {
            this.dispatchSmsDeliveryIntent(pdus, tracker.getFormat(), destPort, resultReceiver, tracker.isClass0());
        }
        return true;
    }

    private boolean processMessagePartWithUserLocked(InboundSmsTracker tracker, byte[][] pdus, int destPort, SmsBroadcastReceiver resultReceiver) {
        this.log("Credential-encrypted storage not available. Port: " + destPort);
        if (destPort == 2948 && this.mWapPush.isWapPushForMms(pdus[0], this)) {
            this.showNewMessageNotification();
            return false;
        }
        if (destPort == -1) {
            boolean filterInvoked = this.filterSms(pdus, destPort, tracker, resultReceiver, false);
            if (filterInvoked) {
                return true;
            }
            this.showNewMessageNotification();
            return false;
        }
        return false;
    }

    @UnsupportedAppUsage
    private void showNewMessageNotification() {
        if (!StorageManager.isFileEncryptedNativeOrEmulated()) {
            return;
        }
        this.log("Show new message notification.");
        PendingIntent intent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(ACTION_OPEN_SMS_APP), 0x40000000);
        Notification.Builder mBuilder = new Notification.Builder(this.mContext).setSmallIcon(17301646).setAutoCancel(true).setVisibility(1).setDefaults(-1).setContentTitle(this.mContext.getString(17040468)).setContentText(this.mContext.getString(17040467)).setContentIntent(intent).setChannelId("sms");
        NotificationManager mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        mNotificationManager.notify(NOTIFICATION_TAG, 1, mBuilder.build());
    }

    static void cancelNewMessageNotification(Context context) {
        NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
        mNotificationManager.cancel(NOTIFICATION_TAG, 1);
    }

    private boolean filterSms(byte[][] pdus, int destPort, InboundSmsTracker tracker, SmsBroadcastReceiver resultReceiver, boolean userUnlocked) {
        CarrierServicesSmsFilterCallback filterCallback = new CarrierServicesSmsFilterCallback(pdus, destPort, tracker.getFormat(), resultReceiver, userUnlocked, tracker.isClass0());
        CarrierServicesSmsFilter carrierServicesFilter = new CarrierServicesSmsFilter(this.mContext, this.mPhone, pdus, destPort, tracker.getFormat(), filterCallback, this.getName(), this.mLocalLog);
        if (carrierServicesFilter.filter()) {
            return true;
        }
        if (VisualVoicemailSmsFilter.filter(this.mContext, pdus, tracker.getFormat(), destPort, this.mPhone.getSubId())) {
            this.log("Visual voicemail SMS dropped");
            this.dropSms(resultReceiver);
            return true;
        }
        return false;
    }

    @UnsupportedAppUsage
    public void dispatchIntent(Intent intent, String permission2, int appOp, Bundle opts, BroadcastReceiver resultReceiver, UserHandle user) {
        intent.addFlags(0x8000000);
        String action = intent.getAction();
        if ("android.provider.Telephony.SMS_DELIVER".equals(action) || "android.provider.Telephony.SMS_RECEIVED".equals(action) || "android.provider.Telephony.WAP_PUSH_DELIVER".equals(action) || "android.provider.Telephony.WAP_PUSH_RECEIVED".equals(action)) {
            intent.addFlags(0x10000000);
        }
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
        if (user.equals(UserHandle.ALL)) {
            int[] users = null;
            try {
                users = ActivityManager.getService().getRunningUserIds();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (users == null) {
                users = new int[]{user.getIdentifier()};
            }
            for (int i = users.length - 1; i >= 0; --i) {
                UserInfo info;
                UserHandle targetUser = new UserHandle(users[i]);
                if (users[i] != 0 && (this.mUserManager.hasUserRestriction("no_sms", targetUser) || (info = this.mUserManager.getUserInfo(users[i])) == null || info.isManagedProfile())) continue;
                this.mContext.sendOrderedBroadcastAsUser(intent, targetUser, permission2, appOp, opts, users[i] == 0 ? resultReceiver : null, this.getHandler(), -1, null, null);
            }
        } else {
            this.mContext.sendOrderedBroadcastAsUser(intent, user, permission2, appOp, opts, resultReceiver, this.getHandler(), -1, null, null);
        }
    }

    @UnsupportedAppUsage
    private void deleteFromRawTable(String deleteWhere, String[] deleteWhereArgs, int deleteType) {
        Uri uri = deleteType == 1 ? sRawUriPermanentDelete : sRawUri;
        int rows = this.mResolver.delete(uri, deleteWhere, deleteWhereArgs);
        if (rows == 0) {
            this.loge("No rows were deleted from raw table!");
        } else {
            this.log("Deleted " + rows + " rows from raw table.");
        }
    }

    @UnsupportedAppUsage
    private Bundle handleSmsWhitelisting(ComponentName target, boolean bgActivityStartAllowed) {
        String reason;
        String pkgName;
        if (target != null) {
            pkgName = target.getPackageName();
            reason = "sms-app";
        } else {
            pkgName = this.mContext.getPackageName();
            reason = "sms-broadcast";
        }
        BroadcastOptions bopts = null;
        Bundle bundle = null;
        if (bgActivityStartAllowed) {
            bopts = BroadcastOptions.makeBasic();
            bopts.setBackgroundActivityStartsAllowed(true);
            bundle = bopts.toBundle();
        }
        try {
            long duration = this.mDeviceIdleController.addPowerSaveTempWhitelistAppForSms(pkgName, 0, reason);
            if (bopts == null) {
                bopts = BroadcastOptions.makeBasic();
            }
            bopts.setTemporaryAppWhitelistDuration(duration);
            bundle = bopts.toBundle();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return bundle;
    }

    private void dispatchSmsDeliveryIntent(byte[][] pdus, String format, int destPort, SmsBroadcastReceiver resultReceiver, boolean isClass0) {
        Intent intent = new Intent();
        intent.putExtra("pdus", (Serializable)pdus);
        intent.putExtra("format", format);
        if (destPort == -1) {
            AppSmsManager appManager;
            Uri uri;
            intent.setAction("android.provider.Telephony.SMS_DELIVER");
            ComponentName componentName = SmsApplication.getDefaultSmsApplication(this.mContext, true);
            if (componentName != null) {
                intent.setComponent(componentName);
                this.log("Delivering SMS to: " + componentName.getPackageName() + " " + componentName.getClassName());
            } else {
                intent.setComponent(null);
            }
            if (SmsManager.getDefault().getAutoPersisting() && (uri = this.writeInboxMessage(intent)) != null) {
                intent.putExtra("uri", uri.toString());
            }
            if ((appManager = this.mPhone.getAppSmsManager()).handleSmsReceivedIntent(intent)) {
                this.dropSms(resultReceiver);
                return;
            }
        } else {
            intent.setAction("android.intent.action.DATA_SMS_RECEIVED");
            Uri uri = Uri.parse("sms://localhost:" + destPort);
            intent.setData(uri);
            intent.setComponent(null);
            intent.addFlags(0x1000000);
        }
        Bundle options = this.handleSmsWhitelisting(intent.getComponent(), isClass0);
        this.dispatchIntent(intent, "android.permission.RECEIVE_SMS", 16, options, resultReceiver, UserHandle.SYSTEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndHandleDuplicate(InboundSmsTracker tracker) throws SQLException {
        Pair<String, String[]> exactMatchQuery = tracker.getExactMatchDupDetectQuery();
        try (Cursor cursor = null;){
            cursor = this.mResolver.query(sRawUri, PDU_DELETED_FLAG_PROJECTION, (String)exactMatchQuery.first, (String[])exactMatchQuery.second, null);
            if (cursor != null && cursor.moveToNext()) {
                if (cursor.getCount() != 1) {
                    this.loge("Exact match query returned " + cursor.getCount() + " rows");
                }
                if (cursor.getInt(PDU_DELETED_FLAG_PROJECTION_INDEX_MAPPING.get(10)) == 1) {
                    this.loge("Discarding duplicate message segment: " + tracker);
                    this.logDupPduMismatch(cursor, tracker);
                    boolean bl = true;
                    return bl;
                }
                if (tracker.getMessageCount() == 1) {
                    this.deleteFromRawTable((String)exactMatchQuery.first, (String[])exactMatchQuery.second, 1);
                    this.loge("Replacing duplicate message: " + tracker);
                    this.logDupPduMismatch(cursor, tracker);
                }
            }
        }
        if (tracker.getMessageCount() > 1) {
            Pair<String, String[]> inexactMatchQuery = tracker.getInexactMatchDupDetectQuery();
            cursor = null;
            try {
                cursor = this.mResolver.query(sRawUri, PDU_DELETED_FLAG_PROJECTION, (String)inexactMatchQuery.first, (String[])inexactMatchQuery.second, null);
                if (cursor != null && cursor.moveToNext()) {
                    if (cursor.getCount() != 1) {
                        this.loge("Inexact match query returned " + cursor.getCount() + " rows");
                    }
                    this.deleteFromRawTable((String)inexactMatchQuery.first, (String[])inexactMatchQuery.second, 1);
                    this.loge("Replacing duplicate message segment: " + tracker);
                    this.logDupPduMismatch(cursor, tracker);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        return false;
    }

    private void logDupPduMismatch(Cursor cursor, InboundSmsTracker tracker) {
        String oldPduString = cursor.getString(PDU_DELETED_FLAG_PROJECTION_INDEX_MAPPING.get(0));
        byte[] pdu = tracker.getPdu();
        byte[] oldPdu = HexDump.hexStringToByteArray(oldPduString);
        if (!Arrays.equals(oldPdu, tracker.getPdu())) {
            this.loge("Warning: dup message PDU of length " + pdu.length + " is different from existing PDU of length " + oldPdu.length);
        }
    }

    private int addTrackerToRawTable(InboundSmsTracker tracker, boolean deDup) {
        block8: {
            if (deDup) {
                try {
                    if (this.checkAndHandleDuplicate(tracker)) {
                        return 5;
                    }
                    break block8;
                }
                catch (SQLException e) {
                    this.loge("Can't access SMS database", e);
                    return 2;
                }
            }
            this.logd("Skipped message de-duping logic");
        }
        String address = tracker.getAddress();
        String refNumber = Integer.toString(tracker.getReferenceNumber());
        String count = Integer.toString(tracker.getMessageCount());
        ContentValues values = tracker.getContentValues();
        Uri newUri = this.mResolver.insert(sRawUri, values);
        this.log("URI of new row -> " + newUri);
        try {
            long rowId = ContentUris.parseId(newUri);
            if (tracker.getMessageCount() == 1) {
                tracker.setDeleteWhere(SELECT_BY_ID, new String[]{Long.toString(rowId)});
            } else {
                String[] deleteWhereArgs = new String[]{address, refNumber, count};
                tracker.setDeleteWhere(tracker.getQueryForSegments(), deleteWhereArgs);
            }
            return 1;
        }
        catch (Exception e) {
            this.loge("error parsing URI for new row: " + newUri, e);
            return 2;
        }
    }

    static boolean isCurrentFormat3gpp2() {
        int activePhone = TelephonyManager.getDefault().getCurrentPhoneType();
        return 2 == activePhone;
    }

    private void dropSms(SmsBroadcastReceiver receiver) {
        this.deleteFromRawTable(receiver.mDeleteWhere, receiver.mDeleteWhereArgs, 2);
        this.sendMessage(3);
    }

    @UnsupportedAppUsage
    private boolean isSkipNotifyFlagSet(int callbackResult) {
        return (callbackResult & 2) > 0;
    }

    @Override
    @UnsupportedAppUsage
    protected void log(String s) {
        Rlog.d(this.getName(), s);
    }

    @Override
    @UnsupportedAppUsage
    protected void loge(String s) {
        Rlog.e(this.getName(), s);
    }

    @Override
    protected void loge(String s, Throwable e) {
        Rlog.e(this.getName(), s, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private Uri writeInboxMessage(Intent intent) {
        SmsMessage[] messages = Telephony.Sms.Intents.getMessagesFromIntent(intent);
        if (messages == null || messages.length < 1) {
            this.loge("Failed to parse SMS pdu");
            return null;
        }
        for (SmsMessage smsMessage : messages) {
            if (smsMessage != null) continue;
            this.loge("Can\u2019t write null SmsMessage");
            return null;
        }
        ContentValues values = InboundSmsHandler.parseSmsMessage(messages);
        long identity = Binder.clearCallingIdentity();
        try {
            Uri uri = this.mContext.getContentResolver().insert(Telephony.Sms.Inbox.CONTENT_URI, values);
            return uri;
        }
        catch (Exception exception) {
            this.loge("Failed to persist inbox message", exception);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return null;
    }

    private static ContentValues parseSmsMessage(SmsMessage[] msgs) {
        SmsMessage sms = msgs[0];
        ContentValues values = new ContentValues();
        values.put("address", sms.getDisplayOriginatingAddress());
        values.put("body", InboundSmsHandler.buildMessageBodyFromPdus(msgs));
        values.put("date_sent", sms.getTimestampMillis());
        values.put("date", System.currentTimeMillis());
        values.put("protocol", sms.getProtocolIdentifier());
        values.put("seen", 0);
        values.put("read", 0);
        String subject = sms.getPseudoSubject();
        if (!TextUtils.isEmpty(subject)) {
            values.put("subject", subject);
        }
        values.put("reply_path_present", sms.isReplyPathPresent() ? 1 : 0);
        values.put("service_center", sms.getServiceCenterAddress());
        return values;
    }

    private static String buildMessageBodyFromPdus(SmsMessage[] msgs) {
        if (msgs.length == 1) {
            return InboundSmsHandler.replaceFormFeeds(msgs[0].getDisplayMessageBody());
        }
        StringBuilder body = new StringBuilder();
        for (SmsMessage msg : msgs) {
            body.append(msg.getDisplayMessageBody());
        }
        return InboundSmsHandler.replaceFormFeeds(body.toString());
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        super.dump(fd, pw, args);
        if (this.mCellBroadcastHandler != null) {
            this.mCellBroadcastHandler.dump(fd, pw, args);
        }
        this.mLocalLog.dump(fd, pw, args);
    }

    private static String replaceFormFeeds(String s) {
        return s == null ? "" : s.replace('\f', '\n');
    }

    @VisibleForTesting
    public PowerManager.WakeLock getWakeLock() {
        return this.mWakeLock;
    }

    @VisibleForTesting
    public int getWakeLockTimeout() {
        return this.mWakeLockTimeout;
    }

    private void setWakeLockTimeout(int timeOut) {
        this.mWakeLockTimeout = timeOut;
    }

    static void registerNewMessageNotificationActionHandler(Context context) {
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction(ACTION_OPEN_SMS_APP);
        context.registerReceiver(new NewMessageNotificationActionReceiver(), userFilter);
    }

    private static class NewMessageNotificationActionReceiver
    extends BroadcastReceiver {
        private NewMessageNotificationActionReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            UserManager userManager;
            if (ACTION_OPEN_SMS_APP.equals(intent.getAction()) && (userManager = (UserManager)context.getSystemService("user")).isUserUnlocked()) {
                context.startActivity(context.getPackageManager().getLaunchIntentForPackage(Telephony.Sms.getDefaultSmsPackage(context)));
            }
        }
    }

    private final class CarrierServicesSmsFilterCallback
    implements CarrierServicesSmsFilter.CarrierServicesSmsFilterCallbackInterface {
        private final byte[][] mPdus;
        private final int mDestPort;
        private final String mSmsFormat;
        private final SmsBroadcastReceiver mSmsBroadcastReceiver;
        private final boolean mUserUnlocked;
        private final boolean mIsClass0;

        CarrierServicesSmsFilterCallback(byte[][] pdus, int destPort, String smsFormat, SmsBroadcastReceiver smsBroadcastReceiver, boolean userUnlocked, boolean isClass0) {
            this.mPdus = pdus;
            this.mDestPort = destPort;
            this.mSmsFormat = smsFormat;
            this.mSmsBroadcastReceiver = smsBroadcastReceiver;
            this.mUserUnlocked = userUnlocked;
            this.mIsClass0 = isClass0;
        }

        @Override
        public void onFilterComplete(int result) {
            InboundSmsHandler.this.logv("onFilterComplete: result is " + result);
            if ((result & 1) == 0) {
                if (VisualVoicemailSmsFilter.filter(InboundSmsHandler.this.mContext, this.mPdus, this.mSmsFormat, this.mDestPort, InboundSmsHandler.this.mPhone.getSubId())) {
                    InboundSmsHandler.this.log("Visual voicemail SMS dropped");
                    InboundSmsHandler.this.dropSms(this.mSmsBroadcastReceiver);
                    return;
                }
                if (this.mUserUnlocked) {
                    InboundSmsHandler.this.dispatchSmsDeliveryIntent(this.mPdus, this.mSmsFormat, this.mDestPort, this.mSmsBroadcastReceiver, this.mIsClass0);
                } else {
                    if (!InboundSmsHandler.this.isSkipNotifyFlagSet(result)) {
                        InboundSmsHandler.this.showNewMessageNotification();
                    }
                    InboundSmsHandler.this.sendMessage(3);
                }
            } else {
                InboundSmsHandler.this.dropSms(this.mSmsBroadcastReceiver);
            }
        }
    }

    private final class SmsBroadcastReceiver
    extends BroadcastReceiver {
        @UnsupportedAppUsage
        private final String mDeleteWhere;
        @UnsupportedAppUsage
        private final String[] mDeleteWhereArgs;
        private long mBroadcastTimeNano;

        SmsBroadcastReceiver(InboundSmsTracker tracker) {
            this.mDeleteWhere = tracker.getDeleteWhere();
            this.mDeleteWhereArgs = tracker.getDeleteWhereArgs();
            this.mBroadcastTimeNano = System.nanoTime();
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.provider.Telephony.SMS_DELIVER")) {
                intent.setAction("android.provider.Telephony.SMS_RECEIVED");
                intent.addFlags(0x1000000);
                intent.setComponent(null);
                Bundle options = InboundSmsHandler.this.handleSmsWhitelisting(null, false);
                InboundSmsHandler.this.dispatchIntent(intent, "android.permission.RECEIVE_SMS", 16, options, this, UserHandle.ALL);
            } else if (action.equals("android.provider.Telephony.WAP_PUSH_DELIVER")) {
                intent.setAction("android.provider.Telephony.WAP_PUSH_RECEIVED");
                intent.setComponent(null);
                intent.addFlags(0x1000000);
                Bundle options = null;
                try {
                    long duration = InboundSmsHandler.this.mDeviceIdleController.addPowerSaveTempWhitelistAppForMms(InboundSmsHandler.this.mContext.getPackageName(), 0, "mms-broadcast");
                    BroadcastOptions bopts = BroadcastOptions.makeBasic();
                    bopts.setTemporaryAppWhitelistDuration(duration);
                    options = bopts.toBundle();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                String mimeType = intent.getType();
                InboundSmsHandler.this.dispatchIntent(intent, WapPushOverSms.getPermissionForType(mimeType), WapPushOverSms.getAppOpsPermissionForIntent(mimeType), options, this, UserHandle.SYSTEM);
            } else {
                int rc;
                if (!("android.intent.action.DATA_SMS_RECEIVED".equals(action) || "android.provider.Telephony.SMS_RECEIVED".equals(action) || "android.intent.action.DATA_SMS_RECEIVED".equals(action) || "android.provider.Telephony.WAP_PUSH_RECEIVED".equals(action))) {
                    InboundSmsHandler.this.loge("unexpected BroadcastReceiver action: " + action);
                }
                if ((rc = this.getResultCode()) != -1 && rc != 1) {
                    InboundSmsHandler.this.loge("a broadcast receiver set the result code to " + rc + ", deleting from raw table anyway!");
                } else {
                    InboundSmsHandler.this.log("successful broadcast, deleting from raw table.");
                }
                InboundSmsHandler.this.deleteFromRawTable(this.mDeleteWhere, this.mDeleteWhereArgs, 2);
                InboundSmsHandler.this.sendMessage(3);
                int durationMillis = (int)((System.nanoTime() - this.mBroadcastTimeNano) / 1000000L);
                if (durationMillis >= 5000) {
                    InboundSmsHandler.this.loge("Slow ordered broadcast completion time: " + durationMillis + " ms");
                } else {
                    InboundSmsHandler.this.log("ordered broadcast completed in: " + durationMillis + " ms");
                }
            }
        }
    }

    private class WaitingState
    extends State {
        private InboundSmsTracker mLastDeliveredSmsTracker;

        private WaitingState() {
        }

        @Override
        public void enter() {
            InboundSmsHandler.this.log("entering Waiting state");
        }

        @Override
        public void exit() {
            InboundSmsHandler.this.log("exiting Waiting state");
            InboundSmsHandler.this.setWakeLockTimeout(3000);
            InboundSmsHandler.this.mPhone.getIccSmsInterfaceManager().mDispatchersController.sendEmptyMessage(17);
        }

        @Override
        public boolean processMessage(Message msg) {
            InboundSmsHandler.this.log("WaitingState.processMessage:" + msg.what);
            switch (msg.what) {
                case 2: {
                    if (this.mLastDeliveredSmsTracker != null) {
                        String str = "Defer sms broadcast due to undelivered sms,  messageCount = " + this.mLastDeliveredSmsTracker.getMessageCount() + " destPort = " + this.mLastDeliveredSmsTracker.getDestPort() + " timestamp = " + this.mLastDeliveredSmsTracker.getTimestamp() + " currentTimestamp = " + System.currentTimeMillis();
                        InboundSmsHandler.this.logd(str);
                        InboundSmsHandler.this.mLocalLog.log(str);
                    }
                    InboundSmsHandler.this.deferMessage(msg);
                    return true;
                }
                case 3: {
                    this.mLastDeliveredSmsTracker = null;
                    InboundSmsHandler.this.sendMessage(4);
                    InboundSmsHandler.this.transitionTo(InboundSmsHandler.this.mDeliveringState);
                    return true;
                }
                case 4: {
                    return true;
                }
                case 8: {
                    this.mLastDeliveredSmsTracker = (InboundSmsTracker)msg.obj;
                    return true;
                }
            }
            return false;
        }
    }

    private class DeliveringState
    extends State {
        private DeliveringState() {
        }

        @Override
        public void enter() {
            InboundSmsHandler.this.log("entering Delivering state");
        }

        @Override
        public void exit() {
            InboundSmsHandler.this.log("leaving Delivering state");
        }

        @Override
        public boolean processMessage(Message msg) {
            InboundSmsHandler.this.log("DeliveringState.processMessage:" + msg.what);
            switch (msg.what) {
                case 1: {
                    InboundSmsHandler.this.handleNewSms((AsyncResult)msg.obj);
                    InboundSmsHandler.this.sendMessage(4);
                    return true;
                }
                case 7: {
                    InboundSmsHandler.this.handleInjectSms((AsyncResult)msg.obj);
                    InboundSmsHandler.this.sendMessage(4);
                    return true;
                }
                case 2: {
                    InboundSmsTracker inboundSmsTracker = (InboundSmsTracker)msg.obj;
                    if (InboundSmsHandler.this.processMessagePart(inboundSmsTracker)) {
                        InboundSmsHandler.this.sendMessage(InboundSmsHandler.this.obtainMessage(8, msg.obj));
                        InboundSmsHandler.this.transitionTo(InboundSmsHandler.this.mWaitingState);
                    } else {
                        InboundSmsHandler.this.log("No broadcast sent on processing EVENT_BROADCAST_SMS in Delivering state. Return to Idle state");
                        InboundSmsHandler.this.sendMessage(4);
                    }
                    return true;
                }
                case 4: {
                    InboundSmsHandler.this.transitionTo(InboundSmsHandler.this.mIdleState);
                    return true;
                }
                case 5: {
                    InboundSmsHandler.this.mWakeLock.release();
                    if (!InboundSmsHandler.this.mWakeLock.isHeld()) {
                        InboundSmsHandler.this.loge("mWakeLock released while delivering/broadcasting!");
                    }
                    return true;
                }
                case 8: {
                    InboundSmsHandler.this.logd("process tracker message in DeliveringState " + msg.arg1);
                    return true;
                }
            }
            String errorMsg = "Unhandled msg in delivering state, msg.what = " + msg.what;
            InboundSmsHandler.this.loge(errorMsg);
            InboundSmsHandler.this.mLocalLog.log(errorMsg);
            return false;
        }
    }

    private class IdleState
    extends State {
        private IdleState() {
        }

        @Override
        public void enter() {
            InboundSmsHandler.this.log("entering Idle state");
            InboundSmsHandler.this.sendMessageDelayed(5, (long)InboundSmsHandler.this.getWakeLockTimeout());
        }

        @Override
        public void exit() {
            InboundSmsHandler.this.mWakeLock.acquire();
            InboundSmsHandler.this.log("acquired wakelock, leaving Idle state");
        }

        @Override
        public boolean processMessage(Message msg) {
            InboundSmsHandler.this.log("IdleState.processMessage:" + msg.what);
            InboundSmsHandler.this.log("Idle state processing message type " + msg.what);
            switch (msg.what) {
                case 1: 
                case 2: 
                case 7: {
                    InboundSmsHandler.this.deferMessage(msg);
                    InboundSmsHandler.this.transitionTo(InboundSmsHandler.this.mDeliveringState);
                    return true;
                }
                case 5: {
                    InboundSmsHandler.this.mWakeLock.release();
                    if (InboundSmsHandler.this.mWakeLock.isHeld()) {
                        InboundSmsHandler.this.log("mWakeLock is still held after release");
                    } else {
                        InboundSmsHandler.this.log("mWakeLock released");
                    }
                    return true;
                }
                case 4: {
                    return true;
                }
            }
            return false;
        }
    }

    private class StartupState
    extends State {
        private StartupState() {
        }

        @Override
        public void enter() {
            InboundSmsHandler.this.log("entering Startup state");
            InboundSmsHandler.this.setWakeLockTimeout(0);
        }

        @Override
        public boolean processMessage(Message msg) {
            InboundSmsHandler.this.log("StartupState.processMessage:" + msg.what);
            switch (msg.what) {
                case 1: 
                case 2: 
                case 7: {
                    InboundSmsHandler.this.deferMessage(msg);
                    return true;
                }
                case 6: {
                    InboundSmsHandler.this.transitionTo(InboundSmsHandler.this.mIdleState);
                    return true;
                }
            }
            return false;
        }
    }

    private class DefaultState
    extends State {
        private DefaultState() {
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                default: 
            }
            String errorText = "processMessage: unhandled message type " + msg.what + " currState=" + InboundSmsHandler.this.getCurrentState().getName();
            if (Build.IS_DEBUGGABLE) {
                InboundSmsHandler.this.loge("---- Dumping InboundSmsHandler ----");
                InboundSmsHandler.this.loge("Total records=" + InboundSmsHandler.this.getLogRecCount());
                for (int i = Math.max(InboundSmsHandler.this.getLogRecSize() - 20, 0); i < InboundSmsHandler.this.getLogRecSize(); ++i) {
                    InboundSmsHandler.this.loge("Rec[%d]: %s\n" + i + InboundSmsHandler.this.getLogRec(i).toString());
                }
                InboundSmsHandler.this.loge("---- Dumped InboundSmsHandler ----");
                throw new RuntimeException(errorText);
            }
            InboundSmsHandler.this.loge(errorText);
            return true;
        }
    }
}

