/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.content.ContentValues;
import android.database.Cursor;
import android.util.Pair;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.HexDump;
import java.util.Arrays;
import java.util.Date;

public class InboundSmsTracker {
    private final byte[] mPdu;
    private final long mTimestamp;
    private final int mDestPort;
    private final boolean mIs3gpp2;
    private final boolean mIs3gpp2WapPdu;
    private final String mMessageBody;
    private final boolean mIsClass0;
    private final String mAddress;
    private final int mReferenceNumber;
    private final int mSequenceNumber;
    private final int mMessageCount;
    private String mDeleteWhere;
    private String[] mDeleteWhereArgs;
    private final String mDisplayAddress;
    @VisibleForTesting
    public static final int DEST_PORT_FLAG_NO_PORT = 65536;
    private static final int DEST_PORT_FLAG_3GPP = 131072;
    @VisibleForTesting
    public static final int DEST_PORT_FLAG_3GPP2 = 262144;
    @VisibleForTesting
    public static final int DEST_PORT_FLAG_3GPP2_WAP_PDU = 524288;
    private static final int DEST_PORT_MASK = 65535;
    @VisibleForTesting
    public static final String SELECT_BY_REFERENCE = "address=? AND reference_number=? AND count=? AND (destination_port & 524288=0) AND deleted=0";
    @VisibleForTesting
    public static final String SELECT_BY_REFERENCE_3GPP2WAP = "address=? AND reference_number=? AND count=? AND (destination_port & 524288=524288) AND deleted=0";

    public InboundSmsTracker(byte[] pdu, long timestamp, int destPort, boolean is3gpp2, boolean is3gpp2WapPdu, String address, String displayAddress, String messageBody, boolean isClass0) {
        this.mPdu = pdu;
        this.mTimestamp = timestamp;
        this.mDestPort = destPort;
        this.mIs3gpp2 = is3gpp2;
        this.mIs3gpp2WapPdu = is3gpp2WapPdu;
        this.mMessageBody = messageBody;
        this.mAddress = address;
        this.mDisplayAddress = displayAddress;
        this.mIsClass0 = isClass0;
        this.mReferenceNumber = -1;
        this.mSequenceNumber = this.getIndexOffset();
        this.mMessageCount = 1;
    }

    public InboundSmsTracker(byte[] pdu, long timestamp, int destPort, boolean is3gpp2, String address, String displayAddress, int referenceNumber, int sequenceNumber, int messageCount, boolean is3gpp2WapPdu, String messageBody, boolean isClass0) {
        this.mPdu = pdu;
        this.mTimestamp = timestamp;
        this.mDestPort = destPort;
        this.mIs3gpp2 = is3gpp2;
        this.mIs3gpp2WapPdu = is3gpp2WapPdu;
        this.mMessageBody = messageBody;
        this.mIsClass0 = isClass0;
        this.mDisplayAddress = displayAddress;
        this.mAddress = address;
        this.mReferenceNumber = referenceNumber;
        this.mSequenceNumber = sequenceNumber;
        this.mMessageCount = messageCount;
    }

    public InboundSmsTracker(Cursor cursor, boolean isCurrentFormat3gpp2) {
        this.mPdu = HexDump.hexStringToByteArray(cursor.getString(0));
        this.mIsClass0 = false;
        if (cursor.isNull(2)) {
            this.mDestPort = -1;
            this.mIs3gpp2 = isCurrentFormat3gpp2;
            this.mIs3gpp2WapPdu = false;
        } else {
            int destPort = cursor.getInt(2);
            this.mIs3gpp2 = (destPort & 0x20000) != 0 ? false : ((destPort & 0x40000) != 0 ? true : isCurrentFormat3gpp2);
            this.mIs3gpp2WapPdu = (destPort & 0x80000) != 0;
            this.mDestPort = InboundSmsTracker.getRealDestPort(destPort);
        }
        this.mTimestamp = cursor.getLong(3);
        this.mAddress = cursor.getString(6);
        this.mDisplayAddress = cursor.getString(9);
        if (cursor.getInt(5) == 1) {
            long rowId = cursor.getLong(7);
            this.mReferenceNumber = -1;
            this.mSequenceNumber = this.getIndexOffset();
            this.mMessageCount = 1;
            this.mDeleteWhere = "_id=?";
            this.mDeleteWhereArgs = new String[]{Long.toString(rowId)};
        } else {
            this.mReferenceNumber = cursor.getInt(4);
            this.mMessageCount = cursor.getInt(5);
            this.mSequenceNumber = cursor.getInt(1);
            int index = this.mSequenceNumber - this.getIndexOffset();
            if (index < 0 || index >= this.mMessageCount) {
                throw new IllegalArgumentException("invalid PDU sequence " + this.mSequenceNumber + " of " + this.mMessageCount);
            }
            this.mDeleteWhere = this.getQueryForSegments();
            this.mDeleteWhereArgs = new String[]{this.mAddress, Integer.toString(this.mReferenceNumber), Integer.toString(this.mMessageCount)};
        }
        this.mMessageBody = cursor.getString(8);
    }

    public ContentValues getContentValues() {
        ContentValues values = new ContentValues();
        values.put("pdu", HexDump.toHexString(this.mPdu));
        values.put("date", this.mTimestamp);
        int destPort = this.mDestPort == -1 ? 65536 : this.mDestPort & 0xFFFF;
        destPort = this.mIs3gpp2 ? (destPort |= 0x40000) : (destPort |= 0x20000);
        if (this.mIs3gpp2WapPdu) {
            destPort |= 0x80000;
        }
        values.put("destination_port", destPort);
        if (this.mAddress != null) {
            values.put("address", this.mAddress);
            values.put("display_originating_addr", this.mDisplayAddress);
            values.put("reference_number", this.mReferenceNumber);
            values.put("sequence", this.mSequenceNumber);
        }
        values.put("count", this.mMessageCount);
        values.put("message_body", this.mMessageBody);
        return values;
    }

    public static int getRealDestPort(int destPort) {
        if ((destPort & 0x10000) != 0) {
            return -1;
        }
        return destPort & 0xFFFF;
    }

    public void setDeleteWhere(String deleteWhere, String[] deleteWhereArgs) {
        this.mDeleteWhere = deleteWhere;
        this.mDeleteWhereArgs = deleteWhereArgs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SmsTracker{timestamp=");
        builder.append(new Date(this.mTimestamp));
        builder.append(" destPort=").append(this.mDestPort);
        builder.append(" is3gpp2=").append(this.mIs3gpp2);
        builder.append(" display_originating_addr=").append(this.mDisplayAddress);
        builder.append(" refNumber=").append(this.mReferenceNumber);
        builder.append(" seqNumber=").append(this.mSequenceNumber);
        builder.append(" msgCount=").append(this.mMessageCount);
        if (this.mDeleteWhere != null) {
            builder.append(" deleteWhere(").append(this.mDeleteWhere);
            builder.append(") deleteArgs=(").append(Arrays.toString(this.mDeleteWhereArgs));
            builder.append(')');
        }
        builder.append('}');
        return builder.toString();
    }

    public byte[] getPdu() {
        return this.mPdu;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public int getDestPort() {
        return this.mDestPort;
    }

    public boolean is3gpp2() {
        return this.mIs3gpp2;
    }

    public boolean isClass0() {
        return this.mIsClass0;
    }

    @UnsupportedAppUsage
    public String getFormat() {
        return this.mIs3gpp2 ? "3gpp2" : "3gpp";
    }

    public String getQueryForSegments() {
        return this.mIs3gpp2WapPdu ? SELECT_BY_REFERENCE_3GPP2WAP : SELECT_BY_REFERENCE;
    }

    public Pair<String, String[]> getExactMatchDupDetectQuery() {
        String address = this.getAddress();
        String refNumber = Integer.toString(this.getReferenceNumber());
        String count = Integer.toString(this.getMessageCount());
        String seqNumber = Integer.toString(this.getSequenceNumber());
        String date = Long.toString(this.getTimestamp());
        String messageBody = this.getMessageBody();
        String where = "address=? AND reference_number=? AND count=? AND sequence=? AND date=? AND message_body=?";
        where = this.addDestPortQuery(where);
        String[] whereArgs = new String[]{address, refNumber, count, seqNumber, date, messageBody};
        return new Pair<String, String[]>(where, whereArgs);
    }

    public Pair<String, String[]> getInexactMatchDupDetectQuery() {
        if (this.getMessageCount() == 1) {
            return null;
        }
        String address = this.getAddress();
        String refNumber = Integer.toString(this.getReferenceNumber());
        String count = Integer.toString(this.getMessageCount());
        String seqNumber = Integer.toString(this.getSequenceNumber());
        String where = "address=? AND reference_number=? AND count=? AND sequence=? AND deleted=0";
        where = this.addDestPortQuery(where);
        String[] whereArgs = new String[]{address, refNumber, count, seqNumber};
        return new Pair<String, String[]>(where, whereArgs);
    }

    private String addDestPortQuery(String where) {
        String whereDestPort = this.mIs3gpp2WapPdu ? "destination_port & 524288=524288" : "destination_port & 524288=0";
        return where + " AND (" + whereDestPort + ")";
    }

    @UnsupportedAppUsage
    public int getIndexOffset() {
        return this.mIs3gpp2 && this.mIs3gpp2WapPdu ? 0 : 1;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public String getDisplayAddress() {
        return this.mDisplayAddress;
    }

    public String getMessageBody() {
        return this.mMessageBody;
    }

    public int getReferenceNumber() {
        return this.mReferenceNumber;
    }

    public int getSequenceNumber() {
        return this.mSequenceNumber;
    }

    public int getMessageCount() {
        return this.mMessageCount;
    }

    public String getDeleteWhere() {
        return this.mDeleteWhere;
    }

    public String[] getDeleteWhereArgs() {
        return this.mDeleteWhereArgs;
    }
}

