/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.CellInfo;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.LocalLog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.NitzStateMachine;
import com.android.internal.telephony.Phone;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class LocaleTracker
extends Handler {
    private static final boolean DBG = true;
    private static final String TAG = LocaleTracker.class.getSimpleName();
    private static final int EVENT_REQUEST_CELL_INFO = 1;
    private static final int EVENT_SERVICE_STATE_CHANGED = 2;
    private static final int EVENT_SIM_STATE_CHANGED = 3;
    private static final int EVENT_UNSOL_CELL_INFO = 4;
    private static final int EVENT_RESPONSE_CELL_INFO = 5;
    private static final long CELL_INFO_MIN_DELAY_MS = 2000L;
    private static final long CELL_INFO_MAX_DELAY_MS = 600000L;
    private static final long CELL_INFO_PERIODIC_POLLING_DELAY_MS = 600000L;
    private static final int MAX_FAIL_COUNT = 30;
    private final Phone mPhone;
    private final NitzStateMachine mNitzStateMachine;
    private int mSimState;
    private String mOperatorNumeric;
    private List<CellInfo> mCellInfoList;
    private int mFailCellInfoCount;
    private String mCurrentCountryIso;
    private int mLastServiceState = 3;
    private boolean mIsTracking = false;
    private final LocalLog mLocalLog = new LocalLog(50);
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            int phoneId;
            if ("android.telephony.action.SIM_CARD_STATE_CHANGED".equals(intent.getAction()) && (phoneId = intent.getIntExtra("phone", 0)) == LocaleTracker.this.mPhone.getPhoneId()) {
                LocaleTracker.this.obtainMessage(3, intent.getIntExtra("android.telephony.extra.SIM_STATE", 0), 0).sendToTarget();
            }
        }
    };

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.mPhone.requestCellInfoUpdate(null, this.obtainMessage(5));
                break;
            }
            case 4: {
                this.processCellInfo((AsyncResult)msg.obj);
                if (this.mCellInfoList == null || this.mCellInfoList.size() <= 0) break;
                this.requestNextCellInfo(true);
                break;
            }
            case 5: {
                this.processCellInfo((AsyncResult)msg.obj);
                this.requestNextCellInfo(this.mCellInfoList != null && this.mCellInfoList.size() > 0);
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onServiceStateChanged((ServiceState)ar.result);
                break;
            }
            case 3: {
                this.onSimCardStateChanged(msg.arg1);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected message arrives. msg = " + msg.what);
            }
        }
    }

    public LocaleTracker(Phone phone, NitzStateMachine nitzStateMachine, Looper looper) {
        super(looper);
        this.mPhone = phone;
        this.mNitzStateMachine = nitzStateMachine;
        this.mSimState = 0;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.telephony.action.SIM_CARD_STATE_CHANGED");
        this.mPhone.getContext().registerReceiver(this.mBroadcastReceiver, filter);
        this.mPhone.registerForServiceStateChanged(this, 2, null);
        this.mPhone.registerForCellInfo(this, 4, null);
    }

    public String getCurrentCountry() {
        return this.mCurrentCountryIso != null ? this.mCurrentCountryIso : "";
    }

    private String getMccFromCellInfo() {
        String selectedMcc = null;
        if (this.mCellInfoList != null) {
            HashMap<String, Integer> countryCodeMap = new HashMap<String, Integer>();
            int maxCount = 0;
            for (CellInfo cellInfo : this.mCellInfoList) {
                String mcc = null;
                if (cellInfo instanceof CellInfoGsm) {
                    mcc = ((CellInfoGsm)cellInfo).getCellIdentity().getMccString();
                } else if (cellInfo instanceof CellInfoLte) {
                    mcc = ((CellInfoLte)cellInfo).getCellIdentity().getMccString();
                } else if (cellInfo instanceof CellInfoWcdma) {
                    mcc = ((CellInfoWcdma)cellInfo).getCellIdentity().getMccString();
                }
                if (mcc == null) continue;
                int count = 1;
                if (countryCodeMap.containsKey(mcc)) {
                    count = (Integer)countryCodeMap.get(mcc) + 1;
                }
                countryCodeMap.put(mcc, count);
                if (count <= maxCount) continue;
                maxCount = count;
                selectedMcc = mcc;
            }
        }
        return selectedMcc;
    }

    private synchronized void onSimCardStateChanged(int state) {
        this.mSimState = state;
        this.updateLocale();
        this.updateTrackingStatus();
    }

    private void onServiceStateChanged(ServiceState serviceState) {
        this.mLastServiceState = serviceState.getState();
        this.updateLocale();
        this.updateTrackingStatus();
    }

    public void updateOperatorNumeric(String operatorNumeric) {
        if (!Objects.equals(this.mOperatorNumeric, operatorNumeric)) {
            String msg = "Operator numeric changes to \"" + operatorNumeric + "\"";
            this.log(msg);
            this.mLocalLog.log(msg);
            this.mOperatorNumeric = operatorNumeric;
            this.updateLocale();
        }
    }

    private void processCellInfo(AsyncResult ar) {
        if (ar == null || ar.exception != null) {
            this.mCellInfoList = null;
            return;
        }
        List cellInfoList = (List)ar.result;
        String msg = "processCellInfo: cell info=" + cellInfoList;
        this.log(msg);
        this.mCellInfoList = cellInfoList;
        this.updateLocale();
    }

    private void requestNextCellInfo(boolean succeeded) {
        if (!this.mIsTracking) {
            return;
        }
        this.removeMessages(1);
        if (succeeded) {
            this.resetCellInfoRetry();
            this.removeMessages(4);
            this.removeMessages(5);
            this.sendMessageDelayed(this.obtainMessage(1), 600000L);
        } else {
            long delay = LocaleTracker.getCellInfoDelayTime(++this.mFailCellInfoCount);
            this.log("Can't get cell info. Try again in " + delay / 1000L + " secs.");
            this.sendMessageDelayed(this.obtainMessage(1), delay);
        }
    }

    @VisibleForTesting
    public static long getCellInfoDelayTime(int failCount) {
        long delay = 2000L * (long)Math.pow(2.0, Math.min(failCount, 30) - 1);
        return Math.min(Math.max(delay, 2000L), 600000L);
    }

    private void resetCellInfoRetry() {
        this.mFailCellInfoCount = 0;
        this.removeMessages(1);
    }

    private void updateTrackingStatus() {
        boolean shouldTrackLocale;
        boolean bl = shouldTrackLocale = !(this.mSimState != 1 && !TextUtils.isEmpty(this.mOperatorNumeric) || this.mLastServiceState != 1 && this.mLastServiceState != 2);
        if (shouldTrackLocale) {
            this.startTracking();
        } else {
            this.stopTracking();
        }
    }

    private void stopTracking() {
        if (!this.mIsTracking) {
            return;
        }
        this.mIsTracking = false;
        String msg = "Stopping LocaleTracker";
        this.log(msg);
        this.mLocalLog.log(msg);
        this.mCellInfoList = null;
        this.resetCellInfoRetry();
    }

    private void startTracking() {
        if (this.mIsTracking) {
            return;
        }
        String msg = "Starting LocaleTracker";
        this.mLocalLog.log(msg);
        this.log(msg);
        this.mIsTracking = true;
        this.sendMessage(this.obtainMessage(1));
    }

    private synchronized void updateLocale() {
        String mcc = null;
        String countryIso = "";
        if (!TextUtils.isEmpty(this.mOperatorNumeric)) {
            try {
                mcc = this.mOperatorNumeric.substring(0, 3);
                countryIso = MccTable.countryCodeForMcc(mcc);
            }
            catch (StringIndexOutOfBoundsException ex) {
                this.loge("updateLocale: Can't get country from operator numeric. mcc = " + mcc + ". ex=" + ex);
            }
        }
        if (TextUtils.isEmpty(countryIso)) {
            mcc = this.getMccFromCellInfo();
            countryIso = MccTable.countryCodeForMcc(mcc);
        }
        this.log("updateLocale: mcc = " + mcc + ", country = " + countryIso);
        boolean countryChanged = false;
        if (!Objects.equals(countryIso, this.mCurrentCountryIso)) {
            String msg = "updateLocale: Change the current country to \"" + countryIso + "\", mcc = " + mcc + ", mCellInfoList = " + this.mCellInfoList;
            this.log(msg);
            this.mLocalLog.log(msg);
            this.mCurrentCountryIso = countryIso;
            TelephonyManager.setTelephonyProperty(this.mPhone.getPhoneId(), "gsm.operator.iso-country", this.mCurrentCountryIso);
            WifiManager wifiManager = (WifiManager)this.mPhone.getContext().getSystemService("wifi");
            if (wifiManager != null) {
                wifiManager.setCountryCode(countryIso);
            } else {
                msg = "Wifi manager is not available.";
                this.log(msg);
                this.mLocalLog.log(msg);
            }
            Intent intent = new Intent("android.telephony.action.NETWORK_COUNTRY_CHANGED");
            intent.putExtra("android.telephony.extra.NETWORK_COUNTRY", countryIso);
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
            this.mPhone.getContext().sendBroadcast(intent);
            countryChanged = true;
        }
        if (TextUtils.isEmpty(countryIso)) {
            this.mNitzStateMachine.handleNetworkCountryCodeUnavailable();
        } else {
            this.mNitzStateMachine.handleNetworkCountryCodeSet(countryChanged);
        }
    }

    public boolean isTracking() {
        return this.mIsTracking;
    }

    private void log(String msg) {
        Rlog.d(TAG, msg);
    }

    private void loge(String msg) {
        Rlog.e(TAG, msg);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        pw.println("LocaleTracker:");
        ipw.increaseIndent();
        ipw.println("mIsTracking = " + this.mIsTracking);
        ipw.println("mOperatorNumeric = " + this.mOperatorNumeric);
        ipw.println("mSimState = " + this.mSimState);
        ipw.println("mCellInfoList = " + this.mCellInfoList);
        ipw.println("mCurrentCountryIso = " + this.mCurrentCountryIso);
        ipw.println("mFailCellInfoCount = " + this.mFailCellInfoCount);
        ipw.println("Local logs:");
        ipw.increaseIndent();
        this.mLocalLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.decreaseIndent();
        ipw.flush();
    }
}

