/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelUuid;
import android.provider.Settings;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.GlobalSettingsHelper;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.util.ArrayUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MultiSimSettingController
extends Handler {
    private static final String LOG_TAG = "MultiSimSettingController";
    private static final boolean DBG = true;
    private static final int EVENT_USER_DATA_ENABLED = 1;
    private static final int EVENT_ROAMING_DATA_ENABLED = 2;
    private static final int EVENT_ALL_SUBSCRIPTIONS_LOADED = 3;
    private static final int EVENT_SUBSCRIPTION_INFO_CHANGED = 4;
    private static final int EVENT_SUBSCRIPTION_GROUP_CHANGED = 5;
    private static final int EVENT_DEFAULT_DATA_SUBSCRIPTION_CHANGED = 6;
    private static final int PRIMARY_SUB_NO_CHANGE = 0;
    private static final int PRIMARY_SUB_ADDED = 1;
    private static final int PRIMARY_SUB_REMOVED = 2;
    private static final int PRIMARY_SUB_SWAPPED = 3;
    private static final int PRIMARY_SUB_SWAPPED_IN_GROUP = 4;
    private static final int PRIMARY_SUB_MARKED_OPPT = 5;
    private static final int PRIMARY_SUB_INITIALIZED = 6;
    private final Context mContext;
    private final SubscriptionController mSubController;
    private List<Integer> mPrimarySubList = new ArrayList<Integer>();
    private static MultiSimSettingController sInstance = null;
    private boolean mSubInfoInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiSimSettingController getInstance() {
        Class<SubscriptionController> clazz = SubscriptionController.class;
        synchronized (SubscriptionController.class) {
            if (sInstance == null) {
                Log.wtf(LOG_TAG, "getInstance null");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiSimSettingController init(Context context, SubscriptionController sc) {
        Class<SubscriptionController> clazz = SubscriptionController.class;
        synchronized (SubscriptionController.class) {
            if (sInstance == null) {
                sInstance = new MultiSimSettingController(context, sc);
            } else {
                Log.wtf(LOG_TAG, "init() called multiple times!  sInstance = " + sInstance);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    @VisibleForTesting
    public MultiSimSettingController(Context context, SubscriptionController sc) {
        this.mContext = context;
        this.mSubController = sc;
    }

    public void notifyUserDataEnabled(int subId, boolean enable) {
        this.obtainMessage(1, subId, enable ? 1 : 0).sendToTarget();
    }

    public void notifyRoamingDataEnabled(int subId, boolean enable) {
        this.obtainMessage(2, subId, enable ? 1 : 0).sendToTarget();
    }

    public void notifyAllSubscriptionLoaded() {
        this.obtainMessage(3).sendToTarget();
    }

    public void notifySubscriptionInfoChanged() {
        this.obtainMessage(4).sendToTarget();
    }

    public void notifySubscriptionGroupChanged(ParcelUuid groupUuid) {
        this.obtainMessage(5, groupUuid).sendToTarget();
    }

    public void notifyDefaultDataSubChanged() {
        this.obtainMessage(6).sendToTarget();
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                int subId = msg.arg1;
                boolean enable = msg.arg2 != 0;
                this.onUserDataEnabled(subId, enable);
                break;
            }
            case 2: {
                int subId = msg.arg1;
                boolean enable = msg.arg2 != 0;
                this.onRoamingDataEnabled(subId, enable);
                break;
            }
            case 3: {
                this.onAllSubscriptionsLoaded();
                break;
            }
            case 4: {
                this.onSubscriptionsChanged();
                break;
            }
            case 5: {
                ParcelUuid groupUuid = (ParcelUuid)msg.obj;
                this.onSubscriptionGroupChanged(groupUuid);
                break;
            }
            case 6: {
                this.onDefaultDataSettingChanged();
            }
        }
    }

    private void onUserDataEnabled(int subId, boolean enable) {
        this.log("onUserDataEnabled");
        this.setUserDataEnabledForGroup(subId, enable);
        if (this.mSubController.getDefaultDataSubId() != subId && !this.mSubController.isOpportunistic(subId) && enable) {
            this.mSubController.setDefaultDataSubId(subId);
        }
    }

    private void onRoamingDataEnabled(int subId, boolean enable) {
        this.log("onRoamingDataEnabled");
        this.setRoamingDataEnabledForGroup(subId, enable);
        this.mSubController.setDataRoaming(enable ? 1 : 0, subId);
    }

    private void onAllSubscriptionsLoaded() {
        this.log("onAllSubscriptionsLoaded");
        this.mSubInfoInitialized = true;
        this.updateDefaults(true);
        this.disableDataForNonDefaultNonOpportunisticSubscriptions();
    }

    private void onSubscriptionsChanged() {
        this.log("onSubscriptionsChanged");
        if (!this.mSubInfoInitialized) {
            return;
        }
        this.updateDefaults(false);
        this.disableDataForNonDefaultNonOpportunisticSubscriptions();
    }

    private void onDefaultDataSettingChanged() {
        this.log("onDefaultDataSettingChanged");
        this.disableDataForNonDefaultNonOpportunisticSubscriptions();
    }

    private void onSubscriptionGroupChanged(ParcelUuid groupUuid) {
        this.log("onSubscriptionGroupChanged");
        List<SubscriptionInfo> infoList = this.mSubController.getSubscriptionsInGroup(groupUuid, this.mContext.getOpPackageName());
        if (infoList == null || infoList.isEmpty()) {
            return;
        }
        int refSubId = infoList.get(0).getSubscriptionId();
        for (SubscriptionInfo info : infoList) {
            int subId = info.getSubscriptionId();
            if (!this.mSubController.isActiveSubId(subId) || this.mSubController.isOpportunistic(subId)) continue;
            refSubId = subId;
            break;
        }
        this.log("refSubId is " + refSubId);
        boolean enable = false;
        try {
            enable = GlobalSettingsHelper.getBoolean(this.mContext, "mobile_data", refSubId);
            this.onUserDataEnabled(refSubId, enable);
        }
        catch (Settings.SettingNotFoundException exception) {
            enable = GlobalSettingsHelper.getBoolean(this.mContext, "mobile_data", -1, enable);
            this.onUserDataEnabled(refSubId, enable);
        }
        enable = false;
        try {
            enable = GlobalSettingsHelper.getBoolean(this.mContext, "data_roaming", refSubId);
            this.onRoamingDataEnabled(refSubId, enable);
        }
        catch (Settings.SettingNotFoundException exception) {
            enable = GlobalSettingsHelper.getBoolean(this.mContext, "data_roaming", -1, enable);
            this.onRoamingDataEnabled(refSubId, enable);
        }
        this.mSubController.syncGroupedSetting(refSubId);
    }

    private void updateDefaults(boolean init) {
        this.log("updateDefaults");
        if (!this.mSubInfoInitialized) {
            return;
        }
        List<SubscriptionInfo> activeSubInfos = this.mSubController.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
        if (ArrayUtils.isEmpty(activeSubInfos)) {
            this.mPrimarySubList.clear();
            this.log("[updateDefaultValues] No active sub. Setting default to INVALID sub.");
            this.mSubController.setDefaultDataSubId(-1);
            this.mSubController.setDefaultVoiceSubId(-1);
            this.mSubController.setDefaultSmsSubId(-1);
            return;
        }
        int change = this.updatePrimarySubListAndGetChangeType(activeSubInfos, init);
        this.log("[updateDefaultValues] change: " + change);
        if (change == 0) {
            return;
        }
        if (this.mPrimarySubList.size() == 1 && change != 2) {
            int subId = this.mPrimarySubList.get(0);
            this.log("[updateDefaultValues] to only primary sub " + subId);
            this.mSubController.setDefaultDataSubId(subId);
            this.mSubController.setDefaultVoiceSubId(subId);
            this.mSubController.setDefaultSmsSubId(subId);
            return;
        }
        this.log("[updateDefaultValues] records: " + this.mPrimarySubList);
        this.log("[updateDefaultValues] Update default data subscription");
        boolean dataSelected = this.updateDefaultValue(this.mPrimarySubList, this.mSubController.getDefaultDataSubId(), newValue -> this.mSubController.setDefaultDataSubId(newValue));
        this.log("[updateDefaultValues] Update default voice subscription");
        boolean voiceSelected = this.updateDefaultValue(this.mPrimarySubList, this.mSubController.getDefaultVoiceSubId(), newValue -> this.mSubController.setDefaultVoiceSubId(newValue));
        this.log("[updateDefaultValues] Update default sms subscription");
        boolean smsSelected = this.updateDefaultValue(this.mPrimarySubList, this.mSubController.getDefaultSmsSubId(), newValue -> this.mSubController.setDefaultSmsSubId(newValue));
        this.sendSubChangeNotificationIfNeeded(change, dataSelected, voiceSelected, smsSelected);
    }

    private int updatePrimarySubListAndGetChangeType(List<SubscriptionInfo> activeSubList, boolean init) {
        List<Integer> prevPrimarySubList = this.mPrimarySubList;
        this.mPrimarySubList = activeSubList.stream().filter(info -> !info.isOpportunistic()).map(info -> info.getSubscriptionId()).collect(Collectors.toList());
        if (init) {
            return 6;
        }
        if (this.mPrimarySubList.equals(prevPrimarySubList)) {
            return 0;
        }
        if (this.mPrimarySubList.size() > prevPrimarySubList.size()) {
            return 1;
        }
        if (this.mPrimarySubList.size() == prevPrimarySubList.size()) {
            for (int subId : this.mPrimarySubList) {
                boolean swappedInSameGroup = false;
                for (int prevSubId : prevPrimarySubList) {
                    if (!this.areSubscriptionsInSameGroup(subId, prevSubId)) continue;
                    swappedInSameGroup = true;
                    break;
                }
                if (swappedInSameGroup) continue;
                return 3;
            }
            return 4;
        }
        for (int subId : prevPrimarySubList) {
            if (this.mPrimarySubList.contains(subId)) continue;
            if (!this.mSubController.isActiveSubId(subId)) {
                return 2;
            }
            if (this.mSubController.isOpportunistic(subId)) continue;
            this.loge("[updatePrimarySubListAndGetChangeType]: missing active primary subId " + subId);
        }
        return 5;
    }

    private void sendSubChangeNotificationIfNeeded(int change, boolean dataSelected, boolean voiceSelected, boolean smsSelected) {
        int simSelectDialogType = this.getSimSelectDialogType(change, dataSelected, voiceSelected, smsSelected);
        SimCombinationWarningParams simCombinationParams = this.getSimCombinationWarningParams(change);
        if (simSelectDialogType != 0 || simCombinationParams.mWarningType != 0) {
            this.log("[sendSubChangeNotificationIfNeeded] showing dialog type " + simSelectDialogType);
            this.log("[sendSubChangeNotificationIfNeeded] showing sim warning " + simCombinationParams.mWarningType);
            Intent intent = new Intent();
            intent.setAction("android.telephony.action.PRIMARY_SUBSCRIPTION_LIST_CHANGED");
            intent.setClassName("com.android.settings", "com.android.settings.sim.SimSelectNotification");
            intent.addFlags(0x10000000);
            intent.putExtra("android.telephony.extra.DEFAULT_SUBSCRIPTION_SELECT_TYPE", simSelectDialogType);
            if (simSelectDialogType == 4) {
                intent.putExtra("android.telephony.extra.SUBSCRIPTION_ID", this.mPrimarySubList.get(0));
            }
            intent.putExtra("android.telephony.extra.SIM_COMBINATION_WARNING_TYPE", simCombinationParams.mWarningType);
            if (simCombinationParams.mWarningType == 1) {
                intent.putExtra("android.telephony.extra.SIM_COMBINATION_NAMES", simCombinationParams.mSimNames);
            }
            this.mContext.sendBroadcast(intent);
        }
    }

    private int getSimSelectDialogType(int change, boolean dataSelected, boolean voiceSelected, boolean smsSelected) {
        int dialogType = 0;
        if (!(this.mPrimarySubList.size() != 1 || change != 2 || dataSelected && smsSelected && voiceSelected)) {
            dialogType = 4;
        } else if (this.mPrimarySubList.size() > 1 && this.isUserVisibleChange(change)) {
            dialogType = 1;
        }
        return dialogType;
    }

    private SimCombinationWarningParams getSimCombinationWarningParams(int change) {
        SimCombinationWarningParams params = new SimCombinationWarningParams();
        if (this.mPrimarySubList.size() <= 1) {
            return params;
        }
        if (!this.isUserVisibleChange(change)) {
            return params;
        }
        ArrayList<String> simNames = new ArrayList<String>();
        int cdmaPhoneCount = 0;
        for (int subId : this.mPrimarySubList) {
            Phone phone = PhoneFactory.getPhone(SubscriptionManager.getPhoneId(subId));
            if (phone == null || !phone.isCdmaSubscriptionAppPresent()) continue;
            ++cdmaPhoneCount;
            String simName = this.mSubController.getActiveSubscriptionInfo(subId, this.mContext.getOpPackageName()).getDisplayName().toString();
            if (TextUtils.isEmpty(simName)) {
                simName = phone.getCarrierName();
            }
            simNames.add(simName);
        }
        if (cdmaPhoneCount > 1) {
            params.mWarningType = 1;
            params.mSimNames = String.join((CharSequence)" & ", simNames);
        }
        return params;
    }

    private boolean isUserVisibleChange(int change) {
        return change == 1 || change == 2 || change == 3;
    }

    private void disableDataForNonDefaultNonOpportunisticSubscriptions() {
        if (!this.mSubInfoInitialized) {
            return;
        }
        int defaultDataSub = this.mSubController.getDefaultDataSubId();
        for (Phone phone : PhoneFactory.getPhones()) {
            if (phone.getSubId() == defaultDataSub || !SubscriptionManager.isValidSubscriptionId(phone.getSubId()) || this.mSubController.isOpportunistic(phone.getSubId()) || !phone.isUserDataEnabled() || this.areSubscriptionsInSameGroup(defaultDataSub, phone.getSubId())) continue;
            this.log("setting data to false on " + phone.getSubId());
            phone.getDataEnabledSettings().setUserDataEnabled(false);
        }
    }

    private boolean areSubscriptionsInSameGroup(int subId1, int subId2) {
        if (!SubscriptionManager.isUsableSubscriptionId(subId1) || !SubscriptionManager.isUsableSubscriptionId(subId2)) {
            return false;
        }
        if (subId1 == subId2) {
            return true;
        }
        ParcelUuid groupUuid1 = this.mSubController.getGroupUuid(subId1);
        ParcelUuid groupUuid2 = this.mSubController.getGroupUuid(subId2);
        return groupUuid1 != null && groupUuid1.equals(groupUuid2);
    }

    private void setUserDataEnabledForGroup(int subId, boolean enable) {
        this.log("setUserDataEnabledForGroup subId " + subId + " enable " + enable);
        List<SubscriptionInfo> infoList = this.mSubController.getSubscriptionsInGroup(this.mSubController.getGroupUuid(subId), this.mContext.getOpPackageName());
        if (infoList == null) {
            return;
        }
        for (SubscriptionInfo info : infoList) {
            int currentSubId = info.getSubscriptionId();
            if (this.mSubController.isActiveSubId(currentSubId)) {
                Phone phone = PhoneFactory.getPhone(this.mSubController.getPhoneId(currentSubId));
                if (phone == null) continue;
                phone.getDataEnabledSettings().setUserDataEnabled(enable);
                continue;
            }
            GlobalSettingsHelper.setBoolean(this.mContext, "mobile_data", currentSubId, enable);
        }
    }

    private void setRoamingDataEnabledForGroup(int subId, boolean enable) {
        SubscriptionController subController = SubscriptionController.getInstance();
        List<SubscriptionInfo> infoList = subController.getSubscriptionsInGroup(this.mSubController.getGroupUuid(subId), this.mContext.getOpPackageName());
        if (infoList == null) {
            return;
        }
        for (SubscriptionInfo info : infoList) {
            GlobalSettingsHelper.setBoolean(this.mContext, "data_roaming", info.getSubscriptionId(), enable);
        }
    }

    private boolean updateDefaultValue(List<Integer> primarySubList, int oldValue, UpdateDefaultAction action) {
        int newValue = -1;
        if (primarySubList.size() > 0) {
            for (int subId : primarySubList) {
                this.log("[updateDefaultValue] Record.id: " + subId);
                if (!this.areSubscriptionsInSameGroup(subId, oldValue)) continue;
                newValue = subId;
                this.log("[updateDefaultValue] updates to subId=" + newValue);
                break;
            }
        }
        if (oldValue != newValue) {
            this.log("[updateDefaultValue: subId] from " + oldValue + " to " + newValue);
            action.update(newValue);
        }
        return SubscriptionManager.isValidSubscriptionId(newValue);
    }

    private void log(String msg) {
        Log.d(LOG_TAG, msg);
    }

    private void loge(String msg) {
        Log.e(LOG_TAG, msg);
    }

    private static interface UpdateDefaultAction {
        public void update(int var1);
    }

    private class SimCombinationWarningParams {
        int mWarningType = 0;
        String mSimNames;

        private SimCombinationWarningParams() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface PrimarySubChangeType {
    }
}

