/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.os.UserHandle;
import android.telephony.AccessNetworkConstants;
import android.telephony.CarrierConfigManager;
import android.telephony.INetworkService;
import android.telephony.INetworkServiceCallback;
import android.telephony.NetworkRegistrationInfo;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.Phone;
import java.util.Hashtable;
import java.util.Map;

public class NetworkRegistrationManager
extends Handler {
    private final String mTag;
    private static final int EVENT_BIND_NETWORK_SERVICE = 1;
    private final int mTransportType;
    private final Phone mPhone;
    private final CarrierConfigManager mCarrierConfigManager;
    private final RegistrantList mRegStateChangeRegistrants = new RegistrantList();
    private INetworkService mINetworkService;
    private RegManagerDeathRecipient mDeathRecipient;
    private String mTargetBindingPackageName;
    private NetworkServiceConnection mServiceConnection;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.telephony.action.CARRIER_CONFIG_CHANGED".equals(action) && NetworkRegistrationManager.this.mPhone.getPhoneId() == intent.getIntExtra("android.telephony.extra.SLOT_INDEX", 0)) {
                NetworkRegistrationManager.this.logd("Carrier config changed. Try to bind network service.");
                NetworkRegistrationManager.this.sendEmptyMessage(1);
            }
        }
    };
    private final Map<NetworkRegStateCallback, Message> mCallbackTable = new Hashtable<NetworkRegStateCallback, Message>();

    public NetworkRegistrationManager(int transportType, Phone phone) {
        this.mTransportType = transportType;
        this.mPhone = phone;
        String tagSuffix = "-" + (transportType == 1 ? "C" : "I");
        if (TelephonyManager.getDefault().getPhoneCount() > 1) {
            tagSuffix = tagSuffix + "-" + this.mPhone.getPhoneId();
        }
        this.mTag = "NRM" + tagSuffix;
        this.mCarrierConfigManager = (CarrierConfigManager)phone.getContext().getSystemService("carrier_config");
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        phone.getContext().registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, intentFilter, null, null);
        this.sendEmptyMessage(1);
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.bindService();
                break;
            }
            default: {
                this.loge("Unhandled event " + msg.what);
            }
        }
    }

    public boolean isServiceConnected() {
        return this.mINetworkService != null && this.mINetworkService.asBinder().isBinderAlive();
    }

    public void unregisterForNetworkRegistrationInfoChanged(Handler h) {
        this.mRegStateChangeRegistrants.remove(h);
    }

    public void registerForNetworkRegistrationInfoChanged(Handler h, int what, Object obj) {
        this.logd("registerForNetworkRegistrationInfoChanged");
        this.mRegStateChangeRegistrants.addUnique(h, what, obj);
    }

    public void requestNetworkRegistrationInfo(int domain, Message onCompleteMessage) {
        if (onCompleteMessage == null) {
            return;
        }
        if (!this.isServiceConnected()) {
            this.loge("service not connected. Domain = " + (domain == 1 ? "CS" : "PS"));
            onCompleteMessage.obj = new AsyncResult(onCompleteMessage.obj, null, new IllegalStateException("Service not connected."));
            onCompleteMessage.sendToTarget();
            return;
        }
        NetworkRegStateCallback callback = new NetworkRegStateCallback();
        try {
            this.mCallbackTable.put(callback, onCompleteMessage);
            this.mINetworkService.requestNetworkRegistrationInfo(this.mPhone.getPhoneId(), domain, callback);
        }
        catch (RemoteException e) {
            this.loge("requestNetworkRegistrationInfo RemoteException " + e);
            this.mCallbackTable.remove(callback);
            onCompleteMessage.obj = new AsyncResult(onCompleteMessage.obj, null, e);
            onCompleteMessage.sendToTarget();
        }
    }

    private void bindService() {
        String packageName = this.getPackageName();
        if (TextUtils.isEmpty(packageName)) {
            this.loge("Can't find the binding package");
            return;
        }
        if (TextUtils.equals(packageName, this.mTargetBindingPackageName)) {
            this.logd("Service " + packageName + " already bound or being bound.");
            return;
        }
        if (this.mINetworkService != null && this.mINetworkService.asBinder().isBinderAlive()) {
            try {
                this.mINetworkService.removeNetworkServiceProvider(this.mPhone.getPhoneId());
            }
            catch (RemoteException e) {
                this.loge("Cannot remove data service provider. " + e);
            }
            this.mPhone.getContext().unbindService(this.mServiceConnection);
        }
        Intent intent = new Intent("android.telephony.NetworkService");
        intent.setPackage(this.getPackageName());
        try {
            this.logd("Trying to bind " + this.getPackageName() + " for transport " + AccessNetworkConstants.transportTypeToString(this.mTransportType));
            this.mServiceConnection = new NetworkServiceConnection();
            if (!this.mPhone.getContext().bindService(intent, this.mServiceConnection, 1)) {
                this.loge("Cannot bind to the data service.");
                return;
            }
            this.mTargetBindingPackageName = packageName;
        }
        catch (SecurityException e) {
            this.loge("bindService failed " + e);
        }
    }

    private String getPackageName() {
        String carrierConfig;
        int resourceId;
        switch (this.mTransportType) {
            case 1: {
                resourceId = 17039790;
                carrierConfig = "carrier_network_service_wwan_package_override_string";
                break;
            }
            case 2: {
                resourceId = 17039788;
                carrierConfig = "carrier_network_service_wlan_package_override_string";
                break;
            }
            default: {
                throw new IllegalStateException("Transport type not WWAN or WLAN. type=" + this.mTransportType);
            }
        }
        String packageName = this.mPhone.getContext().getResources().getString(resourceId);
        PersistableBundle b = this.mCarrierConfigManager.getConfigForSubId(this.mPhone.getSubId());
        if (b != null && !TextUtils.isEmpty(b.getString(carrierConfig))) {
            packageName = b.getString(carrierConfig, packageName);
        }
        return packageName;
    }

    private void logd(String msg) {
        Rlog.d(this.mTag, msg);
    }

    private void loge(String msg) {
        Rlog.e(this.mTag, msg);
    }

    private class NetworkRegStateCallback
    extends INetworkServiceCallback.Stub {
        private NetworkRegStateCallback() {
        }

        @Override
        public void onRequestNetworkRegistrationInfoComplete(int result, NetworkRegistrationInfo info) {
            NetworkRegistrationManager.this.logd("onRequestNetworkRegistrationInfoComplete result: " + result + ", info: " + info);
            Message onCompleteMessage = (Message)NetworkRegistrationManager.this.mCallbackTable.remove(this);
            if (onCompleteMessage != null) {
                onCompleteMessage.arg1 = result;
                onCompleteMessage.obj = new AsyncResult(onCompleteMessage.obj, new NetworkRegistrationInfo(info), null);
                onCompleteMessage.sendToTarget();
            } else {
                NetworkRegistrationManager.this.loge("onCompleteMessage is null");
            }
        }

        @Override
        public void onNetworkStateChanged() {
            NetworkRegistrationManager.this.logd("onNetworkStateChanged");
            NetworkRegistrationManager.this.mRegStateChangeRegistrants.notifyRegistrants();
        }
    }

    private class NetworkServiceConnection
    implements ServiceConnection {
        private NetworkServiceConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            NetworkRegistrationManager.this.logd("service " + name + " for transport " + AccessNetworkConstants.transportTypeToString(NetworkRegistrationManager.this.mTransportType) + " is now connected.");
            NetworkRegistrationManager.this.mINetworkService = INetworkService.Stub.asInterface(service);
            NetworkRegistrationManager.this.mDeathRecipient = new RegManagerDeathRecipient(name);
            try {
                service.linkToDeath(NetworkRegistrationManager.this.mDeathRecipient, 0);
                NetworkRegistrationManager.this.mINetworkService.createNetworkServiceProvider(NetworkRegistrationManager.this.mPhone.getPhoneId());
                NetworkRegistrationManager.this.mINetworkService.registerForNetworkRegistrationInfoChanged(NetworkRegistrationManager.this.mPhone.getPhoneId(), new NetworkRegStateCallback());
            }
            catch (RemoteException exception) {
                NetworkRegistrationManager.this.mDeathRecipient.binderDied();
                NetworkRegistrationManager.this.logd("RemoteException " + exception);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            NetworkRegistrationManager.this.logd("service " + name + " for transport " + AccessNetworkConstants.transportTypeToString(NetworkRegistrationManager.this.mTransportType) + " is now disconnected.");
            NetworkRegistrationManager.this.mTargetBindingPackageName = null;
            if (NetworkRegistrationManager.this.mINetworkService != null) {
                NetworkRegistrationManager.this.mINetworkService.asBinder().unlinkToDeath(NetworkRegistrationManager.this.mDeathRecipient, 0);
            }
        }
    }

    private class RegManagerDeathRecipient
    implements IBinder.DeathRecipient {
        private final ComponentName mComponentName;

        RegManagerDeathRecipient(ComponentName name) {
            this.mComponentName = name;
        }

        @Override
        public void binderDied() {
            NetworkRegistrationManager.this.logd("NetworkService(" + this.mComponentName + " transport type " + NetworkRegistrationManager.this.mTransportType + ") died.");
        }
    }
}

