/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.telephony.CellInfo;
import android.telephony.LocationAccessPolicy;
import android.telephony.NetworkScanRequest;
import android.telephony.RadioAccessSpecifier;
import android.telephony.SubscriptionInfo;
import android.util.Log;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.NetworkScanResult;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SubscriptionController;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class NetworkScanRequestTracker {
    private static final String TAG = "ScanRequestTracker";
    private static final int CMD_START_NETWORK_SCAN = 1;
    private static final int EVENT_START_NETWORK_SCAN_DONE = 2;
    private static final int EVENT_RECEIVE_NETWORK_SCAN_RESULT = 3;
    private static final int CMD_STOP_NETWORK_SCAN = 4;
    private static final int EVENT_STOP_NETWORK_SCAN_DONE = 5;
    private static final int CMD_INTERRUPT_NETWORK_SCAN = 6;
    private static final int EVENT_INTERRUPT_NETWORK_SCAN_DONE = 7;
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    NetworkScanRequestTracker.this.mScheduler.doStartScan((NetworkScanRequestInfo)msg.obj);
                    break;
                }
                case 2: {
                    NetworkScanRequestTracker.this.mScheduler.startScanDone((AsyncResult)msg.obj);
                    break;
                }
                case 3: {
                    NetworkScanRequestTracker.this.mScheduler.receiveResult((AsyncResult)msg.obj);
                    break;
                }
                case 4: {
                    NetworkScanRequestTracker.this.mScheduler.doStopScan(msg.arg1);
                    break;
                }
                case 5: {
                    NetworkScanRequestTracker.this.mScheduler.stopScanDone((AsyncResult)msg.obj);
                    break;
                }
                case 6: {
                    NetworkScanRequestTracker.this.mScheduler.doInterruptScan(msg.arg1);
                    break;
                }
                case 7: {
                    NetworkScanRequestTracker.this.mScheduler.interruptScanDone((AsyncResult)msg.obj);
                }
            }
        }
    };
    private final AtomicInteger mNextNetworkScanRequestId = new AtomicInteger(1);
    private final NetworkScanRequestScheduler mScheduler = new NetworkScanRequestScheduler();

    private void logEmptyResultOrException(AsyncResult ar) {
        if (ar.result == null) {
            Log.e(TAG, "NetworkScanResult: Empty result");
        } else {
            Log.e(TAG, "NetworkScanResult: Exception: " + ar.exception);
        }
    }

    private boolean isValidScan(NetworkScanRequestInfo nsri) {
        if (nsri.mRequest == null || nsri.mRequest.getSpecifiers() == null) {
            return false;
        }
        if (nsri.mRequest.getSpecifiers().length > 8) {
            return false;
        }
        for (RadioAccessSpecifier ras : nsri.mRequest.getSpecifiers()) {
            if (ras.getRadioAccessNetwork() != 1 && ras.getRadioAccessNetwork() != 2 && ras.getRadioAccessNetwork() != 3) {
                return false;
            }
            if (ras.getBands() != null && ras.getBands().length > 8) {
                return false;
            }
            if (ras.getChannels() == null || ras.getChannels().length <= 32) continue;
            return false;
        }
        if (nsri.mRequest.getSearchPeriodicity() < 5 || nsri.mRequest.getSearchPeriodicity() > 300) {
            return false;
        }
        if (nsri.mRequest.getMaxSearchTime() < 60 || nsri.mRequest.getMaxSearchTime() > 3600) {
            return false;
        }
        if (nsri.mRequest.getIncrementalResultsPeriodicity() < 1 || nsri.mRequest.getIncrementalResultsPeriodicity() > 10) {
            return false;
        }
        if (nsri.mRequest.getSearchPeriodicity() > nsri.mRequest.getMaxSearchTime() || nsri.mRequest.getIncrementalResultsPeriodicity() > nsri.mRequest.getMaxSearchTime()) {
            return false;
        }
        return nsri.mRequest.getPlmns() == null || nsri.mRequest.getPlmns().size() <= 20;
    }

    private static boolean doesCellInfoCorrespondToKnownMccMnc(CellInfo ci, Collection<String> knownMccMncs) {
        String mccMnc = ci.getCellIdentity().getMccString() + ci.getCellIdentity().getMncString();
        return knownMccMncs.contains(mccMnc);
    }

    public static Set<String> getAllowedMccMncsForLocationRestrictedScan(Context context) {
        return Binder.withCleanCallingIdentity(() -> SubscriptionController.getInstance().getAvailableSubscriptionInfoList(context.getOpPackageName()).stream().flatMap(NetworkScanRequestTracker::getAllowableMccMncsFromSubscriptionInfo).collect(Collectors.toSet()));
    }

    private static Stream<String> getAllowableMccMncsFromSubscriptionInfo(SubscriptionInfo info) {
        Stream<String> plmns = Stream.of(info.getEhplmns(), info.getHplmns()).flatMap(Collection::stream);
        if (info.getMccString() != null && info.getMncString() != null) {
            plmns = Stream.concat(plmns, Stream.of(info.getMccString() + info.getMncString()));
        }
        return plmns;
    }

    private void notifyMessenger(NetworkScanRequestInfo nsri, int what, int err, List<CellInfo> result) {
        Messenger messenger = nsri.mMessenger;
        Message message = Message.obtain();
        message.what = what;
        message.arg1 = err;
        message.arg2 = nsri.mScanId;
        if (result != null) {
            if (what == 4) {
                Set<String> allowedMccMncs = NetworkScanRequestTracker.getAllowedMccMncsForLocationRestrictedScan(nsri.mPhone.getContext());
                result = result.stream().map(CellInfo::sanitizeLocationInfo).filter(ci -> NetworkScanRequestTracker.doesCellInfoCorrespondToKnownMccMnc(ci, allowedMccMncs)).collect(Collectors.toList());
            }
            Parcelable[] ci2 = result.toArray(new CellInfo[result.size()]);
            Bundle b = new Bundle();
            b.putParcelableArray("scanResult", ci2);
            message.setData(b);
        } else {
            message.obj = null;
        }
        try {
            messenger.send(message);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception in notifyMessenger: " + e);
        }
    }

    private void interruptNetworkScan(int scanId) {
        this.mHandler.obtainMessage(6, scanId, 0).sendToTarget();
    }

    public int startNetworkScan(NetworkScanRequest request, Messenger messenger, IBinder binder, Phone phone, int callingUid, int callingPid, String callingPackage) {
        int scanId = this.mNextNetworkScanRequestId.getAndIncrement();
        NetworkScanRequestInfo nsri = new NetworkScanRequestInfo(request, messenger, binder, scanId, phone, callingUid, callingPid, callingPackage);
        this.mHandler.obtainMessage(1, nsri).sendToTarget();
        return scanId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopNetworkScan(int scanId, int callingUid) {
        NetworkScanRequestScheduler networkScanRequestScheduler = this.mScheduler;
        synchronized (networkScanRequestScheduler) {
            if (!(this.mScheduler.mLiveRequestInfo != null && scanId == this.mScheduler.mLiveRequestInfo.mScanId && callingUid == this.mScheduler.mLiveRequestInfo.mUid || this.mScheduler.mPendingRequestInfo != null && scanId == this.mScheduler.mPendingRequestInfo.mScanId && callingUid == this.mScheduler.mPendingRequestInfo.mUid)) {
                throw new IllegalArgumentException("Scan with id: " + scanId + " does not exist!");
            }
            this.mHandler.obtainMessage(4, scanId, 0).sendToTarget();
        }
    }

    private class NetworkScanRequestScheduler {
        private NetworkScanRequestInfo mLiveRequestInfo;
        private NetworkScanRequestInfo mPendingRequestInfo;

        private NetworkScanRequestScheduler() {
        }

        private int rilErrorToScanError(int rilError) {
            switch (rilError) {
                case 0: {
                    return 0;
                }
                case 1: {
                    Log.e(NetworkScanRequestTracker.TAG, "rilErrorToScanError: RADIO_NOT_AVAILABLE");
                    return 1;
                }
                case 6: {
                    Log.e(NetworkScanRequestTracker.TAG, "rilErrorToScanError: REQUEST_NOT_SUPPORTED");
                    return 4;
                }
                case 37: {
                    Log.e(NetworkScanRequestTracker.TAG, "rilErrorToScanError: NO_MEMORY");
                    return 1;
                }
                case 38: {
                    Log.e(NetworkScanRequestTracker.TAG, "rilErrorToScanError: INTERNAL_ERR");
                    return 1;
                }
                case 40: {
                    Log.e(NetworkScanRequestTracker.TAG, "rilErrorToScanError: MODEM_ERR");
                    return 1;
                }
                case 54: {
                    Log.e(NetworkScanRequestTracker.TAG, "rilErrorToScanError: OPERATION_NOT_ALLOWED");
                    return 1;
                }
                case 44: {
                    Log.e(NetworkScanRequestTracker.TAG, "rilErrorToScanError: INVALID_ARGUMENTS");
                    return 2;
                }
                case 64: {
                    Log.e(NetworkScanRequestTracker.TAG, "rilErrorToScanError: DEVICE_IN_USE");
                    return 3;
                }
            }
            Log.e(NetworkScanRequestTracker.TAG, "rilErrorToScanError: Unexpected RadioError " + rilError);
            return 10000;
        }

        private int commandExceptionErrorToScanError(CommandException.Error error) {
            switch (error) {
                case RADIO_NOT_AVAILABLE: {
                    Log.e(NetworkScanRequestTracker.TAG, "commandExceptionErrorToScanError: RADIO_NOT_AVAILABLE");
                    return 1;
                }
                case REQUEST_NOT_SUPPORTED: {
                    Log.e(NetworkScanRequestTracker.TAG, "commandExceptionErrorToScanError: REQUEST_NOT_SUPPORTED");
                    return 4;
                }
                case NO_MEMORY: {
                    Log.e(NetworkScanRequestTracker.TAG, "commandExceptionErrorToScanError: NO_MEMORY");
                    return 1;
                }
                case INTERNAL_ERR: {
                    Log.e(NetworkScanRequestTracker.TAG, "commandExceptionErrorToScanError: INTERNAL_ERR");
                    return 1;
                }
                case MODEM_ERR: {
                    Log.e(NetworkScanRequestTracker.TAG, "commandExceptionErrorToScanError: MODEM_ERR");
                    return 1;
                }
                case OPERATION_NOT_ALLOWED: {
                    Log.e(NetworkScanRequestTracker.TAG, "commandExceptionErrorToScanError: OPERATION_NOT_ALLOWED");
                    return 1;
                }
                case INVALID_ARGUMENTS: {
                    Log.e(NetworkScanRequestTracker.TAG, "commandExceptionErrorToScanError: INVALID_ARGUMENTS");
                    return 2;
                }
                case DEVICE_IN_USE: {
                    Log.e(NetworkScanRequestTracker.TAG, "commandExceptionErrorToScanError: DEVICE_IN_USE");
                    return 3;
                }
            }
            Log.e(NetworkScanRequestTracker.TAG, "commandExceptionErrorToScanError: Unexpected CommandExceptionError " + (Object)((Object)error));
            return 10000;
        }

        private void doStartScan(NetworkScanRequestInfo nsri) {
            if (nsri == null) {
                Log.e(NetworkScanRequestTracker.TAG, "CMD_START_NETWORK_SCAN: nsri is null");
                return;
            }
            if (!NetworkScanRequestTracker.this.isValidScan(nsri)) {
                NetworkScanRequestTracker.this.notifyMessenger(nsri, 2, 2, null);
                return;
            }
            if (nsri.getIsBinderDead()) {
                Log.e(NetworkScanRequestTracker.TAG, "CMD_START_NETWORK_SCAN: Binder has died");
                return;
            }
            if (!(this.startNewScan(nsri) || this.interruptLiveScan(nsri) || this.cacheScan(nsri))) {
                NetworkScanRequestTracker.this.notifyMessenger(nsri, 2, 3, null);
            }
        }

        private synchronized void startScanDone(AsyncResult ar) {
            NetworkScanRequestInfo nsri = (NetworkScanRequestInfo)ar.userObj;
            if (nsri == null) {
                Log.e(NetworkScanRequestTracker.TAG, "EVENT_START_NETWORK_SCAN_DONE: nsri is null");
                return;
            }
            if (this.mLiveRequestInfo == null || nsri.mScanId != this.mLiveRequestInfo.mScanId) {
                Log.e(NetworkScanRequestTracker.TAG, "EVENT_START_NETWORK_SCAN_DONE: nsri does not match mLiveRequestInfo");
                return;
            }
            if (ar.exception == null && ar.result != null) {
                ((NetworkScanRequestInfo)nsri).mPhone.mCi.registerForNetworkScanResult(NetworkScanRequestTracker.this.mHandler, 3, nsri);
            } else {
                NetworkScanRequestTracker.this.logEmptyResultOrException(ar);
                if (ar.exception != null) {
                    CommandException.Error error = ((CommandException)ar.exception).getCommandError();
                    this.deleteScanAndMayNotify(nsri, this.commandExceptionErrorToScanError(error), true);
                } else {
                    Log.wtf(NetworkScanRequestTracker.TAG, "EVENT_START_NETWORK_SCAN_DONE: ar.exception can not be null!");
                }
            }
        }

        private void receiveResult(AsyncResult ar) {
            NetworkScanRequestInfo nsri = (NetworkScanRequestInfo)ar.userObj;
            if (nsri == null) {
                Log.e(NetworkScanRequestTracker.TAG, "EVENT_RECEIVE_NETWORK_SCAN_RESULT: nsri is null");
                return;
            }
            LocationAccessPolicy.LocationPermissionQuery locationQuery = new LocationAccessPolicy.LocationPermissionQuery.Builder().setCallingPackage(nsri.mCallingPackage).setCallingPid(nsri.mPid).setCallingUid(nsri.mUid).setMinSdkVersionForFine(29).setMethod("NetworkScanTracker#onResult").build();
            if (ar.exception == null && ar.result != null) {
                int notifyMsg;
                NetworkScanResult nsr = (NetworkScanResult)ar.result;
                boolean isLocationAccessAllowed = LocationAccessPolicy.checkLocationPermission(nsri.mPhone.getContext(), locationQuery) == LocationAccessPolicy.LocationPermissionResult.ALLOWED;
                int n = notifyMsg = isLocationAccessAllowed ? 1 : 4;
                if (nsr.scanError == 0) {
                    if (nsri.mPhone.getServiceStateTracker() != null) {
                        nsri.mPhone.getServiceStateTracker().updateOperatorNameForCellInfo(nsr.networkInfos);
                    }
                    NetworkScanRequestTracker.this.notifyMessenger(nsri, notifyMsg, this.rilErrorToScanError(nsr.scanError), nsr.networkInfos);
                    if (nsr.scanStatus == 2) {
                        this.deleteScanAndMayNotify(nsri, 0, true);
                        ((NetworkScanRequestInfo)nsri).mPhone.mCi.unregisterForNetworkScanResult(NetworkScanRequestTracker.this.mHandler);
                    }
                } else {
                    if (nsr.networkInfos != null) {
                        NetworkScanRequestTracker.this.notifyMessenger(nsri, notifyMsg, this.rilErrorToScanError(nsr.scanError), nsr.networkInfos);
                    }
                    this.deleteScanAndMayNotify(nsri, this.rilErrorToScanError(nsr.scanError), true);
                    ((NetworkScanRequestInfo)nsri).mPhone.mCi.unregisterForNetworkScanResult(NetworkScanRequestTracker.this.mHandler);
                }
            } else {
                NetworkScanRequestTracker.this.logEmptyResultOrException(ar);
                this.deleteScanAndMayNotify(nsri, 10000, true);
                ((NetworkScanRequestInfo)nsri).mPhone.mCi.unregisterForNetworkScanResult(NetworkScanRequestTracker.this.mHandler);
            }
        }

        private synchronized void doStopScan(int scanId) {
            if (this.mLiveRequestInfo != null && scanId == this.mLiveRequestInfo.mScanId) {
                this.mLiveRequestInfo.mPhone.stopNetworkScan(NetworkScanRequestTracker.this.mHandler.obtainMessage(5, this.mLiveRequestInfo));
            } else if (this.mPendingRequestInfo != null && scanId == this.mPendingRequestInfo.mScanId) {
                NetworkScanRequestTracker.this.notifyMessenger(this.mPendingRequestInfo, 3, 0, null);
                this.mPendingRequestInfo = null;
            } else {
                Log.e(NetworkScanRequestTracker.TAG, "stopScan: scan " + scanId + " does not exist!");
            }
        }

        private void stopScanDone(AsyncResult ar) {
            NetworkScanRequestInfo nsri = (NetworkScanRequestInfo)ar.userObj;
            if (nsri == null) {
                Log.e(NetworkScanRequestTracker.TAG, "EVENT_STOP_NETWORK_SCAN_DONE: nsri is null");
                return;
            }
            if (ar.exception == null && ar.result != null) {
                this.deleteScanAndMayNotify(nsri, 0, true);
            } else {
                NetworkScanRequestTracker.this.logEmptyResultOrException(ar);
                if (ar.exception != null) {
                    CommandException.Error error = ((CommandException)ar.exception).getCommandError();
                    this.deleteScanAndMayNotify(nsri, this.commandExceptionErrorToScanError(error), true);
                } else {
                    Log.wtf(NetworkScanRequestTracker.TAG, "EVENT_STOP_NETWORK_SCAN_DONE: ar.exception can not be null!");
                }
            }
            ((NetworkScanRequestInfo)nsri).mPhone.mCi.unregisterForNetworkScanResult(NetworkScanRequestTracker.this.mHandler);
        }

        private synchronized void doInterruptScan(int scanId) {
            if (this.mLiveRequestInfo != null && scanId == this.mLiveRequestInfo.mScanId) {
                this.mLiveRequestInfo.mPhone.stopNetworkScan(NetworkScanRequestTracker.this.mHandler.obtainMessage(7, this.mLiveRequestInfo));
            } else {
                Log.e(NetworkScanRequestTracker.TAG, "doInterruptScan: scan " + scanId + " does not exist!");
            }
        }

        private void interruptScanDone(AsyncResult ar) {
            NetworkScanRequestInfo nsri = (NetworkScanRequestInfo)ar.userObj;
            if (nsri == null) {
                Log.e(NetworkScanRequestTracker.TAG, "EVENT_INTERRUPT_NETWORK_SCAN_DONE: nsri is null");
                return;
            }
            ((NetworkScanRequestInfo)nsri).mPhone.mCi.unregisterForNetworkScanResult(NetworkScanRequestTracker.this.mHandler);
            this.deleteScanAndMayNotify(nsri, 0, false);
        }

        private synchronized boolean interruptLiveScan(NetworkScanRequestInfo nsri) {
            if (this.mLiveRequestInfo != null && this.mPendingRequestInfo == null && nsri.mUid == 1001 && this.mLiveRequestInfo.mUid != 1001) {
                this.doInterruptScan(this.mLiveRequestInfo.mScanId);
                this.mPendingRequestInfo = nsri;
                NetworkScanRequestTracker.this.notifyMessenger(this.mLiveRequestInfo, 2, 10002, null);
                return true;
            }
            return false;
        }

        private boolean cacheScan(NetworkScanRequestInfo nsri) {
            return false;
        }

        private synchronized boolean startNewScan(NetworkScanRequestInfo nsri) {
            if (this.mLiveRequestInfo == null) {
                this.mLiveRequestInfo = nsri;
                nsri.mPhone.startNetworkScan(nsri.getRequest(), NetworkScanRequestTracker.this.mHandler.obtainMessage(2, nsri));
                return true;
            }
            return false;
        }

        private synchronized void deleteScanAndMayNotify(NetworkScanRequestInfo nsri, int error, boolean notify) {
            if (this.mLiveRequestInfo != null && nsri.mScanId == this.mLiveRequestInfo.mScanId) {
                if (notify) {
                    if (error == 0) {
                        NetworkScanRequestTracker.this.notifyMessenger(nsri, 3, error, null);
                    } else {
                        NetworkScanRequestTracker.this.notifyMessenger(nsri, 2, error, null);
                    }
                }
                this.mLiveRequestInfo = null;
                if (this.mPendingRequestInfo != null) {
                    this.startNewScan(this.mPendingRequestInfo);
                    this.mPendingRequestInfo = null;
                }
            }
        }
    }

    class NetworkScanRequestInfo
    implements IBinder.DeathRecipient {
        private final NetworkScanRequest mRequest;
        private final Messenger mMessenger;
        private final IBinder mBinder;
        private final Phone mPhone;
        private final int mScanId;
        private final int mUid;
        private final int mPid;
        private final String mCallingPackage;
        private boolean mIsBinderDead;

        NetworkScanRequestInfo(NetworkScanRequest r, Messenger m, IBinder b, int id2, Phone phone, int callingUid, int callingPid, String callingPackage) {
            this.mRequest = r;
            this.mMessenger = m;
            this.mBinder = b;
            this.mScanId = id2;
            this.mPhone = phone;
            this.mUid = callingUid;
            this.mPid = callingPid;
            this.mCallingPackage = callingPackage;
            this.mIsBinderDead = false;
            try {
                this.mBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        synchronized void setIsBinderDead(boolean val) {
            this.mIsBinderDead = val;
        }

        synchronized boolean getIsBinderDead() {
            return this.mIsBinderDead;
        }

        NetworkScanRequest getRequest() {
            return this.mRequest;
        }

        void unlinkDeathRecipient() {
            if (this.mBinder != null) {
                this.mBinder.unlinkToDeath(this, 0);
            }
        }

        @Override
        public void binderDied() {
            Log.e(NetworkScanRequestTracker.TAG, "PhoneInterfaceManager NetworkScanRequestInfo binderDied(" + this.mRequest + ", " + this.mBinder + ")");
            this.setIsBinderDead(true);
            NetworkScanRequestTracker.this.interruptNetworkScan(this.mScanId);
        }
    }
}

