/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class NetworkScanResult
implements Parcelable {
    public static final int SCAN_STATUS_PARTIAL = 1;
    public static final int SCAN_STATUS_COMPLETE = 2;
    public int scanStatus;
    public int scanError;
    public List<CellInfo> networkInfos;
    public static final Parcelable.Creator<NetworkScanResult> CREATOR = new Parcelable.Creator<NetworkScanResult>(){

        @Override
        public NetworkScanResult createFromParcel(Parcel in) {
            return new NetworkScanResult(in);
        }

        public NetworkScanResult[] newArray(int size) {
            return new NetworkScanResult[size];
        }
    };

    public NetworkScanResult(int scanStatus, int scanError, List<CellInfo> networkInfos) {
        this.scanStatus = scanStatus;
        this.scanError = scanError;
        this.networkInfos = networkInfos;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.scanStatus);
        dest.writeInt(this.scanError);
        dest.writeParcelableList(this.networkInfos, flags);
    }

    private NetworkScanResult(Parcel in) {
        this.scanStatus = in.readInt();
        this.scanError = in.readInt();
        ArrayList<CellInfo> ni = new ArrayList<CellInfo>();
        in.readParcelableList(ni, Object.class.getClassLoader());
        this.networkInfos = ni;
    }

    public boolean equals(Object o) {
        NetworkScanResult nsr;
        try {
            nsr = (NetworkScanResult)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return this.scanStatus == nsr.scanStatus && this.scanError == nsr.scanError && this.networkInfos.equals(nsr.networkInfos);
    }

    public String toString() {
        return "{" + ("scanStatus=" + this.scanStatus) + (", scanError=" + this.scanError) + (", networkInfos=" + this.networkInfos) + "}";
    }

    public int hashCode() {
        return this.scanStatus * 31 + this.scanError * 23 + Objects.hashCode(this.networkInfos) * 37;
    }
}

