/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.os.PowerManager;
import android.telephony.Rlog;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.TimestampedValue;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.NewTimeServiceHelper;
import com.android.internal.telephony.NitzData;
import com.android.internal.telephony.NitzStateMachine;
import com.android.internal.telephony.TimeZoneLookupHelper;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public final class NewNitzStateMachine
implements NitzStateMachine {
    private static final String LOG_TAG = "SST";
    private static final boolean DBG = true;
    private TimestampedValue<Long> mSavedNitzTime;
    private TimestampedValue<NitzData> mLatestNitzSignal;
    private boolean mGotCountryCode = false;
    private String mSavedTimeZoneId;
    private boolean mNitzTimeZoneDetectionSuccessful = false;
    private final LocalLog mTimeLog = new LocalLog(15);
    private final LocalLog mTimeZoneLog = new LocalLog(15);
    private final GsmCdmaPhone mPhone;
    private final NitzStateMachine.DeviceState mDeviceState;
    private final NewTimeServiceHelper mTimeServiceHelper;
    private final TimeZoneLookupHelper mTimeZoneLookupHelper;
    private final PowerManager.WakeLock mWakeLock;
    private static final String WAKELOCK_TAG = "NitzStateMachine";

    public NewNitzStateMachine(GsmCdmaPhone phone) {
        this(phone, new NewTimeServiceHelper(phone.getContext()), new NitzStateMachine.DeviceState(phone), new TimeZoneLookupHelper());
    }

    @VisibleForTesting
    public NewNitzStateMachine(GsmCdmaPhone phone, NewTimeServiceHelper timeServiceHelper, NitzStateMachine.DeviceState deviceState, TimeZoneLookupHelper timeZoneLookupHelper) {
        this.mPhone = phone;
        Context context = phone.getContext();
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, WAKELOCK_TAG);
        this.mDeviceState = deviceState;
        this.mTimeZoneLookupHelper = timeZoneLookupHelper;
        this.mTimeServiceHelper = timeServiceHelper;
        this.mTimeServiceHelper.setListener(new NewTimeServiceHelper.Listener(){

            @Override
            public void onTimeZoneDetectionChange(boolean enabled) {
                if (enabled) {
                    NewNitzStateMachine.this.handleAutoTimeZoneEnabled();
                }
            }
        });
    }

    @Override
    public void handleNetworkCountryCodeSet(boolean countryChanged) {
        boolean hadCountryCode = this.mGotCountryCode;
        this.mGotCountryCode = true;
        String isoCountryCode = this.mDeviceState.getNetworkCountryIsoForPhone();
        if (!TextUtils.isEmpty(isoCountryCode) && !this.mNitzTimeZoneDetectionSuccessful) {
            this.updateTimeZoneFromNetworkCountryCode(isoCountryCode);
        }
        if (this.mLatestNitzSignal != null && (countryChanged || !hadCountryCode)) {
            this.updateTimeZoneFromCountryAndNitz();
        }
    }

    private void updateTimeZoneFromCountryAndNitz() {
        String isoCountryCode = this.mDeviceState.getNetworkCountryIsoForPhone();
        TimestampedValue<NitzData> nitzSignal = this.mLatestNitzSignal;
        boolean isTimeZoneSettingInitialized = this.mTimeServiceHelper.isTimeZoneSettingInitialized();
        Rlog.d(LOG_TAG, "updateTimeZoneFromCountryAndNitz: isTimeZoneSettingInitialized=" + isTimeZoneSettingInitialized + " nitzSignal=" + nitzSignal + " isoCountryCode=" + isoCountryCode);
        try {
            TimeZoneLookupHelper.OffsetResult lookupResult;
            String zoneId;
            NitzData nitzData = nitzSignal.getValue();
            if (nitzData.getEmulatorHostTimeZone() != null) {
                zoneId = nitzData.getEmulatorHostTimeZone().getID();
            } else if (!this.mGotCountryCode) {
                zoneId = null;
            } else if (TextUtils.isEmpty(isoCountryCode)) {
                lookupResult = this.mTimeZoneLookupHelper.lookupByNitz(nitzData);
                String logMsg = "updateTimeZoneFromCountryAndNitz: lookupByNitz returned lookupResult=" + lookupResult;
                Rlog.d(LOG_TAG, logMsg);
                this.mTimeZoneLog.log(logMsg);
                zoneId = lookupResult != null ? lookupResult.zoneId : null;
            } else if (this.mLatestNitzSignal == null) {
                Rlog.d(LOG_TAG, "updateTimeZoneFromCountryAndNitz: No cached NITZ data available, not setting zone");
                zoneId = null;
            } else if (this.isNitzSignalOffsetInfoBogus(nitzSignal, isoCountryCode)) {
                String logMsg = "updateTimeZoneFromCountryAndNitz: Received NITZ looks bogus,  isoCountryCode=" + isoCountryCode + " nitzSignal=" + nitzSignal;
                Rlog.d(LOG_TAG, logMsg);
                this.mTimeZoneLog.log(logMsg);
                zoneId = null;
            } else {
                lookupResult = this.mTimeZoneLookupHelper.lookupByNitzCountry(nitzData, isoCountryCode);
                Rlog.d(LOG_TAG, "updateTimeZoneFromCountryAndNitz: using lookupByNitzCountry(nitzData, isoCountryCode), nitzData=" + nitzData + " isoCountryCode=" + isoCountryCode + " lookupResult=" + lookupResult);
                zoneId = lookupResult != null ? lookupResult.zoneId : null;
            }
            String tmpLog = "updateTimeZoneFromCountryAndNitz: isTimeZoneSettingInitialized=" + isTimeZoneSettingInitialized + " isoCountryCode=" + isoCountryCode + " nitzSignal=" + nitzSignal + " zoneId=" + zoneId + " isTimeZoneDetectionEnabled()=" + this.mTimeServiceHelper.isTimeZoneDetectionEnabled();
            this.mTimeZoneLog.log(tmpLog);
            if (zoneId != null) {
                Rlog.d(LOG_TAG, "updateTimeZoneFromCountryAndNitz: zoneId=" + zoneId);
                if (this.mTimeServiceHelper.isTimeZoneDetectionEnabled()) {
                    this.setAndBroadcastNetworkSetTimeZone(zoneId);
                } else {
                    Rlog.d(LOG_TAG, "updateTimeZoneFromCountryAndNitz: skip changing zone as isTimeZoneDetectionEnabled() is false");
                }
                this.mSavedTimeZoneId = zoneId;
                this.mNitzTimeZoneDetectionSuccessful = true;
            } else {
                Rlog.d(LOG_TAG, "updateTimeZoneFromCountryAndNitz: zoneId == null, do nothing");
            }
        }
        catch (RuntimeException ex) {
            Rlog.e(LOG_TAG, "updateTimeZoneFromCountryAndNitz: Processing NITZ data nitzSignal=" + nitzSignal + " isoCountryCode=" + isoCountryCode + " isTimeZoneSettingInitialized=" + isTimeZoneSettingInitialized + " ex=" + ex);
        }
    }

    private boolean isNitzSignalOffsetInfoBogus(TimestampedValue<NitzData> nitzSignal, String isoCountryCode) {
        if (TextUtils.isEmpty(isoCountryCode)) {
            return false;
        }
        NitzData newNitzData = nitzSignal.getValue();
        boolean zeroOffsetNitz = newNitzData.getLocalOffsetMillis() == 0 && !newNitzData.isDst();
        return zeroOffsetNitz && !this.countryUsesUtc(isoCountryCode, nitzSignal);
    }

    private boolean countryUsesUtc(String isoCountryCode, TimestampedValue<NitzData> nitzSignal) {
        return this.mTimeZoneLookupHelper.countryUsesUtc(isoCountryCode, nitzSignal.getValue().getCurrentTimeInMillis());
    }

    @Override
    public void handleNetworkAvailable() {
        Rlog.d(LOG_TAG, "handleNetworkAvailable: mNitzTimeZoneDetectionSuccessful=" + this.mNitzTimeZoneDetectionSuccessful + ", Setting mNitzTimeZoneDetectionSuccessful=false");
        this.mNitzTimeZoneDetectionSuccessful = false;
    }

    @Override
    public void handleNetworkCountryCodeUnavailable() {
        Rlog.d(LOG_TAG, "handleNetworkCountryCodeUnavailable");
        this.mGotCountryCode = false;
        this.mNitzTimeZoneDetectionSuccessful = false;
    }

    @Override
    public void handleNitzReceived(TimestampedValue<NitzData> nitzSignal) {
        this.mLatestNitzSignal = nitzSignal;
        this.updateTimeZoneFromCountryAndNitz();
        this.updateTimeFromNitz();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimeFromNitz() {
        TimestampedValue<NitzData> nitzSignal = this.mLatestNitzSignal;
        try {
            boolean ignoreNitz = this.mDeviceState.getIgnoreNitz();
            if (ignoreNitz) {
                Rlog.d(LOG_TAG, "updateTimeFromNitz: Not suggesting system clock because gsm.ignore-nitz is set");
                return;
            }
            try {
                this.mWakeLock.acquire();
                long elapsedRealtime = this.mTimeServiceHelper.elapsedRealtime();
                long millisSinceNitzReceived = elapsedRealtime - nitzSignal.getReferenceTimeMillis();
                if (millisSinceNitzReceived < 0L || millisSinceNitzReceived > Integer.MAX_VALUE) {
                    Rlog.d(LOG_TAG, "updateTimeFromNitz: not setting time, unexpected elapsedRealtime=" + elapsedRealtime + " nitzSignal=" + nitzSignal);
                    return;
                }
            }
            finally {
                this.mWakeLock.release();
            }
            TimestampedValue<Long> newNitzTime = new TimestampedValue<Long>(nitzSignal.getReferenceTimeMillis(), nitzSignal.getValue().getCurrentTimeInMillis());
            if (this.mSavedNitzTime != null) {
                int nitzUpdateSpacing = this.mDeviceState.getNitzUpdateSpacingMillis();
                int nitzUpdateDiff = this.mDeviceState.getNitzUpdateDiffMillis();
                long elapsedRealtimeSinceLastSaved = newNitzTime.getReferenceTimeMillis() - this.mSavedNitzTime.getReferenceTimeMillis();
                long utcTimeDifferenceMillis = newNitzTime.getValue() - this.mSavedNitzTime.getValue();
                long millisGained = utcTimeDifferenceMillis - elapsedRealtimeSinceLastSaved;
                if (elapsedRealtimeSinceLastSaved <= (long)nitzUpdateSpacing && Math.abs(millisGained) <= (long)nitzUpdateDiff) {
                    Rlog.d(LOG_TAG, "updateTimeFromNitz: not setting time. NITZ signal is too similar to previous value received  mSavedNitzTime=" + this.mSavedNitzTime + ", nitzSignal=" + nitzSignal + ", nitzUpdateSpacing=" + nitzUpdateSpacing + ", nitzUpdateDiff=" + nitzUpdateDiff);
                    return;
                }
            }
            String logMsg = "updateTimeFromNitz: suggesting system clock update nitzSignal=" + nitzSignal + ", newNitzTime=" + newNitzTime + ", mSavedNitzTime= " + this.mSavedNitzTime;
            Rlog.d(LOG_TAG, logMsg);
            this.mTimeLog.log(logMsg);
            this.mTimeServiceHelper.suggestDeviceTime(newNitzTime);
            TelephonyMetrics.getInstance().writeNITZEvent(this.mPhone.getPhoneId(), newNitzTime.getValue());
            this.mSavedNitzTime = newNitzTime;
        }
        catch (RuntimeException ex) {
            Rlog.e(LOG_TAG, "updateTimeFromNitz: Processing NITZ data nitzSignal=" + nitzSignal + " ex=" + ex);
        }
    }

    private void setAndBroadcastNetworkSetTimeZone(String zoneId) {
        Rlog.d(LOG_TAG, "setAndBroadcastNetworkSetTimeZone: zoneId=" + zoneId);
        this.mTimeServiceHelper.setDeviceTimeZone(zoneId);
        Rlog.d(LOG_TAG, "setAndBroadcastNetworkSetTimeZone: called setDeviceTimeZone() zoneId=" + zoneId);
    }

    private void handleAutoTimeZoneEnabled() {
        String tmpLog = "handleAutoTimeZoneEnabled: Reverting to NITZ TimeZone: mSavedTimeZoneId=" + this.mSavedTimeZoneId;
        Rlog.d(LOG_TAG, tmpLog);
        this.mTimeZoneLog.log(tmpLog);
        if (this.mSavedTimeZoneId != null) {
            this.setAndBroadcastNetworkSetTimeZone(this.mSavedTimeZoneId);
        }
    }

    @Override
    public void dumpState(PrintWriter pw) {
        pw.println(" mSavedTime=" + this.mSavedNitzTime);
        pw.println(" mLatestNitzSignal=" + this.mLatestNitzSignal);
        pw.println(" mGotCountryCode=" + this.mGotCountryCode);
        pw.println(" mSavedTimeZoneId=" + this.mSavedTimeZoneId);
        pw.println(" mNitzTimeZoneDetectionSuccessful=" + this.mNitzTimeZoneDetectionSuccessful);
        pw.println(" mWakeLock=" + this.mWakeLock);
        pw.flush();
    }

    @Override
    public void dumpLogs(FileDescriptor fd, IndentingPrintWriter ipw, String[] args) {
        ipw.println(" Time Logs:");
        ipw.increaseIndent();
        this.mTimeLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.println(" Time zone Logs:");
        ipw.increaseIndent();
        this.mTimeZoneLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
    }

    private void updateTimeZoneFromNetworkCountryCode(String iso) {
        TimeZoneLookupHelper.CountryResult lookupResult = this.mTimeZoneLookupHelper.lookupByCountry(iso, this.mTimeServiceHelper.currentTimeMillis());
        if (lookupResult != null && lookupResult.allZonesHaveSameOffset) {
            String logMsg = "updateTimeZoneFromNetworkCountryCode: tz result found iso=" + iso + " lookupResult=" + lookupResult;
            Rlog.d(LOG_TAG, logMsg);
            this.mTimeZoneLog.log(logMsg);
            String zoneId = lookupResult.zoneId;
            if (this.mTimeServiceHelper.isTimeZoneDetectionEnabled()) {
                this.setAndBroadcastNetworkSetTimeZone(zoneId);
            }
            this.mSavedTimeZoneId = zoneId;
        } else {
            Rlog.d(LOG_TAG, "updateTimeZoneFromNetworkCountryCode: no good zone for iso=" + iso + " lookupResult=" + lookupResult);
        }
    }

    public boolean getNitzTimeZoneDetectionSuccessful() {
        return this.mNitzTimeZoneDetectionSuccessful;
    }

    @Override
    public NitzData getCachedNitzData() {
        return this.mLatestNitzSignal != null ? this.mLatestNitzSignal.getValue() : null;
    }

    @Override
    public String getSavedTimeZoneId() {
        return this.mSavedTimeZoneId;
    }
}

