/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.Context;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.TimestampedValue;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.NitzData;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public interface NitzStateMachine {
    public void handleNetworkCountryCodeSet(boolean var1);

    public void handleNetworkAvailable();

    public void handleNetworkCountryCodeUnavailable();

    public void handleNitzReceived(TimestampedValue<NitzData> var1);

    public void dumpState(PrintWriter var1);

    public void dumpLogs(FileDescriptor var1, IndentingPrintWriter var2, String[] var3);

    public NitzData getCachedNitzData();

    public String getSavedTimeZoneId();

    public static class DeviceState {
        private static final int NITZ_UPDATE_SPACING_DEFAULT = 600000;
        private final int mNitzUpdateSpacing;
        private static final int NITZ_UPDATE_DIFF_DEFAULT = 2000;
        private final int mNitzUpdateDiff;
        private final GsmCdmaPhone mPhone;
        private final TelephonyManager mTelephonyManager;
        private final ContentResolver mCr;

        public DeviceState(GsmCdmaPhone phone) {
            this.mPhone = phone;
            Context context = phone.getContext();
            this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
            this.mCr = context.getContentResolver();
            this.mNitzUpdateSpacing = SystemProperties.getInt("ro.nitz_update_spacing", 600000);
            this.mNitzUpdateDiff = SystemProperties.getInt("ro.nitz_update_diff", 2000);
        }

        public int getNitzUpdateSpacingMillis() {
            return Settings.Global.getInt(this.mCr, "nitz_update_spacing", this.mNitzUpdateSpacing);
        }

        public int getNitzUpdateDiffMillis() {
            return Settings.Global.getInt(this.mCr, "nitz_update_diff", this.mNitzUpdateDiff);
        }

        public boolean getIgnoreNitz() {
            String ignoreNitz = SystemProperties.get("gsm.ignore-nitz");
            return ignoreNitz != null && ignoreNitz.equals("yes");
        }

        public String getNetworkCountryIsoForPhone() {
            return this.mTelephonyManager.getNetworkCountryIsoForPhone(this.mPhone.getPhoneId());
        }
    }
}

