/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Base64;
import android.util.Log;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;

public class PackageBasedTokenUtil {
    private static final String TAG = "PackageBasedTokenUtil";
    private static final Charset CHARSET_UTF_8 = Charset.forName("UTF-8");
    private static final String HASH_TYPE = "SHA-256";
    private static final int NUM_HASHED_BYTES = 9;
    static final int NUM_BASE64_CHARS = 11;

    public static String generateToken(Context context, String packageName) {
        PackageManager packageManager = context.getPackageManager();
        String token = PackageBasedTokenUtil.generatePackageBasedToken(packageManager, packageName);
        List<PackageInfo> packages = packageManager.getInstalledPackages(128);
        for (PackageInfo packageInfo : packages) {
            String otherToken;
            String otherPackageName = packageInfo.packageName;
            if (packageName.equals(otherPackageName) || !token.equals(otherToken = PackageBasedTokenUtil.generatePackageBasedToken(packageManager, otherPackageName))) continue;
            Log.e(TAG, "token collides with other installed app.");
            token = null;
        }
        return token;
    }

    private static String generatePackageBasedToken(PackageManager packageManager, String packageName) {
        Signature[] signatures;
        String token = null;
        try {
            signatures = packageManager.getPackageInfo((String)packageName, (int)64).signatures;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Failed to find package with package name: " + packageName);
            return token;
        }
        if (signatures == null) {
            Log.e(TAG, "The certificates is missing.");
        } else {
            MessageDigest messageDigest;
            try {
                messageDigest = MessageDigest.getInstance(HASH_TYPE);
            }
            catch (NoSuchAlgorithmException e) {
                Log.e(TAG, "NoSuchAlgorithmException" + e);
                return null;
            }
            messageDigest.update(packageName.getBytes(CHARSET_UTF_8));
            String space = " ";
            messageDigest.update(space.getBytes(CHARSET_UTF_8));
            for (int i = 0; i < signatures.length; ++i) {
                messageDigest.update(signatures[i].toCharsString().getBytes(CHARSET_UTF_8));
            }
            byte[] hashSignatures = messageDigest.digest();
            hashSignatures = Arrays.copyOf(hashSignatures, 9);
            token = Base64.encodeToString(hashSignatures, 3);
            token = token.substring(0, 11);
        }
        return token;
    }
}

