/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.app.BroadcastOptions;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.NetworkStats;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.CarrierRestrictionRules;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.ClientRequestStats;
import android.telephony.ImsiEncryptionInfo;
import android.telephony.PhysicalChannelConfig;
import android.telephony.RadioAccessFamily;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.data.ApnSetting;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.SparseArray;
import com.android.ims.ImsCall;
import com.android.ims.ImsManager;
import com.android.internal.telephony.AppSmsManager;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallManager;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CarrierActionAgent;
import com.android.internal.telephony.CarrierResolver;
import com.android.internal.telephony.CarrierSignalAgent;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DeviceStateMonitor;
import com.android.internal.telephony.HalVersion;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.SimActivationTracker;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.TelephonyTester;
import com.android.internal.telephony.dataconnection.DataConnectionReasons;
import com.android.internal.telephony.dataconnection.DataEnabledSettings;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.telephony.dataconnection.TransportManager;
import com.android.internal.telephony.emergency.EmergencyNumberTracker;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.test.SimulatedRadioControl;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.UsimServiceTable;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Phone
extends Handler
implements PhoneInternalInterface {
    private static final String LOG_TAG = "Phone";
    protected static final Object lockForRadioTechnologyChange = new Object();
    protected final int USSD_MAX_QUEUE = 10;
    private BroadcastReceiver mImsIntentReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Rlog.d(Phone.LOG_TAG, "mImsIntentReceiver: action " + intent.getAction());
            if (intent.hasExtra("android:phone_id")) {
                int extraPhoneId = intent.getIntExtra("android:phone_id", -1);
                Rlog.d(Phone.LOG_TAG, "mImsIntentReceiver: extraPhoneId = " + extraPhoneId);
                if (extraPhoneId == -1 || extraPhoneId != Phone.this.getPhoneId()) {
                    return;
                }
            }
            Object object = lockForRadioTechnologyChange;
            synchronized (object) {
                if (intent.getAction().equals("com.android.ims.IMS_SERVICE_UP")) {
                    Phone.this.mImsServiceReady = true;
                    Phone.this.updateImsPhone();
                    ImsManager.getInstance(Phone.this.mContext, Phone.this.mPhoneId).updateImsServiceConfig(false);
                } else if (intent.getAction().equals("com.android.ims.IMS_SERVICE_DOWN")) {
                    Phone.this.mImsServiceReady = false;
                    Phone.this.updateImsPhone();
                }
            }
        }
    };
    public static final String NETWORK_SELECTION_KEY = "network_selection_key";
    public static final String NETWORK_SELECTION_NAME_KEY = "network_selection_name_key";
    public static final String NETWORK_SELECTION_SHORT_KEY = "network_selection_short_key";
    public static final String DATA_DISABLED_ON_BOOT_KEY = "disabled_on_boot_key";
    public static final String DATA_ROAMING_IS_USER_SETTING_KEY = "data_roaming_is_user_setting_key";
    private static final int EMERGENCY_SMS_NO_TIME_RECORDED = -1;
    private static final int EMERGENCY_SMS_TIMER_MAX_MS = 300000;
    protected static final int EVENT_RADIO_AVAILABLE = 1;
    protected static final int EVENT_SSN = 2;
    protected static final int EVENT_SIM_RECORDS_LOADED = 3;
    private static final int EVENT_MMI_DONE = 4;
    protected static final int EVENT_RADIO_ON = 5;
    protected static final int EVENT_GET_BASEBAND_VERSION_DONE = 6;
    protected static final int EVENT_USSD = 7;
    protected static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 8;
    protected static final int EVENT_GET_IMEI_DONE = 9;
    protected static final int EVENT_GET_IMEISV_DONE = 10;
    private static final int EVENT_GET_SIM_STATUS_DONE = 11;
    protected static final int EVENT_SET_CALL_FORWARD_DONE = 12;
    protected static final int EVENT_GET_CALL_FORWARD_DONE = 13;
    protected static final int EVENT_CALL_RING = 14;
    private static final int EVENT_CALL_RING_CONTINUE = 15;
    private static final int EVENT_SET_NETWORK_MANUAL_COMPLETE = 16;
    private static final int EVENT_SET_NETWORK_AUTOMATIC_COMPLETE = 17;
    protected static final int EVENT_SET_CLIR_COMPLETE = 18;
    protected static final int EVENT_REGISTERED_TO_NETWORK = 19;
    protected static final int EVENT_SET_VM_NUMBER_DONE = 20;
    protected static final int EVENT_GET_DEVICE_IDENTITY_DONE = 21;
    protected static final int EVENT_RUIM_RECORDS_LOADED = 22;
    protected static final int EVENT_NV_READY = 23;
    private static final int EVENT_SET_ENHANCED_VP = 24;
    protected static final int EVENT_EMERGENCY_CALLBACK_MODE_ENTER = 25;
    protected static final int EVENT_EXIT_EMERGENCY_CALLBACK_RESPONSE = 26;
    protected static final int EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED = 27;
    protected static final int EVENT_SET_NETWORK_AUTOMATIC = 28;
    protected static final int EVENT_ICC_RECORD_EVENTS = 29;
    private static final int EVENT_ICC_CHANGED = 30;
    private static final int EVENT_SRVCC_STATE_CHANGED = 31;
    private static final int EVENT_INITIATE_SILENT_REDIAL = 32;
    private static final int EVENT_RADIO_NOT_AVAILABLE = 33;
    private static final int EVENT_UNSOL_OEM_HOOK_RAW = 34;
    protected static final int EVENT_GET_RADIO_CAPABILITY = 35;
    protected static final int EVENT_SS = 36;
    private static final int EVENT_CONFIG_LCE = 37;
    private static final int EVENT_CHECK_FOR_NETWORK_AUTOMATIC = 38;
    protected static final int EVENT_VOICE_RADIO_TECH_CHANGED = 39;
    protected static final int EVENT_REQUEST_VOICE_RADIO_TECH_DONE = 40;
    protected static final int EVENT_RIL_CONNECTED = 41;
    protected static final int EVENT_UPDATE_PHONE_OBJECT = 42;
    protected static final int EVENT_CARRIER_CONFIG_CHANGED = 43;
    protected static final int EVENT_SET_ROAMING_PREFERENCE_DONE = 44;
    protected static final int EVENT_MODEM_RESET = 45;
    protected static final int EVENT_VRS_OR_RAT_CHANGED = 46;
    protected static final int EVENT_RADIO_STATE_CHANGED = 47;
    protected static final int EVENT_SET_CARRIER_DATA_ENABLED = 48;
    protected static final int EVENT_DEVICE_PROVISIONED_CHANGE = 49;
    protected static final int EVENT_DEVICE_PROVISIONING_DATA_SETTING_CHANGE = 50;
    protected static final int EVENT_GET_AVAILABLE_NETWORKS_DONE = 51;
    private static final int EVENT_ALL_DATA_DISCONNECTED = 52;
    protected static final int EVENT_LAST = 52;
    private static final String GSM_ROAMING_LIST_OVERRIDE_PREFIX = "gsm_roaming_list_";
    private static final String GSM_NON_ROAMING_LIST_OVERRIDE_PREFIX = "gsm_non_roaming_list_";
    private static final String CDMA_ROAMING_LIST_OVERRIDE_PREFIX = "cdma_roaming_list_";
    private static final String CDMA_NON_ROAMING_LIST_OVERRIDE_PREFIX = "cdma_non_roaming_list_";
    public static final String CLIR_KEY = "clir_key";
    private static final String VM_COUNT = "vm_count_key";
    private static final String VM_ID = "vm_id_key";
    public static final String CF_STATUS = "cf_status_key";
    public static final String CF_ID = "cf_id_key";
    private static final String DNS_SERVER_CHECK_DISABLED_KEY = "dns_server_check_disabled_key";
    private static final int ALREADY_IN_AUTO_SELECTION = 1;
    @UnsupportedAppUsage
    public CommandsInterface mCi;
    protected int mVmCount = 0;
    private boolean mDnsCheckDisabled;
    protected final SparseArray<DcTracker> mDcTrackers = new SparseArray();
    protected CarrierSignalAgent mCarrierSignalAgent;
    protected CarrierActionAgent mCarrierActionAgent;
    private boolean mDoesRilSendMultipleCallRing;
    private int mCallRingContinueToken;
    private int mCallRingDelay;
    private boolean mIsVoiceCapable = true;
    private final AppSmsManager mAppSmsManager;
    private SimActivationTracker mSimActivationTracker;
    protected boolean mIsPhoneInEcmState = false;
    private volatile long mTimeLastEmergencySmsSentMs = -1L;
    protected boolean mIsVideoCapable = false;
    @UnsupportedAppUsage
    protected UiccController mUiccController = null;
    @UnsupportedAppUsage
    protected final AtomicReference<IccRecords> mIccRecords = new AtomicReference();
    @UnsupportedAppUsage
    public SmsStorageMonitor mSmsStorageMonitor;
    public SmsUsageMonitor mSmsUsageMonitor;
    @UnsupportedAppUsage
    protected AtomicReference<UiccCardApplication> mUiccApplication = new AtomicReference();
    TelephonyTester mTelephonyTester;
    private String mName;
    private final String mActionDetached;
    private final String mActionAttached;
    protected DeviceStateMonitor mDeviceStateMonitor;
    protected TransportManager mTransportManager;
    protected DataEnabledSettings mDataEnabledSettings;
    protected CarrierResolver mCarrierResolver;
    @UnsupportedAppUsage
    protected int mPhoneId;
    private boolean mImsServiceReady = false;
    @UnsupportedAppUsage
    protected Phone mImsPhone = null;
    private final AtomicReference<RadioCapability> mRadioCapability = new AtomicReference();
    private static final int DEFAULT_REPORT_INTERVAL_MS = 200;
    private static final boolean LCE_PULL_MODE = true;
    private int mLceStatus = -1;
    protected TelephonyComponentFactory mTelephonyComponentFactory;
    public static final String CS_FALLBACK = "cs_fallback";
    public static final String EXTRA_KEY_ALERT_TITLE = "alertTitle";
    public static final String EXTRA_KEY_ALERT_MESSAGE = "alertMessage";
    public static final String EXTRA_KEY_ALERT_SHOW = "alertShow";
    public static final String EXTRA_KEY_NOTIFICATION_MESSAGE = "notificationMessage";
    private final RegistrantList mPreciseCallStateRegistrants = new RegistrantList();
    private final RegistrantList mHandoverRegistrants = new RegistrantList();
    private final RegistrantList mNewRingingConnectionRegistrants = new RegistrantList();
    private final RegistrantList mIncomingRingRegistrants = new RegistrantList();
    protected final RegistrantList mDisconnectRegistrants = new RegistrantList();
    private final RegistrantList mServiceStateRegistrants = new RegistrantList();
    protected final RegistrantList mMmiCompleteRegistrants = new RegistrantList();
    @UnsupportedAppUsage
    protected final RegistrantList mMmiRegistrants = new RegistrantList();
    protected final RegistrantList mUnknownConnectionRegistrants = new RegistrantList();
    protected final RegistrantList mSuppServiceFailedRegistrants = new RegistrantList();
    protected final RegistrantList mRadioOffOrNotAvailableRegistrants = new RegistrantList();
    protected final RegistrantList mSimRecordsLoadedRegistrants = new RegistrantList();
    private final RegistrantList mVideoCapabilityChangedRegistrants = new RegistrantList();
    protected final RegistrantList mEmergencyCallToggledRegistrants = new RegistrantList();
    private final RegistrantList mAllDataDisconnectedRegistrants = new RegistrantList();
    private final RegistrantList mCellInfoRegistrants = new RegistrantList();
    protected Registrant mPostDialHandler;
    protected final LocalLog mLocalLog;
    private Looper mLooper;
    @UnsupportedAppUsage
    protected final Context mContext;
    @UnsupportedAppUsage
    protected PhoneNotifier mNotifier;
    protected SimulatedRadioControl mSimulatedRadioControl;
    private boolean mUnitTestMode;

    protected void handleExitEmergencyCallbackMode() {
    }

    public IccRecords getIccRecords() {
        return this.mIccRecords.get();
    }

    @UnsupportedAppUsage
    public String getPhoneName() {
        return this.mName;
    }

    protected void setPhoneName(String name) {
        this.mName = name;
    }

    @UnsupportedAppUsage
    public String getNai() {
        return null;
    }

    public String getActionDetached() {
        return this.mActionDetached;
    }

    public String getActionAttached() {
        return this.mActionAttached;
    }

    public void setSystemProperty(String property, String value) {
        if (this.getUnitTestMode()) {
            return;
        }
        TelephonyManager.setTelephonyProperty(this.mPhoneId, property, value);
    }

    public void setGlobalSystemProperty(String property, String value) {
        if (this.getUnitTestMode()) {
            return;
        }
        TelephonyManager.setTelephonyProperty(property, value);
    }

    @UnsupportedAppUsage
    public String getSystemProperty(String property, String defValue) {
        if (this.getUnitTestMode()) {
            return null;
        }
        return SystemProperties.get(property, defValue);
    }

    protected Phone(String name, PhoneNotifier notifier, Context context, CommandsInterface ci, boolean unitTestMode) {
        this(name, notifier, context, ci, unitTestMode, Integer.MAX_VALUE, TelephonyComponentFactory.getInstance());
    }

    protected Phone(String name, PhoneNotifier notifier, Context context, CommandsInterface ci, boolean unitTestMode, int phoneId, TelephonyComponentFactory telephonyComponentFactory) {
        this.mPhoneId = phoneId;
        this.mName = name;
        this.mNotifier = notifier;
        this.mContext = context;
        this.mLooper = Looper.myLooper();
        this.mCi = ci;
        this.mActionDetached = this.getClass().getPackage().getName() + ".action_detached";
        this.mActionAttached = this.getClass().getPackage().getName() + ".action_attached";
        this.mAppSmsManager = telephonyComponentFactory.inject(AppSmsManager.class.getName()).makeAppSmsManager(context);
        this.mLocalLog = new LocalLog(64);
        if (Build.IS_DEBUGGABLE) {
            this.mTelephonyTester = new TelephonyTester(this);
        }
        this.setUnitTestMode(unitTestMode);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        this.mDnsCheckDisabled = sp.getBoolean(DNS_SERVER_CHECK_DISABLED_KEY, false);
        this.mCi.setOnCallRing(this, 14, null);
        this.mIsVoiceCapable = this.mContext.getResources().getBoolean(17891570);
        this.mDoesRilSendMultipleCallRing = SystemProperties.getBoolean("ro.telephony.call_ring.multiple", true);
        Rlog.d(LOG_TAG, "mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing);
        this.mCallRingDelay = SystemProperties.getInt("ro.telephony.call_ring.delay", 3000);
        Rlog.d(LOG_TAG, "mCallRingDelay=" + this.mCallRingDelay);
        if (this.getPhoneType() == 5) {
            return;
        }
        Locale carrierLocale = Phone.getLocaleFromCarrierProperties(this.mContext);
        if (carrierLocale != null && !TextUtils.isEmpty(carrierLocale.getCountry())) {
            String country = carrierLocale.getCountry();
            try {
                Settings.Global.getInt(this.mContext.getContentResolver(), "wifi_country_code");
            }
            catch (Settings.SettingNotFoundException e) {
                WifiManager wM = (WifiManager)this.mContext.getSystemService("wifi");
                wM.setCountryCode(country);
            }
        }
        this.mTelephonyComponentFactory = telephonyComponentFactory;
        this.mSmsStorageMonitor = this.mTelephonyComponentFactory.inject(SmsStorageMonitor.class.getName()).makeSmsStorageMonitor(this);
        this.mSmsUsageMonitor = this.mTelephonyComponentFactory.inject(SmsUsageMonitor.class.getName()).makeSmsUsageMonitor(context);
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 30, null);
        this.mSimActivationTracker = this.mTelephonyComponentFactory.inject(SimActivationTracker.class.getName()).makeSimActivationTracker(this);
        if (this.getPhoneType() != 3) {
            this.mCi.registerForSrvccStateChanged(this, 31, null);
        }
        this.mCi.setOnUnsolOemHookRaw(this, 34, null);
        this.mCi.startLceService(200, true, this.obtainMessage(37));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitoringImsService() {
        if (this.getPhoneType() == 3) {
            return;
        }
        Object object = lockForRadioTechnologyChange;
        synchronized (object) {
            IntentFilter filter = new IntentFilter();
            ImsManager imsManager = ImsManager.getInstance(this.mContext, this.getPhoneId());
            if (imsManager != null && !imsManager.isDynamicBinding()) {
                filter.addAction("com.android.ims.IMS_SERVICE_UP");
                filter.addAction("com.android.ims.IMS_SERVICE_DOWN");
                this.mContext.registerReceiver(this.mImsIntentReceiver, filter);
            }
            if (imsManager != null && (imsManager.isDynamicBinding() || imsManager.isServiceAvailable())) {
                this.mImsServiceReady = true;
                this.updateImsPhone();
            }
        }
    }

    public boolean supportsConversionOfCdmaCallerIdMmiCodesWhileRoaming() {
        CarrierConfigManager configManager = (CarrierConfigManager)this.getContext().getSystemService("carrier_config");
        PersistableBundle b = configManager.getConfigForSubId(this.getSubId());
        if (b != null) {
            return b.getBoolean("convert_cdma_caller_id_mmi_codes_while_roaming_on_3gpp_bool", false);
        }
        return false;
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 16: 
            case 17: {
                this.handleSetSelectNetwork((AsyncResult)msg.obj);
                return;
            }
        }
        switch (msg.what) {
            case 14: {
                Rlog.d(LOG_TAG, "Event EVENT_CALL_RING Received state=" + (Object)((Object)this.getState()));
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                PhoneConstants.State state = this.getState();
                if (!(this.mDoesRilSendMultipleCallRing || state != PhoneConstants.State.RINGING && state != PhoneConstants.State.IDLE)) {
                    ++this.mCallRingContinueToken;
                    this.sendIncomingCallRingNotification(this.mCallRingContinueToken);
                    break;
                }
                this.notifyIncomingRing();
                break;
            }
            case 15: {
                Rlog.d(LOG_TAG, "Event EVENT_CALL_RING_CONTINUE Received state=" + (Object)((Object)this.getState()));
                if (this.getState() != PhoneConstants.State.RINGING) break;
                this.sendIncomingCallRingNotification(msg.arg1);
                break;
            }
            case 30: {
                this.onUpdateIccAvailability();
                break;
            }
            case 32: {
                Rlog.d(LOG_TAG, "Event EVENT_INITIATE_SILENT_REDIAL Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null || ar.result == null) break;
                String dialString = (String)ar.result;
                if (TextUtils.isEmpty(dialString)) {
                    return;
                }
                try {
                    this.dialInternal(dialString, new PhoneInternalInterface.DialArgs.Builder().build());
                }
                catch (CallStateException e) {
                    Rlog.e(LOG_TAG, "silent redial failed: " + e);
                }
                break;
            }
            case 31: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.handleSrvccStateChanged((int[])ar.result);
                    break;
                }
                Rlog.e(LOG_TAG, "Srvcc exception: " + ar.exception);
                break;
            }
            case 34: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    this.mNotifier.notifyOemHookRawEventForSubscriber(this, data);
                    break;
                }
                Rlog.e(LOG_TAG, "OEM hook raw exception: " + ar.exception);
                break;
            }
            case 37: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    Rlog.d(LOG_TAG, "config LCE service failed: " + ar.exception);
                    break;
                }
                ArrayList statusInfo = (ArrayList)ar.result;
                this.mLceStatus = (Integer)statusInfo.get(0);
                break;
            }
            case 38: {
                this.onCheckForNetworkSelectionModeAutomatic(msg);
                break;
            }
            case 52: {
                if (!this.areAllDataDisconnected()) break;
                this.mAllDataDisconnectedRegistrants.notifyRegistrants();
                break;
            }
            default: {
                throw new RuntimeException("unexpected event not handled");
            }
        }
    }

    public ArrayList<Connection> getHandoverConnection() {
        return null;
    }

    public void notifySrvccState(Call.SrvccState state) {
    }

    public void registerForSilentRedial(Handler h, int what, Object obj) {
    }

    public void unregisterForSilentRedial(Handler h) {
    }

    private void handleSrvccStateChanged(int[] ret) {
        Rlog.d(LOG_TAG, "handleSrvccStateChanged");
        ArrayList<Connection> conn = null;
        Phone imsPhone = this.mImsPhone;
        Call.SrvccState srvccState = Call.SrvccState.NONE;
        if (ret != null && ret.length != 0) {
            int state = ret[0];
            switch (state) {
                case 0: {
                    srvccState = Call.SrvccState.STARTED;
                    if (imsPhone != null) {
                        conn = imsPhone.getHandoverConnection();
                        this.migrateFrom(imsPhone);
                        break;
                    }
                    Rlog.d(LOG_TAG, "HANDOVER_STARTED: mImsPhone null");
                    break;
                }
                case 1: {
                    srvccState = Call.SrvccState.COMPLETED;
                    if (imsPhone != null) {
                        imsPhone.notifySrvccState(srvccState);
                        break;
                    }
                    Rlog.d(LOG_TAG, "HANDOVER_COMPLETED: mImsPhone null");
                    break;
                }
                case 2: 
                case 3: {
                    srvccState = Call.SrvccState.FAILED;
                    break;
                }
                default: {
                    return;
                }
            }
            this.getCallTracker().notifySrvccState(srvccState, conn);
            this.notifySrvccStateChanged(state);
        }
    }

    @UnsupportedAppUsage
    public Context getContext() {
        return this.mContext;
    }

    protected abstract void onUpdateIccAvailability();

    public void disableDnsCheck(boolean b) {
        this.mDnsCheckDisabled = b;
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean(DNS_SERVER_CHECK_DISABLED_KEY, b);
        editor.apply();
    }

    public boolean isDnsCheckDisabled() {
        return this.mDnsCheckDisabled;
    }

    @UnsupportedAppUsage
    public void registerForPreciseCallStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mPreciseCallStateRegistrants.addUnique(h, what, obj);
    }

    @UnsupportedAppUsage
    public void unregisterForPreciseCallStateChanged(Handler h) {
        this.mPreciseCallStateRegistrants.remove(h);
    }

    protected void notifyPreciseCallStateChangedP() {
        AsyncResult ar = new AsyncResult(null, this, null);
        this.mPreciseCallStateRegistrants.notifyRegistrants(ar);
        this.mNotifier.notifyPreciseCallState(this);
    }

    public void registerForHandoverStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mHandoverRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForHandoverStateChanged(Handler h) {
        this.mHandoverRegistrants.remove(h);
    }

    public void notifyHandoverStateChanged(Connection cn) {
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mHandoverRegistrants.notifyRegistrants(ar);
    }

    protected void setIsInEmergencyCall() {
    }

    public void notifySmsSent(String destinationAddress) {
        TelephonyManager m = (TelephonyManager)this.getContext().getSystemService("phone");
        if (m != null && m.isEmergencyNumber(destinationAddress)) {
            this.mLocalLog.log("Emergency SMS detected, recording time.");
            this.mTimeLastEmergencySmsSentMs = SystemClock.elapsedRealtime();
        }
    }

    public boolean isInEmergencySmsMode() {
        boolean isInEmergencySmsMode;
        long lastSmsTimeMs = this.mTimeLastEmergencySmsSentMs;
        if (lastSmsTimeMs == -1L) {
            return false;
        }
        CarrierConfigManager configManager = (CarrierConfigManager)this.getContext().getSystemService("carrier_config");
        PersistableBundle b = configManager.getConfigForSubId(this.getSubId());
        if (b == null) {
            return false;
        }
        int eSmsTimerMs = b.getInt("emergency_sms_mode_timer_ms_int", 0);
        if (eSmsTimerMs == 0) {
            return false;
        }
        if (eSmsTimerMs > 300000) {
            eSmsTimerMs = 300000;
        }
        boolean bl = isInEmergencySmsMode = SystemClock.elapsedRealtime() <= lastSmsTimeMs + (long)eSmsTimerMs;
        if (!isInEmergencySmsMode) {
            this.mTimeLastEmergencySmsSentMs = -1L;
        } else {
            this.mLocalLog.log("isInEmergencySmsMode: queried while eSMS mode is active.");
        }
        return isInEmergencySmsMode;
    }

    protected void migrateFrom(Phone from) {
        this.migrate(this.mHandoverRegistrants, from.mHandoverRegistrants);
        this.migrate(this.mPreciseCallStateRegistrants, from.mPreciseCallStateRegistrants);
        this.migrate(this.mNewRingingConnectionRegistrants, from.mNewRingingConnectionRegistrants);
        this.migrate(this.mIncomingRingRegistrants, from.mIncomingRingRegistrants);
        this.migrate(this.mDisconnectRegistrants, from.mDisconnectRegistrants);
        this.migrate(this.mServiceStateRegistrants, from.mServiceStateRegistrants);
        this.migrate(this.mMmiCompleteRegistrants, from.mMmiCompleteRegistrants);
        this.migrate(this.mMmiRegistrants, from.mMmiRegistrants);
        this.migrate(this.mUnknownConnectionRegistrants, from.mUnknownConnectionRegistrants);
        this.migrate(this.mSuppServiceFailedRegistrants, from.mSuppServiceFailedRegistrants);
        this.migrate(this.mCellInfoRegistrants, from.mCellInfoRegistrants);
        if (from.isInEmergencyCall()) {
            this.setIsInEmergencyCall();
        }
    }

    protected void migrate(RegistrantList to, RegistrantList from) {
        from.removeCleared();
        int n = from.size();
        for (int i = 0; i < n; ++i) {
            Registrant r = (Registrant)from.get(i);
            Message msg = r.messageForRegistrant();
            if (msg != null) {
                if (msg.obj == CallManager.getInstance().getRegistrantIdentifier()) continue;
                to.add((Registrant)from.get(i));
                continue;
            }
            Rlog.d(LOG_TAG, "msg is null");
        }
    }

    @UnsupportedAppUsage
    public void registerForUnknownConnection(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mUnknownConnectionRegistrants.addUnique(h, what, obj);
    }

    @UnsupportedAppUsage
    public void unregisterForUnknownConnection(Handler h) {
        this.mUnknownConnectionRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public void registerForNewRingingConnection(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mNewRingingConnectionRegistrants.addUnique(h, what, obj);
    }

    @UnsupportedAppUsage
    public void unregisterForNewRingingConnection(Handler h) {
        this.mNewRingingConnectionRegistrants.remove(h);
    }

    public void registerForVideoCapabilityChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mVideoCapabilityChangedRegistrants.addUnique(h, what, obj);
        this.notifyForVideoCapabilityChanged(this.mIsVideoCapable);
    }

    public void unregisterForVideoCapabilityChanged(Handler h) {
        this.mVideoCapabilityChangedRegistrants.remove(h);
    }

    public void registerForInCallVoicePrivacyOn(Handler h, int what, Object obj) {
        this.mCi.registerForInCallVoicePrivacyOn(h, what, obj);
    }

    public void unregisterForInCallVoicePrivacyOn(Handler h) {
        this.mCi.unregisterForInCallVoicePrivacyOn(h);
    }

    public void registerForInCallVoicePrivacyOff(Handler h, int what, Object obj) {
        this.mCi.registerForInCallVoicePrivacyOff(h, what, obj);
    }

    public void unregisterForInCallVoicePrivacyOff(Handler h) {
        this.mCi.unregisterForInCallVoicePrivacyOff(h);
    }

    @UnsupportedAppUsage
    public void registerForIncomingRing(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mIncomingRingRegistrants.addUnique(h, what, obj);
    }

    @UnsupportedAppUsage
    public void unregisterForIncomingRing(Handler h) {
        this.mIncomingRingRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public void registerForDisconnect(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mDisconnectRegistrants.addUnique(h, what, obj);
    }

    @UnsupportedAppUsage
    public void unregisterForDisconnect(Handler h) {
        this.mDisconnectRegistrants.remove(h);
    }

    public void registerForSuppServiceFailed(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mSuppServiceFailedRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForSuppServiceFailed(Handler h) {
        this.mSuppServiceFailedRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public void registerForMmiInitiate(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mMmiRegistrants.addUnique(h, what, obj);
    }

    @UnsupportedAppUsage
    public void unregisterForMmiInitiate(Handler h) {
        this.mMmiRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public void registerForMmiComplete(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mMmiCompleteRegistrants.addUnique(h, what, obj);
    }

    @UnsupportedAppUsage
    public void unregisterForMmiComplete(Handler h) {
        this.checkCorrectThread(h);
        this.mMmiCompleteRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public void registerForSimRecordsLoaded(Handler h, int what, Object obj) {
    }

    @UnsupportedAppUsage
    public void unregisterForSimRecordsLoaded(Handler h) {
    }

    public void registerForTtyModeReceived(Handler h, int what, Object obj) {
    }

    public void unregisterForTtyModeReceived(Handler h) {
    }

    @UnsupportedAppUsage
    public void setNetworkSelectionModeAutomatic(Message response) {
        Rlog.d(LOG_TAG, "setNetworkSelectionModeAutomatic, querying current mode");
        Message msg = this.obtainMessage(38);
        msg.obj = response;
        this.mCi.getNetworkSelectionMode(msg);
    }

    private void onCheckForNetworkSelectionModeAutomatic(Message fromRil) {
        AsyncResult ar = (AsyncResult)fromRil.obj;
        Message response = (Message)ar.userObj;
        boolean doAutomatic = true;
        if (ar.exception == null && ar.result != null) {
            try {
                int[] modes = (int[])ar.result;
                if (modes[0] == 0) {
                    doAutomatic = false;
                }
            }
            catch (Exception modes) {
                // empty catch block
            }
        }
        NetworkSelectMessage nsm = new NetworkSelectMessage();
        nsm.message = response;
        nsm.operatorNumeric = "";
        nsm.operatorAlphaLong = "";
        nsm.operatorAlphaShort = "";
        if (doAutomatic) {
            Message msg = this.obtainMessage(17, nsm);
            this.mCi.setNetworkSelectionModeAutomatic(msg);
        } else {
            Rlog.d(LOG_TAG, "setNetworkSelectionModeAutomatic - already auto, ignoring");
            if (nsm.message != null) {
                nsm.message.arg1 = 1;
            }
            ar.userObj = nsm;
            this.handleSetSelectNetwork(ar);
        }
        this.updateSavedNetworkOperator(nsm);
    }

    public void getNetworkSelectionMode(Message message) {
        this.mCi.getNetworkSelectionMode(message);
    }

    public List<ClientRequestStats> getClientRequestStats() {
        return this.mCi.getClientRequestStats();
    }

    @UnsupportedAppUsage
    public void selectNetworkManually(OperatorInfo network, boolean persistSelection, Message response) {
        NetworkSelectMessage nsm = new NetworkSelectMessage();
        nsm.message = response;
        nsm.operatorNumeric = network.getOperatorNumeric();
        nsm.operatorAlphaLong = network.getOperatorAlphaLong();
        nsm.operatorAlphaShort = network.getOperatorAlphaShort();
        Message msg = this.obtainMessage(16, nsm);
        this.mCi.setNetworkSelectionModeManual(network.getOperatorNumeric(), msg);
        if (persistSelection) {
            this.updateSavedNetworkOperator(nsm);
        } else {
            this.clearSavedNetworkSelection();
        }
    }

    public void registerForEmergencyCallToggle(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mEmergencyCallToggledRegistrants.add(r);
    }

    public void unregisterForEmergencyCallToggle(Handler h) {
        this.mEmergencyCallToggledRegistrants.remove(h);
    }

    private void updateSavedNetworkOperator(NetworkSelectMessage nsm) {
        int subId = this.getSubId();
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
            SharedPreferences.Editor editor = sp.edit();
            editor.putString(NETWORK_SELECTION_KEY + subId, nsm.operatorNumeric);
            editor.putString(NETWORK_SELECTION_NAME_KEY + subId, nsm.operatorAlphaLong);
            editor.putString(NETWORK_SELECTION_SHORT_KEY + subId, nsm.operatorAlphaShort);
            if (!editor.commit()) {
                Rlog.e(LOG_TAG, "failed to commit network selection preference");
            }
        } else {
            Rlog.e(LOG_TAG, "Cannot update network selection preference due to invalid subId " + subId);
        }
    }

    private void handleSetSelectNetwork(AsyncResult ar) {
        if (!(ar.userObj instanceof NetworkSelectMessage)) {
            Rlog.e(LOG_TAG, "unexpected result from user object.");
            return;
        }
        NetworkSelectMessage nsm = (NetworkSelectMessage)ar.userObj;
        if (nsm.message != null) {
            AsyncResult.forMessage(nsm.message, ar.result, ar.exception);
            nsm.message.sendToTarget();
        }
    }

    private OperatorInfo getSavedNetworkSelection() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        String numeric = sp.getString(NETWORK_SELECTION_KEY + this.getSubId(), "");
        String name = sp.getString(NETWORK_SELECTION_NAME_KEY + this.getSubId(), "");
        String shrt = sp.getString(NETWORK_SELECTION_SHORT_KEY + this.getSubId(), "");
        return new OperatorInfo(name, shrt, numeric);
    }

    private void clearSavedNetworkSelection() {
        PreferenceManager.getDefaultSharedPreferences(this.getContext()).edit().remove(NETWORK_SELECTION_KEY + this.getSubId()).remove(NETWORK_SELECTION_NAME_KEY + this.getSubId()).remove(NETWORK_SELECTION_SHORT_KEY + this.getSubId()).commit();
    }

    private void restoreSavedNetworkSelection(Message response) {
        OperatorInfo networkSelection = this.getSavedNetworkSelection();
        if (networkSelection == null || TextUtils.isEmpty(networkSelection.getOperatorNumeric())) {
            this.setNetworkSelectionModeAutomatic(response);
        } else {
            this.selectNetworkManually(networkSelection, true, response);
        }
    }

    public void saveClirSetting(int commandInterfaceCLIRMode) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt(CLIR_KEY + this.getPhoneId(), commandInterfaceCLIRMode);
        Rlog.i(LOG_TAG, "saveClirSetting: clir_key" + this.getPhoneId() + "=" + commandInterfaceCLIRMode);
        if (!editor.commit()) {
            Rlog.e(LOG_TAG, "Failed to commit CLIR preference");
        }
    }

    private void setUnitTestMode(boolean f) {
        this.mUnitTestMode = f;
    }

    public boolean getUnitTestMode() {
        return this.mUnitTestMode;
    }

    protected void notifyDisconnectP(Connection cn) {
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mDisconnectRegistrants.notifyRegistrants(ar);
    }

    @UnsupportedAppUsage
    public void registerForServiceStateChanged(Handler h, int what, Object obj) {
        this.mServiceStateRegistrants.add(h, what, obj);
    }

    @UnsupportedAppUsage
    public void unregisterForServiceStateChanged(Handler h) {
        this.mServiceStateRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public void registerForRingbackTone(Handler h, int what, Object obj) {
        this.mCi.registerForRingbackTone(h, what, obj);
    }

    @UnsupportedAppUsage
    public void unregisterForRingbackTone(Handler h) {
        this.mCi.unregisterForRingbackTone(h);
    }

    public void registerForOnHoldTone(Handler h, int what, Object obj) {
    }

    public void unregisterForOnHoldTone(Handler h) {
    }

    public void registerForResendIncallMute(Handler h, int what, Object obj) {
        this.mCi.registerForResendIncallMute(h, what, obj);
    }

    public void unregisterForResendIncallMute(Handler h) {
        this.mCi.unregisterForResendIncallMute(h);
    }

    public void registerForCellInfo(Handler h, int what, Object obj) {
        this.mCellInfoRegistrants.add(h, what, obj);
    }

    public void unregisterForCellInfo(Handler h) {
        this.mCellInfoRegistrants.remove(h);
    }

    public void setEchoSuppressionEnabled() {
    }

    protected void notifyServiceStateChangedP(ServiceState ss) {
        AsyncResult ar = new AsyncResult(null, ss, null);
        this.mServiceStateRegistrants.notifyRegistrants(ar);
        this.mNotifier.notifyServiceState(this);
    }

    public SimulatedRadioControl getSimulatedRadioControl() {
        return this.mSimulatedRadioControl;
    }

    private void checkCorrectThread(Handler h) {
        if (h.getLooper() != this.mLooper) {
            throw new RuntimeException("com.android.internal.telephony.Phone must be used from within one thread");
        }
    }

    private static Locale getLocaleFromCarrierProperties(Context ctx) {
        String carrier = SystemProperties.get("ro.carrier");
        if (null == carrier || 0 == carrier.length() || "unknown".equals(carrier)) {
            return null;
        }
        CharSequence[] carrierLocales = ctx.getResources().getTextArray(17235974);
        for (int i = 0; i < carrierLocales.length; i += 3) {
            String c = carrierLocales[i].toString();
            if (!carrier.equals(c)) continue;
            return Locale.forLanguageTag(carrierLocales[i + 1].toString().replace('_', '-'));
        }
        return null;
    }

    @UnsupportedAppUsage
    public abstract PhoneConstants.State getState();

    @UnsupportedAppUsage
    public IccFileHandler getIccFileHandler() {
        IccFileHandler fh;
        UiccCardApplication uiccApplication = this.mUiccApplication.get();
        if (uiccApplication == null) {
            Rlog.d(LOG_TAG, "getIccFileHandler: uiccApplication == null, return null");
            fh = null;
        } else {
            fh = uiccApplication.getIccFileHandler();
        }
        Rlog.d(LOG_TAG, "getIccFileHandler: fh=" + fh);
        return fh;
    }

    public Handler getHandler() {
        return this;
    }

    public void updatePhoneObject(int voiceRadioTech) {
    }

    @UnsupportedAppUsage
    public ServiceStateTracker getServiceStateTracker() {
        return null;
    }

    public EmergencyNumberTracker getEmergencyNumberTracker() {
        return null;
    }

    @UnsupportedAppUsage
    public CallTracker getCallTracker() {
        return null;
    }

    public TransportManager getTransportManager() {
        return null;
    }

    public void setVoiceActivationState(int state) {
        this.mSimActivationTracker.setVoiceActivationState(state);
    }

    public void setDataActivationState(int state) {
        this.mSimActivationTracker.setDataActivationState(state);
    }

    public int getVoiceActivationState() {
        return this.mSimActivationTracker.getVoiceActivationState();
    }

    public int getDataActivationState() {
        return this.mSimActivationTracker.getDataActivationState();
    }

    public void updateVoiceMail() {
        Rlog.e(LOG_TAG, "updateVoiceMail() should be overridden");
    }

    public IccCardApplicationStatus.AppType getCurrentUiccAppType() {
        UiccCardApplication currentApp = this.mUiccApplication.get();
        if (currentApp != null) {
            return currentApp.getType();
        }
        return IccCardApplicationStatus.AppType.APPTYPE_UNKNOWN;
    }

    @UnsupportedAppUsage
    public IccCard getIccCard() {
        return null;
    }

    @UnsupportedAppUsage
    public String getIccSerialNumber() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getIccId() : null;
    }

    public String getFullIccSerialNumber() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getFullIccId() : null;
    }

    public boolean getIccRecordsLoaded() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getRecordsLoaded() : false;
    }

    public void setCellInfoMinInterval(int interval) {
        this.getServiceStateTracker().setCellInfoMinInterval(interval);
    }

    public List<CellInfo> getAllCellInfo() {
        return this.getServiceStateTracker().getAllCellInfo();
    }

    public void requestCellInfoUpdate(WorkSource workSource, Message rspMsg) {
        this.getServiceStateTracker().requestAllCellInfo(workSource, rspMsg);
    }

    @UnsupportedAppUsage
    public CellLocation getCellLocation() {
        return this.getServiceStateTracker().getCellLocation();
    }

    public void getCellLocation(WorkSource workSource, Message rspMsg) {
        this.getServiceStateTracker().requestCellLocation(workSource, rspMsg);
    }

    public void setCellInfoListRate(int rateInMillis, WorkSource workSource) {
        this.mCi.setCellInfoListRate(rateInMillis, null, workSource);
    }

    public boolean getMessageWaitingIndicator() {
        return this.mVmCount != 0;
    }

    private int getCallForwardingIndicatorFromSharedPref() {
        int status = 0;
        int subId = this.getSubId();
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            String subscriberId;
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
            status = sp.getInt(CF_STATUS + subId, -1);
            Rlog.d(LOG_TAG, "getCallForwardingIndicatorFromSharedPref: for subId " + subId + "= " + status);
            if (status == -1 && (subscriberId = sp.getString(CF_ID, null)) != null) {
                String currentSubscriberId = this.getSubscriberId();
                if (subscriberId.equals(currentSubscriberId)) {
                    status = sp.getInt(CF_STATUS, 0);
                    this.setCallForwardingIndicatorInSharedPref(status == 1);
                    Rlog.d(LOG_TAG, "getCallForwardingIndicatorFromSharedPref: " + status);
                } else {
                    Rlog.d(LOG_TAG, "getCallForwardingIndicatorFromSharedPref: returning DISABLED as status for matching subscriberId not found");
                }
                SharedPreferences.Editor editor = sp.edit();
                editor.remove(CF_ID);
                editor.remove(CF_STATUS);
                editor.apply();
            }
        } else {
            Rlog.e(LOG_TAG, "getCallForwardingIndicatorFromSharedPref: invalid subId " + subId);
        }
        return status;
    }

    private void setCallForwardingIndicatorInSharedPref(boolean enable) {
        int status = enable ? 1 : 0;
        int subId = this.getSubId();
        Rlog.i(LOG_TAG, "setCallForwardingIndicatorInSharedPref: Storing status = " + status + " in pref " + CF_STATUS + subId);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt(CF_STATUS + subId, status);
        editor.apply();
    }

    public void setVoiceCallForwardingFlag(int line, boolean enable, String number) {
        this.setCallForwardingIndicatorInSharedPref(enable);
        IccRecords r = this.mIccRecords.get();
        if (r != null) {
            r.setVoiceCallForwardingFlag(line, enable, number);
        }
    }

    protected void setVoiceCallForwardingFlag(IccRecords r, int line, boolean enable, String number) {
        this.setCallForwardingIndicatorInSharedPref(enable);
        r.setVoiceCallForwardingFlag(line, enable, number);
    }

    public boolean getCallForwardingIndicator() {
        if (this.getPhoneType() == 2) {
            Rlog.e(LOG_TAG, "getCallForwardingIndicator: not possible in CDMA");
            return false;
        }
        IccRecords r = this.mIccRecords.get();
        int callForwardingIndicator = -1;
        if (r != null) {
            callForwardingIndicator = r.getVoiceCallForwardingFlag();
        }
        if (callForwardingIndicator == -1) {
            callForwardingIndicator = this.getCallForwardingIndicatorFromSharedPref();
        }
        Rlog.v(LOG_TAG, "getCallForwardingIndicator: iccForwardingFlag=" + (r != null ? Integer.valueOf(r.getVoiceCallForwardingFlag()) : "null") + ", sharedPrefFlag=" + this.getCallForwardingIndicatorFromSharedPref());
        return callForwardingIndicator == 1;
    }

    public CarrierSignalAgent getCarrierSignalAgent() {
        return this.mCarrierSignalAgent;
    }

    public CarrierActionAgent getCarrierActionAgent() {
        return this.mCarrierActionAgent;
    }

    public void queryCdmaRoamingPreference(Message response) {
        this.mCi.queryCdmaRoamingPreference(response);
    }

    public SignalStrength getSignalStrength() {
        ServiceStateTracker sst = this.getServiceStateTracker();
        if (sst == null) {
            return new SignalStrength();
        }
        return sst.getSignalStrength();
    }

    public boolean isConcurrentVoiceAndDataAllowed() {
        ServiceStateTracker sst = this.getServiceStateTracker();
        return sst == null ? false : sst.isConcurrentVoiceAndDataAllowed();
    }

    public void setCdmaRoamingPreference(int cdmaRoamingType, Message response) {
        this.mCi.setCdmaRoamingPreference(cdmaRoamingType, response);
    }

    public void setCdmaSubscription(int cdmaSubscriptionType, Message response) {
        this.mCi.setCdmaSubscriptionSource(cdmaSubscriptionType, response);
    }

    @UnsupportedAppUsage
    public void setPreferredNetworkType(int networkType, Message response) {
        int modemRaf = this.getRadioAccessFamily();
        int rafFromType = RadioAccessFamily.getRafFromNetworkType(networkType);
        if (modemRaf == 0 || rafFromType == 0) {
            Rlog.d(LOG_TAG, "setPreferredNetworkType: Abort, unknown RAF: " + modemRaf + " " + rafFromType);
            if (response != null) {
                CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
                AsyncResult.forMessage(response, null, ex);
                response.sendToTarget();
            }
            return;
        }
        int filteredRaf = rafFromType & modemRaf;
        int filteredType = RadioAccessFamily.getNetworkTypeFromRaf(filteredRaf);
        Rlog.d(LOG_TAG, "setPreferredNetworkType: networkType = " + networkType + " modemRaf = " + modemRaf + " rafFromType = " + rafFromType + " filteredType = " + filteredType);
        this.mCi.setPreferredNetworkType(filteredType, response);
    }

    public void getPreferredNetworkType(Message response) {
        this.mCi.getPreferredNetworkType(response);
    }

    @UnsupportedAppUsage
    public void getSmscAddress(Message result) {
        this.mCi.getSmscAddress(result);
    }

    @UnsupportedAppUsage
    public void setSmscAddress(String address, Message result) {
        this.mCi.setSmscAddress(address, result);
    }

    public void setTTYMode(int ttyMode, Message onComplete) {
        this.mCi.setTTYMode(ttyMode, onComplete);
    }

    public void setUiTTYMode(int uiTtyMode, Message onComplete) {
        Rlog.d(LOG_TAG, "unexpected setUiTTYMode method call");
    }

    public void queryTTYMode(Message onComplete) {
        this.mCi.queryTTYMode(onComplete);
    }

    public void enableEnhancedVoicePrivacy(boolean enable, Message onComplete) {
    }

    public void getEnhancedVoicePrivacy(Message onComplete) {
    }

    public void setBandMode(int bandMode, Message response) {
        this.mCi.setBandMode(bandMode, response);
    }

    public void queryAvailableBandMode(Message response) {
        this.mCi.queryAvailableBandMode(response);
    }

    @Deprecated
    @UnsupportedAppUsage
    public void invokeOemRilRequestRaw(byte[] data, Message response) {
        this.mCi.invokeOemRilRequestRaw(data, response);
    }

    @Deprecated
    @UnsupportedAppUsage
    public void invokeOemRilRequestStrings(String[] strings, Message response) {
        this.mCi.invokeOemRilRequestStrings(strings, response);
    }

    public void nvReadItem(int itemID, Message response, WorkSource workSource) {
        this.mCi.nvReadItem(itemID, response, workSource);
    }

    public void nvWriteItem(int itemID, String itemValue, Message response, WorkSource workSource) {
        this.mCi.nvWriteItem(itemID, itemValue, response, workSource);
    }

    public void nvWriteCdmaPrl(byte[] preferredRoamingList, Message response) {
        this.mCi.nvWriteCdmaPrl(preferredRoamingList, response);
    }

    public void rebootModem(Message response) {
        this.mCi.nvResetConfig(1, response);
    }

    public void resetModemConfig(Message response) {
        this.mCi.nvResetConfig(3, response);
    }

    public void notifyDataActivity() {
        this.mNotifier.notifyDataActivity(this);
    }

    private void notifyMessageWaitingIndicator() {
        if (!this.mIsVoiceCapable) {
            return;
        }
        this.mNotifier.notifyMessageWaitingChanged(this);
    }

    public void notifyDataConnection(String apnType) {
        this.mNotifier.notifyDataConnection(this, apnType, this.getDataConnectionState(apnType));
    }

    public void notifyDataConnection() {
        String[] types = this.getActiveApnTypes();
        if (types != null) {
            for (String apnType : types) {
                this.mNotifier.notifyDataConnection(this, apnType, this.getDataConnectionState(apnType));
            }
        }
    }

    @UnsupportedAppUsage
    public void notifyOtaspChanged(int otaspMode) {
        this.mNotifier.notifyOtaspChanged(this, otaspMode);
    }

    public void notifyVoiceActivationStateChanged(int state) {
        this.mNotifier.notifyVoiceActivationStateChanged(this, state);
    }

    public void notifyDataActivationStateChanged(int state) {
        this.mNotifier.notifyDataActivationStateChanged(this, state);
    }

    public void notifyUserMobileDataStateChanged(boolean state) {
        this.mNotifier.notifyUserMobileDataStateChanged(this, state);
    }

    public void notifySignalStrength() {
        this.mNotifier.notifySignalStrength(this);
    }

    @Override
    public PhoneConstants.DataState getDataConnectionState(String apnType) {
        return PhoneConstants.DataState.DISCONNECTED;
    }

    public void notifyCellInfo(List<CellInfo> cellInfo) {
        AsyncResult ar = new AsyncResult(null, cellInfo, null);
        this.mCellInfoRegistrants.notifyRegistrants(ar);
        this.mNotifier.notifyCellInfo(this, cellInfo);
    }

    public void notifyPhysicalChannelConfiguration(List<PhysicalChannelConfig> configs) {
        this.mNotifier.notifyPhysicalChannelConfiguration(this, configs);
    }

    public void notifySrvccStateChanged(int state) {
        this.mNotifier.notifySrvccStateChanged(this, state);
    }

    public void notifyEmergencyNumberList() {
        this.mNotifier.notifyEmergencyNumberList(this);
    }

    public boolean isInEmergencyCall() {
        return false;
    }

    protected static boolean getInEcmMode() {
        return SystemProperties.getBoolean("ril.cdma.inecmmode", false);
    }

    public boolean isInEcm() {
        return this.mIsPhoneInEcmState;
    }

    public void setIsInEcm(boolean isInEcm) {
        this.setGlobalSystemProperty("ril.cdma.inecmmode", String.valueOf(isInEcm));
        this.mIsPhoneInEcmState = isInEcm;
    }

    @UnsupportedAppUsage
    private static int getVideoState(Call call) {
        int videoState = 0;
        Connection conn = call.getEarliestConnection();
        if (conn != null) {
            videoState = conn.getVideoState();
        }
        return videoState;
    }

    private boolean isVideoCallOrConference(Call call) {
        if (call.isMultiparty()) {
            return true;
        }
        boolean isDowngradedVideoCall = false;
        if (call instanceof ImsPhoneCall) {
            ImsPhoneCall imsPhoneCall = (ImsPhoneCall)call;
            ImsCall imsCall = imsPhoneCall.getImsCall();
            return imsCall != null && (imsCall.isVideoCall() || imsCall.wasVideoCall());
        }
        return isDowngradedVideoCall;
    }

    public boolean isImsVideoCallOrConferencePresent() {
        boolean isPresent = false;
        if (this.mImsPhone != null) {
            isPresent = this.isVideoCallOrConference(this.mImsPhone.getForegroundCall()) || this.isVideoCallOrConference(this.mImsPhone.getBackgroundCall()) || this.isVideoCallOrConference(this.mImsPhone.getRingingCall());
        }
        Rlog.d(LOG_TAG, "isImsVideoCallOrConferencePresent: " + isPresent);
        return isPresent;
    }

    @UnsupportedAppUsage
    public abstract int getPhoneType();

    public int getVoiceMessageCount() {
        return this.mVmCount;
    }

    public void setVoiceMessageCount(int countWaiting) {
        this.mVmCount = countWaiting;
        int subId = this.getSubId();
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            Rlog.d(LOG_TAG, "setVoiceMessageCount: Storing Voice Mail Count = " + countWaiting + " for mVmCountKey = " + VM_COUNT + subId + " in preferences.");
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
            SharedPreferences.Editor editor = sp.edit();
            editor.putInt(VM_COUNT + subId, countWaiting);
            editor.apply();
        } else {
            Rlog.e(LOG_TAG, "setVoiceMessageCount in sharedPreference: invalid subId " + subId);
        }
        IccRecords records = UiccController.getInstance().getIccRecords(this.mPhoneId, 1);
        if (records != null) {
            Rlog.d(LOG_TAG, "setVoiceMessageCount: updating SIM Records");
            records.setVoiceMessageWaiting(1, countWaiting);
        } else {
            Rlog.d(LOG_TAG, "setVoiceMessageCount: SIM Records not found");
        }
        this.notifyMessageWaitingIndicator();
    }

    protected int getStoredVoiceMessageCount() {
        int countVoiceMessages = 0;
        int subId = this.getSubId();
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            int invalidCount = -2;
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
            int countFromSP = sp.getInt(VM_COUNT + subId, invalidCount);
            if (countFromSP != invalidCount) {
                countVoiceMessages = countFromSP;
                Rlog.d(LOG_TAG, "getStoredVoiceMessageCount: from preference for subId " + subId + "= " + countVoiceMessages);
            } else {
                String subscriberId = sp.getString(VM_ID, null);
                if (subscriberId != null) {
                    String currentSubscriberId = this.getSubscriberId();
                    if (currentSubscriberId != null && currentSubscriberId.equals(subscriberId)) {
                        countVoiceMessages = sp.getInt(VM_COUNT, 0);
                        this.setVoiceMessageCount(countVoiceMessages);
                        Rlog.d(LOG_TAG, "getStoredVoiceMessageCount: from preference = " + countVoiceMessages);
                    } else {
                        Rlog.d(LOG_TAG, "getStoredVoiceMessageCount: returning 0 as count for matching subscriberId not found");
                    }
                    SharedPreferences.Editor editor = sp.edit();
                    editor.remove(VM_ID);
                    editor.remove(VM_COUNT);
                    editor.apply();
                }
            }
        } else {
            Rlog.e(LOG_TAG, "getStoredVoiceMessageCount: invalid subId " + subId);
        }
        return countVoiceMessages;
    }

    public void sendDialerSpecialCode(String code) {
        if (!TextUtils.isEmpty(code)) {
            BroadcastOptions options = BroadcastOptions.makeBasic();
            options.setBackgroundActivityStartsAllowed(true);
            Intent intent = new Intent("android.provider.Telephony.SECRET_CODE", Uri.parse("android_secret_code://" + code));
            intent.addFlags(0x1000000);
            this.mContext.sendBroadcast(intent, null, options.toBundle());
            Intent secrectCodeIntent = new Intent("android.telephony.action.SECRET_CODE", Uri.parse("android_secret_code://" + code));
            secrectCodeIntent.addFlags(0x1000000);
            this.mContext.sendBroadcast(secrectCodeIntent, null, options.toBundle());
        }
    }

    public int getCdmaEriIconIndex() {
        return -1;
    }

    public int getCdmaEriIconMode() {
        return -1;
    }

    public String getCdmaEriText() {
        return "GSM nw, no ERI";
    }

    public String getCdmaMin() {
        return null;
    }

    public boolean isMinInfoReady() {
        return false;
    }

    public String getCdmaPrlVersion() {
        return null;
    }

    public void sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
    }

    @UnsupportedAppUsage
    public void setOnPostDialCharacter(Handler h, int what, Object obj) {
        this.mPostDialHandler = new Registrant(h, what, obj);
    }

    public Registrant getPostDialHandler() {
        return this.mPostDialHandler;
    }

    @UnsupportedAppUsage
    public void exitEmergencyCallbackMode() {
    }

    public void registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
    }

    public void unregisterForCdmaOtaStatusChange(Handler h) {
    }

    public void registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
    }

    public void unregisterForSubscriptionInfoReady(Handler h) {
    }

    @UnsupportedAppUsage
    public boolean needsOtaServiceProvisioning() {
        return false;
    }

    public boolean isOtaSpNumber(String dialStr) {
        return false;
    }

    public void registerForCallWaiting(Handler h, int what, Object obj) {
    }

    public void unregisterForCallWaiting(Handler h) {
    }

    @UnsupportedAppUsage
    public void registerForEcmTimerReset(Handler h, int what, Object obj) {
    }

    @UnsupportedAppUsage
    public void unregisterForEcmTimerReset(Handler h) {
    }

    public void registerForSignalInfo(Handler h, int what, Object obj) {
        this.mCi.registerForSignalInfo(h, what, obj);
    }

    public void unregisterForSignalInfo(Handler h) {
        this.mCi.unregisterForSignalInfo(h);
    }

    public void registerForDisplayInfo(Handler h, int what, Object obj) {
        this.mCi.registerForDisplayInfo(h, what, obj);
    }

    public void unregisterForDisplayInfo(Handler h) {
        this.mCi.unregisterForDisplayInfo(h);
    }

    public void registerForNumberInfo(Handler h, int what, Object obj) {
        this.mCi.registerForNumberInfo(h, what, obj);
    }

    public void unregisterForNumberInfo(Handler h) {
        this.mCi.unregisterForNumberInfo(h);
    }

    public void registerForRedirectedNumberInfo(Handler h, int what, Object obj) {
        this.mCi.registerForRedirectedNumberInfo(h, what, obj);
    }

    public void unregisterForRedirectedNumberInfo(Handler h) {
        this.mCi.unregisterForRedirectedNumberInfo(h);
    }

    public void registerForLineControlInfo(Handler h, int what, Object obj) {
        this.mCi.registerForLineControlInfo(h, what, obj);
    }

    public void unregisterForLineControlInfo(Handler h) {
        this.mCi.unregisterForLineControlInfo(h);
    }

    public void registerFoT53ClirlInfo(Handler h, int what, Object obj) {
        this.mCi.registerFoT53ClirlInfo(h, what, obj);
    }

    public void unregisterForT53ClirInfo(Handler h) {
        this.mCi.unregisterForT53ClirInfo(h);
    }

    public void registerForT53AudioControlInfo(Handler h, int what, Object obj) {
        this.mCi.registerForT53AudioControlInfo(h, what, obj);
    }

    public void unregisterForT53AudioControlInfo(Handler h) {
        this.mCi.unregisterForT53AudioControlInfo(h);
    }

    @UnsupportedAppUsage
    public void setOnEcbModeExitResponse(Handler h, int what, Object obj) {
    }

    @UnsupportedAppUsage
    public void unsetOnEcbModeExitResponse(Handler h) {
    }

    public void registerForRadioOffOrNotAvailable(Handler h, int what, Object obj) {
        this.mRadioOffOrNotAvailableRegistrants.addUnique(h, what, obj);
    }

    public void unregisterForRadioOffOrNotAvailable(Handler h) {
        this.mRadioOffOrNotAvailableRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public String[] getActiveApnTypes() {
        if (this.mTransportManager != null) {
            ArrayList<String> typesList = new ArrayList<String>();
            for (int transportType : this.mTransportManager.getAvailableTransports()) {
                if (this.getDcTracker(transportType) == null) continue;
                typesList.addAll(Arrays.asList(this.getDcTracker(transportType).getActiveApnTypes()));
            }
            return typesList.toArray(new String[typesList.size()]);
        }
        return null;
    }

    public boolean hasMatchedTetherApnSetting() {
        if (this.getDcTracker(1) != null) {
            return this.getDcTracker(1).hasMatchedTetherApnSetting();
        }
        return false;
    }

    public String getActiveApnHost(String apnType) {
        int transportType;
        if (this.mTransportManager != null && this.getDcTracker(transportType = this.mTransportManager.getCurrentTransport(ApnSetting.getApnTypesBitmaskFromString(apnType))) != null) {
            return this.getDcTracker(transportType).getActiveApnString(apnType);
        }
        return null;
    }

    public LinkProperties getLinkProperties(String apnType) {
        int transport;
        if (this.mTransportManager != null && this.getDcTracker(transport = this.mTransportManager.getCurrentTransport(ApnSetting.getApnTypesBitmaskFromString(apnType))) != null) {
            return this.getDcTracker(transport).getLinkProperties(apnType);
        }
        return null;
    }

    public NetworkCapabilities getNetworkCapabilities(String apnType) {
        int transportType;
        if (this.mTransportManager != null && this.getDcTracker(transportType = this.mTransportManager.getCurrentTransport(ApnSetting.getApnTypesBitmaskFromString(apnType))) != null) {
            return this.getDcTracker(transportType).getNetworkCapabilities(apnType);
        }
        return null;
    }

    public boolean isDataAllowed(int apnType) {
        return this.isDataAllowed(apnType, null);
    }

    public boolean isDataAllowed(int apnType, DataConnectionReasons reasons) {
        int transport;
        if (this.mTransportManager != null && this.getDcTracker(transport = this.mTransportManager.getCurrentTransport(apnType)) != null) {
            return this.getDcTracker(transport).isDataAllowed(reasons);
        }
        return false;
    }

    public void carrierActionSetMeteredApnsEnabled(boolean enabled) {
        this.mCarrierActionAgent.carrierActionSetMeteredApnsEnabled(enabled);
    }

    public void carrierActionSetRadioEnabled(boolean enabled) {
        this.mCarrierActionAgent.carrierActionSetRadioEnabled(enabled);
    }

    public void carrierActionReportDefaultNetworkStatus(boolean report) {
        this.mCarrierActionAgent.carrierActionReportDefaultNetworkStatus(report);
    }

    public void carrierActionResetAll() {
        this.mCarrierActionAgent.carrierActionReset();
    }

    public void notifyNewRingingConnectionP(Connection cn) {
        if (!this.mIsVoiceCapable) {
            return;
        }
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mNewRingingConnectionRegistrants.notifyRegistrants(ar);
    }

    public void notifyUnknownConnectionP(Connection cn) {
        this.mUnknownConnectionRegistrants.notifyResult(cn);
    }

    public void notifyForVideoCapabilityChanged(boolean isVideoCallCapable) {
        this.mIsVideoCapable = isVideoCallCapable;
        AsyncResult ar = new AsyncResult(null, isVideoCallCapable, null);
        this.mVideoCapabilityChangedRegistrants.notifyRegistrants(ar);
    }

    private void notifyIncomingRing() {
        if (!this.mIsVoiceCapable) {
            return;
        }
        AsyncResult ar = new AsyncResult(null, this, null);
        this.mIncomingRingRegistrants.notifyRegistrants(ar);
    }

    private void sendIncomingCallRingNotification(int token) {
        if (this.mIsVoiceCapable && !this.mDoesRilSendMultipleCallRing && token == this.mCallRingContinueToken) {
            Rlog.d(LOG_TAG, "Sending notifyIncomingRing");
            this.notifyIncomingRing();
            this.sendMessageDelayed(this.obtainMessage(15, token, 0), this.mCallRingDelay);
        } else {
            Rlog.d(LOG_TAG, "Ignoring ring notification request, mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing + " token=" + token + " mCallRingContinueToken=" + this.mCallRingContinueToken + " mIsVoiceCapable=" + this.mIsVoiceCapable);
        }
    }

    @UnsupportedAppUsage
    public boolean isCspPlmnEnabled() {
        return false;
    }

    @UnsupportedAppUsage
    public IsimRecords getIsimRecords() {
        Rlog.e(LOG_TAG, "getIsimRecords() is only supported on LTE devices");
        return null;
    }

    @UnsupportedAppUsage
    public String getMsisdn() {
        return null;
    }

    public String getPlmn() {
        return null;
    }

    @UnsupportedAppUsage
    public PhoneConstants.DataState getDataConnectionState() {
        return this.getDataConnectionState("default");
    }

    public void notifyCallForwardingIndicator() {
    }

    public void notifyDataConnectionFailed(String apnType) {
        this.mNotifier.notifyDataConnectionFailed(this, apnType);
    }

    public void notifyPreciseDataConnectionFailed(String apnType, String apn, int failCause) {
        this.mNotifier.notifyPreciseDataConnectionFailed(this, apnType, apn, failCause);
    }

    public int getLteOnCdmaMode() {
        return this.mCi.getLteOnCdmaMode();
    }

    public void setVoiceMessageWaiting(int line, int countWaiting) {
        Rlog.e(LOG_TAG, "Error! This function should never be executed, inactive Phone.");
    }

    public UsimServiceTable getUsimServiceTable() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getUsimServiceTable() : null;
    }

    @UnsupportedAppUsage
    public UiccCard getUiccCard() {
        return this.mUiccController.getUiccCard(this.mPhoneId);
    }

    public String[] getPcscfAddress(String apnType) {
        int transportType;
        if (this.mTransportManager != null && this.getDcTracker(transportType = this.mTransportManager.getCurrentTransport(ApnSetting.getApnTypesBitmaskFromString(apnType))) != null) {
            return this.getDcTracker(transportType).getPcscfAddress(apnType);
        }
        return null;
    }

    public void setImsRegistrationState(boolean registered) {
    }

    @UnsupportedAppUsage
    public Phone getImsPhone() {
        return this.mImsPhone;
    }

    @Override
    public ImsiEncryptionInfo getCarrierInfoForImsiEncryption(int keyType) {
        return null;
    }

    @Override
    public void setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo) {
    }

    public int getCarrierId() {
        return -1;
    }

    public String getCarrierName() {
        return null;
    }

    public int getMNOCarrierId() {
        return -1;
    }

    public int getSpecificCarrierId() {
        return -1;
    }

    public String getSpecificCarrierName() {
        return null;
    }

    public int getCarrierIdListVersion() {
        return -1;
    }

    public void resolveSubscriptionCarrierId(String simState) {
    }

    @Override
    public void resetCarrierKeysForImsiEncryption() {
    }

    @UnsupportedAppUsage
    public boolean isUtEnabled() {
        if (this.mImsPhone != null) {
            return this.mImsPhone.isUtEnabled();
        }
        return false;
    }

    @UnsupportedAppUsage
    public void dispose() {
    }

    private void updateImsPhone() {
        Rlog.d(LOG_TAG, "updateImsPhone mImsServiceReady=" + this.mImsServiceReady);
        if (this.mImsServiceReady && this.mImsPhone == null) {
            this.mImsPhone = PhoneFactory.makeImsPhone(this.mNotifier, this);
            CallManager.getInstance().registerPhone(this.mImsPhone);
            this.mImsPhone.registerForSilentRedial(this, 32, null);
        } else if (!this.mImsServiceReady && this.mImsPhone != null) {
            CallManager.getInstance().unregisterPhone(this.mImsPhone);
            this.mImsPhone.unregisterForSilentRedial(this);
            this.mImsPhone.dispose();
            this.mImsPhone = null;
        }
    }

    protected Connection dialInternal(String dialString, PhoneInternalInterface.DialArgs dialArgs) throws CallStateException {
        return null;
    }

    @UnsupportedAppUsage
    public int getSubId() {
        if (SubscriptionController.getInstance() == null) {
            Rlog.e(LOG_TAG, "SubscriptionController.getInstance = null! Returning default subId");
            return Integer.MAX_VALUE;
        }
        return SubscriptionController.getInstance().getSubIdUsingPhoneId(this.mPhoneId);
    }

    @UnsupportedAppUsage
    public int getPhoneId() {
        return this.mPhoneId;
    }

    public int getVoicePhoneServiceState() {
        Phone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            return 0;
        }
        return this.getServiceState().getState();
    }

    public boolean setOperatorBrandOverride(String brand) {
        return false;
    }

    public boolean setRoamingOverride(List<String> gsmRoamingList, List<String> gsmNonRoamingList, List<String> cdmaRoamingList, List<String> cdmaNonRoamingList) {
        String iccId = this.getIccSerialNumber();
        if (TextUtils.isEmpty(iccId)) {
            return false;
        }
        this.setRoamingOverrideHelper(gsmRoamingList, GSM_ROAMING_LIST_OVERRIDE_PREFIX, iccId);
        this.setRoamingOverrideHelper(gsmNonRoamingList, GSM_NON_ROAMING_LIST_OVERRIDE_PREFIX, iccId);
        this.setRoamingOverrideHelper(cdmaRoamingList, CDMA_ROAMING_LIST_OVERRIDE_PREFIX, iccId);
        this.setRoamingOverrideHelper(cdmaNonRoamingList, CDMA_NON_ROAMING_LIST_OVERRIDE_PREFIX, iccId);
        ServiceStateTracker tracker = this.getServiceStateTracker();
        if (tracker != null) {
            tracker.pollState();
        }
        return true;
    }

    private void setRoamingOverrideHelper(List<String> list, String prefix, String iccId) {
        SharedPreferences.Editor spEditor = PreferenceManager.getDefaultSharedPreferences(this.mContext).edit();
        String key = prefix + iccId;
        if (list == null || list.isEmpty()) {
            spEditor.remove(key).commit();
        } else {
            spEditor.putStringSet(key, new HashSet<String>(list)).commit();
        }
    }

    public boolean isMccMncMarkedAsRoaming(String mccMnc) {
        return this.getRoamingOverrideHelper(GSM_ROAMING_LIST_OVERRIDE_PREFIX, mccMnc);
    }

    public boolean isMccMncMarkedAsNonRoaming(String mccMnc) {
        return this.getRoamingOverrideHelper(GSM_NON_ROAMING_LIST_OVERRIDE_PREFIX, mccMnc);
    }

    public boolean isSidMarkedAsRoaming(int SID) {
        return this.getRoamingOverrideHelper(CDMA_ROAMING_LIST_OVERRIDE_PREFIX, Integer.toString(SID));
    }

    public boolean isSidMarkedAsNonRoaming(int SID) {
        return this.getRoamingOverrideHelper(CDMA_NON_ROAMING_LIST_OVERRIDE_PREFIX, Integer.toString(SID));
    }

    public boolean isImsRegistered() {
        Phone imsPhone = this.mImsPhone;
        boolean isImsRegistered = false;
        if (imsPhone != null) {
            isImsRegistered = imsPhone.isImsRegistered();
        } else {
            ServiceStateTracker sst = this.getServiceStateTracker();
            if (sst != null) {
                isImsRegistered = sst.isImsRegistered();
            }
        }
        Rlog.d(LOG_TAG, "isImsRegistered =" + isImsRegistered);
        return isImsRegistered;
    }

    @UnsupportedAppUsage
    public boolean isWifiCallingEnabled() {
        Phone imsPhone = this.mImsPhone;
        boolean isWifiCallingEnabled = false;
        if (imsPhone != null) {
            isWifiCallingEnabled = imsPhone.isWifiCallingEnabled();
        }
        Rlog.d(LOG_TAG, "isWifiCallingEnabled =" + isWifiCallingEnabled);
        return isWifiCallingEnabled;
    }

    public boolean isImsCapabilityAvailable(int capability, int regTech) {
        Phone imsPhone = this.mImsPhone;
        boolean isAvailable = false;
        if (imsPhone != null) {
            isAvailable = imsPhone.isImsCapabilityAvailable(capability, regTech);
        }
        Rlog.d(LOG_TAG, "isImsRegistered =" + isAvailable);
        return isAvailable;
    }

    @UnsupportedAppUsage
    public boolean isVolteEnabled() {
        Phone imsPhone = this.mImsPhone;
        boolean isVolteEnabled = false;
        if (imsPhone != null) {
            isVolteEnabled = imsPhone.isVolteEnabled();
        }
        Rlog.d(LOG_TAG, "isImsRegistered =" + isVolteEnabled);
        return isVolteEnabled;
    }

    public int getImsRegistrationTech() {
        Phone imsPhone = this.mImsPhone;
        int regTech = -1;
        if (imsPhone != null) {
            regTech = imsPhone.getImsRegistrationTech();
        }
        Rlog.d(LOG_TAG, "getImsRegistrationTechnology =" + regTech);
        return regTech;
    }

    private boolean getRoamingOverrideHelper(String prefix, String key) {
        String iccId = this.getIccSerialNumber();
        if (TextUtils.isEmpty(iccId) || TextUtils.isEmpty(key)) {
            return false;
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
        Set<String> value = sp.getStringSet(prefix + iccId, null);
        if (value == null) {
            return false;
        }
        return value.contains(key);
    }

    public int getRadioPowerState() {
        return this.mCi.getRadioState();
    }

    public boolean isRadioAvailable() {
        return this.mCi.getRadioState() != 2;
    }

    public boolean isRadioOn() {
        return this.mCi.getRadioState() == 1;
    }

    public void shutdownRadio() {
        this.getServiceStateTracker().requestShutdown();
    }

    public boolean isShuttingDown() {
        return this.getServiceStateTracker().isDeviceShuttingDown();
    }

    public void setRadioCapability(RadioCapability rc, Message response) {
        this.mCi.setRadioCapability(rc, response);
    }

    public int getRadioAccessFamily() {
        RadioCapability rc = this.getRadioCapability();
        return rc == null ? 0 : rc.getRadioAccessFamily();
    }

    public String getModemUuId() {
        RadioCapability rc = this.getRadioCapability();
        return rc == null ? "" : rc.getLogicalModemUuid();
    }

    public RadioCapability getRadioCapability() {
        return this.mRadioCapability.get();
    }

    public void radioCapabilityUpdated(RadioCapability rc) {
        this.mRadioCapability.set(rc);
        if (SubscriptionManager.isValidSubscriptionId(this.getSubId())) {
            boolean restoreSelection = !this.mContext.getResources().getBoolean(0x111011F);
            this.sendSubscriptionSettings(restoreSelection);
        }
    }

    public void sendSubscriptionSettings(boolean restoreNetworkSelection) {
        int type = PhoneFactory.calculatePreferredNetworkType(this.mContext, this.getSubId());
        this.setPreferredNetworkType(type, null);
        if (restoreNetworkSelection) {
            this.restoreSavedNetworkSelection(null);
        }
    }

    protected void setPreferredNetworkTypeIfSimLoaded() {
        int subId = this.getSubId();
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            int type = PhoneFactory.calculatePreferredNetworkType(this.mContext, this.getSubId());
            this.setPreferredNetworkType(type, null);
        }
    }

    public void registerForRadioCapabilityChanged(Handler h, int what, Object obj) {
        this.mCi.registerForRadioCapabilityChanged(h, what, obj);
    }

    public void unregisterForRadioCapabilityChanged(Handler h) {
        this.mCi.unregisterForRadioCapabilityChanged(this);
    }

    public boolean isImsUseEnabled() {
        ImsManager imsManager = ImsManager.getInstance(this.mContext, this.mPhoneId);
        boolean imsUseEnabled = imsManager.isVolteEnabledByPlatform() && imsManager.isEnhanced4gLteModeSettingEnabledByUser() || imsManager.isWfcEnabledByPlatform() && imsManager.isWfcEnabledByUser() && imsManager.isNonTtyOrTtyOnVolteEnabled();
        return imsUseEnabled;
    }

    public boolean isImsAvailable() {
        if (this.mImsPhone == null) {
            return false;
        }
        return this.mImsPhone.isImsAvailable();
    }

    @UnsupportedAppUsage
    public boolean isVideoEnabled() {
        Phone imsPhone = this.mImsPhone;
        if (imsPhone != null) {
            return imsPhone.isVideoEnabled();
        }
        return false;
    }

    public int getLceStatus() {
        return this.mLceStatus;
    }

    public void getModemActivityInfo(Message response, WorkSource workSource) {
        this.mCi.getModemActivityInfo(response, workSource);
    }

    public void startLceAfterRadioIsAvailable() {
        this.mCi.startLceService(200, true, this.obtainMessage(37));
    }

    public void setAllowedCarriers(CarrierRestrictionRules carrierRestrictionRules, Message response, WorkSource workSource) {
        this.mCi.setAllowedCarriers(carrierRestrictionRules, response, workSource);
    }

    public void setSignalStrengthReportingCriteria(int[] thresholds, int ran) {
    }

    public void setLinkCapacityReportingCriteria(int[] dlThresholds, int[] ulThresholds, int ran) {
    }

    public void getAllowedCarriers(Message response, WorkSource workSource) {
        this.mCi.getAllowedCarriers(response, workSource);
    }

    public Locale getLocaleFromSimAndCarrierPrefs() {
        IccRecords records = this.mIccRecords.get();
        if (records != null && records.getSimLanguage() != null) {
            return new Locale(records.getSimLanguage());
        }
        return Phone.getLocaleFromCarrierProperties(this.mContext);
    }

    public void updateDataConnectionTracker() {
        if (this.mTransportManager != null) {
            for (int transport : this.mTransportManager.getAvailableTransports()) {
                if (this.getDcTracker(transport) == null) continue;
                this.getDcTracker(transport).update();
            }
        }
    }

    public boolean updateCurrentCarrierInProvider() {
        return false;
    }

    public boolean areAllDataDisconnected() {
        if (this.mTransportManager != null) {
            for (int transport : this.mTransportManager.getAvailableTransports()) {
                if (this.getDcTracker(transport) == null || this.getDcTracker(transport).isDisconnected()) continue;
                return false;
            }
        }
        return true;
    }

    public void registerForAllDataDisconnected(Handler h, int what) {
        this.mAllDataDisconnectedRegistrants.addUnique(h, what, null);
        if (this.mTransportManager != null) {
            for (int transport : this.mTransportManager.getAvailableTransports()) {
                if (this.getDcTracker(transport) == null || this.getDcTracker(transport).isDisconnected()) continue;
                this.getDcTracker(transport).registerForAllDataDisconnected(this, 52);
            }
        }
    }

    public void unregisterForAllDataDisconnected(Handler h) {
        this.mAllDataDisconnectedRegistrants.remove(h);
    }

    public DataEnabledSettings getDataEnabledSettings() {
        return this.mDataEnabledSettings;
    }

    @UnsupportedAppUsage
    public IccSmsInterfaceManager getIccSmsInterfaceManager() {
        return null;
    }

    protected boolean isMatchGid(String gid) {
        String gid1 = this.getGroupIdLevel1();
        int gidLength = gid.length();
        return !TextUtils.isEmpty(gid1) && gid1.length() >= gidLength && gid1.substring(0, gidLength).equalsIgnoreCase(gid);
    }

    public static void checkWfcWifiOnlyModeBeforeDial(Phone imsPhone, int phoneId, Context context) throws CallStateException {
        if (imsPhone == null || !imsPhone.isWifiCallingEnabled()) {
            boolean wfcWiFiOnly;
            ImsManager imsManager = ImsManager.getInstance(context, phoneId);
            boolean bl = wfcWiFiOnly = imsManager.isWfcEnabledByPlatform() && imsManager.isWfcEnabledByUser() && imsManager.getWfcMode() == 0;
            if (wfcWiFiOnly) {
                throw new CallStateException(1, "WFC Wi-Fi Only Mode: IMS not registered");
            }
        }
    }

    public void startRingbackTone() {
    }

    public void stopRingbackTone() {
    }

    public void callEndCleanupHandOverCallIfAny() {
    }

    public void cancelUSSD(Message msg) {
    }

    public abstract void setBroadcastEmergencyCallStateChanges(boolean var1);

    public abstract void sendEmergencyCallStateChange(boolean var1);

    public Phone getDefaultPhone() {
        return this;
    }

    public NetworkStats getVtDataUsage(boolean perUidStats) {
        if (this.mImsPhone == null) {
            return null;
        }
        return this.mImsPhone.getVtDataUsage(perUidStats);
    }

    public Uri[] getCurrentSubscriberUris() {
        return null;
    }

    public AppSmsManager getAppSmsManager() {
        return this.mAppSmsManager;
    }

    public void setSimPowerState(int state, WorkSource workSource) {
        this.mCi.setSimCardPower(state, null, workSource);
    }

    public void setRadioIndicationUpdateMode(int filters, int mode) {
        if (this.mDeviceStateMonitor != null) {
            this.mDeviceStateMonitor.setIndicationUpdateMode(filters, mode);
        }
    }

    public void setCarrierTestOverride(String mccmnc, String imsi, String iccid, String gid1, String gid2, String pnn, String spn, String carrierPrivilegeRules, String apn) {
    }

    public DcTracker getDcTracker(int transportType) {
        return this.mDcTrackers.get(transportType);
    }

    public boolean isCdmaSubscriptionAppPresent() {
        return false;
    }

    public HalVersion getHalVersion() {
        if (this.mCi != null && this.mCi instanceof RIL) {
            return ((RIL)this.mCi).getHalVersion();
        }
        return RIL.RADIO_HAL_VERSION_UNKNOWN;
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("Phone: subId=" + this.getSubId());
        pw.println(" mPhoneId=" + this.mPhoneId);
        pw.println(" mCi=" + this.mCi);
        pw.println(" mDnsCheckDisabled=" + this.mDnsCheckDisabled);
        pw.println(" mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing);
        pw.println(" mCallRingContinueToken=" + this.mCallRingContinueToken);
        pw.println(" mCallRingDelay=" + this.mCallRingDelay);
        pw.println(" mIsVoiceCapable=" + this.mIsVoiceCapable);
        pw.println(" mIccRecords=" + this.mIccRecords.get());
        pw.println(" mUiccApplication=" + this.mUiccApplication.get());
        pw.println(" mSmsStorageMonitor=" + this.mSmsStorageMonitor);
        pw.println(" mSmsUsageMonitor=" + this.mSmsUsageMonitor);
        pw.flush();
        pw.println(" mLooper=" + this.mLooper);
        pw.println(" mContext=" + this.mContext);
        pw.println(" mNotifier=" + this.mNotifier);
        pw.println(" mSimulatedRadioControl=" + this.mSimulatedRadioControl);
        pw.println(" mUnitTestMode=" + this.mUnitTestMode);
        pw.println(" isDnsCheckDisabled()=" + this.isDnsCheckDisabled());
        pw.println(" getUnitTestMode()=" + this.getUnitTestMode());
        pw.println(" getState()=" + (Object)((Object)this.getState()));
        pw.println(" getIccSerialNumber()=" + this.getIccSerialNumber());
        pw.println(" getIccRecordsLoaded()=" + this.getIccRecordsLoaded());
        pw.println(" getMessageWaitingIndicator()=" + this.getMessageWaitingIndicator());
        pw.println(" getCallForwardingIndicator()=" + this.getCallForwardingIndicator());
        pw.println(" isInEmergencyCall()=" + this.isInEmergencyCall());
        pw.flush();
        pw.println(" isInEcm()=" + this.isInEcm());
        pw.println(" getPhoneName()=" + this.getPhoneName());
        pw.println(" getPhoneType()=" + this.getPhoneType());
        pw.println(" getVoiceMessageCount()=" + this.getVoiceMessageCount());
        pw.println(" getActiveApnTypes()=" + this.getActiveApnTypes());
        pw.println(" needsOtaServiceProvisioning=" + this.needsOtaServiceProvisioning());
        pw.println(" isInEmergencySmsMode=" + this.isInEmergencySmsMode());
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        if (this.mImsPhone != null) {
            try {
                this.mImsPhone.dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.mTransportManager != null) {
            for (int transport : this.mTransportManager.getAvailableTransports()) {
                if (this.getDcTracker(transport) == null) continue;
                this.getDcTracker(transport).dump(fd, pw, args);
                pw.flush();
                pw.println("++++++++++++++++++++++++++++++++");
            }
        }
        if (this.getServiceStateTracker() != null) {
            try {
                this.getServiceStateTracker().dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.getEmergencyNumberTracker() != null) {
            try {
                this.getEmergencyNumberTracker().dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.mCarrierResolver != null) {
            try {
                this.mCarrierResolver.dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.mCarrierActionAgent != null) {
            try {
                this.mCarrierActionAgent.dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.mCarrierSignalAgent != null) {
            try {
                this.mCarrierSignalAgent.dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.getCallTracker() != null) {
            try {
                this.getCallTracker().dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.mSimActivationTracker != null) {
            try {
                this.mSimActivationTracker.dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.mDeviceStateMonitor != null) {
            pw.println("DeviceStateMonitor:");
            this.mDeviceStateMonitor.dump(fd, pw, args);
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.mTransportManager != null) {
            this.mTransportManager.dump(fd, pw, args);
        }
        if (this.mCi != null && this.mCi instanceof RIL) {
            try {
                ((RIL)this.mCi).dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        pw.println("Phone Local Log: ");
        if (this.mLocalLog != null) {
            try {
                this.mLocalLog.dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
    }

    private static class NetworkSelectMessage {
        public Message message;
        public String operatorNumeric;
        public String operatorAlphaLong;
        public String operatorAlphaShort;

        private NetworkSelectMessage() {
        }
    }
}

