/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemProperties;
import android.os.storage.StorageManager;
import android.telephony.PhoneCapability;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.telephony.DefaultPhoneNotifier;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.RadioConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class PhoneConfigurationManager {
    public static final String DSDA = "dsda";
    public static final String DSDS = "dsds";
    public static final String TSTS = "tsts";
    public static final String SSSS = "";
    private static final String LOG_TAG = "PhoneCfgMgr";
    private static final int EVENT_SWITCH_DSDS_CONFIG_DONE = 100;
    private static final int EVENT_GET_MODEM_STATUS = 101;
    private static final int EVENT_GET_MODEM_STATUS_DONE = 102;
    private static final int EVENT_GET_PHONE_CAPABILITY_DONE = 103;
    private static PhoneConfigurationManager sInstance = null;
    private final Context mContext;
    private PhoneCapability mStaticCapability;
    private final RadioConfig mRadioConfig;
    private final MainThreadHandler mHandler;
    private final Phone[] mPhones;
    private final Map<Integer, Boolean> mPhoneStatusMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhoneConfigurationManager init(Context context) {
        Class<PhoneConfigurationManager> clazz = PhoneConfigurationManager.class;
        synchronized (PhoneConfigurationManager.class) {
            if (sInstance == null) {
                sInstance = new PhoneConfigurationManager(context);
            } else {
                Log.wtf(LOG_TAG, "init() called multiple times!  sInstance = " + sInstance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private PhoneConfigurationManager(Context context) {
        this.mContext = context;
        TelephonyManager telephonyManager = new TelephonyManager(context);
        this.mStaticCapability = this.getDefaultCapability();
        this.mRadioConfig = RadioConfig.getInstance(this.mContext);
        this.mHandler = new MainThreadHandler();
        this.mPhoneStatusMap = new HashMap<Integer, Boolean>();
        this.notifyCapabilityChanged();
        this.mPhones = PhoneFactory.getPhones();
        if (!StorageManager.inCryptKeeperBounce()) {
            for (Phone phone : this.mPhones) {
                phone.mCi.registerForAvailable(this.mHandler, 1, phone);
            }
        } else {
            for (Phone phone : this.mPhones) {
                phone.mCi.registerForOn(this.mHandler, 5, phone);
            }
        }
    }

    private PhoneCapability getDefaultCapability() {
        if (this.getPhoneCount() > 1) {
            return PhoneCapability.DEFAULT_DSDS_CAPABILITY;
        }
        return PhoneCapability.DEFAULT_SSSS_CAPABILITY;
    }

    public static PhoneConfigurationManager getInstance() {
        if (sInstance == null) {
            Log.wtf(LOG_TAG, "getInstance null");
        }
        return sInstance;
    }

    public void enablePhone(Phone phone, boolean enable, Message result) {
        if (phone == null) {
            PhoneConfigurationManager.log("enablePhone failed phone is null");
            return;
        }
        phone.mCi.enableModem(enable, result);
    }

    public boolean getPhoneStatus(Phone phone) {
        if (phone == null) {
            PhoneConfigurationManager.log("getPhoneStatus failed phone is null");
            return false;
        }
        int phoneId = phone.getPhoneId();
        try {
            return this.getPhoneStatusFromCache(phoneId);
        }
        catch (NoSuchElementException ex) {
            this.updatePhoneStatus(phone);
            return true;
        }
    }

    public void getPhoneStatusFromModem(Phone phone, Message result) {
        if (phone == null) {
            PhoneConfigurationManager.log("getPhoneStatus failed phone is null");
        }
        phone.mCi.getModemStatus(result);
    }

    public boolean getPhoneStatusFromCache(int phoneId) throws NoSuchElementException {
        if (this.mPhoneStatusMap.containsKey(phoneId)) {
            return this.mPhoneStatusMap.get(phoneId);
        }
        throw new NoSuchElementException("phoneId not found: " + phoneId);
    }

    private void updatePhoneStatus(Phone phone) {
        Message result = Message.obtain(this.mHandler, 102, phone.getPhoneId(), 0);
        phone.mCi.getModemStatus(result);
    }

    public void addToPhoneStatusCache(int phoneId, boolean status) {
        this.mPhoneStatusMap.put(phoneId, status);
    }

    public int getPhoneCount() {
        TelephonyManager tm = new TelephonyManager(this.mContext);
        return tm.getPhoneCount();
    }

    public synchronized PhoneCapability getStaticPhoneCapability() {
        if (this.getDefaultCapability().equals(this.mStaticCapability)) {
            PhoneConfigurationManager.log("getStaticPhoneCapability: sending the request for getting PhoneCapability");
            Message callback = Message.obtain((Handler)this.mHandler, 103);
            this.mRadioConfig.getPhoneCapability(callback);
        }
        return this.mStaticCapability;
    }

    public PhoneCapability getCurrentPhoneCapability() {
        return this.getStaticPhoneCapability();
    }

    public int getNumberOfModemsWithSimultaneousDataConnections() {
        return this.mStaticCapability.maxActiveData;
    }

    private void notifyCapabilityChanged() {
        DefaultPhoneNotifier notifier = new DefaultPhoneNotifier();
        notifier.notifyPhoneCapabilityChanged(this.mStaticCapability);
    }

    public void switchMultiSimConfig(int numOfSims) {
        PhoneConfigurationManager.log("switchMultiSimConfig: with numOfSims = " + numOfSims);
        if (this.getStaticPhoneCapability().logicalModemList.size() < numOfSims) {
            PhoneConfigurationManager.log("switchMultiSimConfig: Phone is not capable of enabling " + numOfSims + " sims, exiting!");
            return;
        }
        if (this.getPhoneCount() != numOfSims) {
            PhoneConfigurationManager.log("switchMultiSimConfig: sending the request for switching");
            Message callback = Message.obtain(this.mHandler, 100, numOfSims, 0);
            this.mRadioConfig.setModemsConfig(numOfSims, callback);
        } else {
            PhoneConfigurationManager.log("switchMultiSimConfig: No need to switch. getNumOfActiveSims is already " + numOfSims);
        }
    }

    public boolean isRebootRequiredForModemConfigChange() {
        String rebootRequired = SystemProperties.get("persist.radio.reboot_on_modem_change");
        PhoneConfigurationManager.log("isRebootRequiredForModemConfigChange: isRebootRequired = " + rebootRequired);
        return !rebootRequired.equals("false");
    }

    private void setMultiSimProperties(int numOfSims) {
        String finalMultiSimConfig;
        switch (numOfSims) {
            case 3: {
                finalMultiSimConfig = TSTS;
                break;
            }
            case 2: {
                finalMultiSimConfig = DSDS;
                break;
            }
            default: {
                finalMultiSimConfig = SSSS;
            }
        }
        SystemProperties.set("persist.radio.multisim.config", finalMultiSimConfig);
        if (this.isRebootRequiredForModemConfigChange()) {
            PhoneConfigurationManager.log("setMultiSimProperties: Rebooting due to switching multi-sim config to " + finalMultiSimConfig);
            PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
            pm.reboot("Switching to " + finalMultiSimConfig);
        } else {
            PhoneConfigurationManager.log("setMultiSimProperties: Rebooting is not required to switch multi-sim config to " + finalMultiSimConfig);
        }
    }

    private static void log(String s) {
        Rlog.d(LOG_TAG, s);
    }

    private final class MainThreadHandler
    extends Handler {
        private MainThreadHandler() {
        }

        @Override
        public void handleMessage(Message msg) {
            Phone phone = null;
            switch (msg.what) {
                case 1: 
                case 5: {
                    PhoneConfigurationManager.log("Received EVENT_RADIO_AVAILABLE/EVENT_RADIO_ON");
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.userObj != null && ar.userObj instanceof Phone) {
                        phone = (Phone)ar.userObj;
                        PhoneConfigurationManager.this.updatePhoneStatus(phone);
                    } else {
                        PhoneConfigurationManager.log("Unable to add phoneStatus to cache. No phone object provided for event " + msg.what);
                    }
                    PhoneConfigurationManager.this.getStaticPhoneCapability();
                    break;
                }
                case 100: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar != null && ar.exception == null) {
                        int numOfLiveModems = msg.arg1;
                        PhoneConfigurationManager.this.setMultiSimProperties(numOfLiveModems);
                        break;
                    }
                    PhoneConfigurationManager.log(msg.what + " failure. Not switching multi-sim config." + ar.exception);
                    break;
                }
                case 102: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar != null && ar.exception == null) {
                        int phoneId = msg.arg1;
                        boolean enabled = (Boolean)ar.result;
                        PhoneConfigurationManager.this.addToPhoneStatusCache(phoneId, enabled);
                        break;
                    }
                    PhoneConfigurationManager.log(msg.what + " failure. Not updating modem status." + ar.exception);
                    break;
                }
                case 103: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar != null && ar.exception == null) {
                        PhoneConfigurationManager.this.mStaticCapability = (PhoneCapability)ar.result;
                        PhoneConfigurationManager.this.notifyCapabilityChanged();
                        break;
                    }
                    PhoneConfigurationManager.log(msg.what + " failure. Not getting phone capability." + ar.exception);
                }
            }
        }
    }
}

