/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import com.android.internal.telephony.PhoneConstants;

@Deprecated
public final class PhoneStateIntentReceiver
extends BroadcastReceiver {
    private static final String LOG_TAG = "PhoneStatIntentReceiver";
    private static final boolean DBG = false;
    private static final int NOTIF_PHONE = 1;
    private static final int NOTIF_SERVICE = 2;
    private static final int NOTIF_SIGNAL = 4;
    PhoneConstants.State mPhoneState = PhoneConstants.State.IDLE;
    ServiceState mServiceState = new ServiceState();
    @UnsupportedAppUsage
    SignalStrength mSignalStrength = new SignalStrength();
    private Context mContext;
    private Handler mTarget;
    private IntentFilter mFilter = new IntentFilter();
    @UnsupportedAppUsage
    private int mWants;
    private int mPhoneStateEventWhat;
    private int mServiceStateEventWhat;
    private int mAsuEventWhat;

    public PhoneStateIntentReceiver() {
    }

    @UnsupportedAppUsage
    public PhoneStateIntentReceiver(Context context, Handler target) {
        this();
        this.setContext(context);
        this.setTarget(target);
    }

    public void setContext(Context c) {
        this.mContext = c;
    }

    public void setTarget(Handler h) {
        this.mTarget = h;
    }

    public PhoneConstants.State getPhoneState() {
        if ((this.mWants & 1) == 0) {
            throw new RuntimeException("client must call notifyPhoneCallState(int)");
        }
        return this.mPhoneState;
    }

    public ServiceState getServiceState() {
        if ((this.mWants & 2) == 0) {
            throw new RuntimeException("client must call notifyServiceState(int)");
        }
        return this.mServiceState;
    }

    public int getSignalStrengthLevelAsu() {
        if ((this.mWants & 4) == 0) {
            throw new RuntimeException("client must call notifySignalStrength(int)");
        }
        return this.mSignalStrength.getAsuLevel();
    }

    @UnsupportedAppUsage
    public int getSignalStrengthDbm() {
        if ((this.mWants & 4) == 0) {
            throw new RuntimeException("client must call notifySignalStrength(int)");
        }
        return this.mSignalStrength.getDbm();
    }

    public void notifyPhoneCallState(int eventWhat) {
        this.mWants |= 1;
        this.mPhoneStateEventWhat = eventWhat;
        this.mFilter.addAction("android.intent.action.PHONE_STATE");
    }

    public boolean getNotifyPhoneCallState() {
        return (this.mWants & 1) != 0;
    }

    @UnsupportedAppUsage
    public void notifyServiceState(int eventWhat) {
        this.mWants |= 2;
        this.mServiceStateEventWhat = eventWhat;
        this.mFilter.addAction("android.intent.action.SERVICE_STATE");
    }

    public boolean getNotifyServiceState() {
        return (this.mWants & 2) != 0;
    }

    @UnsupportedAppUsage
    public void notifySignalStrength(int eventWhat) {
        this.mWants |= 4;
        this.mAsuEventWhat = eventWhat;
        this.mFilter.addAction("android.intent.action.SIG_STR");
    }

    public boolean getNotifySignalStrength() {
        return (this.mWants & 4) != 0;
    }

    @UnsupportedAppUsage
    public void registerIntent() {
        this.mContext.registerReceiver(this, this.mFilter);
    }

    @UnsupportedAppUsage
    public void unregisterIntent() {
        this.mContext.unregisterReceiver(this);
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        try {
            if ("android.intent.action.SIG_STR".equals(action)) {
                this.mSignalStrength = SignalStrength.newFromBundle(intent.getExtras());
                if (this.mTarget != null && this.getNotifySignalStrength()) {
                    Message message = Message.obtain(this.mTarget, this.mAsuEventWhat);
                    this.mTarget.sendMessage(message);
                }
            } else if ("android.intent.action.PHONE_STATE".equals(action)) {
                String phoneState = intent.getStringExtra("state");
                this.mPhoneState = Enum.valueOf(PhoneConstants.State.class, phoneState);
                if (this.mTarget != null && this.getNotifyPhoneCallState()) {
                    Message message = Message.obtain(this.mTarget, this.mPhoneStateEventWhat);
                    this.mTarget.sendMessage(message);
                }
            } else if ("android.intent.action.SERVICE_STATE".equals(action)) {
                this.mServiceState = ServiceState.newFromBundle(intent.getExtras());
                if (this.mTarget != null && this.getNotifyServiceState()) {
                    Message message = Message.obtain(this.mTarget, this.mServiceStateEventWhat);
                    this.mTarget.sendMessage(message);
                }
            }
        }
        catch (Exception ex) {
            Rlog.e(LOG_TAG, "[PhoneStateIntentRecv] caught " + ex);
            ex.printStackTrace();
        }
    }
}

