/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.app.AppOpsManager;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.ImsiEncryptionInfo;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.TelephonyPermissions;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;

public class PhoneSubInfoController
extends IPhoneSubInfo.Stub {
    private static final String TAG = "PhoneSubInfoController";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    @UnsupportedAppUsage
    private final Phone[] mPhone;
    @UnsupportedAppUsage
    private final Context mContext;
    private final AppOpsManager mAppOps;

    public PhoneSubInfoController(Context context, Phone[] phone) {
        this.mPhone = phone;
        if (ServiceManager.getService("iphonesubinfo") == null) {
            ServiceManager.addService("iphonesubinfo", this);
        }
        this.mContext = context;
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
    }

    @Override
    public String getDeviceId(String callingPackage) {
        return this.getDeviceIdForPhone(SubscriptionManager.getPhoneId(this.getDefaultSubscription()), callingPackage);
    }

    @Override
    public String getDeviceIdForPhone(int phoneId, String callingPackage) {
        return this.callPhoneMethodForPhoneIdWithReadDeviceIdentifiersCheck(phoneId, callingPackage, "getDeviceId", phone -> phone.getDeviceId());
    }

    @Override
    public String getNaiForSubscriber(int subId, String callingPackage) {
        return this.callPhoneMethodForSubIdWithReadCheck(subId, callingPackage, "getNai", phone -> phone.getNai());
    }

    @Override
    public String getImeiForSubscriber(int subId, String callingPackage) {
        return this.callPhoneMethodForSubIdWithReadDeviceIdentifiersCheck(subId, callingPackage, "getImei", phone -> phone.getImei());
    }

    @Override
    public ImsiEncryptionInfo getCarrierInfoForImsiEncryption(int subId, int keyType, String callingPackage) {
        return this.callPhoneMethodForSubIdWithReadCheck(subId, callingPackage, "getCarrierInfoForImsiEncryption", phone -> phone.getCarrierInfoForImsiEncryption(keyType));
    }

    @Override
    public void setCarrierInfoForImsiEncryption(int subId, String callingPackage, ImsiEncryptionInfo imsiEncryptionInfo) {
        this.callPhoneMethodForSubIdWithModifyCheck(subId, callingPackage, "setCarrierInfoForImsiEncryption", phone -> {
            phone.setCarrierInfoForImsiEncryption(imsiEncryptionInfo);
            return null;
        });
    }

    @Override
    public void resetCarrierKeysForImsiEncryption(int subId, String callingPackage) {
        this.callPhoneMethodForSubIdWithModifyCheck(subId, callingPackage, "setCarrierInfoForImsiEncryption", phone -> {
            phone.resetCarrierKeysForImsiEncryption();
            return null;
        });
    }

    @Override
    public String getDeviceSvn(String callingPackage) {
        return this.getDeviceSvnUsingSubId(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getDeviceSvnUsingSubId(int subId, String callingPackage) {
        return this.callPhoneMethodForSubIdWithReadCheck(subId, callingPackage, "getDeviceSvn", phone -> phone.getDeviceSvn());
    }

    @Override
    public String getSubscriberId(String callingPackage) {
        return this.getSubscriberIdForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubscriberIdForSubscriber(int subId, String callingPackage) {
        boolean isActive;
        String message = "getSubscriberId";
        long identity = Binder.clearCallingIdentity();
        try {
            isActive = SubscriptionController.getInstance().isActiveSubId(subId, callingPackage);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        if (isActive) {
            return this.callPhoneMethodForSubIdWithReadSubscriberIdentifiersCheck(subId, callingPackage, message, phone -> phone.getSubscriberId());
        }
        if (!TelephonyPermissions.checkCallingOrSelfReadSubscriberIdentifiers(this.mContext, subId, callingPackage, message)) {
            return null;
        }
        identity = Binder.clearCallingIdentity();
        try {
            String string2 = SubscriptionController.getInstance().getImsiPrivileged(subId);
            return string2;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @Override
    public String getIccSerialNumber(String callingPackage) {
        return this.getIccSerialNumberForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getIccSerialNumberForSubscriber(int subId, String callingPackage) {
        return this.callPhoneMethodForSubIdWithReadSubscriberIdentifiersCheck(subId, callingPackage, "getIccSerialNumber", phone -> phone.getIccSerialNumber());
    }

    @Override
    public String getLine1Number(String callingPackage) {
        return this.getLine1NumberForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getLine1NumberForSubscriber(int subId, String callingPackage) {
        return this.callPhoneMethodForSubIdWithReadPhoneNumberCheck(subId, callingPackage, "getLine1Number", phone -> phone.getLine1Number());
    }

    @Override
    public String getLine1AlphaTag(String callingPackage) {
        return this.getLine1AlphaTagForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getLine1AlphaTagForSubscriber(int subId, String callingPackage) {
        return this.callPhoneMethodForSubIdWithReadCheck(subId, callingPackage, "getLine1AlphaTag", phone -> phone.getLine1AlphaTag());
    }

    @Override
    public String getMsisdn(String callingPackage) {
        return this.getMsisdnForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getMsisdnForSubscriber(int subId, String callingPackage) {
        return this.callPhoneMethodForSubIdWithReadCheck(subId, callingPackage, "getMsisdn", phone -> phone.getMsisdn());
    }

    @Override
    public String getVoiceMailNumber(String callingPackage) {
        return this.getVoiceMailNumberForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getVoiceMailNumberForSubscriber(int subId, String callingPackage) {
        return this.callPhoneMethodForSubIdWithReadCheck(subId, callingPackage, "getVoiceMailNumber", phone -> {
            String number = PhoneNumberUtils.extractNetworkPortion(phone.getVoiceMailNumber());
            return number;
        });
    }

    @Override
    public String getVoiceMailAlphaTag(String callingPackage) {
        return this.getVoiceMailAlphaTagForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getVoiceMailAlphaTagForSubscriber(int subId, String callingPackage) {
        return this.callPhoneMethodForSubIdWithReadCheck(subId, callingPackage, "getVoiceMailAlphaTag", phone -> phone.getVoiceMailAlphaTag());
    }

    @UnsupportedAppUsage
    private Phone getPhone(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        if (!SubscriptionManager.isValidPhoneId(phoneId)) {
            phoneId = 0;
        }
        return this.mPhone[phoneId];
    }

    private void enforcePrivilegedPermissionOrCarrierPrivilege(int subId, String message) {
        int permissionResult = this.mContext.checkCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE");
        if (permissionResult == 0) {
            return;
        }
        TelephonyPermissions.enforceCallingOrSelfCarrierPrivilege(subId, message);
    }

    private void enforceModifyPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "Requires MODIFY_PHONE_STATE");
    }

    @UnsupportedAppUsage
    private int getDefaultSubscription() {
        return PhoneFactory.getDefaultSubscription();
    }

    @Override
    public String getIsimImpi(int subId) {
        return this.callPhoneMethodForSubIdWithPrivilegedCheck(subId, "getIsimImpi", phone -> {
            IsimRecords isim = phone.getIsimRecords();
            if (isim != null) {
                return isim.getIsimImpi();
            }
            return null;
        });
    }

    @Override
    public String getIsimDomain(int subId) {
        return this.callPhoneMethodForSubIdWithPrivilegedCheck(subId, "getIsimDomain", phone -> {
            IsimRecords isim = phone.getIsimRecords();
            if (isim != null) {
                return isim.getIsimDomain();
            }
            return null;
        });
    }

    @Override
    public String[] getIsimImpu(int subId) {
        return this.callPhoneMethodForSubIdWithPrivilegedCheck(subId, "getIsimImpu", phone -> {
            IsimRecords isim = phone.getIsimRecords();
            if (isim != null) {
                return isim.getIsimImpu();
            }
            return null;
        });
    }

    @Override
    public String getIsimIst(int subId) throws RemoteException {
        return this.callPhoneMethodForSubIdWithPrivilegedCheck(subId, "getIsimIst", phone -> {
            IsimRecords isim = phone.getIsimRecords();
            if (isim != null) {
                return isim.getIsimIst();
            }
            return null;
        });
    }

    @Override
    public String[] getIsimPcscf(int subId) throws RemoteException {
        return this.callPhoneMethodForSubIdWithPrivilegedCheck(subId, "getIsimPcscf", phone -> {
            IsimRecords isim = phone.getIsimRecords();
            if (isim != null) {
                return isim.getIsimPcscf();
            }
            return null;
        });
    }

    @Override
    public String getIccSimChallengeResponse(int subId, int appType, int authType, String data) throws RemoteException {
        CallPhoneMethodHelper<String> toExecute = phone -> {
            UiccCard uiccCard = phone.getUiccCard();
            if (uiccCard == null) {
                this.loge("getIccSimChallengeResponse() UiccCard is null");
                return null;
            }
            UiccCardApplication uiccApp = uiccCard.getApplicationByType(appType);
            if (uiccApp == null) {
                this.loge("getIccSimChallengeResponse() no app with specified type -- " + appType);
                return null;
            }
            this.loge("getIccSimChallengeResponse() found app " + uiccApp.getAid() + " specified type -- " + appType);
            if (authType != 128 && authType != 129) {
                this.loge("getIccSimChallengeResponse() unsupported authType: " + authType);
                return null;
            }
            return uiccApp.getIccRecords().getIccSimChallengeResponse(authType, data);
        };
        return this.callPhoneMethodWithPermissionCheck(subId, null, "getIccSimChallengeResponse", toExecute, (aContext, aSubId, aCallingPackage, aMessage) -> {
            this.enforcePrivilegedPermissionOrCarrierPrivilege(aSubId, aMessage);
            return true;
        });
    }

    @Override
    public String getGroupIdLevel1ForSubscriber(int subId, String callingPackage) {
        return this.callPhoneMethodForSubIdWithReadCheck(subId, callingPackage, "getGroupIdLevel1", phone -> phone.getGroupIdLevel1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T callPhoneMethodWithPermissionCheck(int subId, String callingPackage, String message, CallPhoneMethodHelper<T> callMethodHelper, PermissionCheckHelper permissionCheckHelper) {
        if (!permissionCheckHelper.checkPermission(this.mContext, subId, callingPackage, message)) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            Phone phone = this.getPhone(subId);
            if (phone != null) {
                T t = callMethodHelper.callMethod(phone);
                return t;
            }
            this.loge(message + " phone is null for Subscription:" + subId);
            T t = null;
            return t;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private <T> T callPhoneMethodForSubIdWithReadCheck(int subId, String callingPackage, String message, CallPhoneMethodHelper<T> callMethodHelper) {
        return this.callPhoneMethodWithPermissionCheck(subId, callingPackage, message, callMethodHelper, (aContext, aSubId, aCallingPackage, aMessage) -> TelephonyPermissions.checkCallingOrSelfReadPhoneState(aContext, aSubId, aCallingPackage, aMessage));
    }

    private <T> T callPhoneMethodForSubIdWithReadDeviceIdentifiersCheck(int subId, String callingPackage, String message, CallPhoneMethodHelper<T> callMethodHelper) {
        return this.callPhoneMethodWithPermissionCheck(subId, callingPackage, message, callMethodHelper, (aContext, aSubId, aCallingPackage, aMessage) -> TelephonyPermissions.checkCallingOrSelfReadDeviceIdentifiers(aContext, aSubId, aCallingPackage, aMessage));
    }

    private <T> T callPhoneMethodForSubIdWithReadSubscriberIdentifiersCheck(int subId, String callingPackage, String message, CallPhoneMethodHelper<T> callMethodHelper) {
        return this.callPhoneMethodWithPermissionCheck(subId, callingPackage, message, callMethodHelper, (aContext, aSubId, aCallingPackage, aMessage) -> TelephonyPermissions.checkCallingOrSelfReadSubscriberIdentifiers(aContext, aSubId, aCallingPackage, aMessage));
    }

    private <T> T callPhoneMethodForSubIdWithPrivilegedCheck(int subId, String message, CallPhoneMethodHelper<T> callMethodHelper) {
        return this.callPhoneMethodWithPermissionCheck(subId, null, message, callMethodHelper, (aContext, aSubId, aCallingPackage, aMessage) -> {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", message);
            return true;
        });
    }

    private <T> T callPhoneMethodForSubIdWithModifyCheck(int subId, String callingPackage, String message, CallPhoneMethodHelper<T> callMethodHelper) {
        return this.callPhoneMethodWithPermissionCheck(subId, null, message, callMethodHelper, (aContext, aSubId, aCallingPackage, aMessage) -> {
            this.enforceModifyPermission();
            return true;
        });
    }

    private <T> T callPhoneMethodForSubIdWithReadPhoneNumberCheck(int subId, String callingPackage, String message, CallPhoneMethodHelper<T> callMethodHelper) {
        return this.callPhoneMethodWithPermissionCheck(subId, callingPackage, message, callMethodHelper, (aContext, aSubId, aCallingPackage, aMessage) -> TelephonyPermissions.checkCallingOrSelfReadPhoneNumber(aContext, aSubId, aCallingPackage, aMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T callPhoneMethodForPhoneIdWithReadDeviceIdentifiersCheck(int phoneId, String callingPackage, String message, CallPhoneMethodHelper<T> callMethodHelper) {
        Phone phone;
        if (!SubscriptionManager.isValidPhoneId(phoneId)) {
            phoneId = 0;
        }
        if ((phone = this.mPhone[phoneId]) == null) {
            return null;
        }
        if (!TelephonyPermissions.checkCallingOrSelfReadDeviceIdentifiers(this.mContext, phone.getSubId(), callingPackage, message)) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            T t = callMethodHelper.callMethod(phone);
            return t;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void log(String s) {
        Rlog.d(TAG, s);
    }

    @UnsupportedAppUsage
    private void loge(String s) {
        Rlog.e(TAG, s);
    }

    private static interface PermissionCheckHelper {
        public boolean checkPermission(Context var1, int var2, String var3, String var4);
    }

    private static interface CallPhoneMethodHelper<T> {
        public T callMethod(Phone var1);
    }
}

