/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.MatchAllNetworkSpecifier;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkFactory;
import android.net.NetworkRequest;
import android.net.NetworkSpecifier;
import android.net.StringNetworkSpecifier;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.PhoneCapability;
import android.telephony.PhoneStateListener;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.util.LocalLog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CellularNetworkValidator;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.ISetOpportunisticDataCallback;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RadioConfig;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.dataconnection.DcRequest;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.nano.TelephonyProto;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class PhoneSwitcher
extends Handler {
    private static final String LOG_TAG = "PhoneSwitcher";
    private static final boolean VDBG = false;
    private static final int DEFAULT_NETWORK_CHANGE_TIMEOUT_MS = 5000;
    private static final int MODEM_COMMAND_RETRY_PERIOD_MS = 5000;
    @VisibleForTesting
    public static int ECBM_DEFAULT_DATA_SWITCH_BASE_TIME_MS = 5000;
    @VisibleForTesting
    public static int DEFAULT_DATA_OVERRIDE_TIMEOUT_MS = 5000;
    private static final int DEFAULT_EMERGENCY_PHONE_ID = 0;
    private final List<DcRequest> mPrioritizedDcRequests = new ArrayList<DcRequest>();
    private final RegistrantList mActivePhoneRegistrants;
    private final SubscriptionController mSubscriptionController;
    private final int[] mPhoneSubscriptions;
    private final CommandsInterface[] mCommandsInterfaces;
    private final Context mContext;
    private final PhoneState[] mPhoneStates;
    @UnsupportedAppUsage
    private final int mNumPhones;
    @UnsupportedAppUsage
    private final Phone[] mPhones;
    private final LocalLog mLocalLog;
    @VisibleForTesting
    public final PhoneStateListener mPhoneStateListener;
    private final CellularNetworkValidator mValidator;
    @VisibleForTesting
    public final CellularNetworkValidator.ValidationCallback mValidationCallback = (validated, subId) -> Message.obtain(this, 110, subId, validated ? 1 : 0).sendToTarget();
    @UnsupportedAppUsage
    private int mMaxActivePhones;
    private static PhoneSwitcher sPhoneSwitcher = null;
    private int mPrimaryDataSubId = -1;
    private int mOpptDataSubId = Integer.MAX_VALUE;
    private int mPhoneIdInVoiceCall = -1;
    @VisibleForTesting
    protected int mPreferredDataPhoneId = -1;
    private int mPreferredDataSubId = -1;
    private EmergencyOverrideRequest mEmergencyOverride;
    private ISetOpportunisticDataCallback mSetOpptSubCallback;
    private static final int EVENT_PRIMARY_DATA_SUB_CHANGED = 101;
    private static final int EVENT_SUBSCRIPTION_CHANGED = 102;
    private static final int EVENT_REQUEST_NETWORK = 103;
    private static final int EVENT_RELEASE_NETWORK = 104;
    private static final int EVENT_EMERGENCY_TOGGLE = 105;
    private static final int EVENT_RADIO_CAPABILITY_CHANGED = 106;
    private static final int EVENT_OPPT_DATA_SUB_CHANGED = 107;
    private static final int EVENT_RADIO_AVAILABLE = 108;
    @VisibleForTesting
    public static final int EVENT_PRECISE_CALL_STATE_CHANGED = 109;
    private static final int EVENT_NETWORK_VALIDATION_DONE = 110;
    private static final int EVENT_REMOVE_DEFAULT_NETWORK_CHANGE_CALLBACK = 111;
    private static final int EVENT_MODEM_COMMAND_DONE = 112;
    private static final int EVENT_MODEM_COMMAND_RETRY = 113;
    @VisibleForTesting
    public static final int EVENT_DATA_ENABLED_CHANGED = 114;
    private static final int EVENT_OVERRIDE_DDS_FOR_EMERGENCY = 115;
    private static final int EVENT_REMOVE_DDS_EMERGENCY_OVERRIDE = 116;
    private static final int HAL_COMMAND_UNKNOWN = 0;
    private static final int HAL_COMMAND_ALLOW_DATA = 1;
    private static final int HAL_COMMAND_PREFERRED_DATA = 2;
    private int mHalCommandToUse = 0;
    private RadioConfig mRadioConfig;
    private static final int MAX_LOCAL_LOG_LINES = 30;
    private static final int DEFAULT_VALIDATION_EXPIRATION_TIME = 2000;
    private Boolean mHasRegisteredDefaultNetworkChangeCallback = false;
    private ConnectivityManager mConnectivityManager;
    private final ConnectivityManager.NetworkCallback mDefaultNetworkCallback = new ConnectivityManager.NetworkCallback(){

        @Override
        public void onAvailable(Network network) {
            if (PhoneSwitcher.this.mConnectivityManager.getNetworkCapabilities(network).hasTransport(0)) {
                PhoneSwitcher.this.logDataSwitchEvent(PhoneSwitcher.this.mOpptDataSubId, 2, 0);
            }
            PhoneSwitcher.this.removeDefaultNetworkChangeCallback();
        }
    };
    private final BroadcastReceiver mDefaultDataChangedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Message msg = PhoneSwitcher.this.obtainMessage(101);
            msg.sendToTarget();
        }
    };
    private final IOnSubscriptionsChangedListener mSubscriptionsChangedListener = new IOnSubscriptionsChangedListener.Stub(){

        @Override
        public void onSubscriptionsChanged() {
            Message msg = PhoneSwitcher.this.obtainMessage(102);
            msg.sendToTarget();
        }
    };
    private static final boolean REQUESTS_CHANGED = true;
    private static final boolean REQUESTS_UNCHANGED = false;

    public static PhoneSwitcher getInstance() {
        return sPhoneSwitcher;
    }

    public static PhoneSwitcher make(int maxActivePhones, int numPhones, Context context, SubscriptionController subscriptionController, Looper looper, ITelephonyRegistry tr, CommandsInterface[] cis, Phone[] phones) {
        if (sPhoneSwitcher == null) {
            sPhoneSwitcher = new PhoneSwitcher(maxActivePhones, numPhones, context, subscriptionController, looper, tr, cis, phones);
        }
        return sPhoneSwitcher;
    }

    @VisibleForTesting
    public PhoneSwitcher(int numPhones, Looper looper) {
        super(looper);
        this.mMaxActivePhones = 0;
        this.mSubscriptionController = null;
        this.mCommandsInterfaces = null;
        this.mContext = null;
        this.mPhoneStates = null;
        this.mPhones = null;
        this.mLocalLog = null;
        this.mActivePhoneRegistrants = null;
        this.mNumPhones = numPhones;
        this.mPhoneSubscriptions = new int[numPhones];
        this.mRadioConfig = RadioConfig.getInstance(this.mContext);
        this.mPhoneStateListener = new PhoneStateListener(looper){

            @Override
            public void onPhoneCapabilityChanged(PhoneCapability capability) {
                PhoneSwitcher.this.onPhoneCapabilityChangedInternal(capability);
            }
        };
        this.mValidator = CellularNetworkValidator.getInstance();
    }

    private boolean isPhoneInVoiceCallChanged() {
        int oldPhoneIdInVoiceCall = this.mPhoneIdInVoiceCall;
        this.mPhoneIdInVoiceCall = -1;
        for (Phone phone : this.mPhones) {
            if (!this.isCallActive(phone) && !this.isCallActive(phone.getImsPhone())) continue;
            this.mPhoneIdInVoiceCall = phone.getPhoneId();
            break;
        }
        return this.mPhoneIdInVoiceCall != oldPhoneIdInVoiceCall;
    }

    @VisibleForTesting
    public PhoneSwitcher(int maxActivePhones, int numPhones, Context context, SubscriptionController subscriptionController, Looper looper, ITelephonyRegistry tr, CommandsInterface[] cis, Phone[] phones) {
        super(looper);
        this.mContext = context;
        this.mNumPhones = numPhones;
        this.mPhones = phones;
        this.mPhoneSubscriptions = new int[numPhones];
        this.mMaxActivePhones = maxActivePhones;
        this.mLocalLog = new LocalLog(30);
        this.mSubscriptionController = subscriptionController;
        this.mRadioConfig = RadioConfig.getInstance(this.mContext);
        this.mPhoneStateListener = new PhoneStateListener(looper){

            @Override
            public void onPhoneCapabilityChanged(PhoneCapability capability) {
                PhoneSwitcher.this.onPhoneCapabilityChangedInternal(capability);
            }
        };
        this.mValidator = CellularNetworkValidator.getInstance();
        this.mActivePhoneRegistrants = new RegistrantList();
        this.mPhoneStates = new PhoneState[numPhones];
        for (int i = 0; i < numPhones; ++i) {
            this.mPhoneStates[i] = new PhoneState();
            if (this.mPhones[i] == null) continue;
            this.mPhones[i].registerForEmergencyCallToggle(this, 105, null);
            this.mPhones[i].registerForPreciseCallStateChanged(this, 109, null);
            if (this.mPhones[i].getImsPhone() != null) {
                this.mPhones[i].getImsPhone().registerForPreciseCallStateChanged(this, 109, null);
            }
            this.mPhones[i].getDataEnabledSettings().registerForDataEnabledChanged(this, 114, null);
        }
        this.mCommandsInterfaces = cis;
        if (numPhones > 0) {
            this.mCommandsInterfaces[0].registerForAvailable(this, 108, null);
        }
        try {
            tr.addOnSubscriptionsChangedListener(context.getOpPackageName(), this.mSubscriptionsChangedListener);
        }
        catch (RemoteException i) {
            // empty catch block
        }
        this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.mContext.registerReceiver(this.mDefaultDataChangedReceiver, new IntentFilter("android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED"));
        NetworkCapabilities netCap = new NetworkCapabilities();
        netCap.addTransportType(0);
        netCap.addCapability(0);
        netCap.addCapability(1);
        netCap.addCapability(2);
        netCap.addCapability(3);
        netCap.addCapability(4);
        netCap.addCapability(5);
        netCap.addCapability(7);
        netCap.addCapability(8);
        netCap.addCapability(9);
        netCap.addCapability(10);
        netCap.addCapability(13);
        netCap.addCapability(12);
        netCap.addCapability(23);
        netCap.setNetworkSpecifier(new MatchAllNetworkSpecifier());
        PhoneSwitcherNetworkRequestListener networkFactory = new PhoneSwitcherNetworkRequestListener(looper, context, netCap, this);
        networkFactory.setScoreFilter(101);
        networkFactory.register();
        this.log("PhoneSwitcher started");
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 102: {
                this.onEvaluate(false, "subChanged");
                break;
            }
            case 101: {
                if (!this.onEvaluate(false, "primary data subId changed")) break;
                this.logDataSwitchEvent(this.mOpptDataSubId, 1, 1);
                this.registerDefaultNetworkChangeCallback();
                break;
            }
            case 103: {
                this.onRequestNetwork((NetworkRequest)msg.obj);
                break;
            }
            case 104: {
                this.onReleaseNetwork((NetworkRequest)msg.obj);
                break;
            }
            case 105: {
                boolean isInEcm = this.isInEmergencyCallbackMode();
                if (this.mEmergencyOverride != null) {
                    this.log("Emergency override - ecbm status = " + isInEcm);
                    if (isInEcm) {
                        this.removeMessages(116);
                        this.mEmergencyOverride.mRequiresEcmFinish = true;
                    } else if (this.mEmergencyOverride.mRequiresEcmFinish) {
                        Message msg2 = this.obtainMessage(116);
                        this.sendMessageDelayed(msg2, this.mEmergencyOverride.mGnssOverrideTimeMs);
                    }
                }
                this.onEvaluate(true, "emergencyToggle");
                break;
            }
            case 106: {
                int phoneId = msg.arg1;
                this.sendRilCommands(phoneId);
                break;
            }
            case 107: {
                int subId = msg.arg1;
                boolean needValidation = msg.arg2 == 1;
                ISetOpportunisticDataCallback callback = (ISetOpportunisticDataCallback)msg.obj;
                this.setOpportunisticDataSubscription(subId, needValidation, callback);
                break;
            }
            case 108: {
                this.updateHalCommandToUse();
                this.onEvaluate(false, "EVENT_RADIO_AVAILABLE");
                break;
            }
            case 109: {
                if (!this.isPhoneInVoiceCallChanged()) break;
                if (this.mEmergencyOverride != null && this.mEmergencyOverride.mPendingOriginatingCall) {
                    this.removeMessages(116);
                    if (this.mPhoneIdInVoiceCall == -1) {
                        Message msg2 = this.obtainMessage(116);
                        this.sendMessageDelayed(msg2, this.mEmergencyOverride.mGnssOverrideTimeMs + ECBM_DEFAULT_DATA_SWITCH_BASE_TIME_MS);
                        this.mEmergencyOverride.mPendingOriginatingCall = false;
                    }
                }
            }
            case 114: {
                if (!this.onEvaluate(false, "EVENT_PRECISE_CALL_STATE_CHANGED")) break;
                this.logDataSwitchEvent(this.mOpptDataSubId, 1, 2);
                this.registerDefaultNetworkChangeCallback();
                break;
            }
            case 110: {
                int subId = msg.arg1;
                boolean passed = msg.arg2 == 1;
                this.onValidationDone(subId, passed);
                break;
            }
            case 111: {
                this.removeDefaultNetworkChangeCallback();
                break;
            }
            case 112: {
                boolean commandSuccess;
                AsyncResult ar = (AsyncResult)msg.obj;
                boolean bl = commandSuccess = ar != null && ar.exception == null;
                if (this.mEmergencyOverride != null) {
                    this.log("Emergency override result sent = " + commandSuccess);
                    this.mEmergencyOverride.sendOverrideCompleteCallbackResultAndClear(commandSuccess);
                    break;
                }
                if (commandSuccess) break;
                int phoneId = (Integer)ar.userObj;
                this.log("Modem command failed. with exception " + ar.exception);
                this.sendMessageDelayed(Message.obtain(this, 113, phoneId), 5000L);
                break;
            }
            case 113: {
                int phoneId = (Integer)msg.obj;
                this.log("Resend modem command on phone " + phoneId);
                this.sendRilCommands(phoneId);
                break;
            }
            case 115: {
                EmergencyOverrideRequest req = (EmergencyOverrideRequest)msg.obj;
                if (this.mEmergencyOverride != null) {
                    if (this.mEmergencyOverride.mPhoneId != req.mPhoneId) {
                        this.log("emergency override requested for phone id " + req.mPhoneId + " when there is already an override in place for phone id " + this.mEmergencyOverride.mPhoneId + ". Ignoring.");
                        if (!req.isCallbackAvailable()) break;
                        req.mOverrideCompleteFuture.complete(false);
                        break;
                    }
                    if (this.mEmergencyOverride.isCallbackAvailable()) {
                        this.mEmergencyOverride.mOverrideCompleteFuture.complete(false);
                    }
                    this.mEmergencyOverride = req;
                } else {
                    this.mEmergencyOverride = req;
                }
                this.log("new emergency override - " + this.mEmergencyOverride);
                this.removeMessages(116);
                Message msg2 = this.obtainMessage(116);
                this.sendMessageDelayed(msg2, DEFAULT_DATA_OVERRIDE_TIMEOUT_MS);
                if (this.onEvaluate(false, "emer_override_dds")) break;
                this.mEmergencyOverride.sendOverrideCompleteCallbackResultAndClear(true);
                break;
            }
            case 116: {
                this.log("Emergency override removed - " + this.mEmergencyOverride);
                this.mEmergencyOverride = null;
                this.onEvaluate(false, "emer_rm_override_dds");
            }
        }
    }

    private boolean isEmergency() {
        if (this.isInEmergencyCallbackMode()) {
            return true;
        }
        for (Phone p : this.mPhones) {
            if (p == null) continue;
            if (p.isInEmergencyCall()) {
                return true;
            }
            Phone imsPhone = p.getImsPhone();
            if (imsPhone == null || !imsPhone.isInEmergencyCall()) continue;
            return true;
        }
        return false;
    }

    private boolean isInEmergencyCallbackMode() {
        for (Phone p : this.mPhones) {
            if (p == null) continue;
            if (p.isInEcm()) {
                return true;
            }
            Phone imsPhone = p.getImsPhone();
            if (imsPhone == null || !imsPhone.isInEcm()) continue;
            return true;
        }
        return false;
    }

    private void onRequestNetwork(NetworkRequest networkRequest) {
        DcRequest dcRequest = new DcRequest(networkRequest, this.mContext);
        if (!this.mPrioritizedDcRequests.contains(dcRequest)) {
            this.collectRequestNetworkMetrics(networkRequest);
            this.mPrioritizedDcRequests.add(dcRequest);
            Collections.sort(this.mPrioritizedDcRequests);
            this.onEvaluate(true, "netRequest");
        }
    }

    private void onReleaseNetwork(NetworkRequest networkRequest) {
        DcRequest dcRequest = new DcRequest(networkRequest, this.mContext);
        if (this.mPrioritizedDcRequests.remove(dcRequest)) {
            this.onEvaluate(true, "netReleased");
            this.collectReleaseNetworkMetrics(networkRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDefaultNetworkChangeCallback() {
        Boolean bl = this.mHasRegisteredDefaultNetworkChangeCallback;
        synchronized (bl) {
            if (this.mHasRegisteredDefaultNetworkChangeCallback.booleanValue()) {
                this.mHasRegisteredDefaultNetworkChangeCallback = false;
                this.removeMessages(111);
                this.mConnectivityManager.unregisterNetworkCallback(this.mDefaultNetworkCallback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDefaultNetworkChangeCallback() {
        this.removeDefaultNetworkChangeCallback();
        Boolean bl = this.mHasRegisteredDefaultNetworkChangeCallback;
        synchronized (bl) {
            this.mHasRegisteredDefaultNetworkChangeCallback = true;
            this.mConnectivityManager.registerDefaultNetworkCallback(this.mDefaultNetworkCallback);
            this.sendMessageDelayed(this.obtainMessage(111), 5000L);
        }
    }

    private void collectRequestNetworkMetrics(NetworkRequest networkRequest) {
        if (this.mNumPhones > 1 && networkRequest.networkCapabilities.hasCapability(0)) {
            TelephonyProto.TelephonyEvent.OnDemandDataSwitch onDemandDataSwitch = new TelephonyProto.TelephonyEvent.OnDemandDataSwitch();
            onDemandDataSwitch.apn = 2;
            onDemandDataSwitch.state = 1;
            TelephonyMetrics.getInstance().writeOnDemandDataSwitch(onDemandDataSwitch);
        }
    }

    private void collectReleaseNetworkMetrics(NetworkRequest networkRequest) {
        if (this.mNumPhones > 1 && networkRequest.networkCapabilities.hasCapability(0)) {
            TelephonyProto.TelephonyEvent.OnDemandDataSwitch onDemandDataSwitch = new TelephonyProto.TelephonyEvent.OnDemandDataSwitch();
            onDemandDataSwitch.apn = 2;
            onDemandDataSwitch.state = 2;
            TelephonyMetrics.getInstance().writeOnDemandDataSwitch(onDemandDataSwitch);
        }
    }

    private boolean onEvaluate(boolean requestsChanged, String reason) {
        StringBuilder sb = new StringBuilder(reason);
        if (this.isEmergency()) {
            this.log("onEvaluate for reason " + reason + " aborted due to Emergency");
            return false;
        }
        boolean diffDetected = this.mHalCommandToUse != 2 && requestsChanged;
        int primaryDataSubId = this.mSubscriptionController.getDefaultDataSubId();
        if (primaryDataSubId != this.mPrimaryDataSubId) {
            sb.append(" mPrimaryDataSubId ").append(this.mPrimaryDataSubId).append("->").append(primaryDataSubId);
            this.mPrimaryDataSubId = primaryDataSubId;
        }
        boolean hasAnyActiveSubscription = false;
        for (int i = 0; i < this.mNumPhones; ++i) {
            int sub = this.mSubscriptionController.getSubIdUsingPhoneId(i);
            if (SubscriptionManager.isValidSubscriptionId(sub)) {
                hasAnyActiveSubscription = true;
            }
            if (sub == this.mPhoneSubscriptions[i]) continue;
            sb.append(" phone[").append(i).append("] ").append(this.mPhoneSubscriptions[i]);
            sb.append("->").append(sub);
            this.mPhoneSubscriptions[i] = sub;
            diffDetected = true;
        }
        if (!hasAnyActiveSubscription) {
            this.transitionToEmergencyPhone();
        }
        int oldPreferredDataPhoneId = this.mPreferredDataPhoneId;
        if (hasAnyActiveSubscription) {
            this.updatePreferredDataPhoneId();
        }
        if (oldPreferredDataPhoneId != this.mPreferredDataPhoneId) {
            sb.append(" preferred phoneId ").append(oldPreferredDataPhoneId).append("->").append(this.mPreferredDataPhoneId);
            diffDetected = true;
        }
        if (diffDetected) {
            this.log("evaluating due to " + sb.toString());
            if (this.mHalCommandToUse == 2) {
                for (int phoneId = 0; phoneId < this.mNumPhones; ++phoneId) {
                    this.mPhoneStates[phoneId].active = true;
                }
                this.sendRilCommands(this.mPreferredDataPhoneId);
            } else {
                ArrayList<Integer> newActivePhones = new ArrayList<Integer>();
                if (this.mMaxActivePhones == this.mPhones.length) {
                    for (int i = 0; i < this.mMaxActivePhones; ++i) {
                        newActivePhones.add(this.mPhones[i].getPhoneId());
                    }
                } else {
                    for (DcRequest dcRequest : this.mPrioritizedDcRequests) {
                        int phoneIdForRequest = this.phoneIdForRequest(dcRequest.networkRequest);
                        if (phoneIdForRequest == -1 || newActivePhones.contains(phoneIdForRequest)) continue;
                        newActivePhones.add(phoneIdForRequest);
                        if (newActivePhones.size() < this.mMaxActivePhones) continue;
                        break;
                    }
                    if (newActivePhones.size() < this.mMaxActivePhones && newActivePhones.contains(this.mPreferredDataPhoneId) && SubscriptionManager.isUsableSubIdValue(this.mPreferredDataPhoneId)) {
                        newActivePhones.add(this.mPreferredDataPhoneId);
                    }
                }
                for (int phoneId = 0; phoneId < this.mNumPhones; ++phoneId) {
                    if (newActivePhones.contains(phoneId)) continue;
                    this.deactivate(phoneId);
                }
                Iterator iterator = newActivePhones.iterator();
                while (iterator.hasNext()) {
                    int phoneId = (Integer)iterator.next();
                    this.activate(phoneId);
                }
            }
            this.notifyPreferredDataSubIdChanged();
            this.mActivePhoneRegistrants.notifyRegistrants();
        }
        return diffDetected;
    }

    @UnsupportedAppUsage
    private void activate(int phoneId) {
        this.switchPhone(phoneId, true);
    }

    @UnsupportedAppUsage
    private void deactivate(int phoneId) {
        this.switchPhone(phoneId, false);
    }

    private void switchPhone(int phoneId, boolean active) {
        PhoneState state = this.mPhoneStates[phoneId];
        if (state.active == active) {
            return;
        }
        state.active = active;
        this.log((active ? "activate " : "deactivate ") + phoneId);
        state.lastRequested = System.currentTimeMillis();
        this.sendRilCommands(phoneId);
    }

    public void onRadioCapChanged(int phoneId) {
        this.validatePhoneId(phoneId);
        Message msg = this.obtainMessage(106);
        msg.arg1 = phoneId;
        msg.sendToTarget();
    }

    public void overrideDefaultDataForEmergency(int phoneId, int overrideTimeSec, CompletableFuture<Boolean> dataSwitchResult) {
        this.validatePhoneId(phoneId);
        Message msg = this.obtainMessage(115);
        EmergencyOverrideRequest request = new EmergencyOverrideRequest();
        request.mPhoneId = phoneId;
        request.mGnssOverrideTimeMs = overrideTimeSec * 1000;
        request.mOverrideCompleteFuture = dataSwitchResult;
        msg.obj = request;
        msg.sendToTarget();
    }

    private void sendRilCommands(int phoneId) {
        if (!SubscriptionManager.isValidPhoneId(phoneId) || phoneId >= this.mNumPhones) {
            return;
        }
        Message message = Message.obtain(this, 112, phoneId);
        if (this.mHalCommandToUse == 1 || this.mHalCommandToUse == 0) {
            if (this.mNumPhones > 1) {
                this.mCommandsInterfaces[phoneId].setDataAllowed(this.isPhoneActive(phoneId), message);
            }
        } else if (phoneId == this.mPreferredDataPhoneId) {
            this.mRadioConfig.setPreferredDataModem(this.mPreferredDataPhoneId, message);
        }
    }

    private void onPhoneCapabilityChangedInternal(PhoneCapability capability) {
        int newMaxActivePhones = TelephonyManager.getDefault().getNumberOfModemsWithSimultaneousDataConnections();
        if (this.mMaxActivePhones != newMaxActivePhones) {
            this.mMaxActivePhones = newMaxActivePhones;
            this.log("Max active phones changed to " + this.mMaxActivePhones);
            this.onEvaluate(false, "phoneCfgChanged");
        }
    }

    private int phoneIdForRequest(NetworkRequest netRequest) {
        int preferredDataSubId;
        int subId = this.getSubIdFromNetworkRequest(netRequest);
        if (subId == Integer.MAX_VALUE) {
            return this.mPreferredDataPhoneId;
        }
        if (subId == -1) {
            return -1;
        }
        int n = preferredDataSubId = SubscriptionManager.isValidPhoneId(this.mPreferredDataPhoneId) ? this.mPhoneSubscriptions[this.mPreferredDataPhoneId] : -1;
        if (netRequest.hasCapability(12) && netRequest.hasCapability(13) && subId != preferredDataSubId && subId != this.mValidator.getSubIdInValidation()) {
            return -1;
        }
        int phoneId = -1;
        for (int i = 0; i < this.mNumPhones; ++i) {
            if (this.mPhoneSubscriptions[i] != subId) continue;
            phoneId = i;
            break;
        }
        return phoneId;
    }

    private int getSubIdFromNetworkRequest(NetworkRequest networkRequest) {
        int subId;
        NetworkSpecifier specifier = networkRequest.networkCapabilities.getNetworkSpecifier();
        if (specifier == null) {
            return Integer.MAX_VALUE;
        }
        if (specifier instanceof StringNetworkSpecifier) {
            try {
                subId = Integer.parseInt(((StringNetworkSpecifier)specifier).specifier);
            }
            catch (NumberFormatException e) {
                Rlog.e(LOG_TAG, "NumberFormatException on " + ((StringNetworkSpecifier)specifier).specifier);
                return -1;
            }
        } else {
            return -1;
        }
        return subId;
    }

    private int getSubIdForDefaultNetworkRequests() {
        if (this.mSubscriptionController.isActiveSubId(this.mOpptDataSubId)) {
            return this.mOpptDataSubId;
        }
        return this.mPrimaryDataSubId;
    }

    private void updatePreferredDataPhoneId() {
        Phone voicePhone = this.findPhoneById(this.mPhoneIdInVoiceCall);
        if (this.mEmergencyOverride != null && this.findPhoneById(this.mEmergencyOverride.mPhoneId) != null) {
            this.log("updatePreferredDataPhoneId: preferred data overridden for emergency. phoneId = " + this.mEmergencyOverride.mPhoneId);
            this.mPreferredDataPhoneId = this.mEmergencyOverride.mPhoneId;
        } else if (voicePhone != null && voicePhone.getDataEnabledSettings().isDataEnabled(17)) {
            this.mPreferredDataPhoneId = this.mPhoneIdInVoiceCall;
        } else {
            int subId = this.getSubIdForDefaultNetworkRequests();
            int phoneId = -1;
            if (SubscriptionManager.isUsableSubIdValue(subId)) {
                for (int i = 0; i < this.mNumPhones; ++i) {
                    if (this.mPhoneSubscriptions[i] != subId) continue;
                    phoneId = i;
                    break;
                }
            }
            this.mPreferredDataPhoneId = phoneId;
        }
        this.mPreferredDataSubId = this.mSubscriptionController.getSubIdUsingPhoneId(this.mPreferredDataPhoneId);
    }

    private void transitionToEmergencyPhone() {
        if (this.mPreferredDataPhoneId != 0) {
            this.log("No active subscriptions: resetting preferred phone to 0 for emergency");
            this.mPreferredDataPhoneId = 0;
        }
        if (this.mPreferredDataSubId != -1) {
            this.mPreferredDataSubId = -1;
            this.notifyPreferredDataSubIdChanged();
        }
    }

    private Phone findPhoneById(int phoneId) {
        if (phoneId < 0 || phoneId >= this.mNumPhones) {
            return null;
        }
        return this.mPhones[phoneId];
    }

    public boolean shouldApplyNetworkRequest(NetworkRequest networkRequest, int phoneId) {
        this.validatePhoneId(phoneId);
        if (!this.isPhoneActive(phoneId) || this.mSubscriptionController.getSubIdUsingPhoneId(phoneId) == -1 && !this.isEmergencyNetworkRequest(networkRequest)) {
            return false;
        }
        int phoneIdToHandle = this.phoneIdForRequest(networkRequest);
        return phoneId == phoneIdToHandle;
    }

    boolean isEmergencyNetworkRequest(NetworkRequest networkRequest) {
        return networkRequest.hasCapability(10);
    }

    @VisibleForTesting
    protected boolean isPhoneActive(int phoneId) {
        return this.mPhoneStates[phoneId].active;
    }

    public void registerForActivePhoneSwitch(Handler h, int what, Object o) {
        Registrant r = new Registrant(h, what, o);
        this.mActivePhoneRegistrants.add(r);
        r.notifyRegistrant();
    }

    public void unregisterForActivePhoneSwitch(Handler h) {
        this.mActivePhoneRegistrants.remove(h);
    }

    @VisibleForTesting
    protected void validatePhoneId(int phoneId) {
        if (phoneId < 0 || phoneId >= this.mNumPhones) {
            throw new IllegalArgumentException("Invalid PhoneId");
        }
    }

    private void setOpportunisticDataSubscription(int subId, boolean needValidation, ISetOpportunisticDataCallback callback) {
        int subIdToValidate;
        if (!this.mSubscriptionController.isActiveSubId(subId) && subId != Integer.MAX_VALUE) {
            this.log("Can't switch data to inactive subId " + subId);
            this.sendSetOpptCallbackHelper(callback, 2);
            return;
        }
        int n = subIdToValidate = subId == Integer.MAX_VALUE ? this.mPrimaryDataSubId : subId;
        if (this.mValidator.isValidating() && (!needValidation || subIdToValidate != this.mValidator.getSubIdInValidation())) {
            this.mValidator.stopValidation();
        }
        if (subId == this.mOpptDataSubId) {
            this.sendSetOpptCallbackHelper(callback, 0);
            return;
        }
        if (this.mValidator.isValidationFeatureSupported() && needValidation) {
            this.logDataSwitchEvent(subId, 1, 3);
            this.registerDefaultNetworkChangeCallback();
            this.mSetOpptSubCallback = callback;
            this.mValidator.validate(subIdToValidate, 2000, false, this.mValidationCallback);
        } else {
            this.setOpportunisticSubscriptionInternal(subId);
            this.sendSetOpptCallbackHelper(callback, 0);
        }
    }

    private void sendSetOpptCallbackHelper(ISetOpportunisticDataCallback callback, int result) {
        if (callback == null) {
            return;
        }
        try {
            callback.onComplete(result);
        }
        catch (RemoteException exception) {
            this.log("RemoteException " + exception);
        }
    }

    private void setOpportunisticSubscriptionInternal(int subId) {
        if (this.mOpptDataSubId != subId) {
            this.mOpptDataSubId = subId;
            if (this.onEvaluate(false, "oppt data subId changed")) {
                this.logDataSwitchEvent(this.mOpptDataSubId, 1, 3);
                this.registerDefaultNetworkChangeCallback();
            }
        }
    }

    private void onValidationDone(int subId, boolean passed) {
        int resultForCallBack;
        this.log("onValidationDone: " + (passed ? "passed" : "failed") + " on subId " + subId);
        if (!this.mSubscriptionController.isActiveSubId(subId)) {
            this.log("onValidationDone: subId " + subId + " is no longer active");
            resultForCallBack = 2;
        } else if (!passed) {
            resultForCallBack = 1;
        } else {
            if (this.mSubscriptionController.isOpportunistic(subId)) {
                this.setOpportunisticSubscriptionInternal(subId);
            } else {
                this.setOpportunisticSubscriptionInternal(Integer.MAX_VALUE);
            }
            resultForCallBack = 0;
        }
        this.sendSetOpptCallbackHelper(this.mSetOpptSubCallback, resultForCallBack);
        this.mSetOpptSubCallback = null;
    }

    public void trySetOpportunisticDataSubscription(int subId, boolean needValidation, ISetOpportunisticDataCallback callback) {
        this.log("Try set opportunistic data subscription to subId " + subId + (needValidation ? " with " : " without ") + "validation");
        this.obtainMessage(107, subId, needValidation ? 1 : 0, callback).sendToTarget();
    }

    private boolean isCallActive(Phone phone) {
        if (phone == null) {
            return false;
        }
        return phone.getForegroundCall().getState() == Call.State.ACTIVE || phone.getForegroundCall().getState() == Call.State.ALERTING;
    }

    private void updateHalCommandToUse() {
        this.mHalCommandToUse = this.mRadioConfig.isSetPreferredDataCommandSupported() ? 2 : 1;
    }

    public int getOpportunisticDataSubscriptionId() {
        return this.mOpptDataSubId;
    }

    public int getPreferredDataPhoneId() {
        return this.mPreferredDataPhoneId;
    }

    @UnsupportedAppUsage
    private void log(String l) {
        Rlog.d(LOG_TAG, l);
        this.mLocalLog.log(l);
    }

    private void logDataSwitchEvent(int subId, int state, int reason) {
        subId = subId == Integer.MAX_VALUE ? this.mPrimaryDataSubId : subId;
        TelephonyProto.TelephonyEvent.DataSwitch dataSwitch = new TelephonyProto.TelephonyEvent.DataSwitch();
        dataSwitch.state = state;
        dataSwitch.reason = reason;
        TelephonyMetrics.getInstance().writeDataSwitch(subId, dataSwitch);
    }

    private void notifyPreferredDataSubIdChanged() {
        ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        try {
            this.log("notifyPreferredDataSubIdChanged to " + this.mPreferredDataSubId);
            tr.notifyActiveDataSubIdChanged(this.mPreferredDataSubId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println("PhoneSwitcher:");
        Calendar c = Calendar.getInstance();
        for (int i = 0; i < this.mNumPhones; ++i) {
            PhoneState ps = this.mPhoneStates[i];
            c.setTimeInMillis(ps.lastRequested);
            pw.println("PhoneId(" + i + ") active=" + ps.active + ", lastRequest=" + (ps.lastRequested == 0L ? "never" : String.format("%tm-%td %tH:%tM:%tS.%tL", c, c, c, c, c, c)));
        }
        pw.increaseIndent();
        this.mLocalLog.dump(fd, pw, args);
        pw.decreaseIndent();
    }

    private static class PhoneState {
        public volatile boolean active = false;
        public long lastRequested = 0L;

        private PhoneState() {
        }
    }

    private static class PhoneSwitcherNetworkRequestListener
    extends NetworkFactory {
        private final PhoneSwitcher mPhoneSwitcher;

        public PhoneSwitcherNetworkRequestListener(Looper l, Context c, NetworkCapabilities nc, PhoneSwitcher ps) {
            super(l, c, "PhoneSwitcherNetworkRequstListener", nc);
            this.mPhoneSwitcher = ps;
        }

        @Override
        protected void needNetworkFor(NetworkRequest networkRequest, int score) {
            Message msg = this.mPhoneSwitcher.obtainMessage(103);
            msg.obj = networkRequest;
            msg.sendToTarget();
        }

        @Override
        protected void releaseNetworkFor(NetworkRequest networkRequest) {
            Message msg = this.mPhoneSwitcher.obtainMessage(104);
            msg.obj = networkRequest;
            msg.sendToTarget();
        }
    }

    private static final class EmergencyOverrideRequest {
        int mPhoneId = -1;
        int mGnssOverrideTimeMs = -1;
        CompletableFuture<Boolean> mOverrideCompleteFuture;
        boolean mRequiresEcmFinish = false;
        boolean mPendingOriginatingCall = true;

        private EmergencyOverrideRequest() {
        }

        boolean isCallbackAvailable() {
            return this.mOverrideCompleteFuture != null;
        }

        void sendOverrideCompleteCallbackResultAndClear(boolean result) {
            if (this.isCallbackAvailable()) {
                this.mOverrideCompleteFuture.complete(result);
                this.mOverrideCompleteFuture = null;
            }
        }

        public String toString() {
            return String.format("EmergencyOverrideRequest: [phoneId= %d, overrideMs= %d, hasCallback= %b, ecmFinishStatus= %b]", this.mPhoneId, this.mGnssOverrideTimeMs, this.isCallbackAvailable(), this.mRequiresEcmFinish);
        }
    }
}

