/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import android.provider.Settings;
import com.android.internal.annotations.VisibleForTesting;
import java.util.HashMap;

public class RadioBugDetector {
    private static final int RADIO_BUG_NONE = 0;
    private static final int RADIO_BUG_REPETITIVE_WAKELOCK_TIMEOUT_ERROR = 1;
    @VisibleForTesting
    protected static final int RADIO_BUG_REPETITIVE_SYSTEM_ERROR = 2;
    private static final int DEFAULT_WAKELOCK_TIMEOUT_COUNT_THRESHOLD = 10;
    private static final int DEFAULT_SYSTEM_ERROR_COUNT_THRESHOLD = 100;
    private Context mContext;
    private int mContinuousWakelockTimoutCount = 0;
    private int mRadioBugStatus = 0;
    private int mSlotId;
    private int mWakelockTimeoutThreshold = 0;
    private int mSystemErrorThreshold = 0;
    private HashMap<Integer, Integer> mSysErrRecord = new HashMap();

    public RadioBugDetector(Context context, int slotId) {
        this.mContext = context;
        this.mSlotId = slotId;
        this.init();
    }

    private void init() {
        this.mWakelockTimeoutThreshold = Settings.Global.getInt(this.mContext.getContentResolver(), "radio_bug_wakelock_timeout_count_threshold", 10);
        this.mSystemErrorThreshold = Settings.Global.getInt(this.mContext.getContentResolver(), "radio_bug_system_error_count_threshold", 100);
    }

    public synchronized void detectRadioBug(int requestType, int error) {
        this.mContinuousWakelockTimoutCount = 0;
        if (error == 39) {
            int errorCount = this.mSysErrRecord.getOrDefault(requestType, 0);
            this.mSysErrRecord.put(requestType, ++errorCount);
            this.broadcastBug(true);
        } else {
            this.mSysErrRecord.remove(requestType);
            if (!this.isFrequentSystemError()) {
                this.mRadioBugStatus = 0;
            }
        }
    }

    public void processWakelockTimeout() {
        ++this.mContinuousWakelockTimoutCount;
        this.broadcastBug(false);
    }

    private synchronized void broadcastBug(boolean isSystemError) {
        if (isSystemError ? !this.isFrequentSystemError() : this.mContinuousWakelockTimoutCount < this.mWakelockTimeoutThreshold) {
            return;
        }
        if (this.mRadioBugStatus == 0) {
            this.mRadioBugStatus = isSystemError ? 2 : 1;
            Intent intent = new Intent("com.android.internal.telephony.ACTION_REPORT_RADIO_BUG");
            intent.addFlags(0x1000000);
            intent.putExtra("slotId", this.mSlotId);
            intent.putExtra("radioBugType", this.mRadioBugStatus);
            this.mContext.sendBroadcast(intent, "android.permission.READ_PRIVILEGED_PHONE_STATE");
        }
    }

    private boolean isFrequentSystemError() {
        int countForError = 0;
        boolean error = false;
        for (int count : this.mSysErrRecord.values()) {
            if ((countForError += count) < this.mSystemErrorThreshold) continue;
            error = true;
            break;
        }
        return error;
    }

    @VisibleForTesting
    public int getRadioBugStatus() {
        return this.mRadioBugStatus;
    }

    @VisibleForTesting
    public int getWakelockTimeoutThreshold() {
        return this.mWakelockTimeoutThreshold;
    }

    @VisibleForTesting
    public int getSystemErrorThreshold() {
        return this.mSystemErrorThreshold;
    }

    @VisibleForTesting
    public int getWakelockTimoutCount() {
        return this.mContinuousWakelockTimoutCount;
    }
}

