/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.hardware.radio.V1_0.RadioResponseInfo;
import android.hardware.radio.config.V1_0.IRadioConfig;
import android.hardware.radio.config.V1_0.SimSlotStatus;
import android.hardware.radio.config.V1_1.ModemsConfig;
import android.net.ConnectivityManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.IHwBinder;
import android.os.Message;
import android.os.Registrant;
import android.os.RemoteException;
import android.os.WorkSource;
import android.telephony.Rlog;
import android.util.SparseArray;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.HalVersion;
import com.android.internal.telephony.RILRequest;
import com.android.internal.telephony.RadioConfigIndication;
import com.android.internal.telephony.RadioConfigResponse;
import com.android.internal.telephony.uicc.IccSlotStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;

public class RadioConfig
extends Handler {
    private static final String TAG = "RadioConfig";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final int EVENT_SERVICE_DEAD = 1;
    private static final HalVersion RADIO_CONFIG_HAL_VERSION_UNKNOWN = new HalVersion(-1, -1);
    private static final HalVersion RADIO_CONFIG_HAL_VERSION_1_0 = new HalVersion(1, 0);
    private static final HalVersion RADIO_CONFIG_HAL_VERSION_1_1 = new HalVersion(1, 1);
    private final boolean mIsMobileNetworkSupported;
    private volatile IRadioConfig mRadioConfigProxy = null;
    private HalVersion mRadioConfigVersion = RADIO_CONFIG_HAL_VERSION_UNKNOWN;
    private final ServiceDeathRecipient mServiceDeathRecipient;
    private final AtomicLong mRadioConfigProxyCookie = new AtomicLong(0L);
    private final RadioConfigResponse mRadioConfigResponse;
    private final RadioConfigIndication mRadioConfigIndication;
    private final SparseArray<RILRequest> mRequestList = new SparseArray();
    private final WorkSource mDefaultWorkSource;
    private static RadioConfig sRadioConfig;
    protected Registrant mSimSlotStatusRegistrant;

    private RadioConfig(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        this.mIsMobileNetworkSupported = cm.isNetworkSupported(0);
        this.mRadioConfigResponse = new RadioConfigResponse(this);
        this.mRadioConfigIndication = new RadioConfigIndication(this);
        this.mServiceDeathRecipient = new ServiceDeathRecipient();
        this.mDefaultWorkSource = new WorkSource(context.getApplicationInfo().uid, context.getPackageName());
    }

    public static RadioConfig getInstance(Context context) {
        if (sRadioConfig == null) {
            sRadioConfig = new RadioConfig(context);
        }
        return sRadioConfig;
    }

    @Override
    public void handleMessage(Message message) {
        switch (message.what) {
            case 1: {
                RadioConfig.logd("handleMessage: EVENT_SERVICE_DEAD cookie = " + message.obj + " mRadioConfigProxyCookie = " + this.mRadioConfigProxyCookie.get());
                if (((Long)message.obj).longValue() != this.mRadioConfigProxyCookie.get()) break;
                this.resetProxyAndRequestList("EVENT_SERVICE_DEAD", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRequestList(int error, boolean loggable) {
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            int count = this.mRequestList.size();
            if (loggable) {
                RadioConfig.logd("clearRequestList: mRequestList=" + count);
            }
            for (int i = 0; i < count; ++i) {
                RILRequest rr = this.mRequestList.valueAt(i);
                if (loggable) {
                    RadioConfig.logd(i + ": [" + rr.mSerial + "] " + RadioConfig.requestToString(rr.mRequest));
                }
                rr.onError(error, null);
                rr.release();
            }
            this.mRequestList.clear();
        }
    }

    private void resetProxyAndRequestList(String caller, Exception e) {
        RadioConfig.loge(caller + ": " + e);
        this.mRadioConfigProxy = null;
        this.mRadioConfigProxyCookie.incrementAndGet();
        RILRequest.resetSerial();
        this.clearRequestList(1, false);
        this.getRadioConfigProxy(null);
    }

    public IRadioConfig getRadioConfigProxy(Message result) {
        if (!this.mIsMobileNetworkSupported) {
            if (result != null) {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(1));
                result.sendToTarget();
            }
            return null;
        }
        if (this.mRadioConfigProxy != null) {
            return this.mRadioConfigProxy;
        }
        this.updateRadioConfigProxy();
        if (this.mRadioConfigProxy == null && result != null) {
            AsyncResult.forMessage(result, null, CommandException.fromRilErrno(1));
            result.sendToTarget();
        }
        return this.mRadioConfigProxy;
    }

    private void updateRadioConfigProxy() {
        try {
            try {
                this.mRadioConfigProxy = android.hardware.radio.config.V1_1.IRadioConfig.getService(true);
                this.mRadioConfigVersion = RADIO_CONFIG_HAL_VERSION_1_1;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (this.mRadioConfigProxy == null) {
                try {
                    this.mRadioConfigProxy = IRadioConfig.getService(true);
                    this.mRadioConfigVersion = RADIO_CONFIG_HAL_VERSION_1_0;
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            if (this.mRadioConfigProxy == null) {
                RadioConfig.loge("getRadioConfigProxy: mRadioConfigProxy == null");
                return;
            }
            this.mRadioConfigProxy.linkToDeath(this.mServiceDeathRecipient, this.mRadioConfigProxyCookie.incrementAndGet());
            this.mRadioConfigProxy.setResponseFunctions(this.mRadioConfigResponse, this.mRadioConfigIndication);
        }
        catch (RemoteException | RuntimeException e) {
            this.mRadioConfigProxy = null;
            RadioConfig.loge("getRadioConfigProxy: RadioConfigProxy setResponseFunctions: " + e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RILRequest obtainRequest(int request, Message result, WorkSource workSource) {
        RILRequest rr = RILRequest.obtain(request, result, workSource);
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            this.mRequestList.append(rr.mSerial, rr);
        }
        return rr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RILRequest findAndRemoveRequestFromList(int serial) {
        RILRequest rr;
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            rr = this.mRequestList.get(serial);
            if (rr != null) {
                this.mRequestList.remove(serial);
            }
        }
        return rr;
    }

    public RILRequest processResponse(RadioResponseInfo responseInfo) {
        RILRequest rr;
        int serial = responseInfo.serial;
        int error = responseInfo.error;
        int type = responseInfo.type;
        if (type != 0) {
            RadioConfig.loge("processResponse: Unexpected response type " + type);
        }
        if ((rr = this.findAndRemoveRequestFromList(serial)) == null) {
            RadioConfig.loge("processResponse: Unexpected response! serial: " + serial + " error: " + error);
            return null;
        }
        return rr;
    }

    public void getSimSlotsStatus(Message result) {
        IRadioConfig radioConfigProxy = this.getRadioConfigProxy(result);
        if (radioConfigProxy != null) {
            RILRequest rr = this.obtainRequest(200, result, this.mDefaultWorkSource);
            RadioConfig.logd(rr.serialString() + "> " + RadioConfig.requestToString(rr.mRequest));
            try {
                radioConfigProxy.getSimSlotsStatus(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.resetProxyAndRequestList("getSimSlotsStatus", e);
            }
        }
    }

    public void setPreferredDataModem(int modemId, Message result) {
        if (!this.isSetPreferredDataCommandSupported()) {
            if (result != null) {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(6));
                result.sendToTarget();
            }
            return;
        }
        RILRequest rr = this.obtainRequest(204, result, this.mDefaultWorkSource);
        RadioConfig.logd(rr.serialString() + "> " + RadioConfig.requestToString(rr.mRequest));
        try {
            ((android.hardware.radio.config.V1_1.IRadioConfig)this.mRadioConfigProxy).setPreferredDataModem(rr.mSerial, (byte)modemId);
        }
        catch (RemoteException | RuntimeException e) {
            this.resetProxyAndRequestList("setPreferredDataModem", e);
        }
    }

    public void getPhoneCapability(Message result) {
        IRadioConfig radioConfigProxy = this.getRadioConfigProxy(null);
        if (radioConfigProxy == null || this.mRadioConfigVersion.less(RADIO_CONFIG_HAL_VERSION_1_1)) {
            if (result != null) {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(6));
                result.sendToTarget();
            }
            return;
        }
        RILRequest rr = this.obtainRequest(206, result, this.mDefaultWorkSource);
        RadioConfig.logd(rr.serialString() + "> " + RadioConfig.requestToString(rr.mRequest));
        try {
            ((android.hardware.radio.config.V1_1.IRadioConfig)this.mRadioConfigProxy).getPhoneCapability(rr.mSerial);
        }
        catch (RemoteException | RuntimeException e) {
            this.resetProxyAndRequestList("getPhoneCapability", e);
        }
    }

    public boolean isSetPreferredDataCommandSupported() {
        IRadioConfig radioConfigProxy = this.getRadioConfigProxy(null);
        return radioConfigProxy != null && this.mRadioConfigVersion.greaterOrEqual(RADIO_CONFIG_HAL_VERSION_1_1);
    }

    public void setSimSlotsMapping(int[] physicalSlots, Message result) {
        IRadioConfig radioConfigProxy = this.getRadioConfigProxy(result);
        if (radioConfigProxy != null) {
            RILRequest rr = this.obtainRequest(201, result, this.mDefaultWorkSource);
            RadioConfig.logd(rr.serialString() + "> " + RadioConfig.requestToString(rr.mRequest) + " " + Arrays.toString(physicalSlots));
            try {
                radioConfigProxy.setSimSlotsMapping(rr.mSerial, RadioConfig.primitiveArrayToArrayList(physicalSlots));
            }
            catch (RemoteException | RuntimeException e) {
                this.resetProxyAndRequestList("setSimSlotsMapping", e);
            }
        }
    }

    private static ArrayList<Integer> primitiveArrayToArrayList(int[] arr) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(arr.length);
        for (int i : arr) {
            arrayList.add(i);
        }
        return arrayList;
    }

    static String requestToString(int request) {
        switch (request) {
            case 206: {
                return "GET_PHONE_CAPABILITY";
            }
            case 200: {
                return "GET_SLOT_STATUS";
            }
            case 201: {
                return "SET_LOGICAL_TO_PHYSICAL_SLOT_MAPPING";
            }
            case 204: {
                return "SET_PREFERRED_DATA_MODEM";
            }
            case 207: {
                return "SWITCH_DUAL_SIM_CONFIG";
            }
        }
        return "<unknown request " + request + ">";
    }

    public void setModemsConfig(int numOfLiveModems, Message result) {
        IRadioConfig radioConfigProxy = this.getRadioConfigProxy(result);
        if (radioConfigProxy != null && this.mRadioConfigVersion.greaterOrEqual(RADIO_CONFIG_HAL_VERSION_1_1)) {
            android.hardware.radio.config.V1_1.IRadioConfig radioConfigProxy11 = (android.hardware.radio.config.V1_1.IRadioConfig)radioConfigProxy;
            RILRequest rr = this.obtainRequest(207, result, this.mDefaultWorkSource);
            RadioConfig.logd(rr.serialString() + "> " + RadioConfig.requestToString(rr.mRequest) + ", numOfLiveModems = " + numOfLiveModems);
            try {
                ModemsConfig modemsConfig = new ModemsConfig();
                modemsConfig.numOfLiveModems = (byte)numOfLiveModems;
                radioConfigProxy11.setModemsConfig(rr.mSerial, modemsConfig);
            }
            catch (RemoteException | RuntimeException e) {
                this.resetProxyAndRequestList("setModemsConfig", e);
            }
        }
    }

    public void registerForSimSlotStatusChanged(Handler h, int what, Object obj) {
        this.mSimSlotStatusRegistrant = new Registrant(h, what, obj);
    }

    public void unregisterForSimSlotStatusChanged(Handler h) {
        if (this.mSimSlotStatusRegistrant != null && this.mSimSlotStatusRegistrant.getHandler() == h) {
            this.mSimSlotStatusRegistrant.clear();
            this.mSimSlotStatusRegistrant = null;
        }
    }

    static ArrayList<IccSlotStatus> convertHalSlotStatus(ArrayList<SimSlotStatus> halSlotStatusList) {
        ArrayList<IccSlotStatus> response = new ArrayList<IccSlotStatus>(halSlotStatusList.size());
        for (SimSlotStatus slotStatus : halSlotStatusList) {
            IccSlotStatus iccSlotStatus = new IccSlotStatus();
            iccSlotStatus.setCardState(slotStatus.cardState);
            iccSlotStatus.setSlotState(slotStatus.slotState);
            iccSlotStatus.logicalSlotIndex = slotStatus.logicalSlotId;
            iccSlotStatus.atr = slotStatus.atr;
            iccSlotStatus.iccid = slotStatus.iccid;
            response.add(iccSlotStatus);
        }
        return response;
    }

    static ArrayList<IccSlotStatus> convertHalSlotStatus_1_2(ArrayList<android.hardware.radio.config.V1_2.SimSlotStatus> halSlotStatusList) {
        ArrayList<IccSlotStatus> response = new ArrayList<IccSlotStatus>(halSlotStatusList.size());
        for (android.hardware.radio.config.V1_2.SimSlotStatus slotStatus : halSlotStatusList) {
            IccSlotStatus iccSlotStatus = new IccSlotStatus();
            iccSlotStatus.setCardState(slotStatus.base.cardState);
            iccSlotStatus.setSlotState(slotStatus.base.slotState);
            iccSlotStatus.logicalSlotIndex = slotStatus.base.logicalSlotId;
            iccSlotStatus.atr = slotStatus.base.atr;
            iccSlotStatus.iccid = slotStatus.base.iccid;
            iccSlotStatus.eid = slotStatus.eid;
            response.add(iccSlotStatus);
        }
        return response;
    }

    private static void logd(String log) {
        Rlog.d(TAG, log);
    }

    private static void loge(String log) {
        Rlog.e(TAG, log);
    }

    final class ServiceDeathRecipient
    implements IHwBinder.DeathRecipient {
        ServiceDeathRecipient() {
        }

        @Override
        public void serviceDied(long cookie) {
            RadioConfig.logd("serviceDied");
            RadioConfig.this.sendMessage(RadioConfig.this.obtainMessage(1, cookie));
        }
    }
}

