/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.hardware.radio.V1_0.RadioResponseInfo;
import android.hardware.radio.config.V1_1.ModemInfo;
import android.hardware.radio.config.V1_1.ModemsConfig;
import android.hardware.radio.config.V1_2.IRadioConfigResponse;
import android.hardware.radio.config.V1_2.SimSlotStatus;
import android.telephony.PhoneCapability;
import android.telephony.Rlog;
import com.android.internal.telephony.RILRequest;
import com.android.internal.telephony.RadioConfig;
import com.android.internal.telephony.RadioResponse;
import com.android.internal.telephony.uicc.IccSlotStatus;
import java.util.ArrayList;

public class RadioConfigResponse
extends IRadioConfigResponse.Stub {
    private static final String TAG = "RadioConfigResponse";
    private final RadioConfig mRadioConfig;

    public RadioConfigResponse(RadioConfig radioConfig) {
        this.mRadioConfig = radioConfig;
    }

    @Override
    public void getSimSlotsStatusResponse(RadioResponseInfo responseInfo, ArrayList<android.hardware.radio.config.V1_0.SimSlotStatus> slotStatus) {
        RILRequest rr = this.mRadioConfig.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<IccSlotStatus> ret = RadioConfig.convertHalSlotStatus(slotStatus);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
                Rlog.d(TAG, rr.serialString() + "< " + RadioConfig.requestToString(rr.mRequest) + " " + ret.toString());
            } else {
                rr.onError(responseInfo.error, ret);
                Rlog.e(TAG, rr.serialString() + "< " + RadioConfig.requestToString(rr.mRequest) + " error " + responseInfo.error);
            }
        } else {
            Rlog.e(TAG, "getSimSlotsStatusResponse: Error " + responseInfo.toString());
        }
    }

    @Override
    public void getSimSlotsStatusResponse_1_2(RadioResponseInfo responseInfo, ArrayList<SimSlotStatus> slotStatus) {
        RILRequest rr = this.mRadioConfig.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<IccSlotStatus> ret = RadioConfig.convertHalSlotStatus_1_2(slotStatus);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
                Rlog.d(TAG, rr.serialString() + "< " + RadioConfig.requestToString(rr.mRequest) + " " + ret.toString());
            } else {
                rr.onError(responseInfo.error, ret);
                Rlog.e(TAG, rr.serialString() + "< " + RadioConfig.requestToString(rr.mRequest) + " error " + responseInfo.error);
            }
        } else {
            Rlog.e(TAG, "getSimSlotsStatusResponse_1_2: Error " + responseInfo.toString());
        }
    }

    @Override
    public void setSimSlotsMappingResponse(RadioResponseInfo responseInfo) {
        RILRequest rr = this.mRadioConfig.processResponse(responseInfo);
        if (rr != null) {
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, null);
                Rlog.d(TAG, rr.serialString() + "< " + RadioConfig.requestToString(rr.mRequest));
            } else {
                rr.onError(responseInfo.error, null);
                Rlog.e(TAG, rr.serialString() + "< " + RadioConfig.requestToString(rr.mRequest) + " error " + responseInfo.error);
            }
        } else {
            Rlog.e(TAG, "setSimSlotsMappingResponse: Error " + responseInfo.toString());
        }
    }

    private PhoneCapability convertHalPhoneCapability(android.hardware.radio.config.V1_1.PhoneCapability phoneCapability) {
        int maxActiveVoiceCalls = 0;
        byte maxActiveData = phoneCapability.maxActiveData;
        int max5G = 0;
        boolean validationBeforeSwitchSupported = phoneCapability.isInternetLingeringSupported;
        ArrayList<android.telephony.ModemInfo> logicalModemList = new ArrayList<android.telephony.ModemInfo>();
        for (ModemInfo modemInfo : phoneCapability.logicalModemList) {
            logicalModemList.add(new android.telephony.ModemInfo(modemInfo.modemId));
        }
        return new PhoneCapability(maxActiveVoiceCalls, maxActiveData, max5G, logicalModemList, validationBeforeSwitchSupported);
    }

    @Override
    public void getPhoneCapabilityResponse(RadioResponseInfo responseInfo, android.hardware.radio.config.V1_1.PhoneCapability phoneCapability) {
        RILRequest rr = this.mRadioConfig.processResponse(responseInfo);
        if (rr != null) {
            PhoneCapability ret = this.convertHalPhoneCapability(phoneCapability);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
                Rlog.d(TAG, rr.serialString() + "< " + RadioConfig.requestToString(rr.mRequest) + " " + ret.toString());
            } else {
                rr.onError(responseInfo.error, ret);
                Rlog.e(TAG, rr.serialString() + "< " + RadioConfig.requestToString(rr.mRequest) + " error " + responseInfo.error);
            }
        } else {
            Rlog.e(TAG, "getPhoneCapabilityResponse: Error " + responseInfo.toString());
        }
    }

    @Override
    public void setPreferredDataModemResponse(RadioResponseInfo responseInfo) {
        RILRequest rr = this.mRadioConfig.processResponse(responseInfo);
        if (rr != null) {
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, null);
                Rlog.d(TAG, rr.serialString() + "< " + RadioConfig.requestToString(rr.mRequest));
            } else {
                rr.onError(responseInfo.error, null);
                Rlog.e(TAG, rr.serialString() + "< " + RadioConfig.requestToString(rr.mRequest) + " error " + responseInfo.error);
            }
        } else {
            Rlog.e(TAG, "setPreferredDataModemResponse: Error " + responseInfo.toString());
        }
    }

    @Override
    public void setModemsConfigResponse(RadioResponseInfo responseInfo) {
        RILRequest rr = this.mRadioConfig.processResponse(responseInfo);
        if (rr != null) {
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, rr.mRequest);
                Rlog.d(TAG, rr.serialString() + "< " + RadioConfig.requestToString(rr.mRequest));
            } else {
                rr.onError(responseInfo.error, null);
                Rlog.e(TAG, rr.serialString() + "< " + RadioConfig.requestToString(rr.mRequest) + " error " + responseInfo.error);
            }
        } else {
            Rlog.e(TAG, "setModemsConfigResponse: Error " + responseInfo.toString());
        }
    }

    @Override
    public void getModemsConfigResponse(RadioResponseInfo responseInfo, ModemsConfig modemsConfig) {
        RILRequest rr = this.mRadioConfig.processResponse(responseInfo);
        if (rr != null) {
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, modemsConfig);
                Rlog.d(TAG, rr.serialString() + "< " + RadioConfig.requestToString(rr.mRequest));
            } else {
                rr.onError(responseInfo.error, modemsConfig);
                Rlog.e(TAG, rr.serialString() + "< " + RadioConfig.requestToString(rr.mRequest) + " error " + responseInfo.error);
            }
        } else {
            Rlog.e(TAG, "getModemsConfigResponse: Error " + responseInfo.toString());
        }
    }
}

