/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PersistableBundle;
import android.os.UserHandle;
import android.telephony.CarrierConfigManager;
import android.telephony.NetworkRegistrationInfo;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.telephony.Phone;
import java.util.Arrays;

public class RatRatcheter {
    private static final String LOG_TAG = "RilRatcheter";
    private final SparseArray<SparseIntArray> mRatFamilyMap = new SparseArray();
    private final Phone mPhone;
    private boolean mVoiceRatchetEnabled = true;
    private boolean mDataRatchetEnabled = true;
    private BroadcastReceiver mConfigChangedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.telephony.action.CARRIER_CONFIG_CHANGED".equals(action)) {
                RatRatcheter.this.resetRatFamilyMap();
            }
        }
    };

    public static boolean updateBandwidths(int[] bandwidths, ServiceState serviceState) {
        if (bandwidths == null) {
            return false;
        }
        int ssAggregateBandwidth = Arrays.stream(serviceState.getCellBandwidths()).sum();
        int newAggregateBandwidth = Arrays.stream(bandwidths).sum();
        if (newAggregateBandwidth > ssAggregateBandwidth) {
            serviceState.setCellBandwidths(bandwidths);
            return true;
        }
        return false;
    }

    public RatRatcheter(Phone phone) {
        this.mPhone = phone;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        phone.getContext().registerReceiverAsUser(this.mConfigChangedReceiver, UserHandle.ALL, intentFilter, null, null);
        this.resetRatFamilyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int ratchetRat(int oldNetworkType, int newNetworkType) {
        int oldRat = ServiceState.networkTypeToRilRadioTechnology(oldNetworkType);
        int newRat = ServiceState.networkTypeToRilRadioTechnology(newNetworkType);
        SparseArray<SparseIntArray> sparseArray = this.mRatFamilyMap;
        synchronized (sparseArray) {
            int newRatRank;
            SparseIntArray oldFamily = this.mRatFamilyMap.get(oldRat);
            if (oldFamily == null) {
                return newNetworkType;
            }
            SparseIntArray newFamily = this.mRatFamilyMap.get(newRat);
            if (newFamily != oldFamily) {
                return newNetworkType;
            }
            int oldRatRank = newFamily.get(oldRat, -1);
            int n = oldRatRank > (newRatRank = newFamily.get(newRat, -1)) ? oldRat : newRat;
            return ServiceState.rilRadioTechnologyToNetworkType(n);
        }
    }

    public void ratchet(ServiceState oldSS, ServiceState newSS, boolean locationChange) {
        if (!locationChange && this.isSameRatFamily(oldSS, newSS)) {
            RatRatcheter.updateBandwidths(oldSS.getCellBandwidths(), newSS);
        }
        if (locationChange) {
            this.mVoiceRatchetEnabled = false;
            this.mDataRatchetEnabled = false;
            return;
        }
        boolean newUsingCA = oldSS.isUsingCarrierAggregation() || newSS.isUsingCarrierAggregation() || newSS.getCellBandwidths().length > 1;
        NetworkRegistrationInfo oldCsNri = oldSS.getNetworkRegistrationInfo(1, 1);
        NetworkRegistrationInfo newCsNri = newSS.getNetworkRegistrationInfo(1, 1);
        if (this.mVoiceRatchetEnabled) {
            int newPsNetworkType = this.ratchetRat(oldCsNri.getAccessNetworkTechnology(), newCsNri.getAccessNetworkTechnology());
            newCsNri.setAccessNetworkTechnology(newPsNetworkType);
            newSS.addNetworkRegistrationInfo(newCsNri);
        } else if (oldCsNri.getAccessNetworkTechnology() != oldCsNri.getAccessNetworkTechnology()) {
            this.mVoiceRatchetEnabled = true;
        }
        NetworkRegistrationInfo oldPsNri = oldSS.getNetworkRegistrationInfo(2, 1);
        NetworkRegistrationInfo newPsNri = newSS.getNetworkRegistrationInfo(2, 1);
        if (this.mDataRatchetEnabled) {
            int newPsNetworkType = this.ratchetRat(oldPsNri.getAccessNetworkTechnology(), newPsNri.getAccessNetworkTechnology());
            newPsNri.setAccessNetworkTechnology(newPsNetworkType);
            newSS.addNetworkRegistrationInfo(newPsNri);
        } else if (oldPsNri.getAccessNetworkTechnology() != newPsNri.getAccessNetworkTechnology()) {
            this.mDataRatchetEnabled = true;
        }
        newSS.setIsUsingCarrierAggregation(newUsingCA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSameRatFamily(ServiceState ss1, ServiceState ss2) {
        SparseArray<SparseIntArray> sparseArray = this.mRatFamilyMap;
        synchronized (sparseArray) {
            int dataRat1 = ServiceState.networkTypeToRilRadioTechnology(ss1.getNetworkRegistrationInfo(2, 1).getAccessNetworkTechnology());
            int dataRat2 = ServiceState.networkTypeToRilRadioTechnology(ss2.getNetworkRegistrationInfo(2, 1).getAccessNetworkTechnology());
            if (dataRat1 == dataRat2) {
                return true;
            }
            if (this.mRatFamilyMap.get(dataRat1) == null) {
                return false;
            }
            return this.mRatFamilyMap.get(dataRat1) == this.mRatFamilyMap.get(dataRat2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetRatFamilyMap() {
        SparseArray<SparseIntArray> sparseArray = this.mRatFamilyMap;
        synchronized (sparseArray) {
            this.mRatFamilyMap.clear();
            CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
            if (configManager == null) {
                return;
            }
            PersistableBundle b = configManager.getConfig();
            if (b == null) {
                return;
            }
            String[] ratFamilies = b.getStringArray("ratchet_rat_families");
            if (ratFamilies == null) {
                return;
            }
            block5: for (String ratFamily : ratFamilies) {
                String[] rats = ratFamily.split(",");
                if (rats.length < 2) continue;
                SparseIntArray currentFamily = new SparseIntArray(rats.length);
                int pos = 0;
                for (String ratString : rats) {
                    int ratInt;
                    try {
                        ratInt = Integer.parseInt(ratString.trim());
                    }
                    catch (NumberFormatException e) {
                        Rlog.e(LOG_TAG, "NumberFormatException on " + ratString);
                        continue block5;
                    }
                    if (this.mRatFamilyMap.get(ratInt) != null) {
                        Rlog.e(LOG_TAG, "RAT listed twice: " + ratString);
                        continue block5;
                    }
                    currentFamily.put(ratInt, pos++);
                    this.mRatFamilyMap.put(ratInt, currentFamily);
                }
            }
        }
    }
}

