/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.os.Build;
import android.os.PersistableBundle;
import android.os.SystemProperties;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.data.ApnSetting;
import android.text.TextUtils;
import android.util.Pair;
import com.android.internal.telephony.Phone;
import java.util.ArrayList;
import java.util.Random;

public class RetryManager {
    public static final String LOG_TAG = "RetryManager";
    public static final boolean DBG = true;
    public static final boolean VDBG = false;
    private static final String DEFAULT_DATA_RETRY_CONFIG = "max_retries=3, 5000, 5000, 5000";
    private static final String OTHERS_APN_TYPE = "others";
    private static final long DEFAULT_INTER_APN_DELAY = 20000L;
    private static final long DEFAULT_INTER_APN_DELAY_FOR_PROVISIONING = 3000L;
    private static final long DEFAULT_APN_RETRY_AFTER_DISCONNECT_DELAY = 10000L;
    public static final long NO_RETRY = -1L;
    public static final long NO_SUGGESTED_RETRY_DELAY = -2L;
    private static final int MAX_SAME_APN_RETRY = 3;
    @UnsupportedAppUsage
    private long mInterApnDelay;
    @UnsupportedAppUsage
    private long mFailFastInterApnDelay;
    private long mApnRetryAfterDisconnectDelay;
    private long mModemSuggestedDelay = -2L;
    private int mSameApnRetryCount = 0;
    private ArrayList<RetryRec> mRetryArray = new ArrayList();
    @UnsupportedAppUsage
    private Phone mPhone;
    private boolean mRetryForever = false;
    private int mMaxRetryCount;
    private int mRetryCount = 0;
    private Random mRng = new Random();
    private String mConfig;
    private ArrayList<ApnSetting> mWaitingApns = null;
    private int mCurrentApnIndex = -1;
    @UnsupportedAppUsage
    private String mApnType;

    public RetryManager(Phone phone, String apnType) {
        this.mPhone = phone;
        this.mApnType = apnType;
    }

    @UnsupportedAppUsage
    private boolean configure(String configStr) {
        if (configStr.startsWith("\"") && configStr.endsWith("\"")) {
            configStr = configStr.substring(1, configStr.length() - 1);
        }
        this.reset();
        this.log("configure: '" + configStr + "'");
        this.mConfig = configStr;
        if (!TextUtils.isEmpty(configStr)) {
            int defaultRandomization = 0;
            String[] strArray = configStr.split(",");
            for (int i = 0; i < strArray.length; ++i) {
                Pair<Boolean, Integer> value;
                String[] splitStr = strArray[i].split("=", 2);
                splitStr[0] = splitStr[0].trim();
                if (splitStr.length > 1) {
                    splitStr[1] = splitStr[1].trim();
                    if (TextUtils.equals(splitStr[0], "default_randomization")) {
                        value = this.parseNonNegativeInt(splitStr[0], splitStr[1]);
                        if (!((Boolean)value.first).booleanValue()) {
                            return false;
                        }
                        defaultRandomization = (Integer)value.second;
                        continue;
                    }
                    if (TextUtils.equals(splitStr[0], "max_retries")) {
                        if (TextUtils.equals("infinite", splitStr[1])) {
                            this.mRetryForever = true;
                            continue;
                        }
                        value = this.parseNonNegativeInt(splitStr[0], splitStr[1]);
                        if (!((Boolean)value.first).booleanValue()) {
                            return false;
                        }
                        this.mMaxRetryCount = (Integer)value.second;
                        continue;
                    }
                    Rlog.e(LOG_TAG, "Unrecognized configuration name value pair: " + strArray[i]);
                    return false;
                }
                splitStr = strArray[i].split(":", 2);
                splitStr[0] = splitStr[0].trim();
                RetryRec rr = new RetryRec(0, 0);
                value = this.parseNonNegativeInt("delayTime", splitStr[0]);
                if (!((Boolean)value.first).booleanValue()) {
                    return false;
                }
                rr.mDelayTime = (Integer)value.second;
                if (splitStr.length > 1) {
                    splitStr[1] = splitStr[1].trim();
                    value = this.parseNonNegativeInt("randomizationTime", splitStr[1]);
                    if (!((Boolean)value.first).booleanValue()) {
                        return false;
                    }
                    rr.mRandomizationTime = (Integer)value.second;
                } else {
                    rr.mRandomizationTime = defaultRandomization;
                }
                this.mRetryArray.add(rr);
            }
            if (this.mRetryArray.size() > this.mMaxRetryCount) {
                this.mMaxRetryCount = this.mRetryArray.size();
            }
        } else {
            this.log("configure: cleared");
        }
        return true;
    }

    private void configureRetry() {
        String configString = null;
        String otherConfigString = null;
        try {
            String config;
            if (Build.IS_DEBUGGABLE && !TextUtils.isEmpty(config = SystemProperties.get("test.data_retry_config"))) {
                this.configure(config);
                return;
            }
            CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
            PersistableBundle b = configManager.getConfigForSubId(this.mPhone.getSubId());
            this.mInterApnDelay = b.getLong("carrier_data_call_apn_delay_default_long", 20000L);
            this.mFailFastInterApnDelay = b.getLong("carrier_data_call_apn_delay_faster_long", 3000L);
            this.mApnRetryAfterDisconnectDelay = b.getLong("carrier_data_call_apn_retry_after_disconnect_long", 10000L);
            String[] allConfigStrings = b.getStringArray("carrier_data_call_retry_config_strings");
            if (allConfigStrings != null) {
                for (String s : allConfigStrings) {
                    String[] splitStr;
                    if (TextUtils.isEmpty(s) || (splitStr = s.split(":", 2)).length != 2) continue;
                    String apnType = splitStr[0].trim();
                    if (apnType.equals(this.mApnType)) {
                        configString = splitStr[1];
                        break;
                    }
                    if (!apnType.equals(OTHERS_APN_TYPE)) continue;
                    otherConfigString = splitStr[1];
                }
            }
            if (configString == null) {
                if (otherConfigString != null) {
                    configString = otherConfigString;
                } else {
                    this.log("Invalid APN retry configuration!. Use the default one now.");
                    configString = DEFAULT_DATA_RETRY_CONFIG;
                }
            }
        }
        catch (NullPointerException ex) {
            this.log("Failed to read configuration! Use the hardcoded default value.");
            this.mInterApnDelay = 20000L;
            this.mFailFastInterApnDelay = 3000L;
            configString = DEFAULT_DATA_RETRY_CONFIG;
        }
        this.configure(configString);
    }

    @UnsupportedAppUsage
    private int getRetryTimer() {
        int index = this.mRetryCount < this.mRetryArray.size() ? this.mRetryCount : this.mRetryArray.size() - 1;
        int retVal = index >= 0 && index < this.mRetryArray.size() ? this.mRetryArray.get((int)index).mDelayTime + this.nextRandomizationTime(index) : 0;
        this.log("getRetryTimer: " + retVal);
        return retVal;
    }

    private Pair<Boolean, Integer> parseNonNegativeInt(String name, String stringValue) {
        Pair<Boolean, Integer> retVal;
        try {
            int value = Integer.parseInt(stringValue);
            retVal = new Pair<Boolean, Integer>(this.validateNonNegativeInt(name, value), value);
        }
        catch (NumberFormatException e) {
            Rlog.e(LOG_TAG, name + " bad value: " + stringValue, e);
            retVal = new Pair<Boolean, Integer>(false, 0);
        }
        return retVal;
    }

    private boolean validateNonNegativeInt(String name, int value) {
        boolean retVal;
        if (value < 0) {
            Rlog.e(LOG_TAG, name + " bad value: is < 0");
            retVal = false;
        } else {
            retVal = true;
        }
        return retVal;
    }

    private int nextRandomizationTime(int index) {
        int randomTime = this.mRetryArray.get((int)index).mRandomizationTime;
        if (randomTime == 0) {
            return 0;
        }
        return this.mRng.nextInt(randomTime);
    }

    public ApnSetting getNextApnSetting() {
        int index;
        block4: {
            if (this.mWaitingApns == null || this.mWaitingApns.size() == 0) {
                this.log("Waiting APN list is null or empty.");
                return null;
            }
            if (this.mModemSuggestedDelay != -2L && this.mSameApnRetryCount < 3) {
                ++this.mSameApnRetryCount;
                return this.mWaitingApns.get(this.mCurrentApnIndex);
            }
            this.mSameApnRetryCount = 0;
            index = this.mCurrentApnIndex;
            do {
                if (++index == this.mWaitingApns.size()) {
                    index = 0;
                }
                if (!this.mWaitingApns.get(index).getPermanentFailed()) break block4;
            } while (index != this.mCurrentApnIndex);
            return null;
        }
        this.mCurrentApnIndex = index;
        return this.mWaitingApns.get(this.mCurrentApnIndex);
    }

    public long getDelayForNextApn(boolean failFastEnabled) {
        long delay;
        int index;
        block9: {
            if (this.mWaitingApns == null || this.mWaitingApns.size() == 0) {
                this.log("Waiting APN list is null or empty.");
                return -1L;
            }
            if (this.mModemSuggestedDelay == -1L) {
                this.log("Modem suggested not retrying.");
                return -1L;
            }
            if (this.mModemSuggestedDelay != -2L && this.mSameApnRetryCount < 3) {
                this.log("Modem suggested retry in " + this.mModemSuggestedDelay + " ms.");
                return this.mModemSuggestedDelay;
            }
            index = this.mCurrentApnIndex;
            do {
                if (++index >= this.mWaitingApns.size()) {
                    index = 0;
                }
                if (!this.mWaitingApns.get(index).getPermanentFailed()) break block9;
            } while (index != this.mCurrentApnIndex);
            this.log("All APNs have permanently failed.");
            return -1L;
        }
        if (index <= this.mCurrentApnIndex) {
            if (!this.mRetryForever && this.mRetryCount + 1 > this.mMaxRetryCount) {
                this.log("Reached maximum retry count " + this.mMaxRetryCount + ".");
                return -1L;
            }
            delay = this.getRetryTimer();
            ++this.mRetryCount;
        } else {
            delay = this.mInterApnDelay;
        }
        if (failFastEnabled && delay > this.mFailFastInterApnDelay) {
            delay = this.mFailFastInterApnDelay;
        }
        return delay;
    }

    public void markApnPermanentFailed(ApnSetting apn) {
        if (apn != null) {
            apn.setPermanentFailed(true);
        }
    }

    private void reset() {
        this.mMaxRetryCount = 0;
        this.mRetryCount = 0;
        this.mCurrentApnIndex = -1;
        this.mSameApnRetryCount = 0;
        this.mModemSuggestedDelay = -2L;
        this.mRetryArray.clear();
    }

    public void setWaitingApns(ArrayList<ApnSetting> waitingApns) {
        if (waitingApns == null) {
            this.log("No waiting APNs provided");
            return;
        }
        this.mWaitingApns = waitingApns;
        this.configureRetry();
        for (ApnSetting apn : this.mWaitingApns) {
            apn.setPermanentFailed(false);
        }
        this.log("Setting " + this.mWaitingApns.size() + " waiting APNs.");
    }

    public ArrayList<ApnSetting> getWaitingApns() {
        return this.mWaitingApns;
    }

    public void setModemSuggestedDelay(long delay) {
        this.mModemSuggestedDelay = delay;
    }

    public long getRetryAfterDisconnectDelay() {
        return this.mApnRetryAfterDisconnectDelay;
    }

    public String toString() {
        if (this.mConfig == null) {
            return "";
        }
        return "RetryManager: mApnType=" + this.mApnType + " mRetryCount=" + this.mRetryCount + " mMaxRetryCount=" + this.mMaxRetryCount + " mCurrentApnIndex=" + this.mCurrentApnIndex + " mSameApnRtryCount=" + this.mSameApnRetryCount + " mModemSuggestedDelay=" + this.mModemSuggestedDelay + " mRetryForever=" + this.mRetryForever + " mInterApnDelay=" + this.mInterApnDelay + " mApnRetryAfterDisconnectDelay=" + this.mApnRetryAfterDisconnectDelay + " mConfig={" + this.mConfig + "}";
    }

    @UnsupportedAppUsage
    private void log(String s) {
        Rlog.d(LOG_TAG, "[" + this.mApnType + "] " + s);
    }

    private static class RetryRec {
        int mDelayTime;
        int mRandomizationTime;

        RetryRec(int delayTime, int randomizationTime) {
            this.mDelayTime = delayTime;
            this.mRandomizationTime = randomizationTime;
        }
    }
}

