/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.BaseBundle;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.WorkSource;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.CarrierConfigManager;
import android.telephony.CellIdentity;
import android.telephony.CellIdentityCdma;
import android.telephony.CellIdentityGsm;
import android.telephony.CellIdentityLte;
import android.telephony.CellIdentityTdscdma;
import android.telephony.CellIdentityWcdma;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.DataSpecificRegistrationInfo;
import android.telephony.NetworkRegistrationInfo;
import android.telephony.PhysicalChannelConfig;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.VoiceSpecificRegistrationInfo;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.LocalLog;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.StatsLog;
import android.util.TimestampedValue;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CarrierServiceStateTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.HbpcdUtils;
import com.android.internal.telephony.LocaleTracker;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.NetworkRegistrationManager;
import com.android.internal.telephony.NitzData;
import com.android.internal.telephony.NitzStateMachine;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.ProxyController;
import com.android.internal.telephony.RatRatcheter;
import com.android.internal.telephony.RestrictedState;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.TimeZoneLookupHelper;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.cdma.EriManager;
import com.android.internal.telephony.cdnr.CarrierDisplayNameData;
import com.android.internal.telephony.cdnr.CarrierDisplayNameResolver;
import com.android.internal.telephony.dataconnection.DataConnection;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.telephony.dataconnection.TransportManager;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.RuimRecords;
import com.android.internal.telephony.uicc.SIMRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.UiccProfile;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ServiceStateTracker
extends Handler {
    static final String LOG_TAG = "SST";
    static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String PROP_FORCE_ROAMING = "telephony.test.forceRoaming";
    @UnsupportedAppUsage
    private CommandsInterface mCi;
    @UnsupportedAppUsage
    private UiccController mUiccController = null;
    @UnsupportedAppUsage
    private UiccCardApplication mUiccApplcation = null;
    @UnsupportedAppUsage
    private IccRecords mIccRecords = null;
    private boolean mVoiceCapable;
    @UnsupportedAppUsage
    public ServiceState mSS;
    @UnsupportedAppUsage
    private ServiceState mNewSS;
    private int mCellInfoMinIntervalMs = 2000;
    private static final long CELL_INFO_LIST_QUERY_TIMEOUT = 2000L;
    private long mLastCellInfoReqTime;
    private List<CellInfo> mLastCellInfoList = null;
    private List<PhysicalChannelConfig> mLastPhysicalChannelConfigList = null;
    @UnsupportedAppUsage
    private SignalStrength mSignalStrength;
    public RestrictedState mRestrictedState;
    @VisibleForTesting
    public int[] mPollingContext;
    @UnsupportedAppUsage
    private boolean mDesiredPowerState;
    private boolean mDontPollSignalStrength = false;
    @UnsupportedAppUsage
    private RegistrantList mVoiceRoamingOnRegistrants = new RegistrantList();
    @UnsupportedAppUsage
    private RegistrantList mVoiceRoamingOffRegistrants = new RegistrantList();
    @UnsupportedAppUsage
    private RegistrantList mDataRoamingOnRegistrants = new RegistrantList();
    @UnsupportedAppUsage
    private RegistrantList mDataRoamingOffRegistrants = new RegistrantList();
    protected SparseArray<RegistrantList> mAttachedRegistrants = new SparseArray();
    protected SparseArray<RegistrantList> mDetachedRegistrants = new SparseArray();
    private RegistrantList mVoiceRegStateOrRatChangedRegistrants = new RegistrantList();
    private SparseArray<RegistrantList> mDataRegStateOrRatChangedRegistrants = new SparseArray();
    @UnsupportedAppUsage
    private RegistrantList mNetworkAttachedRegistrants = new RegistrantList();
    private RegistrantList mNetworkDetachedRegistrants = new RegistrantList();
    private RegistrantList mPsRestrictEnabledRegistrants = new RegistrantList();
    private RegistrantList mPsRestrictDisabledRegistrants = new RegistrantList();
    private RegistrantList mImsCapabilityChangedRegistrants = new RegistrantList();
    private boolean mPendingRadioPowerOffAfterDataOff = false;
    private int mPendingRadioPowerOffAfterDataOffTag = 0;
    private static final int POLL_PERIOD_MILLIS = 20000;
    public static final int DEFAULT_GPRS_CHECK_PERIOD_MILLIS = 60000;
    protected static final int EVENT_RADIO_STATE_CHANGED = 1;
    protected static final int EVENT_NETWORK_STATE_CHANGED = 2;
    protected static final int EVENT_GET_SIGNAL_STRENGTH = 3;
    protected static final int EVENT_POLL_STATE_CS_CELLULAR_REGISTRATION = 4;
    protected static final int EVENT_POLL_STATE_PS_CELLULAR_REGISTRATION = 5;
    protected static final int EVENT_POLL_STATE_PS_IWLAN_REGISTRATION = 6;
    protected static final int EVENT_POLL_STATE_OPERATOR = 7;
    protected static final int EVENT_POLL_SIGNAL_STRENGTH = 10;
    protected static final int EVENT_NITZ_TIME = 11;
    protected static final int EVENT_SIGNAL_STRENGTH_UPDATE = 12;
    protected static final int EVENT_POLL_STATE_NETWORK_SELECTION_MODE = 14;
    protected static final int EVENT_GET_LOC_DONE = 15;
    protected static final int EVENT_SIM_RECORDS_LOADED = 16;
    protected static final int EVENT_SIM_READY = 17;
    protected static final int EVENT_LOCATION_UPDATES_ENABLED = 18;
    protected static final int EVENT_GET_PREFERRED_NETWORK_TYPE = 19;
    protected static final int EVENT_SET_PREFERRED_NETWORK_TYPE = 20;
    protected static final int EVENT_RESET_PREFERRED_NETWORK_TYPE = 21;
    protected static final int EVENT_CHECK_REPORT_GPRS = 22;
    protected static final int EVENT_RESTRICTED_STATE_CHANGED = 23;
    protected static final int EVENT_RUIM_READY = 26;
    protected static final int EVENT_RUIM_RECORDS_LOADED = 27;
    protected static final int EVENT_POLL_STATE_CDMA_SUBSCRIPTION = 34;
    protected static final int EVENT_NV_READY = 35;
    protected static final int EVENT_OTA_PROVISION_STATUS_CHANGE = 37;
    protected static final int EVENT_SET_RADIO_POWER_OFF = 38;
    protected static final int EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED = 39;
    protected static final int EVENT_CDMA_PRL_VERSION_CHANGED = 40;
    protected static final int EVENT_RADIO_ON = 41;
    public static final int EVENT_ICC_CHANGED = 42;
    protected static final int EVENT_GET_CELL_INFO_LIST = 43;
    protected static final int EVENT_UNSOL_CELL_INFO_LIST = 44;
    protected static final int EVENT_CHANGE_IMS_STATE = 45;
    protected static final int EVENT_IMS_STATE_CHANGED = 46;
    protected static final int EVENT_IMS_STATE_DONE = 47;
    protected static final int EVENT_IMS_CAPABILITY_CHANGED = 48;
    protected static final int EVENT_ALL_DATA_DISCONNECTED = 49;
    protected static final int EVENT_PHONE_TYPE_SWITCHED = 50;
    protected static final int EVENT_RADIO_POWER_FROM_CARRIER = 51;
    protected static final int EVENT_IMS_SERVICE_STATE_CHANGED = 53;
    protected static final int EVENT_RADIO_POWER_OFF_DONE = 54;
    protected static final int EVENT_PHYSICAL_CHANNEL_CONFIG = 55;
    protected static final int EVENT_CELL_LOCATION_RESPONSE = 56;
    protected static final int EVENT_CARRIER_CONFIG_CHANGED = 57;
    public static final int CARRIER_NAME_DISPLAY_BITMASK_SHOW_SPN = 1;
    public static final int CARRIER_NAME_DISPLAY_BITMASK_SHOW_PLMN = 2;
    private List<Message> mPendingCellInfoRequests = new LinkedList<Message>();
    private boolean mIsPendingCellInfoRequest = false;
    protected static final String REGISTRATION_DENIED_GEN = "General";
    protected static final String REGISTRATION_DENIED_AUTH = "Authentication Failure";
    private CarrierDisplayNameResolver mCdnr;
    private boolean mImsRegistrationOnOff = false;
    private boolean mAlarmSwitch = false;
    private boolean mRadioDisabledByCarrier = false;
    private PendingIntent mRadioOffIntent = null;
    private static final String ACTION_RADIO_OFF = "android.intent.action.ACTION_RADIO_OFF";
    private boolean mPowerOffDelayNeed = true;
    @UnsupportedAppUsage
    private boolean mDeviceShuttingDown = false;
    @UnsupportedAppUsage
    private boolean mSpnUpdatePending = false;
    @UnsupportedAppUsage
    private String mCurSpn = null;
    @UnsupportedAppUsage
    private String mCurDataSpn = null;
    @UnsupportedAppUsage
    private String mCurPlmn = null;
    @UnsupportedAppUsage
    private boolean mCurShowPlmn = false;
    @UnsupportedAppUsage
    private boolean mCurShowSpn = false;
    @UnsupportedAppUsage
    @VisibleForTesting
    public int mSubId = -1;
    private int mPrevSubId = -1;
    private boolean mImsRegistered = false;
    @UnsupportedAppUsage
    private SubscriptionManager mSubscriptionManager;
    @UnsupportedAppUsage
    private SubscriptionController mSubscriptionController;
    @UnsupportedAppUsage
    private final SstSubscriptionsChangedListener mOnSubscriptionsChangedListener = new SstSubscriptionsChangedListener();
    private final RatRatcheter mRatRatcheter;
    private final LocaleTracker mLocaleTracker;
    private final LocalLog mRoamingLog = new LocalLog(10);
    private final LocalLog mAttachLog = new LocalLog(10);
    private final LocalLog mPhoneTypeLog = new LocalLog(10);
    private final LocalLog mRatLog = new LocalLog(20);
    private final LocalLog mRadioPowerLog = new LocalLog(20);
    private final LocalLog mCdnrLogs = new LocalLog(64);
    private Pattern mOperatorNameStringPattern;
    @UnsupportedAppUsage
    private final GsmCdmaPhone mPhone;
    private CellIdentity mCellIdentity;
    private CellIdentity mNewCellIdentity;
    private static final int MS_PER_HOUR = 3600000;
    private final NitzStateMachine mNitzState;
    private final EriManager mEriManager;
    @UnsupportedAppUsage
    private final ContentResolver mCr;
    @UnsupportedAppUsage
    private int mPreferredNetworkType;
    @UnsupportedAppUsage
    private int mMaxDataCalls = 1;
    @UnsupportedAppUsage
    private int mNewMaxDataCalls = 1;
    @UnsupportedAppUsage
    private int mReasonDataDenied = -1;
    @UnsupportedAppUsage
    private int mNewReasonDataDenied = -1;
    private int mRejectCode;
    private int mNewRejectCode;
    private boolean mGsmRoaming = false;
    private boolean mDataRoaming = false;
    @UnsupportedAppUsage
    private boolean mEmergencyOnly = false;
    @UnsupportedAppUsage
    private boolean mStartedGprsRegCheck;
    @UnsupportedAppUsage
    private boolean mReportedGprsNoReg;
    private CarrierServiceStateTracker mCSST;
    private Notification mNotification;
    public static final int PS_ENABLED = 1001;
    public static final int PS_DISABLED = 1002;
    public static final int CS_ENABLED = 1003;
    public static final int CS_DISABLED = 1004;
    public static final int CS_NORMAL_ENABLED = 1005;
    public static final int CS_EMERGENCY_ENABLED = 1006;
    public static final int CS_REJECT_CAUSE_ENABLED = 2001;
    public static final int CS_REJECT_CAUSE_DISABLED = 2002;
    public static final int PS_NOTIFICATION = 888;
    public static final int CS_NOTIFICATION = 999;
    public static final int CS_REJECT_CAUSE_NOTIFICATION = 111;
    private boolean mIsSimReady = false;
    @UnsupportedAppUsage
    private BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                int phoneId = intent.getExtras().getInt("android.telephony.extra.SLOT_INDEX");
                if (phoneId == ServiceStateTracker.this.mPhone.getPhoneId()) {
                    ServiceStateTracker.this.sendEmptyMessage(57);
                }
                return;
            }
            if (!ServiceStateTracker.this.mPhone.isPhoneTypeGsm()) {
                ServiceStateTracker.this.loge("Ignoring intent " + intent + " received on CDMA phone");
                return;
            }
            if (intent.getAction().equals("android.intent.action.LOCALE_CHANGED")) {
                ServiceStateTracker.this.updateSpnDisplay();
            } else if (intent.getAction().equals(ServiceStateTracker.ACTION_RADIO_OFF)) {
                ServiceStateTracker.this.mAlarmSwitch = false;
                ServiceStateTracker.this.powerOffRadioSafely();
            }
        }
    };
    public static final String UNACTIVATED_MIN2_VALUE = "000000";
    public static final String UNACTIVATED_MIN_VALUE = "1111110111";
    private int mCurrentOtaspMode = 0;
    @UnsupportedAppUsage
    private int mRoamingIndicator;
    private boolean mIsInPrl;
    @UnsupportedAppUsage
    private int mDefaultRoamingIndicator;
    private int mRegistrationState = -1;
    private RegistrantList mCdmaForSubscriptionInfoReadyRegistrants = new RegistrantList();
    private String mMdn;
    private int[] mHomeSystemId = null;
    private int[] mHomeNetworkId = null;
    private String mMin;
    private String mPrlVersion;
    private boolean mIsMinInfoReady = false;
    private boolean mIsEriTextLoaded = false;
    @UnsupportedAppUsage
    private boolean mIsSubscriptionFromRuim = false;
    private CdmaSubscriptionSourceManager mCdmaSSM;
    public static final String INVALID_MCC = "000";
    public static final String DEFAULT_MNC = "00";
    private HbpcdUtils mHbpcdUtils = null;
    private String mRegistrationDeniedReason;
    private String mCurrentCarrier = null;
    private final TransportManager mTransportManager;
    private final SparseArray<NetworkRegistrationManager> mRegStateManagers = new SparseArray();
    private ArrayList<Pair<Integer, Integer>> mEarfcnPairListForRsrpBoost = null;
    private int mLteRsrpBoost = 0;
    private final Object mLteRsrpBoostLock = new Object();
    private static final int INVALID_LTE_EARFCN = -1;
    private SignalStrength mLastSignalStrength = null;
    private boolean mWantContinuousLocationUpdates;
    private boolean mWantSingleLocationUpdate;

    public ServiceStateTracker(GsmCdmaPhone phone, CommandsInterface ci) {
        this.mNitzState = TelephonyComponentFactory.getInstance().inject(NitzStateMachine.class.getName()).makeNitzStateMachine(phone);
        this.mPhone = phone;
        this.mCi = ci;
        this.mCdnr = new CarrierDisplayNameResolver(this.mPhone);
        this.mEriManager = TelephonyComponentFactory.getInstance().inject(EriManager.class.getName()).makeEriManager(this.mPhone, 0);
        this.mRatRatcheter = new RatRatcheter(this.mPhone);
        this.mVoiceCapable = this.mPhone.getContext().getResources().getBoolean(17891570);
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 42, null);
        this.mCi.setOnSignalStrengthUpdate(this, 12, null);
        this.mCi.registerForCellInfoList(this, 44, null);
        this.mCi.registerForPhysicalChannelConfiguration(this, 55, null);
        this.mSubscriptionController = SubscriptionController.getInstance();
        this.mSubscriptionManager = SubscriptionManager.from(phone.getContext());
        this.mSubscriptionManager.addOnSubscriptionsChangedListener(this.mOnSubscriptionsChangedListener);
        this.mRestrictedState = new RestrictedState();
        this.mTransportManager = this.mPhone.getTransportManager();
        for (int transportType : this.mTransportManager.getAvailableTransports()) {
            this.mRegStateManagers.append(transportType, new NetworkRegistrationManager(transportType, phone));
            this.mRegStateManagers.get(transportType).registerForNetworkRegistrationInfoChanged(this, 2, null);
        }
        this.mLocaleTracker = TelephonyComponentFactory.getInstance().inject(LocaleTracker.class.getName()).makeLocaleTracker(this.mPhone, this.mNitzState, this.getLooper());
        this.mCi.registerForImsNetworkStateChanged(this, 46, null);
        this.mCi.registerForRadioStateChanged(this, 1, null);
        this.mCi.setOnNITZTime(this, 11, null);
        this.mCr = phone.getContext().getContentResolver();
        int airplaneMode = Settings.Global.getInt(this.mCr, "airplane_mode_on", 0);
        int enableCellularOnBoot = Settings.Global.getInt(this.mCr, "enable_cellular_on_boot", 1);
        this.mDesiredPowerState = enableCellularOnBoot > 0 && airplaneMode <= 0;
        this.mRadioPowerLog.log("init : airplane mode = " + airplaneMode + " enableCellularOnBoot = " + enableCellularOnBoot);
        this.setSignalStrengthDefaultValues();
        this.mPhone.getCarrierActionAgent().registerForCarrierAction(1, this, 51, null, false);
        Context context = this.mPhone.getContext();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.LOCALE_CHANGED");
        context.registerReceiver(this.mIntentReceiver, filter);
        filter = new IntentFilter();
        filter.addAction(ACTION_RADIO_OFF);
        context.registerReceiver(this.mIntentReceiver, filter);
        filter = new IntentFilter();
        filter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        context.registerReceiver(this.mIntentReceiver, filter);
        this.mPhone.notifyOtaspChanged(0);
        this.mCi.setOnRestrictedStateChanged(this, 23, null);
        this.updatePhoneType();
        this.mCSST = new CarrierServiceStateTracker(phone, this);
        this.registerForNetworkAttached(this.mCSST, 101, null);
        this.registerForNetworkDetached(this.mCSST, 102, null);
        this.registerForDataConnectionAttached(1, this.mCSST, 103, null);
        this.registerForDataConnectionDetached(1, this.mCSST, 104, null);
        this.registerForImsCapabilityChanged(this.mCSST, 105, null);
    }

    @VisibleForTesting
    public void updatePhoneType() {
        if (this.mSS != null && this.mSS.getVoiceRoaming()) {
            this.mVoiceRoamingOffRegistrants.notifyRegistrants();
        }
        if (this.mSS != null && this.mSS.getDataRoaming()) {
            this.mDataRoamingOffRegistrants.notifyRegistrants();
        }
        if (this.mSS != null && this.mSS.getVoiceRegState() == 0) {
            this.mNetworkDetachedRegistrants.notifyRegistrants();
        }
        for (int transport : this.mTransportManager.getAvailableTransports()) {
            NetworkRegistrationInfo nrs;
            if (this.mSS == null || (nrs = this.mSS.getNetworkRegistrationInfo(2, transport)) == null || !nrs.isInService() || this.mDetachedRegistrants.get(transport) == null) continue;
            this.mDetachedRegistrants.get(transport).notifyRegistrants();
        }
        this.mSS = new ServiceState();
        this.mSS.setStateOutOfService();
        this.mNewSS = new ServiceState();
        this.mNewSS.setStateOutOfService();
        this.mLastCellInfoReqTime = 0L;
        this.mLastCellInfoList = null;
        this.mSignalStrength = new SignalStrength();
        this.mStartedGprsRegCheck = false;
        this.mReportedGprsNoReg = false;
        this.mMdn = null;
        this.mMin = null;
        this.mPrlVersion = null;
        this.mIsMinInfoReady = false;
        this.mNitzState.handleNetworkCountryCodeUnavailable();
        this.mCellIdentity = null;
        this.mNewCellIdentity = null;
        this.cancelPollState();
        if (this.mPhone.isPhoneTypeGsm()) {
            if (this.mCdmaSSM != null) {
                this.mCdmaSSM.dispose(this);
            }
            this.mCi.unregisterForCdmaPrlChanged(this);
            this.mCi.unregisterForCdmaOtaProvision(this);
            this.mPhone.unregisterForSimRecordsLoaded(this);
        } else {
            this.mPhone.registerForSimRecordsLoaded(this, 16, null);
            this.mCdmaSSM = CdmaSubscriptionSourceManager.getInstance(this.mPhone.getContext(), this.mCi, this, 39, null);
            this.mIsSubscriptionFromRuim = this.mCdmaSSM.getCdmaSubscriptionSource() == 0;
            this.mCi.registerForCdmaPrlChanged(this, 40, null);
            this.mCi.registerForCdmaOtaProvision(this, 37, null);
            this.mHbpcdUtils = new HbpcdUtils(this.mPhone.getContext());
            this.updateOtaspState();
        }
        this.onUpdateIccAvailability();
        this.mPhone.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(0));
        this.mCi.getSignalStrength(this.obtainMessage(3));
        this.sendMessage(this.obtainMessage(50));
        this.logPhoneTypeChange();
        this.notifyVoiceRegStateRilRadioTechnologyChanged();
        for (int transport : this.mTransportManager.getAvailableTransports()) {
            this.notifyDataRegStateRilRadioTechnologyChanged(transport);
        }
    }

    @VisibleForTesting
    public void requestShutdown() {
        if (this.mDeviceShuttingDown) {
            return;
        }
        this.mDeviceShuttingDown = true;
        this.mDesiredPowerState = false;
        this.setPowerStateToDesired();
    }

    public void dispose() {
        this.mCi.unSetOnSignalStrengthUpdate(this);
        this.mUiccController.unregisterForIccChanged(this);
        this.mCi.unregisterForCellInfoList(this);
        this.mCi.unregisterForPhysicalChannelConfiguration(this);
        this.mSubscriptionManager.removeOnSubscriptionsChangedListener(this.mOnSubscriptionsChangedListener);
        this.mCi.unregisterForImsNetworkStateChanged(this);
        this.mPhone.getCarrierActionAgent().unregisterForCarrierAction(this, 1);
        if (this.mCSST != null) {
            this.mCSST.dispose();
            this.mCSST = null;
        }
    }

    @UnsupportedAppUsage
    public boolean getDesiredPowerState() {
        return this.mDesiredPowerState;
    }

    public boolean getPowerStateFromCarrier() {
        return !this.mRadioDisabledByCarrier;
    }

    @UnsupportedAppUsage
    protected boolean notifySignalStrength() {
        boolean notified = false;
        if (!this.mSignalStrength.equals(this.mLastSignalStrength)) {
            try {
                this.mPhone.notifySignalStrength();
                notified = true;
                this.mLastSignalStrength = this.mSignalStrength;
            }
            catch (NullPointerException ex) {
                this.loge("updateSignalStrength() Phone already destroyed: " + ex + "SignalStrength not notified");
            }
        }
        return notified;
    }

    protected void notifyVoiceRegStateRilRadioTechnologyChanged() {
        int rat = this.mSS.getRilVoiceRadioTechnology();
        int vrs = this.mSS.getVoiceRegState();
        this.log("notifyVoiceRegStateRilRadioTechnologyChanged: vrs=" + vrs + " rat=" + rat);
        this.mVoiceRegStateOrRatChangedRegistrants.notifyResult(new Pair<Integer, Integer>(vrs, rat));
    }

    protected void notifyDataRegStateRilRadioTechnologyChanged(int transport) {
        NetworkRegistrationInfo nrs = this.mSS.getNetworkRegistrationInfo(2, transport);
        if (nrs != null) {
            int rat = ServiceState.networkTypeToRilRadioTechnology(nrs.getAccessNetworkTechnology());
            int drs = this.regCodeToServiceState(nrs.getRegistrationState());
            this.log("notifyDataRegStateRilRadioTechnologyChanged: drs=" + drs + " rat=" + rat);
            RegistrantList registrantList = this.mDataRegStateOrRatChangedRegistrants.get(transport);
            if (registrantList != null) {
                registrantList.notifyResult(new Pair<Integer, Integer>(drs, rat));
            }
        }
        this.mPhone.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(this.mSS.getRilDataRadioTechnology()));
    }

    @UnsupportedAppUsage
    protected void useDataRegStateForDataOnlyDevices() {
        if (!this.mVoiceCapable) {
            this.log("useDataRegStateForDataOnlyDevice: VoiceRegState=" + this.mNewSS.getVoiceRegState() + " DataRegState=" + this.mNewSS.getDataRegState());
            this.mNewSS.setVoiceRegState(this.mNewSS.getDataRegState());
        }
    }

    @UnsupportedAppUsage
    protected void updatePhoneObject() {
        if (this.mPhone.getContext().getResources().getBoolean(17891547)) {
            boolean isRegistered;
            boolean bl = isRegistered = this.mSS.getVoiceRegState() == 0 || this.mSS.getVoiceRegState() == 2;
            if (!isRegistered) {
                this.log("updatePhoneObject: Ignore update");
                return;
            }
            this.mPhone.updatePhoneObject(this.mSS.getRilVoiceRadioTechnology());
        }
    }

    public void registerForVoiceRoamingOn(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceRoamingOnRegistrants.add(r);
        if (this.mSS.getVoiceRoaming()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForVoiceRoamingOn(Handler h) {
        this.mVoiceRoamingOnRegistrants.remove(h);
    }

    public void registerForVoiceRoamingOff(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceRoamingOffRegistrants.add(r);
        if (!this.mSS.getVoiceRoaming()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForVoiceRoamingOff(Handler h) {
        this.mVoiceRoamingOffRegistrants.remove(h);
    }

    public void registerForDataRoamingOn(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mDataRoamingOnRegistrants.add(r);
        if (this.mSS.getDataRoaming()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForDataRoamingOn(Handler h) {
        this.mDataRoamingOnRegistrants.remove(h);
    }

    public void registerForDataRoamingOff(Handler h, int what, Object obj, boolean notifyNow) {
        Registrant r = new Registrant(h, what, obj);
        this.mDataRoamingOffRegistrants.add(r);
        if (notifyNow && !this.mSS.getDataRoaming()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForDataRoamingOff(Handler h) {
        this.mDataRoamingOffRegistrants.remove(h);
    }

    @UnsupportedAppUsage
    public void reRegisterNetwork(Message onComplete) {
        this.mCi.getPreferredNetworkType(this.obtainMessage(19, onComplete));
    }

    public void setRadioPower(boolean power) {
        this.mDesiredPowerState = power;
        this.setPowerStateToDesired();
    }

    public void setRadioPowerFromCarrier(boolean enable) {
        this.mRadioDisabledByCarrier = !enable;
        this.setPowerStateToDesired();
    }

    public void enableSingleLocationUpdate() {
        if (this.mWantSingleLocationUpdate || this.mWantContinuousLocationUpdates) {
            return;
        }
        this.mWantSingleLocationUpdate = true;
        this.mCi.setLocationUpdates(true, this.obtainMessage(18));
    }

    public void enableLocationUpdates() {
        if (this.mWantSingleLocationUpdate || this.mWantContinuousLocationUpdates) {
            return;
        }
        this.mWantContinuousLocationUpdates = true;
        this.mCi.setLocationUpdates(true, this.obtainMessage(18));
    }

    protected void disableSingleLocationUpdate() {
        this.mWantSingleLocationUpdate = false;
        if (!this.mWantSingleLocationUpdate && !this.mWantContinuousLocationUpdates) {
            this.mCi.setLocationUpdates(false, null);
        }
    }

    public void disableLocationUpdates() {
        this.mWantContinuousLocationUpdates = false;
        if (!this.mWantSingleLocationUpdate && !this.mWantContinuousLocationUpdates) {
            this.mCi.setLocationUpdates(false, null);
        }
    }

    private int getLteEarfcn(CellIdentity cellIdentity) {
        int lteEarfcn = -1;
        if (cellIdentity != null) {
            switch (cellIdentity.getType()) {
                case 3: {
                    lteEarfcn = ((CellIdentityLte)cellIdentity).getEarfcn();
                    break;
                }
            }
        }
        return lteEarfcn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 38: {
                ServiceStateTracker serviceStateTracker = this;
                synchronized (serviceStateTracker) {
                    if (this.mPendingRadioPowerOffAfterDataOff && msg.arg1 == this.mPendingRadioPowerOffAfterDataOffTag) {
                        this.log("EVENT_SET_RADIO_OFF, turn radio off now.");
                        this.hangupAndPowerOff();
                        ++this.mPendingRadioPowerOffAfterDataOffTag;
                        this.mPendingRadioPowerOffAfterDataOff = false;
                    } else {
                        this.log("EVENT_SET_RADIO_OFF is stale arg1=" + msg.arg1 + "!= tag=" + this.mPendingRadioPowerOffAfterDataOffTag);
                    }
                    break;
                }
            }
            case 42: {
                if (this.isSimAbsent()) {
                    this.log("EVENT_ICC_CHANGED: SIM absent");
                    this.cancelAllNotifications();
                    this.mMdn = null;
                    this.mMin = null;
                    this.mIsMinInfoReady = false;
                    this.mCdnr.updateEfFromRuim(null);
                    this.mCdnr.updateEfFromUsim(null);
                }
                this.onUpdateIccAvailability();
                if (this.mUiccApplcation == null || this.mUiccApplcation.getState() == IccCardApplicationStatus.AppState.APPSTATE_READY) break;
                this.mIsSimReady = false;
                this.updateSpnDisplay();
                break;
            }
            case 43: 
            case 44: {
                List cellInfo = null;
                Throwable ex = null;
                if (msg.obj != null) {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.log("EVENT_GET_CELL_INFO_LIST: error ret null, e=" + ar.exception);
                        ex = ar.exception;
                    } else if (ar.result == null) {
                        this.loge("Invalid CellInfo result");
                    } else {
                        cellInfo = (List)ar.result;
                        this.updateOperatorNameForCellInfo(cellInfo);
                        this.mLastCellInfoList = cellInfo;
                        this.mPhone.notifyCellInfo(cellInfo);
                    }
                } else {
                    long curTime;
                    if (!this.mIsPendingCellInfoRequest || (curTime = SystemClock.elapsedRealtime()) - this.mLastCellInfoReqTime < 2000L) break;
                    this.loge("Timeout waiting for CellInfo; (everybody panic)!");
                    this.mLastCellInfoList = null;
                }
                List<Message> list = this.mPendingCellInfoRequests;
                synchronized (list) {
                    if (this.mIsPendingCellInfoRequest) {
                        this.mIsPendingCellInfoRequest = false;
                        for (Message m : this.mPendingCellInfoRequests) {
                            AsyncResult.forMessage(m, cellInfo, ex);
                            m.sendToTarget();
                        }
                        this.mPendingCellInfoRequests.clear();
                    }
                    break;
                }
            }
            case 46: {
                this.mCi.getImsRegistrationState(this.obtainMessage(47));
                break;
            }
            case 47: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                int[] responseArray = (int[])ar.result;
                this.mImsRegistered = responseArray[0] == 1;
                break;
            }
            case 54: {
                this.log("EVENT_RADIO_POWER_OFF_DONE");
                if (!this.mDeviceShuttingDown || this.mCi.getRadioState() == 2) break;
                this.mCi.requestShutdown(null);
                break;
            }
            case 17: {
                this.mOnSubscriptionsChangedListener.mPreviousSubId.set(-1);
                this.mPrevSubId = -1;
                this.mIsSimReady = true;
                this.pollState();
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 1: 
            case 50: {
                if (!this.mPhone.isPhoneTypeGsm() && this.mCi.getRadioState() == 1) {
                    this.handleCdmaSubscriptionSource(this.mCdmaSSM.getCdmaSubscriptionSource());
                    this.queueNextSignalStrengthPoll();
                }
                this.setPowerStateToDesired();
                this.modemTriggeredPollState();
                break;
            }
            case 2: {
                this.modemTriggeredPollState();
                break;
            }
            case 3: {
                if (this.mCi.getRadioState() != 1) {
                    return;
                }
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSignalStrengthResult(ar);
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 15: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    CellIdentity cellIdentity = ((NetworkRegistrationInfo)ar.result).getCellIdentity();
                    this.updateOperatorNameForCellIdentity(cellIdentity);
                    this.mCellIdentity = cellIdentity;
                    this.mPhone.notifyLocationChanged(this.getCellLocation());
                }
                this.disableSingleLocationUpdate();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.handlePollStateResult(msg.what, ar);
                break;
            }
            case 14: {
                this.log("EVENT_POLL_STATE_NETWORK_SELECTION_MODE");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (this.mPhone.isPhoneTypeGsm()) {
                    this.handlePollStateResult(msg.what, ar);
                    break;
                }
                if (ar.exception == null && ar.result != null) {
                    int[] ints = (int[])ar.result;
                    if (ints[0] != 1) break;
                    this.mPhone.setNetworkSelectionModeAutomatic(null);
                    break;
                }
                this.log("Unable to getNetworkSelectionMode");
                break;
            }
            case 10: {
                this.mCi.getSignalStrength(this.obtainMessage(3));
                break;
            }
            case 11: {
                AsyncResult ar = (AsyncResult)msg.obj;
                String nitzString = (String)((Object[])ar.result)[0];
                long nitzReceiveTime = (Long)((Object[])ar.result)[1];
                this.setTimeFromNITZString(nitzString, nitzReceiveTime);
                break;
            }
            case 12: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.mDontPollSignalStrength = true;
                this.onSignalStrengthResult(ar);
                break;
            }
            case 16: {
                this.log("EVENT_SIM_RECORDS_LOADED: what=" + msg.what);
                this.updatePhoneObject();
                this.updateOtaspState();
                if (!this.mPhone.isPhoneTypeGsm()) break;
                this.mCdnr.updateEfFromUsim((SIMRecords)this.mIccRecords);
                this.updateSpnDisplay();
                break;
            }
            case 18: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mRegStateManagers.get(1).requestNetworkRegistrationInfo(1, this.obtainMessage(15, null));
                break;
            }
            case 20: {
                AsyncResult ar = (AsyncResult)msg.obj;
                Message message = this.obtainMessage(21, ar.userObj);
                this.mCi.setPreferredNetworkType(this.mPreferredNetworkType, message);
                break;
            }
            case 21: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.userObj == null) break;
                AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                ((Message)ar.userObj).sendToTarget();
                break;
            }
            case 19: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.mPreferredNetworkType = ar.exception == null ? ((int[])ar.result)[0] : 7;
                Message message = this.obtainMessage(20, ar.userObj);
                int toggledNetworkType = 7;
                this.mCi.setPreferredNetworkType(toggledNetworkType, message);
                break;
            }
            case 22: {
                if (this.mPhone.isPhoneTypeGsm() && this.mSS != null && !this.isGprsConsistent(this.mSS.getDataRegState(), this.mSS.getVoiceRegState())) {
                    EventLog.writeEvent(50107, this.mSS.getOperatorNumeric(), ServiceStateTracker.getCidFromCellIdentity(this.mCellIdentity));
                    this.mReportedGprsNoReg = true;
                }
                this.mStartedGprsRegCheck = false;
                break;
            }
            case 23: {
                if (!this.mPhone.isPhoneTypeGsm()) break;
                this.log("EVENT_RESTRICTED_STATE_CHANGED");
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onRestrictedStateChanged(ar);
                break;
            }
            case 49: {
                int dds = SubscriptionManager.getDefaultDataSubscriptionId();
                ProxyController.getInstance().unregisterForAllDataDisconnected(dds, this);
                ServiceStateTracker serviceStateTracker = this;
                synchronized (serviceStateTracker) {
                    if (this.mPendingRadioPowerOffAfterDataOff) {
                        this.log("EVENT_ALL_DATA_DISCONNECTED, turn radio off now.");
                        this.hangupAndPowerOff();
                        this.mPendingRadioPowerOffAfterDataOff = false;
                    } else {
                        this.log("EVENT_ALL_DATA_DISCONNECTED is stale");
                    }
                    break;
                }
            }
            case 45: {
                this.log("EVENT_CHANGE_IMS_STATE:");
                this.setPowerStateToDesired();
                break;
            }
            case 48: {
                this.log("EVENT_IMS_CAPABILITY_CHANGED");
                this.updateSpnDisplay();
                this.mImsCapabilityChangedRegistrants.notifyRegistrants();
                break;
            }
            case 53: {
                this.log("EVENT_IMS_SERVICE_STATE_CHANGED");
                if (this.mSS.getState() == 0) break;
                this.mPhone.notifyServiceStateChanged(this.mPhone.getServiceState());
                break;
            }
            case 39: {
                this.handleCdmaSubscriptionSource(this.mCdmaSSM.getCdmaSubscriptionSource());
                break;
            }
            case 26: {
                if (this.mPhone.getLteOnCdmaMode() == 1) {
                    this.log("Receive EVENT_RUIM_READY");
                    this.pollState();
                } else {
                    this.log("Receive EVENT_RUIM_READY and Send Request getCDMASubscription.");
                    this.getSubscriptionInfoAndStartPollingThreads();
                }
                this.mCi.getNetworkSelectionMode(this.obtainMessage(14));
                break;
            }
            case 35: {
                this.updatePhoneObject();
                this.mCi.getNetworkSelectionMode(this.obtainMessage(14));
                this.getSubscriptionInfoAndStartPollingThreads();
                break;
            }
            case 34: {
                if (this.mPhone.isPhoneTypeGsm()) break;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                String[] cdmaSubscription = (String[])ar.result;
                if (cdmaSubscription != null && cdmaSubscription.length >= 5) {
                    this.mMdn = cdmaSubscription[0];
                    this.parseSidNid(cdmaSubscription[1], cdmaSubscription[2]);
                    this.mMin = cdmaSubscription[3];
                    this.mPrlVersion = cdmaSubscription[4];
                    this.log("GET_CDMA_SUBSCRIPTION: MDN=" + this.mMdn);
                    this.mIsMinInfoReady = true;
                    this.updateOtaspState();
                    this.notifyCdmaSubscriptionInfoReady();
                    if (!this.mIsSubscriptionFromRuim && this.mIccRecords != null) {
                        this.log("GET_CDMA_SUBSCRIPTION set imsi in mIccRecords");
                        this.mIccRecords.setImsi(this.getImsi());
                        break;
                    }
                    this.log("GET_CDMA_SUBSCRIPTION either mIccRecords is null or NV type device - not setting Imsi in mIccRecords");
                    break;
                }
                this.log("GET_CDMA_SUBSCRIPTION: error parsing cdmaSubscription params num=" + cdmaSubscription.length);
                break;
            }
            case 27: {
                if (this.mPhone.isPhoneTypeGsm()) break;
                this.log("EVENT_RUIM_RECORDS_LOADED: what=" + msg.what);
                this.mCdnr.updateEfFromRuim((RuimRecords)this.mIccRecords);
                this.updatePhoneObject();
                if (this.mPhone.isPhoneTypeCdma()) {
                    this.updateSpnDisplay();
                    break;
                }
                RuimRecords ruim = (RuimRecords)this.mIccRecords;
                if (ruim != null) {
                    this.mMdn = ruim.getMdn();
                    if (ruim.isProvisioned()) {
                        this.mMin = ruim.getMin();
                        this.parseSidNid(ruim.getSid(), ruim.getNid());
                        this.mPrlVersion = ruim.getPrlVersion();
                        this.mIsMinInfoReady = true;
                    }
                    this.updateOtaspState();
                    this.notifyCdmaSubscriptionInfoReady();
                }
                this.pollState();
                break;
            }
            case 37: {
                int[] ints;
                int otaStatus;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null || (otaStatus = (ints = (int[])ar.result)[0]) != 8 && otaStatus != 10) break;
                this.log("EVENT_OTA_PROVISION_STATUS_CHANGE: Complete, Reload MDN");
                this.mCi.getCDMASubscription(this.obtainMessage(34));
                break;
            }
            case 40: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                int[] ints = (int[])ar.result;
                this.mPrlVersion = Integer.toString(ints[0]);
                break;
            }
            case 51: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                boolean enable = (Boolean)ar.result;
                this.log("EVENT_RADIO_POWER_FROM_CARRIER: " + enable);
                this.setRadioPowerFromCarrier(enable);
                break;
            }
            case 55: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                List list = (List)ar.result;
                this.mPhone.notifyPhysicalChannelConfiguration(list);
                this.mLastPhysicalChannelConfigList = list;
                boolean hasChanged = this.updateNrFrequencyRangeFromPhysicalChannelConfigs(list, this.mSS);
                if (!(hasChanged |= this.updateNrStateFromPhysicalChannelConfigs(list, this.mSS)) && !RatRatcheter.updateBandwidths(this.getBandwidthsFromConfigs(list), this.mSS)) break;
                this.mPhone.notifyServiceStateChanged(this.mSS);
                break;
            }
            case 56: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar == null) {
                    this.loge("Invalid null response to getCellLocation!");
                    break;
                }
                Message rspRspMsg = (Message)ar.userObj;
                AsyncResult.forMessage(rspRspMsg, this.getCellLocation(), ar.exception);
                rspRspMsg.sendToTarget();
                break;
            }
            case 57: {
                this.onCarrierConfigChanged();
                break;
            }
            default: {
                this.log("Unhandled message with number: " + msg.what);
            }
        }
    }

    private boolean isSimAbsent() {
        UiccCard uiccCard;
        boolean simAbsent = this.mUiccController == null ? true : ((uiccCard = this.mUiccController.getUiccCard(this.mPhone.getPhoneId())) == null ? true : uiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_ABSENT);
        return simAbsent;
    }

    private int[] getBandwidthsFromConfigs(List<PhysicalChannelConfig> list) {
        return list.stream().map(PhysicalChannelConfig::getCellBandwidthDownlink).mapToInt(Integer::intValue).toArray();
    }

    protected boolean isSidsAllZeros() {
        if (this.mHomeSystemId != null) {
            for (int i = 0; i < this.mHomeSystemId.length; ++i) {
                if (this.mHomeSystemId[i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public ServiceState getServiceState() {
        return new ServiceState(this.mSS);
    }

    private boolean isHomeSid(int sid) {
        if (this.mHomeSystemId != null) {
            for (int i = 0; i < this.mHomeSystemId.length; ++i) {
                if (sid != this.mHomeSystemId[i]) continue;
                return true;
            }
        }
        return false;
    }

    public String getMdnNumber() {
        return this.mMdn;
    }

    public String getCdmaMin() {
        return this.mMin;
    }

    public String getPrlVersion() {
        return this.mPrlVersion;
    }

    public String getImsi() {
        String operatorNumeric = ((TelephonyManager)this.mPhone.getContext().getSystemService("phone")).getSimOperatorNumericForPhone(this.mPhone.getPhoneId());
        if (!TextUtils.isEmpty(operatorNumeric) && this.getCdmaMin() != null) {
            return operatorNumeric + this.getCdmaMin();
        }
        return null;
    }

    public boolean isMinInfoReady() {
        return this.mIsMinInfoReady;
    }

    public int getOtasp() {
        int provisioningState;
        if (!this.mPhone.getIccRecordsLoaded()) {
            this.log("getOtasp: otasp uninitialized due to sim not loaded");
            return 0;
        }
        if (this.mPhone.isPhoneTypeGsm()) {
            this.log("getOtasp: otasp not needed for GSM");
            return 3;
        }
        if (this.mIsSubscriptionFromRuim && this.mMin == null) {
            return 2;
        }
        if (this.mMin == null || this.mMin.length() < 6) {
            this.log("getOtasp: bad mMin='" + this.mMin + "'");
            provisioningState = 1;
        } else {
            provisioningState = this.mMin.equals(UNACTIVATED_MIN_VALUE) || this.mMin.substring(0, 6).equals(UNACTIVATED_MIN2_VALUE) || SystemProperties.getBoolean("test_cdma_setup", false) ? 2 : 3;
        }
        this.log("getOtasp: state=" + provisioningState);
        return provisioningState;
    }

    protected void parseSidNid(String sidStr, String nidStr) {
        int i;
        if (sidStr != null) {
            String[] sid = sidStr.split(",");
            this.mHomeSystemId = new int[sid.length];
            for (i = 0; i < sid.length; ++i) {
                try {
                    this.mHomeSystemId[i] = Integer.parseInt(sid[i]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    this.loge("error parsing system id: " + ex);
                }
            }
        }
        this.log("CDMA_SUBSCRIPTION: SID=" + sidStr);
        if (nidStr != null) {
            String[] nid = nidStr.split(",");
            this.mHomeNetworkId = new int[nid.length];
            for (i = 0; i < nid.length; ++i) {
                try {
                    this.mHomeNetworkId[i] = Integer.parseInt(nid[i]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    this.loge("CDMA_SUBSCRIPTION: error parsing network id: " + ex);
                }
            }
        }
        this.log("CDMA_SUBSCRIPTION: NID=" + nidStr);
    }

    @UnsupportedAppUsage
    protected void updateOtaspState() {
        int otaspMode = this.getOtasp();
        int oldOtaspMode = this.mCurrentOtaspMode;
        this.mCurrentOtaspMode = otaspMode;
        if (oldOtaspMode != this.mCurrentOtaspMode) {
            this.log("updateOtaspState: call notifyOtaspChanged old otaspMode=" + oldOtaspMode + " new otaspMode=" + this.mCurrentOtaspMode);
            this.mPhone.notifyOtaspChanged(this.mCurrentOtaspMode);
        }
    }

    protected Phone getPhone() {
        return this.mPhone;
    }

    protected void handlePollStateResult(int what, AsyncResult ar) {
        if (ar.userObj != this.mPollingContext) {
            return;
        }
        if (ar.exception != null) {
            CommandException.Error err = null;
            if (ar.exception instanceof IllegalStateException) {
                this.log("handlePollStateResult exception " + ar.exception);
            }
            if (ar.exception instanceof CommandException) {
                err = ((CommandException)ar.exception).getCommandError();
            }
            if (err == CommandException.Error.RADIO_NOT_AVAILABLE) {
                this.cancelPollState();
                return;
            }
            if (err != CommandException.Error.OP_NOT_ALLOWED_BEFORE_REG_NW) {
                this.loge("RIL implementation has returned an error where it must succeed" + ar.exception);
            }
        } else {
            try {
                this.handlePollStateResultMessage(what, ar);
            }
            catch (RuntimeException ex) {
                this.loge("Exception while polling service state. Probably malformed RIL response." + ex);
            }
        }
        this.mPollingContext[0] = this.mPollingContext[0] - 1;
        if (this.mPollingContext[0] == 0) {
            this.mNewSS.setEmergencyOnly(this.mEmergencyOnly);
            this.combinePsRegistrationStates(this.mNewSS);
            this.updateOperatorNameForServiceState(this.mNewSS);
            if (this.mPhone.isPhoneTypeGsm()) {
                this.updateRoamingState();
            } else {
                int dataRat;
                boolean isRoamingBetweenOperators;
                boolean namMatch = false;
                if (!this.isSidsAllZeros() && this.isHomeSid(this.mNewSS.getCdmaSystemId())) {
                    namMatch = true;
                }
                if (this.mIsSubscriptionFromRuim && (isRoamingBetweenOperators = this.isRoamingBetweenOperators(this.mNewSS.getVoiceRoaming(), this.mNewSS)) != this.mNewSS.getVoiceRoaming()) {
                    this.log("isRoamingBetweenOperators=" + isRoamingBetweenOperators + ". Override CDMA voice roaming to " + isRoamingBetweenOperators);
                    this.mNewSS.setVoiceRoaming(isRoamingBetweenOperators);
                }
                if (ServiceState.isCdma(dataRat = this.mNewSS.getRilDataRadioTechnology())) {
                    boolean isVoiceInService;
                    boolean bl = isVoiceInService = this.mNewSS.getVoiceRegState() == 0;
                    if (isVoiceInService) {
                        boolean isVoiceRoaming = this.mNewSS.getVoiceRoaming();
                        if (this.mNewSS.getDataRoaming() != isVoiceRoaming) {
                            this.log("Data roaming != Voice roaming. Override data roaming to " + isVoiceRoaming);
                            this.mNewSS.setDataRoaming(isVoiceRoaming);
                        }
                    } else {
                        boolean isRoamIndForHomeSystem = this.isRoamIndForHomeSystem(this.mRoamingIndicator);
                        if (this.mNewSS.getDataRoaming() == isRoamIndForHomeSystem) {
                            this.log("isRoamIndForHomeSystem=" + isRoamIndForHomeSystem + ", override data roaming to " + !isRoamIndForHomeSystem);
                            this.mNewSS.setDataRoaming(!isRoamIndForHomeSystem);
                        }
                    }
                }
                this.mNewSS.setCdmaDefaultRoamingIndicator(this.mDefaultRoamingIndicator);
                this.mNewSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
                boolean isPrlLoaded = true;
                if (TextUtils.isEmpty(this.mPrlVersion)) {
                    isPrlLoaded = false;
                }
                if (!isPrlLoaded || this.mNewSS.getRilVoiceRadioTechnology() == 0) {
                    this.log("Turn off roaming indicator if !isPrlLoaded or voice RAT is unknown");
                    this.mNewSS.setCdmaRoamingIndicator(1);
                } else if (!this.isSidsAllZeros()) {
                    if (!namMatch && !this.mIsInPrl) {
                        this.mNewSS.setCdmaRoamingIndicator(this.mDefaultRoamingIndicator);
                    } else if (namMatch && !this.mIsInPrl) {
                        if (ServiceState.isLte(this.mNewSS.getRilVoiceRadioTechnology())) {
                            this.log("Turn off roaming indicator as voice is LTE");
                            this.mNewSS.setCdmaRoamingIndicator(1);
                        } else {
                            this.mNewSS.setCdmaRoamingIndicator(2);
                        }
                    } else if (!namMatch && this.mIsInPrl) {
                        this.mNewSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
                    } else if (this.mRoamingIndicator <= 2) {
                        this.mNewSS.setCdmaRoamingIndicator(1);
                    } else {
                        this.mNewSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
                    }
                }
                int roamingIndicator = this.mNewSS.getCdmaRoamingIndicator();
                this.mNewSS.setCdmaEriIconIndex(this.mEriManager.getCdmaEriIconIndex(roamingIndicator, this.mDefaultRoamingIndicator));
                this.mNewSS.setCdmaEriIconMode(this.mEriManager.getCdmaEriIconMode(roamingIndicator, this.mDefaultRoamingIndicator));
                this.log("Set CDMA Roaming Indicator to: " + this.mNewSS.getCdmaRoamingIndicator() + ". voiceRoaming = " + this.mNewSS.getVoiceRoaming() + ". dataRoaming = " + this.mNewSS.getDataRoaming() + ", isPrlLoaded = " + isPrlLoaded + ". namMatch = " + namMatch + " , mIsInPrl = " + this.mIsInPrl + ", mRoamingIndicator = " + this.mRoamingIndicator + ", mDefaultRoamingIndicator= " + this.mDefaultRoamingIndicator);
            }
            this.pollStateDone();
        }
    }

    private boolean isRoamingBetweenOperators(boolean cdmaRoaming, ServiceState s) {
        return cdmaRoaming && !this.isSameOperatorNameFromSimAndSS(s);
    }

    private boolean isNrStateChanged(NetworkRegistrationInfo oldRegState, NetworkRegistrationInfo newRegState) {
        if (oldRegState == null || newRegState == null) {
            return oldRegState != newRegState;
        }
        return oldRegState.getNrState() != newRegState.getNrState();
    }

    private boolean updateNrFrequencyRangeFromPhysicalChannelConfigs(List<PhysicalChannelConfig> physicalChannelConfigs, ServiceState ss) {
        int newFrequencyRange = -1;
        if (physicalChannelConfigs != null) {
            DcTracker dcTracker = this.mPhone.getDcTracker(1);
            block0: for (PhysicalChannelConfig config : physicalChannelConfigs) {
                int[] contextIds;
                if (!this.isNrPhysicalChannelConfig(config)) continue;
                for (int cid : contextIds = config.getContextIds()) {
                    DataConnection dc = dcTracker.getDataConnectionByContextId(cid);
                    if (dc == null || !dc.getNetworkCapabilities().hasCapability(12)) continue;
                    newFrequencyRange = ServiceState.getBetterNRFrequencyRange(newFrequencyRange, config.getFrequencyRange());
                    continue block0;
                }
            }
        }
        boolean hasChanged = newFrequencyRange != ss.getNrFrequencyRange();
        ss.setNrFrequencyRange(newFrequencyRange);
        return hasChanged;
    }

    private boolean updateNrStateFromPhysicalChannelConfigs(List<PhysicalChannelConfig> configs, ServiceState ss) {
        NetworkRegistrationInfo regInfo = ss.getNetworkRegistrationInfo(2, 1);
        if (regInfo == null || configs == null) {
            return false;
        }
        boolean hasNrSecondaryServingCell = false;
        for (PhysicalChannelConfig config : configs) {
            if (!this.isNrPhysicalChannelConfig(config) || config.getConnectionStatus() != 2) continue;
            hasNrSecondaryServingCell = true;
            break;
        }
        int newNrState = regInfo.getNrState();
        if (hasNrSecondaryServingCell) {
            if (regInfo.getNrState() == 2) {
                newNrState = 3;
            }
        } else if (regInfo.getNrState() == 3) {
            newNrState = 2;
        }
        boolean hasChanged = newNrState != regInfo.getNrState();
        regInfo.setNrState(newNrState);
        ss.addNetworkRegistrationInfo(regInfo);
        return hasChanged;
    }

    private boolean isNrPhysicalChannelConfig(PhysicalChannelConfig config) {
        return config.getRat() == 20;
    }

    private void combinePsRegistrationStates(ServiceState serviceState) {
        NetworkRegistrationInfo wlanPsRegState = serviceState.getNetworkRegistrationInfo(2, 2);
        NetworkRegistrationInfo wwanPsRegState = serviceState.getNetworkRegistrationInfo(2, 1);
        boolean isIwlanPreferred = this.mTransportManager.isAnyApnPreferredOnIwlan();
        serviceState.setIwlanPreferred(isIwlanPreferred);
        if (wlanPsRegState != null && wlanPsRegState.getAccessNetworkTechnology() == 18 && wlanPsRegState.getRegistrationState() == 1 && isIwlanPreferred) {
            serviceState.setDataRegState(0);
        } else if (wwanPsRegState != null) {
            int regState = wwanPsRegState.getRegistrationState();
            serviceState.setDataRegState(this.regCodeToServiceState(regState));
        }
        this.log("combinePsRegistrationStates: " + serviceState);
    }

    void handlePollStateResultMessage(int what, AsyncResult ar) {
        switch (what) {
            case 4: {
                NetworkRegistrationInfo networkRegState = (NetworkRegistrationInfo)ar.result;
                VoiceSpecificRegistrationInfo voiceSpecificStates = networkRegState.getVoiceSpecificInfo();
                int registrationState = networkRegState.getRegistrationState();
                int cssIndicator = voiceSpecificStates.cssSupported ? 1 : 0;
                int newVoiceRat = ServiceState.networkTypeToRilRadioTechnology(networkRegState.getAccessNetworkTechnology());
                this.mNewSS.setVoiceRegState(this.regCodeToServiceState(registrationState));
                this.mNewSS.setCssIndicator(cssIndicator);
                this.mNewSS.addNetworkRegistrationInfo(networkRegState);
                this.setPhyCellInfoFromCellIdentity(this.mNewSS, networkRegState.getCellIdentity());
                int reasonForDenial = networkRegState.getRejectCause();
                this.mEmergencyOnly = networkRegState.isEmergencyEnabled();
                if (this.mPhone.isPhoneTypeGsm()) {
                    this.mGsmRoaming = this.regCodeIsRoaming(registrationState);
                    this.mNewRejectCode = reasonForDenial;
                    boolean bl = this.mPhone.getContext().getResources().getBoolean(17891570);
                } else {
                    int roamingIndicator = voiceSpecificStates.roamingIndicator;
                    int systemIsInPrl = voiceSpecificStates.systemIsInPrl;
                    int defaultRoamingIndicator = voiceSpecificStates.defaultRoamingIndicator;
                    this.mRegistrationState = registrationState;
                    boolean cdmaRoaming = this.regCodeIsRoaming(registrationState) && !this.isRoamIndForHomeSystem(roamingIndicator);
                    this.mNewSS.setVoiceRoaming(cdmaRoaming);
                    this.mRoamingIndicator = roamingIndicator;
                    this.mIsInPrl = systemIsInPrl != 0;
                    this.mDefaultRoamingIndicator = defaultRoamingIndicator;
                    int systemId = 0;
                    int networkId = 0;
                    CellIdentity cellIdentity = networkRegState.getCellIdentity();
                    if (cellIdentity != null && cellIdentity.getType() == 2) {
                        systemId = ((CellIdentityCdma)cellIdentity).getSystemId();
                        networkId = ((CellIdentityCdma)cellIdentity).getNetworkId();
                    }
                    this.mNewSS.setCdmaSystemAndNetworkId(systemId, networkId);
                    this.mRegistrationDeniedReason = reasonForDenial == 0 ? REGISTRATION_DENIED_GEN : (reasonForDenial == 1 ? REGISTRATION_DENIED_AUTH : "");
                    if (this.mRegistrationState == 3) {
                        this.log("Registration denied, " + this.mRegistrationDeniedReason);
                    }
                }
                this.mNewCellIdentity = networkRegState.getCellIdentity();
                this.log("handlePollStateResultMessage: CS cellular. " + networkRegState);
                break;
            }
            case 6: {
                NetworkRegistrationInfo networkRegState = (NetworkRegistrationInfo)ar.result;
                this.mNewSS.addNetworkRegistrationInfo(networkRegState);
                this.log("handlePollStateResultMessage: PS IWLAN. " + networkRegState);
                break;
            }
            case 5: {
                NetworkRegistrationInfo networkRegState = (NetworkRegistrationInfo)ar.result;
                this.mNewSS.addNetworkRegistrationInfo(networkRegState);
                DataSpecificRegistrationInfo dataSpecificStates = networkRegState.getDataSpecificInfo();
                int registrationState = networkRegState.getRegistrationState();
                int serviceState = this.regCodeToServiceState(registrationState);
                int newDataRat = ServiceState.networkTypeToRilRadioTechnology(networkRegState.getAccessNetworkTechnology());
                this.log("handlePollStateResultMessage: PS cellular. " + networkRegState);
                if (serviceState == 1) {
                    this.mLastPhysicalChannelConfigList = null;
                    this.updateNrFrequencyRangeFromPhysicalChannelConfigs(null, this.mNewSS);
                }
                this.updateNrStateFromPhysicalChannelConfigs(this.mLastPhysicalChannelConfigList, this.mNewSS);
                this.setPhyCellInfoFromCellIdentity(this.mNewSS, networkRegState.getCellIdentity());
                if (this.mPhone.isPhoneTypeGsm()) {
                    this.mNewReasonDataDenied = networkRegState.getRejectCause();
                    this.mNewMaxDataCalls = dataSpecificStates.maxDataCalls;
                    this.mDataRoaming = this.regCodeIsRoaming(registrationState);
                } else if (this.mPhone.isPhoneTypeCdma()) {
                    boolean isDataRoaming = this.regCodeIsRoaming(registrationState);
                    this.mNewSS.setDataRoaming(isDataRoaming);
                } else {
                    int oldDataRAT = this.mSS.getRilDataRadioTechnology();
                    if (oldDataRAT == 0 && newDataRat != 0 || ServiceState.isCdma(oldDataRAT) && ServiceState.isLte(newDataRat) || ServiceState.isLte(oldDataRAT) && ServiceState.isCdma(newDataRat)) {
                        this.mCi.getSignalStrength(this.obtainMessage(3));
                    }
                    boolean isDataRoaming = this.regCodeIsRoaming(registrationState);
                    this.mNewSS.setDataRoaming(isDataRoaming);
                }
                this.updateServiceStateLteEarfcnBoost(this.mNewSS, this.getLteEarfcn(networkRegState.getCellIdentity()));
                break;
            }
            case 7: {
                String brandOverride = this.getOperatorBrandOverride();
                this.mCdnr.updateEfForBrandOverride(brandOverride);
                if (this.mPhone.isPhoneTypeGsm()) {
                    String[] opNames = (String[])ar.result;
                    if (opNames == null || opNames.length < 3) break;
                    this.mNewSS.setOperatorAlphaLongRaw(opNames[0]);
                    this.mNewSS.setOperatorAlphaShortRaw(opNames[1]);
                    if (brandOverride != null) {
                        this.log("EVENT_POLL_STATE_OPERATOR: use brandOverride=" + brandOverride);
                        this.mNewSS.setOperatorName(brandOverride, brandOverride, opNames[2]);
                        break;
                    }
                    this.mNewSS.setOperatorName(opNames[0], opNames[1], opNames[2]);
                    break;
                }
                String[] opNames = (String[])ar.result;
                if (opNames != null && opNames.length >= 3) {
                    if (opNames[2] == null || opNames[2].length() < 5 || "00000".equals(opNames[2])) {
                        opNames[2] = SystemProperties.get("ro.cdma.home.operator.numeric", "00000");
                        this.log("RIL_REQUEST_OPERATOR.response[2], the numeric,  is bad. Using SystemProperties 'ro.cdma.home.operator.numeric'= " + opNames[2]);
                    }
                    if (!this.mIsSubscriptionFromRuim) {
                        this.mNewSS.setOperatorName(opNames[0], opNames[1], opNames[2]);
                        break;
                    }
                    if (brandOverride != null) {
                        this.mNewSS.setOperatorName(brandOverride, brandOverride, opNames[2]);
                        break;
                    }
                    this.mNewSS.setOperatorName(opNames[0], opNames[1], opNames[2]);
                    break;
                }
                this.log("EVENT_POLL_STATE_OPERATOR_CDMA: error parsing opNames");
                break;
            }
            case 14: {
                int[] ints = (int[])ar.result;
                this.mNewSS.setIsManualSelection(ints[0] == 1);
                if (ints[0] != 1 || !this.mPhone.shouldForceAutoNetworkSelect()) break;
                this.mPhone.setNetworkSelectionModeAutomatic(null);
                this.log(" Forcing Automatic Network Selection, manual selection is not allowed");
                break;
            }
            default: {
                this.loge("handlePollStateResultMessage: Unexpected RIL response received: " + what);
            }
        }
    }

    private static boolean isValidLteBandwidthKhz(int bandwidth) {
        switch (bandwidth) {
            case 1400: 
            case 3000: 
            case 5000: 
            case 10000: 
            case 15000: 
            case 20000: {
                return true;
            }
        }
        return false;
    }

    private static int getCidFromCellIdentity(CellIdentity id2) {
        if (id2 == null) {
            return -1;
        }
        int cid = -1;
        switch (id2.getType()) {
            case 1: {
                cid = ((CellIdentityGsm)id2).getCid();
                break;
            }
            case 4: {
                cid = ((CellIdentityWcdma)id2).getCid();
                break;
            }
            case 5: {
                cid = ((CellIdentityTdscdma)id2).getCid();
                break;
            }
            case 3: {
                cid = ((CellIdentityLte)id2).getCi();
                break;
            }
        }
        if (cid == Integer.MAX_VALUE) {
            cid = -1;
        }
        return cid;
    }

    private void setPhyCellInfoFromCellIdentity(ServiceState ss, CellIdentity cellIdentity) {
        if (cellIdentity == null) {
            this.log("Could not set ServiceState channel number. CellIdentity null");
            return;
        }
        ss.setChannelNumber(cellIdentity.getChannelNumber());
        if (cellIdentity instanceof CellIdentityLte) {
            CellIdentityLte cl = (CellIdentityLte)cellIdentity;
            int[] bandwidths = null;
            if (!ArrayUtils.isEmpty(this.mLastPhysicalChannelConfigList)) {
                for (int bw : bandwidths = this.getBandwidthsFromConfigs(this.mLastPhysicalChannelConfigList)) {
                    if (ServiceStateTracker.isValidLteBandwidthKhz(bw)) continue;
                    this.loge("Invalid LTE Bandwidth in RegistrationState, " + bw);
                    bandwidths = null;
                    break;
                }
            }
            if (bandwidths == null || bandwidths.length == 1) {
                int cbw = cl.getBandwidth();
                if (ServiceStateTracker.isValidLteBandwidthKhz(cbw)) {
                    bandwidths = new int[]{cbw};
                } else if (cbw != Integer.MAX_VALUE) {
                    this.loge("Invalid LTE Bandwidth in RegistrationState, " + cbw);
                }
            }
            if (bandwidths != null) {
                ss.setCellBandwidths(bandwidths);
            }
        }
    }

    private boolean isRoamIndForHomeSystem(int roamInd) {
        PersistableBundle config = this.getCarrierConfig();
        int[] homeRoamIndicators = config.getIntArray("cdma_enhanced_roaming_indicator_for_home_network_int_array");
        this.log("isRoamIndForHomeSystem: homeRoamIndicators=" + Arrays.toString(homeRoamIndicators));
        if (homeRoamIndicators != null) {
            for (int homeRoamInd : homeRoamIndicators) {
                if (homeRoamInd != roamInd) continue;
                return true;
            }
            this.log("isRoamIndForHomeSystem: No match found against list for roamInd=" + roamInd);
            return false;
        }
        this.log("isRoamIndForHomeSystem: No list found");
        return false;
    }

    @UnsupportedAppUsage
    protected void updateRoamingState() {
        PersistableBundle bundle = this.getCarrierConfig();
        if (this.mPhone.isPhoneTypeGsm()) {
            boolean roaming;
            boolean bl = roaming = this.mGsmRoaming || this.mDataRoaming;
            if (this.mGsmRoaming && !this.isOperatorConsideredRoaming(this.mNewSS) && (this.isSameNamedOperators(this.mNewSS) || this.isOperatorConsideredNonRoaming(this.mNewSS))) {
                this.log("updateRoamingState: resource override set non roaming.isSameNamedOperators=" + this.isSameNamedOperators(this.mNewSS) + ",isOperatorConsideredNonRoaming=" + this.isOperatorConsideredNonRoaming(this.mNewSS));
                roaming = false;
            }
            if (this.alwaysOnHomeNetwork(bundle)) {
                this.log("updateRoamingState: carrier config override always on home network");
                roaming = false;
            } else if (this.isNonRoamingInGsmNetwork(bundle, this.mNewSS.getOperatorNumeric())) {
                this.log("updateRoamingState: carrier config override set non roaming:" + this.mNewSS.getOperatorNumeric());
                roaming = false;
            } else if (this.isRoamingInGsmNetwork(bundle, this.mNewSS.getOperatorNumeric())) {
                this.log("updateRoamingState: carrier config override set roaming:" + this.mNewSS.getOperatorNumeric());
                roaming = true;
            }
            this.mNewSS.setVoiceRoaming(roaming);
            this.mNewSS.setDataRoaming(roaming);
        } else {
            String systemId = Integer.toString(this.mNewSS.getCdmaSystemId());
            if (this.alwaysOnHomeNetwork(bundle)) {
                this.log("updateRoamingState: carrier config override always on home network");
                this.setRoamingOff();
            } else if (this.isNonRoamingInGsmNetwork(bundle, this.mNewSS.getOperatorNumeric()) || this.isNonRoamingInCdmaNetwork(bundle, systemId)) {
                this.log("updateRoamingState: carrier config override set non-roaming:" + this.mNewSS.getOperatorNumeric() + ", " + systemId);
                this.setRoamingOff();
            } else if (this.isRoamingInGsmNetwork(bundle, this.mNewSS.getOperatorNumeric()) || this.isRoamingInCdmaNetwork(bundle, systemId)) {
                this.log("updateRoamingState: carrier config override set roaming:" + this.mNewSS.getOperatorNumeric() + ", " + systemId);
                this.setRoamingOn();
            }
            if (Build.IS_DEBUGGABLE && SystemProperties.getBoolean(PROP_FORCE_ROAMING, false)) {
                this.mNewSS.setVoiceRoaming(true);
                this.mNewSS.setDataRoaming(true);
            }
        }
    }

    private void setRoamingOn() {
        this.mNewSS.setVoiceRoaming(true);
        this.mNewSS.setDataRoaming(true);
        this.mNewSS.setCdmaEriIconIndex(0);
        this.mNewSS.setCdmaEriIconMode(0);
    }

    private void setRoamingOff() {
        this.mNewSS.setVoiceRoaming(false);
        this.mNewSS.setDataRoaming(false);
        this.mNewSS.setCdmaEriIconIndex(1);
    }

    private void updateOperatorNameFromCarrierConfig() {
        if (!this.mPhone.isPhoneTypeGsm() && !this.mSS.getRoaming()) {
            PersistableBundle config;
            boolean hasBrandOverride;
            boolean bl = hasBrandOverride = this.mUiccController.getUiccCard(this.getPhoneId()) != null && this.mUiccController.getUiccCard(this.getPhoneId()).getOperatorBrandOverride() != null;
            if (!hasBrandOverride && (config = this.getCarrierConfig()).getBoolean("cdma_home_registered_plmn_name_override_bool")) {
                String operator = config.getString("cdma_home_registered_plmn_name_string");
                this.log("updateOperatorNameFromCarrierConfig: changing from " + this.mSS.getOperatorAlpha() + " to " + operator);
                this.mSS.setOperatorName(operator, operator, this.mSS.getOperatorNumeric());
            }
        }
    }

    private void notifySpnDisplayUpdate(CarrierDisplayNameData data) {
        int subId = this.mPhone.getSubId();
        if (!(this.mSubId == subId && data.shouldShowPlmn() == this.mCurShowPlmn && data.shouldShowSpn() == this.mCurShowSpn && TextUtils.equals(data.getSpn(), this.mCurSpn) && TextUtils.equals(data.getDataSpn(), this.mCurDataSpn) && TextUtils.equals(data.getPlmn(), this.mCurPlmn))) {
            String log = String.format("updateSpnDisplay: changed sending intent, rule=%d, showPlmn='%b', plmn='%s', showSpn='%b', spn='%s', dataSpn='%s', subId='%d'", this.getCarrierNameDisplayBitmask(this.mSS), data.shouldShowPlmn(), data.getPlmn(), data.shouldShowSpn(), data.getSpn(), data.getDataSpn(), subId);
            this.mCdnrLogs.log(log);
            this.log("updateSpnDisplay: " + log);
            Intent intent = new Intent("android.provider.Telephony.SPN_STRINGS_UPDATED");
            intent.putExtra("showSpn", data.shouldShowSpn());
            intent.putExtra("spn", data.getSpn());
            intent.putExtra("spnData", data.getDataSpn());
            intent.putExtra("showPlmn", data.shouldShowPlmn());
            intent.putExtra("plmn", data.getPlmn());
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
            this.mPhone.getContext().sendStickyBroadcastAsUser(intent, UserHandle.ALL);
            if (!this.mSubscriptionController.setPlmnSpn(this.mPhone.getPhoneId(), data.shouldShowPlmn(), data.getPlmn(), data.shouldShowSpn(), data.getSpn())) {
                this.mSpnUpdatePending = true;
            }
        }
        this.mSubId = subId;
        this.mCurShowSpn = data.shouldShowSpn();
        this.mCurShowPlmn = data.shouldShowPlmn();
        this.mCurSpn = data.getSpn();
        this.mCurDataSpn = data.getDataSpn();
        this.mCurPlmn = data.getPlmn();
    }

    private void updateSpnDisplayCdnr() {
        this.log("updateSpnDisplayCdnr+");
        CarrierDisplayNameData data = this.mCdnr.getCarrierDisplayNameData();
        this.notifySpnDisplayUpdate(data);
        this.log("updateSpnDisplayCdnr-");
    }

    @UnsupportedAppUsage
    @VisibleForTesting
    public void updateSpnDisplay() {
        PersistableBundle config = this.getCarrierConfig();
        if (config.getBoolean("enable_carrier_display_name_resolver_bool")) {
            this.updateSpnDisplayCdnr();
        } else {
            this.updateSpnDisplayLegacy();
        }
    }

    private void updateSpnDisplayLegacy() {
        this.log("updateSpnDisplayLegacy+");
        String spn = null;
        String dataSpn = null;
        boolean showSpn = false;
        String plmn = null;
        boolean showPlmn = false;
        String wfcVoiceSpnFormat = null;
        String wfcDataSpnFormat = null;
        String wfcFlightSpnFormat = null;
        int combinedRegState = this.getCombinedRegState(this.mSS);
        if (this.mPhone.getImsPhone() != null && this.mPhone.getImsPhone().isWifiCallingEnabled() && combinedRegState == 0) {
            int voiceIdx = 0;
            int dataIdx = 0;
            int flightModeIdx = -1;
            boolean useRootLocale = false;
            PersistableBundle bundle = this.getCarrierConfig();
            voiceIdx = bundle.getInt("wfc_spn_format_idx_int");
            dataIdx = bundle.getInt("wfc_data_spn_format_idx_int");
            flightModeIdx = bundle.getInt("wfc_flight_mode_spn_format_idx_int");
            useRootLocale = bundle.getBoolean("wfc_spn_use_root_locale");
            String[] wfcSpnFormats = SubscriptionManager.getResourcesForSubId(this.mPhone.getContext(), this.mPhone.getSubId(), useRootLocale).getStringArray(17236116);
            if (voiceIdx < 0 || voiceIdx >= wfcSpnFormats.length) {
                this.loge("updateSpnDisplay: KEY_WFC_SPN_FORMAT_IDX_INT out of bounds: " + voiceIdx);
                voiceIdx = 0;
            }
            if (dataIdx < 0 || dataIdx >= wfcSpnFormats.length) {
                this.loge("updateSpnDisplay: KEY_WFC_DATA_SPN_FORMAT_IDX_INT out of bounds: " + dataIdx);
                dataIdx = 0;
            }
            if (flightModeIdx < 0 || flightModeIdx >= wfcSpnFormats.length) {
                flightModeIdx = voiceIdx;
            }
            wfcVoiceSpnFormat = wfcSpnFormats[voiceIdx];
            wfcDataSpnFormat = wfcSpnFormats[dataIdx];
            wfcFlightSpnFormat = wfcSpnFormats[flightModeIdx];
        }
        if (this.mPhone.isPhoneTypeGsm()) {
            IccRecords iccRecords = this.mIccRecords;
            int rule = this.getCarrierNameDisplayBitmask(this.mSS);
            boolean noService = false;
            if (combinedRegState == 1 || combinedRegState == 2) {
                boolean forceDisplayNoService;
                showPlmn = true;
                boolean bl = forceDisplayNoService = this.mPhone.getContext().getResources().getBoolean(17891414) && !this.mIsSimReady;
                if (this.mEmergencyOnly && !forceDisplayNoService) {
                    plmn = Resources.getSystem().getText(17039896).toString();
                } else {
                    plmn = Resources.getSystem().getText(17040246).toString();
                    noService = true;
                }
                this.log("updateSpnDisplay: radio is on but out of service, set plmn='" + plmn + "'");
            } else if (combinedRegState == 0) {
                plmn = this.mSS.getOperatorAlpha();
                showPlmn = !TextUtils.isEmpty(plmn) && (rule & 2) == 2;
                this.log("updateSpnDisplay: rawPlmn = " + plmn);
            } else {
                showPlmn = true;
                plmn = Resources.getSystem().getText(17040246).toString();
                this.log("updateSpnDisplay: radio is off w/ showPlmn=" + showPlmn + " plmn=" + plmn);
            }
            dataSpn = spn = this.getServiceProviderName();
            showSpn = !noService && !TextUtils.isEmpty(spn) && (rule & 1) == 1;
            this.log("updateSpnDisplay: rawSpn = " + spn);
            if (!(TextUtils.isEmpty(spn) || TextUtils.isEmpty(wfcVoiceSpnFormat) || TextUtils.isEmpty(wfcDataSpnFormat))) {
                if (this.mSS.getVoiceRegState() == 3) {
                    wfcVoiceSpnFormat = wfcFlightSpnFormat;
                }
                String originalSpn = spn.trim();
                spn = String.format(wfcVoiceSpnFormat, originalSpn);
                dataSpn = String.format(wfcDataSpnFormat, originalSpn);
                showSpn = true;
                showPlmn = false;
            } else if (!TextUtils.isEmpty(plmn) && !TextUtils.isEmpty(wfcVoiceSpnFormat)) {
                String originalPlmn = plmn.trim();
                plmn = String.format(wfcVoiceSpnFormat, originalPlmn);
            } else if (this.mSS.getVoiceRegState() == 3 || showPlmn && TextUtils.equals(spn, plmn)) {
                spn = null;
                showSpn = false;
            }
        } else {
            String eriText = this.getOperatorNameFromEri();
            if (eriText != null) {
                this.mSS.setOperatorAlphaLong(eriText);
            }
            this.updateOperatorNameFromCarrierConfig();
            plmn = this.mSS.getOperatorAlpha();
            this.log("updateSpnDisplay: cdma rawPlmn = " + plmn);
            boolean bl = showPlmn = plmn != null;
            if (!TextUtils.isEmpty(plmn) && !TextUtils.isEmpty(wfcVoiceSpnFormat)) {
                String originalPlmn = plmn.trim();
                plmn = String.format(wfcVoiceSpnFormat, originalPlmn);
            } else if (this.mCi.getRadioState() == 0) {
                this.log("updateSpnDisplay: overwriting plmn from " + plmn + " to null as radio state is off");
                plmn = null;
            }
            if (combinedRegState == 1) {
                plmn = Resources.getSystem().getText(17040246).toString();
                this.log("updateSpnDisplay: radio is on but out of svc, set plmn='" + plmn + "'");
            }
        }
        this.notifySpnDisplayUpdate(new CarrierDisplayNameData.Builder().setSpn(spn).setDataSpn(dataSpn).setShowSpn(showSpn).setPlmn(plmn).setShowPlmn(showPlmn).build());
        this.log("updateSpnDisplayLegacy-");
    }

    protected void setPowerStateToDesired() {
        AlarmManager am;
        Context context;
        String tmpLog = "mDeviceShuttingDown=" + this.mDeviceShuttingDown + ", mDesiredPowerState=" + this.mDesiredPowerState + ", getRadioState=" + this.mCi.getRadioState() + ", mPowerOffDelayNeed=" + this.mPowerOffDelayNeed + ", mAlarmSwitch=" + this.mAlarmSwitch + ", mRadioDisabledByCarrier=" + this.mRadioDisabledByCarrier;
        this.log(tmpLog);
        this.mRadioPowerLog.log(tmpLog);
        if (this.mPhone.isPhoneTypeGsm() && this.mAlarmSwitch) {
            this.log("mAlarmSwitch == true");
            context = this.mPhone.getContext();
            am = (AlarmManager)context.getSystemService("alarm");
            am.cancel(this.mRadioOffIntent);
            this.mAlarmSwitch = false;
        }
        if (this.mDesiredPowerState && !this.mRadioDisabledByCarrier && this.mCi.getRadioState() == 0) {
            this.mCi.setRadioPower(true, null);
        } else if ((!this.mDesiredPowerState || this.mRadioDisabledByCarrier) && this.mCi.getRadioState() == 1) {
            if (this.mPhone.isPhoneTypeGsm() && this.mPowerOffDelayNeed) {
                if (this.mImsRegistrationOnOff && !this.mAlarmSwitch) {
                    this.log("mImsRegistrationOnOff == true");
                    context = this.mPhone.getContext();
                    am = (AlarmManager)context.getSystemService("alarm");
                    Intent intent = new Intent(ACTION_RADIO_OFF);
                    this.mRadioOffIntent = PendingIntent.getBroadcast(context, 0, intent, 0);
                    this.mAlarmSwitch = true;
                    this.log("Alarm setting");
                    am.set(2, SystemClock.elapsedRealtime() + 3000L, this.mRadioOffIntent);
                } else {
                    this.powerOffRadioSafely();
                }
            } else {
                this.powerOffRadioSafely();
            }
        } else if (this.mDeviceShuttingDown && this.mCi.getRadioState() != 2) {
            this.mCi.requestShutdown(null);
        }
    }

    protected void onUpdateIccAvailability() {
        if (this.mUiccController == null) {
            return;
        }
        UiccCardApplication newUiccApplication = this.getUiccCardApplication();
        if (this.mUiccApplcation != newUiccApplication) {
            if (this.mIccRecords instanceof SIMRecords) {
                this.mCdnr.updateEfFromUsim(null);
            } else if (this.mIccRecords instanceof RuimRecords) {
                this.mCdnr.updateEfFromRuim(null);
            }
            if (this.mUiccApplcation != null) {
                this.log("Removing stale icc objects.");
                this.mUiccApplcation.unregisterForReady(this);
                if (this.mIccRecords != null) {
                    this.mIccRecords.unregisterForRecordsLoaded(this);
                }
                this.mIccRecords = null;
                this.mUiccApplcation = null;
            }
            if (newUiccApplication != null) {
                this.log("New card found");
                this.mUiccApplcation = newUiccApplication;
                this.mIccRecords = this.mUiccApplcation.getIccRecords();
                if (this.mPhone.isPhoneTypeGsm()) {
                    this.mUiccApplcation.registerForReady(this, 17, null);
                    if (this.mIccRecords != null) {
                        this.mIccRecords.registerForRecordsLoaded(this, 16, null);
                    }
                } else if (this.mIsSubscriptionFromRuim) {
                    this.mUiccApplcation.registerForReady(this, 26, null);
                    if (this.mIccRecords != null) {
                        this.mIccRecords.registerForRecordsLoaded(this, 27, null);
                    }
                }
            }
        }
    }

    private void logRoamingChange() {
        this.mRoamingLog.log(this.mSS.toString());
    }

    private void logAttachChange() {
        this.mAttachLog.log(this.mSS.toString());
    }

    private void logPhoneTypeChange() {
        this.mPhoneTypeLog.log(Integer.toString(this.mPhone.getPhoneType()));
    }

    private void logRatChange() {
        this.mRatLog.log(this.mSS.toString());
    }

    @UnsupportedAppUsage
    protected final void log(String s) {
        Rlog.d(LOG_TAG, "[" + this.mPhone.getPhoneId() + "] " + s);
    }

    @UnsupportedAppUsage
    protected final void loge(String s) {
        Rlog.e(LOG_TAG, "[" + this.mPhone.getPhoneId() + "] " + s);
    }

    @UnsupportedAppUsage
    public int getCurrentDataConnectionState() {
        return this.mSS.getDataRegState();
    }

    @UnsupportedAppUsage
    public boolean isConcurrentVoiceAndDataAllowed() {
        if (this.mSS.getCssIndicator() == 1) {
            return true;
        }
        if (this.mPhone.isPhoneTypeGsm()) {
            return this.mSS.getRilDataRadioTechnology() >= 3;
        }
        return false;
    }

    public void onImsServiceStateChanged() {
        this.sendMessage(this.obtainMessage(53));
    }

    public void setImsRegistrationState(boolean registered) {
        this.log("ImsRegistrationState - registered : " + registered);
        if (this.mImsRegistrationOnOff && !registered && this.mAlarmSwitch) {
            this.mImsRegistrationOnOff = registered;
            Context context = this.mPhone.getContext();
            AlarmManager am = (AlarmManager)context.getSystemService("alarm");
            am.cancel(this.mRadioOffIntent);
            this.mAlarmSwitch = false;
            this.sendMessage(this.obtainMessage(45));
            return;
        }
        this.mImsRegistrationOnOff = registered;
    }

    public void onImsCapabilityChanged() {
        this.sendMessage(this.obtainMessage(48));
    }

    public boolean isRadioOn() {
        return this.mCi.getRadioState() == 1;
    }

    @UnsupportedAppUsage
    public void pollState() {
        this.pollState(false);
    }

    private void modemTriggeredPollState() {
        this.pollState(true);
    }

    public void pollState(boolean modemTriggered) {
        this.mPollingContext = new int[1];
        this.mPollingContext[0] = 0;
        this.log("pollState: modemTriggered=" + modemTriggered);
        switch (this.mCi.getRadioState()) {
            case 2: {
                this.mNewSS.setStateOutOfService();
                this.mNewCellIdentity = null;
                this.setSignalStrengthDefaultValues();
                this.mNitzState.handleNetworkCountryCodeUnavailable();
                this.pollStateDone();
                break;
            }
            case 0: {
                this.mNewSS.setStateOff();
                this.mNewCellIdentity = null;
                this.setSignalStrengthDefaultValues();
                this.mNitzState.handleNetworkCountryCodeUnavailable();
                if (this.mDeviceShuttingDown || !modemTriggered && 18 != this.mSS.getRilDataRadioTechnology()) {
                    this.pollStateDone();
                    break;
                }
            }
            default: {
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getOperator(this.obtainMessage(7, this.mPollingContext));
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mRegStateManagers.get(1).requestNetworkRegistrationInfo(2, this.obtainMessage(5, this.mPollingContext));
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mRegStateManagers.get(1).requestNetworkRegistrationInfo(1, this.obtainMessage(4, this.mPollingContext));
                if (this.mRegStateManagers.get(2) != null) {
                    this.mPollingContext[0] = this.mPollingContext[0] + 1;
                    this.mRegStateManagers.get(2).requestNetworkRegistrationInfo(2, this.obtainMessage(6, this.mPollingContext));
                }
                if (!this.mPhone.isPhoneTypeGsm()) break;
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getNetworkSelectionMode(this.obtainMessage(14, this.mPollingContext));
            }
        }
    }

    private void pollStateDone() {
        boolean isDataInService;
        if (!this.mPhone.isPhoneTypeGsm()) {
            this.updateRoamingState();
        }
        if (Build.IS_DEBUGGABLE && SystemProperties.getBoolean(PROP_FORCE_ROAMING, false)) {
            this.mNewSS.setVoiceRoaming(true);
            this.mNewSS.setDataRoaming(true);
        }
        this.useDataRegStateForDataOnlyDevices();
        this.processIwlanRegistrationInfo();
        if (Build.IS_DEBUGGABLE && this.mPhone.mTelephonyTester != null) {
            this.mPhone.mTelephonyTester.overrideServiceState(this.mNewSS);
        }
        this.log("Poll ServiceState done:  oldSS=[" + this.mSS + "] newSS=[" + this.mNewSS + "] oldMaxDataCalls=" + this.mMaxDataCalls + " mNewMaxDataCalls=" + this.mNewMaxDataCalls + " oldReasonDataDenied=" + this.mReasonDataDenied + " mNewReasonDataDenied=" + this.mNewReasonDataDenied);
        boolean hasRegistered = this.mSS.getVoiceRegState() != 0 && this.mNewSS.getVoiceRegState() == 0;
        boolean hasDeregistered = this.mSS.getVoiceRegState() == 0 && this.mNewSS.getVoiceRegState() != 0;
        boolean hasAirplaneModeOnChanged = this.mSS.getVoiceRegState() != 3 && this.mNewSS.getVoiceRegState() == 3;
        SparseBooleanArray hasDataAttached = new SparseBooleanArray(this.mTransportManager.getAvailableTransports().length);
        SparseBooleanArray hasDataDetached = new SparseBooleanArray(this.mTransportManager.getAvailableTransports().length);
        SparseBooleanArray hasRilDataRadioTechnologyChanged = new SparseBooleanArray(this.mTransportManager.getAvailableTransports().length);
        SparseBooleanArray hasDataRegStateChanged = new SparseBooleanArray(this.mTransportManager.getAvailableTransports().length);
        boolean anyDataRegChanged = false;
        boolean anyDataRatChanged = false;
        for (int transport : this.mTransportManager.getAvailableTransports()) {
            NetworkRegistrationInfo oldNrs = this.mSS.getNetworkRegistrationInfo(2, transport);
            NetworkRegistrationInfo newNrs = this.mNewSS.getNetworkRegistrationInfo(2, transport);
            boolean changed = (oldNrs == null || !oldNrs.isInService() || hasAirplaneModeOnChanged) && newNrs != null && newNrs.isInService();
            hasDataAttached.put(transport, changed);
            changed = oldNrs != null && oldNrs.isInService() && (newNrs == null || !newNrs.isInService());
            hasDataDetached.put(transport, changed);
            int oldRAT = oldNrs != null ? oldNrs.getAccessNetworkTechnology() : 0;
            int newRAT = newNrs != null ? newNrs.getAccessNetworkTechnology() : 0;
            hasRilDataRadioTechnologyChanged.put(transport, oldRAT != newRAT);
            if (oldRAT != newRAT) {
                anyDataRatChanged = true;
            }
            int oldRegState = oldNrs != null ? oldNrs.getRegistrationState() : 4;
            int newRegState = newNrs != null ? newNrs.getRegistrationState() : 4;
            hasDataRegStateChanged.put(transport, oldRegState != newRegState);
            if (oldRegState == newRegState) continue;
            anyDataRegChanged = true;
        }
        boolean hasVoiceRegStateChanged = this.mSS.getVoiceRegState() != this.mNewSS.getVoiceRegState();
        boolean hasNrFrequencyRangeChanged = this.mSS.getNrFrequencyRange() != this.mNewSS.getNrFrequencyRange();
        boolean hasNrStateChanged = this.isNrStateChanged(this.mSS.getNetworkRegistrationInfo(2, 3), this.mNewSS.getNetworkRegistrationInfo(2, 3));
        boolean hasLocationChanged = !Objects.equals(this.mNewCellIdentity, this.mCellIdentity);
        boolean bl = isDataInService = this.mNewSS.getDataRegState() == 0;
        if (isDataInService) {
            this.mRatRatcheter.ratchet(this.mSS, this.mNewSS, hasLocationChanged);
        }
        boolean hasRilVoiceRadioTechnologyChanged = this.mSS.getRilVoiceRadioTechnology() != this.mNewSS.getRilVoiceRadioTechnology();
        boolean hasChanged = !this.mNewSS.equals(this.mSS);
        boolean hasVoiceRoamingOn = !this.mSS.getVoiceRoaming() && this.mNewSS.getVoiceRoaming();
        boolean hasVoiceRoamingOff = this.mSS.getVoiceRoaming() && !this.mNewSS.getVoiceRoaming();
        boolean hasDataRoamingOn = !this.mSS.getDataRoaming() && this.mNewSS.getDataRoaming();
        boolean hasDataRoamingOff = this.mSS.getDataRoaming() && !this.mNewSS.getDataRoaming();
        boolean hasRejectCauseChanged = this.mRejectCode != this.mNewRejectCode;
        boolean hasCssIndicatorChanged = this.mSS.getCssIndicator() != this.mNewSS.getCssIndicator();
        boolean has4gHandoff = false;
        boolean hasMultiApnSupport = false;
        boolean hasLostMultiApnSupport = false;
        if (this.mPhone.isPhoneTypeCdmaLte()) {
            has4gHandoff = this.mNewSS.getDataRegState() == 0 && (ServiceState.isLte(this.mSS.getRilDataRadioTechnology()) && this.mNewSS.getRilDataRadioTechnology() == 13 || this.mSS.getRilDataRadioTechnology() == 13 && ServiceState.isLte(this.mNewSS.getRilDataRadioTechnology()));
            hasMultiApnSupport = (ServiceState.isLte(this.mNewSS.getRilDataRadioTechnology()) || this.mNewSS.getRilDataRadioTechnology() == 13) && !ServiceState.isLte(this.mSS.getRilDataRadioTechnology()) && this.mSS.getRilDataRadioTechnology() != 13;
            hasLostMultiApnSupport = this.mNewSS.getRilDataRadioTechnology() >= 4 && this.mNewSS.getRilDataRadioTechnology() <= 8;
        }
        this.log("pollStateDone: hasRegistered = " + hasRegistered + " hasDeregistered = " + hasDeregistered + " hasDataAttached = " + hasDataAttached + " hasDataDetached = " + hasDataDetached + " hasDataRegStateChanged = " + hasDataRegStateChanged + " hasRilVoiceRadioTechnologyChanged = " + hasRilVoiceRadioTechnologyChanged + " hasRilDataRadioTechnologyChanged = " + hasRilDataRadioTechnologyChanged + " hasChanged = " + hasChanged + " hasVoiceRoamingOn = " + hasVoiceRoamingOn + " hasVoiceRoamingOff = " + hasVoiceRoamingOff + " hasDataRoamingOn =" + hasDataRoamingOn + " hasDataRoamingOff = " + hasDataRoamingOff + " hasLocationChanged = " + hasLocationChanged + " has4gHandoff = " + has4gHandoff + " hasMultiApnSupport = " + hasMultiApnSupport + " hasLostMultiApnSupport = " + hasLostMultiApnSupport + " hasCssIndicatorChanged = " + hasCssIndicatorChanged + " hasNrFrequencyRangeChanged = " + hasNrFrequencyRangeChanged + " hasNrStateChanged = " + hasNrStateChanged + " hasAirplaneModeOnlChanged = " + hasAirplaneModeOnChanged);
        if (hasVoiceRegStateChanged || anyDataRegChanged) {
            EventLog.writeEvent(this.mPhone.isPhoneTypeGsm() ? 50114 : 50116, this.mSS.getVoiceRegState(), this.mSS.getDataRegState(), this.mNewSS.getVoiceRegState(), this.mNewSS.getDataRegState());
        }
        if (this.mPhone.isPhoneTypeGsm()) {
            if (hasRilVoiceRadioTechnologyChanged) {
                int cid = ServiceStateTracker.getCidFromCellIdentity(this.mNewCellIdentity);
                EventLog.writeEvent(50123, cid, this.mSS.getRilVoiceRadioTechnology(), this.mNewSS.getRilVoiceRadioTechnology());
                this.log("RAT switched " + ServiceState.rilRadioTechnologyToString(this.mSS.getRilVoiceRadioTechnology()) + " -> " + ServiceState.rilRadioTechnologyToString(this.mNewSS.getRilVoiceRadioTechnology()) + " at cell " + cid);
            }
            if (hasCssIndicatorChanged) {
                this.mPhone.notifyDataConnection();
            }
            this.mReasonDataDenied = this.mNewReasonDataDenied;
            this.mMaxDataCalls = this.mNewMaxDataCalls;
            this.mRejectCode = this.mNewRejectCode;
        }
        ServiceState oldMergedSS = new ServiceState(this.mPhone.getServiceState());
        ServiceState tss = this.mSS;
        this.mSS = this.mNewSS;
        this.mNewSS = tss;
        this.mNewSS.setStateOutOfService();
        CellIdentity tempCellId = this.mCellIdentity;
        this.mCellIdentity = this.mNewCellIdentity;
        this.mNewCellIdentity = tempCellId;
        if (hasRilVoiceRadioTechnologyChanged) {
            this.updatePhoneObject();
        }
        TelephonyManager tm = (TelephonyManager)this.mPhone.getContext().getSystemService("phone");
        if (anyDataRatChanged) {
            tm.setDataNetworkTypeForPhone(this.mPhone.getPhoneId(), this.mSS.getRilDataRadioTechnology());
            StatsLog.write(76, ServiceState.rilRadioTechnologyToNetworkType(this.mSS.getRilDataRadioTechnology()), this.mPhone.getPhoneId());
        }
        if (hasRegistered) {
            this.mNetworkAttachedRegistrants.notifyRegistrants();
            this.mNitzState.handleNetworkAvailable();
        }
        if (hasDeregistered) {
            this.mNetworkDetachedRegistrants.notifyRegistrants();
        }
        if (hasRejectCauseChanged) {
            this.setNotification(2001);
        }
        if (hasChanged) {
            this.updateSpnDisplay();
            tm.setNetworkOperatorNameForPhone(this.mPhone.getPhoneId(), this.mSS.getOperatorAlpha());
            String operatorNumeric = this.mSS.getOperatorNumeric();
            if (!this.mPhone.isPhoneTypeGsm() && this.isInvalidOperatorNumeric(operatorNumeric)) {
                int sid = this.mSS.getCdmaSystemId();
                operatorNumeric = this.fixUnknownMcc(operatorNumeric, sid);
            }
            tm.setNetworkOperatorNumericForPhone(this.mPhone.getPhoneId(), operatorNumeric);
            if (this.isInvalidOperatorNumeric(operatorNumeric)) {
                this.log("operatorNumeric " + operatorNumeric + " is invalid");
                this.mLocaleTracker.updateOperatorNumeric("");
            } else if (this.mSS.getRilDataRadioTechnology() != 18) {
                if (!this.mPhone.isPhoneTypeGsm()) {
                    this.setOperatorIdd(operatorNumeric);
                }
                this.mLocaleTracker.updateOperatorNumeric(operatorNumeric);
            }
            tm.setNetworkRoamingForPhone(this.mPhone.getPhoneId(), this.mPhone.isPhoneTypeGsm() ? this.mSS.getVoiceRoaming() : this.mSS.getVoiceRoaming() || this.mSS.getDataRoaming());
            this.setRoamingType(this.mSS);
            this.log("Broadcasting ServiceState : " + this.mSS);
            if (!oldMergedSS.equals(this.mPhone.getServiceState())) {
                this.mPhone.notifyServiceStateChanged(this.mPhone.getServiceState());
            }
            this.mPhone.getContext().getContentResolver().insert(Telephony.ServiceStateTable.getUriForSubscriptionId(this.mPhone.getSubId()), Telephony.ServiceStateTable.getContentValuesForServiceState(this.mSS));
            TelephonyMetrics.getInstance().writeServiceStateChanged(this.mPhone.getPhoneId(), this.mSS);
        }
        boolean shouldLogAttachedChange = false;
        boolean shouldLogRatChange = false;
        if (hasRegistered || hasDeregistered) {
            shouldLogAttachedChange = true;
        }
        if (has4gHandoff) {
            this.mAttachedRegistrants.get(1).notifyRegistrants();
            shouldLogAttachedChange = true;
        }
        if (hasRilVoiceRadioTechnologyChanged) {
            shouldLogRatChange = true;
            this.notifySignalStrength();
        }
        for (int transport : this.mTransportManager.getAvailableTransports()) {
            if (hasRilDataRadioTechnologyChanged.get(transport)) {
                shouldLogRatChange = true;
                this.notifySignalStrength();
            }
            if (hasDataRegStateChanged.get(transport) || hasRilDataRadioTechnologyChanged.get(transport)) {
                this.notifyDataRegStateRilRadioTechnologyChanged(transport);
                this.mPhone.notifyDataConnection();
            }
            if (hasDataAttached.get(transport)) {
                shouldLogAttachedChange = true;
                if (this.mAttachedRegistrants.get(transport) != null) {
                    this.mAttachedRegistrants.get(transport).notifyRegistrants();
                }
            }
            if (!hasDataDetached.get(transport)) continue;
            shouldLogAttachedChange = true;
            if (this.mDetachedRegistrants.get(transport) == null) continue;
            this.mDetachedRegistrants.get(transport).notifyRegistrants();
        }
        if (shouldLogAttachedChange) {
            this.logAttachChange();
        }
        if (shouldLogRatChange) {
            this.logRatChange();
        }
        if (hasVoiceRegStateChanged || hasRilVoiceRadioTechnologyChanged) {
            this.notifyVoiceRegStateRilRadioTechnologyChanged();
        }
        if (hasVoiceRoamingOn || hasVoiceRoamingOff || hasDataRoamingOn || hasDataRoamingOff) {
            this.logRoamingChange();
        }
        if (hasVoiceRoamingOn) {
            this.mVoiceRoamingOnRegistrants.notifyRegistrants();
        }
        if (hasVoiceRoamingOff) {
            this.mVoiceRoamingOffRegistrants.notifyRegistrants();
        }
        if (hasDataRoamingOn) {
            this.mDataRoamingOnRegistrants.notifyRegistrants();
        }
        if (hasDataRoamingOff) {
            this.mDataRoamingOffRegistrants.notifyRegistrants();
        }
        if (hasLocationChanged) {
            this.mPhone.notifyLocationChanged(this.getCellLocation());
        }
        if (this.mPhone.isPhoneTypeGsm()) {
            if (!this.isGprsConsistent(this.mSS.getDataRegState(), this.mSS.getVoiceRegState())) {
                if (!this.mStartedGprsRegCheck && !this.mReportedGprsNoReg) {
                    this.mStartedGprsRegCheck = true;
                    int check_period = Settings.Global.getInt(this.mPhone.getContext().getContentResolver(), "gprs_register_check_period_ms", 60000);
                    this.sendMessageDelayed(this.obtainMessage(22), check_period);
                }
            } else {
                this.mReportedGprsNoReg = false;
            }
        }
    }

    private String getOperatorNameFromEri() {
        String eriText = null;
        if (this.mPhone.isPhoneTypeCdma()) {
            if (this.mCi.getRadioState() == 1 && !this.mIsSubscriptionFromRuim) {
                eriText = this.mSS.getVoiceRegState() == 0 ? this.mPhone.getCdmaEriText() : this.mPhone.getContext().getText(17040955).toString();
            }
        } else if (this.mPhone.isPhoneTypeCdmaLte()) {
            boolean hasBrandOverride;
            boolean bl = hasBrandOverride = this.mUiccController.getUiccCard(this.getPhoneId()) != null && this.mUiccController.getUiccCard(this.getPhoneId()).getOperatorBrandOverride() != null;
            if (!hasBrandOverride && this.mCi.getRadioState() == 1 && this.mEriManager.isEriFileLoaded() && (!ServiceState.isLte(this.mSS.getRilVoiceRadioTechnology()) || this.mPhone.getContext().getResources().getBoolean(0x1110008))) {
                eriText = this.mSS.getOperatorAlpha();
                if (this.mSS.getVoiceRegState() == 0) {
                    eriText = this.mPhone.getCdmaEriText();
                } else if (this.mSS.getVoiceRegState() == 3) {
                    eriText = this.getServiceProviderName();
                    if (TextUtils.isEmpty(eriText)) {
                        eriText = SystemProperties.get("ro.cdma.home.operator.alpha");
                    }
                } else if (this.mSS.getDataRegState() != 0) {
                    eriText = this.mPhone.getContext().getText(17040955).toString();
                }
            }
            if (this.mUiccApplcation != null && this.mUiccApplcation.getState() == IccCardApplicationStatus.AppState.APPSTATE_READY && this.mIccRecords != null && this.getCombinedRegState(this.mSS) == 0 && !ServiceState.isLte(this.mSS.getRilVoiceRadioTechnology())) {
                boolean showSpn = ((RuimRecords)this.mIccRecords).getCsimSpnDisplayCondition();
                int iconIndex = this.mSS.getCdmaEriIconIndex();
                if (showSpn && iconIndex == 1 && this.isInHomeSidNid(this.mSS.getCdmaSystemId(), this.mSS.getCdmaNetworkId()) && this.mIccRecords != null) {
                    eriText = this.getServiceProviderName();
                }
            }
        }
        return eriText;
    }

    public String getServiceProviderName() {
        String operatorBrandOverride = this.getOperatorBrandOverride();
        if (!TextUtils.isEmpty(operatorBrandOverride)) {
            return operatorBrandOverride;
        }
        String carrierName = this.mIccRecords != null ? this.mIccRecords.getServiceProviderName() : "";
        PersistableBundle config = this.getCarrierConfig();
        if (config.getBoolean("carrier_name_override_bool") || TextUtils.isEmpty(carrierName)) {
            return config.getString("carrier_name_string");
        }
        return carrierName;
    }

    public int getCarrierNameDisplayBitmask(ServiceState ss) {
        int rule;
        boolean isRoaming;
        int carrierDisplayNameConditionFromSim;
        PersistableBundle config = this.getCarrierConfig();
        if (!TextUtils.isEmpty(this.getOperatorBrandOverride())) {
            return 1;
        }
        if (TextUtils.isEmpty(this.getServiceProviderName())) {
            return 2;
        }
        boolean useRoamingFromServiceState = config.getBoolean("spn_display_rule_use_roaming_from_service_state_bool");
        int n = carrierDisplayNameConditionFromSim = this.mIccRecords == null ? 0 : this.mIccRecords.getCarrierNameDisplayCondition();
        if (useRoamingFromServiceState) {
            isRoaming = ss.getRoaming();
        } else {
            String[] hplmns = this.mIccRecords != null ? this.mIccRecords.getHomePlmns() : null;
            boolean bl = isRoaming = !ArrayUtils.contains(hplmns, ss.getOperatorNumeric());
        }
        if (isRoaming) {
            rule = 2;
            if ((carrierDisplayNameConditionFromSim & 2) == 2) {
                rule |= 1;
            }
        } else {
            rule = 1;
            if ((carrierDisplayNameConditionFromSim & 1) == 1) {
                rule |= 2;
            }
        }
        return rule;
    }

    private String getOperatorBrandOverride() {
        UiccCard card = this.mPhone.getUiccCard();
        if (card == null) {
            return null;
        }
        UiccProfile profile = card.getUiccProfile();
        if (profile == null) {
            return null;
        }
        return profile.getOperatorBrandOverride();
    }

    @UnsupportedAppUsage
    private boolean isInHomeSidNid(int sid, int nid) {
        if (this.isSidsAllZeros()) {
            return true;
        }
        if (this.mHomeSystemId.length != this.mHomeNetworkId.length) {
            return true;
        }
        if (sid == 0) {
            return true;
        }
        for (int i = 0; i < this.mHomeSystemId.length; ++i) {
            if (this.mHomeSystemId[i] != sid || this.mHomeNetworkId[i] != 0 && this.mHomeNetworkId[i] != 65535 && nid != 0 && nid != 65535 && this.mHomeNetworkId[i] != nid) continue;
            return true;
        }
        return false;
    }

    @UnsupportedAppUsage
    protected void setOperatorIdd(String operatorNumeric) {
        String idd = this.mHbpcdUtils.getIddByMcc(Integer.parseInt(operatorNumeric.substring(0, 3)));
        if (idd != null && !idd.isEmpty()) {
            this.mPhone.setGlobalSystemProperty("gsm.operator.idpstring", idd);
        } else {
            this.mPhone.setGlobalSystemProperty("gsm.operator.idpstring", "+");
        }
    }

    @UnsupportedAppUsage
    private boolean isInvalidOperatorNumeric(String operatorNumeric) {
        return operatorNumeric == null || operatorNumeric.length() < 5 || operatorNumeric.startsWith(INVALID_MCC);
    }

    @UnsupportedAppUsage
    private String fixUnknownMcc(String operatorNumeric, int sid) {
        NitzData nitzData;
        boolean isDst;
        int mcc;
        boolean isNitzTimeZone;
        TimeZone tzone;
        if (sid <= 0) {
            return operatorNumeric;
        }
        if (this.mNitzState.getSavedTimeZoneId() != null) {
            tzone = TimeZone.getTimeZone(this.mNitzState.getSavedTimeZoneId());
            isNitzTimeZone = true;
        } else {
            NitzData lastNitzData = this.mNitzState.getCachedNitzData();
            if (lastNitzData == null) {
                tzone = null;
            } else {
                tzone = TimeZoneLookupHelper.guessZoneByNitzStatic(lastNitzData);
                this.log("fixUnknownMcc(): guessNitzTimeZone returned " + (tzone == null ? tzone : tzone.getID()));
            }
            isNitzTimeZone = false;
        }
        int utcOffsetHours = 0;
        if (tzone != null) {
            utcOffsetHours = tzone.getRawOffset() / 3600000;
        }
        if ((mcc = this.mHbpcdUtils.getMcc(sid, utcOffsetHours, (isDst = (nitzData = this.mNitzState.getCachedNitzData()) != null && nitzData.isDst()) ? 1 : 0, isNitzTimeZone)) > 0) {
            operatorNumeric = Integer.toString(mcc) + DEFAULT_MNC;
        }
        return operatorNumeric;
    }

    @UnsupportedAppUsage
    private boolean isGprsConsistent(int dataRegState, int voiceRegState) {
        return voiceRegState != 0 || dataRegState == 0;
    }

    private int regCodeToServiceState(int code) {
        switch (code) {
            case 1: 
            case 5: {
                return 0;
            }
        }
        return 1;
    }

    private boolean regCodeIsRoaming(int code) {
        return 5 == code;
    }

    private boolean isSameOperatorNameFromSimAndSS(ServiceState s) {
        String spn = ((TelephonyManager)this.mPhone.getContext().getSystemService("phone")).getSimOperatorNameForPhone(this.getPhoneId());
        String onsl = s.getOperatorAlphaLong();
        String onss = s.getOperatorAlphaShort();
        boolean equalsOnsl = !TextUtils.isEmpty(spn) && spn.equalsIgnoreCase(onsl);
        boolean equalsOnss = !TextUtils.isEmpty(spn) && spn.equalsIgnoreCase(onss);
        return equalsOnsl || equalsOnss;
    }

    private boolean isSameNamedOperators(ServiceState s) {
        return this.currentMccEqualsSimMcc(s) && this.isSameOperatorNameFromSimAndSS(s);
    }

    private boolean currentMccEqualsSimMcc(ServiceState s) {
        String simNumeric = ((TelephonyManager)this.mPhone.getContext().getSystemService("phone")).getSimOperatorNumericForPhone(this.getPhoneId());
        String operatorNumeric = s.getOperatorNumeric();
        boolean equalsMcc = true;
        try {
            equalsMcc = simNumeric.substring(0, 3).equals(operatorNumeric.substring(0, 3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return equalsMcc;
    }

    private boolean isOperatorConsideredNonRoaming(ServiceState s) {
        String operatorNumeric = s.getOperatorNumeric();
        PersistableBundle config = this.getCarrierConfig();
        String[] numericArray = config.getStringArray("non_roaming_operator_string_array");
        if (ArrayUtils.isEmpty(numericArray) || operatorNumeric == null) {
            return false;
        }
        for (String numeric : numericArray) {
            if (TextUtils.isEmpty(numeric) || !operatorNumeric.startsWith(numeric)) continue;
            return true;
        }
        return false;
    }

    private boolean isOperatorConsideredRoaming(ServiceState s) {
        String operatorNumeric = s.getOperatorNumeric();
        PersistableBundle config = this.getCarrierConfig();
        String[] numericArray = config.getStringArray("roaming_operator_string_array");
        if (ArrayUtils.isEmpty(numericArray) || operatorNumeric == null) {
            return false;
        }
        for (String numeric : numericArray) {
            if (TextUtils.isEmpty(numeric) || !operatorNumeric.startsWith(numeric)) continue;
            return true;
        }
        return false;
    }

    private void onRestrictedStateChanged(AsyncResult ar) {
        RestrictedState newRs = new RestrictedState();
        this.log("onRestrictedStateChanged: E rs " + this.mRestrictedState);
        if (ar.exception == null && ar.result != null) {
            int state = (Integer)ar.result;
            newRs.setCsEmergencyRestricted((state & 1) != 0 || (state & 4) != 0);
            if (this.mUiccApplcation != null && this.mUiccApplcation.getState() == IccCardApplicationStatus.AppState.APPSTATE_READY) {
                newRs.setCsNormalRestricted((state & 2) != 0 || (state & 4) != 0);
                newRs.setPsRestricted((state & 0x10) != 0);
            }
            this.log("onRestrictedStateChanged: new rs " + newRs);
            if (!this.mRestrictedState.isPsRestricted() && newRs.isPsRestricted()) {
                this.mPsRestrictEnabledRegistrants.notifyRegistrants();
                this.setNotification(1001);
            } else if (this.mRestrictedState.isPsRestricted() && !newRs.isPsRestricted()) {
                this.mPsRestrictDisabledRegistrants.notifyRegistrants();
                this.setNotification(1002);
            }
            if (this.mRestrictedState.isCsRestricted()) {
                if (!newRs.isAnyCsRestricted()) {
                    this.setNotification(1004);
                } else if (!newRs.isCsNormalRestricted()) {
                    this.setNotification(1006);
                } else if (!newRs.isCsEmergencyRestricted()) {
                    this.setNotification(1005);
                }
            } else if (this.mRestrictedState.isCsEmergencyRestricted() && !this.mRestrictedState.isCsNormalRestricted()) {
                if (!newRs.isAnyCsRestricted()) {
                    this.setNotification(1004);
                } else if (newRs.isCsRestricted()) {
                    this.setNotification(1003);
                } else if (newRs.isCsNormalRestricted()) {
                    this.setNotification(1005);
                }
            } else if (!this.mRestrictedState.isCsEmergencyRestricted() && this.mRestrictedState.isCsNormalRestricted()) {
                if (!newRs.isAnyCsRestricted()) {
                    this.setNotification(1004);
                } else if (newRs.isCsRestricted()) {
                    this.setNotification(1003);
                } else if (newRs.isCsEmergencyRestricted()) {
                    this.setNotification(1006);
                }
            } else if (newRs.isCsRestricted()) {
                this.setNotification(1003);
            } else if (newRs.isCsEmergencyRestricted()) {
                this.setNotification(1006);
            } else if (newRs.isCsNormalRestricted()) {
                this.setNotification(1005);
            }
            this.mRestrictedState = newRs;
        }
        this.log("onRestrictedStateChanged: X rs " + this.mRestrictedState);
    }

    public CellLocation getCellLocation() {
        if (this.mCellIdentity != null) {
            return this.mCellIdentity.asCellLocation();
        }
        CellLocation cl = ServiceStateTracker.getCellLocationFromCellInfo(this.getAllCellInfo());
        if (cl != null) {
            return cl;
        }
        return this.mPhone.getPhoneType() == 2 ? new CdmaCellLocation() : new GsmCellLocation();
    }

    public void requestCellLocation(WorkSource workSource, Message rspMsg) {
        if (this.mCellIdentity != null) {
            AsyncResult.forMessage(rspMsg, this.mCellIdentity.asCellLocation(), null);
            rspMsg.sendToTarget();
            return;
        }
        Message cellLocRsp = this.obtainMessage(56, rspMsg);
        this.requestAllCellInfo(workSource, cellLocRsp);
    }

    private static CellLocation getCellLocationFromCellInfo(List<CellInfo> info) {
        CellLocation cl = null;
        if (info != null && info.size() > 0) {
            CellIdentity fallbackLteCid = null;
            for (CellInfo ci : info) {
                CellIdentity c = ci.getCellIdentity();
                if (c instanceof CellIdentityLte && fallbackLteCid == null) {
                    if (ServiceStateTracker.getCidFromCellIdentity(c) == -1) continue;
                    fallbackLteCid = c;
                    continue;
                }
                if (ServiceStateTracker.getCidFromCellIdentity(c) == -1) continue;
                cl = c.asCellLocation();
                break;
            }
            if (cl == null && fallbackLteCid != null) {
                cl = fallbackLteCid.asCellLocation();
            }
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimeFromNITZString(String nitzString, long nitzReceiveTime) {
        long start = SystemClock.elapsedRealtime();
        Rlog.d(LOG_TAG, "NITZ: " + nitzString + "," + nitzReceiveTime + " start=" + start + " delay=" + (start - nitzReceiveTime));
        NitzData newNitzData = NitzData.parse(nitzString);
        if (newNitzData != null) {
            try {
                TimestampedValue<NitzData> nitzSignal = new TimestampedValue<NitzData>(nitzReceiveTime, newNitzData);
                this.mNitzState.handleNitzReceived(nitzSignal);
            }
            finally {
                long end = SystemClock.elapsedRealtime();
                Rlog.d(LOG_TAG, "NITZ: end=" + end + " dur=" + (end - start));
            }
        }
    }

    private void cancelAllNotifications() {
        this.log("cancelAllNotifications: mPrevSubId=" + this.mPrevSubId);
        NotificationManager notificationManager = (NotificationManager)this.mPhone.getContext().getSystemService("notification");
        if (SubscriptionManager.isValidSubscriptionId(this.mPrevSubId)) {
            notificationManager.cancel(Integer.toString(this.mPrevSubId), 888);
            notificationManager.cancel(Integer.toString(this.mPrevSubId), 999);
            notificationManager.cancel(Integer.toString(this.mPrevSubId), 111);
        }
    }

    @VisibleForTesting
    public void setNotification(int notifyType) {
        this.log("setNotification: create notification " + notifyType);
        if (!SubscriptionManager.isValidSubscriptionId(this.mSubId)) {
            this.loge("cannot setNotification on invalid subid mSubId=" + this.mSubId);
            return;
        }
        Context context = this.mPhone.getContext();
        SubscriptionInfo info = this.mSubscriptionController.getActiveSubscriptionInfo(this.mPhone.getSubId(), context.getOpPackageName());
        if (info == null || info.isOpportunistic() && info.getGroupUuid() != null) {
            this.log("cannot setNotification on invisible subid mSubId=" + this.mSubId);
            return;
        }
        boolean isSetNotification = context.getResources().getBoolean(0x11100F1);
        if (!isSetNotification) {
            this.log("Ignore all the notifications");
            return;
        }
        boolean autoCancelCsRejectNotification = false;
        PersistableBundle bundle = this.getCarrierConfig();
        boolean disableVoiceBarringNotification = bundle.getBoolean("disable_voice_barring_notification_bool", false);
        if (disableVoiceBarringNotification && (notifyType == 1003 || notifyType == 1005 || notifyType == 1006)) {
            this.log("Voice/emergency call barred notification disabled");
            return;
        }
        autoCancelCsRejectNotification = bundle.getBoolean("carrier_auto_cancel_cs_notification", false);
        CharSequence details = "";
        CharSequence title = "";
        int notificationId = 999;
        int icon = 17301642;
        boolean multipleSubscriptions = ((TelephonyManager)this.mPhone.getContext().getSystemService("phone")).getPhoneCount() > 1;
        int simNumber = this.mSubscriptionController.getSlotIndex(this.mSubId) + 1;
        switch (notifyType) {
            case 1001: {
                long dataSubId = SubscriptionManager.getDefaultDataSubscriptionId();
                if (dataSubId != (long)this.mPhone.getSubId()) {
                    return;
                }
                notificationId = 888;
                title = context.getText(17039422);
                details = multipleSubscriptions ? context.getString(17039426, simNumber) : context.getText(0x1040041);
                break;
            }
            case 1002: {
                notificationId = 888;
                break;
            }
            case 1003: {
                title = context.getText(17039421);
                details = multipleSubscriptions ? context.getString(17039426, simNumber) : context.getText(0x1040041);
                break;
            }
            case 1005: {
                title = context.getText(0x1040040);
                details = multipleSubscriptions ? context.getString(17039426, simNumber) : context.getText(0x1040041);
                break;
            }
            case 1006: {
                title = context.getText(17039423);
                details = multipleSubscriptions ? context.getString(17039426, simNumber) : context.getText(0x1040041);
                break;
            }
            case 1004: {
                break;
            }
            case 2001: {
                notificationId = 111;
                int resId = this.selectResourceForRejectCode(this.mRejectCode, multipleSubscriptions);
                if (0 == resId) {
                    if (autoCancelCsRejectNotification) {
                        notifyType = 2002;
                        break;
                    }
                    this.loge("setNotification: mRejectCode=" + this.mRejectCode + " is not handled.");
                    return;
                }
                icon = 17303513;
                title = context.getString(resId, simNumber);
                details = null;
            }
        }
        this.log("setNotification, create notification, notifyType: " + notifyType + ", title: " + title + ", details: " + details + ", subId: " + this.mSubId);
        this.mNotification = new Notification.Builder(context).setWhen(System.currentTimeMillis()).setAutoCancel(true).setSmallIcon(icon).setTicker(title).setColor(context.getResources().getColor(17170460)).setContentTitle(title).setStyle(new Notification.BigTextStyle().bigText(details)).setContentText(details).setChannel("alert").build();
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notifyType == 1002 || notifyType == 1004 || notifyType == 2002) {
            notificationManager.cancel(Integer.toString(this.mSubId), notificationId);
        } else {
            boolean show = false;
            if (this.mSS.isEmergencyOnly() && notifyType == 1006) {
                show = true;
            } else if (notifyType == 2001) {
                show = true;
            } else if (this.mSS.getState() == 0) {
                show = true;
            }
            if (show) {
                notificationManager.notify(Integer.toString(this.mSubId), notificationId, this.mNotification);
            }
        }
    }

    private int selectResourceForRejectCode(int rejCode, boolean multipleSubscriptions) {
        int rejResourceId = 0;
        switch (rejCode) {
            case 1: {
                rejResourceId = multipleSubscriptions ? 17040436 : 17040435;
                break;
            }
            case 2: {
                rejResourceId = multipleSubscriptions ? 17040442 : 17040441;
                break;
            }
            case 3: {
                rejResourceId = multipleSubscriptions ? 17040440 : 17040439;
                break;
            }
            case 6: {
                rejResourceId = multipleSubscriptions ? 17040438 : 17040437;
                break;
            }
        }
        return rejResourceId;
    }

    private UiccCardApplication getUiccCardApplication() {
        if (this.mPhone.isPhoneTypeGsm()) {
            return this.mUiccController.getUiccCardApplication(this.mPhone.getPhoneId(), 1);
        }
        return this.mUiccController.getUiccCardApplication(this.mPhone.getPhoneId(), 2);
    }

    private void queueNextSignalStrengthPoll() {
        if (this.mDontPollSignalStrength) {
            return;
        }
        UiccCard uiccCard = UiccController.getInstance().getUiccCard(this.getPhoneId());
        if (uiccCard == null || uiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_ABSENT) {
            this.log("Not polling signal strength due to absence of SIM");
            return;
        }
        Message msg = this.obtainMessage();
        msg.what = 10;
        this.sendMessageDelayed(msg, 20000L);
    }

    private void notifyCdmaSubscriptionInfoReady() {
        if (this.mCdmaForSubscriptionInfoReadyRegistrants != null) {
            this.log("CDMA_SUBSCRIPTION: call notifyRegistrants()");
            this.mCdmaForSubscriptionInfoReadyRegistrants.notifyRegistrants();
        }
    }

    public void registerForDataConnectionAttached(int transport, Handler h, int what, Object obj) {
        NetworkRegistrationInfo netRegState;
        Registrant r = new Registrant(h, what, obj);
        if (this.mAttachedRegistrants.get(transport) == null) {
            this.mAttachedRegistrants.put(transport, new RegistrantList());
        }
        this.mAttachedRegistrants.get(transport).add(r);
        if (this.mSS != null && ((netRegState = this.mSS.getNetworkRegistrationInfo(2, transport)) == null || netRegState.isInService())) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForDataConnectionAttached(int transport, Handler h) {
        if (this.mAttachedRegistrants.get(transport) != null) {
            this.mAttachedRegistrants.get(transport).remove(h);
        }
    }

    public void registerForDataConnectionDetached(int transport, Handler h, int what, Object obj) {
        NetworkRegistrationInfo netRegState;
        Registrant r = new Registrant(h, what, obj);
        if (this.mDetachedRegistrants.get(transport) == null) {
            this.mDetachedRegistrants.put(transport, new RegistrantList());
        }
        this.mDetachedRegistrants.get(transport).add(r);
        if (this.mSS != null && (netRegState = this.mSS.getNetworkRegistrationInfo(2, transport)) != null && !netRegState.isInService()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForDataConnectionDetached(int transport, Handler h) {
        if (this.mDetachedRegistrants.get(transport) != null) {
            this.mDetachedRegistrants.get(transport).remove(h);
        }
    }

    public void registerForVoiceRegStateOrRatChanged(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceRegStateOrRatChangedRegistrants.add(r);
        this.notifyVoiceRegStateRilRadioTechnologyChanged();
    }

    public void unregisterForVoiceRegStateOrRatChanged(Handler h) {
        this.mVoiceRegStateOrRatChangedRegistrants.remove(h);
    }

    public void registerForDataRegStateOrRatChanged(int transport, Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        if (this.mDataRegStateOrRatChangedRegistrants.get(transport) == null) {
            this.mDataRegStateOrRatChangedRegistrants.put(transport, new RegistrantList());
        }
        this.mDataRegStateOrRatChangedRegistrants.get(transport).add(r);
        this.notifyDataRegStateRilRadioTechnologyChanged(transport);
    }

    public void unregisterForDataRegStateOrRatChanged(int transport, Handler h) {
        if (this.mDataRegStateOrRatChangedRegistrants.get(transport) != null) {
            this.mDataRegStateOrRatChangedRegistrants.get(transport).remove(h);
        }
    }

    public void registerForNetworkAttached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mNetworkAttachedRegistrants.add(r);
        if (this.mSS.getVoiceRegState() == 0) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForNetworkAttached(Handler h) {
        this.mNetworkAttachedRegistrants.remove(h);
    }

    public void registerForNetworkDetached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mNetworkDetachedRegistrants.add(r);
        if (this.mSS.getVoiceRegState() != 0) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForNetworkDetached(Handler h) {
        this.mNetworkDetachedRegistrants.remove(h);
    }

    public void registerForPsRestrictedEnabled(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mPsRestrictEnabledRegistrants.add(r);
        if (this.mRestrictedState.isPsRestricted()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForPsRestrictedEnabled(Handler h) {
        this.mPsRestrictEnabledRegistrants.remove(h);
    }

    public void registerForPsRestrictedDisabled(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mPsRestrictDisabledRegistrants.add(r);
        if (this.mRestrictedState.isPsRestricted()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForPsRestrictedDisabled(Handler h) {
        this.mPsRestrictDisabledRegistrants.remove(h);
    }

    public void registerForImsCapabilityChanged(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mImsCapabilityChangedRegistrants.add(r);
    }

    public void unregisterForImsCapabilityChanged(Handler h) {
        this.mImsCapabilityChangedRegistrants.remove(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void powerOffRadioSafely() {
        ServiceStateTracker serviceStateTracker = this;
        synchronized (serviceStateTracker) {
            if (!this.mPendingRadioPowerOffAfterDataOff) {
                int dds = SubscriptionManager.getDefaultDataSubscriptionId();
                if (this.mPhone.areAllDataDisconnected() && (dds == this.mPhone.getSubId() || dds != this.mPhone.getSubId() && ProxyController.getInstance().areAllDataDisconnected(dds))) {
                    for (int transport : this.mTransportManager.getAvailableTransports()) {
                        if (this.mPhone.getDcTracker(transport) == null) continue;
                        this.mPhone.getDcTracker(transport).cleanUpAllConnections("radioTurnedOff");
                    }
                    this.log("Data disconnected, turn off radio right away.");
                    this.hangupAndPowerOff();
                } else {
                    if (this.mPhone.isPhoneTypeGsm() && this.mPhone.isInCall()) {
                        this.mPhone.mCT.mRingingCall.hangupIfAlive();
                        this.mPhone.mCT.mBackgroundCall.hangupIfAlive();
                        this.mPhone.mCT.mForegroundCall.hangupIfAlive();
                    }
                    for (int transport : this.mTransportManager.getAvailableTransports()) {
                        if (this.mPhone.getDcTracker(transport) == null) continue;
                        this.mPhone.getDcTracker(transport).cleanUpAllConnections("radioTurnedOff");
                    }
                    if (dds != this.mPhone.getSubId() && !ProxyController.getInstance().areAllDataDisconnected(dds)) {
                        this.log("Data is active on DDS.  Wait for all data disconnect");
                        ProxyController.getInstance().registerForAllDataDisconnected(dds, this, 49);
                        this.mPendingRadioPowerOffAfterDataOff = true;
                    }
                    Message msg = Message.obtain(this);
                    msg.what = 38;
                    msg.arg1 = ++this.mPendingRadioPowerOffAfterDataOffTag;
                    if (this.sendMessageDelayed(msg, 30000L)) {
                        this.log("Wait upto 30s for data to disconnect, then turn off radio.");
                        this.mPendingRadioPowerOffAfterDataOff = true;
                    } else {
                        this.log("Cannot send delayed Msg, turn off radio right away.");
                        this.hangupAndPowerOff();
                        this.mPendingRadioPowerOffAfterDataOff = false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processPendingRadioPowerOffAfterDataOff() {
        ServiceStateTracker serviceStateTracker = this;
        synchronized (serviceStateTracker) {
            if (this.mPendingRadioPowerOffAfterDataOff) {
                this.log("Process pending request to turn radio off.");
                ++this.mPendingRadioPowerOffAfterDataOffTag;
                this.hangupAndPowerOff();
                this.mPendingRadioPowerOffAfterDataOff = false;
                return true;
            }
            return false;
        }
    }

    private boolean containsEarfcnInEarfcnRange(ArrayList<Pair<Integer, Integer>> earfcnPairList, int earfcn) {
        if (earfcnPairList != null) {
            for (Pair<Integer, Integer> earfcnPair : earfcnPairList) {
                if (earfcn < (Integer)earfcnPair.first || earfcn > (Integer)earfcnPair.second) continue;
                return true;
            }
        }
        return false;
    }

    ArrayList<Pair<Integer, Integer>> convertEarfcnStringArrayToPairList(String[] earfcnsList) {
        ArrayList<Pair<Integer, Integer>> earfcnPairList = new ArrayList<Pair<Integer, Integer>>();
        if (earfcnsList != null) {
            for (int i = 0; i < earfcnsList.length; ++i) {
                try {
                    int earfcnEnd;
                    String[] earfcns = earfcnsList[i].split("-");
                    if (earfcns.length != 2) {
                        return null;
                    }
                    int earfcnStart = Integer.parseInt(earfcns[0]);
                    if (earfcnStart > (earfcnEnd = Integer.parseInt(earfcns[1]))) {
                        return null;
                    }
                    earfcnPairList.add(new Pair<Integer, Integer>(earfcnStart, earfcnEnd));
                    continue;
                }
                catch (PatternSyntaxException pse) {
                    return null;
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
        }
        return earfcnPairList;
    }

    private void onCarrierConfigChanged() {
        PersistableBundle config = this.getCarrierConfig();
        this.log("CarrierConfigChange " + config);
        this.mEriManager.loadEriFile();
        this.mCdnr.updateEfForEri(this.getOperatorNameFromEri());
        this.updateLteEarfcnLists(config);
        this.updateReportingCriteria(config);
        this.updateOperatorNamePattern(config);
        this.mCdnr.updateEfFromCarrierConfig(config);
        this.pollState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLteEarfcnLists(PersistableBundle config) {
        Object object = this.mLteRsrpBoostLock;
        synchronized (object) {
            this.mLteRsrpBoost = config.getInt("lte_earfcns_rsrp_boost_int", 0);
            String[] earfcnsStringArrayForRsrpBoost = config.getStringArray("boosted_lte_earfcns_string_array");
            this.mEarfcnPairListForRsrpBoost = this.convertEarfcnStringArrayToPairList(earfcnsStringArrayForRsrpBoost);
        }
    }

    private void updateReportingCriteria(PersistableBundle config) {
        this.mPhone.setSignalStrengthReportingCriteria(config.getIntArray("lte_rsrp_thresholds_int_array"), 3);
        this.mPhone.setSignalStrengthReportingCriteria(config.getIntArray("wcdma_rscp_thresholds_int_array"), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServiceStateLteEarfcnBoost(ServiceState serviceState, int lteEarfcn) {
        Object object = this.mLteRsrpBoostLock;
        synchronized (object) {
            if (lteEarfcn != -1 && this.containsEarfcnInEarfcnRange(this.mEarfcnPairListForRsrpBoost, lteEarfcn)) {
                serviceState.setLteEarfcnRsrpBoost(this.mLteRsrpBoost);
            } else {
                serviceState.setLteEarfcnRsrpBoost(0);
            }
        }
    }

    protected boolean onSignalStrengthResult(AsyncResult ar) {
        if (ar.exception == null && ar.result != null) {
            this.mSignalStrength = (SignalStrength)ar.result;
            PersistableBundle config = this.getCarrierConfig();
            this.mSignalStrength.updateLevel(config, this.mSS);
        } else {
            this.log("onSignalStrengthResult() Exception from RIL : " + ar.exception);
            this.mSignalStrength = new SignalStrength();
        }
        boolean ssChanged = this.notifySignalStrength();
        return ssChanged;
    }

    protected void hangupAndPowerOff() {
        if (!this.mPhone.isPhoneTypeGsm() || this.mPhone.isInCall()) {
            this.mPhone.mCT.mRingingCall.hangupIfAlive();
            this.mPhone.mCT.mBackgroundCall.hangupIfAlive();
            this.mPhone.mCT.mForegroundCall.hangupIfAlive();
        }
        this.mCi.setRadioPower(false, this.obtainMessage(54));
    }

    protected void cancelPollState() {
        this.mPollingContext = new int[1];
    }

    private boolean networkCountryIsoChanged(String newCountryIsoCode, String prevCountryIsoCode) {
        if (TextUtils.isEmpty(newCountryIsoCode)) {
            this.log("countryIsoChanged: no new country ISO code");
            return false;
        }
        if (TextUtils.isEmpty(prevCountryIsoCode)) {
            this.log("countryIsoChanged: no previous country ISO code");
            return true;
        }
        return !newCountryIsoCode.equals(prevCountryIsoCode);
    }

    private boolean iccCardExists() {
        boolean iccCardExist = false;
        if (this.mUiccApplcation != null) {
            iccCardExist = this.mUiccApplcation.getState() != IccCardApplicationStatus.AppState.APPSTATE_UNKNOWN;
        }
        return iccCardExist;
    }

    @UnsupportedAppUsage
    public String getSystemProperty(String property, String defValue) {
        return TelephonyManager.getTelephonyProperty(this.mPhone.getPhoneId(), property, defValue);
    }

    public List<CellInfo> getAllCellInfo() {
        return this.mLastCellInfoList;
    }

    public void setCellInfoMinInterval(int interval) {
        this.mCellInfoMinIntervalMs = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestAllCellInfo(WorkSource workSource, Message rspMsg) {
        if (this.mCi.getRilVersion() < 8) {
            AsyncResult.forMessage(rspMsg);
            rspMsg.sendToTarget();
            this.log("SST.requestAllCellInfo(): not implemented");
            return;
        }
        List<Message> list = this.mPendingCellInfoRequests;
        synchronized (list) {
            if (this.mIsPendingCellInfoRequest) {
                if (rspMsg != null) {
                    this.mPendingCellInfoRequests.add(rspMsg);
                }
                return;
            }
            long curTime = SystemClock.elapsedRealtime();
            if (curTime - this.mLastCellInfoReqTime < (long)this.mCellInfoMinIntervalMs) {
                if (rspMsg != null) {
                    this.log("SST.requestAllCellInfo(): return last, back to back calls");
                    AsyncResult.forMessage(rspMsg, this.mLastCellInfoList, null);
                    rspMsg.sendToTarget();
                }
                return;
            }
            if (rspMsg != null) {
                this.mPendingCellInfoRequests.add(rspMsg);
            }
            this.mLastCellInfoReqTime = curTime;
            this.mIsPendingCellInfoRequest = true;
            Message msg = this.obtainMessage(43);
            this.mCi.getCellInfoList(msg, workSource);
            this.sendMessageDelayed(this.obtainMessage(43), 2000L);
        }
    }

    public SignalStrength getSignalStrength() {
        return this.mSignalStrength;
    }

    public void registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mCdmaForSubscriptionInfoReadyRegistrants.add(r);
        if (this.isMinInfoReady()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForSubscriptionInfoReady(Handler h) {
        this.mCdmaForSubscriptionInfoReadyRegistrants.remove(h);
    }

    private void saveCdmaSubscriptionSource(int source) {
        this.log("Storing cdma subscription source: " + source);
        Settings.Global.putInt(this.mPhone.getContext().getContentResolver(), "subscription_mode", source);
        this.log("Read from settings: " + Settings.Global.getInt(this.mPhone.getContext().getContentResolver(), "subscription_mode", -1));
    }

    private void getSubscriptionInfoAndStartPollingThreads() {
        this.mCi.getCDMASubscription(this.obtainMessage(34));
        this.pollState();
    }

    private void handleCdmaSubscriptionSource(int newSubscriptionSource) {
        this.log("Subscription Source : " + newSubscriptionSource);
        this.mIsSubscriptionFromRuim = newSubscriptionSource == 0;
        this.log("isFromRuim: " + this.mIsSubscriptionFromRuim);
        this.saveCdmaSubscriptionSource(newSubscriptionSource);
        if (!this.mIsSubscriptionFromRuim) {
            this.sendMessage(this.obtainMessage(35));
        }
    }

    private void dumpEarfcnPairList(PrintWriter pw) {
        pw.print(" mEarfcnPairListForRsrpBoost={");
        if (this.mEarfcnPairListForRsrpBoost != null) {
            int i = this.mEarfcnPairListForRsrpBoost.size();
            for (Pair<Integer, Integer> earfcnPair : this.mEarfcnPairListForRsrpBoost) {
                pw.print("(");
                pw.print(earfcnPair.first);
                pw.print(",");
                pw.print(earfcnPair.second);
                pw.print(")");
                if (--i == 0) continue;
                pw.print(",");
            }
        }
        pw.println("}");
    }

    private void dumpCellInfoList(PrintWriter pw) {
        pw.print(" mLastCellInfoList={");
        if (this.mLastCellInfoList != null) {
            boolean first = true;
            for (CellInfo info : this.mLastCellInfoList) {
                if (!first) {
                    pw.print(",");
                }
                first = false;
                pw.print(info.toString());
            }
        }
        pw.println("}");
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ServiceStateTracker:");
        pw.println(" mSubId=" + this.mSubId);
        pw.println(" mSS=" + this.mSS);
        pw.println(" mNewSS=" + this.mNewSS);
        pw.println(" mVoiceCapable=" + this.mVoiceCapable);
        pw.println(" mRestrictedState=" + this.mRestrictedState);
        pw.println(" mPollingContext=" + this.mPollingContext + " - " + (this.mPollingContext != null ? Integer.valueOf(this.mPollingContext[0]) : ""));
        pw.println(" mDesiredPowerState=" + this.mDesiredPowerState);
        pw.println(" mDontPollSignalStrength=" + this.mDontPollSignalStrength);
        pw.println(" mSignalStrength=" + this.mSignalStrength);
        pw.println(" mLastSignalStrength=" + this.mLastSignalStrength);
        pw.println(" mRestrictedState=" + this.mRestrictedState);
        pw.println(" mPendingRadioPowerOffAfterDataOff=" + this.mPendingRadioPowerOffAfterDataOff);
        pw.println(" mPendingRadioPowerOffAfterDataOffTag=" + this.mPendingRadioPowerOffAfterDataOffTag);
        pw.println(" mCellIdentity=" + Rlog.pii(false, (Object)this.mCellIdentity));
        pw.println(" mNewCellIdentity=" + Rlog.pii(false, (Object)this.mNewCellIdentity));
        pw.println(" mLastCellInfoReqTime=" + this.mLastCellInfoReqTime);
        this.dumpCellInfoList(pw);
        pw.flush();
        pw.println(" mPreferredNetworkType=" + this.mPreferredNetworkType);
        pw.println(" mMaxDataCalls=" + this.mMaxDataCalls);
        pw.println(" mNewMaxDataCalls=" + this.mNewMaxDataCalls);
        pw.println(" mReasonDataDenied=" + this.mReasonDataDenied);
        pw.println(" mNewReasonDataDenied=" + this.mNewReasonDataDenied);
        pw.println(" mGsmRoaming=" + this.mGsmRoaming);
        pw.println(" mDataRoaming=" + this.mDataRoaming);
        pw.println(" mEmergencyOnly=" + this.mEmergencyOnly);
        pw.flush();
        this.mNitzState.dumpState(pw);
        pw.flush();
        pw.println(" mStartedGprsRegCheck=" + this.mStartedGprsRegCheck);
        pw.println(" mReportedGprsNoReg=" + this.mReportedGprsNoReg);
        pw.println(" mNotification=" + this.mNotification);
        pw.println(" mCurSpn=" + this.mCurSpn);
        pw.println(" mCurDataSpn=" + this.mCurDataSpn);
        pw.println(" mCurShowSpn=" + this.mCurShowSpn);
        pw.println(" mCurPlmn=" + this.mCurPlmn);
        pw.println(" mCurShowPlmn=" + this.mCurShowPlmn);
        pw.flush();
        pw.println(" mCurrentOtaspMode=" + this.mCurrentOtaspMode);
        pw.println(" mRoamingIndicator=" + this.mRoamingIndicator);
        pw.println(" mIsInPrl=" + this.mIsInPrl);
        pw.println(" mDefaultRoamingIndicator=" + this.mDefaultRoamingIndicator);
        pw.println(" mRegistrationState=" + this.mRegistrationState);
        pw.println(" mMdn=" + this.mMdn);
        pw.println(" mHomeSystemId=" + this.mHomeSystemId);
        pw.println(" mHomeNetworkId=" + this.mHomeNetworkId);
        pw.println(" mMin=" + this.mMin);
        pw.println(" mPrlVersion=" + this.mPrlVersion);
        pw.println(" mIsMinInfoReady=" + this.mIsMinInfoReady);
        pw.println(" mIsEriTextLoaded=" + this.mIsEriTextLoaded);
        pw.println(" mIsSubscriptionFromRuim=" + this.mIsSubscriptionFromRuim);
        pw.println(" mCdmaSSM=" + this.mCdmaSSM);
        pw.println(" mRegistrationDeniedReason=" + this.mRegistrationDeniedReason);
        pw.println(" mCurrentCarrier=" + this.mCurrentCarrier);
        pw.flush();
        pw.println(" mImsRegistered=" + this.mImsRegistered);
        pw.println(" mImsRegistrationOnOff=" + this.mImsRegistrationOnOff);
        pw.println(" mAlarmSwitch=" + this.mAlarmSwitch);
        pw.println(" mRadioDisabledByCarrier" + this.mRadioDisabledByCarrier);
        pw.println(" mPowerOffDelayNeed=" + this.mPowerOffDelayNeed);
        pw.println(" mDeviceShuttingDown=" + this.mDeviceShuttingDown);
        pw.println(" mSpnUpdatePending=" + this.mSpnUpdatePending);
        pw.println(" mLteRsrpBoost=" + this.mLteRsrpBoost);
        pw.println(" mCellInfoMinIntervalMs=" + this.mCellInfoMinIntervalMs);
        pw.println(" mEriManager=" + this.mEriManager);
        this.dumpEarfcnPairList(pw);
        this.mLocaleTracker.dump(fd, pw, args);
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "    ");
        this.mCdnr.dump(ipw);
        ipw.println(" Carrier Display Name update records:");
        ipw.increaseIndent();
        this.mCdnrLogs.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.println(" Roaming Log:");
        ipw.increaseIndent();
        this.mRoamingLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.println(" Attach Log:");
        ipw.increaseIndent();
        this.mAttachLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.println(" Phone Change Log:");
        ipw.increaseIndent();
        this.mPhoneTypeLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.println(" Rat Change Log:");
        ipw.increaseIndent();
        this.mRatLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.println(" Radio power Log:");
        ipw.increaseIndent();
        this.mRadioPowerLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        this.mNitzState.dumpLogs(fd, ipw, args);
        ipw.flush();
    }

    @UnsupportedAppUsage
    public boolean isImsRegistered() {
        return this.mImsRegistered;
    }

    protected void checkCorrectThread() {
        if (Thread.currentThread() != this.getLooper().getThread()) {
            throw new RuntimeException("ServiceStateTracker must be used from within one thread");
        }
    }

    protected boolean isCallerOnDifferentThread() {
        boolean value = Thread.currentThread() != this.getLooper().getThread();
        return value;
    }

    protected boolean inSameCountry(String operatorNumeric) {
        if (TextUtils.isEmpty(operatorNumeric) || operatorNumeric.length() < 5) {
            return false;
        }
        String homeNumeric = this.getHomeOperatorNumeric();
        if (TextUtils.isEmpty(homeNumeric) || homeNumeric.length() < 5) {
            return false;
        }
        boolean inSameCountry = true;
        String networkMCC = operatorNumeric.substring(0, 3);
        String homeMCC = homeNumeric.substring(0, 3);
        String networkCountry = MccTable.countryCodeForMcc(networkMCC);
        String homeCountry = MccTable.countryCodeForMcc(homeMCC);
        if (networkCountry.isEmpty() || homeCountry.isEmpty()) {
            return false;
        }
        inSameCountry = homeCountry.equals(networkCountry);
        if (inSameCountry) {
            return inSameCountry;
        }
        if ("us".equals(homeCountry) && "vi".equals(networkCountry)) {
            inSameCountry = true;
        } else if ("vi".equals(homeCountry) && "us".equals(networkCountry)) {
            inSameCountry = true;
        }
        return inSameCountry;
    }

    @UnsupportedAppUsage
    protected void setRoamingType(ServiceState currentServiceState) {
        boolean isVoiceInService;
        boolean bl = isVoiceInService = currentServiceState.getVoiceRegState() == 0;
        if (isVoiceInService) {
            if (currentServiceState.getVoiceRoaming()) {
                if (this.mPhone.isPhoneTypeGsm()) {
                    if (this.inSameCountry(currentServiceState.getVoiceOperatorNumeric())) {
                        currentServiceState.setVoiceRoamingType(2);
                    } else {
                        currentServiceState.setVoiceRoamingType(3);
                    }
                } else {
                    int[] intRoamingIndicators = this.mPhone.getContext().getResources().getIntArray(17235998);
                    if (intRoamingIndicators != null && intRoamingIndicators.length > 0) {
                        currentServiceState.setVoiceRoamingType(2);
                        int curRoamingIndicator = currentServiceState.getCdmaRoamingIndicator();
                        for (int i = 0; i < intRoamingIndicators.length; ++i) {
                            if (curRoamingIndicator != intRoamingIndicators[i]) continue;
                            currentServiceState.setVoiceRoamingType(3);
                            break;
                        }
                    } else if (this.inSameCountry(currentServiceState.getVoiceOperatorNumeric())) {
                        currentServiceState.setVoiceRoamingType(2);
                    } else {
                        currentServiceState.setVoiceRoamingType(3);
                    }
                }
            } else {
                currentServiceState.setVoiceRoamingType(0);
            }
        }
        boolean isDataInService = currentServiceState.getDataRegState() == 0;
        int dataRegType = currentServiceState.getRilDataRadioTechnology();
        if (isDataInService) {
            if (!currentServiceState.getDataRoaming()) {
                currentServiceState.setDataRoamingType(0);
            } else if (this.mPhone.isPhoneTypeGsm()) {
                if (ServiceState.isGsm(dataRegType)) {
                    if (isVoiceInService) {
                        currentServiceState.setDataRoamingType(currentServiceState.getVoiceRoamingType());
                    } else {
                        currentServiceState.setDataRoamingType(1);
                    }
                } else {
                    currentServiceState.setDataRoamingType(1);
                }
            } else if (ServiceState.isCdma(dataRegType)) {
                if (isVoiceInService) {
                    currentServiceState.setDataRoamingType(currentServiceState.getVoiceRoamingType());
                } else {
                    currentServiceState.setDataRoamingType(1);
                }
            } else if (this.inSameCountry(currentServiceState.getDataOperatorNumeric())) {
                currentServiceState.setDataRoamingType(2);
            } else {
                currentServiceState.setDataRoamingType(3);
            }
        }
    }

    @UnsupportedAppUsage
    private void setSignalStrengthDefaultValues() {
        this.mSignalStrength = new SignalStrength();
    }

    protected String getHomeOperatorNumeric() {
        String numeric = ((TelephonyManager)this.mPhone.getContext().getSystemService("phone")).getSimOperatorNumericForPhone(this.mPhone.getPhoneId());
        if (!this.mPhone.isPhoneTypeGsm() && TextUtils.isEmpty(numeric)) {
            numeric = SystemProperties.get("ro.cdma.home.operator.numeric", "");
        }
        return numeric;
    }

    @UnsupportedAppUsage
    protected int getPhoneId() {
        return this.mPhone.getPhoneId();
    }

    private void processIwlanRegistrationInfo() {
        NetworkRegistrationInfo wwanNri;
        if (this.mCi.getRadioState() == 0) {
            boolean resetIwlanRatVal = false;
            this.log("set service state as POWER_OFF");
            if (18 == this.mNewSS.getRilDataRadioTechnology()) {
                this.log("pollStateDone: mNewSS = " + this.mNewSS);
                this.log("pollStateDone: reset iwlan RAT value");
                resetIwlanRatVal = true;
            }
            String operator = this.mNewSS.getOperatorAlphaLong();
            this.mNewSS.setStateOff();
            if (resetIwlanRatVal) {
                this.mNewSS.setDataRegState(0);
                NetworkRegistrationInfo nri = new NetworkRegistrationInfo.Builder().setTransportType(2).setDomain(2).setAccessNetworkTechnology(18).setRegistrationState(1).build();
                this.mNewSS.addNetworkRegistrationInfo(nri);
                if (this.mTransportManager.isInLegacyMode()) {
                    nri = new NetworkRegistrationInfo.Builder().setTransportType(1).setDomain(2).setAccessNetworkTechnology(18).setRegistrationState(1).build();
                    this.mNewSS.addNetworkRegistrationInfo(nri);
                }
                this.mNewSS.setOperatorAlphaLong(operator);
                this.log("pollStateDone: mNewSS = " + this.mNewSS);
            }
            return;
        }
        if (this.mTransportManager.isInLegacyMode() && (wwanNri = this.mNewSS.getNetworkRegistrationInfo(2, 1)) != null && wwanNri.getAccessNetworkTechnology() == 18) {
            NetworkRegistrationInfo wlanNri = new NetworkRegistrationInfo.Builder().setTransportType(2).setDomain(2).setRegistrationState(wwanNri.getRegistrationState()).setAccessNetworkTechnology(18).setRejectCause(wwanNri.getRejectCause()).setEmergencyOnly(wwanNri.isEmergencyEnabled()).setAvailableServices(wwanNri.getAvailableServices()).build();
            this.mNewSS.addNetworkRegistrationInfo(wlanNri);
        }
    }

    protected final boolean alwaysOnHomeNetwork(BaseBundle b) {
        return b.getBoolean("force_home_network_bool");
    }

    private boolean isInNetwork(BaseBundle b, String network, String key) {
        String[] networks = b.getStringArray(key);
        return networks != null && Arrays.asList(networks).contains(network);
    }

    protected final boolean isRoamingInGsmNetwork(BaseBundle b, String network) {
        return this.isInNetwork(b, network, "gsm_roaming_networks_string_array");
    }

    protected final boolean isNonRoamingInGsmNetwork(BaseBundle b, String network) {
        return this.isInNetwork(b, network, "gsm_nonroaming_networks_string_array");
    }

    protected final boolean isRoamingInCdmaNetwork(BaseBundle b, String network) {
        return this.isInNetwork(b, network, "cdma_roaming_networks_string_array");
    }

    protected final boolean isNonRoamingInCdmaNetwork(BaseBundle b, String network) {
        return this.isInNetwork(b, network, "cdma_nonroaming_networks_string_array");
    }

    public boolean isDeviceShuttingDown() {
        return this.mDeviceShuttingDown;
    }

    protected int getCombinedRegState(ServiceState ss) {
        int regState = ss.getVoiceRegState();
        int dataRegState = ss.getDataRegState();
        if ((regState == 1 || regState == 3) && dataRegState == 0) {
            this.log("getCombinedRegState: return STATE_IN_SERVICE as Data is in service");
            regState = dataRegState;
        }
        return regState;
    }

    private PersistableBundle getCarrierConfig() {
        PersistableBundle config;
        CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        if (configManager != null && (config = configManager.getConfigForSubId(this.mPhone.getSubId())) != null) {
            return config;
        }
        return CarrierConfigManager.getDefaultConfig();
    }

    public LocaleTracker getLocaleTracker() {
        return this.mLocaleTracker;
    }

    String getCdmaEriText(int roamInd, int defRoamInd) {
        return this.mEriManager.getCdmaEriText(roamInd, defRoamInd);
    }

    private void updateOperatorNamePattern(PersistableBundle config) {
        String operatorNamePattern = config.getString("operator_name_filter_pattern_string");
        if (!TextUtils.isEmpty(operatorNamePattern)) {
            this.mOperatorNameStringPattern = Pattern.compile(operatorNamePattern);
            this.log("mOperatorNameStringPattern: " + this.mOperatorNameStringPattern.toString());
        }
    }

    private void updateOperatorNameForServiceState(ServiceState servicestate) {
        if (servicestate == null) {
            return;
        }
        servicestate.setOperatorName(this.filterOperatorNameByPattern(servicestate.getOperatorAlphaLong()), this.filterOperatorNameByPattern(servicestate.getOperatorAlphaShort()), servicestate.getOperatorNumeric());
        List<NetworkRegistrationInfo> networkRegistrationInfos = servicestate.getNetworkRegistrationInfoList();
        for (int i = 0; i < networkRegistrationInfos.size(); ++i) {
            if (networkRegistrationInfos.get(i) == null) continue;
            this.updateOperatorNameForCellIdentity(networkRegistrationInfos.get(i).getCellIdentity());
        }
    }

    private void updateOperatorNameForCellIdentity(CellIdentity cellIdentity) {
        if (cellIdentity == null) {
            return;
        }
        cellIdentity.setOperatorAlphaLong(this.filterOperatorNameByPattern((String)cellIdentity.getOperatorAlphaLong()));
        cellIdentity.setOperatorAlphaShort(this.filterOperatorNameByPattern((String)cellIdentity.getOperatorAlphaShort()));
    }

    public void updateOperatorNameForCellInfo(List<CellInfo> cellInfos) {
        if (cellInfos == null || cellInfos.isEmpty()) {
            return;
        }
        for (CellInfo cellInfo : cellInfos) {
            if (!cellInfo.isRegistered()) continue;
            this.updateOperatorNameForCellIdentity(cellInfo.getCellIdentity());
        }
    }

    public String filterOperatorNameByPattern(String operatorName) {
        if (this.mOperatorNameStringPattern == null || TextUtils.isEmpty(operatorName)) {
            return operatorName;
        }
        Matcher matcher = this.mOperatorNameStringPattern.matcher(operatorName);
        if (matcher.find()) {
            if (matcher.groupCount() > 0) {
                operatorName = matcher.group(1);
            } else {
                this.log("filterOperatorNameByPattern: pattern no group");
            }
        }
        return operatorName;
    }

    private class SstSubscriptionsChangedListener
    extends SubscriptionManager.OnSubscriptionsChangedListener {
        public final AtomicInteger mPreviousSubId = new AtomicInteger(-1);

        private SstSubscriptionsChangedListener() {
        }

        @Override
        public void onSubscriptionsChanged() {
            ServiceStateTracker.this.log("SubscriptionListener.onSubscriptionInfoChanged");
            int subId = ServiceStateTracker.this.mPhone.getSubId();
            ServiceStateTracker.this.mPrevSubId = this.mPreviousSubId.get();
            if (this.mPreviousSubId.getAndSet(subId) != subId) {
                if (SubscriptionManager.isValidSubscriptionId(subId)) {
                    Context context = ServiceStateTracker.this.mPhone.getContext();
                    ServiceStateTracker.this.mPhone.notifyPhoneStateChanged();
                    ServiceStateTracker.this.mPhone.notifyCallForwardingIndicator();
                    boolean restoreSelection = !context.getResources().getBoolean(0x111011F);
                    ServiceStateTracker.this.mPhone.sendSubscriptionSettings(restoreSelection);
                    ServiceStateTracker.this.mPhone.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(ServiceStateTracker.this.mSS.getRilDataRadioTechnology()));
                    if (ServiceStateTracker.this.mSpnUpdatePending) {
                        ServiceStateTracker.this.mSubscriptionController.setPlmnSpn(ServiceStateTracker.this.mPhone.getPhoneId(), ServiceStateTracker.this.mCurShowPlmn, ServiceStateTracker.this.mCurPlmn, ServiceStateTracker.this.mCurShowSpn, ServiceStateTracker.this.mCurSpn);
                        ServiceStateTracker.this.mSpnUpdatePending = false;
                    }
                    SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
                    String oldNetworkSelection = sp.getString("network_selection_key", "");
                    String oldNetworkSelectionName = sp.getString("network_selection_name_key", "");
                    String oldNetworkSelectionShort = sp.getString("network_selection_short_key", "");
                    if (!(TextUtils.isEmpty(oldNetworkSelection) && TextUtils.isEmpty(oldNetworkSelectionName) && TextUtils.isEmpty(oldNetworkSelectionShort))) {
                        SharedPreferences.Editor editor = sp.edit();
                        editor.putString("network_selection_key" + subId, oldNetworkSelection);
                        editor.putString("network_selection_name_key" + subId, oldNetworkSelectionName);
                        editor.putString("network_selection_short_key" + subId, oldNetworkSelectionShort);
                        editor.remove("network_selection_key");
                        editor.remove("network_selection_name_key");
                        editor.remove("network_selection_short_key");
                        editor.commit();
                    }
                    ServiceStateTracker.this.updateSpnDisplay();
                }
                ServiceStateTracker.this.mPhone.updateVoiceMail();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CarrierNameDisplayBitmask {
    }
}

