/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.telephony.Rlog;
import android.util.LocalLog;
import com.android.internal.telephony.Phone;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;

public class SimActivationTracker {
    private static final boolean DBG = true;
    private static final String LOG_TAG = "SAT";
    private static final boolean VDBG = Rlog.isLoggable("SAT", 2);
    private Phone mPhone;
    private int mVoiceActivationState;
    private int mDataActivationState;
    private final LocalLog mVoiceActivationStateLog = new LocalLog(10);
    private final LocalLog mDataActivationStateLog = new LocalLog(10);
    private final BroadcastReceiver mReceiver;

    public SimActivationTracker(Phone phone) {
        this.mPhone = phone;
        this.mVoiceActivationState = 0;
        this.mDataActivationState = 0;
        this.mReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (VDBG) {
                    SimActivationTracker.this.log("action: " + action);
                }
                if ("android.intent.action.SIM_STATE_CHANGED".equals(action) && "ABSENT".equals(intent.getStringExtra("ss"))) {
                    SimActivationTracker.this.log("onSimAbsent, reset activation state to UNKNOWN");
                    SimActivationTracker.this.setVoiceActivationState(0);
                    SimActivationTracker.this.setDataActivationState(0);
                }
            }
        };
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SIM_STATE_CHANGED");
        this.mPhone.getContext().registerReceiver(this.mReceiver, intentFilter);
    }

    public void setVoiceActivationState(int state) {
        if (!SimActivationTracker.isValidActivationState(state) || 4 == state) {
            throw new IllegalArgumentException("invalid voice activation state: " + state);
        }
        this.log("setVoiceActivationState=" + state);
        this.mVoiceActivationState = state;
        this.mVoiceActivationStateLog.log(SimActivationTracker.toString(state));
        this.mPhone.notifyVoiceActivationStateChanged(state);
    }

    public void setDataActivationState(int state) {
        if (!SimActivationTracker.isValidActivationState(state)) {
            throw new IllegalArgumentException("invalid data activation state: " + state);
        }
        this.log("setDataActivationState=" + state);
        this.mDataActivationState = state;
        this.mDataActivationStateLog.log(SimActivationTracker.toString(state));
        this.mPhone.notifyDataActivationStateChanged(state);
    }

    public int getVoiceActivationState() {
        return this.mVoiceActivationState;
    }

    public int getDataActivationState() {
        return this.mDataActivationState;
    }

    private static boolean isValidActivationState(int state) {
        switch (state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private static String toString(int state) {
        switch (state) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "activating";
            }
            case 2: {
                return "activated";
            }
            case 3: {
                return "deactivated";
            }
            case 4: {
                return "restricted";
            }
        }
        return "invalid";
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private void loge(String s) {
        Rlog.e(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        pw.println(" mVoiceActivationState Log:");
        ipw.increaseIndent();
        this.mVoiceActivationStateLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        pw.println(" mDataActivationState Log:");
        ipw.increaseIndent();
        this.mDataActivationStateLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
    }

    public void dispose() {
        this.mPhone.getContext().unregisterReceiver(this.mReceiver);
    }
}

