/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.app.role.RoleManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Process;
import android.os.UserHandle;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.content.PackageMonitor;
import com.android.internal.logging.MetricsLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public final class SmsApplication {
    static final String LOG_TAG = "SmsApplication";
    private static final String PHONE_PACKAGE_NAME = "com.android.phone";
    private static final String BLUETOOTH_PACKAGE_NAME = "com.android.bluetooth";
    private static final String MMS_SERVICE_PACKAGE_NAME = "com.android.mms.service";
    private static final String TELEPHONY_PROVIDER_PACKAGE_NAME = "com.android.providers.telephony";
    private static final String SCHEME_SMS = "sms";
    private static final String SCHEME_SMSTO = "smsto";
    private static final String SCHEME_MMS = "mms";
    private static final String SCHEME_MMSTO = "mmsto";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_MULTIUSER = false;
    private static final int[] DEFAULT_APP_EXCLUSIVE_APPOPS = new int[]{14, 15, 16, 19, 20, 57};
    private static SmsPackageMonitor sSmsPackageMonitor = null;

    private static int getIncomingUserId(Context context) {
        int contextUserId = context.getUserId();
        int callingUid = Binder.getCallingUid();
        if (UserHandle.getAppId(callingUid) < 10000) {
            return contextUserId;
        }
        return UserHandle.getUserId(callingUid);
    }

    public static Collection<SmsApplicationData> getApplicationCollection(Context context) {
        return SmsApplication.getApplicationCollectionAsUser(context, SmsApplication.getIncomingUserId(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<SmsApplicationData> getApplicationCollectionAsUser(Context context, int userId) {
        long token = Binder.clearCallingIdentity();
        try {
            Collection<SmsApplicationData> collection = SmsApplication.getApplicationCollectionInternal(context, userId);
            return collection;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static Collection<SmsApplicationData> getApplicationCollectionInternal(Context context, int userId) {
        String packageName;
        SmsApplicationData smsApplicationData;
        ActivityInfo activityInfo;
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.provider.Telephony.SMS_DELIVER");
        List<ResolveInfo> smsReceivers = packageManager.queryBroadcastReceiversAsUser(intent, 786432, userId);
        HashMap<String, SmsApplicationData> receivers = new HashMap<String, SmsApplicationData>();
        for (ResolveInfo resolveInfo : smsReceivers) {
            String string2;
            ActivityInfo activityInfo2 = resolveInfo.activityInfo;
            if (activityInfo2 == null || !"android.permission.BROADCAST_SMS".equals(activityInfo2.permission) || receivers.containsKey(string2 = activityInfo2.packageName)) continue;
            SmsApplicationData smsApplicationData2 = new SmsApplicationData(string2, activityInfo2.applicationInfo.uid);
            smsApplicationData2.mSmsReceiverClass = activityInfo2.name;
            receivers.put(string2, smsApplicationData2);
        }
        intent = new Intent("android.provider.Telephony.WAP_PUSH_DELIVER");
        intent.setDataAndType(null, "application/vnd.wap.mms-message");
        List<ResolveInfo> mmsReceivers = packageManager.queryBroadcastReceiversAsUser(intent, 786432, userId);
        for (ResolveInfo resolveInfo : mmsReceivers) {
            String string3;
            SmsApplicationData smsApplicationData3;
            ActivityInfo activityInfo3 = resolveInfo.activityInfo;
            if (activityInfo3 == null || !"android.permission.BROADCAST_WAP_PUSH".equals(activityInfo3.permission) || (smsApplicationData3 = (SmsApplicationData)receivers.get(string3 = activityInfo3.packageName)) == null) continue;
            smsApplicationData3.mMmsReceiverClass = activityInfo3.name;
        }
        intent = new Intent("android.intent.action.RESPOND_VIA_MESSAGE", Uri.fromParts(SCHEME_SMSTO, "", null));
        List<ResolveInfo> list = packageManager.queryIntentServicesAsUser(intent, 786432, userId);
        for (ResolveInfo resolveInfo : list) {
            String string4;
            SmsApplicationData smsApplicationData4;
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (serviceInfo == null || !"android.permission.SEND_RESPOND_VIA_MESSAGE".equals(serviceInfo.permission) || (smsApplicationData4 = (SmsApplicationData)receivers.get(string4 = serviceInfo.packageName)) == null) continue;
            smsApplicationData4.mRespondViaMessageClass = serviceInfo.name;
        }
        intent = new Intent("android.intent.action.SENDTO", Uri.fromParts(SCHEME_SMSTO, "", null));
        List<ResolveInfo> list2 = packageManager.queryIntentActivitiesAsUser(intent, 786432, userId);
        for (ResolveInfo resolveInfo : list2) {
            String packageName5;
            SmsApplicationData smsApplicationData5;
            ActivityInfo activityInfo4 = resolveInfo.activityInfo;
            if (activityInfo4 == null || (smsApplicationData5 = (SmsApplicationData)receivers.get(packageName5 = activityInfo4.packageName)) == null) continue;
            smsApplicationData5.mSendToClass = activityInfo4.name;
        }
        intent = new Intent("android.provider.action.DEFAULT_SMS_PACKAGE_CHANGED");
        List<ResolveInfo> list3 = packageManager.queryBroadcastReceiversAsUser(intent, 786432, userId);
        for (ResolveInfo resolveInfo : list3) {
            String packageName6;
            SmsApplicationData smsApplicationData6;
            ActivityInfo activityInfo5 = resolveInfo.activityInfo;
            if (activityInfo5 == null || (smsApplicationData6 = (SmsApplicationData)receivers.get(packageName6 = activityInfo5.packageName)) == null) continue;
            smsApplicationData6.mSmsAppChangedReceiverClass = activityInfo5.name;
        }
        intent = new Intent("android.provider.action.EXTERNAL_PROVIDER_CHANGE");
        List<ResolveInfo> list4 = packageManager.queryBroadcastReceiversAsUser(intent, 786432, userId);
        for (ResolveInfo resolveInfo : list4) {
            String packageName7;
            SmsApplicationData smsApplicationData7;
            ActivityInfo activityInfo6 = resolveInfo.activityInfo;
            if (activityInfo6 == null || (smsApplicationData7 = (SmsApplicationData)receivers.get(packageName7 = activityInfo6.packageName)) == null) continue;
            smsApplicationData7.mProviderChangedReceiverClass = activityInfo6.name;
        }
        intent = new Intent("android.provider.Telephony.SIM_FULL");
        List<ResolveInfo> list5 = packageManager.queryBroadcastReceiversAsUser(intent, 786432, userId);
        for (ResolveInfo resolveInfo : list5) {
            activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || (smsApplicationData = (SmsApplicationData)receivers.get(packageName = activityInfo.packageName)) == null) continue;
            smsApplicationData.mSimFullReceiverClass = activityInfo.name;
        }
        for (ResolveInfo resolveInfo : smsReceivers) {
            activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || (smsApplicationData = (SmsApplicationData)receivers.get(packageName = activityInfo.packageName)) == null || smsApplicationData.isComplete()) continue;
            Log.w(LOG_TAG, "Package " + packageName + " lacks required manifest declarations to be a default sms app: " + smsApplicationData);
            receivers.remove(packageName);
        }
        return receivers.values();
    }

    public static SmsApplicationData getApplicationForPackage(Collection<SmsApplicationData> applications, String packageName) {
        if (packageName == null) {
            return null;
        }
        for (SmsApplicationData application : applications) {
            if (!application.mPackageName.contentEquals(packageName)) continue;
            return application;
        }
        return null;
    }

    private static SmsApplicationData getApplication(Context context, boolean updateIfNeeded, int userId) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        RoleManager roleManager = (RoleManager)context.getSystemService("role");
        if (!(tm.isSmsCapable() || roleManager != null && roleManager.isRoleAvailable("android.app.role.SMS"))) {
            return null;
        }
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollectionInternal(context, userId);
        String defaultApplication = SmsApplication.getDefaultSmsPackage(context, userId);
        SmsApplicationData applicationData = null;
        if (defaultApplication != null) {
            applicationData = SmsApplication.getApplicationForPackage(applications, defaultApplication);
        }
        if (applicationData != null) {
            boolean appOpsFixed;
            if ((updateIfNeeded || applicationData.mUid == Process.myUid()) && !(appOpsFixed = SmsApplication.tryFixExclusiveSmsAppops(context, applicationData, updateIfNeeded))) {
                applicationData = null;
            }
            if (applicationData != null && updateIfNeeded) {
                SmsApplication.defaultSmsAppChanged(context);
            }
        }
        return applicationData;
    }

    private static String getDefaultSmsPackage(Context context, int userId) {
        return context.getSystemService(RoleManager.class).getDefaultSmsPackage(userId);
    }

    private static void defaultSmsAppChanged(Context context) {
        PackageManager packageManager = context.getPackageManager();
        AppOpsManager appOps = context.getSystemService(AppOpsManager.class);
        SmsApplication.assignExclusiveSmsPermissionsToSystemApp(context, packageManager, appOps, PHONE_PACKAGE_NAME);
        SmsApplication.assignExclusiveSmsPermissionsToSystemApp(context, packageManager, appOps, BLUETOOTH_PACKAGE_NAME);
        SmsApplication.assignExclusiveSmsPermissionsToSystemApp(context, packageManager, appOps, MMS_SERVICE_PACKAGE_NAME);
        SmsApplication.assignExclusiveSmsPermissionsToSystemApp(context, packageManager, appOps, TELEPHONY_PROVIDER_PACKAGE_NAME);
        for (int appop : DEFAULT_APP_EXCLUSIVE_APPOPS) {
            appOps.setUidMode(appop, 1001, 0);
        }
    }

    private static boolean tryFixExclusiveSmsAppops(Context context, SmsApplicationData applicationData, boolean updateIfNeeded) {
        AppOpsManager appOps = context.getSystemService(AppOpsManager.class);
        for (int appOp : DEFAULT_APP_EXCLUSIVE_APPOPS) {
            int mode = appOps.checkOp(appOp, applicationData.mUid, applicationData.mPackageName);
            if (mode == 0) continue;
            Rlog.e(LOG_TAG, applicationData.mPackageName + " lost " + AppOpsManager.modeToName(appOp) + ": " + (updateIfNeeded ? " (fixing)" : " (no permission to fix)"));
            if (updateIfNeeded) {
                appOps.setUidMode(appOp, applicationData.mUid, 0);
                continue;
            }
            return false;
        }
        return true;
    }

    public static void setDefaultApplication(String packageName, Context context) {
        SmsApplication.setDefaultApplicationAsUser(packageName, context, SmsApplication.getIncomingUserId(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultApplicationAsUser(String packageName, Context context, int userId) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        RoleManager roleManager = (RoleManager)context.getSystemService("role");
        if (!(tm.isSmsCapable() || roleManager != null && roleManager.isRoleAvailable("android.app.role.SMS"))) {
            return;
        }
        long token = Binder.clearCallingIdentity();
        try {
            SmsApplication.setDefaultApplicationInternal(packageName, context, userId);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static void setDefaultApplicationInternal(String packageName, Context context, int userId) {
        UserHandle userHandle = UserHandle.of(userId);
        String oldPackageName = SmsApplication.getDefaultSmsPackage(context, userId);
        if (packageName != null && oldPackageName != null && packageName.equals(oldPackageName)) {
            return;
        }
        PackageManager packageManager = context.getPackageManager();
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollectionInternal(context, userId);
        SmsApplicationData oldAppData = oldPackageName != null ? SmsApplication.getApplicationForPackage(applications, oldPackageName) : null;
        SmsApplicationData applicationData = SmsApplication.getApplicationForPackage(applications, packageName);
        if (applicationData != null) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            if (oldPackageName != null) {
                try {
                    int uid = packageManager.getPackageInfoAsUser((String)oldPackageName, (int)0, (int)userId).applicationInfo.uid;
                    SmsApplication.setExclusiveAppops(oldPackageName, appOps, uid, 3);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Rlog.w(LOG_TAG, "Old SMS package not found: " + oldPackageName);
                }
            }
            CompletableFuture future = new CompletableFuture();
            Consumer<Boolean> callback = successful -> {
                if (successful.booleanValue()) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(new RuntimeException());
                }
            };
            context.getSystemService(RoleManager.class).addRoleHolderAsUser("android.app.role.SMS", applicationData.mPackageName, 0, UserHandle.of(userId), AsyncTask.THREAD_POOL_EXECUTOR, callback);
            try {
                future.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                Log.e(LOG_TAG, "Exception while adding sms role holder " + applicationData, e);
                return;
            }
            SmsApplication.defaultSmsAppChanged(context);
        }
    }

    public static void broadcastSmsAppChange(Context context, UserHandle userHandle, String oldPackage, String newPackage) {
        Collection<SmsApplicationData> apps = SmsApplication.getApplicationCollection(context);
        SmsApplication.broadcastSmsAppChange(context, userHandle, SmsApplication.getApplicationForPackage(apps, oldPackage), SmsApplication.getApplicationForPackage(apps, newPackage));
    }

    private static void broadcastSmsAppChange(Context context, UserHandle userHandle, SmsApplicationData oldAppData, SmsApplicationData applicationData) {
        Intent intent;
        ComponentName component;
        if (oldAppData != null && oldAppData.mSmsAppChangedReceiverClass != null) {
            Intent oldAppIntent = new Intent("android.provider.action.DEFAULT_SMS_PACKAGE_CHANGED");
            component = new ComponentName(oldAppData.mPackageName, oldAppData.mSmsAppChangedReceiverClass);
            oldAppIntent.setComponent(component);
            oldAppIntent.putExtra("android.provider.extra.IS_DEFAULT_SMS_APP", false);
            context.sendBroadcastAsUser(oldAppIntent, userHandle);
        }
        if (applicationData != null && applicationData.mSmsAppChangedReceiverClass != null) {
            intent = new Intent("android.provider.action.DEFAULT_SMS_PACKAGE_CHANGED");
            component = new ComponentName(applicationData.mPackageName, applicationData.mSmsAppChangedReceiverClass);
            intent.setComponent(component);
            intent.putExtra("android.provider.extra.IS_DEFAULT_SMS_APP", true);
            context.sendBroadcastAsUser(intent, userHandle);
        }
        intent = new Intent("android.provider.action.DEFAULT_SMS_PACKAGE_CHANGED_INTERNAL");
        context.sendBroadcastAsUser(intent, userHandle, "android.permission.MONITOR_DEFAULT_SMS_PACKAGE");
        if (applicationData != null) {
            MetricsLogger.action(context, 266, applicationData.mPackageName);
        }
    }

    private static void assignExclusiveSmsPermissionsToSystemApp(Context context, PackageManager packageManager, AppOpsManager appOps, String packageName) {
        int result = packageManager.checkSignatures(context.getPackageName(), packageName);
        if (result != 0) {
            Rlog.e(LOG_TAG, packageName + " does not have system signature");
            return;
        }
        try {
            PackageInfo info = packageManager.getPackageInfo(packageName, 0);
            int mode = appOps.checkOp(15, info.applicationInfo.uid, packageName);
            if (mode != 0) {
                Rlog.w(LOG_TAG, packageName + " does not have OP_WRITE_SMS:  (fixing)");
                SmsApplication.setExclusiveAppops(packageName, appOps, info.applicationInfo.uid, 0);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Rlog.e(LOG_TAG, "Package not found: " + packageName);
        }
    }

    private static void setExclusiveAppops(String pkg, AppOpsManager appOpsManager, int uid, int mode) {
        for (int appop : DEFAULT_APP_EXCLUSIVE_APPOPS) {
            appOpsManager.setUidMode(appop, uid, mode);
        }
    }

    public static void initSmsPackageMonitor(Context context) {
        sSmsPackageMonitor = new SmsPackageMonitor(context);
        sSmsPackageMonitor.register(context, context.getMainLooper(), UserHandle.ALL, false);
    }

    private static void configurePreferredActivity(PackageManager packageManager, ComponentName componentName, int userId) {
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, SCHEME_SMS);
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, SCHEME_SMSTO);
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, SCHEME_MMS);
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, SCHEME_MMSTO);
    }

    private static void replacePreferredActivity(PackageManager packageManager, ComponentName componentName, int userId, String scheme) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.fromParts(scheme, "", null));
        List<ResolveInfo> resolveInfoList = packageManager.queryIntentActivitiesAsUser(intent, 65600, userId);
        int n = resolveInfoList.size();
        ComponentName[] set = new ComponentName[n];
        for (int i = 0; i < n; ++i) {
            ResolveInfo info = resolveInfoList.get(i);
            set[i] = new ComponentName(info.activityInfo.packageName, info.activityInfo.name);
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SENDTO");
        intentFilter.addCategory("android.intent.category.DEFAULT");
        intentFilter.addDataScheme(scheme);
        packageManager.replacePreferredActivityAsUser(intentFilter, 0x208000, set, componentName, userId);
    }

    public static SmsApplicationData getSmsApplicationData(String packageName, Context context) {
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollection(context);
        return SmsApplication.getApplicationForPackage(applications, packageName);
    }

    public static ComponentName getDefaultSmsApplication(Context context, boolean updateIfNeeded) {
        return SmsApplication.getDefaultSmsApplicationAsUser(context, updateIfNeeded, SmsApplication.getIncomingUserId(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentName getDefaultSmsApplicationAsUser(Context context, boolean updateIfNeeded, int userId) {
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mSmsReceiverClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentName getDefaultMmsApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mMmsReceiverClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentName getDefaultRespondViaMessageApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mRespondViaMessageClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentName getDefaultSendToApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mSendToClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentName getDefaultExternalTelephonyProviderChangedApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null && smsApplicationData.mProviderChangedReceiverClass != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mProviderChangedReceiverClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentName getDefaultSimFullApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null && smsApplicationData.mSimFullReceiverClass != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mSimFullReceiverClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    public static boolean shouldWriteMessageForPackage(String packageName, Context context) {
        if (SmsManager.getDefault().getAutoPersisting()) {
            return true;
        }
        return !SmsApplication.isDefaultSmsApplication(context, packageName);
    }

    public static boolean isDefaultSmsApplication(Context context, String packageName) {
        if (packageName == null) {
            return false;
        }
        String defaultSmsPackage = SmsApplication.getDefaultSmsApplicationPackageName(context);
        return defaultSmsPackage != null && defaultSmsPackage.equals(packageName) || BLUETOOTH_PACKAGE_NAME.equals(packageName);
    }

    private static String getDefaultSmsApplicationPackageName(Context context) {
        ComponentName component = SmsApplication.getDefaultSmsApplication(context, false);
        if (component != null) {
            return component.getPackageName();
        }
        return null;
    }

    private static final class SmsPackageMonitor
    extends PackageMonitor {
        final Context mContext;

        public SmsPackageMonitor(Context context) {
            this.mContext = context;
        }

        @Override
        public void onPackageDisappeared(String packageName, int reason) {
            this.onPackageChanged();
        }

        @Override
        public void onPackageAppeared(String packageName, int reason) {
            this.onPackageChanged();
        }

        @Override
        public void onPackageModified(String packageName) {
            this.onPackageChanged();
        }

        private void onPackageChanged() {
            ComponentName componentName;
            PackageManager packageManager = this.mContext.getPackageManager();
            Context userContext = this.mContext;
            int userId = this.getSendingUserId();
            if (userId != 0) {
                try {
                    userContext = this.mContext.createPackageContextAsUser(this.mContext.getPackageName(), 0, new UserHandle(userId));
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            if ((componentName = SmsApplication.getDefaultSendToApplication(userContext, true)) != null) {
                SmsApplication.configurePreferredActivity(packageManager, componentName, userId);
            }
        }
    }

    public static class SmsApplicationData {
        private String mApplicationName;
        public String mPackageName;
        private String mSmsReceiverClass;
        private String mMmsReceiverClass;
        private String mRespondViaMessageClass;
        private String mSendToClass;
        private String mSmsAppChangedReceiverClass;
        private String mProviderChangedReceiverClass;
        private String mSimFullReceiverClass;
        private int mUid;

        public boolean isComplete() {
            return this.mSmsReceiverClass != null && this.mMmsReceiverClass != null && this.mRespondViaMessageClass != null && this.mSendToClass != null;
        }

        public SmsApplicationData(String packageName, int uid) {
            this.mPackageName = packageName;
            this.mUid = uid;
        }

        public String getApplicationName(Context context) {
            if (this.mApplicationName == null) {
                ApplicationInfo appInfo;
                PackageManager pm = context.getPackageManager();
                try {
                    appInfo = pm.getApplicationInfoAsUser(this.mPackageName, 0, UserHandle.getUserId(this.mUid));
                }
                catch (PackageManager.NameNotFoundException e) {
                    return null;
                }
                if (appInfo != null) {
                    CharSequence label = pm.getApplicationLabel(appInfo);
                    this.mApplicationName = label == null ? null : label.toString();
                }
            }
            return this.mApplicationName;
        }

        public String toString() {
            return " mPackageName: " + this.mPackageName + " mSmsReceiverClass: " + this.mSmsReceiverClass + " mMmsReceiverClass: " + this.mMmsReceiverClass + " mRespondViaMessageClass: " + this.mRespondViaMessageClass + " mSendToClass: " + this.mSendToClass + " mSmsAppChangedClass: " + this.mSmsAppChangedReceiverClass + " mProviderChangedReceiverClass: " + this.mProviderChangedReceiverClass + " mSimFullReceiverClass: " + this.mSimFullReceiverClass + " mUid: " + this.mUid;
        }
    }
}

