/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.database.SQLException;
import android.os.PersistableBundle;
import android.os.UserManager;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import com.android.internal.telephony.InboundSmsHandler;
import com.android.internal.telephony.InboundSmsTracker;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.cdma.CdmaInboundSmsHandler;
import com.android.internal.telephony.gsm.GsmInboundSmsHandler;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import java.util.HashMap;
import java.util.HashSet;

public class SmsBroadcastUndelivered {
    private static final String TAG = "SmsBroadcastUndelivered";
    private static final boolean DBG = true;
    static final long DEFAULT_PARTIAL_SEGMENT_EXPIRE_AGE = 604800000L;
    private static final String[] PDU_PENDING_MESSAGE_PROJECTION = new String[]{"pdu", "sequence", "destination_port", "date", "reference_number", "count", "address", "_id", "message_body", "display_originating_addr"};
    private static SmsBroadcastUndelivered instance;
    private final ContentResolver mResolver;
    private final GsmInboundSmsHandler mGsmInboundSmsHandler;
    private final CdmaInboundSmsHandler mCdmaInboundSmsHandler;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Rlog.d(SmsBroadcastUndelivered.TAG, "Received broadcast " + intent.getAction());
            if ("android.intent.action.USER_UNLOCKED".equals(intent.getAction())) {
                new ScanRawTableThread(context).start();
            }
        }
    };

    public static void initialize(Context context, GsmInboundSmsHandler gsmInboundSmsHandler, CdmaInboundSmsHandler cdmaInboundSmsHandler) {
        if (instance == null) {
            instance = new SmsBroadcastUndelivered(context, gsmInboundSmsHandler, cdmaInboundSmsHandler);
        }
        if (gsmInboundSmsHandler != null) {
            gsmInboundSmsHandler.sendMessage(6);
        }
        if (cdmaInboundSmsHandler != null) {
            cdmaInboundSmsHandler.sendMessage(6);
        }
    }

    @UnsupportedAppUsage
    private SmsBroadcastUndelivered(Context context, GsmInboundSmsHandler gsmInboundSmsHandler, CdmaInboundSmsHandler cdmaInboundSmsHandler) {
        this.mResolver = context.getContentResolver();
        this.mGsmInboundSmsHandler = gsmInboundSmsHandler;
        this.mCdmaInboundSmsHandler = cdmaInboundSmsHandler;
        UserManager userManager = (UserManager)context.getSystemService("user");
        if (userManager.isUserUnlocked()) {
            new ScanRawTableThread(context).start();
        } else {
            IntentFilter userFilter = new IntentFilter();
            userFilter.addAction("android.intent.action.USER_UNLOCKED");
            context.registerReceiver(this.mBroadcastReceiver, userFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void scanRawTable(Context context, CdmaInboundSmsHandler cdmaInboundSmsHandler, GsmInboundSmsHandler gsmInboundSmsHandler, long oldMessageTimestamp) {
        Rlog.d(TAG, "scanning raw table for undelivered messages");
        long startTime = System.nanoTime();
        ContentResolver contentResolver = context.getContentResolver();
        HashMap<SmsReferenceKey, Integer> multiPartReceivedCount = new HashMap<SmsReferenceKey, Integer>(4);
        HashSet<SmsReferenceKey> oldMultiPartMessages = new HashSet<SmsReferenceKey>(4);
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(InboundSmsHandler.sRawUri, PDU_PENDING_MESSAGE_PROJECTION, "deleted = 0", null, null);
            if (cursor == null) {
                Rlog.e(TAG, "error getting pending message cursor");
                return;
            }
            boolean isCurrentFormat3gpp2 = InboundSmsHandler.isCurrentFormat3gpp2();
            while (cursor.moveToNext()) {
                InboundSmsTracker tracker;
                try {
                    tracker = TelephonyComponentFactory.getInstance().inject(InboundSmsTracker.class.getName()).makeInboundSmsTracker(cursor, isCurrentFormat3gpp2);
                }
                catch (IllegalArgumentException e) {
                    Rlog.e(TAG, "error loading SmsTracker: " + e);
                    continue;
                }
                if (tracker.getMessageCount() == 1) {
                    SmsBroadcastUndelivered.broadcastSms(tracker, cdmaInboundSmsHandler, gsmInboundSmsHandler);
                    continue;
                }
                SmsReferenceKey reference = new SmsReferenceKey(tracker);
                Integer receivedCount = (Integer)multiPartReceivedCount.get(reference);
                if (receivedCount == null) {
                    multiPartReceivedCount.put(reference, 1);
                    if (tracker.getTimestamp() >= oldMessageTimestamp) continue;
                    oldMultiPartMessages.add(reference);
                    continue;
                }
                int newCount = receivedCount + 1;
                if (newCount == tracker.getMessageCount()) {
                    Rlog.d(TAG, "found complete multi-part message");
                    SmsBroadcastUndelivered.broadcastSms(tracker, cdmaInboundSmsHandler, gsmInboundSmsHandler);
                    oldMultiPartMessages.remove(reference);
                    continue;
                }
                multiPartReceivedCount.put(reference, newCount);
            }
            int phoneId = SmsBroadcastUndelivered.getPhoneId(gsmInboundSmsHandler, cdmaInboundSmsHandler);
            for (SmsReferenceKey message : oldMultiPartMessages) {
                int rows = contentResolver.delete(InboundSmsHandler.sRawUriPermanentDelete, message.getDeleteWhere(), message.getDeleteWhereArgs());
                if (rows == 0) {
                    Rlog.e(TAG, "No rows were deleted from raw table!");
                } else {
                    Rlog.d(TAG, "Deleted " + rows + " rows from raw table for incomplete " + message.mMessageCount + " part message");
                }
                if (rows <= 0) continue;
                TelephonyMetrics metrics = TelephonyMetrics.getInstance();
                metrics.writeDroppedIncomingMultipartSms(phoneId, message.mFormat, rows, message.mMessageCount);
            }
        }
        catch (SQLException e) {
            Rlog.e(TAG, "error reading pending SMS messages", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            Rlog.d(TAG, "finished scanning raw table in " + (System.nanoTime() - startTime) / 1000000L + " ms");
        }
    }

    private static int getPhoneId(GsmInboundSmsHandler gsmInboundSmsHandler, CdmaInboundSmsHandler cdmaInboundSmsHandler) {
        int phoneId = -1;
        if (gsmInboundSmsHandler != null) {
            phoneId = gsmInboundSmsHandler.getPhone().getPhoneId();
        } else if (cdmaInboundSmsHandler != null) {
            phoneId = cdmaInboundSmsHandler.getPhone().getPhoneId();
        }
        return phoneId;
    }

    private static void broadcastSms(InboundSmsTracker tracker, CdmaInboundSmsHandler cdmaInboundSmsHandler, GsmInboundSmsHandler gsmInboundSmsHandler) {
        InboundSmsHandler handler = tracker.is3gpp2() ? cdmaInboundSmsHandler : gsmInboundSmsHandler;
        if (handler != null) {
            handler.sendMessage(2, tracker);
        } else {
            Rlog.e(TAG, "null handler for " + tracker.getFormat() + " format, can't deliver.");
        }
    }

    private long getUndeliveredSmsExpirationTime(Context context) {
        int subId = SubscriptionManager.getDefaultSmsSubscriptionId();
        CarrierConfigManager configManager = (CarrierConfigManager)context.getSystemService("carrier_config");
        PersistableBundle bundle = configManager.getConfigForSubId(subId);
        if (bundle != null) {
            return bundle.getLong("undelivered_sms_message_expiration_time", 604800000L);
        }
        return 604800000L;
    }

    private static class SmsReferenceKey {
        final String mAddress;
        final int mReferenceNumber;
        final int mMessageCount;
        final String mQuery;
        final String mFormat;

        SmsReferenceKey(InboundSmsTracker tracker) {
            this.mAddress = tracker.getAddress();
            this.mReferenceNumber = tracker.getReferenceNumber();
            this.mMessageCount = tracker.getMessageCount();
            this.mQuery = tracker.getQueryForSegments();
            this.mFormat = tracker.getFormat();
        }

        String[] getDeleteWhereArgs() {
            return new String[]{this.mAddress, Integer.toString(this.mReferenceNumber), Integer.toString(this.mMessageCount)};
        }

        String getDeleteWhere() {
            return this.mQuery;
        }

        public int hashCode() {
            return (this.mReferenceNumber * 31 + this.mMessageCount) * 31 + this.mAddress.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof SmsReferenceKey) {
                SmsReferenceKey other = (SmsReferenceKey)o;
                return other.mAddress.equals(this.mAddress) && other.mReferenceNumber == this.mReferenceNumber && other.mMessageCount == this.mMessageCount;
            }
            return false;
        }
    }

    private class ScanRawTableThread
    extends Thread {
        private final Context context;

        private ScanRawTableThread(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            SmsBroadcastUndelivered.scanRawTable(this.context, SmsBroadcastUndelivered.this.mCdmaInboundSmsHandler, SmsBroadcastUndelivered.this.mGsmInboundSmsHandler, System.currentTimeMillis() - SmsBroadcastUndelivered.this.getUndeliveredSmsExpirationTime(this.context));
            InboundSmsHandler.cancelNewMessageNotification(this.context);
        }
    }
}

