/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.ServiceManager;
import android.telephony.IFinancialSmsCallback;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.BtSmsInterfaceManager;
import com.android.internal.telephony.ISmsImplBase;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.SmsPermissions;
import com.android.internal.telephony.SmsRawData;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.TelephonyPermissions;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class SmsController
extends ISmsImplBase {
    static final String LOG_TAG = "SmsController";
    private final Context mContext;

    protected SmsController(Context context) {
        this.mContext = context;
        if (ServiceManager.getService("isms") == null) {
            ServiceManager.addService("isms", this);
        }
    }

    private Phone getPhone(int subId) {
        Phone phone = PhoneFactory.getPhone(SubscriptionManager.getPhoneId(subId));
        if (phone == null) {
            phone = PhoneFactory.getDefaultPhone();
        }
        return phone;
    }

    private SmsPermissions getSmsPermissions(int subId) {
        Phone phone = this.getPhone(subId);
        return new SmsPermissions(phone, this.mContext, (AppOpsManager)this.mContext.getSystemService("appops"));
    }

    @Override
    @UnsupportedAppUsage
    public boolean updateMessageOnIccEfForSubscriber(int subId, String callingPackage, int index, int status, byte[] pdu) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.updateMessageOnIccEf(callingPackage, index, status, pdu);
        }
        Rlog.e(LOG_TAG, "updateMessageOnIccEfForSubscriber iccSmsIntMgr is null for Subscription: " + subId);
        return false;
    }

    @Override
    @UnsupportedAppUsage
    public boolean copyMessageToIccEfForSubscriber(int subId, String callingPackage, int status, byte[] pdu, byte[] smsc) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.copyMessageToIccEf(callingPackage, status, pdu, smsc);
        }
        Rlog.e(LOG_TAG, "copyMessageToIccEfForSubscriber iccSmsIntMgr is null for Subscription: " + subId);
        return false;
    }

    @Override
    @UnsupportedAppUsage
    public List<SmsRawData> getAllMessagesFromIccEfForSubscriber(int subId, String callingPackage) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.getAllMessagesFromIccEf(callingPackage);
        }
        Rlog.e(LOG_TAG, "getAllMessagesFromIccEfForSubscriber iccSmsIntMgr is null for Subscription: " + subId);
        return null;
    }

    @Override
    @UnsupportedAppUsage
    public void sendDataForSubscriber(int subId, String callingPackage, String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.sendData(callingPackage, destAddr, scAddr, destPort, data, sentIntent, deliveryIntent);
        } else {
            Rlog.e(LOG_TAG, "sendDataForSubscriber iccSmsIntMgr is null for Subscription: " + subId);
            this.sendErrorInPendingIntent(sentIntent, 1);
        }
    }

    @Override
    public void sendDataForSubscriberWithSelfPermissions(int subId, String callingPackage, String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        this.sendDataForSubscriberWithSelfPermissionsInternal(subId, callingPackage, destAddr, scAddr, destPort, data, sentIntent, deliveryIntent, false);
    }

    private void sendDataForSubscriberWithSelfPermissionsInternal(int subId, String callingPackage, String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean isForVvm) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.sendDataWithSelfPermissions(callingPackage, destAddr, scAddr, destPort, data, sentIntent, deliveryIntent, isForVvm);
        } else {
            Rlog.e(LOG_TAG, "sendText iccSmsIntMgr is null for Subscription: " + subId);
            this.sendErrorInPendingIntent(sentIntent, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendTextForSubscriber(int subId, String callingPackage, String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean persistMessageForNonDefaultSmsApp) {
        SubscriptionInfo info;
        if (!this.getSmsPermissions(subId).checkCallingCanSendText(persistMessageForNonDefaultSmsApp, callingPackage, "Sending SMS message")) {
            this.sendErrorInPendingIntent(sentIntent, 1);
            return;
        }
        long token = Binder.clearCallingIdentity();
        try {
            info = this.getSubscriptionInfo(subId);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        if (this.isBluetoothSubscription(info)) {
            this.sendBluetoothText(info, destAddr, text, sentIntent, deliveryIntent);
        } else {
            this.sendIccText(subId, callingPackage, destAddr, scAddr, text, sentIntent, deliveryIntent, persistMessageForNonDefaultSmsApp);
        }
    }

    private boolean isBluetoothSubscription(SubscriptionInfo info) {
        return info != null && info.getSubscriptionType() == 1;
    }

    private void sendBluetoothText(SubscriptionInfo info, String destAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        BtSmsInterfaceManager btSmsInterfaceManager = new BtSmsInterfaceManager();
        btSmsInterfaceManager.sendText(destAddr, text, sentIntent, deliveryIntent, info);
    }

    private void sendIccText(int subId, String callingPackage, String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean persistMessageForNonDefaultSmsApp) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.sendText(callingPackage, destAddr, scAddr, text, sentIntent, deliveryIntent, persistMessageForNonDefaultSmsApp);
        } else {
            Rlog.e(LOG_TAG, "sendTextForSubscriber iccSmsIntMgr is null for Subscription: " + subId);
            this.sendErrorInPendingIntent(sentIntent, 1);
        }
    }

    @Override
    public void sendTextForSubscriberWithSelfPermissions(int subId, String callingPackage, String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean persistMessage) {
        this.sendTextForSubscriberWithSelfPermissionsInternal(subId, callingPackage, destAddr, scAddr, text, sentIntent, deliveryIntent, persistMessage, false);
    }

    private void sendTextForSubscriberWithSelfPermissionsInternal(int subId, String callingPackage, String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean persistMessage, boolean isForVvm) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.sendTextWithSelfPermissions(callingPackage, destAddr, scAddr, text, sentIntent, deliveryIntent, persistMessage, isForVvm);
        } else {
            Rlog.e(LOG_TAG, "sendText iccSmsIntMgr is null for Subscription: " + subId);
            this.sendErrorInPendingIntent(sentIntent, 1);
        }
    }

    @Override
    public void sendTextForSubscriberWithOptions(int subId, String callingPackage, String destAddr, String scAddr, String parts, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean persistMessage, int priority, boolean expectMore, int validityPeriod) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.sendTextWithOptions(callingPackage, destAddr, scAddr, parts, sentIntent, deliveryIntent, persistMessage, priority, expectMore, validityPeriod);
        } else {
            Rlog.e(LOG_TAG, "sendTextWithOptions iccSmsIntMgr is null for Subscription: " + subId);
            this.sendErrorInPendingIntent(sentIntent, 1);
        }
    }

    @Override
    public void sendMultipartTextForSubscriber(int subId, String callingPackage, String destAddr, String scAddr, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents, boolean persistMessageForNonDefaultSmsApp) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.sendMultipartText(callingPackage, destAddr, scAddr, parts, sentIntents, deliveryIntents, persistMessageForNonDefaultSmsApp);
        } else {
            Rlog.e(LOG_TAG, "sendMultipartTextForSubscriber iccSmsIntMgr is null for Subscription: " + subId);
            this.sendErrorInPendingIntents(sentIntents, 1);
        }
    }

    @Override
    public void sendMultipartTextForSubscriberWithOptions(int subId, String callingPackage, String destAddr, String scAddr, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents, boolean persistMessage, int priority, boolean expectMore, int validityPeriod) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.sendMultipartTextWithOptions(callingPackage, destAddr, scAddr, parts, sentIntents, deliveryIntents, persistMessage, priority, expectMore, validityPeriod);
        } else {
            Rlog.e(LOG_TAG, "sendMultipartTextWithOptions iccSmsIntMgr is null for Subscription: " + subId);
            this.sendErrorInPendingIntents(sentIntents, 1);
        }
    }

    @Override
    @UnsupportedAppUsage
    public boolean enableCellBroadcastForSubscriber(int subId, int messageIdentifier, int ranType) {
        return this.enableCellBroadcastRangeForSubscriber(subId, messageIdentifier, messageIdentifier, ranType);
    }

    @Override
    @UnsupportedAppUsage
    public boolean enableCellBroadcastRangeForSubscriber(int subId, int startMessageId, int endMessageId, int ranType) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.enableCellBroadcastRange(startMessageId, endMessageId, ranType);
        }
        Rlog.e(LOG_TAG, "enableCellBroadcastRangeForSubscriber iccSmsIntMgr is null for Subscription: " + subId);
        return false;
    }

    @Override
    @UnsupportedAppUsage
    public boolean disableCellBroadcastForSubscriber(int subId, int messageIdentifier, int ranType) {
        return this.disableCellBroadcastRangeForSubscriber(subId, messageIdentifier, messageIdentifier, ranType);
    }

    @Override
    @UnsupportedAppUsage
    public boolean disableCellBroadcastRangeForSubscriber(int subId, int startMessageId, int endMessageId, int ranType) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.disableCellBroadcastRange(startMessageId, endMessageId, ranType);
        }
        Rlog.e(LOG_TAG, "disableCellBroadcastRangeForSubscriber iccSmsIntMgr is null for Subscription:" + subId);
        return false;
    }

    @Override
    public int getPremiumSmsPermission(String packageName) {
        return this.getPremiumSmsPermissionForSubscriber(this.getPreferredSmsSubscription(), packageName);
    }

    @Override
    public int getPremiumSmsPermissionForSubscriber(int subId, String packageName) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.getPremiumSmsPermission(packageName);
        }
        Rlog.e(LOG_TAG, "getPremiumSmsPermissionForSubscriber iccSmsIntMgr is null");
        return 0;
    }

    @Override
    public void setPremiumSmsPermission(String packageName, int permission2) {
        this.setPremiumSmsPermissionForSubscriber(this.getPreferredSmsSubscription(), packageName, permission2);
    }

    @Override
    public void setPremiumSmsPermissionForSubscriber(int subId, String packageName, int permission2) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.setPremiumSmsPermission(packageName, permission2);
        } else {
            Rlog.e(LOG_TAG, "setPremiumSmsPermissionForSubscriber iccSmsIntMgr is null");
        }
    }

    @Override
    @UnsupportedAppUsage
    public boolean isImsSmsSupportedForSubscriber(int subId) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.isImsSmsSupported();
        }
        Rlog.e(LOG_TAG, "isImsSmsSupportedForSubscriber iccSmsIntMgr is null");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSmsSimPickActivityNeeded(int subId) {
        List<SubscriptionInfo> subInfoList;
        boolean isCallingProcessForeground;
        Context context = ActivityThread.currentApplication().getApplicationContext();
        ActivityManager am = context.getSystemService(ActivityManager.class);
        boolean bl = isCallingProcessForeground = am != null && am.getUidImportance(Binder.getCallingUid()) == 100;
        if (!isCallingProcessForeground) {
            Rlog.d(LOG_TAG, "isSmsSimPickActivityNeeded: calling process not foreground. Suppressing activity.");
            return false;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        long identity = Binder.clearCallingIdentity();
        try {
            subInfoList = SubscriptionManager.from(context).getActiveSubscriptionInfoList();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        if (subInfoList != null) {
            int subInfoLength = subInfoList.size();
            for (int i = 0; i < subInfoLength; ++i) {
                SubscriptionInfo sir = subInfoList.get(i);
                if (sir == null || sir.getSubscriptionId() != subId) continue;
                return false;
            }
            if (subInfoLength > 0 && telephonyManager.getSimCount() > 1) {
                return true;
            }
        }
        return false;
    }

    @Override
    @UnsupportedAppUsage
    public String getImsSmsFormatForSubscriber(int subId) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            return iccSmsIntMgr.getImsSmsFormat();
        }
        Rlog.e(LOG_TAG, "getImsSmsFormatForSubscriber iccSmsIntMgr is null");
        return null;
    }

    @Override
    public void injectSmsPduForSubscriber(int subId, byte[] pdu, String format, PendingIntent receivedIntent) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.injectSmsPdu(pdu, format, receivedIntent);
        } else {
            Rlog.e(LOG_TAG, "injectSmsPduForSubscriber iccSmsIntMgr is null");
            this.sendErrorInPendingIntent(receivedIntent, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnsupportedAppUsage
    public int getPreferredSmsSubscription() {
        int defaultSubId = SubscriptionController.getInstance().getDefaultSmsSubId();
        if (SubscriptionManager.isValidSubscriptionId(defaultSubId)) {
            return defaultSubId;
        }
        long token = Binder.clearCallingIdentity();
        try {
            int[] activeSubs = SubscriptionController.getInstance().getActiveSubIdList(true);
            if (activeSubs.length == 1) {
                int n = activeSubs[0];
                return n;
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return -1;
    }

    @Override
    public boolean isSMSPromptEnabled() {
        return PhoneFactory.isSMSPromptEnabled();
    }

    @Override
    public void sendStoredText(int subId, String callingPkg, Uri messageUri, String scAddress, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.sendStoredText(callingPkg, messageUri, scAddress, sentIntent, deliveryIntent);
        } else {
            Rlog.e(LOG_TAG, "sendStoredText iccSmsIntMgr is null for subscription: " + subId);
            this.sendErrorInPendingIntent(sentIntent, 1);
        }
    }

    @Override
    public void sendStoredMultipartText(int subId, String callingPkg, Uri messageUri, String scAddress, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents) {
        IccSmsInterfaceManager iccSmsIntMgr = this.getIccSmsInterfaceManager(subId);
        if (iccSmsIntMgr != null) {
            iccSmsIntMgr.sendStoredMultipartText(callingPkg, messageUri, scAddress, sentIntents, deliveryIntents);
        } else {
            Rlog.e(LOG_TAG, "sendStoredMultipartText iccSmsIntMgr is null for subscription: " + subId);
            this.sendErrorInPendingIntents(sentIntents, 1);
        }
    }

    @Override
    public String createAppSpecificSmsTokenWithPackageInfo(int subId, String callingPkg, String prefixes, PendingIntent intent) {
        return this.getPhone(subId).getAppSmsManager().createAppSpecificSmsTokenWithPackageInfo(subId, callingPkg, prefixes, intent);
    }

    @Override
    public String createAppSpecificSmsToken(int subId, String callingPkg, PendingIntent intent) {
        return this.getPhone(subId).getAppSmsManager().createAppSpecificSmsToken(callingPkg, intent);
    }

    @Override
    public void getSmsMessagesForFinancialApp(int subId, String callingPkg, Bundle params, IFinancialSmsCallback callback) {
        this.getPhone(subId).getAppSmsManager().getSmsMessagesForFinancialApp(callingPkg, params, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkSmsShortCodeDestination(int subId, String callingPackage, String destAddress, String countryIso) {
        if (!TelephonyPermissions.checkCallingOrSelfReadPhoneState(this.getPhone(subId).getContext(), subId, callingPackage, "checkSmsShortCodeDestination")) {
            return 0;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            int n = this.getPhone((int)subId).mSmsUsageMonitor.checkDestination(destAddress, countryIso);
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public void sendVisualVoicemailSmsForSubscriber(String callingPackage, int subId, String number, int port, String text, PendingIntent sentIntent) {
        if (port == 0) {
            this.sendTextForSubscriberWithSelfPermissionsInternal(subId, callingPackage, number, null, text, sentIntent, null, false, true);
        } else {
            byte[] data = text.getBytes(StandardCharsets.UTF_8);
            this.sendDataForSubscriberWithSelfPermissionsInternal(subId, callingPackage, number, null, (short)port, data, sentIntent, null, true);
        }
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, LOG_TAG, pw)) {
            return;
        }
        IndentingPrintWriter indentingPW = new IndentingPrintWriter((Writer)pw, "    ");
        for (Phone phone : PhoneFactory.getPhones()) {
            int subId = phone.getSubId();
            indentingPW.println(String.format("SmsManager for subId = %d:", subId));
            indentingPW.increaseIndent();
            if (this.getIccSmsInterfaceManager(subId) != null) {
                this.getIccSmsInterfaceManager(subId).dump(fd, indentingPW, args);
            }
            indentingPW.decreaseIndent();
        }
        indentingPW.flush();
    }

    @UnsupportedAppUsage
    private void sendErrorInPendingIntent(PendingIntent intent, int errorCode) {
        if (intent != null) {
            try {
                intent.send(errorCode);
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
        }
    }

    @UnsupportedAppUsage
    private void sendErrorInPendingIntents(List<PendingIntent> intents, int errorCode) {
        if (intents == null) {
            return;
        }
        for (PendingIntent intent : intents) {
            this.sendErrorInPendingIntent(intent, errorCode);
        }
    }

    @UnsupportedAppUsage
    private IccSmsInterfaceManager getIccSmsInterfaceManager(int subId) {
        return this.getPhone(subId).getIccSmsInterfaceManager();
    }

    private SubscriptionInfo getSubscriptionInfo(int subId) {
        SubscriptionManager manager = (SubscriptionManager)this.mContext.getSystemService("telephony_subscription_service");
        return manager.getActiveSubscriptionInfo(subId);
    }
}

