/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.UserManager;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SmsMessage;
import android.util.Pair;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.ImsSmsDispatcher;
import com.android.internal.telephony.InboundSmsHandler;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsBroadcastUndelivered;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.cdma.CdmaInboundSmsHandler;
import com.android.internal.telephony.cdma.CdmaSMSDispatcher;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.gsm.GsmInboundSmsHandler;
import com.android.internal.telephony.gsm.GsmSMSDispatcher;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class SmsDispatchersController
extends Handler {
    private static final String TAG = "SmsDispatchersController";
    private static final boolean VDBG = false;
    private static final int EVENT_RADIO_ON = 11;
    private static final int EVENT_IMS_STATE_CHANGED = 12;
    private static final int EVENT_IMS_STATE_DONE = 13;
    private static final int EVENT_SERVICE_STATE_CHANGED = 14;
    private static final int EVENT_PARTIAL_SEGMENT_TIMER_EXPIRY = 15;
    private static final int EVENT_USER_UNLOCKED = 16;
    protected static final int EVENT_SMS_HANDLER_EXITING_WAITING_STATE = 17;
    private static final long PARTIAL_SEGMENT_WAIT_DURATION = 86400000L;
    private static final long INVALID_TIME = -1L;
    private long mLastInServiceTime = -1L;
    private long mCurrentWaitElapsedDuration = 0L;
    private long mCurrentWaitStartTime = -1L;
    private SMSDispatcher mCdmaDispatcher;
    private SMSDispatcher mGsmDispatcher;
    private ImsSmsDispatcher mImsSmsDispatcher;
    private GsmInboundSmsHandler mGsmInboundSmsHandler;
    private CdmaInboundSmsHandler mCdmaInboundSmsHandler;
    private Phone mPhone;
    private final SmsUsageMonitor mUsageMonitor;
    private final CommandsInterface mCi;
    private final Context mContext;
    private boolean mIms = false;
    private String mImsSmsFormat = "unknown";
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Rlog.d(SmsDispatchersController.TAG, "Received broadcast " + intent.getAction());
            if ("android.intent.action.USER_UNLOCKED".equals(intent.getAction())) {
                SmsDispatchersController.this.sendMessage(SmsDispatchersController.this.obtainMessage(16));
            }
        }
    };

    public SmsDispatchersController(Phone phone, SmsStorageMonitor storageMonitor, SmsUsageMonitor usageMonitor) {
        Rlog.d(TAG, "SmsDispatchersController created");
        this.mContext = phone.getContext();
        this.mUsageMonitor = usageMonitor;
        this.mCi = phone.mCi;
        this.mPhone = phone;
        this.mImsSmsDispatcher = new ImsSmsDispatcher(phone, this);
        this.mCdmaDispatcher = new CdmaSMSDispatcher(phone, this);
        this.mGsmInboundSmsHandler = GsmInboundSmsHandler.makeInboundSmsHandler(phone.getContext(), storageMonitor, phone);
        this.mCdmaInboundSmsHandler = CdmaInboundSmsHandler.makeInboundSmsHandler(phone.getContext(), storageMonitor, phone, (CdmaSMSDispatcher)this.mCdmaDispatcher);
        this.mGsmDispatcher = new GsmSMSDispatcher(phone, this, this.mGsmInboundSmsHandler);
        SmsBroadcastUndelivered.initialize(phone.getContext(), this.mGsmInboundSmsHandler, this.mCdmaInboundSmsHandler);
        InboundSmsHandler.registerNewMessageNotificationActionHandler(phone.getContext());
        this.mCi.registerForOn(this, 11, null);
        this.mCi.registerForImsNetworkStateChanged(this, 12, null);
        UserManager userManager = (UserManager)this.mContext.getSystemService("user");
        if (userManager.isUserUnlocked()) {
            this.mPhone.registerForServiceStateChanged(this, 14, null);
            this.resetPartialSegmentWaitTimer();
        } else {
            IntentFilter userFilter = new IntentFilter();
            userFilter.addAction("android.intent.action.USER_UNLOCKED");
            this.mContext.registerReceiver(this.mBroadcastReceiver, userFilter);
        }
    }

    public void dispose() {
        this.mCi.unregisterForOn(this);
        this.mCi.unregisterForImsNetworkStateChanged(this);
        this.mPhone.unregisterForServiceStateChanged(this);
        this.mGsmDispatcher.dispose();
        this.mCdmaDispatcher.dispose();
        this.mGsmInboundSmsHandler.dispose();
        this.mCdmaInboundSmsHandler.dispose();
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 11: 
            case 12: {
                this.mCi.getImsRegistrationState(this.obtainMessage(13));
                break;
            }
            case 13: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.updateImsInfo(ar);
                    break;
                }
                Rlog.e(TAG, "IMS State query failed with exp " + ar.exception);
                break;
            }
            case 14: 
            case 17: {
                this.reevaluateTimerStatus();
                break;
            }
            case 15: {
                this.handlePartialSegmentTimerExpiry((Long)msg.obj);
                break;
            }
            case 16: {
                this.mPhone.registerForServiceStateChanged(this, 14, null);
                this.resetPartialSegmentWaitTimer();
                break;
            }
            default: {
                if (this.isCdmaMo()) {
                    this.mCdmaDispatcher.handleMessage(msg);
                    break;
                }
                this.mGsmDispatcher.handleMessage(msg);
            }
        }
    }

    private void reevaluateTimerStatus() {
        long currentTime = System.currentTimeMillis();
        this.removeMessages(15);
        if (this.mLastInServiceTime != -1L) {
            this.mCurrentWaitElapsedDuration += currentTime - this.mLastInServiceTime;
        }
        if (this.mCurrentWaitElapsedDuration > 86400000L) {
            this.handlePartialSegmentTimerExpiry(this.mCurrentWaitStartTime);
        } else if (this.isInService()) {
            this.handleInService(currentTime);
        } else {
            this.handleOutOfService(currentTime);
        }
    }

    private void handleInService(long currentTime) {
        if (this.mCurrentWaitStartTime == -1L) {
            this.mCurrentWaitStartTime = currentTime;
        }
        this.sendMessageDelayed(this.obtainMessage(15, this.mCurrentWaitStartTime), 86400000L - this.mCurrentWaitElapsedDuration);
        this.mLastInServiceTime = currentTime;
    }

    private void handleOutOfService(long currentTime) {
        this.mLastInServiceTime = -1L;
    }

    private void handlePartialSegmentTimerExpiry(long waitTimerStart) {
        if (this.mGsmInboundSmsHandler.getCurrentState().getName().equals("WaitingState") || this.mCdmaInboundSmsHandler.getCurrentState().getName().equals("WaitingState")) {
            this.logd("handlePartialSegmentTimerExpiry: ignoring timer expiry as InboundSmsHandler is in WaitingState");
            return;
        }
        SmsBroadcastUndelivered.scanRawTable(this.mContext, this.mCdmaInboundSmsHandler, this.mGsmInboundSmsHandler, waitTimerStart);
        this.resetPartialSegmentWaitTimer();
    }

    private void resetPartialSegmentWaitTimer() {
        long currentTime = System.currentTimeMillis();
        this.removeMessages(15);
        if (this.isInService()) {
            this.mCurrentWaitStartTime = currentTime;
            this.mLastInServiceTime = currentTime;
            this.sendMessageDelayed(this.obtainMessage(15, this.mCurrentWaitStartTime), 86400000L);
        } else {
            this.mCurrentWaitStartTime = -1L;
            this.mLastInServiceTime = -1L;
        }
        this.mCurrentWaitElapsedDuration = 0L;
    }

    private boolean isInService() {
        ServiceState serviceState = this.mPhone.getServiceState();
        return serviceState != null && serviceState.getState() == 0;
    }

    private void setImsSmsFormat(int format) {
        switch (format) {
            case 1: {
                this.mImsSmsFormat = "3gpp";
                break;
            }
            case 2: {
                this.mImsSmsFormat = "3gpp2";
                break;
            }
            default: {
                this.mImsSmsFormat = "unknown";
            }
        }
    }

    private void updateImsInfo(AsyncResult ar) {
        int[] responseArray = (int[])ar.result;
        this.setImsSmsFormat(responseArray[1]);
        this.mIms = responseArray[0] == 1 && !"unknown".equals(this.mImsSmsFormat);
        Rlog.d(TAG, "IMS registration state: " + this.mIms + " format: " + this.mImsSmsFormat);
    }

    @VisibleForTesting
    public void injectSmsPdu(byte[] pdu, String format, SmsInjectionCallback callback) {
        android.telephony.SmsMessage msg = android.telephony.SmsMessage.createFromPdu(pdu, format);
        this.injectSmsPdu(msg, format, callback, false);
    }

    @VisibleForTesting
    public void injectSmsPdu(android.telephony.SmsMessage msg, String format, SmsInjectionCallback callback, boolean ignoreClass) {
        Rlog.d(TAG, "SmsDispatchersController:injectSmsPdu");
        try {
            if (msg == null) {
                Rlog.e(TAG, "injectSmsPdu: createFromPdu returned null");
                callback.onSmsInjectedResult(2);
                return;
            }
            if (!ignoreClass && msg.getMessageClass() != SmsMessage.MessageClass.CLASS_1) {
                Rlog.e(TAG, "injectSmsPdu: not class 1");
                callback.onSmsInjectedResult(2);
                return;
            }
            AsyncResult ar = new AsyncResult(callback, msg, null);
            if (format.equals("3gpp")) {
                Rlog.i(TAG, "SmsDispatchersController:injectSmsText Sending msg=" + msg + ", format=" + format + "to mGsmInboundSmsHandler");
                this.mGsmInboundSmsHandler.sendMessage(7, ar);
            } else if (format.equals("3gpp2")) {
                Rlog.i(TAG, "SmsDispatchersController:injectSmsText Sending msg=" + msg + ", format=" + format + "to mCdmaInboundSmsHandler");
                this.mCdmaInboundSmsHandler.sendMessage(7, ar);
            } else {
                Rlog.e(TAG, "Invalid pdu format: " + format);
                callback.onSmsInjectedResult(2);
            }
        }
        catch (Exception e) {
            Rlog.e(TAG, "injectSmsPdu failed: ", e);
            callback.onSmsInjectedResult(2);
        }
    }

    public void sendRetrySms(SMSDispatcher.SmsTracker tracker) {
        String newFormat;
        String oldFormat = tracker.mFormat;
        String string2 = newFormat = 2 == this.mPhone.getPhoneType() ? this.mCdmaDispatcher.getFormat() : this.mGsmDispatcher.getFormat();
        if (oldFormat.equals(newFormat)) {
            if (this.isCdmaFormat(newFormat)) {
                Rlog.d(TAG, "old format matched new format (cdma)");
                this.mCdmaDispatcher.sendSms(tracker);
                return;
            }
            Rlog.d(TAG, "old format matched new format (gsm)");
            this.mGsmDispatcher.sendSms(tracker);
            return;
        }
        HashMap<String, Object> map = tracker.getData();
        if (!(map.containsKey("scAddr") && map.containsKey("destAddr") && (map.containsKey("text") || map.containsKey("data") && map.containsKey("destPort")))) {
            Rlog.e(TAG, "sendRetrySms failed to re-encode per missing fields!");
            tracker.onFailed(this.mContext, 1, 0);
            return;
        }
        String scAddr = (String)map.get("scAddr");
        String destAddr = (String)map.get("destAddr");
        SmsMessageBase.SubmitPduBase pdu = null;
        if (map.containsKey("text")) {
            Rlog.d(TAG, "sms failed was text");
            String text = (String)map.get("text");
            if (this.isCdmaFormat(newFormat)) {
                Rlog.d(TAG, "old format (gsm) ==> new format (cdma)");
                pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, text, tracker.mDeliveryIntent != null, null);
            } else {
                Rlog.d(TAG, "old format (cdma) ==> new format (gsm)");
                pdu = com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddr, destAddr, text, tracker.mDeliveryIntent != null, null);
            }
        } else if (map.containsKey("data")) {
            Rlog.d(TAG, "sms failed was data");
            byte[] data = (byte[])map.get("data");
            Integer destPort = (Integer)map.get("destPort");
            if (this.isCdmaFormat(newFormat)) {
                Rlog.d(TAG, "old format (gsm) ==> new format (cdma)");
                pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, destPort, data, tracker.mDeliveryIntent != null);
            } else {
                Rlog.d(TAG, "old format (cdma) ==> new format (gsm)");
                pdu = com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddr, destAddr, destPort, data, tracker.mDeliveryIntent != null);
            }
        }
        map.put("smsc", pdu.encodedScAddress);
        map.put("pdu", pdu.encodedMessage);
        SMSDispatcher dispatcher = this.isCdmaFormat(newFormat) ? this.mCdmaDispatcher : this.mGsmDispatcher;
        tracker.mFormat = dispatcher.getFormat();
        dispatcher.sendSms(tracker);
    }

    public boolean isIms() {
        return this.mIms;
    }

    public String getImsSmsFormat() {
        return this.mImsSmsFormat;
    }

    protected boolean isCdmaMo() {
        if (!this.isIms()) {
            return 2 == this.mPhone.getPhoneType();
        }
        return this.isCdmaFormat(this.mImsSmsFormat);
    }

    public boolean isCdmaFormat(String format) {
        return this.mCdmaDispatcher.getFormat().equals(format);
    }

    protected void sendData(String callingPackage, String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean isForVvm) {
        if (this.mImsSmsDispatcher.isAvailable()) {
            this.mImsSmsDispatcher.sendData(callingPackage, destAddr, scAddr, destPort, data, sentIntent, deliveryIntent, isForVvm);
        } else if (this.isCdmaMo()) {
            this.mCdmaDispatcher.sendData(callingPackage, destAddr, scAddr, destPort, data, sentIntent, deliveryIntent, isForVvm);
        } else {
            this.mGsmDispatcher.sendData(callingPackage, destAddr, scAddr, destPort, data, sentIntent, deliveryIntent, isForVvm);
        }
    }

    public void sendText(String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, Uri messageUri, String callingPkg, boolean persistMessage, int priority, boolean expectMore, int validityPeriod, boolean isForVvm) {
        if (this.mImsSmsDispatcher.isAvailable() || this.mImsSmsDispatcher.isEmergencySmsSupport(destAddr)) {
            this.mImsSmsDispatcher.sendText(destAddr, scAddr, text, sentIntent, deliveryIntent, messageUri, callingPkg, persistMessage, -1, false, -1, isForVvm);
        } else if (this.isCdmaMo()) {
            this.mCdmaDispatcher.sendText(destAddr, scAddr, text, sentIntent, deliveryIntent, messageUri, callingPkg, persistMessage, priority, expectMore, validityPeriod, isForVvm);
        } else {
            this.mGsmDispatcher.sendText(destAddr, scAddr, text, sentIntent, deliveryIntent, messageUri, callingPkg, persistMessage, priority, expectMore, validityPeriod, isForVvm);
        }
    }

    protected void sendMultipartText(String destAddr, String scAddr, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents, Uri messageUri, String callingPkg, boolean persistMessage, int priority, boolean expectMore, int validityPeriod) {
        if (this.mImsSmsDispatcher.isAvailable()) {
            this.mImsSmsDispatcher.sendMultipartText(destAddr, scAddr, parts, sentIntents, deliveryIntents, messageUri, callingPkg, persistMessage, -1, false, -1);
        } else if (this.isCdmaMo()) {
            this.mCdmaDispatcher.sendMultipartText(destAddr, scAddr, parts, sentIntents, deliveryIntents, messageUri, callingPkg, persistMessage, priority, expectMore, validityPeriod);
        } else {
            this.mGsmDispatcher.sendMultipartText(destAddr, scAddr, parts, sentIntents, deliveryIntents, messageUri, callingPkg, persistMessage, priority, expectMore, validityPeriod);
        }
    }

    public int getPremiumSmsPermission(String packageName) {
        return this.mUsageMonitor.getPremiumSmsPermission(packageName);
    }

    public void setPremiumSmsPermission(String packageName, int permission2) {
        this.mUsageMonitor.setPremiumSmsPermission(packageName, permission2);
    }

    public SmsUsageMonitor getUsageMonitor() {
        return this.mUsageMonitor;
    }

    public Pair<Boolean, Boolean> handleSmsStatusReport(SMSDispatcher.SmsTracker tracker, String format, byte[] pdu) {
        if (this.isCdmaFormat(format)) {
            return this.handleCdmaStatusReport(tracker, format, pdu);
        }
        return this.handleGsmStatusReport(tracker, format, pdu);
    }

    private Pair<Boolean, Boolean> handleCdmaStatusReport(SMSDispatcher.SmsTracker tracker, String format, byte[] pdu) {
        tracker.updateSentMessageStatus(this.mContext, 0);
        boolean success = this.triggerDeliveryIntent(tracker, format, pdu);
        return new Pair<Boolean, Boolean>(success, true);
    }

    private Pair<Boolean, Boolean> handleGsmStatusReport(SMSDispatcher.SmsTracker tracker, String format, byte[] pdu) {
        com.android.internal.telephony.gsm.SmsMessage sms = com.android.internal.telephony.gsm.SmsMessage.newFromCDS(pdu);
        boolean complete = false;
        boolean success = false;
        if (sms != null) {
            int tpStatus = sms.getStatus();
            if (tpStatus >= 64 || tpStatus < 32) {
                tracker.updateSentMessageStatus(this.mContext, tpStatus);
                complete = true;
            }
            success = this.triggerDeliveryIntent(tracker, format, pdu);
        }
        return new Pair<Boolean, Boolean>(success, complete);
    }

    private boolean triggerDeliveryIntent(SMSDispatcher.SmsTracker tracker, String format, byte[] pdu) {
        PendingIntent intent = tracker.mDeliveryIntent;
        Intent fillIn = new Intent();
        fillIn.putExtra("pdu", pdu);
        fillIn.putExtra("format", format);
        try {
            intent.send(this.mContext, -1, fillIn);
            return true;
        }
        catch (PendingIntent.CanceledException ex) {
            return false;
        }
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mGsmInboundSmsHandler.dump(fd, pw, args);
        this.mCdmaInboundSmsHandler.dump(fd, pw, args);
    }

    private void logd(String msg) {
        Rlog.d(TAG, msg);
    }

    public static interface SmsInjectionCallback {
        public void onSmsInjectedResult(int var1);
    }
}

