/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Binder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.telecom.PhoneAccountHandle;
import android.telecom.TelecomManager;
import android.telephony.RadioAccessFamily;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.UiccAccessRule;
import android.telephony.UiccSlotInfo;
import android.telephony.euicc.EuiccManager;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.ISetOpportunisticDataCallback;
import com.android.internal.telephony.ISub;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccCardConstants;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.MultiSimSettingController;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConfigurationManager;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneSwitcher;
import com.android.internal.telephony.ProxyController;
import com.android.internal.telephony.SubscriptionInfoUpdater;
import com.android.internal.telephony.TelephonyPermissions;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.util.ArrayUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class SubscriptionController
extends ISub.Stub {
    private static final String LOG_TAG = "SubscriptionController";
    private static final boolean DBG = true;
    private static final boolean VDBG = Rlog.isLoggable("SubscriptionController", 2);
    private static final boolean DBG_CACHE = false;
    private static final int DEPRECATED_SETTING = -1;
    private static final ParcelUuid INVALID_GROUP_UUID = ParcelUuid.fromString("00000000-0000-0000-0000-000000000000");
    private final LocalLog mLocalLog = new LocalLog(200);
    private Object mSubInfoListLock = new Object();
    private final List<SubscriptionInfo> mCacheActiveSubInfoList = new ArrayList<SubscriptionInfo>();
    private List<SubscriptionInfo> mCacheOpportunisticSubInfoList = new ArrayList<SubscriptionInfo>();
    private static final Comparator<SubscriptionInfo> SUBSCRIPTION_INFO_COMPARATOR = (arg0, arg1) -> {
        int flag = arg0.getSimSlotIndex() - arg1.getSimSlotIndex();
        if (flag == 0) {
            return arg0.getSubscriptionId() - arg1.getSubscriptionId();
        }
        return flag;
    };
    @UnsupportedAppUsage
    protected final Object mLock = new Object();
    private static SubscriptionController sInstance = null;
    protected static Phone[] sPhones;
    @UnsupportedAppUsage
    protected Context mContext;
    protected TelephonyManager mTelephonyManager;
    protected UiccController mUiccController;
    private AppOpsManager mAppOps;
    private static Map<Integer, ArrayList<Integer>> sSlotIndexToSubIds;
    private static int mDefaultFallbackSubId;
    @UnsupportedAppUsage
    private static int mDefaultPhoneId;
    @UnsupportedAppUsage
    private int[] colorArr;
    private long mLastISubServiceRegTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubscriptionController init(Phone phone) {
        Class<SubscriptionController> clazz = SubscriptionController.class;
        synchronized (SubscriptionController.class) {
            if (sInstance == null) {
                sInstance = new SubscriptionController(phone);
            } else {
                Log.wtf(LOG_TAG, "init() called multiple times!  sInstance = " + sInstance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubscriptionController init(Context c, CommandsInterface[] ci) {
        Class<SubscriptionController> clazz = SubscriptionController.class;
        synchronized (SubscriptionController.class) {
            if (sInstance == null) {
                sInstance = new SubscriptionController(c);
            } else {
                Log.wtf(LOG_TAG, "init() called multiple times!  sInstance = " + sInstance);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    @UnsupportedAppUsage
    public static SubscriptionController getInstance() {
        if (sInstance == null) {
            Log.wtf(LOG_TAG, "getInstance null");
        }
        return sInstance;
    }

    protected SubscriptionController(Context c) {
        this.init(c);
        this.migrateImsSettings();
    }

    protected void init(Context c) {
        this.mContext = c;
        this.mTelephonyManager = TelephonyManager.from(this.mContext);
        try {
            this.mUiccController = UiccController.getInstance();
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("UiccController has to be initialised before SubscriptionController init");
        }
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
        if (ServiceManager.getService("isub") == null) {
            ServiceManager.addService("isub", this);
            this.mLastISubServiceRegTime = System.currentTimeMillis();
        }
        this.clearSlotIndexForSubInfoRecords();
        this.logdl("[SubscriptionController] init by Context");
    }

    public void notifySubInfoReady() {
        this.sendDefaultChangedBroadcast(SubscriptionManager.getDefaultSubscriptionId());
    }

    @UnsupportedAppUsage
    private boolean isSubInfoReady() {
        return SubscriptionInfoUpdater.isSubInfoInitialized();
    }

    private void clearSlotIndexForSubInfoRecords() {
        if (this.mContext == null) {
            this.logel("[clearSlotIndexForSubInfoRecords] TelephonyManager or mContext is null");
            return;
        }
        ContentValues value = new ContentValues(1);
        value.put("sim_id", -1);
        this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, null, null);
    }

    private SubscriptionController(Phone phone) {
        this.mContext = phone.getContext();
        this.mAppOps = this.mContext.getSystemService(AppOpsManager.class);
        if (ServiceManager.getService("isub") == null) {
            ServiceManager.addService("isub", this);
        }
        this.migrateImsSettings();
        this.clearSlotIndexForSubInfoRecords();
        this.logdl("[SubscriptionController] init by Phone");
    }

    @UnsupportedAppUsage
    private void enforceModifyPhoneState(String message) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", message);
    }

    private void enforceReadPrivilegedPhoneState(String message) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", message);
    }

    private void broadcastSimInfoContentChanged() {
        Intent intent = new Intent("android.intent.action.ACTION_SUBINFO_CONTENT_CHANGE");
        this.mContext.sendBroadcast(intent);
        intent = new Intent("android.intent.action.ACTION_SUBINFO_RECORD_UPDATED");
        this.mContext.sendBroadcast(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void notifySubscriptionInfoChanged() {
        ArrayList<SubscriptionInfo> subInfos;
        ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        try {
            this.logd("notifySubscriptionInfoChanged:");
            tr.notifySubscriptionInfoChanged();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.broadcastSimInfoContentChanged();
        MultiSimSettingController.getInstance().notifySubscriptionInfoChanged();
        TelephonyMetrics metrics = TelephonyMetrics.getInstance();
        Object object = this.mSubInfoListLock;
        synchronized (object) {
            subInfos = new ArrayList<SubscriptionInfo>(this.mCacheActiveSubInfoList);
        }
        metrics.updateActiveSubscriptionInfoList(subInfos);
    }

    @UnsupportedAppUsage
    private SubscriptionInfo getSubInfoRecord(Cursor cursor) {
        String line1Number;
        int id2 = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
        String iccId = cursor.getString(cursor.getColumnIndexOrThrow("icc_id"));
        int simSlotIndex = cursor.getInt(cursor.getColumnIndexOrThrow("sim_id"));
        String displayName = cursor.getString(cursor.getColumnIndexOrThrow("display_name"));
        String carrierName = cursor.getString(cursor.getColumnIndexOrThrow("carrier_name"));
        int nameSource = cursor.getInt(cursor.getColumnIndexOrThrow("name_source"));
        int iconTint = cursor.getInt(cursor.getColumnIndexOrThrow("color"));
        String number = cursor.getString(cursor.getColumnIndexOrThrow("number"));
        int dataRoaming = cursor.getInt(cursor.getColumnIndexOrThrow("data_roaming"));
        Bitmap iconBitmap = BitmapFactory.decodeResource(this.mContext.getResources(), 17302815);
        String mcc = cursor.getString(cursor.getColumnIndexOrThrow("mcc_string"));
        String mnc = cursor.getString(cursor.getColumnIndexOrThrow("mnc_string"));
        String ehplmnsRaw = cursor.getString(cursor.getColumnIndexOrThrow("ehplmns"));
        String hplmnsRaw = cursor.getString(cursor.getColumnIndexOrThrow("hplmns"));
        String[] ehplmns = ehplmnsRaw == null ? null : ehplmnsRaw.split(",");
        String[] hplmns = hplmnsRaw == null ? null : hplmnsRaw.split(",");
        String cardId = cursor.getString(cursor.getColumnIndexOrThrow("card_id"));
        String countryIso = cursor.getString(cursor.getColumnIndexOrThrow("iso_country_code"));
        int publicCardId = this.mUiccController.convertToPublicCardId(cardId);
        boolean isEmbedded = cursor.getInt(cursor.getColumnIndexOrThrow("is_embedded")) == 1;
        int carrierId = cursor.getInt(cursor.getColumnIndexOrThrow("carrier_id"));
        Object[] accessRules = isEmbedded ? UiccAccessRule.decodeRules(cursor.getBlob(cursor.getColumnIndexOrThrow("access_rules"))) : null;
        boolean isOpportunistic = cursor.getInt(cursor.getColumnIndexOrThrow("is_opportunistic")) == 1;
        String groupUUID = cursor.getString(cursor.getColumnIndexOrThrow("group_uuid"));
        int profileClass = cursor.getInt(cursor.getColumnIndexOrThrow("profile_class"));
        int subType = cursor.getInt(cursor.getColumnIndexOrThrow("subscription_type"));
        String groupOwner = this.getOptionalStringFromCursor(cursor, "group_owner", null);
        if (VDBG) {
            String iccIdToPrint = SubscriptionInfo.givePrintableIccid(iccId);
            String cardIdToPrint = SubscriptionInfo.givePrintableIccid(cardId);
            this.logd("[getSubInfoRecord] id:" + id2 + " iccid:" + iccIdToPrint + " simSlotIndex:" + simSlotIndex + " carrierid:" + carrierId + " displayName:" + displayName + " nameSource:" + nameSource + " iconTint:" + iconTint + " dataRoaming:" + dataRoaming + " mcc:" + mcc + " mnc:" + mnc + " countIso:" + countryIso + " isEmbedded:" + isEmbedded + " accessRules:" + Arrays.toString(accessRules) + " cardId:" + cardIdToPrint + " publicCardId:" + publicCardId + " isOpportunistic:" + isOpportunistic + " groupUUID:" + groupUUID + " profileClass:" + profileClass + " subscriptionType: " + subType);
        }
        if (!TextUtils.isEmpty(line1Number = this.mTelephonyManager.getLine1Number(id2)) && !line1Number.equals(number)) {
            number = line1Number;
        }
        SubscriptionInfo info = new SubscriptionInfo(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, dataRoaming, iconBitmap, mcc, mnc, countryIso, isEmbedded, (UiccAccessRule[])accessRules, cardId, publicCardId, isOpportunistic, groupUUID, false, carrierId, profileClass, subType, groupOwner);
        info.setAssociatedPlmns(ehplmns, hplmns);
        return info;
    }

    private String getOptionalStringFromCursor(Cursor cursor, String column, String defaultVal) {
        int columnIndex = cursor.getColumnIndex(column);
        return columnIndex == -1 ? defaultVal : cursor.getString(columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public List<SubscriptionInfo> getSubInfo(String selection, Object queryKey) {
        if (VDBG) {
            this.logd("selection:" + selection + ", querykey: " + queryKey);
        }
        String[] selectionArgs = null;
        if (queryKey != null) {
            selectionArgs = new String[]{queryKey.toString()};
        }
        ArrayList<SubscriptionInfo> subList = null;
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, selection, selectionArgs, null);){
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    SubscriptionInfo subInfo = this.getSubInfoRecord(cursor);
                    if (subInfo == null) continue;
                    if (subList == null) {
                        subList = new ArrayList<SubscriptionInfo>();
                    }
                    subList.add(subInfo);
                }
            } else {
                this.logd("Query fail");
            }
        }
        return subList;
    }

    private int getUnusedColor(String callingPackage) {
        List<SubscriptionInfo> availableSubInfos = this.getActiveSubscriptionInfoList(callingPackage);
        this.colorArr = this.mContext.getResources().getIntArray(17236103);
        int colorIdx = 0;
        if (availableSubInfos != null) {
            for (int i = 0; i < this.colorArr.length; ++i) {
                int j;
                for (j = 0; j < availableSubInfos.size() && this.colorArr[i] != availableSubInfos.get(j).getIconTint(); ++j) {
                }
                if (j != availableSubInfos.size()) continue;
                return this.colorArr[i];
            }
            colorIdx = availableSubInfos.size() % this.colorArr.length;
        }
        return this.colorArr[colorIdx];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnsupportedAppUsage
    public SubscriptionInfo getActiveSubscriptionInfo(int subId, String callingPackage) {
        if (!TelephonyPermissions.checkCallingOrSelfReadPhoneState(this.mContext, subId, callingPackage, "getActiveSubscriptionInfo")) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> subList = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            if (subList != null) {
                for (SubscriptionInfo si : subList) {
                    if (si.getSubscriptionId() != subId) continue;
                    this.logd("[getActiveSubscriptionInfo]+ subId=" + subId + " subInfo=" + si);
                    SubscriptionInfo subscriptionInfo = si;
                    return subscriptionInfo;
                }
            }
            this.logd("[getActiveSubscriptionInfo]- subId=" + subId + " subList=" + subList + " subInfo=null");
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return null;
    }

    public SubscriptionInfo getSubscriptionInfo(int subId) {
        List<SubscriptionInfo> subInfoList = this.getSubInfo("_id=" + subId, null);
        if (subInfoList == null || subInfoList.isEmpty()) {
            return null;
        }
        return subInfoList.get(0);
    }

    @Override
    public SubscriptionInfo getActiveSubscriptionInfoForIccId(String iccId, String callingPackage) {
        int subId;
        SubscriptionInfo si = this.getActiveSubscriptionInfoForIccIdInternal(iccId);
        int n = subId = si != null ? si.getSubscriptionId() : -1;
        if (!TelephonyPermissions.checkCallingOrSelfReadPhoneState(this.mContext, subId, callingPackage, "getActiveSubscriptionInfoForIccId")) {
            return null;
        }
        return si;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubscriptionInfo getActiveSubscriptionInfoForIccIdInternal(String iccId) {
        if (iccId == null) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> subList = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            if (subList != null) {
                for (SubscriptionInfo si : subList) {
                    if (!iccId.equals(si.getIccId())) continue;
                    this.logd("[getActiveSubInfoUsingIccId]+ iccId=" + iccId + " subInfo=" + si);
                    SubscriptionInfo subscriptionInfo = si;
                    return subscriptionInfo;
                }
            }
            this.logd("[getActiveSubInfoUsingIccId]+ iccId=" + iccId + " subList=" + subList + " subInfo=null");
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int slotIndex, String callingPackage) {
        block8: {
            Phone phone = PhoneFactory.getPhone(slotIndex);
            if (phone == null) {
                this.loge("[getActiveSubscriptionInfoForSimSlotIndex] no phone, slotIndex=" + slotIndex);
                return null;
            }
            if (!TelephonyPermissions.checkCallingOrSelfReadPhoneState(this.mContext, phone.getSubId(), callingPackage, "getActiveSubscriptionInfoForSimSlotIndex")) {
                return null;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                List<SubscriptionInfo> subList = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
                if (subList != null) {
                    for (SubscriptionInfo si : subList) {
                        if (si.getSimSlotIndex() != slotIndex) continue;
                        this.logd("[getActiveSubscriptionInfoForSimSlotIndex]+ slotIndex=" + slotIndex + " subId=" + si);
                        SubscriptionInfo subscriptionInfo = si;
                        return subscriptionInfo;
                    }
                    this.logd("[getActiveSubscriptionInfoForSimSlotIndex]+ slotIndex=" + slotIndex + " subId=null");
                    break block8;
                }
                this.logd("[getActiveSubscriptionInfoForSimSlotIndex]+ subList=null");
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SubscriptionInfo> getAllSubInfoList(String callingPackage) {
        if (VDBG) {
            this.logd("[getAllSubInfoList]+");
        }
        if (!TelephonyPermissions.checkCallingOrSelfReadPhoneState(this.mContext, -1, callingPackage, "getAllSubInfoList")) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> subList = null;
            subList = this.getSubInfo(null, null);
            if (subList != null) {
                if (VDBG) {
                    this.logd("[getAllSubInfoList]- " + subList.size() + " infos return");
                }
            } else if (VDBG) {
                this.logd("[getAllSubInfoList]- no info return");
            }
            List<SubscriptionInfo> list = subList;
            return list;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @Override
    @UnsupportedAppUsage
    public List<SubscriptionInfo> getActiveSubscriptionInfoList(String callingPackage) {
        return this.getSubscriptionInfoListFromCacheHelper(callingPackage, this.mCacheActiveSubInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void refreshCachedActiveSubscriptionInfoList() {
        boolean opptSubListChanged;
        Object object = this.mSubInfoListLock;
        synchronized (object) {
            List<SubscriptionInfo> activeSubscriptionInfoList = this.getSubInfo("sim_id>=0 OR subscription_type=1", null);
            if (activeSubscriptionInfoList != null) {
                if (this.mCacheActiveSubInfoList.size() != activeSubscriptionInfoList.size() || !this.mCacheActiveSubInfoList.containsAll(activeSubscriptionInfoList)) {
                    this.logdl("Active subscription info list changed. " + activeSubscriptionInfoList);
                }
                this.mCacheActiveSubInfoList.clear();
                activeSubscriptionInfoList.sort(SUBSCRIPTION_INFO_COMPARATOR);
                this.mCacheActiveSubInfoList.addAll(activeSubscriptionInfoList);
            } else {
                this.logd("activeSubscriptionInfoList is null.");
                this.mCacheActiveSubInfoList.clear();
            }
            opptSubListChanged = this.refreshCachedOpportunisticSubscriptionInfoList();
        }
        if (opptSubListChanged) {
            this.notifyOpportunisticSubscriptionInfoChanged();
        }
    }

    @Override
    @UnsupportedAppUsage
    public int getActiveSubInfoCount(String callingPackage) {
        List<SubscriptionInfo> records = this.getActiveSubscriptionInfoList(callingPackage);
        if (records == null) {
            if (VDBG) {
                this.logd("[getActiveSubInfoCount] records null");
            }
            return 0;
        }
        if (VDBG) {
            this.logd("[getActiveSubInfoCount]- count: " + records.size());
        }
        return records.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAllSubInfoCount(String callingPackage) {
        this.logd("[getAllSubInfoCount]+");
        if (!TelephonyPermissions.checkCallingOrSelfReadPhoneState(this.mContext, -1, callingPackage, "getAllSubInfoCount")) {
            return 0;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, null, null, null);){
                if (cursor != null) {
                    int count = cursor.getCount();
                    this.logd("[getAllSubInfoCount]- " + count + " SUB(s) in DB");
                    int n = count;
                    return n;
                }
            }
            this.logd("[getAllSubInfoCount]- no SUB in DB");
            int n = 0;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @Override
    public int getActiveSubInfoCountMax() {
        return this.mTelephonyManager.getSimCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SubscriptionInfo> getAvailableSubscriptionInfoList(String callingPackage) {
        if (!TelephonyPermissions.checkCallingOrSelfReadPhoneState(this.mContext, -1, callingPackage, "getAvailableSubscriptionInfoList")) {
            throw new SecurityException("Need READ_PHONE_STATE to call  getAvailableSubscriptionInfoList");
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> subList;
            String selection = "sim_id>=0 OR subscription_type=1";
            EuiccManager euiccManager = (EuiccManager)this.mContext.getSystemService("euicc");
            if (euiccManager.isEnabled()) {
                selection = selection + " OR is_embedded=1";
            }
            if ((subList = this.getSubInfo(selection, null)) != null) {
                subList.sort(SUBSCRIPTION_INFO_COMPARATOR);
                if (VDBG) {
                    this.logdl("[getAvailableSubInfoList]- " + subList.size() + " infos return");
                }
            } else {
                this.logdl("[getAvailableSubInfoList]- no info return");
            }
            List<SubscriptionInfo> list = subList;
            return list;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SubscriptionInfo> getAccessibleSubscriptionInfoList(String callingPackage) {
        List<SubscriptionInfo> subList;
        EuiccManager euiccManager = (EuiccManager)this.mContext.getSystemService("euicc");
        if (!euiccManager.isEnabled()) {
            this.logdl("[getAccessibleSubInfoList] Embedded subscriptions are disabled");
            return null;
        }
        this.mAppOps.checkPackage(Binder.getCallingUid(), callingPackage);
        long identity = Binder.clearCallingIdentity();
        try {
            subList = this.getSubInfo("is_embedded=1", null);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        if (subList == null) {
            this.logdl("[getAccessibleSubInfoList] No info returned");
            return null;
        }
        List<SubscriptionInfo> filteredList = subList.stream().filter(subscriptionInfo -> subscriptionInfo.canManageSubscription(this.mContext, callingPackage)).sorted(SUBSCRIPTION_INFO_COMPARATOR).collect(Collectors.toList());
        if (VDBG) {
            this.logdl("[getAccessibleSubInfoList] " + filteredList.size() + " infos returned");
        }
        return filteredList;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public List<SubscriptionInfo> getSubscriptionInfoListForEmbeddedSubscriptionUpdate(String[] embeddedIccids, boolean isEuiccRemovable) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("(").append("is_embedded").append("=1");
        if (isEuiccRemovable) {
            whereClause.append(" AND ").append("is_removable").append("=1");
        }
        whereClause.append(") OR ").append("icc_id").append(" IN (");
        for (int i = 0; i < embeddedIccids.length; ++i) {
            if (i > 0) {
                whereClause.append(",");
            }
            whereClause.append("\"").append(embeddedIccids[i]).append("\"");
        }
        whereClause.append(")");
        List<SubscriptionInfo> list = this.getSubInfo(whereClause.toString(), null);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestEmbeddedSubscriptionInfoListRefresh(int cardId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_EMBEDDED_SUBSCRIPTIONS", "requestEmbeddedSubscriptionInfoListRefresh");
        long token = Binder.clearCallingIdentity();
        try {
            PhoneFactory.requestEmbeddedSubscriptionInfoListRefresh(cardId, null);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    public void requestEmbeddedSubscriptionInfoListRefresh(int cardId, Runnable callback) {
        PhoneFactory.requestEmbeddedSubscriptionInfoListRefresh(cardId, callback);
    }

    public void requestEmbeddedSubscriptionInfoListRefresh(Runnable callback) {
        PhoneFactory.requestEmbeddedSubscriptionInfoListRefresh(this.mTelephonyManager.getCardIdForDefaultEuicc(), callback);
    }

    @Override
    public int addSubInfoRecord(String iccId, int slotIndex) {
        return this.addSubInfo(iccId, null, slotIndex, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addSubInfo(String uniqueId, String displayName, int slotIndex, int subscriptionType) {
        String iccIdStr = uniqueId;
        if (!this.isSubscriptionForRemoteSim(subscriptionType)) {
            iccIdStr = SubscriptionInfo.givePrintableIccid(uniqueId);
        }
        this.logdl("[addSubInfoRecord]+ iccid: " + iccIdStr + ", slotIndex: " + slotIndex + ", subscriptionType: " + subscriptionType);
        this.enforceModifyPhoneState("addSubInfo");
        long identity = Binder.clearCallingIdentity();
        try {
            int subId;
            String[] args;
            if (uniqueId == null) {
                this.logdl("[addSubInfo]- null iccId");
                int n = -1;
                return n;
            }
            ContentResolver resolver = this.mContext.getContentResolver();
            String selection = "icc_id=?";
            if (this.isSubscriptionForRemoteSim(subscriptionType)) {
                selection = selection + " AND subscription_type=?";
                args = new String[]{uniqueId, Integer.toString(subscriptionType)};
            } else {
                selection = selection + " OR icc_id=?";
                args = new String[]{uniqueId, IccUtils.getDecimalSubstring(uniqueId)};
            }
            boolean setDisplayName = false;
            try (Cursor cursor = resolver.query(SubscriptionManager.CONTENT_URI, new String[]{"_id", "sim_id", "name_source", "icc_id", "card_id"}, selection, args, null);){
                boolean recordsDoNotExist;
                boolean bl = recordsDoNotExist = cursor == null || !cursor.moveToFirst();
                if (this.isSubscriptionForRemoteSim(subscriptionType)) {
                    if (recordsDoNotExist) {
                        slotIndex = -1;
                        Uri uri = this.insertEmptySubInfoRecord(uniqueId, displayName, slotIndex, subscriptionType);
                        this.logd("[addSubInfoRecord] New record created: " + uri);
                    } else {
                        this.logdl("[addSubInfoRecord] Record already exists");
                    }
                } else if (recordsDoNotExist) {
                    setDisplayName = true;
                    Uri uri = this.insertEmptySubInfoRecord(uniqueId, slotIndex);
                    this.logdl("[addSubInfoRecord] New record created: " + uri);
                } else {
                    String cardId;
                    UiccCard card;
                    int subId2 = cursor.getInt(0);
                    int oldSimInfoId = cursor.getInt(1);
                    int nameSource = cursor.getInt(2);
                    String oldIccId = cursor.getString(3);
                    String oldCardId = cursor.getString(4);
                    ContentValues value = new ContentValues();
                    if (slotIndex != oldSimInfoId) {
                        value.put("sim_id", slotIndex);
                    }
                    if (oldIccId != null && oldIccId.length() < uniqueId.length() && oldIccId.equals(IccUtils.getDecimalSubstring(uniqueId))) {
                        value.put("icc_id", uniqueId);
                    }
                    if ((card = this.mUiccController.getUiccCardForPhone(slotIndex)) != null && (cardId = card.getCardId()) != null && cardId != oldCardId) {
                        value.put("card_id", cardId);
                    }
                    if (value.size() > 0) {
                        resolver.update(SubscriptionManager.getUriForSubscriptionId(subId2), value, null, null);
                    }
                    this.logdl("[addSubInfoRecord] Record already exists");
                }
            }
            selection = "sim_id=?";
            args = new String[]{String.valueOf(slotIndex)};
            if (this.isSubscriptionForRemoteSim(subscriptionType)) {
                selection = "icc_id=? AND subscription_type=?";
                args = new String[]{uniqueId, Integer.toString(subscriptionType)};
            }
            cursor = resolver.query(SubscriptionManager.CONTENT_URI, null, selection, args, null);
            try {
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        if (this.addToSubIdList(slotIndex, subId = cursor.getInt(cursor.getColumnIndexOrThrow("_id")), subscriptionType)) {
                            int subIdCountMax = this.getActiveSubInfoCountMax();
                            int defaultSubId = this.getDefaultSubId();
                            this.logdl("[addSubInfoRecord] sSlotIndexToSubIds.size=" + sSlotIndexToSubIds.size() + " slotIndex=" + slotIndex + " subId=" + subId + " defaultSubId=" + defaultSubId + " simCount=" + subIdCountMax);
                            if (!this.isSubscriptionForRemoteSim(subscriptionType)) {
                                if (!SubscriptionManager.isValidSubscriptionId(defaultSubId) || subIdCountMax == 1) {
                                    this.logdl("setting default fallback subid to " + subId);
                                    this.setDefaultFallbackSubId(subId, subscriptionType);
                                }
                                if (subIdCountMax == 1) {
                                    this.logdl("[addSubInfoRecord] one sim set defaults to subId=" + subId);
                                    this.setDefaultDataSubId(subId);
                                    this.setDefaultSmsSubId(subId);
                                    this.setDefaultVoiceSubId(subId);
                                }
                            } else {
                                this.updateDefaultSubIdsIfNeeded(subId, subscriptionType);
                            }
                        } else {
                            this.logdl("[addSubInfoRecord] current SubId is already known, IGNORE");
                        }
                        this.logdl("[addSubInfoRecord] hashmap(" + slotIndex + "," + subId + ")");
                    } while (cursor.moveToNext());
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.refreshCachedActiveSubscriptionInfoList();
            if (this.isSubscriptionForRemoteSim(subscriptionType)) {
                this.notifySubscriptionInfoChanged();
            } else {
                subId = this.getSubIdUsingPhoneId(slotIndex);
                if (!SubscriptionManager.isValidSubscriptionId(subId)) {
                    this.logdl("[addSubInfoRecord]- getSubId failed invalid subId = " + subId);
                    int subIdCountMax = -1;
                    return subIdCountMax;
                }
                if (setDisplayName) {
                    String simCarrierName = this.mTelephonyManager.getSimOperatorName(subId);
                    String nameToSet = !TextUtils.isEmpty(simCarrierName) ? simCarrierName : "CARD " + Integer.toString(slotIndex + 1);
                    ContentValues value = new ContentValues();
                    value.put("display_name", nameToSet);
                    resolver.update(SubscriptionManager.getUriForSubscriptionId(subId), value, null, null);
                    this.refreshCachedActiveSubscriptionInfoList();
                    this.logdl("[addSubInfoRecord] sim name = " + nameToSet);
                }
                sPhones[slotIndex].updateDataConnectionTracker();
                this.logdl("[addSubInfoRecord]- info size=" + sSlotIndexToSubIds.size());
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return 0;
    }

    private void updateDefaultSubIdsIfNeeded(int newDefault, int subscriptionType) {
        int value;
        this.logdl("[updateDefaultSubIdsIfNeeded] newDefault=" + newDefault + ", subscriptionType=" + subscriptionType);
        if (!this.isActiveSubscriptionId(this.getDefaultSubId())) {
            this.logdl("[updateDefaultSubIdsIfNeeded] set mDefaultFallbackSubId=" + newDefault);
            this.setDefaultFallbackSubId(newDefault, subscriptionType);
        }
        if (!this.isActiveSubscriptionId(value = this.getDefaultSmsSubId())) {
            this.setDefaultSmsSubId(newDefault);
        }
        if (!this.isActiveSubscriptionId(value = this.getDefaultDataSubId())) {
            this.setDefaultDataSubId(newDefault);
        }
        if (!this.isActiveSubscriptionId(value = this.getDefaultVoiceSubId())) {
            this.setDefaultVoiceSubId(newDefault);
        }
    }

    private boolean isActiveSubscriptionId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return false;
        }
        ArrayList<Integer> subIdList = this.getActiveSubIdArrayList();
        if (subIdList.isEmpty()) {
            return false;
        }
        return subIdList.contains(new Integer(subId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeSubInfo(String uniqueId, int subscriptionType) {
        this.enforceModifyPhoneState("removeSubInfo");
        this.logd("[removeSubInfo] uniqueId: " + uniqueId + ", subscriptionType: " + subscriptionType);
        int subId = -1;
        int slotIndex = -1;
        for (SubscriptionInfo info : this.mCacheActiveSubInfoList) {
            if (info.getSubscriptionType() != subscriptionType || !info.getIccId().equalsIgnoreCase(uniqueId)) continue;
            subId = info.getSubscriptionId();
            slotIndex = info.getSimSlotIndex();
            break;
        }
        if (subId == -1) {
            this.logd("Invalid subscription details: subscriptionType = " + subscriptionType + ", uniqueId = " + uniqueId);
            return -1;
        }
        this.logd("removing the subid : " + subId);
        int result = 0;
        long identity = Binder.clearCallingIdentity();
        try {
            ContentResolver resolver = this.mContext.getContentResolver();
            result = resolver.delete(SubscriptionManager.CONTENT_URI, "_id=? AND subscription_type=?", new String[]{Integer.toString(subId), Integer.toString(subscriptionType)});
            if (result != 1) {
                this.logd("found NO subscription to remove with subscriptionType = " + subscriptionType + ", uniqueId = " + uniqueId);
                int n = -1;
                return n;
            }
            this.refreshCachedActiveSubscriptionInfoList();
            ArrayList<Integer> subIdsList = sSlotIndexToSubIds.get(slotIndex);
            if (subIdsList == null) {
                this.loge("sSlotIndexToSubIds has no entry for slotIndex = " + slotIndex);
            } else if (subIdsList.contains(subId)) {
                subIdsList.remove(new Integer(subId));
                if (subIdsList.isEmpty()) {
                    sSlotIndexToSubIds.remove(slotIndex);
                }
            } else {
                this.loge("sSlotIndexToSubIds has no subid: " + subId + ", in index: " + slotIndex);
            }
            int newDefault = -1;
            SubscriptionInfo info = null;
            List<SubscriptionInfo> records = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            if (!records.isEmpty()) {
                info = records.get(0);
            }
            this.updateDefaultSubIdsIfNeeded(info.getSubscriptionId(), info.getSubscriptionType());
            this.notifySubscriptionInfoChanged();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return result;
    }

    public void clearSubInfoRecord(int slotIndex) {
        this.logdl("[clearSubInfoRecord]+ iccId: slotIndex:" + slotIndex);
        List<SubscriptionInfo> oldSubInfo = this.getSubInfoUsingSlotIndexPrivileged(slotIndex);
        ContentResolver resolver = this.mContext.getContentResolver();
        ContentValues value = new ContentValues(1);
        value.put("sim_id", -1);
        if (oldSubInfo != null) {
            for (int i = 0; i < oldSubInfo.size(); ++i) {
                resolver.update(SubscriptionManager.getUriForSubscriptionId(oldSubInfo.get(i).getSubscriptionId()), value, null, null);
            }
        }
        this.refreshCachedActiveSubscriptionInfoList();
        sSlotIndexToSubIds.remove(slotIndex);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public Uri insertEmptySubInfoRecord(String iccId, int slotIndex) {
        return this.insertEmptySubInfoRecord(iccId, null, slotIndex, 0);
    }

    Uri insertEmptySubInfoRecord(String uniqueId, String displayName, int slotIndex, int subscriptionType) {
        ContentResolver resolver = this.mContext.getContentResolver();
        ContentValues value = new ContentValues();
        value.put("icc_id", uniqueId);
        int color2 = this.getUnusedColor(this.mContext.getOpPackageName());
        value.put("color", color2);
        value.put("sim_id", slotIndex);
        value.put("carrier_name", "");
        value.put("card_id", uniqueId);
        value.put("subscription_type", subscriptionType);
        if (this.isSubscriptionForRemoteSim(subscriptionType)) {
            value.put("display_name", displayName);
        } else {
            String cardId;
            UiccCard card = this.mUiccController.getUiccCardForPhone(slotIndex);
            if (card != null && (cardId = card.getCardId()) != null) {
                value.put("card_id", cardId);
            }
        }
        Uri uri = resolver.insert(SubscriptionManager.CONTENT_URI, value);
        this.refreshCachedActiveSubscriptionInfoList();
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public boolean setPlmnSpn(int slotIndex, boolean showPlmn, String plmn, boolean showSpn, String spn) {
        Object object = this.mLock;
        synchronized (object) {
            int subId = this.getSubIdUsingPhoneId(slotIndex);
            if (this.mContext.getPackageManager().resolveContentProvider(SubscriptionManager.CONTENT_URI.getAuthority(), 0) == null || !SubscriptionManager.isValidSubscriptionId(subId)) {
                this.logd("[setPlmnSpn] No valid subscription to store info");
                this.notifySubscriptionInfoChanged();
                return false;
            }
            String carrierText = "";
            if (showPlmn) {
                carrierText = plmn;
                if (showSpn && !Objects.equals(spn, plmn)) {
                    String separator = this.mContext.getString(17040216).toString();
                    carrierText = carrierText + separator + spn;
                }
            } else if (showSpn) {
                carrierText = spn;
            }
            this.setCarrierText(carrierText, subId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setCarrierText(String text, int subId) {
        this.logd("[setCarrierText]+ text:" + text + " subId:" + subId);
        this.enforceModifyPhoneState("setCarrierText");
        long identity = Binder.clearCallingIdentity();
        try {
            ContentValues value = new ContentValues(1);
            value.put("carrier_name", text);
            int result = this.mContext.getContentResolver().update(SubscriptionManager.getUriForSubscriptionId(subId), value, null, null);
            this.refreshCachedActiveSubscriptionInfoList();
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setIconTint(int tint, int subId) {
        this.logd("[setIconTint]+ tint:" + tint + " subId:" + subId);
        this.enforceModifyPhoneState("setIconTint");
        long identity = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            ContentValues value = new ContentValues(1);
            value.put("color", tint);
            this.logd("[setIconTint]- tint:" + tint + " set");
            int result = this.mContext.getContentResolver().update(SubscriptionManager.getUriForSubscriptionId(subId), value, null, null);
            this.refreshCachedActiveSubscriptionInfoList();
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public static int getNameSourcePriority(int nameSource) {
        switch (nameSource) {
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setDisplayNameUsingSrc(String displayName, int subId, int nameSource) {
        this.logd("[setDisplayName]+  displayName:" + displayName + " subId:" + subId + " nameSource:" + nameSource);
        this.enforceModifyPhoneState("setDisplayNameUsingSrc");
        long identity = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            List<SubscriptionInfo> allSubInfo = this.getSubInfo(null, null);
            if (allSubInfo == null || allSubInfo.isEmpty()) {
                int n = 0;
                return n;
            }
            for (SubscriptionInfo subInfo : allSubInfo) {
                if (subInfo.getSubscriptionId() != subId || SubscriptionController.getNameSourcePriority(subInfo.getNameSource()) <= SubscriptionController.getNameSourcePriority(nameSource) && (displayName == null || !displayName.equals(subInfo.getDisplayName()))) continue;
                int n = 0;
                return n;
            }
            String nameToSet = displayName == null ? this.mContext.getString(17039374) : displayName;
            ContentValues value = new ContentValues(1);
            value.put("display_name", nameToSet);
            if (nameSource >= 0) {
                this.logd("Set nameSource=" + nameSource);
                value.put("name_source", nameSource);
            }
            this.logd("[setDisplayName]- mDisplayName:" + nameToSet + " set");
            SubscriptionInfo sub = this.getSubscriptionInfo(subId);
            if (sub != null && sub.isEmbedded()) {
                int cardId = sub.getCardId();
                this.logd("Updating embedded sub nickname on cardId: " + cardId);
                EuiccManager euiccManager = ((EuiccManager)this.mContext.getSystemService("euicc")).createForCardId(cardId);
                euiccManager.updateSubscriptionNickname(subId, displayName, PendingIntent.getService(this.mContext, 0, new Intent(), 0));
            }
            int result = this.mContext.getContentResolver().update(SubscriptionManager.getUriForSubscriptionId(subId), value, null, null);
            this.refreshCachedActiveSubscriptionInfoList();
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setDisplayNumber(String number, int subId) {
        this.logd("[setDisplayNumber]+ subId:" + subId);
        this.enforceModifyPhoneState("setDisplayNumber");
        long identity = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            int phoneId = this.getPhoneId(subId);
            if (number == null || phoneId < 0 || phoneId >= this.mTelephonyManager.getPhoneCount()) {
                this.logd("[setDispalyNumber]- fail");
                int n = -1;
                return n;
            }
            ContentValues value = new ContentValues(1);
            value.put("number", number);
            int result = this.mContext.getContentResolver().update(SubscriptionManager.getUriForSubscriptionId(subId), value, null, null);
            this.refreshCachedActiveSubscriptionInfoList();
            this.logd("[setDisplayNumber]- update result :" + result);
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public void setAssociatedPlmns(String[] ehplmns, String[] hplmns, int subId) {
        this.logd("[setAssociatedPlmns]+ subId:" + subId);
        this.validateSubId(subId);
        int phoneId = this.getPhoneId(subId);
        if (phoneId < 0 || phoneId >= this.mTelephonyManager.getPhoneCount()) {
            this.logd("[setAssociatedPlmns]- fail");
            return;
        }
        String formattedEhplmns = ehplmns == null ? "" : String.join((CharSequence)",", ehplmns);
        String formattedHplmns = hplmns == null ? "" : String.join((CharSequence)",", hplmns);
        ContentValues value = new ContentValues(2);
        value.put("ehplmns", formattedEhplmns);
        value.put("hplmns", formattedHplmns);
        int count = this.mContext.getContentResolver().update(SubscriptionManager.getUriForSubscriptionId(subId), value, null, null);
        this.refreshCachedActiveSubscriptionInfoList();
        this.logd("[setAssociatedPlmns]- update result :" + count);
        this.notifySubscriptionInfoChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setDataRoaming(int roaming, int subId) {
        this.logd("[setDataRoaming]+ roaming:" + roaming + " subId:" + subId);
        this.enforceModifyPhoneState("setDataRoaming");
        long identity = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            if (roaming < 0) {
                this.logd("[setDataRoaming]- fail");
                int n = -1;
                return n;
            }
            ContentValues value = new ContentValues(1);
            value.put("data_roaming", roaming);
            this.logd("[setDataRoaming]- roaming:" + roaming + " set");
            int result = this.databaseUpdateHelper(value, subId, true);
            this.refreshCachedActiveSubscriptionInfoList();
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public void syncGroupedSetting(int refSubId) {
        String dataEnabledOverrideRules = this.getSubscriptionProperty(refSubId, "data_enabled_override_rules");
        ContentValues value = new ContentValues(1);
        value.put("data_enabled_override_rules", dataEnabledOverrideRules);
        this.databaseUpdateHelper(value, refSubId, true);
    }

    private int databaseUpdateHelper(ContentValues value, int subId, boolean updateEntireGroup) {
        List<SubscriptionInfo> infoList = this.getSubscriptionsInGroup(this.getGroupUuid(subId), this.mContext.getOpPackageName());
        if (!updateEntireGroup || infoList == null || infoList.size() == 0) {
            return this.mContext.getContentResolver().update(SubscriptionManager.getUriForSubscriptionId(subId), value, null, null);
        }
        int[] subIdList = new int[infoList.size()];
        for (int i = 0; i < infoList.size(); ++i) {
            subIdList[i] = infoList.get(i).getSubscriptionId();
        }
        return this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, this.getSelectionForSubIdList(subIdList), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setCarrierId(int carrierId, int subId) {
        this.logd("[setCarrierId]+ carrierId:" + carrierId + " subId:" + subId);
        this.enforceModifyPhoneState("setCarrierId");
        long identity = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            ContentValues value = new ContentValues(1);
            value.put("carrier_id", carrierId);
            int result = this.mContext.getContentResolver().update(SubscriptionManager.getUriForSubscriptionId(subId), value, null, null);
            this.refreshCachedActiveSubscriptionInfoList();
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public int setMccMnc(String mccMnc, int subId) {
        String mccString = mccMnc.substring(0, 3);
        String mncString = mccMnc.substring(3);
        int mcc = 0;
        int mnc = 0;
        try {
            mcc = Integer.parseInt(mccString);
            mnc = Integer.parseInt(mncString);
        }
        catch (NumberFormatException e) {
            this.loge("[setMccMnc] - couldn't parse mcc/mnc: " + mccMnc);
        }
        this.logd("[setMccMnc]+ mcc/mnc:" + mcc + "/" + mnc + " subId:" + subId);
        ContentValues value = new ContentValues(4);
        value.put("mcc", mcc);
        value.put("mnc", mnc);
        value.put("mcc_string", mccString);
        value.put("mnc_string", mncString);
        int result = this.mContext.getContentResolver().update(SubscriptionManager.getUriForSubscriptionId(subId), value, null, null);
        this.refreshCachedActiveSubscriptionInfoList();
        this.notifySubscriptionInfoChanged();
        return result;
    }

    public int setImsi(String imsi, int subId) {
        this.logd("[setImsi]+ imsi:" + imsi + " subId:" + subId);
        ContentValues value = new ContentValues(1);
        value.put("imsi", imsi);
        int result = this.mContext.getContentResolver().update(SubscriptionManager.getUriForSubscriptionId(subId), value, null, null);
        this.refreshCachedActiveSubscriptionInfoList();
        this.notifySubscriptionInfoChanged();
        return result;
    }

    public String getImsiPrivileged(int subId) {
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, "_id=?", new String[]{String.valueOf(subId)}, null);){
            String imsi = null;
            if (cursor != null) {
                if (cursor.moveToNext()) {
                    imsi = this.getOptionalStringFromCursor(cursor, "imsi", null);
                }
            } else {
                this.logd("getImsiPrivileged: failed to retrieve imsi.");
            }
            String string2 = imsi;
            return string2;
        }
    }

    public int setCountryIso(String iso, int subId) {
        this.logd("[setCountryIso]+ iso:" + iso + " subId:" + subId);
        ContentValues value = new ContentValues();
        value.put("iso_country_code", iso);
        int result = this.mContext.getContentResolver().update(SubscriptionManager.getUriForSubscriptionId(subId), value, null, null);
        this.refreshCachedActiveSubscriptionInfoList();
        this.notifySubscriptionInfoChanged();
        return result;
    }

    @Override
    public int getSlotIndex(int subId) {
        if (VDBG) {
            SubscriptionController.printStackTrace("[getSlotIndex] subId=" + subId);
        }
        if (subId == Integer.MAX_VALUE) {
            subId = this.getDefaultSubId();
        }
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            this.logd("[getSlotIndex]- subId invalid");
            return -1;
        }
        int size = sSlotIndexToSubIds.size();
        if (size == 0) {
            this.logd("[getSlotIndex]- size == 0, return SIM_NOT_INSERTED instead");
            return -1;
        }
        for (Map.Entry<Integer, ArrayList<Integer>> entry : sSlotIndexToSubIds.entrySet()) {
            int sim = entry.getKey();
            ArrayList<Integer> subs = entry.getValue();
            if (subs == null || !subs.contains(subId)) continue;
            if (VDBG) {
                this.logv("[getSlotIndex]- return = " + sim);
            }
            return sim;
        }
        this.logd("[getSlotIndex]- return fail");
        return -1;
    }

    @Override
    @Deprecated
    @UnsupportedAppUsage
    public int[] getSubId(int slotIndex) {
        if (VDBG) {
            SubscriptionController.printStackTrace("[getSubId]+ slotIndex=" + slotIndex);
        }
        if (slotIndex == Integer.MAX_VALUE) {
            slotIndex = this.getSlotIndex(this.getDefaultSubId());
            if (VDBG) {
                this.logd("[getSubId] map default slotIndex=" + slotIndex);
            }
        }
        if (!SubscriptionManager.isValidSlotIndex(slotIndex) && slotIndex != -1) {
            this.logd("[getSubId]- invalid slotIndex=" + slotIndex);
            return null;
        }
        int size = sSlotIndexToSubIds.size();
        if (size == 0) {
            if (VDBG) {
                this.logd("[getSubId]- sSlotIndexToSubIds.size == 0, return null slotIndex=" + slotIndex);
            }
            return null;
        }
        ArrayList<Integer> subIds = sSlotIndexToSubIds.get(slotIndex);
        if (subIds != null && subIds.size() > 0) {
            int[] subIdArr = new int[subIds.size()];
            for (int i = 0; i < subIds.size(); ++i) {
                subIdArr[i] = subIds.get(i);
            }
            if (VDBG) {
                this.logd("[getSubId]- subIdArr=" + subIdArr);
            }
            return subIdArr;
        }
        this.logd("[getSubId]- numSubIds == 0, return null slotIndex=" + slotIndex);
        return null;
    }

    @Override
    @UnsupportedAppUsage
    public int getPhoneId(int subId) {
        if (VDBG) {
            SubscriptionController.printStackTrace("[getPhoneId] subId=" + subId);
        }
        if (subId == Integer.MAX_VALUE) {
            subId = this.getDefaultSubId();
            this.logd("[getPhoneId] asked for default subId=" + subId);
        }
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            if (VDBG) {
                this.logdl("[getPhoneId]- invalid subId return=-1");
            }
            return -1;
        }
        int size = sSlotIndexToSubIds.size();
        if (size == 0) {
            int phoneId = mDefaultPhoneId;
            if (VDBG) {
                this.logdl("[getPhoneId]- no sims, returning default phoneId=" + phoneId);
            }
            return phoneId;
        }
        for (Map.Entry<Integer, ArrayList<Integer>> entry : sSlotIndexToSubIds.entrySet()) {
            int sim = entry.getKey();
            ArrayList<Integer> subs = entry.getValue();
            if (subs == null || !subs.contains(subId)) continue;
            if (VDBG) {
                this.logdl("[getPhoneId]- found subId=" + subId + " phoneId=" + sim);
            }
            return sim;
        }
        int phoneId = mDefaultPhoneId;
        if (VDBG) {
            this.logd("[getPhoneId]- subId=" + subId + " not found return default phoneId=" + phoneId);
        }
        return phoneId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int clearSubInfo() {
        this.enforceModifyPhoneState("clearSubInfo");
        long identity = Binder.clearCallingIdentity();
        try {
            int size = sSlotIndexToSubIds.size();
            if (size == 0) {
                this.logdl("[clearSubInfo]- no simInfo size=" + size);
                int n = 0;
                return n;
            }
            sSlotIndexToSubIds.clear();
            this.logdl("[clearSubInfo]- clear size=" + size);
            int n = size;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void logvl(String msg) {
        this.logv(msg);
        this.mLocalLog.log(msg);
    }

    private void logv(String msg) {
        Rlog.v(LOG_TAG, msg);
    }

    @UnsupportedAppUsage
    private void logdl(String msg) {
        this.logd(msg);
        this.mLocalLog.log(msg);
    }

    private static void slogd(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    @UnsupportedAppUsage
    private void logd(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private void logel(String msg) {
        this.loge(msg);
        this.mLocalLog.log(msg);
    }

    @UnsupportedAppUsage
    private void loge(String msg) {
        Rlog.e(LOG_TAG, msg);
    }

    @Override
    @UnsupportedAppUsage
    public int getDefaultSubId() {
        int subId;
        boolean isVoiceCapable = this.mContext.getResources().getBoolean(17891570);
        if (isVoiceCapable) {
            subId = this.getDefaultVoiceSubId();
            if (VDBG) {
                this.logdl("[getDefaultSubId] isVoiceCapable subId=" + subId);
            }
        } else {
            subId = this.getDefaultDataSubId();
            if (VDBG) {
                this.logdl("[getDefaultSubId] NOT VoiceCapable subId=" + subId);
            }
        }
        if (!this.isActiveSubId(subId)) {
            subId = mDefaultFallbackSubId;
            if (VDBG) {
                this.logdl("[getDefaultSubId] NOT active use fall back subId=" + subId);
            }
        }
        if (VDBG) {
            this.logv("[getDefaultSubId]- value = " + subId);
        }
        return subId;
    }

    @Override
    @UnsupportedAppUsage
    public void setDefaultSmsSubId(int subId) {
        this.enforceModifyPhoneState("setDefaultSmsSubId");
        if (subId == Integer.MAX_VALUE) {
            throw new RuntimeException("setDefaultSmsSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultSmsSubId] subId=" + subId);
        Settings.Global.putInt(this.mContext.getContentResolver(), "multi_sim_sms", subId);
        this.broadcastDefaultSmsSubIdChanged(subId);
    }

    private void broadcastDefaultSmsSubIdChanged(int subId) {
        this.logdl("[broadcastDefaultSmsSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.telephony.action.DEFAULT_SMS_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x21000000);
        intent.putExtra("subscription", subId);
        intent.putExtra("android.telephony.extra.SUBSCRIPTION_INDEX", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    @Override
    @UnsupportedAppUsage
    public int getDefaultSmsSubId() {
        int subId = Settings.Global.getInt(this.mContext.getContentResolver(), "multi_sim_sms", -1);
        if (VDBG) {
            this.logd("[getDefaultSmsSubId] subId=" + subId);
        }
        return subId;
    }

    @Override
    @UnsupportedAppUsage
    public void setDefaultVoiceSubId(int subId) {
        this.enforceModifyPhoneState("setDefaultVoiceSubId");
        if (subId == Integer.MAX_VALUE) {
            throw new RuntimeException("setDefaultVoiceSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultVoiceSubId] subId=" + subId);
        int previousDefaultSub = this.getDefaultSubId();
        Settings.Global.putInt(this.mContext.getContentResolver(), "multi_sim_voice_call", subId);
        this.broadcastDefaultVoiceSubIdChanged(subId);
        PhoneAccountHandle newHandle = subId == -1 ? null : this.mTelephonyManager.getPhoneAccountHandleForSubscriptionId(subId);
        TelecomManager telecomManager = this.mContext.getSystemService(TelecomManager.class);
        PhoneAccountHandle currentHandle = telecomManager.getUserSelectedOutgoingPhoneAccount();
        if (!Objects.equals(currentHandle, newHandle)) {
            telecomManager.setUserSelectedOutgoingPhoneAccount(newHandle);
            this.logd("[setDefaultVoiceSubId] change to phoneAccountHandle=" + newHandle);
        } else {
            this.logd("[setDefaultVoiceSubId] default phone account not changed");
        }
        if (previousDefaultSub != this.getDefaultSubId()) {
            this.sendDefaultChangedBroadcast(this.getDefaultSubId());
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void broadcastDefaultVoiceSubIdChanged(int subId) {
        this.logdl("[broadcastDefaultVoiceSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_VOICE_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x21000000);
        intent.putExtra("subscription", subId);
        intent.putExtra("android.telephony.extra.SUBSCRIPTION_INDEX", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    @Override
    @UnsupportedAppUsage
    public int getDefaultVoiceSubId() {
        int subId = Settings.Global.getInt(this.mContext.getContentResolver(), "multi_sim_voice_call", -1);
        if (VDBG) {
            SubscriptionController.slogd("[getDefaultVoiceSubId] subId=" + subId);
        }
        return subId;
    }

    @Override
    @UnsupportedAppUsage
    public int getDefaultDataSubId() {
        int subId = Settings.Global.getInt(this.mContext.getContentResolver(), "multi_sim_data_call", -1);
        if (VDBG) {
            this.logd("[getDefaultDataSubId] subId= " + subId);
        }
        return subId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnsupportedAppUsage
    public void setDefaultDataSubId(int subId) {
        this.enforceModifyPhoneState("setDefaultDataSubId");
        long identity = Binder.clearCallingIdentity();
        try {
            if (subId == Integer.MAX_VALUE) {
                throw new RuntimeException("setDefaultDataSubId called with DEFAULT_SUB_ID");
            }
            ProxyController proxyController = ProxyController.getInstance();
            int len = sPhones.length;
            this.logdl("[setDefaultDataSubId] num phones=" + len + ", subId=" + subId);
            if (SubscriptionManager.isValidSubscriptionId(subId)) {
                RadioAccessFamily[] rafs = new RadioAccessFamily[len];
                boolean atLeastOneMatch = false;
                for (int phoneId = 0; phoneId < len; ++phoneId) {
                    int raf;
                    Phone phone = sPhones[phoneId];
                    int id2 = phone.getSubId();
                    if (id2 == subId) {
                        raf = proxyController.getMaxRafSupported();
                        atLeastOneMatch = true;
                    } else {
                        raf = proxyController.getMinRafSupported();
                    }
                    this.logdl("[setDefaultDataSubId] phoneId=" + phoneId + " subId=" + id2 + " RAF=" + raf);
                    rafs[phoneId] = new RadioAccessFamily(phoneId, raf);
                }
                if (atLeastOneMatch) {
                    proxyController.setRadioCapability(rafs);
                } else {
                    this.logdl("[setDefaultDataSubId] no valid subId's found - not updating.");
                }
            }
            this.updateAllDataConnectionTrackers();
            int previousDefaultSub = this.getDefaultSubId();
            Settings.Global.putInt(this.mContext.getContentResolver(), "multi_sim_data_call", subId);
            MultiSimSettingController.getInstance().notifyDefaultDataSubChanged();
            this.broadcastDefaultDataSubIdChanged(subId);
            if (previousDefaultSub != this.getDefaultSubId()) {
                this.sendDefaultChangedBroadcast(this.getDefaultSubId());
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @UnsupportedAppUsage
    private void updateAllDataConnectionTrackers() {
        int len = sPhones.length;
        this.logd("[updateAllDataConnectionTrackers] sPhones.length=" + len);
        for (int phoneId = 0; phoneId < len; ++phoneId) {
            this.logd("[updateAllDataConnectionTrackers] phoneId=" + phoneId);
            sPhones[phoneId].updateDataConnectionTracker();
        }
    }

    @UnsupportedAppUsage
    private void broadcastDefaultDataSubIdChanged(int subId) {
        this.logdl("[broadcastDefaultDataSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x21000000);
        intent.putExtra("subscription", subId);
        intent.putExtra("android.telephony.extra.SUBSCRIPTION_INDEX", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    @UnsupportedAppUsage
    private void setDefaultFallbackSubId(int subId, int subscriptionType) {
        if (subId == Integer.MAX_VALUE) {
            throw new RuntimeException("setDefaultSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultFallbackSubId] subId=" + subId + ", subscriptionType=" + subscriptionType);
        int previousDefaultSub = this.getDefaultSubId();
        if (this.isSubscriptionForRemoteSim(subscriptionType)) {
            mDefaultFallbackSubId = subId;
            return;
        }
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            int phoneId = this.getPhoneId(subId);
            if (phoneId >= 0 && (phoneId < this.mTelephonyManager.getPhoneCount() || this.mTelephonyManager.getSimCount() == 1)) {
                this.logdl("[setDefaultFallbackSubId] set mDefaultFallbackSubId=" + subId);
                mDefaultFallbackSubId = subId;
                String defaultMccMnc = this.mTelephonyManager.getSimOperatorNumericForPhone(phoneId);
                MccTable.updateMccMncConfiguration(this.mContext, defaultMccMnc);
            } else {
                this.logdl("[setDefaultFallbackSubId] not set invalid phoneId=" + phoneId + " subId=" + subId);
            }
        }
        if (previousDefaultSub != this.getDefaultSubId()) {
            this.sendDefaultChangedBroadcast(this.getDefaultSubId());
        }
    }

    public void sendDefaultChangedBroadcast(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        Intent intent = new Intent("android.telephony.action.DEFAULT_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x21000000);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId, subId);
        this.logdl("[sendDefaultChangedBroadcast] broadcast default subId changed phoneId=" + phoneId + " subId=" + subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    public boolean isOpportunistic(int subId) {
        SubscriptionInfo info = this.getActiveSubscriptionInfo(subId, this.mContext.getOpPackageName());
        return info != null && info.isOpportunistic();
    }

    @UnsupportedAppUsage
    public int getSubIdUsingPhoneId(int phoneId) {
        int[] subIds = this.getSubId(phoneId);
        if (subIds == null || subIds.length == 0) {
            return -1;
        }
        return subIds[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public List<SubscriptionInfo> getSubInfoUsingSlotIndexPrivileged(int slotIndex) {
        this.logd("[getSubInfoUsingSlotIndexPrivileged]+ slotIndex:" + slotIndex);
        if (slotIndex == Integer.MAX_VALUE) {
            slotIndex = this.getSlotIndex(this.getDefaultSubId());
        }
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            this.logd("[getSubInfoUsingSlotIndexPrivileged]- invalid slotIndex");
            return null;
        }
        ArrayList<SubscriptionInfo> subList = null;
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, "sim_id=?", new String[]{String.valueOf(slotIndex)}, null);){
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    SubscriptionInfo subInfo = this.getSubInfoRecord(cursor);
                    if (subInfo == null) continue;
                    if (subList == null) {
                        subList = new ArrayList<SubscriptionInfo>();
                    }
                    subList.add(subInfo);
                }
            }
        }
        this.logd("[getSubInfoUsingSlotIndex]- null info return");
        return subList;
    }

    @UnsupportedAppUsage
    private void validateSubId(int subId) {
        this.logd("validateSubId subId: " + subId);
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            throw new RuntimeException("Invalid sub id passed as parameter");
        }
        if (subId == Integer.MAX_VALUE) {
            throw new RuntimeException("Default sub id passed as parameter");
        }
    }

    public void updatePhonesAvailability(Phone[] phones) {
        sPhones = phones;
    }

    private synchronized ArrayList<Integer> getActiveSubIdArrayList() {
        ArrayList<Map.Entry<Integer, ArrayList<Integer>>> simInfoList = new ArrayList<Map.Entry<Integer, ArrayList<Integer>>>(sSlotIndexToSubIds.entrySet());
        Collections.sort(simInfoList, (x, y) -> ((Integer)x.getKey()).compareTo((Integer)y.getKey()));
        ArrayList<Integer> allSubs = new ArrayList<Integer>();
        for (Map.Entry entry : simInfoList) {
            allSubs.addAll((Collection)entry.getValue());
        }
        return allSubs;
    }

    private boolean isSubscriptionVisible(int subId) {
        for (SubscriptionInfo info : this.mCacheOpportunisticSubInfoList) {
            if (info.getSubscriptionId() != subId) continue;
            return info.getGroupUuid() == null;
        }
        return true;
    }

    @Override
    public int[] getActiveSubIdList(boolean visibleOnly) {
        List<Integer> allSubs = this.getActiveSubIdArrayList();
        if (visibleOnly) {
            allSubs = allSubs.stream().filter(subId -> this.isSubscriptionVisible((int)subId)).collect(Collectors.toList());
        }
        int[] subIdArr = new int[allSubs.size()];
        int i = 0;
        Iterator iterator = allSubs.iterator();
        while (iterator.hasNext()) {
            int sub;
            subIdArr[i] = sub = ((Integer)iterator.next()).intValue();
            ++i;
        }
        if (VDBG) {
            this.logdl("[getActiveSubIdList] allSubs=" + allSubs + " subIdArr.length=" + subIdArr.length);
        }
        return subIdArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActiveSubId(int subId, String callingPackage) {
        if (!TelephonyPermissions.checkCallingOrSelfReadPhoneState(this.mContext, subId, callingPackage, "isActiveSubId")) {
            throw new SecurityException("Requires READ_PHONE_STATE permission.");
        }
        long identity = Binder.clearCallingIdentity();
        try {
            boolean bl = this.isActiveSubId(subId);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public boolean isActiveSubId(int subId) {
        boolean retVal;
        boolean bl = retVal = SubscriptionManager.isValidSubscriptionId(subId) && this.getActiveSubIdArrayList().contains(subId);
        if (VDBG) {
            this.logdl("[isActiveSubId]- " + retVal);
        }
        return retVal;
    }

    @Override
    public int getSimStateForSlotIndex(int slotIndex) {
        String err;
        IccCardConstants.State simState;
        if (slotIndex < 0) {
            simState = IccCardConstants.State.UNKNOWN;
            err = "invalid slotIndex";
        } else {
            Phone phone = null;
            try {
                phone = PhoneFactory.getPhone(slotIndex);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (phone == null) {
                simState = IccCardConstants.State.UNKNOWN;
                err = "phone == null";
            } else {
                IccCard icc = phone.getIccCard();
                if (icc == null) {
                    simState = IccCardConstants.State.UNKNOWN;
                    err = "icc == null";
                } else {
                    simState = icc.getState();
                    err = "";
                }
            }
        }
        if (VDBG) {
            this.logd("getSimStateForSlotIndex: " + err + " simState=" + (Object)((Object)simState) + " ordinal=" + simState.ordinal() + " slotIndex=" + slotIndex);
        }
        return simState.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setSubscriptionProperty(int subId, String propKey, String propValue) {
        this.enforceModifyPhoneState("setSubscriptionProperty");
        long token = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            ContentResolver resolver = this.mContext.getContentResolver();
            int result = SubscriptionController.setSubscriptionPropertyIntoContentResolver(subId, propKey, propValue, resolver);
            this.refreshCachedActiveSubscriptionInfoList();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static int setSubscriptionPropertyIntoContentResolver(int subId, String propKey, String propValue, ContentResolver resolver) {
        ContentValues value = new ContentValues();
        switch (propKey) {
            case "enable_cmas_extreme_threat_alerts": 
            case "enable_cmas_severe_threat_alerts": 
            case "enable_cmas_amber_alerts": 
            case "enable_emergency_alerts": 
            case "alert_sound_duration": 
            case "alert_reminder_interval": 
            case "enable_alert_vibrate": 
            case "enable_alert_speech": 
            case "enable_etws_test_alerts": 
            case "enable_channel_50_alerts": 
            case "enable_cmas_test_alerts": 
            case "show_cmas_opt_out_dialog": 
            case "volte_vt_enabled": 
            case "is_opportunistic": 
            case "vt_ims_enabled": 
            case "wfc_ims_enabled": 
            case "wfc_ims_mode": 
            case "wfc_ims_roaming_mode": 
            case "wfc_ims_roaming_enabled": {
                value.put(propKey, Integer.parseInt(propValue));
                break;
            }
            default: {
                SubscriptionController.slogd("Invalid column name");
            }
        }
        return resolver.update(SubscriptionManager.getUriForSubscriptionId(subId), value, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubscriptionProperty(int subId, String propKey, String callingPackage) {
        if (!TelephonyPermissions.checkCallingOrSelfReadPhoneState(this.mContext, subId, callingPackage, "getSubscriptionProperty")) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            String string2 = this.getSubscriptionProperty(subId, propKey);
            return string2;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public String getSubscriptionProperty(int subId, String propKey) {
        String resultValue = null;
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, new String[]{propKey}, "_id=?", new String[]{subId + ""}, null);){
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    switch (propKey) {
                        case "enable_cmas_extreme_threat_alerts": 
                        case "enable_cmas_severe_threat_alerts": 
                        case "enable_cmas_amber_alerts": 
                        case "enable_emergency_alerts": 
                        case "alert_sound_duration": 
                        case "alert_reminder_interval": 
                        case "enable_alert_vibrate": 
                        case "enable_alert_speech": 
                        case "enable_etws_test_alerts": 
                        case "enable_channel_50_alerts": 
                        case "enable_cmas_test_alerts": 
                        case "show_cmas_opt_out_dialog": 
                        case "volte_vt_enabled": 
                        case "vt_ims_enabled": 
                        case "wfc_ims_enabled": 
                        case "wfc_ims_mode": 
                        case "wfc_ims_roaming_mode": 
                        case "wfc_ims_roaming_enabled": 
                        case "is_opportunistic": 
                        case "group_uuid": 
                        case "white_listed_apn_data": {
                            resultValue = cursor.getInt(0) + "";
                            break;
                        }
                        case "data_enabled_override_rules": {
                            resultValue = cursor.getString(0);
                            break;
                        }
                        default: {
                            this.logd("Invalid column name");
                            break;
                        }
                    }
                } else {
                    this.logd("Valid row not present in db");
                }
            } else {
                this.logd("Query failed");
            }
        }
        this.logd("getSubscriptionProperty Query value = " + resultValue);
        return resultValue;
    }

    private static void printStackTrace(String msg) {
        RuntimeException re = new RuntimeException();
        SubscriptionController.slogd("StackTrace - " + msg);
        StackTraceElement[] st = re.getStackTrace();
        boolean first = true;
        for (StackTraceElement ste : st) {
            if (first) {
                first = false;
                continue;
            }
            SubscriptionController.slogd(ste.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "Requires DUMP");
        long token = Binder.clearCallingIdentity();
        try {
            pw.println("SubscriptionController:");
            pw.println(" mLastISubServiceRegTime=" + this.mLastISubServiceRegTime);
            pw.println(" defaultSubId=" + this.getDefaultSubId());
            pw.println(" defaultDataSubId=" + this.getDefaultDataSubId());
            pw.println(" defaultVoiceSubId=" + this.getDefaultVoiceSubId());
            pw.println(" defaultSmsSubId=" + this.getDefaultSmsSubId());
            pw.println(" defaultDataPhoneId=" + SubscriptionManager.from(this.mContext).getDefaultDataPhoneId());
            pw.println(" defaultVoicePhoneId=" + SubscriptionManager.getDefaultVoicePhoneId());
            pw.println(" defaultSmsPhoneId=" + SubscriptionManager.from(this.mContext).getDefaultSmsPhoneId());
            pw.flush();
            for (Map.Entry<Integer, ArrayList<Integer>> entry : sSlotIndexToSubIds.entrySet()) {
                pw.println(" sSlotIndexToSubId[" + entry.getKey() + "]: subIds=" + entry);
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            List<SubscriptionInfo> sirl = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            if (sirl != null) {
                pw.println(" ActiveSubInfoList:");
                for (SubscriptionInfo entry : sirl) {
                    pw.println("  " + entry.toString());
                }
            } else {
                pw.println(" ActiveSubInfoList: is null");
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            sirl = this.getAllSubInfoList(this.mContext.getOpPackageName());
            if (sirl != null) {
                pw.println(" AllSubInfoList:");
                for (SubscriptionInfo entry : sirl) {
                    pw.println("  " + entry.toString());
                }
            } else {
                pw.println(" AllSubInfoList: is null");
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            this.mLocalLog.dump(fd, pw, args);
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            pw.flush();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void migrateImsSettings() {
        this.migrateImsSettingHelper("volte_vt_enabled", "volte_vt_enabled");
        this.migrateImsSettingHelper("vt_ims_enabled", "vt_ims_enabled");
        this.migrateImsSettingHelper("wfc_ims_enabled", "wfc_ims_enabled");
        this.migrateImsSettingHelper("wfc_ims_mode", "wfc_ims_mode");
        this.migrateImsSettingHelper("wfc_ims_roaming_mode", "wfc_ims_roaming_mode");
        this.migrateImsSettingHelper("wfc_ims_roaming_enabled", "wfc_ims_roaming_enabled");
    }

    private void migrateImsSettingHelper(String settingGlobal, String subscriptionProperty) {
        ContentResolver resolver = this.mContext.getContentResolver();
        int defaultSubId = this.getDefaultVoiceSubId();
        if (defaultSubId == -1) {
            return;
        }
        try {
            int prevSetting = Settings.Global.getInt(resolver, settingGlobal);
            if (prevSetting != -1) {
                SubscriptionController.setSubscriptionPropertyIntoContentResolver(defaultSubId, subscriptionProperty, Integer.toString(prevSetting), resolver);
                Settings.Global.putInt(resolver, settingGlobal, -1);
            }
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setOpportunistic(boolean opportunistic, int subId, String callingPackage) {
        try {
            TelephonyPermissions.enforceCallingOrSelfModifyPermissionOrCarrierPrivilege(this.mContext, subId, callingPackage);
        }
        catch (SecurityException e) {
            this.enforceCarrierPrivilegeOnInactiveSub(subId, callingPackage, "Caller requires permission on sub " + subId);
        }
        long token = Binder.clearCallingIdentity();
        try {
            int ret = this.setSubscriptionProperty(subId, "is_opportunistic", String.valueOf(opportunistic ? 1 : 0));
            if (ret != 0) {
                this.notifySubscriptionInfoChanged();
            }
            int n = ret;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void enforceCarrierPrivilegeOnInactiveSub(int subId, String callingPackage, String message) {
        this.mAppOps.checkPackage(Binder.getCallingUid(), callingPackage);
        SubscriptionManager subManager = (SubscriptionManager)this.mContext.getSystemService("telephony_subscription_service");
        List<SubscriptionInfo> subInfo = this.getSubInfo("_id=" + subId, null);
        try {
            if (!this.isActiveSubId(subId) && subInfo != null && subInfo.size() == 1 && subManager.canManageSubscription(subInfo.get(0), callingPackage)) {
                return;
            }
            throw new SecurityException(message);
        }
        catch (IllegalArgumentException e) {
            throw new SecurityException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPreferredDataSubscriptionId(int subId, boolean needValidation, ISetOpportunisticDataCallback callback) {
        this.enforceModifyPhoneState("setPreferredDataSubscriptionId");
        long token = Binder.clearCallingIdentity();
        try {
            PhoneSwitcher.getInstance().trySetOpportunisticDataSubscription(subId, needValidation, callback);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPreferredDataSubscriptionId() {
        this.enforceReadPrivilegedPhoneState("getPreferredDataSubscriptionId");
        long token = Binder.clearCallingIdentity();
        try {
            int n = PhoneSwitcher.getInstance().getOpportunisticDataSubscriptionId();
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public List<SubscriptionInfo> getOpportunisticSubscriptions(String callingPackage) {
        return this.getSubscriptionInfoListFromCacheHelper(callingPackage, this.mCacheOpportunisticSubInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelUuid createSubscriptionGroup(int[] subIdList, String callingPackage) {
        if (subIdList == null || subIdList.length == 0) {
            throw new IllegalArgumentException("Invalid subIdList " + subIdList);
        }
        this.mAppOps.checkPackage(Binder.getCallingUid(), callingPackage);
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0 && !this.checkCarrierPrivilegeOnSubList(subIdList, callingPackage)) {
            throw new SecurityException("CreateSubscriptionGroup needs MODIFY_PHONE_STATE or carrier privilege permission on all specified subscriptions");
        }
        long identity = Binder.clearCallingIdentity();
        try {
            ParcelUuid groupUUID = new ParcelUuid(UUID.randomUUID());
            ContentValues value = new ContentValues();
            value.put("group_uuid", groupUUID.toString());
            value.put("group_owner", callingPackage);
            int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, this.getSelectionForSubIdList(subIdList), null);
            this.logdl("createSubscriptionGroup update DB result: " + result);
            this.refreshCachedActiveSubscriptionInfoList();
            this.notifySubscriptionInfoChanged();
            MultiSimSettingController.getInstance().notifySubscriptionGroupChanged(groupUUID);
            ParcelUuid parcelUuid = groupUUID;
            return parcelUuid;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private String getOwnerPackageOfSubGroup(ParcelUuid groupUuid) {
        if (groupUuid == null) {
            return null;
        }
        List<SubscriptionInfo> infoList = this.getSubInfo("group_uuid='" + groupUuid.toString() + "'", null);
        return ArrayUtils.isEmpty(infoList) ? null : infoList.get(0).getGroupOwner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canPackageManageGroup(ParcelUuid groupUuid, String callingPackage) {
        List<SubscriptionInfo> infoList;
        if (groupUuid == null) {
            throw new IllegalArgumentException("Invalid groupUuid");
        }
        if (TextUtils.isEmpty(callingPackage)) {
            throw new IllegalArgumentException("Empty callingPackage");
        }
        long identity = Binder.clearCallingIdentity();
        try {
            infoList = this.getSubInfo("group_uuid='" + groupUuid.toString() + "'", null);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        if (ArrayUtils.isEmpty(infoList)) {
            return true;
        }
        if (callingPackage.equals(infoList.get(0).getGroupOwner())) {
            return true;
        }
        int[] subIdArray = infoList.stream().mapToInt(info -> info.getSubscriptionId()).toArray();
        return this.checkCarrierPrivilegeOnSubList(subIdArray, callingPackage);
    }

    private int updateGroupOwner(ParcelUuid groupUuid, String groupOwner) {
        ContentValues value = new ContentValues(1);
        value.put("group_owner", groupOwner);
        return this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "group_uuid=\"" + groupUuid + "\"", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubscriptionsIntoGroup(int[] subIdList, ParcelUuid groupUuid, String callingPackage) {
        if (subIdList == null || subIdList.length == 0) {
            throw new IllegalArgumentException("Invalid subId list");
        }
        if (groupUuid == null || groupUuid.equals(INVALID_GROUP_UUID)) {
            throw new IllegalArgumentException("Invalid groupUuid");
        }
        if (this.getSubscriptionsInGroup(groupUuid, callingPackage).isEmpty()) {
            throw new IllegalArgumentException("Cannot add subscriptions to a non-existent group!");
        }
        this.mAppOps.checkPackage(Binder.getCallingUid(), callingPackage);
        if (!(this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") == 0 || this.checkCarrierPrivilegeOnSubList(subIdList, callingPackage) && this.canPackageManageGroup(groupUuid, callingPackage))) {
            throw new SecurityException("Requires MODIFY_PHONE_STATE or carrier privilege permissions on subscriptions and the group.");
        }
        long identity = Binder.clearCallingIdentity();
        try {
            this.logdl("addSubscriptionsIntoGroup sub list " + Arrays.toString(subIdList) + " into group " + groupUuid);
            ContentValues value = new ContentValues();
            value.put("group_uuid", groupUuid.toString());
            int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, this.getSelectionForSubIdList(subIdList), null);
            this.logdl("addSubscriptionsIntoGroup update DB result: " + result);
            if (result > 0) {
                this.updateGroupOwner(groupUuid, callingPackage);
                this.refreshCachedActiveSubscriptionInfoList();
                this.notifySubscriptionInfoChanged();
                MultiSimSettingController.getInstance().notifySubscriptionGroupChanged(groupUuid);
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscriptionsFromGroup(int[] subIdList, ParcelUuid groupUuid, String callingPackage) {
        if (subIdList == null || subIdList.length == 0) {
            return;
        }
        this.mAppOps.checkPackage(Binder.getCallingUid(), callingPackage);
        if (!(this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") == 0 || this.checkCarrierPrivilegeOnSubList(subIdList, callingPackage) && this.canPackageManageGroup(groupUuid, callingPackage))) {
            throw new SecurityException("removeSubscriptionsFromGroup needs MODIFY_PHONE_STATE or carrier privilege permission on all specified subscriptions");
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> subInfoList = this.getSubInfo(this.getSelectionForSubIdList(subIdList), null);
            for (SubscriptionInfo info : subInfoList) {
                if (groupUuid.equals(info.getGroupUuid())) continue;
                throw new IllegalArgumentException("Subscription " + info.getSubscriptionId() + " doesn't belong to group " + groupUuid);
            }
            ContentValues value = new ContentValues();
            value.put("group_uuid", (String)null);
            value.put("group_owner", (String)null);
            int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, this.getSelectionForSubIdList(subIdList), null);
            this.logdl("removeSubscriptionsFromGroup update DB result: " + result);
            if (result > 0) {
                this.updateGroupOwner(groupUuid, callingPackage);
                this.refreshCachedActiveSubscriptionInfoList();
                this.notifySubscriptionInfoChanged();
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCarrierPrivilegeOnSubList(int[] subIdList, String callingPackage) {
        HashSet<Integer> checkSubList = new HashSet<Integer>();
        for (int subId : subIdList) {
            if (this.isActiveSubId(subId)) {
                if (this.mTelephonyManager.hasCarrierPrivileges(subId)) continue;
                return false;
            }
            checkSubList.add(subId);
        }
        if (checkSubList.isEmpty()) {
            return true;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            SubscriptionManager subscriptionManager = (SubscriptionManager)this.mContext.getSystemService("telephony_subscription_service");
            List<SubscriptionInfo> subInfoList = this.getSubInfo(this.getSelectionForSubIdList(subIdList), null);
            if (subInfoList == null || subInfoList.size() != subIdList.length) {
                throw new IllegalArgumentException("Invalid subInfoList.");
            }
            for (SubscriptionInfo subInfo : subInfoList) {
                if (!checkSubList.contains(subInfo.getSubscriptionId())) continue;
                if (subInfo.isEmbedded() && subscriptionManager.canManageSubscription(subInfo, callingPackage)) {
                    checkSubList.remove(subInfo.getSubscriptionId());
                    continue;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = checkSubList.isEmpty();
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private String getSelectionForSubIdList(int[] subId) {
        StringBuilder selection = new StringBuilder();
        selection.append("_id");
        selection.append(" IN (");
        for (int i = 0; i < subId.length - 1; ++i) {
            selection.append(subId[i] + ", ");
        }
        selection.append(subId[subId.length - 1]);
        selection.append(")");
        return selection.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SubscriptionInfo> getSubscriptionsInGroup(ParcelUuid groupUuid, String callingPackage) {
        List<SubscriptionInfo> subInfoList;
        long identity = Binder.clearCallingIdentity();
        try {
            subInfoList = this.getAllSubInfoList(this.mContext.getOpPackageName());
            if (groupUuid == null || subInfoList == null || subInfoList.isEmpty()) {
                ArrayList<SubscriptionInfo> arrayList = new ArrayList<SubscriptionInfo>();
                return arrayList;
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return subInfoList.stream().filter(info -> {
            if (!groupUuid.equals(info.getGroupUuid())) {
                return false;
            }
            int subId = info.getSubscriptionId();
            return TelephonyPermissions.checkCallingOrSelfReadPhoneState(this.mContext, subId, callingPackage, "getSubscriptionsInGroup") || info.isEmbedded() && info.canManageSubscription(this.mContext, callingPackage);
        }).collect(Collectors.toList());
    }

    public ParcelUuid getGroupUuid(int subId) {
        List<SubscriptionInfo> subInfo = this.getSubInfo("_id=" + subId, null);
        ParcelUuid groupUuid = subInfo == null || subInfo.size() == 0 ? null : subInfo.get(0).getGroupUuid();
        return groupUuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSubscriptionEnabled(boolean enable, int subId) {
        this.enforceModifyPhoneState("setSubscriptionEnabled");
        long identity = Binder.clearCallingIdentity();
        try {
            this.logd("setSubscriptionEnabled" + (enable ? " enable " : " disable ") + " subId " + subId);
            if (!SubscriptionManager.isUsableSubscriptionId(subId)) {
                throw new IllegalArgumentException("setSubscriptionEnabled not usable subId " + subId);
            }
            SubscriptionInfo info = SubscriptionController.getInstance().getAllSubInfoList(this.mContext.getOpPackageName()).stream().filter(subInfo -> subInfo.getSubscriptionId() == subId).findFirst().get();
            if (info == null) {
                this.logd("setSubscriptionEnabled subId " + subId + " doesn't exist.");
                boolean bl = false;
                return bl;
            }
            if (info.isEmbedded()) {
                boolean bl = this.enableEmbeddedSubscription(info, enable);
                return bl;
            }
            boolean bl = this.enablePhysicalSubscription(info, enable);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private boolean enableEmbeddedSubscription(SubscriptionInfo info, boolean enable) {
        this.enableSubscriptionOverEuiccManager(info.getSubscriptionId(), enable, -1);
        return false;
    }

    private static boolean isInactiveInsertedPSim(UiccSlotInfo slotInfo, String cardId) {
        return !slotInfo.getIsEuicc() && !slotInfo.getIsActive() && slotInfo.getCardStateInfo() == 2 && TextUtils.equals(slotInfo.getCardId(), cardId);
    }

    private boolean enablePhysicalSubscription(SubscriptionInfo info, boolean enable) {
        if (enable && info.getSimSlotIndex() == -1) {
            UiccSlotInfo[] slotsInfo = this.mTelephonyManager.getUiccSlotsInfo();
            if (slotsInfo == null) {
                return false;
            }
            boolean foundMatch = false;
            for (int i = 0; i < slotsInfo.length; ++i) {
                UiccSlotInfo slotInfo = slotsInfo[i];
                if (!SubscriptionController.isInactiveInsertedPSim(slotInfo, info.getCardString())) continue;
                this.enableSubscriptionOverEuiccManager(info.getSubscriptionId(), enable, i);
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                this.logdl("enablePhysicalSubscription subId " + info.getSubscriptionId() + " is not inserted.");
            }
            return false;
        }
        return this.mTelephonyManager.enableModemForSlot(info.getSimSlotIndex(), enable);
    }

    private void enableSubscriptionOverEuiccManager(int subId, boolean enable, int physicalSlotIndex) {
        this.logdl("enableSubscriptionOverEuiccManager" + (enable ? " enable " : " disable ") + "subId " + subId + " on slotIndex " + physicalSlotIndex);
        Intent intent = new Intent("android.telephony.euicc.action.TOGGLE_SUBSCRIPTION_PRIVILEGED");
        intent.addFlags(0x10000000);
        intent.putExtra("android.telephony.euicc.extra.SUBSCRIPTION_ID", subId);
        intent.putExtra("android.telephony.euicc.extra.ENABLE_SUBSCRIPTION", enable);
        if (physicalSlotIndex != -1) {
            intent.putExtra("android.telephony.euicc.extra.PHYSICAL_SLOT_ID", physicalSlotIndex);
        }
        this.mContext.startActivity(intent);
    }

    private void updateEnabledSubscriptionGlobalSetting(int subId, int physicalSlotIndex) {
        Settings.Global.putInt(this.mContext.getContentResolver(), "enabled_subscription_for_slot" + physicalSlotIndex, subId);
    }

    private void updateModemStackEnabledGlobalSetting(boolean enabled, int physicalSlotIndex) {
        Settings.Global.putInt(this.mContext.getContentResolver(), "modem_stack_enabled_for_slot" + physicalSlotIndex, enabled ? 1 : 0);
    }

    private int getPhysicalSlotIndex(boolean isEmbedded, int subId) {
        UiccSlotInfo[] slotInfos = this.mTelephonyManager.getUiccSlotsInfo();
        int logicalSlotIndex = this.getSlotIndex(subId);
        int physicalSlotIndex = -1;
        boolean isLogicalSlotIndexValid = SubscriptionManager.isValidSlotIndex(logicalSlotIndex);
        for (int i = 0; i < slotInfos.length; ++i) {
            if ((!isLogicalSlotIndexValid || slotInfos[i].getLogicalSlotIdx() != logicalSlotIndex) && (isLogicalSlotIndexValid || !slotInfos[i].getIsEuicc() || !isEmbedded)) continue;
            physicalSlotIndex = i;
            break;
        }
        return physicalSlotIndex;
    }

    private int getPhysicalSlotIndexFromLogicalSlotIndex(int logicalSlotIndex) {
        int physicalSlotIndex = -1;
        UiccSlotInfo[] slotInfos = this.mTelephonyManager.getUiccSlotsInfo();
        for (int i = 0; i < slotInfos.length; ++i) {
            if (slotInfos[i].getLogicalSlotIdx() != logicalSlotIndex) continue;
            physicalSlotIndex = i;
            break;
        }
        return physicalSlotIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubscriptionEnabled(int subId) {
        this.enforceReadPrivilegedPhoneState("isSubscriptionEnabled");
        long identity = Binder.clearCallingIdentity();
        try {
            if (!SubscriptionManager.isUsableSubscriptionId(subId)) {
                throw new IllegalArgumentException("isSubscriptionEnabled not usable subId " + subId);
            }
            List<SubscriptionInfo> infoList = this.getSubInfo("_id=" + subId, null);
            if (infoList == null || infoList.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean isEmbedded = infoList.get(0).isEmbedded();
            if (isEmbedded) {
                boolean bl = this.isActiveSubId(subId);
                return bl;
            }
            boolean bl = this.isActiveSubId(subId) && PhoneConfigurationManager.getInstance().getPhoneStatus(PhoneFactory.getPhone(this.getPhoneId(subId)));
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEnabledSubscriptionId(int logicalSlotIndex) {
        this.enforceReadPrivilegedPhoneState("getEnabledSubscriptionId");
        long identity = Binder.clearCallingIdentity();
        try {
            int subId;
            if (!SubscriptionManager.isValidPhoneId(logicalSlotIndex)) {
                throw new IllegalArgumentException("getEnabledSubscriptionId with invalid logicalSlotIndex " + logicalSlotIndex);
            }
            int physicalSlotIndex = this.getPhysicalSlotIndexFromLogicalSlotIndex(logicalSlotIndex);
            if (physicalSlotIndex == -1) {
                int n = -1;
                return n;
            }
            int modemStackEnabled = Settings.Global.getInt(this.mContext.getContentResolver(), "modem_stack_enabled_for_slot" + physicalSlotIndex, 1);
            if (modemStackEnabled != 1) {
                int n = -1;
                return n;
            }
            try {
                subId = Settings.Global.getInt(this.mContext.getContentResolver(), "enabled_subscription_for_slot" + physicalSlotIndex);
            }
            catch (Settings.SettingNotFoundException e) {
                subId = this.getSubIdUsingPhoneId(logicalSlotIndex);
            }
            int n = subId;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SubscriptionInfo> getSubscriptionInfoListFromCacheHelper(String callingPackage, List<SubscriptionInfo> cacheSubList) {
        boolean canReadAllPhoneState;
        try {
            canReadAllPhoneState = TelephonyPermissions.checkReadPhoneState(this.mContext, -1, Binder.getCallingPid(), Binder.getCallingUid(), callingPackage, "getSubscriptionInfoList");
        }
        catch (SecurityException e) {
            canReadAllPhoneState = false;
        }
        Object object = this.mSubInfoListLock;
        synchronized (object) {
            if (canReadAllPhoneState) {
                return new ArrayList<SubscriptionInfo>(cacheSubList);
            }
            return cacheSubList.stream().filter(subscriptionInfo -> {
                try {
                    return TelephonyPermissions.checkCallingOrSelfReadPhoneState(this.mContext, subscriptionInfo.getSubscriptionId(), callingPackage, "getSubscriptionInfoList");
                }
                catch (SecurityException e) {
                    return false;
                }
            }).collect(Collectors.toList());
        }
    }

    private synchronized boolean addToSubIdList(int slotIndex, int subId, int subscriptionType) {
        ArrayList<Integer> subIdsList = sSlotIndexToSubIds.get(slotIndex);
        if (subIdsList == null) {
            subIdsList = new ArrayList();
            sSlotIndexToSubIds.put(slotIndex, subIdsList);
        }
        if (subIdsList.contains(subId)) {
            this.logdl("slotIndex, subId combo already exists in the map. Not adding it again.");
            return false;
        }
        if (this.isSubscriptionForRemoteSim(subscriptionType)) {
            subIdsList.add(subId);
        } else {
            subIdsList.clear();
            subIdsList.add(subId);
        }
        this.logdl("slotIndex, subId combo is added to the map.");
        return true;
    }

    private boolean isSubscriptionForRemoteSim(int subscriptionType) {
        return subscriptionType == 1;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public Map<Integer, ArrayList<Integer>> getSlotIndexToSubIdsMap() {
        return sSlotIndexToSubIds;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void resetStaticMembers() {
        mDefaultFallbackSubId = -1;
        mDefaultPhoneId = Integer.MAX_VALUE;
    }

    private void notifyOpportunisticSubscriptionInfoChanged() {
        ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        try {
            this.logd("notifyOpptSubscriptionInfoChanged:");
            tr.notifyOpportunisticSubscriptionInfoChanged();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshCachedOpportunisticSubscriptionInfoList() {
        Object object = this.mSubInfoListLock;
        synchronized (object) {
            List<SubscriptionInfo> oldOpptCachedList = this.mCacheOpportunisticSubInfoList;
            List<SubscriptionInfo> subList = this.getSubInfo("is_opportunistic=1 AND (sim_id>=0 OR is_embedded=1)", null);
            if (subList != null) {
                subList.sort(SUBSCRIPTION_INFO_COMPARATOR);
            } else {
                subList = new ArrayList<SubscriptionInfo>();
            }
            this.mCacheOpportunisticSubInfoList = subList;
            for (SubscriptionInfo info : this.mCacheOpportunisticSubInfoList) {
                if (!this.shouldDisableSubGroup(info.getGroupUuid())) continue;
                info.setGroupDisabled(true);
                if (!this.isActiveSubId(info.getSubscriptionId()) || !this.isSubInfoReady()) continue;
                this.logd("[refreshCachedOpportunisticSubscriptionInfoList] Deactivating grouped opportunistic subscription " + info.getSubscriptionId());
                this.deactivateSubscription(info);
            }
            return !oldOpptCachedList.equals(this.mCacheOpportunisticSubInfoList);
        }
    }

    private boolean shouldDisableSubGroup(ParcelUuid groupUuid) {
        if (groupUuid == null) {
            return false;
        }
        for (SubscriptionInfo activeInfo : this.mCacheActiveSubInfoList) {
            if (activeInfo.isOpportunistic() || !groupUuid.equals(activeInfo.getGroupUuid())) continue;
            return false;
        }
        return true;
    }

    private void deactivateSubscription(SubscriptionInfo info) {
        if (info.isEmbedded()) {
            this.logd("[deactivateSubscription] eSIM profile " + info.getSubscriptionId());
            EuiccManager euiccManager = (EuiccManager)this.mContext.getSystemService("euicc");
            euiccManager.switchToSubscription(-1, PendingIntent.getService(this.mContext, 0, new Intent(), 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAlwaysAllowMmsData(int subId, boolean alwaysAllow) {
        this.logd("[setAlwaysAllowMmsData]+ alwaysAllow:" + alwaysAllow + " subId:" + subId);
        this.enforceModifyPhoneState("setAlwaysAllowMmsData");
        long identity = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            Phone phone = PhoneFactory.getPhone(this.getPhoneId(subId));
            if (phone == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = phone.getDataEnabledSettings().setAlwaysAllowMmsData(alwaysAllow);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public boolean setDataEnabledOverrideRules(int subId, String rules) {
        boolean result;
        this.logd("[setDataEnabledOverrideRules]+ rules:" + rules + " subId:" + subId);
        this.validateSubId(subId);
        ContentValues value = new ContentValues(1);
        value.put("data_enabled_override_rules", rules);
        boolean bl = result = this.databaseUpdateHelper(value, subId, true) > 0;
        if (result) {
            this.refreshCachedActiveSubscriptionInfoList();
            this.notifySubscriptionInfoChanged();
        }
        return result;
    }

    public String getDataEnabledOverrideRules(int subId) {
        return TextUtils.emptyIfNull(this.getSubscriptionProperty(subId, "data_enabled_override_rules"));
    }

    static {
        sSlotIndexToSubIds = new ConcurrentHashMap<Integer, ArrayList<Integer>>();
        mDefaultFallbackSubId = -1;
        mDefaultPhoneId = Integer.MAX_VALUE;
    }
}

