/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.app.ActivityManager;
import android.app.UserSwitchObserver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.IPackageManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelUuid;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.service.carrier.CarrierIdentifier;
import android.service.euicc.EuiccProfileInfo;
import android.service.euicc.GetEuiccProfileInfoListResult;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.UiccAccessRule;
import android.telephony.euicc.EuiccManager;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CarrierAppUtils;
import com.android.internal.telephony.CarrierResolver;
import com.android.internal.telephony.CarrierServiceBindHelper;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IntentBroadcaster;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.MultiSimSettingController;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RILConstants;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.euicc.EuiccController;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.UiccSlot;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SubscriptionInfoUpdater
extends Handler {
    private static final String LOG_TAG = "SubscriptionInfoUpdater";
    @UnsupportedAppUsage
    private static final int PROJECT_SIM_NUM = TelephonyManager.getDefault().getPhoneCount();
    private static final boolean DBG = true;
    private static final int EVENT_INVALID = -1;
    private static final int EVENT_GET_NETWORK_SELECTION_MODE_DONE = 2;
    private static final int EVENT_SIM_LOADED = 3;
    private static final int EVENT_SIM_ABSENT = 4;
    private static final int EVENT_SIM_LOCKED = 5;
    private static final int EVENT_SIM_IO_ERROR = 6;
    private static final int EVENT_SIM_UNKNOWN = 7;
    private static final int EVENT_SIM_RESTRICTED = 8;
    private static final int EVENT_SIM_NOT_READY = 9;
    private static final int EVENT_SIM_READY = 10;
    private static final int EVENT_SIM_IMSI = 11;
    private static final int EVENT_REFRESH_EMBEDDED_SUBSCRIPTIONS = 12;
    private static final String ICCID_STRING_FOR_NO_SIM = "";
    private static final ParcelUuid REMOVE_GROUP_UUID = ParcelUuid.fromString("00000000-0000-0000-0000-000000000000");
    public static final String CURR_SUBID = "curr_subid";
    @UnsupportedAppUsage
    private static Phone[] mPhone;
    @UnsupportedAppUsage
    private static Context mContext;
    @UnsupportedAppUsage
    private static String[] mIccId;
    private static int[] sSimCardState;
    private static int[] sSimApplicationState;
    private static boolean sIsSubInfoInitialized;
    private SubscriptionManager mSubscriptionManager = null;
    private EuiccManager mEuiccManager;
    @UnsupportedAppUsage
    private IPackageManager mPackageManager;
    private Handler mBackgroundHandler;
    @UnsupportedAppUsage
    private int mCurrentlyActiveUserId;
    private CarrierServiceBindHelper mCarrierServiceBindHelper;

    public SubscriptionInfoUpdater(Looper looper, Context context, Phone[] phone, CommandsInterface[] ci) {
        this(looper, context, phone, ci, IPackageManager.Stub.asInterface(ServiceManager.getService("package")));
    }

    @VisibleForTesting
    public SubscriptionInfoUpdater(Looper looper, Context context, Phone[] phone, CommandsInterface[] ci, IPackageManager packageMgr) {
        SubscriptionInfoUpdater.logd("Constructor invoked");
        this.mBackgroundHandler = new Handler(looper);
        mContext = context;
        mPhone = phone;
        this.mSubscriptionManager = SubscriptionManager.from(mContext);
        this.mEuiccManager = (EuiccManager)mContext.getSystemService("euicc");
        this.mPackageManager = packageMgr;
        this.mCarrierServiceBindHelper = new CarrierServiceBindHelper(mContext);
        this.initializeCarrierApps();
    }

    private void initializeCarrierApps() {
        this.mCurrentlyActiveUserId = 0;
        try {
            ActivityManager.getService().registerUserSwitchObserver(new UserSwitchObserver(){

                @Override
                public void onUserSwitching(int newUserId, IRemoteCallback reply) throws RemoteException {
                    SubscriptionInfoUpdater.this.mCurrentlyActiveUserId = newUserId;
                    CarrierAppUtils.disableCarrierAppsUntilPrivileged(mContext.getOpPackageName(), SubscriptionInfoUpdater.this.mPackageManager, TelephonyManager.getDefault(), mContext.getContentResolver(), SubscriptionInfoUpdater.this.mCurrentlyActiveUserId);
                    if (reply != null) {
                        try {
                            reply.sendResult(null);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
            }, LOG_TAG);
            this.mCurrentlyActiveUserId = ActivityManager.getService().getCurrentUser().id;
        }
        catch (RemoteException e) {
            SubscriptionInfoUpdater.logd("Couldn't get current user ID; guessing it's 0: " + e.getMessage());
        }
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(mContext.getOpPackageName(), this.mPackageManager, TelephonyManager.getDefault(), mContext.getContentResolver(), this.mCurrentlyActiveUserId);
    }

    public void updateInternalIccState(String simStatus, String reason, int slotId, boolean absentAndInactive) {
        SubscriptionInfoUpdater.logd("updateInternalIccState to simStatus " + simStatus + " reason " + reason + " slotId " + slotId);
        int message = this.internalIccStateToMessage(simStatus);
        if (message != -1) {
            this.sendMessage(this.obtainMessage(message, slotId, absentAndInactive ? 1 : 0, reason));
        }
    }

    private int internalIccStateToMessage(String simStatus) {
        switch (simStatus) {
            case "ABSENT": {
                return 4;
            }
            case "UNKNOWN": {
                return 7;
            }
            case "CARD_IO_ERROR": {
                return 6;
            }
            case "CARD_RESTRICTED": {
                return 8;
            }
            case "NOT_READY": {
                return 9;
            }
            case "LOCKED": {
                return 5;
            }
            case "LOADED": {
                return 3;
            }
            case "READY": {
                return 10;
            }
            case "IMSI": {
                return 11;
            }
        }
        SubscriptionInfoUpdater.logd("Ignoring simStatus: " + simStatus);
        return -1;
    }

    @UnsupportedAppUsage
    private boolean isAllIccIdQueryDone() {
        for (int i = 0; i < PROJECT_SIM_NUM; ++i) {
            UiccSlot slot = UiccController.getInstance().getUiccSlotForPhone(i);
            int slotId = UiccController.getInstance().getSlotIdFromPhoneId(i);
            if (mIccId[i] != null && slot != null && slot.isActive()) continue;
            if (mIccId[i] == null) {
                SubscriptionInfoUpdater.logd("Wait for SIM " + i + " Iccid");
            } else {
                SubscriptionInfoUpdater.logd(String.format("Wait for slot corresponding to phone %d to be active, slotId is %d", i, slotId));
            }
            return false;
        }
        SubscriptionInfoUpdater.logd("All IccIds query complete");
        return true;
    }

    @Override
    public void handleMessage(Message msg) {
        ArrayList<Integer> cardIds = new ArrayList<Integer>();
        switch (msg.what) {
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                Integer slotId = (Integer)ar.userObj;
                if (ar.exception == null && ar.result != null) {
                    int[] modes = (int[])ar.result;
                    if (modes[0] != 1) break;
                    mPhone[slotId].setNetworkSelectionModeAutomatic(null);
                    break;
                }
                SubscriptionInfoUpdater.logd("EVENT_GET_NETWORK_SELECTION_MODE_DONE: error getting network mode.");
                break;
            }
            case 3: {
                this.handleSimLoaded(msg.arg1);
                break;
            }
            case 4: {
                this.handleSimAbsent(msg.arg1, msg.arg2);
                break;
            }
            case 5: {
                this.handleSimLocked(msg.arg1, (String)msg.obj);
                break;
            }
            case 7: {
                this.broadcastSimStateChanged(msg.arg1, "UNKNOWN", null);
                this.broadcastSimCardStateChanged(msg.arg1, 0);
                this.broadcastSimApplicationStateChanged(msg.arg1, 0);
                this.updateSubscriptionCarrierId(msg.arg1, "UNKNOWN");
                this.updateCarrierServices(msg.arg1, "UNKNOWN");
                break;
            }
            case 6: {
                this.handleSimError(msg.arg1);
                break;
            }
            case 8: {
                this.broadcastSimStateChanged(msg.arg1, "CARD_RESTRICTED", "CARD_RESTRICTED");
                this.broadcastSimCardStateChanged(msg.arg1, 9);
                this.broadcastSimApplicationStateChanged(msg.arg1, 6);
                this.updateSubscriptionCarrierId(msg.arg1, "CARD_RESTRICTED");
                this.updateCarrierServices(msg.arg1, "CARD_RESTRICTED");
                break;
            }
            case 10: {
                cardIds.add(this.getCardIdFromPhoneId(msg.arg1));
                this.updateEmbeddedSubscriptions(cardIds, hasChanges -> {
                    if (hasChanges) {
                        SubscriptionController.getInstance().notifySubscriptionInfoChanged();
                    }
                });
                this.broadcastSimStateChanged(msg.arg1, "READY", null);
                this.broadcastSimCardStateChanged(msg.arg1, 11);
                this.broadcastSimApplicationStateChanged(msg.arg1, 6);
                break;
            }
            case 11: {
                this.broadcastSimStateChanged(msg.arg1, "IMSI", null);
                break;
            }
            case 9: {
                cardIds.add(this.getCardIdFromPhoneId(msg.arg1));
                this.updateEmbeddedSubscriptions(cardIds, hasChanges -> {
                    if (hasChanges) {
                        SubscriptionController.getInstance().notifySubscriptionInfoChanged();
                    }
                });
                this.handleSimNotReady(msg.arg1);
                break;
            }
            case 12: {
                cardIds.add(msg.arg1);
                Runnable r = (Runnable)msg.obj;
                this.updateEmbeddedSubscriptions(cardIds, hasChanges -> {
                    if (hasChanges) {
                        SubscriptionController.getInstance().notifySubscriptionInfoChanged();
                    }
                    if (r != null) {
                        r.run();
                    }
                });
                break;
            }
            default: {
                SubscriptionInfoUpdater.logd("Unknown msg:" + msg.what);
            }
        }
    }

    private int getCardIdFromPhoneId(int phoneId) {
        UiccController uiccController = UiccController.getInstance();
        UiccCard card = uiccController.getUiccCardForPhone(phoneId);
        if (card != null) {
            return uiccController.convertToPublicCardId(card.getCardId());
        }
        return -2;
    }

    void requestEmbeddedSubscriptionInfoListRefresh(int cardId, Runnable callback) {
        this.sendMessage(this.obtainMessage(12, cardId, 0, callback));
    }

    private void handleSimLocked(int slotId, String reason) {
        String iccId;
        if (mIccId[slotId] != null && mIccId[slotId].equals(ICCID_STRING_FOR_NO_SIM)) {
            SubscriptionInfoUpdater.logd("SIM" + (slotId + 1) + " hot plug in");
            SubscriptionInfoUpdater.mIccId[slotId] = null;
        }
        if ((iccId = mIccId[slotId]) == null) {
            IccCard iccCard = mPhone[slotId].getIccCard();
            if (iccCard == null) {
                SubscriptionInfoUpdater.logd("handleSimLocked: IccCard null");
                return;
            }
            IccRecords records = iccCard.getIccRecords();
            if (records == null) {
                SubscriptionInfoUpdater.logd("handleSimLocked: IccRecords null");
                return;
            }
            if (IccUtils.stripTrailingFs(records.getFullIccId()) == null) {
                SubscriptionInfoUpdater.logd("handleSimLocked: IccID null");
                return;
            }
            SubscriptionInfoUpdater.mIccId[slotId] = IccUtils.stripTrailingFs(records.getFullIccId());
        } else {
            SubscriptionInfoUpdater.logd("NOT Querying IccId its already set sIccid[" + slotId + "]=" + iccId);
        }
        this.updateSubscriptionInfoByIccId(slotId, true);
        this.broadcastSimStateChanged(slotId, "LOCKED", reason);
        this.broadcastSimCardStateChanged(slotId, 11);
        this.broadcastSimApplicationStateChanged(slotId, SubscriptionInfoUpdater.getSimStateFromLockedReason(reason));
        this.updateSubscriptionCarrierId(slotId, "LOCKED");
        this.updateCarrierServices(slotId, "LOCKED");
    }

    private static int getSimStateFromLockedReason(String lockedReason) {
        switch (lockedReason) {
            case "PIN": {
                return 2;
            }
            case "PUK": {
                return 3;
            }
            case "NETWORK": {
                return 4;
            }
            case "PERM_DISABLED": {
                return 7;
            }
        }
        Rlog.e(LOG_TAG, "Unexpected SIM locked reason " + lockedReason);
        return 0;
    }

    private void handleSimNotReady(int slotId) {
        SubscriptionInfoUpdater.logd("handleSimNotReady: slotId: " + slotId);
        IccCard iccCard = mPhone[slotId].getIccCard();
        if (iccCard.isEmptyProfile()) {
            SubscriptionInfoUpdater.mIccId[slotId] = ICCID_STRING_FOR_NO_SIM;
            this.updateSubscriptionInfoByIccId(slotId, false);
        }
        this.broadcastSimStateChanged(slotId, "NOT_READY", null);
        this.broadcastSimCardStateChanged(slotId, 11);
        this.broadcastSimApplicationStateChanged(slotId, 6);
    }

    private void handleSimLoaded(int slotId) {
        SubscriptionInfoUpdater.logd("handleSimLoaded: slotId: " + slotId);
        int loadedSlotId = slotId;
        IccCard iccCard = mPhone[slotId].getIccCard();
        if (iccCard == null) {
            SubscriptionInfoUpdater.logd("handleSimLoaded: IccCard null");
            return;
        }
        IccRecords records = iccCard.getIccRecords();
        if (records == null) {
            SubscriptionInfoUpdater.logd("handleSimLoaded: IccRecords null");
            return;
        }
        if (IccUtils.stripTrailingFs(records.getFullIccId()) == null) {
            SubscriptionInfoUpdater.logd("handleSimLoaded: IccID null");
            return;
        }
        SubscriptionInfoUpdater.mIccId[slotId] = IccUtils.stripTrailingFs(records.getFullIccId());
        this.updateSubscriptionInfoByIccId(slotId, true);
        List<SubscriptionInfo> subscriptionInfos = SubscriptionController.getInstance().getSubInfoUsingSlotIndexPrivileged(slotId);
        if (subscriptionInfos == null || subscriptionInfos.isEmpty()) {
            SubscriptionInfoUpdater.loge("empty subinfo for slotId: " + slotId + "could not update ContentResolver");
        } else {
            for (SubscriptionInfo sub : subscriptionInfos) {
                SharedPreferences sp;
                int storedSubId;
                String imsi;
                int subId = sub.getSubscriptionId();
                TelephonyManager tm = (TelephonyManager)mContext.getSystemService("phone");
                String operator = tm.getSimOperatorNumeric(subId);
                if (!TextUtils.isEmpty(operator)) {
                    if (subId == SubscriptionController.getInstance().getDefaultSubId()) {
                        MccTable.updateMccMncConfiguration(mContext, operator);
                    }
                    SubscriptionController.getInstance().setMccMnc(operator, subId);
                } else {
                    SubscriptionInfoUpdater.logd("EVENT_RECORDS_LOADED Operator name is null");
                }
                String iso = tm.getSimCountryIsoForPhone(slotId);
                if (!TextUtils.isEmpty(iso)) {
                    SubscriptionController.getInstance().setCountryIso(iso, subId);
                } else {
                    SubscriptionInfoUpdater.logd("EVENT_RECORDS_LOADED sim country iso is null");
                }
                String msisdn = tm.getLine1Number(subId);
                if (msisdn != null) {
                    SubscriptionController.getInstance().setDisplayNumber(msisdn, subId);
                }
                if ((imsi = tm.createForSubscriptionId(subId).getSubscriberId()) != null) {
                    SubscriptionController.getInstance().setImsi(imsi, subId);
                }
                String[] ehplmns = records.getEhplmns();
                String[] hplmns = records.getPlmnsFromHplmnActRecord();
                if (ehplmns != null || hplmns != null) {
                    SubscriptionController.getInstance().setAssociatedPlmns(ehplmns, hplmns, subId);
                }
                if ((storedSubId = (sp = PreferenceManager.getDefaultSharedPreferences(mContext)).getInt(CURR_SUBID + slotId, -1)) == subId) continue;
                int networkType = Settings.Global.getInt(mPhone[slotId].getContext().getContentResolver(), "preferred_network_mode" + subId, -1);
                if (networkType == -1) {
                    networkType = RILConstants.PREFERRED_NETWORK_MODE;
                    try {
                        networkType = TelephonyManager.getIntAtIndex(mContext.getContentResolver(), "preferred_network_mode", slotId);
                    }
                    catch (Settings.SettingNotFoundException retrySnfe) {
                        Rlog.e(LOG_TAG, "Settings Exception Reading Value At Index for Settings.Global.PREFERRED_NETWORK_MODE");
                    }
                    Settings.Global.putInt(mPhone[slotId].getContext().getContentResolver(), "preferred_network_mode" + subId, networkType);
                }
                mPhone[slotId].setPreferredNetworkType(networkType, null);
                mPhone[slotId].getNetworkSelectionMode(this.obtainMessage(2, new Integer(slotId)));
                SharedPreferences.Editor editor = sp.edit();
                editor.putInt(CURR_SUBID + slotId, subId);
                editor.apply();
            }
        }
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(mContext.getOpPackageName(), this.mPackageManager, TelephonyManager.getDefault(), mContext.getContentResolver(), this.mCurrentlyActiveUserId);
        this.broadcastSimStateChanged(loadedSlotId, "LOADED", null);
        this.broadcastSimCardStateChanged(loadedSlotId, 11);
        this.broadcastSimApplicationStateChanged(loadedSlotId, 10);
        this.updateSubscriptionCarrierId(loadedSlotId, "LOADED");
        this.updateCarrierServices(loadedSlotId, "LOADED");
    }

    private void updateCarrierServices(int slotId, String simState) {
        CarrierConfigManager configManager = (CarrierConfigManager)mContext.getSystemService("carrier_config");
        configManager.updateConfigForPhoneId(slotId, simState);
        this.mCarrierServiceBindHelper.updateForPhoneId(slotId, simState);
    }

    private void updateSubscriptionCarrierId(int slotId, String simState) {
        if (mPhone != null && mPhone[slotId] != null) {
            mPhone[slotId].resolveSubscriptionCarrierId(simState);
        }
    }

    private void handleSimAbsent(int slotId, int absentAndInactive) {
        if (mIccId[slotId] != null && !mIccId[slotId].equals(ICCID_STRING_FOR_NO_SIM)) {
            SubscriptionInfoUpdater.logd("SIM" + (slotId + 1) + " hot plug out, absentAndInactive=" + absentAndInactive);
        }
        SubscriptionInfoUpdater.mIccId[slotId] = ICCID_STRING_FOR_NO_SIM;
        this.updateSubscriptionInfoByIccId(slotId, true);
        if (absentAndInactive == 0) {
            this.broadcastSimStateChanged(slotId, "ABSENT", null);
            this.broadcastSimCardStateChanged(slotId, 1);
            this.broadcastSimApplicationStateChanged(slotId, 0);
            this.updateSubscriptionCarrierId(slotId, "ABSENT");
            this.updateCarrierServices(slotId, "ABSENT");
        }
    }

    private void handleSimError(int slotId) {
        if (mIccId[slotId] != null && !mIccId[slotId].equals(ICCID_STRING_FOR_NO_SIM)) {
            SubscriptionInfoUpdater.logd("SIM" + (slotId + 1) + " Error ");
        }
        SubscriptionInfoUpdater.mIccId[slotId] = ICCID_STRING_FOR_NO_SIM;
        this.updateSubscriptionInfoByIccId(slotId, true);
        this.broadcastSimStateChanged(slotId, "CARD_IO_ERROR", "CARD_IO_ERROR");
        this.broadcastSimCardStateChanged(slotId, 8);
        this.broadcastSimApplicationStateChanged(slotId, 6);
        this.updateSubscriptionCarrierId(slotId, "CARD_IO_ERROR");
        this.updateCarrierServices(slotId, "CARD_IO_ERROR");
    }

    private synchronized void updateSubscriptionInfoByIccId(int slotIndex, boolean updateEmbeddedSubs) {
        UiccController uiccController;
        UiccSlot[] uiccSlots;
        List<SubscriptionInfo> subInfos;
        SubscriptionInfoUpdater.logd("updateSubscriptionInfoByIccId:+ Start");
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            SubscriptionInfoUpdater.loge("[updateSubscriptionInfoByIccId]- invalid slotIndex=" + slotIndex);
            return;
        }
        SubscriptionInfoUpdater.logd("updateSubscriptionInfoByIccId: removing subscription info record: slotIndex " + slotIndex);
        SubscriptionController.getInstance().clearSubInfoRecord(slotIndex);
        if (!ICCID_STRING_FOR_NO_SIM.equals(mIccId[slotIndex])) {
            SubscriptionInfoUpdater.logd("updateSubscriptionInfoByIccId: adding subscription info record: iccid: " + mIccId[slotIndex] + "slot: " + slotIndex);
            this.mSubscriptionManager.addSubscriptionInfoRecord(mIccId[slotIndex], slotIndex);
        }
        if ((subInfos = SubscriptionController.getInstance().getSubInfoUsingSlotIndexPrivileged(slotIndex)) != null) {
            boolean changed = false;
            for (int i = 0; i < subInfos.size(); ++i) {
                SubscriptionInfo temp = subInfos.get(i);
                ContentValues value = new ContentValues(1);
                String msisdn = TelephonyManager.getDefault().getLine1Number(temp.getSubscriptionId());
                if (TextUtils.equals(msisdn, temp.getNumber())) continue;
                value.put("number", msisdn);
                mContext.getContentResolver().update(SubscriptionManager.getUriForSubscriptionId(temp.getSubscriptionId()), value, null, null);
                changed = true;
            }
            if (changed) {
                SubscriptionController.getInstance().refreshCachedActiveSubscriptionInfoList();
            }
        }
        if (this.isAllIccIdQueryDone()) {
            SubscriptionInfoUpdater subscriptionInfoUpdater = this;
            if (this.mSubscriptionManager.isActiveSubId(subscriptionInfoUpdater.mSubscriptionManager.getDefaultDataSubscriptionId())) {
                SubscriptionInfoUpdater subscriptionInfoUpdater2 = this;
                this.mSubscriptionManager.setDefaultDataSubId(subscriptionInfoUpdater2.mSubscriptionManager.getDefaultDataSubscriptionId());
            } else {
                SubscriptionInfoUpdater.logd("bypass reset default data sub if inactive");
            }
            SubscriptionInfoUpdater.setSubInfoInitialized();
        }
        if ((uiccSlots = (uiccController = UiccController.getInstance()).getUiccSlots()) != null && updateEmbeddedSubs) {
            ArrayList<Integer> cardIds = new ArrayList<Integer>();
            for (UiccSlot uiccSlot : uiccSlots) {
                if (uiccSlot == null || uiccSlot.getUiccCard() == null) continue;
                int cardId = uiccController.convertToPublicCardId(uiccSlot.getUiccCard().getCardId());
                cardIds.add(cardId);
            }
            this.updateEmbeddedSubscriptions(cardIds, hasChanges -> {
                if (hasChanges) {
                    SubscriptionController.getInstance().notifySubscriptionInfoChanged();
                }
                SubscriptionInfoUpdater.logd("updateSubscriptionInfoByIccId: SubscriptionInfo update complete");
            });
        }
        SubscriptionController.getInstance().notifySubscriptionInfoChanged();
        SubscriptionInfoUpdater.logd("updateSubscriptionInfoByIccId: SubscriptionInfo update complete");
    }

    private static void setSubInfoInitialized() {
        if (!sIsSubInfoInitialized) {
            SubscriptionInfoUpdater.logd("SubInfo Initialized");
            sIsSubInfoInitialized = true;
            SubscriptionController.getInstance().notifySubInfoReady();
            MultiSimSettingController.getInstance().notifyAllSubscriptionLoaded();
        }
    }

    public static boolean isSubInfoInitialized() {
        return sIsSubInfoInitialized;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void updateEmbeddedSubscriptions(List<Integer> cardIds, UpdateEmbeddedSubsCallback callback) {
        if (!this.mEuiccManager.isEnabled()) {
            callback.run(false);
            return;
        }
        this.mBackgroundHandler.post(() -> {
            ArrayList<GetEuiccProfileInfoListResult> results = new ArrayList<GetEuiccProfileInfoListResult>();
            Iterator iterator = cardIds.iterator();
            while (iterator.hasNext()) {
                int cardId = (Integer)iterator.next();
                GetEuiccProfileInfoListResult result = EuiccController.get().blockingGetEuiccProfileInfoList(cardId);
                SubscriptionInfoUpdater.logd("blockingGetEuiccProfileInfoList cardId " + cardId);
                results.add(result);
            }
            this.post(() -> {
                boolean hasChanges = false;
                for (GetEuiccProfileInfoListResult result : results) {
                    if (!this.updateEmbeddedSubscriptionsCache(result)) continue;
                    hasChanges = true;
                }
                if (callback != null) {
                    callback.run(hasChanges);
                }
            });
        });
    }

    private boolean updateEmbeddedSubscriptionsCache(GetEuiccProfileInfoListResult result) {
        SubscriptionInfoUpdater.logd("updateEmbeddedSubscriptionsCache");
        if (result == null) {
            return false;
        }
        List<EuiccProfileInfo> list = result.getProfiles();
        if (result.getResult() != 0 || list == null) {
            SubscriptionInfoUpdater.logd("blockingGetEuiccProfileInfoList returns an error. Result code=" + result.getResult() + ". Null profile list=" + (result.getProfiles() == null));
            return false;
        }
        EuiccProfileInfo[] embeddedProfiles = list.toArray(new EuiccProfileInfo[list.size()]);
        SubscriptionInfoUpdater.logd("blockingGetEuiccProfileInfoList: got " + result.getProfiles().size() + " profiles");
        boolean isRemovable = result.getIsRemovable();
        String[] embeddedIccids = new String[embeddedProfiles.length];
        for (int i = 0; i < embeddedProfiles.length; ++i) {
            embeddedIccids[i] = embeddedProfiles[i].getIccid();
        }
        SubscriptionInfoUpdater.logd("Get eUICC profile list of size " + embeddedProfiles.length);
        boolean hasChanges = false;
        List<SubscriptionInfo> existingSubscriptions = SubscriptionController.getInstance().getSubscriptionInfoListForEmbeddedSubscriptionUpdate(embeddedIccids, isRemovable);
        ContentResolver contentResolver = mContext.getContentResolver();
        for (EuiccProfileInfo embeddedProfile : embeddedProfiles) {
            int index = SubscriptionInfoUpdater.findSubscriptionInfoForIccid(existingSubscriptions, embeddedProfile.getIccid());
            int prevCarrierId = -1;
            int nameSource = 0;
            if (index < 0) {
                SubscriptionController.getInstance().insertEmptySubInfoRecord(embeddedProfile.getIccid(), -1);
            } else {
                nameSource = existingSubscriptions.get(index).getNameSource();
                prevCarrierId = existingSubscriptions.get(index).getCarrierId();
                existingSubscriptions.remove(index);
            }
            SubscriptionInfoUpdater.logd("embeddedProfile " + embeddedProfile + " existing record " + (index < 0 ? "not found" : "found"));
            ContentValues values = new ContentValues();
            values.put("is_embedded", 1);
            List<UiccAccessRule> ruleList = embeddedProfile.getUiccAccessRules();
            boolean isRuleListEmpty = false;
            if (ruleList == null || ruleList.size() == 0) {
                isRuleListEmpty = true;
            }
            values.put("access_rules", isRuleListEmpty ? null : UiccAccessRule.encodeRules(ruleList.toArray(new UiccAccessRule[ruleList.size()])));
            values.put("is_removable", isRemovable);
            if (SubscriptionController.getNameSourcePriority(nameSource) <= SubscriptionController.getNameSourcePriority(3)) {
                values.put("display_name", embeddedProfile.getNickname());
                values.put("name_source", 3);
            }
            values.put("profile_class", embeddedProfile.getProfileClass());
            CarrierIdentifier cid = embeddedProfile.getCarrierIdentifier();
            if (cid != null) {
                if (prevCarrierId == -1) {
                    values.put("carrier_id", CarrierResolver.getCarrierIdFromIdentifier(mContext, cid));
                }
                String mcc = cid.getMcc();
                String mnc = cid.getMnc();
                values.put("mcc_string", mcc);
                values.put("mcc", mcc);
                values.put("mnc_string", mnc);
                values.put("mnc", mnc);
            }
            hasChanges = true;
            contentResolver.update(SubscriptionManager.CONTENT_URI, values, "icc_id=\"" + embeddedProfile.getIccid() + "\"", null);
            SubscriptionController.getInstance().refreshCachedActiveSubscriptionInfoList();
        }
        if (!existingSubscriptions.isEmpty()) {
            SubscriptionInfoUpdater.logd("Removing existing embedded subscriptions of size" + existingSubscriptions.size());
            ArrayList<String> iccidsToRemove = new ArrayList<String>();
            for (int i = 0; i < existingSubscriptions.size(); ++i) {
                SubscriptionInfo info = existingSubscriptions.get(i);
                if (!info.isEmbedded()) continue;
                SubscriptionInfoUpdater.logd("Removing embedded subscription of IccId " + info.getIccId());
                iccidsToRemove.add("\"" + info.getIccId() + "\"");
            }
            String whereClause = "icc_id IN (" + TextUtils.join((CharSequence)",", iccidsToRemove) + ")";
            ContentValues values = new ContentValues();
            values.put("is_embedded", 0);
            hasChanges = true;
            contentResolver.update(SubscriptionManager.CONTENT_URI, values, whereClause, null);
            SubscriptionController.getInstance().refreshCachedActiveSubscriptionInfoList();
        }
        SubscriptionInfoUpdater.logd("updateEmbeddedSubscriptions done hasChanges=" + hasChanges);
        return hasChanges;
    }

    public void updateSubscriptionByCarrierConfigAndNotifyComplete(int phoneId, String configPackageName, PersistableBundle config, Message onComplete) {
        this.post(() -> {
            this.updateSubscriptionByCarrierConfig(phoneId, configPackageName, config);
            onComplete.sendToTarget();
        });
    }

    private String getDefaultCarrierServicePackageName() {
        CarrierConfigManager configManager = (CarrierConfigManager)mContext.getSystemService("carrier_config");
        return configManager.getDefaultCarrierServicePackageName();
    }

    private boolean isCarrierServicePackage(int phoneId, String pkgName) {
        if (pkgName.equals(this.getDefaultCarrierServicePackageName())) {
            return false;
        }
        List<String> carrierPackageNames = TelephonyManager.from(mContext).getCarrierPackageNamesForIntentAndPhone(new Intent("android.service.carrier.CarrierService"), phoneId);
        SubscriptionInfoUpdater.logd("Carrier Packages For Subscription = " + carrierPackageNames);
        return carrierPackageNames != null && carrierPackageNames.contains(pkgName);
    }

    @VisibleForTesting
    public void updateSubscriptionByCarrierConfig(int phoneId, String configPackageName, PersistableBundle config) {
        if (!SubscriptionManager.isValidPhoneId(phoneId) || TextUtils.isEmpty(configPackageName) || config == null) {
            SubscriptionInfoUpdater.logd("In updateSubscriptionByCarrierConfig(): phoneId=" + phoneId + " configPackageName=" + configPackageName + " config=" + (config == null ? "null" : Integer.valueOf(config.hashCode())));
            return;
        }
        SubscriptionController sc = SubscriptionController.getInstance();
        if (sc == null) {
            SubscriptionInfoUpdater.loge("SubscriptionController was null");
            return;
        }
        int currentSubId = sc.getSubIdUsingPhoneId(phoneId);
        if (!SubscriptionManager.isValidSubscriptionId(currentSubId) || currentSubId == Integer.MAX_VALUE) {
            SubscriptionInfoUpdater.logd("No subscription is active for phone being updated");
            return;
        }
        SubscriptionInfo currentSubInfo = sc.getSubscriptionInfo(currentSubId);
        if (currentSubInfo == null) {
            SubscriptionInfoUpdater.loge("Couldn't retrieve subscription info for current subscription");
            return;
        }
        if (!this.isCarrierServicePackage(phoneId, configPackageName)) {
            SubscriptionInfoUpdater.loge("Cannot manage subId=" + currentSubId + ", carrierPackage=" + configPackageName);
            return;
        }
        ContentValues cv = new ContentValues();
        boolean isOpportunistic = config.getBoolean("is_opportunistic_subscription_bool", false);
        if (currentSubInfo.isOpportunistic() != isOpportunistic) {
            SubscriptionInfoUpdater.logd("Set SubId=" + currentSubId + " isOpportunistic=" + isOpportunistic);
            cv.put("is_opportunistic", isOpportunistic ? "1" : "0");
        }
        String groupUuidString = config.getString("subscription_group_uuid_string", ICCID_STRING_FOR_NO_SIM);
        ParcelUuid groupUuid = null;
        if (!TextUtils.isEmpty(groupUuidString)) {
            try {
                groupUuid = ParcelUuid.fromString(groupUuidString);
                if (groupUuid.equals(REMOVE_GROUP_UUID) && currentSubInfo.getGroupUuid() != null) {
                    cv.put("group_uuid", (String)null);
                    SubscriptionInfoUpdater.logd("Group Removed for" + currentSubId);
                } else if (SubscriptionController.getInstance().canPackageManageGroup(groupUuid, configPackageName)) {
                    cv.put("group_uuid", groupUuid.toString());
                    cv.put("group_owner", configPackageName);
                    SubscriptionInfoUpdater.logd("Group Added for" + currentSubId);
                } else {
                    SubscriptionInfoUpdater.loge("configPackageName " + configPackageName + " doesn't own grouUuid " + groupUuid);
                }
            }
            catch (IllegalArgumentException e) {
                SubscriptionInfoUpdater.loge("Invalid Group UUID=" + groupUuidString);
            }
        }
        if (cv.size() > 0 && mContext.getContentResolver().update(SubscriptionManager.getUriForSubscriptionId(currentSubId), cv, null, null) > 0) {
            sc.refreshCachedActiveSubscriptionInfoList();
            sc.notifySubscriptionInfoChanged();
            MultiSimSettingController.getInstance().notifySubscriptionGroupChanged(groupUuid);
        }
    }

    private static int findSubscriptionInfoForIccid(List<SubscriptionInfo> list, String iccid) {
        for (int i = 0; i < list.size(); ++i) {
            if (!TextUtils.equals(iccid, list.get(i).getIccId())) continue;
            return i;
        }
        return -1;
    }

    private boolean isNewSim(String iccId, String decIccId, String[] oldIccId) {
        boolean newSim = true;
        for (int i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (iccId.equals(oldIccId[i])) {
                newSim = false;
                break;
            }
            if (decIccId == null || !decIccId.equals(oldIccId[i])) continue;
            newSim = false;
            break;
        }
        SubscriptionInfoUpdater.logd("newSim = " + newSim);
        return newSim;
    }

    @UnsupportedAppUsage
    private void broadcastSimStateChanged(int slotId, String state, String reason) {
        Intent i = new Intent("android.intent.action.SIM_STATE_CHANGED");
        i.addFlags(0x4000000);
        i.putExtra("phoneName", "Phone");
        i.putExtra("ss", state);
        i.putExtra("reason", reason);
        SubscriptionManager.putPhoneIdAndSubIdExtra(i, slotId);
        SubscriptionInfoUpdater.logd("Broadcasting intent ACTION_SIM_STATE_CHANGED " + state + " reason " + reason + " for phone: " + slotId);
        IntentBroadcaster.getInstance().broadcastStickyIntent(i, slotId);
    }

    private void broadcastSimCardStateChanged(int phoneId, int state) {
        if (state != sSimCardState[phoneId]) {
            SubscriptionInfoUpdater.sSimCardState[phoneId] = state;
            Intent i = new Intent("android.telephony.action.SIM_CARD_STATE_CHANGED");
            i.addFlags(0x4000000);
            i.addFlags(0x1000000);
            i.putExtra("android.telephony.extra.SIM_STATE", state);
            SubscriptionManager.putPhoneIdAndSubIdExtra(i, phoneId);
            int slotId = UiccController.getInstance().getSlotIdFromPhoneId(phoneId);
            i.putExtra("slot", slotId);
            SubscriptionInfoUpdater.logd("Broadcasting intent ACTION_SIM_CARD_STATE_CHANGED " + SubscriptionInfoUpdater.simStateString(state) + " for phone: " + phoneId + " slot: " + slotId);
            mContext.sendBroadcast(i, "android.permission.READ_PRIVILEGED_PHONE_STATE");
            TelephonyMetrics.getInstance().updateSimState(phoneId, state);
        }
    }

    private void broadcastSimApplicationStateChanged(int phoneId, int state) {
        if (state != sSimApplicationState[phoneId] && (state != 6 || sSimApplicationState[phoneId] != 0)) {
            SubscriptionInfoUpdater.sSimApplicationState[phoneId] = state;
            Intent i = new Intent("android.telephony.action.SIM_APPLICATION_STATE_CHANGED");
            i.addFlags(0x1000000);
            i.addFlags(0x4000000);
            i.putExtra("android.telephony.extra.SIM_STATE", state);
            SubscriptionManager.putPhoneIdAndSubIdExtra(i, phoneId);
            int slotId = UiccController.getInstance().getSlotIdFromPhoneId(phoneId);
            i.putExtra("slot", slotId);
            SubscriptionInfoUpdater.logd("Broadcasting intent ACTION_SIM_APPLICATION_STATE_CHANGED " + SubscriptionInfoUpdater.simStateString(state) + " for phone: " + phoneId + " slot: " + slotId);
            mContext.sendBroadcast(i, "android.permission.READ_PRIVILEGED_PHONE_STATE");
            TelephonyMetrics.getInstance().updateSimState(phoneId, state);
        }
    }

    private static String simStateString(int state) {
        switch (state) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "ABSENT";
            }
            case 2: {
                return "PIN_REQUIRED";
            }
            case 3: {
                return "PUK_REQUIRED";
            }
            case 4: {
                return "NETWORK_LOCKED";
            }
            case 5: {
                return "READY";
            }
            case 6: {
                return "NOT_READY";
            }
            case 7: {
                return "PERM_DISABLED";
            }
            case 8: {
                return "CARD_IO_ERROR";
            }
            case 9: {
                return "CARD_RESTRICTED";
            }
            case 10: {
                return "LOADED";
            }
            case 11: {
                return "PRESENT";
            }
        }
        return "INVALID";
    }

    @UnsupportedAppUsage
    private static void logd(String message) {
        Rlog.d(LOG_TAG, message);
    }

    private static void loge(String message) {
        Rlog.e(LOG_TAG, message);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("SubscriptionInfoUpdater:");
        this.mCarrierServiceBindHelper.dump(fd, pw, args);
    }

    static {
        mContext = null;
        mIccId = new String[PROJECT_SIM_NUM];
        sSimCardState = new int[PROJECT_SIM_NUM];
        sSimApplicationState = new int[PROJECT_SIM_NUM];
        sIsSubInfoInitialized = false;
    }

    private static interface UpdateEmbeddedSubsCallback {
        public void run(boolean var1);
    }
}

