/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.telephony.Rlog;
import android.util.LocalLog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.SubscriptionController;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class SubscriptionMonitor {
    private final RegistrantList[] mSubscriptionsChangedRegistrants;
    private final RegistrantList[] mDefaultDataSubChangedRegistrants;
    private final SubscriptionController mSubscriptionController;
    private final Context mContext;
    private final int[] mPhoneSubId;
    private int mDefaultDataSubId;
    private int mDefaultDataPhoneId;
    private final Object mLock = new Object();
    private static final boolean VDBG = true;
    private static final String LOG_TAG = "SubscriptionMonitor";
    private static final int MAX_LOGLINES = 100;
    private final LocalLog mLocalLog = new LocalLog(100);
    private final IOnSubscriptionsChangedListener mSubscriptionsChangedListener = new IOnSubscriptionsChangedListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscriptionsChanged() {
            Object object = SubscriptionMonitor.this.mLock;
            synchronized (object) {
                int newDefaultDataPhoneId = -1;
                for (int phoneId = 0; phoneId < SubscriptionMonitor.this.mPhoneSubId.length; ++phoneId) {
                    int newSubId = SubscriptionMonitor.this.mSubscriptionController.getSubIdUsingPhoneId(phoneId);
                    int oldSubId = SubscriptionMonitor.this.mPhoneSubId[phoneId];
                    if (oldSubId != newSubId) {
                        SubscriptionMonitor.this.log("Phone[" + phoneId + "] subId changed " + oldSubId + "->" + newSubId + ", " + SubscriptionMonitor.this.mSubscriptionsChangedRegistrants[phoneId].size() + " registrants");
                        ((SubscriptionMonitor)SubscriptionMonitor.this).mPhoneSubId[phoneId] = newSubId;
                        SubscriptionMonitor.this.mSubscriptionsChangedRegistrants[phoneId].notifyRegistrants();
                        if (SubscriptionMonitor.this.mDefaultDataSubId == -1) continue;
                        if (newSubId == SubscriptionMonitor.this.mDefaultDataSubId || oldSubId == SubscriptionMonitor.this.mDefaultDataSubId) {
                            SubscriptionMonitor.this.log("mDefaultDataSubId = " + SubscriptionMonitor.this.mDefaultDataSubId + ", " + SubscriptionMonitor.this.mDefaultDataSubChangedRegistrants[phoneId].size() + " registrants");
                            SubscriptionMonitor.this.mDefaultDataSubChangedRegistrants[phoneId].notifyRegistrants();
                        }
                    }
                    if (newSubId != SubscriptionMonitor.this.mDefaultDataSubId) continue;
                    newDefaultDataPhoneId = phoneId;
                }
                SubscriptionMonitor.this.mDefaultDataPhoneId = newDefaultDataPhoneId;
            }
        }
    };
    private final BroadcastReceiver mDefaultDataSubscriptionChangedReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int newDefaultDataSubId = SubscriptionMonitor.this.mSubscriptionController.getDefaultDataSubId();
            Object object = SubscriptionMonitor.this.mLock;
            synchronized (object) {
                if (SubscriptionMonitor.this.mDefaultDataSubId != newDefaultDataSubId) {
                    SubscriptionMonitor.this.log("Default changed " + SubscriptionMonitor.this.mDefaultDataSubId + "->" + newDefaultDataSubId);
                    int oldDefaultDataSubId = SubscriptionMonitor.this.mDefaultDataSubId;
                    int oldDefaultDataPhoneId = SubscriptionMonitor.this.mDefaultDataPhoneId;
                    SubscriptionMonitor.this.mDefaultDataSubId = newDefaultDataSubId;
                    int newDefaultDataPhoneId = SubscriptionMonitor.this.mSubscriptionController.getPhoneId(-1);
                    if (newDefaultDataSubId != -1) {
                        for (int phoneId = 0; phoneId < SubscriptionMonitor.this.mPhoneSubId.length; ++phoneId) {
                            if (SubscriptionMonitor.this.mPhoneSubId[phoneId] != newDefaultDataSubId) continue;
                            newDefaultDataPhoneId = phoneId;
                            SubscriptionMonitor.this.log("newDefaultDataPhoneId=" + newDefaultDataPhoneId);
                            break;
                        }
                    }
                    if (newDefaultDataPhoneId != oldDefaultDataPhoneId) {
                        SubscriptionMonitor.this.log("Default phoneId changed " + oldDefaultDataPhoneId + "->" + newDefaultDataPhoneId + ", " + (SubscriptionMonitor.this.invalidPhoneId(oldDefaultDataPhoneId) ? 0 : SubscriptionMonitor.this.mDefaultDataSubChangedRegistrants[oldDefaultDataPhoneId].size()) + "," + (SubscriptionMonitor.this.invalidPhoneId(newDefaultDataPhoneId) ? 0 : SubscriptionMonitor.this.mDefaultDataSubChangedRegistrants[newDefaultDataPhoneId].size()) + " registrants");
                        SubscriptionMonitor.this.mDefaultDataPhoneId = newDefaultDataPhoneId;
                        if (!SubscriptionMonitor.this.invalidPhoneId(oldDefaultDataPhoneId)) {
                            SubscriptionMonitor.this.mDefaultDataSubChangedRegistrants[oldDefaultDataPhoneId].notifyRegistrants();
                        }
                        if (!SubscriptionMonitor.this.invalidPhoneId(newDefaultDataPhoneId)) {
                            SubscriptionMonitor.this.mDefaultDataSubChangedRegistrants[newDefaultDataPhoneId].notifyRegistrants();
                        }
                    }
                }
            }
        }
    };

    public SubscriptionMonitor(ITelephonyRegistry tr, Context context, SubscriptionController subscriptionController, int numPhones) {
        try {
            tr.addOnSubscriptionsChangedListener(context.getOpPackageName(), this.mSubscriptionsChangedListener);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.mSubscriptionController = subscriptionController;
        this.mContext = context;
        this.mSubscriptionsChangedRegistrants = new RegistrantList[numPhones];
        this.mDefaultDataSubChangedRegistrants = new RegistrantList[numPhones];
        this.mPhoneSubId = new int[numPhones];
        this.mDefaultDataSubId = this.mSubscriptionController.getDefaultDataSubId();
        this.mDefaultDataPhoneId = this.mSubscriptionController.getPhoneId(this.mDefaultDataSubId);
        for (int phoneId = 0; phoneId < numPhones; ++phoneId) {
            this.mSubscriptionsChangedRegistrants[phoneId] = new RegistrantList();
            this.mDefaultDataSubChangedRegistrants[phoneId] = new RegistrantList();
            this.mPhoneSubId[phoneId] = this.mSubscriptionController.getSubIdUsingPhoneId(phoneId);
        }
        this.mContext.registerReceiver(this.mDefaultDataSubscriptionChangedReceiver, new IntentFilter("android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED"));
    }

    @VisibleForTesting
    public SubscriptionMonitor() {
        this.mSubscriptionsChangedRegistrants = null;
        this.mDefaultDataSubChangedRegistrants = null;
        this.mSubscriptionController = null;
        this.mContext = null;
        this.mPhoneSubId = null;
    }

    public void registerForSubscriptionChanged(int phoneId, Handler h, int what, Object o) {
        if (this.invalidPhoneId(phoneId)) {
            throw new IllegalArgumentException("Invalid PhoneId");
        }
        Registrant r = new Registrant(h, what, o);
        this.mSubscriptionsChangedRegistrants[phoneId].add(r);
        r.notifyRegistrant();
    }

    public void unregisterForSubscriptionChanged(int phoneId, Handler h) {
        if (this.invalidPhoneId(phoneId)) {
            throw new IllegalArgumentException("Invalid PhoneId");
        }
        this.mSubscriptionsChangedRegistrants[phoneId].remove(h);
    }

    public void registerForDefaultDataSubscriptionChanged(int phoneId, Handler h, int what, Object o) {
        if (this.invalidPhoneId(phoneId)) {
            throw new IllegalArgumentException("Invalid PhoneId");
        }
        Registrant r = new Registrant(h, what, o);
        this.mDefaultDataSubChangedRegistrants[phoneId].add(r);
        r.notifyRegistrant();
    }

    public void unregisterForDefaultDataSubscriptionChanged(int phoneId, Handler h) {
        if (this.invalidPhoneId(phoneId)) {
            throw new IllegalArgumentException("Invalid PhoneId");
        }
        this.mDefaultDataSubChangedRegistrants[phoneId].remove(h);
    }

    private boolean invalidPhoneId(int phoneId) {
        return phoneId < 0 || phoneId >= this.mPhoneSubId.length;
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, s);
        this.mLocalLog.log(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter printWriter, String[] args) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLocalLog.dump(fd, printWriter, args);
        }
    }
}

