/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.database.Cursor;
import android.os.Handler;
import android.os.IDeviceIdleController;
import android.os.Looper;
import android.os.ServiceManager;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStatVfs;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.AppSmsManager;
import com.android.internal.telephony.CarrierActionAgent;
import com.android.internal.telephony.CarrierResolver;
import com.android.internal.telephony.CarrierSignalAgent;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DeviceStateMonitor;
import com.android.internal.telephony.GsmCdmaCallTracker;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.InboundSmsTracker;
import com.android.internal.telephony.LocaleTracker;
import com.android.internal.telephony.NewNitzStateMachine;
import com.android.internal.telephony.NitzStateMachine;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.SimActivationTracker;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.WspTypeDecoder;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.cdma.EriManager;
import com.android.internal.telephony.dataconnection.DataEnabledSettings;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.telephony.dataconnection.TransportManager;
import com.android.internal.telephony.emergency.EmergencyNumberTracker;
import com.android.internal.telephony.imsphone.ImsExternalCallTracker;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneCallTracker;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccProfile;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TelephonyComponentFactory {
    private static final String TAG = TelephonyComponentFactory.class.getSimpleName();
    private static TelephonyComponentFactory sInstance;
    private InjectedComponents mInjectedComponents;
    static final boolean USE_NEW_NITZ_STATE_MACHINE = true;

    public static TelephonyComponentFactory getInstance() {
        if (sInstance == null) {
            sInstance = new TelephonyComponentFactory();
        }
        return sInstance;
    }

    public void injectTheComponentFactory(XmlResourceParser parser) {
        if (this.mInjectedComponents != null) {
            Rlog.d(TAG, "Already injected.");
            return;
        }
        if (parser != null) {
            this.mInjectedComponents = new InjectedComponents();
            this.mInjectedComponents.parseXml(parser);
            this.mInjectedComponents.makeInjectedInstance();
            boolean injectSuccessful = !TextUtils.isEmpty(this.mInjectedComponents.getValidatedPaths());
            Rlog.d(TAG, "Total components injected: " + (injectSuccessful ? this.mInjectedComponents.mComponentNames.size() : 0));
        }
    }

    public TelephonyComponentFactory inject(String componentName) {
        if (this.mInjectedComponents != null && this.mInjectedComponents.isComponentInjected(componentName)) {
            return this.mInjectedComponents.mInjectedInstance;
        }
        return sInstance;
    }

    public GsmCdmaCallTracker makeGsmCdmaCallTracker(GsmCdmaPhone phone) {
        return new GsmCdmaCallTracker(phone);
    }

    public SmsStorageMonitor makeSmsStorageMonitor(Phone phone) {
        return new SmsStorageMonitor(phone);
    }

    public SmsUsageMonitor makeSmsUsageMonitor(Context context) {
        return new SmsUsageMonitor(context);
    }

    public ServiceStateTracker makeServiceStateTracker(GsmCdmaPhone phone, CommandsInterface ci) {
        return new ServiceStateTracker(phone, ci);
    }

    public EmergencyNumberTracker makeEmergencyNumberTracker(Phone phone, CommandsInterface ci) {
        return new EmergencyNumberTracker(phone, ci);
    }

    public NitzStateMachine makeNitzStateMachine(GsmCdmaPhone phone) {
        return new NewNitzStateMachine(phone);
    }

    public SimActivationTracker makeSimActivationTracker(Phone phone) {
        return new SimActivationTracker(phone);
    }

    public DcTracker makeDcTracker(Phone phone, int transportType) {
        return new DcTracker(phone, transportType);
    }

    public CarrierSignalAgent makeCarrierSignalAgent(Phone phone) {
        return new CarrierSignalAgent(phone);
    }

    public CarrierActionAgent makeCarrierActionAgent(Phone phone) {
        return new CarrierActionAgent(phone);
    }

    public CarrierResolver makeCarrierResolver(Phone phone) {
        return new CarrierResolver(phone);
    }

    public IccPhoneBookInterfaceManager makeIccPhoneBookInterfaceManager(Phone phone) {
        return new IccPhoneBookInterfaceManager(phone);
    }

    public IccSmsInterfaceManager makeIccSmsInterfaceManager(Phone phone) {
        return new IccSmsInterfaceManager(phone);
    }

    public UiccProfile makeUiccProfile(Context context, CommandsInterface ci, IccCardStatus ics, int phoneId, UiccCard uiccCard, Object lock) {
        return new UiccProfile(context, ci, ics, phoneId, uiccCard, lock);
    }

    public EriManager makeEriManager(Phone phone, int eriFileSource) {
        return new EriManager(phone, eriFileSource);
    }

    public WspTypeDecoder makeWspTypeDecoder(byte[] pdu) {
        return new WspTypeDecoder(pdu);
    }

    public InboundSmsTracker makeInboundSmsTracker(byte[] pdu, long timestamp, int destPort, boolean is3gpp2, boolean is3gpp2WapPdu, String address, String displayAddr, String messageBody, boolean isClass0) {
        return new InboundSmsTracker(pdu, timestamp, destPort, is3gpp2, is3gpp2WapPdu, address, displayAddr, messageBody, isClass0);
    }

    public InboundSmsTracker makeInboundSmsTracker(byte[] pdu, long timestamp, int destPort, boolean is3gpp2, String address, String displayAddr, int referenceNumber, int sequenceNumber, int messageCount, boolean is3gpp2WapPdu, String messageBody, boolean isClass0) {
        return new InboundSmsTracker(pdu, timestamp, destPort, is3gpp2, address, displayAddr, referenceNumber, sequenceNumber, messageCount, is3gpp2WapPdu, messageBody, isClass0);
    }

    public InboundSmsTracker makeInboundSmsTracker(Cursor cursor, boolean isCurrentFormat3gpp2) {
        return new InboundSmsTracker(cursor, isCurrentFormat3gpp2);
    }

    public ImsPhoneCallTracker makeImsPhoneCallTracker(ImsPhone imsPhone) {
        return new ImsPhoneCallTracker(imsPhone);
    }

    public ImsExternalCallTracker makeImsExternalCallTracker(ImsPhone imsPhone) {
        return new ImsExternalCallTracker(imsPhone);
    }

    public AppSmsManager makeAppSmsManager(Context context) {
        return new AppSmsManager(context);
    }

    public DeviceStateMonitor makeDeviceStateMonitor(Phone phone) {
        return new DeviceStateMonitor(phone);
    }

    public TransportManager makeTransportManager(Phone phone) {
        return new TransportManager(phone);
    }

    public CdmaSubscriptionSourceManager getCdmaSubscriptionSourceManagerInstance(Context context, CommandsInterface ci, Handler h, int what, Object obj) {
        return CdmaSubscriptionSourceManager.getInstance(context, ci, h, what, obj);
    }

    public IDeviceIdleController getIDeviceIdleController() {
        return IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
    }

    public LocaleTracker makeLocaleTracker(Phone phone, NitzStateMachine nitzStateMachine, Looper looper) {
        return new LocaleTracker(phone, nitzStateMachine, looper);
    }

    public DataEnabledSettings makeDataEnabledSettings(Phone phone) {
        return new DataEnabledSettings(phone);
    }

    private static class InjectedComponents {
        private static final String ATTRIBUTE_JAR = "jar";
        private static final String ATTRIBUTE_PACKAGE = "package";
        private static final String TAG_INJECTION = "injection";
        private static final String TAG_COMPONENTS = "components";
        private static final String TAG_COMPONENT = "component";
        private static final String SYSTEM = "/system/";
        private static final String PRODUCT = "/product/";
        private final Set<String> mComponentNames = new HashSet<String>();
        private TelephonyComponentFactory mInjectedInstance;
        private String mPackageName;
        private String mJarPath;

        private InjectedComponents() {
        }

        private String getValidatedPaths() {
            if (TextUtils.isEmpty(this.mPackageName) || TextUtils.isEmpty(this.mJarPath)) {
                return null;
            }
            return Arrays.stream(this.mJarPath.split(File.pathSeparator)).filter(s -> s.startsWith(SYSTEM) || s.startsWith(PRODUCT)).filter(s -> {
                try {
                    StructStatVfs vfs = Os.statvfs(s);
                    return (vfs.f_flag & (long)OsConstants.ST_RDONLY) != 0L;
                }
                catch (ErrnoException e) {
                    Rlog.w(TAG, "Injection jar is not protected , path: " + s + e.getMessage());
                    return false;
                }
            }).distinct().collect(Collectors.joining(File.pathSeparator));
        }

        private void makeInjectedInstance() {
            String validatedPaths = this.getValidatedPaths();
            Rlog.d(TAG, "validated paths: " + validatedPaths);
            if (!TextUtils.isEmpty(validatedPaths)) {
                try {
                    PathClassLoader classLoader = new PathClassLoader(validatedPaths, ClassLoader.getSystemClassLoader());
                    Class<?> cls = classLoader.loadClass(this.mPackageName);
                    this.mInjectedInstance = (TelephonyComponentFactory)cls.newInstance();
                }
                catch (ClassNotFoundException e) {
                    Rlog.e(TAG, "failed: " + e.getMessage());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    Rlog.e(TAG, "injection failed: " + e.getMessage());
                }
            }
        }

        private boolean isComponentInjected(String componentName) {
            if (this.mInjectedInstance == null) {
                return false;
            }
            return this.mComponentNames.contains(componentName);
        }

        private void parseXml(XmlPullParser parser) {
            this.parseXmlByTag(parser, false, p -> {
                this.setAttributes((XmlPullParser)p);
                this.parseInjection((XmlPullParser)p);
            }, TAG_INJECTION);
        }

        private void parseInjection(XmlPullParser parser) {
            this.parseXmlByTag(parser, false, p -> this.parseComponents((XmlPullParser)p), TAG_COMPONENTS);
        }

        private void parseComponents(XmlPullParser parser) {
            this.parseXmlByTag(parser, true, p -> this.parseComponent((XmlPullParser)p), TAG_COMPONENT);
        }

        private void parseComponent(XmlPullParser parser) {
            try {
                int type;
                int outerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                    if (type != 4) continue;
                    this.mComponentNames.add(parser.getText());
                }
            }
            catch (IOException | XmlPullParserException e) {
                Rlog.e(TAG, "Failed to parse the component.", e);
            }
        }

        private void parseXmlByTag(XmlPullParser parser, boolean allowDuplicate, Consumer<XmlPullParser> consumer, String tag) {
            try {
                int type;
                int outerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                    if (type != 2 || !tag.equals(parser.getName())) continue;
                    consumer.accept(parser);
                    if (allowDuplicate) continue;
                    return;
                }
            }
            catch (IOException | XmlPullParserException e) {
                Rlog.e(TAG, "Failed to parse or find tag: " + tag, e);
            }
        }

        private void setAttributes(XmlPullParser parser) {
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String name = parser.getAttributeName(i);
                String value = parser.getAttributeValue(i);
                if (ATTRIBUTE_PACKAGE.equals(name)) {
                    this.mPackageName = value;
                    continue;
                }
                if (!ATTRIBUTE_JAR.equals(name)) continue;
                this.mJarPath = value;
            }
        }
    }
}

