/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.util.Log;
import android.util.StatsLog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.ITelephony;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public final class TelephonyPermissions {
    private static final String LOG_TAG = "TelephonyPermissions";
    private static final boolean DBG = false;
    private static final Supplier<ITelephony> TELEPHONY_SUPPLIER = () -> ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
    private static final String PROPERTY_DEVICE_IDENTIFIER_ACCESS_RESTRICTIONS_DISABLED = "device_identifier_access_restrictions_disabled";
    private static final Map<String, Set<String>> sReportedDeviceIDPackages = new HashMap<String, Set<String>>();

    private TelephonyPermissions() {
    }

    public static boolean checkCallingOrSelfReadPhoneState(Context context, int subId, String callingPackage, String message) {
        return TelephonyPermissions.checkReadPhoneState(context, subId, Binder.getCallingPid(), Binder.getCallingUid(), callingPackage, message);
    }

    public static boolean checkCallingOrSelfReadPhoneStateNoThrow(Context context, int subId, String callingPackage, String message) {
        try {
            return TelephonyPermissions.checkCallingOrSelfReadPhoneState(context, subId, callingPackage, message);
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static boolean checkReadPhoneState(Context context, int subId, int pid, int uid, String callingPackage, String message) {
        return TelephonyPermissions.checkReadPhoneState(context, TELEPHONY_SUPPLIER, subId, pid, uid, callingPackage, message);
    }

    public static boolean checkCarrierPrivilegeForSubId(int subId) {
        return SubscriptionManager.isValidSubscriptionId(subId) && TelephonyPermissions.getCarrierPrivilegeStatus(TELEPHONY_SUPPLIER, subId, Binder.getCallingUid()) == 1;
    }

    @VisibleForTesting
    public static boolean checkReadPhoneState(Context context, Supplier<ITelephony> telephonySupplier, int subId, int pid, int uid, String callingPackage, String message) {
        try {
            context.enforcePermission("android.permission.READ_PRIVILEGED_PHONE_STATE", pid, uid, message);
            return true;
        }
        catch (SecurityException privilegedPhoneStateException) {
            try {
                context.enforcePermission("android.permission.READ_PHONE_STATE", pid, uid, message);
            }
            catch (SecurityException phoneStateException) {
                if (SubscriptionManager.isValidSubscriptionId(subId)) {
                    TelephonyPermissions.enforceCarrierPrivilege(telephonySupplier, subId, uid, message);
                    return true;
                }
                throw phoneStateException;
            }
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            return appOps.noteOp(51, uid, callingPackage) == 0;
        }
    }

    public static boolean checkReadPhoneStateOnAnyActiveSub(Context context, int pid, int uid, String callingPackage, String message) {
        return TelephonyPermissions.checkReadPhoneStateOnAnyActiveSub(context, TELEPHONY_SUPPLIER, pid, uid, callingPackage, message);
    }

    @VisibleForTesting
    public static boolean checkReadPhoneStateOnAnyActiveSub(Context context, Supplier<ITelephony> telephonySupplier, int pid, int uid, String callingPackage, String message) {
        try {
            context.enforcePermission("android.permission.READ_PRIVILEGED_PHONE_STATE", pid, uid, message);
            return true;
        }
        catch (SecurityException privilegedPhoneStateException) {
            try {
                context.enforcePermission("android.permission.READ_PHONE_STATE", pid, uid, message);
            }
            catch (SecurityException phoneStateException) {
                return TelephonyPermissions.checkCarrierPrivilegeForAnySubId(context, telephonySupplier, uid);
            }
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            return appOps.noteOp(51, uid, callingPackage) == 0;
        }
    }

    public static boolean checkCallingOrSelfReadDeviceIdentifiers(Context context, String callingPackage, String message) {
        return TelephonyPermissions.checkCallingOrSelfReadDeviceIdentifiers(context, -1, callingPackage, message);
    }

    public static boolean checkCallingOrSelfReadDeviceIdentifiers(Context context, int subId, String callingPackage, String message) {
        return TelephonyPermissions.checkReadDeviceIdentifiers(context, TELEPHONY_SUPPLIER, subId, Binder.getCallingPid(), Binder.getCallingUid(), callingPackage, message);
    }

    public static boolean checkCallingOrSelfReadSubscriberIdentifiers(Context context, int subId, String callingPackage, String message) {
        return TelephonyPermissions.checkReadDeviceIdentifiers(context, TELEPHONY_SUPPLIER, subId, Binder.getCallingPid(), Binder.getCallingUid(), callingPackage, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static boolean checkReadDeviceIdentifiers(Context context, Supplier<ITelephony> telephonySupplier, int subId, int pid, int uid, String callingPackage, String message) {
        int appId = UserHandle.getAppId(uid);
        if (appId == 1000 || appId == 0) {
            return true;
        }
        if (context.checkPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", pid, uid) == 0) {
            return true;
        }
        if (TelephonyPermissions.checkCarrierPrivilegeForAnySubId(context, telephonySupplier, uid)) {
            return true;
        }
        if (callingPackage != null) {
            long token = Binder.clearCallingIdentity();
            AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
            try {
                if (appOpsManager.noteOpNoThrow("android:read_device_identifiers", uid, callingPackage) == 0) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            DevicePolicyManager devicePolicyManager = (DevicePolicyManager)context.getSystemService("device_policy");
            if (devicePolicyManager != null && devicePolicyManager.checkDeviceIdentifierAccess(callingPackage, pid, uid)) {
                return true;
            }
        }
        return TelephonyPermissions.reportAccessDeniedToReadIdentifiers(context, subId, pid, uid, callingPackage, message);
    }

    private static boolean reportAccessDeniedToReadIdentifiers(Context context, int subId, int pid, int uid, String callingPackage, String message) {
        boolean isPreinstalled = false;
        boolean isPrivApp = false;
        ApplicationInfo callingPackageInfo = null;
        try {
            callingPackageInfo = context.getPackageManager().getApplicationInfoAsUser(callingPackage, 0, UserHandle.getUserId(uid));
            if (callingPackageInfo != null && callingPackageInfo.isSystemApp()) {
                isPreinstalled = true;
                if (callingPackageInfo.isPrivilegedApp()) {
                    isPrivApp = true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(LOG_TAG, "Exception caught obtaining package info for package " + callingPackage, e);
        }
        boolean packageReported = sReportedDeviceIDPackages.containsKey(callingPackage);
        if (!packageReported || !sReportedDeviceIDPackages.get(callingPackage).contains(message)) {
            Set<Object> invokedMethods;
            if (!packageReported) {
                invokedMethods = new HashSet();
                sReportedDeviceIDPackages.put(callingPackage, invokedMethods);
            } else {
                invokedMethods = sReportedDeviceIDPackages.get(callingPackage);
            }
            invokedMethods.add(message);
            StatsLog.write(172, callingPackage, message, isPreinstalled, isPrivApp);
        }
        Log.w(LOG_TAG, "reportAccessDeniedToReadIdentifiers:" + callingPackage + ":" + message + ":isPreinstalled=" + isPreinstalled + ":isPrivApp=" + isPrivApp);
        if (callingPackageInfo != null && callingPackageInfo.targetSdkVersion < 29) {
            if (context.checkPermission("android.permission.READ_PHONE_STATE", pid, uid) == 0) {
                return false;
            }
            if (TelephonyPermissions.checkCarrierPrivilegeForSubId(subId)) {
                return false;
            }
        }
        throw new SecurityException(message + ": The user " + uid + " does not meet the requirements to access device identifiers.");
    }

    public static boolean checkReadCallLog(Context context, int subId, int pid, int uid, String callingPackage) {
        return TelephonyPermissions.checkReadCallLog(context, TELEPHONY_SUPPLIER, subId, pid, uid, callingPackage);
    }

    @VisibleForTesting
    public static boolean checkReadCallLog(Context context, Supplier<ITelephony> telephonySupplier, int subId, int pid, int uid, String callingPackage) {
        if (context.checkPermission("android.permission.READ_CALL_LOG", pid, uid) != 0) {
            if (SubscriptionManager.isValidSubscriptionId(subId)) {
                TelephonyPermissions.enforceCarrierPrivilege(telephonySupplier, subId, uid, "readCallLog");
                return true;
            }
            return false;
        }
        AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
        return appOps.noteOp(6, uid, callingPackage) == 0;
    }

    public static boolean checkCallingOrSelfReadPhoneNumber(Context context, int subId, String callingPackage, String message) {
        return TelephonyPermissions.checkReadPhoneNumber(context, TELEPHONY_SUPPLIER, subId, Binder.getCallingPid(), Binder.getCallingUid(), callingPackage, message);
    }

    @VisibleForTesting
    public static boolean checkReadPhoneNumber(Context context, Supplier<ITelephony> telephonySupplier, int subId, int pid, int uid, String callingPackage, String message) {
        AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
        if (appOps.noteOp(15, uid, callingPackage) == 0) {
            return true;
        }
        try {
            return TelephonyPermissions.checkReadPhoneState(context, telephonySupplier, subId, pid, uid, callingPackage, message);
        }
        catch (SecurityException securityException) {
            try {
                context.enforcePermission("android.permission.READ_SMS", pid, uid, message);
                int opCode = AppOpsManager.permissionToOpCode("android.permission.READ_SMS");
                if (opCode != -1) {
                    return appOps.noteOp(opCode, uid, callingPackage) == 0;
                }
                return true;
            }
            catch (SecurityException opCode) {
                try {
                    context.enforcePermission("android.permission.READ_PHONE_NUMBERS", pid, uid, message);
                    int opCode2 = AppOpsManager.permissionToOpCode("android.permission.READ_PHONE_NUMBERS");
                    if (opCode2 != -1) {
                        return appOps.noteOp(opCode2, uid, callingPackage) == 0;
                    }
                    return true;
                }
                catch (SecurityException securityException2) {
                    throw new SecurityException(message + ": Neither user " + uid + " nor current process has " + "android.permission.READ_PHONE_STATE" + ", " + "android.permission.READ_SMS" + ", or " + "android.permission.READ_PHONE_NUMBERS");
                }
            }
        }
    }

    public static void enforceCallingOrSelfModifyPermissionOrCarrierPrivilege(Context context, int subId, String message) {
        if (context.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") == 0) {
            return;
        }
        TelephonyPermissions.enforceCallingOrSelfCarrierPrivilege(subId, message);
    }

    public static void enforeceCallingOrSelfReadPhoneStatePermissionOrCarrierPrivilege(Context context, int subId, String message) {
        if (context.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
            return;
        }
        TelephonyPermissions.enforceCallingOrSelfCarrierPrivilege(subId, message);
    }

    public static void enforeceCallingOrSelfReadPrivilegedPhoneStatePermissionOrCarrierPrivilege(Context context, int subId, String message) {
        if (context.checkCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE") == 0) {
            return;
        }
        TelephonyPermissions.enforceCallingOrSelfCarrierPrivilege(subId, message);
    }

    public static void enforceCallingOrSelfCarrierPrivilege(int subId, String message) {
        TelephonyPermissions.enforceCarrierPrivilege(subId, Binder.getCallingUid(), message);
    }

    private static void enforceCarrierPrivilege(int subId, int uid, String message) {
        TelephonyPermissions.enforceCarrierPrivilege(TELEPHONY_SUPPLIER, subId, uid, message);
    }

    private static void enforceCarrierPrivilege(Supplier<ITelephony> telephonySupplier, int subId, int uid, String message) {
        if (TelephonyPermissions.getCarrierPrivilegeStatus(telephonySupplier, subId, uid) != 1) {
            throw new SecurityException(message);
        }
    }

    private static boolean checkCarrierPrivilegeForAnySubId(Context context, Supplier<ITelephony> telephonySupplier, int uid) {
        SubscriptionManager sm = (SubscriptionManager)context.getSystemService("telephony_subscription_service");
        int[] activeSubIds = sm.getActiveSubscriptionIdList();
        if (activeSubIds != null) {
            for (int activeSubId : activeSubIds) {
                if (TelephonyPermissions.getCarrierPrivilegeStatus(telephonySupplier, activeSubId, uid) != 1) continue;
                return true;
            }
        }
        return false;
    }

    private static int getCarrierPrivilegeStatus(Supplier<ITelephony> telephonySupplier, int subId, int uid) {
        ITelephony telephony = telephonySupplier.get();
        try {
            if (telephony != null) {
                return telephony.getCarrierPrivilegeStatusForUid(subId, uid);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        Rlog.e(LOG_TAG, "Phone process is down, cannot check carrier privileges");
        return 0;
    }

    public static void enforceShellOnly(int callingUid, String message) {
        if (callingUid == 2000 || callingUid == 0) {
            return;
        }
        throw new SecurityException(message + ": Only shell user can call it");
    }
}

