/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Message;
import android.os.PowerManager;
import android.telephony.Rlog;
import com.android.internal.telephony.Phone;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class WakeLockStateMachine
extends StateMachine {
    protected static final boolean DBG = true;
    private final PowerManager.WakeLock mWakeLock;
    public static final int EVENT_NEW_SMS_MESSAGE = 1;
    protected static final int EVENT_BROADCAST_COMPLETE = 2;
    static final int EVENT_RELEASE_WAKE_LOCK = 3;
    @UnsupportedAppUsage
    protected Phone mPhone;
    @UnsupportedAppUsage
    protected Context mContext;
    protected AtomicInteger mReceiverCount = new AtomicInteger(0);
    private static final int WAKE_LOCK_TIMEOUT = 3000;
    private final DefaultState mDefaultState = new DefaultState();
    @UnsupportedAppUsage
    private final IdleState mIdleState = new IdleState();
    private final WaitingState mWaitingState = new WaitingState();
    protected final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (WakeLockStateMachine.this.mReceiverCount.decrementAndGet() == 0) {
                WakeLockStateMachine.this.sendMessage(2);
            }
        }
    };

    protected WakeLockStateMachine(String debugTag, Context context, Phone phone) {
        super(debugTag);
        this.mContext = context;
        this.mPhone = phone;
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, debugTag);
        this.mWakeLock.acquire();
        this.addState(this.mDefaultState);
        this.addState(this.mIdleState, this.mDefaultState);
        this.addState(this.mWaitingState, this.mDefaultState);
        this.setInitialState(this.mIdleState);
    }

    public final void dispose() {
        this.quit();
    }

    @Override
    protected void onQuitting() {
        while (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
    }

    public final void dispatchSmsMessage(Object obj) {
        this.sendMessage(1, obj);
    }

    protected abstract boolean handleSmsMessage(Message var1);

    @Override
    @UnsupportedAppUsage
    protected void log(String s) {
        Rlog.d(this.getName(), s);
    }

    @Override
    protected void loge(String s) {
        Rlog.e(this.getName(), s);
    }

    @Override
    protected void loge(String s, Throwable e) {
        Rlog.e(this.getName(), s, e);
    }

    class WaitingState
    extends State {
        WaitingState() {
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    WakeLockStateMachine.this.log("deferring message until return to idle");
                    WakeLockStateMachine.this.deferMessage(msg);
                    return true;
                }
                case 2: {
                    WakeLockStateMachine.this.log("broadcast complete, returning to idle");
                    WakeLockStateMachine.this.transitionTo(WakeLockStateMachine.this.mIdleState);
                    return true;
                }
                case 3: {
                    WakeLockStateMachine.this.mWakeLock.release();
                    if (!WakeLockStateMachine.this.mWakeLock.isHeld()) {
                        WakeLockStateMachine.this.loge("mWakeLock released while still in WaitingState!");
                    }
                    return true;
                }
            }
            return false;
        }
    }

    class IdleState
    extends State {
        IdleState() {
        }

        @Override
        public void enter() {
            WakeLockStateMachine.this.sendMessageDelayed(3, 3000L);
        }

        @Override
        public void exit() {
            WakeLockStateMachine.this.mWakeLock.acquire();
            WakeLockStateMachine.this.log("acquired wakelock, leaving Idle state");
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (WakeLockStateMachine.this.handleSmsMessage(msg)) {
                        WakeLockStateMachine.this.transitionTo(WakeLockStateMachine.this.mWaitingState);
                    }
                    return true;
                }
                case 3: {
                    WakeLockStateMachine.this.mWakeLock.release();
                    if (WakeLockStateMachine.this.mWakeLock.isHeld()) {
                        WakeLockStateMachine.this.log("mWakeLock is still held after release");
                    } else {
                        WakeLockStateMachine.this.log("mWakeLock released");
                    }
                    return true;
                }
            }
            return false;
        }
    }

    class DefaultState
    extends State {
        DefaultState() {
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                default: 
            }
            String errorText = "processMessage: unhandled message type " + msg.what;
            if (Build.IS_DEBUGGABLE) {
                throw new RuntimeException(errorText);
            }
            WakeLockStateMachine.this.loge(errorText);
            return true;
        }
    }
}

