/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.telephony.cat.AppInterface;
import com.android.internal.telephony.cat.BIPClientParams;
import com.android.internal.telephony.cat.CallSetupParams;
import com.android.internal.telephony.cat.CommandDetails;
import com.android.internal.telephony.cat.CommandParams;
import com.android.internal.telephony.cat.DisplayTextParams;
import com.android.internal.telephony.cat.GetInputParams;
import com.android.internal.telephony.cat.Input;
import com.android.internal.telephony.cat.LaunchBrowserMode;
import com.android.internal.telephony.cat.LaunchBrowserParams;
import com.android.internal.telephony.cat.Menu;
import com.android.internal.telephony.cat.PlayToneParams;
import com.android.internal.telephony.cat.SelectItemParams;
import com.android.internal.telephony.cat.SetEventListParams;
import com.android.internal.telephony.cat.TextMessage;
import com.android.internal.telephony.cat.ToneSettings;

public class CatCmdMessage
implements Parcelable {
    @UnsupportedAppUsage
    CommandDetails mCmdDet;
    @UnsupportedAppUsage
    private TextMessage mTextMsg;
    @UnsupportedAppUsage
    private Menu mMenu;
    @UnsupportedAppUsage
    private Input mInput;
    private BrowserSettings mBrowserSettings = null;
    private ToneSettings mToneSettings = null;
    @UnsupportedAppUsage
    private CallSettings mCallSettings = null;
    private SetupEventListSettings mSetupEventListSettings = null;
    private boolean mLoadIconFailed = false;
    public static final Parcelable.Creator<CatCmdMessage> CREATOR = new Parcelable.Creator<CatCmdMessage>(){

        @Override
        public CatCmdMessage createFromParcel(Parcel in) {
            return new CatCmdMessage(in);
        }

        public CatCmdMessage[] newArray(int size) {
            return new CatCmdMessage[size];
        }
    };

    CatCmdMessage(CommandParams cmdParams) {
        this.mCmdDet = cmdParams.mCmdDet;
        this.mLoadIconFailed = cmdParams.mLoadIconFailed;
        switch (this.getCmdType()) {
            case SET_UP_MENU: 
            case SELECT_ITEM: {
                this.mMenu = ((SelectItemParams)cmdParams).mMenu;
                break;
            }
            case DISPLAY_TEXT: 
            case SET_UP_IDLE_MODE_TEXT: 
            case SEND_DTMF: 
            case SEND_SMS: 
            case REFRESH: 
            case RUN_AT: 
            case SEND_SS: 
            case SEND_USSD: {
                this.mTextMsg = ((DisplayTextParams)cmdParams).mTextMsg;
                break;
            }
            case GET_INPUT: 
            case GET_INKEY: {
                this.mInput = ((GetInputParams)cmdParams).mInput;
                break;
            }
            case LAUNCH_BROWSER: {
                this.mTextMsg = ((LaunchBrowserParams)cmdParams).mConfirmMsg;
                this.mBrowserSettings = new BrowserSettings();
                this.mBrowserSettings.url = ((LaunchBrowserParams)cmdParams).mUrl;
                this.mBrowserSettings.mode = ((LaunchBrowserParams)cmdParams).mMode;
                break;
            }
            case PLAY_TONE: {
                PlayToneParams params = (PlayToneParams)cmdParams;
                this.mToneSettings = params.mSettings;
                this.mTextMsg = params.mTextMsg;
                break;
            }
            case GET_CHANNEL_STATUS: {
                this.mTextMsg = ((CallSetupParams)cmdParams).mConfirmMsg;
                break;
            }
            case SET_UP_CALL: {
                this.mCallSettings = new CallSettings();
                this.mCallSettings.confirmMsg = ((CallSetupParams)cmdParams).mConfirmMsg;
                this.mCallSettings.callMsg = ((CallSetupParams)cmdParams).mCallMsg;
                break;
            }
            case OPEN_CHANNEL: 
            case CLOSE_CHANNEL: 
            case RECEIVE_DATA: 
            case SEND_DATA: {
                BIPClientParams param = (BIPClientParams)cmdParams;
                this.mTextMsg = param.mTextMsg;
                break;
            }
            case SET_UP_EVENT_LIST: {
                this.mSetupEventListSettings = new SetupEventListSettings();
                this.mSetupEventListSettings.eventList = ((SetEventListParams)cmdParams).mEventInfo;
                break;
            }
        }
    }

    public CatCmdMessage(Parcel in) {
        this.mCmdDet = (CommandDetails)in.readParcelable(null);
        this.mTextMsg = (TextMessage)in.readParcelable(null);
        this.mMenu = (Menu)in.readParcelable(null);
        this.mInput = (Input)in.readParcelable(null);
        this.mLoadIconFailed = in.readByte() == 1;
        switch (this.getCmdType()) {
            case LAUNCH_BROWSER: {
                this.mBrowserSettings = new BrowserSettings();
                this.mBrowserSettings.url = in.readString();
                this.mBrowserSettings.mode = LaunchBrowserMode.values()[in.readInt()];
                break;
            }
            case PLAY_TONE: {
                this.mToneSettings = (ToneSettings)in.readParcelable(null);
                break;
            }
            case SET_UP_CALL: {
                this.mCallSettings = new CallSettings();
                this.mCallSettings.confirmMsg = (TextMessage)in.readParcelable(null);
                this.mCallSettings.callMsg = (TextMessage)in.readParcelable(null);
                break;
            }
            case SET_UP_EVENT_LIST: {
                this.mSetupEventListSettings = new SetupEventListSettings();
                int length = in.readInt();
                this.mSetupEventListSettings.eventList = new int[length];
                for (int i = 0; i < length; ++i) {
                    this.mSetupEventListSettings.eventList[i] = in.readInt();
                }
                break;
            }
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mCmdDet, 0);
        dest.writeParcelable(this.mTextMsg, 0);
        dest.writeParcelable(this.mMenu, 0);
        dest.writeParcelable(this.mInput, 0);
        dest.writeByte((byte)(this.mLoadIconFailed ? 1 : 0));
        switch (this.getCmdType()) {
            case LAUNCH_BROWSER: {
                dest.writeString(this.mBrowserSettings.url);
                dest.writeInt(this.mBrowserSettings.mode.ordinal());
                break;
            }
            case PLAY_TONE: {
                dest.writeParcelable(this.mToneSettings, 0);
                break;
            }
            case SET_UP_CALL: {
                dest.writeParcelable(this.mCallSettings.confirmMsg, 0);
                dest.writeParcelable(this.mCallSettings.callMsg, 0);
                break;
            }
            case SET_UP_EVENT_LIST: {
                dest.writeIntArray(this.mSetupEventListSettings.eventList);
                break;
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @UnsupportedAppUsage
    public AppInterface.CommandType getCmdType() {
        return AppInterface.CommandType.fromInt(this.mCmdDet.typeOfCommand);
    }

    public Menu getMenu() {
        return this.mMenu;
    }

    public Input geInput() {
        return this.mInput;
    }

    @UnsupportedAppUsage
    public TextMessage geTextMessage() {
        return this.mTextMsg;
    }

    public BrowserSettings getBrowserSettings() {
        return this.mBrowserSettings;
    }

    public ToneSettings getToneSettings() {
        return this.mToneSettings;
    }

    @UnsupportedAppUsage
    public CallSettings getCallSettings() {
        return this.mCallSettings;
    }

    @UnsupportedAppUsage
    public SetupEventListSettings getSetEventList() {
        return this.mSetupEventListSettings;
    }

    @UnsupportedAppUsage
    public boolean hasIconLoadFailed() {
        return this.mLoadIconFailed;
    }

    public final class BrowserTerminationCauses {
        public static final int USER_TERMINATION = 0;
        public static final int ERROR_TERMINATION = 1;
    }

    public final class SetupEventListConstants {
        public static final int USER_ACTIVITY_EVENT = 4;
        public static final int IDLE_SCREEN_AVAILABLE_EVENT = 5;
        public static final int LANGUAGE_SELECTION_EVENT = 7;
        public static final int BROWSER_TERMINATION_EVENT = 8;
        public static final int BROWSING_STATUS_EVENT = 15;
    }

    public class SetupEventListSettings {
        @UnsupportedAppUsage
        public int[] eventList;
    }

    public class CallSettings {
        @UnsupportedAppUsage
        public TextMessage confirmMsg;
        @UnsupportedAppUsage
        public TextMessage callMsg;
    }

    public class BrowserSettings {
        public String url;
        public LaunchBrowserMode mode;
    }
}

