/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.annotation.UnsupportedAppUsage;
import android.telephony.Rlog;
import com.android.internal.telephony.cat.CatLog;
import com.android.internal.telephony.cat.ResultCode;
import com.android.internal.telephony.cat.ResultException;
import java.util.ArrayList;
import java.util.List;

public class ComprehensionTlv {
    private static final String LOG_TAG = "ComprehensionTlv";
    private int mTag;
    private boolean mCr;
    private int mLength;
    private int mValueIndex;
    private byte[] mRawValue;

    protected ComprehensionTlv(int tag, boolean cr, int length, byte[] data, int valueIndex) {
        this.mTag = tag;
        this.mCr = cr;
        this.mLength = length;
        this.mValueIndex = valueIndex;
        this.mRawValue = data;
    }

    @UnsupportedAppUsage
    public int getTag() {
        return this.mTag;
    }

    public boolean isComprehensionRequired() {
        return this.mCr;
    }

    @UnsupportedAppUsage
    public int getLength() {
        return this.mLength;
    }

    @UnsupportedAppUsage
    public int getValueIndex() {
        return this.mValueIndex;
    }

    @UnsupportedAppUsage
    public byte[] getRawValue() {
        return this.mRawValue;
    }

    public static List<ComprehensionTlv> decodeMany(byte[] data, int startIndex) throws ResultException {
        ArrayList<ComprehensionTlv> items = new ArrayList<ComprehensionTlv>();
        int endIndex = data.length;
        while (startIndex < endIndex) {
            ComprehensionTlv ctlv = ComprehensionTlv.decode(data, startIndex);
            if (ctlv != null) {
                items.add(ctlv);
                startIndex = ctlv.mValueIndex + ctlv.mLength;
                continue;
            }
            CatLog.d(LOG_TAG, "decodeMany: ctlv is null, stop decoding");
            break;
        }
        return items;
    }

    public static ComprehensionTlv decode(byte[] data, int startIndex) throws ResultException {
        int curIndex = startIndex;
        int endIndex = data.length;
        try {
            int length;
            boolean cr;
            int tag;
            int temp = data[curIndex++] & 0xFF;
            switch (temp) {
                case 0: 
                case 128: 
                case 255: {
                    Rlog.d("CAT     ", "decode: unexpected first tag byte=" + Integer.toHexString(temp) + ", startIndex=" + startIndex + " curIndex=" + curIndex + " endIndex=" + endIndex);
                    return null;
                }
                case 127: {
                    tag = (data[curIndex] & 0xFF) << 8 | data[curIndex + 1] & 0xFF;
                    cr = (tag & 0x8000) != 0;
                    tag &= 0xFFFF7FFF;
                    curIndex += 2;
                    break;
                }
                default: {
                    tag = temp;
                    cr = (tag & 0x80) != 0;
                    tag &= 0xFFFFFF7F;
                }
            }
            temp = data[curIndex++] & 0xFF;
            if (temp < 128) {
                length = temp;
            } else if (temp == 129) {
                if ((length = data[curIndex++] & 0xFF) < 128) {
                    throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD, "length < 0x80 length=" + Integer.toHexString(length) + " startIndex=" + startIndex + " curIndex=" + curIndex + " endIndex=" + endIndex);
                }
            } else if (temp == 130) {
                length = (data[curIndex] & 0xFF) << 8 | data[curIndex + 1] & 0xFF;
                curIndex += 2;
                if (length < 256) {
                    throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD, "two byte length < 0x100 length=" + Integer.toHexString(length) + " startIndex=" + startIndex + " curIndex=" + curIndex + " endIndex=" + endIndex);
                }
            } else if (temp == 131) {
                length = (data[curIndex] & 0xFF) << 16 | (data[curIndex + 1] & 0xFF) << 8 | data[curIndex + 2] & 0xFF;
                curIndex += 3;
                if (length < 65536) {
                    throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD, "three byte length < 0x10000 length=0x" + Integer.toHexString(length) + " startIndex=" + startIndex + " curIndex=" + curIndex + " endIndex=" + endIndex);
                }
            } else {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD, "Bad length modifer=" + temp + " startIndex=" + startIndex + " curIndex=" + curIndex + " endIndex=" + endIndex);
            }
            return new ComprehensionTlv(tag, cr, length, data, curIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD, "IndexOutOfBoundsException startIndex=" + startIndex + " curIndex=" + curIndex + " endIndex=" + endIndex);
        }
    }
}

