/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import com.android.internal.telephony.EncodeException;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.cat.ComprehensionTlvTag;
import com.android.internal.telephony.cat.ResponseData;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

class GetInkeyInputResponseData
extends ResponseData {
    private boolean mIsUcs2;
    private boolean mIsPacked;
    private boolean mIsYesNo;
    private boolean mYesNoResponse;
    public String mInData;
    protected static final byte GET_INKEY_YES = 1;
    protected static final byte GET_INKEY_NO = 0;

    public GetInkeyInputResponseData(String inData, boolean ucs2, boolean packed) {
        this.mIsUcs2 = ucs2;
        this.mIsPacked = packed;
        this.mInData = inData;
        this.mIsYesNo = false;
    }

    public GetInkeyInputResponseData(boolean yesNoResponse) {
        this.mIsUcs2 = false;
        this.mIsPacked = false;
        this.mInData = "";
        this.mIsYesNo = true;
        this.mYesNoResponse = yesNoResponse;
    }

    @Override
    public void format(ByteArrayOutputStream buf) {
        byte[] data;
        block17: {
            if (buf == null) {
                return;
            }
            int tag = 0x80 | ComprehensionTlvTag.TEXT_STRING.value();
            buf.write(tag);
            if (this.mIsYesNo) {
                data = new byte[]{this.mYesNoResponse ? (byte)1 : 0};
            } else if (this.mInData != null && this.mInData.length() > 0) {
                try {
                    if (this.mIsUcs2) {
                        data = this.mInData.getBytes("UTF-16BE");
                        break block17;
                    }
                    if (this.mIsPacked) {
                        byte[] tempData = GsmAlphabet.stringToGsm7BitPacked(this.mInData, 0, 0);
                        data = new byte[tempData.length - 1];
                        System.arraycopy(tempData, 1, data, 0, tempData.length - 1);
                        break block17;
                    }
                    data = GsmAlphabet.stringToGsm8BitPacked(this.mInData);
                }
                catch (UnsupportedEncodingException e) {
                    data = new byte[]{};
                }
                catch (EncodeException e) {
                    data = new byte[]{};
                }
            } else {
                data = new byte[]{};
            }
        }
        if (data.length + 1 <= 255) {
            GetInkeyInputResponseData.writeLength(buf, data.length + 1);
        } else {
            data = new byte[]{};
        }
        if (this.mIsUcs2) {
            buf.write(8);
        } else if (this.mIsPacked) {
            buf.write(0);
        } else {
            buf.write(4);
        }
        for (byte b : data) {
            buf.write(b);
        }
    }
}

