/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.annotation.UnsupportedAppUsage;
import android.os.Handler;
import android.os.Message;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.cat.BerTlv;
import com.android.internal.telephony.cat.CatLog;
import com.android.internal.telephony.cat.CommandParams;
import com.android.internal.telephony.cat.CommandParamsFactory;
import com.android.internal.telephony.cat.ResultCode;
import com.android.internal.telephony.cat.ResultException;
import com.android.internal.telephony.cat.RilMessage;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;

class RilMessageDecoder
extends StateMachine {
    private static final int CMD_START = 1;
    private static final int CMD_PARAMS_READY = 2;
    @UnsupportedAppUsage
    private CommandParamsFactory mCmdParamsFactory = null;
    private RilMessage mCurrentRilMessage = null;
    private Handler mCaller = null;
    private static int mSimCount = 0;
    @UnsupportedAppUsage
    private static RilMessageDecoder[] mInstance = null;
    @UnsupportedAppUsage
    private StateStart mStateStart = new StateStart();
    private StateCmdParamsReady mStateCmdParamsReady = new StateCmdParamsReady();

    @UnsupportedAppUsage
    public static synchronized RilMessageDecoder getInstance(Handler caller, IccFileHandler fh, int slotId) {
        if (null == mInstance) {
            mSimCount = TelephonyManager.getDefault().getSimCount();
            mInstance = new RilMessageDecoder[mSimCount];
            for (int i = 0; i < mSimCount; ++i) {
                RilMessageDecoder.mInstance[i] = null;
            }
        }
        if (slotId != -1 && slotId < mSimCount) {
            if (null == mInstance[slotId]) {
                RilMessageDecoder.mInstance[slotId] = new RilMessageDecoder(caller, fh);
            }
        } else {
            CatLog.d("RilMessageDecoder", "invaild slot id: " + slotId);
            return null;
        }
        return mInstance[slotId];
    }

    public void sendStartDecodingMessageParams(RilMessage rilMsg) {
        Message msg = this.obtainMessage(1);
        msg.obj = rilMsg;
        this.sendMessage(msg);
    }

    public void sendMsgParamsDecoded(ResultCode resCode, CommandParams cmdParams) {
        Message msg = this.obtainMessage(2);
        msg.arg1 = resCode.value();
        msg.obj = cmdParams;
        this.sendMessage(msg);
    }

    private void sendCmdForExecution(RilMessage rilMsg) {
        Message msg = this.mCaller.obtainMessage(10, new RilMessage(rilMsg));
        msg.sendToTarget();
    }

    private RilMessageDecoder(Handler caller, IccFileHandler fh) {
        super("RilMessageDecoder");
        this.addState(this.mStateStart);
        this.addState(this.mStateCmdParamsReady);
        this.setInitialState(this.mStateStart);
        this.mCaller = caller;
        this.mCmdParamsFactory = CommandParamsFactory.getInstance(this, fh);
    }

    private RilMessageDecoder() {
        super("RilMessageDecoder");
    }

    private boolean decodeMessageParams(RilMessage rilMsg) {
        boolean decodingStarted;
        this.mCurrentRilMessage = rilMsg;
        switch (rilMsg.mId) {
            case 1: 
            case 4: {
                this.mCurrentRilMessage.mResCode = ResultCode.OK;
                this.sendCmdForExecution(this.mCurrentRilMessage);
                decodingStarted = false;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                byte[] rawData = null;
                try {
                    rawData = IccUtils.hexStringToBytes((String)rilMsg.mData);
                }
                catch (Exception e) {
                    CatLog.d(this, "decodeMessageParams dropping zombie messages");
                    decodingStarted = false;
                    break;
                }
                try {
                    this.mCmdParamsFactory.make(BerTlv.decode(rawData));
                    decodingStarted = true;
                }
                catch (ResultException e) {
                    CatLog.d(this, "decodeMessageParams: caught ResultException e=" + e);
                    this.mCurrentRilMessage.mResCode = e.result();
                    this.sendCmdForExecution(this.mCurrentRilMessage);
                    decodingStarted = false;
                }
                break;
            }
            default: {
                decodingStarted = false;
            }
        }
        return decodingStarted;
    }

    public void dispose() {
        this.quitNow();
        this.mStateStart = null;
        this.mStateCmdParamsReady = null;
        this.mCmdParamsFactory.dispose();
        this.mCmdParamsFactory = null;
        this.mCurrentRilMessage = null;
        this.mCaller = null;
        mInstance = null;
    }

    private class StateCmdParamsReady
    extends State {
        private StateCmdParamsReady() {
        }

        @Override
        public boolean processMessage(Message msg) {
            if (msg.what == 2) {
                ((RilMessageDecoder)RilMessageDecoder.this).mCurrentRilMessage.mResCode = ResultCode.fromInt(msg.arg1);
                ((RilMessageDecoder)RilMessageDecoder.this).mCurrentRilMessage.mData = msg.obj;
                RilMessageDecoder.this.sendCmdForExecution(RilMessageDecoder.this.mCurrentRilMessage);
                RilMessageDecoder.this.transitionTo(RilMessageDecoder.this.mStateStart);
            } else {
                CatLog.d(this, "StateCmdParamsReady expecting CMD_PARAMS_READY=2 got " + msg.what);
                RilMessageDecoder.this.deferMessage(msg);
            }
            return true;
        }
    }

    private class StateStart
    extends State {
        private StateStart() {
        }

        @Override
        public boolean processMessage(Message msg) {
            if (msg.what == 1) {
                if (RilMessageDecoder.this.decodeMessageParams((RilMessage)msg.obj)) {
                    RilMessageDecoder.this.transitionTo(RilMessageDecoder.this.mStateCmdParamsReady);
                }
            } else {
                CatLog.d(this, "StateStart unexpected expecting START=1 got " + msg.what);
            }
            return true;
        }
    }
}

